/*
 * generated by Xtext
 */
package org.sqlproc.model.validation

import org.eclipse.xtext.validation.Check
import org.sqlproc.model.processorModel.PojoDefinitionModel
import org.sqlproc.model.processorModel.ProcessorModelPackage
import org.sqlproc.model.processorModel.Artifacts
import com.google.inject.Inject
import org.sqlproc.plugin.lib.resolver.DbResolver
import org.sqlproc.plugin.lib.property.ModelProperty
import org.eclipse.emf.ecore.EObject
import static extension org.eclipse.xtext.EcoreUtil2.*
import static extension org.eclipse.emf.ecore.util.EcoreUtil.*
import org.sqlproc.model.processorModel.FunctionDefinitionModel
import org.sqlproc.model.processorModel.ProcedureDefinitionModel
import org.sqlproc.model.processorModel.TableDefinitionModel
import org.sqlproc.model.processorModel.Property
import org.sqlproc.model.processorModel.PojoEntity
import org.sqlproc.model.processorModel.Package
import org.sqlproc.model.processorModel.AbstractEntity
import org.sqlproc.model.processorModel.AnnotatedEntity
import org.sqlproc.model.processorModel.DaoEntity
import org.sqlproc.model.processorModel.Entity
import org.sqlproc.plugin.lib.util.CommonUtils
import org.sqlproc.model.processorModel.AnnotationDefinitionModel
import org.sqlproc.model.processorModel.Feature

/**
 * Custom validation rules. 
 *
 * see http://www.eclipse.org/Xtext/documentation.html#validation
 */
class ProcessorModelValidator extends AbstractProcessorModelValidator {

    @Inject
    DbResolver dbResolver

    @Inject
    ModelProperty modelProperty

    @Check
    def checkUniquePojoDefinition(PojoDefinitionModel pojoDefinition) {
    	if (CommonUtils.skipVerification(pojoDefinition, modelProperty))
            return;
    	
        val artifacts = getArtifacts(pojoDefinition)
        if (artifacts == null)
            return;
        for (PojoDefinitionModel definition : artifacts.pojos) {
            if (definition != null && definition !== pojoDefinition && pojoDefinition.name == definition.name) {
                error("Duplicate name : " + pojoDefinition.name, ProcessorModelPackage.Literals.POJO_DEFINITION_MODEL__NAME)
                return
            }
        }
    }
    
    @Check
    def checkUniqueAnnotationDefinition(AnnotationDefinitionModel annotationDefinition) {
        if (CommonUtils.skipVerification(annotationDefinition, modelProperty))
            return;
        val artifacts = getArtifacts(annotationDefinition)
        if (artifacts == null)
            return;
            
        for (AnnotationDefinitionModel definition : artifacts.annotations) {
            if (definition != null && definition !== annotationDefinition && annotationDefinition.name == definition.name) {
                error("Duplicate name : " + annotationDefinition.name, ProcessorModelPackage.Literals.ANNOTATION_DEFINITION_MODEL__NAME)
                return
            }
        }
    }
    
    @Check
    def checkUniqueProperty(Property property) {
        if (CommonUtils.skipVerification(property, modelProperty))
            return;
        val artifacts = getArtifacts(property)
        if (artifacts == null)
            return;

        for (Property prop : artifacts.properties) {
            if (prop != null && prop !== property && prop.name == property.name) {
	            if (!prop.name.startsWith("pojogen") && !prop.name.startsWith("database") && !prop.name.startsWith("metagen")
	                && !prop.name.startsWith("daogen") && !prop.name.startsWith("replace-text")) {
	                error("Duplicate name : " + property.name, ProcessorModelPackage.Literals.PROPERTY__NAME)
	                return
	            }
            }
        }
    }

    @Check
    def checkTableDefinition(TableDefinitionModel tableDefinition) {
        if (CommonUtils.skipVerification(tableDefinition, modelProperty))
            return;
        val artifacts = getArtifacts(tableDefinition)
        if (artifacts == null)
            return;

        for (TableDefinitionModel table : artifacts.tables) {
            if (table != null && table !== tableDefinition && tableDefinition.name ==table.name) {
                error("Duplicate name : " + tableDefinition.name + "[table]", ProcessorModelPackage.Literals.TABLE_DEFINITION_MODEL__NAME)
                return
           }
        }
        if (isResolveDb(tableDefinition) && !dbResolver.checkTable(tableDefinition, tableDefinition.table)) {
            error("Cannot find table in DB : " + tableDefinition.table, ProcessorModelPackage.Literals.TABLE_DEFINITION_MODEL__TABLE)
        }
    }

    @Check
    def checkProcedureDefinition(ProcedureDefinitionModel procedureDefinition) {
        if (CommonUtils.skipVerification(procedureDefinition, modelProperty))
            return;
        val artifacts = getArtifacts(procedureDefinition)
        if (artifacts == null)
            return;

        for (ProcedureDefinitionModel procedure : artifacts.procedures) {
            if (procedure != null && procedure !== procedureDefinition && procedureDefinition.name == procedure.name) {
                error("Duplicate name : " + procedureDefinition.name + "[procedure]", ProcessorModelPackage.Literals.PROCEDURE_DEFINITION_MODEL__NAME)
                return
	        }
        }
        if (isResolveDb(procedureDefinition) && !dbResolver.checkProcedure(procedureDefinition, procedureDefinition.table)) {
            error("Cannot find procedure in DB : " + procedureDefinition.table, ProcessorModelPackage.Literals.PROCEDURE_DEFINITION_MODEL__NAME)
        }
    }

    @Check
    def checkFunctionDefinition(FunctionDefinitionModel functionDefinition) {
        if (CommonUtils.skipVerification(functionDefinition, modelProperty))
            return;
        val artifacts = getArtifacts(functionDefinition)
        if (artifacts == null)
            return;

        for (FunctionDefinitionModel function : artifacts.functions) {
            if (function != null && function !== functionDefinition && functionDefinition.name == function.name) {
                error("Duplicate name : " + functionDefinition.name + "[function]", ProcessorModelPackage.Literals.FUNCTION_DEFINITION_MODEL__NAME)
                return
	    	}
        }
    }
    
    @Check
    def checkUniquePojoEntity(Entity entity) {
        if (CommonUtils.skipVerification(entity, modelProperty))
            return;
        val artifacts = getArtifacts(entity)
        if (artifacts == null)
            return;

        for (Package pkg : artifacts.packages) {
            if (pkg != null) {
	            for (AbstractEntity abstractEntity : pkg.elements) {
	                if (abstractEntity != null && (abstractEntity instanceof AnnotatedEntity)) {
		                val annotatedEntity = abstractEntity as AnnotatedEntity
		                if (annotatedEntity.entity != null) {
	                		val _entity = annotatedEntity.entity as Entity
		                	if (_entity != null && _entity !== entity && entity.name == _entity.name) {
			                    error("Duplicate name : " + entity.name, ProcessorModelPackage.Literals.ENTITY__NAME)
			                    return
			                }
		                }
					}
	            }
            }
        }
    }

    @Check
    def checkUniquePojoAttribute(Feature feature) {
        if (CommonUtils.skipVerification(feature, modelProperty))
            return;
            
        val entity = feature.getContainerOfType(typeof(Entity))
        if (entity != null) {
        	if (entity instanceof PojoEntity) {
        		val pentity = entity as PojoEntity
		        for (Feature _feature : pentity.features.map[feature]) {
		            if (_feature != null && _feature !== feature && feature.name == _feature.name) {
		                error("Duplicate name : " + feature.name, ProcessorModelPackage.Literals.FEATURE__NAME)
		                return
		            }
		        }
        	} else if (entity instanceof DaoEntity) {
        		val pentity = entity as DaoEntity
		        for (Feature _feature : pentity.features.map[feature]) {
		            if (_feature != null && _feature !== feature && feature.name == _feature.name) {
		                error("Duplicate name : " + feature.name, ProcessorModelPackage.Literals.FEATURE__NAME)
		                return
		            }
		        }
	        }
        }
    }
    
    def isResolveDb(EObject model) {
        return dbResolver.isResolveDb(model)
    }
    
    def Artifacts getArtifacts(EObject model) {
        val root = model.rootContainer
        if (!(root instanceof Artifacts))
            return null;
        return root as Artifacts
    }
}
