/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.plugin.lib.generator;

import com.google.common.base.CaseFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.sqlproc.plugin.lib.property.ColumnAnnotations;
import org.sqlproc.plugin.lib.property.EnumAttribute;
import org.sqlproc.plugin.lib.property.FunctionDefinition;
import org.sqlproc.plugin.lib.property.ImplementsExtends;
import org.sqlproc.plugin.lib.property.ModelProperty;
import org.sqlproc.plugin.lib.property.PojoAnnotations;
import org.sqlproc.plugin.lib.property.PojoAttrType;
import org.sqlproc.plugin.lib.property.PojoAttribute;
import org.sqlproc.plugin.lib.property.PojoDefinition;
import org.sqlproc.plugin.lib.property.PojoEntityType;
import org.sqlproc.plugin.lib.property.ProcedureDefinition;
import org.sqlproc.plugin.lib.property.TableDefinition;
import org.sqlproc.plugin.lib.resolver.DbCheckConstraint;
import org.sqlproc.plugin.lib.resolver.DbColumn;
import org.sqlproc.plugin.lib.resolver.DbExport;
import org.sqlproc.plugin.lib.resolver.DbImport;
import org.sqlproc.plugin.lib.resolver.DbIndex;
import org.sqlproc.plugin.lib.resolver.DbResolver;
import org.sqlproc.plugin.lib.resolver.DbTable;
import org.sqlproc.plugin.lib.util.CommonUtils;
import org.sqlproc.plugin.lib.util.Debug;
import org.sqlproc.plugin.lib.util.Stats;

public class TableBaseGenerator {
    protected Logger LOGGER = Logger.getLogger(TableBaseGenerator.class);
    protected Debug debug = new Debug(this.LOGGER);
    protected static String INDENT = "    ";
    protected static String NL = "\n";
    protected static String NLINDENT = NL + INDENT;
    protected static String NLINDENTINDENT = NL + INDENT + INDENT;
    protected static final String METHOD_TO_STRING = "toString";
    protected static final String METHOD_HASH_CODE = "hashCode";
    protected static final String METHOD_EQUALS = "equals";
    protected static final String METHOD_IS_DEF = "isDef";
    protected static final String ENUM_IS_DEF = "enumDef";
    protected static final String METHOD_TO_INIT = "toInit";
    protected static final String METHOD_INDEX = "index";
    protected static final String METHOD_ENUM_TO_INIT = "enumInit";
    protected static final String METHOD_PROC_ID = "procId";
    protected static final String METHOD_ENUM_INDEX = "enumIndex";
    protected static final String COLLECTION_LIST = "java.util.List";
    protected static final String ANNOTATION_NOT_NULL = "javax.validation.constraints.NotNull";
    protected static final String ANNOTATION_SIZE = "javax.validation.constraints.Size";
    protected EObject model;
    protected boolean doCompressMetaDirectives;
    protected boolean doGenerateFromTo;
    protected String caseFormatLibrary;
    protected Map<String, PojoAttrType> sqlTypes = new HashMap<String, PojoAttrType>();
    protected Map<String, Map<String, PojoAttrType>> tableTypes = new HashMap<String, Map<String, PojoAttrType>>();
    protected Map<String, Map<String, PojoAttrType>> columnTypes = new HashMap<String, Map<String, PojoAttrType>>();
    protected Map<String, Map<String, PojoAttrType>> functionTypes = new HashMap<String, Map<String, PojoAttrType>>();
    protected Map<String, Map<String, PojoAttrType>> procedureTypes = new HashMap<String, Map<String, PojoAttrType>>();
    protected Map<String, String> tableNames = new HashMap<String, String>();
    protected Map<String, Map<String, String>> columnNames = new HashMap<String, Map<String, String>>();
    protected Set<String> ignoreTables = new HashSet<String>();
    protected Set<String> onlyTables = new HashSet<String>();
    protected Set<String> notAbstractTables = new HashSet<String>();
    protected Set<String> createTables = new HashSet<String>();
    protected Map<String, Set<String>> ignoreColumns = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> requiredColumns = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> notRequiredColumns = new HashMap<String, Set<String>>();
    protected Map<String, Map<String, PojoAttrType>> createColumns = new HashMap<String, Map<String, PojoAttrType>>();
    protected Map<String, Map<String, Map<String, Set<String>>>> ignoreExports = new HashMap<String, Map<String, Map<String, Set<String>>>>();
    protected Map<String, Map<String, Map<String, String>>> ignoreImports = new HashMap<String, Map<String, Map<String, String>>>();
    protected Map<String, Map<String, Map<String, String>>> createExports = new HashMap<String, Map<String, Map<String, String>>>();
    protected Map<String, Map<String, Map<String, String>>> createImports = new HashMap<String, Map<String, Map<String, String>>>();
    protected Map<String, Map<String, Map<String, String>>> create121Imports = new HashMap<String, Map<String, Map<String, String>>>();
    protected Map<String, Map<String, Map<String, String>>> inheritImports = new HashMap<String, Map<String, Map<String, String>>>();
    protected Map<String, Map<String, Map<String, String>>> manyToManyImports = new HashMap<String, Map<String, Map<String, String>>>();
    protected Map<String, Map<String, Map<String, List<String>>>> inheritance = new HashMap<String, Map<String, Map<String, List<String>>>>();
    protected Map<String, String> inheritanceColumns = new HashMap<String, String>();
    protected Set<String> generateMethods = new HashSet<String>();
    protected Map<String, ImplementsExtends> toImplements = new TreeMap<String, ImplementsExtends>();
    protected ImplementsExtends toExtends = null;
    protected Map<String, List<String>> joinTables = new HashMap<String, List<String>>();
    protected boolean doGenerateWrappers;
    protected boolean doGenerateValidationAnnotations;
    protected boolean makeItFinal;
    protected String versionColumn;
    protected Map<String, Set<String>> versionColumns = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> notVersionColumns = new HashMap<String, Set<String>>();
    protected String generateOperators = null;
    protected Set<String> preserveForeignKeys = new HashSet<String>();
    protected Map<String, PojoEntityType> pojosForProcedures = new HashMap<String, PojoEntityType>();
    protected Map<String, PojoEntityType> pojosForFunctions = new HashMap<String, PojoEntityType>();
    protected Filter activeFilter = null;
    protected Map<String, String> enumForCheckConstraints = new HashMap<String, String>();
    protected Map<String, ColumnAnnotations> columnAnnotations = new TreeMap<String, ColumnAnnotations>();
    protected Map<String, ColumnAnnotations> columnAnnotations2 = new TreeMap<String, ColumnAnnotations>();
    protected PojoAnnotations pojoAnnotations = null;
    protected boolean oldDateTime = false;
    protected Set<String> tables = new HashSet<String>();
    protected Map<String, Map<String, PojoAttribute>> pojos = new TreeMap<String, Map<String, PojoAttribute>>();
    protected Map<String, Map<String, PojoAttribute>> procedures = new TreeMap<String, Map<String, PojoAttribute>>();
    protected Map<String, Map<String, PojoAttribute>> functions = new TreeMap<String, Map<String, PojoAttribute>>();
    protected Map<String, String> pojoExtends = new HashMap<String, String>();
    protected Map<String, Set<String>> pojoInheritanceDiscriminator = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> pojoInheritanceSimple = new HashMap<String, Set<String>>();
    protected Map<String, String> pojoDiscriminators = new HashMap<String, String>();
    protected Map<String, List<Map<PojoAttribute, Boolean>>> indexes = new TreeMap<String, List<Map<PojoAttribute, Boolean>>>();
    protected Set<String> dbSequences = new TreeSet<String>();
    protected DbResolver.DbType dbType = null;
    protected Map<String, List<EnumAttribute>> enums = new TreeMap<String, List<EnumAttribute>>();
    protected Map<String, String> enumsTables = new HashMap<String, String>();
    protected Map<String, String> comments = new HashMap<String, String>();
    protected String pojoPackage;
    protected Map<String, String> metaFunctionsResult = new HashMap<String, String>();
    protected Map<String, String> metaProceduresResult = new HashMap<String, String>();
    protected Map<String, String> metaFunctionsResultSet = new HashMap<String, String>();
    protected Map<String, String> metaProceduresResultSet = new HashMap<String, String>();
    protected Map<String, TableDefinition> modelTables = new TreeMap<String, TableDefinition>();
    protected Map<String, PojoDefinition> modelAnnotations = new TreeMap<String, PojoDefinition>();
    protected Map<String, ProcedureDefinition> modelProcedures = new TreeMap<String, ProcedureDefinition>();
    protected Map<String, FunctionDefinition> modelFunctions = new TreeMap<String, FunctionDefinition>();
    protected Map<String, TableDefinition> modelTablesInv = new TreeMap<String, TableDefinition>();
    protected Map<String, ProcedureDefinition> modelProceduresInv = new TreeMap<String, ProcedureDefinition>();
    protected Map<String, FunctionDefinition> modelFunctionsInv = new TreeMap<String, FunctionDefinition>();
    public static final String FAKE_FUN_PROC_COLUMN_NAME = "_result_";
    public static final String FUN_PROC_COLUMN_NAME = "RESULT";
    protected static final String LIBRARY_GUAVA = "GUAVA";
    protected static Map<String, String> metaType2classNameMap = new LinkedHashMap<String, String>();
    protected static Map<String, String> className2metaTypeMap;

    static {
        metaType2classNameMap.put("localdatetime", LocalDateTime.class.getName());
        metaType2classNameMap.put("localdate", LocalDate.class.getName());
        metaType2classNameMap.put("localtime", LocalTime.class.getName());
        metaType2classNameMap.put("instant", Instant.class.getName());
        metaType2classNameMap.put("stamp", Timestamp.class.getName());
        metaType2classNameMap.put("timestamp", Timestamp.class.getName());
        metaType2classNameMap.put("date", Date.class.getName());
        metaType2classNameMap.put("datetime", java.util.Date.class.getName());
        metaType2classNameMap.put("time", Time.class.getName());
        metaType2classNameMap.put("byte", Byte.class.getName());
        metaType2classNameMap.put("boolean", Boolean.class.getName());
        metaType2classNameMap.put("bool", Boolean.class.getName());
        metaType2classNameMap.put("character", Character.class.getName());
        metaType2classNameMap.put("char", Character.class.getName());
        metaType2classNameMap.put("short", Short.class.getName());
        metaType2classNameMap.put("int", Integer.class.getName());
        metaType2classNameMap.put("integer", Integer.class.getName());
        metaType2classNameMap.put("long", Long.class.getName());
        metaType2classNameMap.put("string", String.class.getName());
        metaType2classNameMap.put("str", String.class.getName());
        metaType2classNameMap.put("text", String.class.getName());
        metaType2classNameMap.put("double", Double.class.getName());
        metaType2classNameMap.put("float", Float.class.getName());
        metaType2classNameMap.put("bigint", BigInteger.class.getName());
        metaType2classNameMap.put("biginteger", BigInteger.class.getName());
        metaType2classNameMap.put("bigdec", BigDecimal.class.getName());
        metaType2classNameMap.put("bigdecimal", BigDecimal.class.getName());
        metaType2classNameMap.put("blob", Blob.class.getName());
        metaType2classNameMap.put("clob", Clob.class.getName());
        metaType2classNameMap.put("bytes", Byte[].class.getName());
        metaType2classNameMap.put("bytearr", Byte[].class.getName());
        metaType2classNameMap.put("bytearray", Byte[].class.getName());
        className2metaTypeMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : metaType2classNameMap.entrySet()) {
            String value = entry.getValue();
            if (className2metaTypeMap.containsKey(value)) continue;
            className2metaTypeMap.put(value, entry.getKey());
            if (!value.startsWith("java.lang.")) continue;
            className2metaTypeMap.put(value.substring(10), entry.getKey());
        }
    }

    public TableBaseGenerator(ModelProperty modelProperty, EObject model, List<String> dbSequences, DbResolver.DbType dbType) {
        Map<String, FunctionDefinition> modelFunctions;
        Map<String, ProcedureDefinition> modelProcedures;
        Map<String, TableDefinition> modelTables;
        Map<String, PojoDefinition> modelAnnotations;
        Map<String, String> metaProceduresResultSet;
        Map<String, String> metaFunctionsResultSet;
        Map<String, ColumnAnnotations> columnAnnotations;
        Map<String, PojoEntityType> pojosForProcedures;
        Set<String> preserveForeignKeys;
        Map<String, Set<String>> notVersionColumns;
        Set<String> generateMethods;
        Map<String, String> inheritanceColumns;
        Map<String, Map<String, Map<String, List<String>>>> inheritance;
        Map<String, Map<String, Map<String, String>>> manyToManyImports;
        Map<String, Map<String, Map<String, String>>> inheritImports;
        Map<String, Map<String, Map<String, String>>> create121Imports;
        Map<String, Map<String, Map<String, String>>> createImports;
        Map<String, Map<String, Map<String, String>>> createExports;
        Map<String, Map<String, Map<String, String>>> ignoreImports;
        Map<String, Map<String, Map<String, Set<String>>>> ignoreExports;
        Map<String, Map<String, PojoAttrType>> createColumns;
        Map<String, Set<String>> notRequiredColumns;
        Map<String, Set<String>> requiredColumns;
        Map<String, Set<String>> ignoreColumns;
        Set<String> createTables;
        Set<String> onlyTables;
        Set<String> ignoreTables;
        Map<String, Map<String, String>> columnNames;
        Map<String, String> tableNames;
        Map<String, Map<String, PojoAttrType>> functionTypes;
        Map<String, Map<String, PojoAttrType>> procedureTypes;
        Map<String, Map<String, PojoAttrType>> columnTypes;
        Map<String, Map<String, PojoAttrType>> tableTypes;
        this.model = model;
        this.debug = new Debug(modelProperty.getDebugLevel(model), modelProperty.getDebugScope(model), this.LOGGER);
        this.doCompressMetaDirectives = modelProperty.isCompressMetaDirectives(model);
        this.doGenerateFromTo = modelProperty.isGenerateFromTo(model);
        this.caseFormatLibrary = modelProperty.getCaseFormatLibrary(model);
        Map<String, PojoAttrType> sqlTypes = modelProperty.getSqlTypes(model);
        if (sqlTypes != null) {
            this.sqlTypes.putAll(sqlTypes);
            for (Map.Entry<String, PojoAttrType> e : sqlTypes.entrySet()) {
                this.sqlTypes.put(e.getKey().toLowerCase(), e.getValue());
                this.sqlTypes.put(e.getKey().toUpperCase(), e.getValue());
            }
        }
        if ((tableTypes = modelProperty.getTableTypes(model)) != null) {
            this.tableTypes.putAll(tableTypes);
        }
        if ((columnTypes = modelProperty.getColumnTypes(model)) != null) {
            this.columnTypes.putAll(columnTypes);
        }
        if ((procedureTypes = modelProperty.getProcedureTypes(model)) != null) {
            this.procedureTypes.putAll(procedureTypes);
        }
        if ((functionTypes = modelProperty.getFunctionTypes(model)) != null) {
            this.functionTypes.putAll(functionTypes);
        }
        if ((tableNames = modelProperty.getTableNames(model)) != null) {
            this.tableNames.putAll(tableNames);
        }
        if ((columnNames = modelProperty.getColumnNames(model)) != null) {
            this.columnNames.putAll(columnNames);
        }
        if ((ignoreTables = modelProperty.getIgnoreTables(model)) != null) {
            this.ignoreTables.addAll(ignoreTables);
        }
        if ((onlyTables = modelProperty.getOnlyTables(model)) != null) {
            this.onlyTables.addAll(onlyTables);
        }
        Set<String> notAbstractTables = modelProperty.getNotAbstractTables(model);
        if (onlyTables != null) {
            this.notAbstractTables.addAll(notAbstractTables);
        }
        if ((createTables = modelProperty.getCreateTables(model)) != null) {
            this.createTables.addAll(createTables);
        }
        if ((ignoreColumns = modelProperty.getIgnoreColumns(model)) != null) {
            this.ignoreColumns.putAll(ignoreColumns);
        }
        if ((requiredColumns = modelProperty.getRequiredColumns(model)) != null) {
            this.requiredColumns.putAll(requiredColumns);
        }
        if ((notRequiredColumns = modelProperty.getNotRequiredColumns(model)) != null) {
            this.notRequiredColumns.putAll(notRequiredColumns);
        }
        if ((createColumns = modelProperty.getCreateColumns(model)) != null) {
            this.createColumns.putAll(createColumns);
        }
        if ((ignoreExports = modelProperty.getIgnoreExports(model)) != null) {
            this.ignoreExports.putAll(ignoreExports);
        }
        if ((ignoreImports = modelProperty.getIgnoreImports(model)) != null) {
            this.ignoreImports.putAll(ignoreImports);
        }
        if ((createExports = modelProperty.getCreateExports(model)) != null) {
            this.createExports.putAll(createExports);
        }
        if ((createImports = modelProperty.getCreateImports(model)) != null) {
            this.createImports.putAll(createImports);
        }
        if ((create121Imports = modelProperty.getCreate121Imports(model)) != null) {
            this.create121Imports.putAll(create121Imports);
        }
        if ((inheritImports = modelProperty.getInheritImports(model)) != null) {
            this.inheritImports.putAll(inheritImports);
        }
        if ((manyToManyImports = modelProperty.getManyToManyImports(model)) != null) {
            this.manyToManyImports.putAll(manyToManyImports);
        }
        if ((inheritance = modelProperty.getInheritance(model)) != null) {
            this.inheritance.putAll(inheritance);
        }
        if ((inheritanceColumns = modelProperty.getInheritanceColumns(model)) != null) {
            this.inheritanceColumns.putAll(inheritanceColumns);
        }
        if ((generateMethods = modelProperty.getGenerateMethods(model)) != null) {
            this.generateMethods.addAll(generateMethods);
        }
        this.generateOperators = modelProperty.getGenerateOperators(model);
        Map<String, ImplementsExtends> toImplements = modelProperty.getToImplements(model);
        if (toImplements != null) {
            this.toImplements.putAll(toImplements);
        }
        this.toExtends = modelProperty.getToExtends(model);
        Map<String, List<String>> joinTables = modelProperty.getJoinTables(model);
        if (joinTables != null) {
            this.joinTables.putAll(joinTables);
        }
        this.doGenerateWrappers = modelProperty.isDoGenerateWrappers(model);
        this.doGenerateValidationAnnotations = modelProperty.isDoGenerateValidationAnnotations(model);
        this.makeItFinal = modelProperty.isMakeItFinal(model);
        this.versionColumn = modelProperty.getVersionColumn(model);
        Map<String, Set<String>> versionColumns = modelProperty.getVersionColumns(model);
        if (versionColumns != null) {
            this.versionColumns.putAll(versionColumns);
        }
        if ((notVersionColumns = modelProperty.getNotVersionColumns(model)) != null) {
            this.notVersionColumns.putAll(notVersionColumns);
        }
        if ((preserveForeignKeys = modelProperty.getPreserveForeignKeys(model)) != null) {
            this.preserveForeignKeys.addAll(preserveForeignKeys);
        }
        if ((pojosForProcedures = modelProperty.getPojosForProcedures(model)) != null) {
            this.pojosForProcedures.putAll(pojosForProcedures);
        }
        Map<String, PojoEntityType> pojosForFunctions = modelProperty.getPojosForFunctions(model);
        if (pojosForProcedures != null) {
            this.pojosForFunctions.putAll(pojosForFunctions);
        }
        this.activeFilter = Filter.parse(modelProperty.getActiveFilter(model));
        Map<String, String> enumForCheckConstraints = modelProperty.getEnumForCheckConstraints(model);
        if (enumForCheckConstraints != null) {
            this.enumForCheckConstraints.putAll(enumForCheckConstraints);
        }
        if ((columnAnnotations = modelProperty.getColumnAnnotations(model)) != null) {
            this.columnAnnotations.putAll(columnAnnotations);
            for (Map.Entry<String, ColumnAnnotations> entry : columnAnnotations.entrySet()) {
                this.columnAnnotations2.put(this.columnToCamelCase(entry.getKey()), entry.getValue());
            }
        }
        this.pojoAnnotations = modelProperty.getPojoAnnotations(model);
        this.pojoPackage = modelProperty.getPackage(model);
        this.oldDateTime = modelProperty.isOldDateTime(model);
        for (Map.Entry<String, Object> entry : this.inheritImports.entrySet()) {
            for (Map.Entry inherit : ((Map)entry.getValue()).entrySet()) {
                for (Map.Entry tabcol : ((Map)inherit.getValue()).entrySet()) {
                    if (!this.ignoreExports.containsKey(tabcol.getKey())) {
                        this.ignoreExports.put((String)tabcol.getKey(), new HashMap());
                    }
                    if (!this.ignoreExports.get(tabcol.getKey()).containsKey(tabcol.getValue())) {
                        this.ignoreExports.get(tabcol.getKey()).put((String)tabcol.getValue(), new HashMap());
                    }
                    this.ignoreExports.get(tabcol.getKey()).get(tabcol.getValue()).put(entry.getKey(), null);
                    if (!this.ignoreColumns.containsKey(entry.getKey())) {
                        this.ignoreColumns.put(entry.getKey(), new HashSet());
                    }
                    this.ignoreColumns.get(entry.getKey()).add((String)inherit.getKey());
                }
            }
        }
        this.dbSequences.addAll(dbSequences);
        this.dbType = dbType;
        Map<String, String> map = modelProperty.getMetaFunctionsResult(model);
        if (map != null) {
            this.metaFunctionsResult.putAll(map);
        }
        if ((metaFunctionsResultSet = modelProperty.getMetaFunctionsResultSet(model)) != null) {
            this.metaFunctionsResultSet.putAll(metaFunctionsResultSet);
        }
        if ((metaProceduresResultSet = modelProperty.getMetaProceduresResultSet(model)) != null) {
            this.metaProceduresResultSet.putAll(metaProceduresResultSet);
        }
        if ((modelAnnotations = modelProperty.getModelAnnotations(model)) != null) {
            this.modelAnnotations.putAll(modelAnnotations);
        }
        if ((modelTables = modelProperty.getModelTables(model)) != null) {
            this.modelTables.putAll(modelTables);
            for (TableDefinition def : modelTables.values()) {
                this.modelTablesInv.put(def.getTable(), def);
            }
        }
        if ((modelProcedures = modelProperty.getModelProcedures(model)) != null) {
            this.modelProcedures.putAll(modelProcedures);
            for (ProcedureDefinition def : modelProcedures.values()) {
                this.modelProceduresInv.put(def.getProcedure(), def);
            }
        }
        if ((modelFunctions = modelProperty.getModelFunctions(model)) != null) {
            this.modelFunctions.putAll(modelFunctions);
            for (FunctionDefinition def : modelFunctions.values()) {
                this.modelFunctionsInv.put(def.getFunction(), def);
            }
        }
        this.debug.debug("doCompressMetaDirectives " + this.doCompressMetaDirectives);
        this.debug.debug("sqlTypes " + String.valueOf(this.sqlTypes));
        this.debug.debug("tableTypes " + String.valueOf(this.tableTypes));
        this.debug.debug("columnTypes " + String.valueOf(this.columnTypes));
        this.debug.debug("procedureTypes " + String.valueOf(this.procedureTypes));
        this.debug.debug("functionTypes " + String.valueOf(this.functionTypes));
        this.debug.debug("tableNames " + String.valueOf(this.tableNames));
        this.debug.debug("columnNames " + String.valueOf(this.columnNames));
        this.debug.debug("ignoreTables " + String.valueOf(this.ignoreTables));
        this.debug.debug("onlyTables " + String.valueOf(this.onlyTables));
        this.debug.debug("notAbstractTables " + String.valueOf(this.notAbstractTables));
        this.debug.debug("createTables " + String.valueOf(this.createTables));
        this.debug.debug("ignoreColumns " + String.valueOf(this.ignoreColumns));
        this.debug.debug("createColumns " + String.valueOf(this.createColumns));
        this.debug.debug("ignoreExports " + String.valueOf(this.ignoreExports));
        this.debug.debug("ignoreImports " + String.valueOf(this.ignoreImports));
        this.debug.debug("createExports " + String.valueOf(this.createExports));
        this.debug.debug("createImports " + String.valueOf(this.createImports));
        this.debug.debug("create121Imports " + String.valueOf(this.create121Imports));
        this.debug.debug("inheritImports " + String.valueOf(this.inheritImports));
        this.debug.debug("manyToManyImports " + String.valueOf(this.manyToManyImports));
        this.debug.debug("inheritance " + String.valueOf(this.inheritance));
        this.debug.debug("inheritanceColumns " + String.valueOf(this.inheritanceColumns));
        this.debug.debug("generateMethods " + String.valueOf(this.generateMethods));
        this.debug.debug("generateOperators " + this.generateOperators);
        this.debug.debug("toImplements " + String.valueOf(this.toImplements));
        this.debug.debug("toExtends " + String.valueOf(this.toExtends));
        this.debug.debug("joinTables " + String.valueOf(this.joinTables));
        this.debug.debug("doGenerateWrappers " + this.doGenerateWrappers);
        this.debug.debug("doGenerateValidationAnnotations " + this.doGenerateValidationAnnotations);
        this.debug.debug("makeItFinal " + this.makeItFinal);
        this.debug.debug("sequences " + String.valueOf(this.dbSequences));
        this.debug.debug("dbType " + String.valueOf((Object)this.dbType));
        this.debug.debug("metaFunctionsResult " + String.valueOf(this.metaFunctionsResult));
        this.debug.debug("metaFunctionsResultSet " + String.valueOf(this.metaFunctionsResultSet));
        this.debug.debug("metaProceduresResultSet " + String.valueOf(this.metaProceduresResultSet));
        this.debug.debug("preserveForeignKeys " + String.valueOf(this.preserveForeignKeys));
        this.debug.debug("pojosForProcedures " + String.valueOf(this.pojosForProcedures));
        this.debug.debug("pojosForFunctions " + String.valueOf(this.pojosForFunctions));
        this.debug.debug("versionColumn " + this.versionColumn);
        this.debug.debug("versionColumns " + String.valueOf(this.versionColumns));
        this.debug.debug("notVersionColumns " + String.valueOf(this.notVersionColumns));
        this.debug.debug("activeFilter " + String.valueOf(this.activeFilter));
        this.debug.debug("columnAnnotations " + String.valueOf(this.columnAnnotations));
        this.debug.debug("columnAnnotations2 " + String.valueOf(this.columnAnnotations2));
        this.debug.debug("pojoAnnotations " + String.valueOf(this.pojoAnnotations));
        this.debug.debug("enumForCheckConstraints " + String.valueOf(this.enumForCheckConstraints));
        this.debug.debug("modelAnnotations " + String.valueOf(this.modelAnnotations));
        this.debug.debug("modelTables " + String.valueOf(this.modelTables));
        this.debug.debug("modelProcedures " + String.valueOf(this.modelProcedures));
        this.debug.debug("modelFunctions " + String.valueOf(this.modelFunctions));
        this.debug.debug("oldDateTime " + this.oldDateTime);
        for (String table : createTables) {
            this.addTableDefinition(table, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null);
            this.tables.remove(table);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addTableDefinition(String table, List<DbColumn> dbColumns, List<String> dbPrimaryKeys, List<DbExport> dbExports, List<DbImport> dbImports, List<DbIndex> dbIndexes, List<DbCheckConstraint> dbCheckConstraints, String comment) {
        void var10_45;
        void var10_43;
        Iterator<Map.Entry<String, List<String>>> attribute;
        this.debug.debug("addTableDefinition: " + table + " dbColumns " + String.valueOf(dbColumns));
        this.debug.debug("addTableDefinition: " + table + " dbPrimaryKeys " + String.valueOf(dbPrimaryKeys));
        this.debug.debug("addTableDefinition: " + table + " dbExports " + String.valueOf(dbExports));
        this.debug.debug("addTableDefinition: " + table + " dbImports " + String.valueOf(dbImports));
        this.debug.debug("addTableDefinition: " + table + " dbIndexes " + String.valueOf(dbIndexes));
        this.debug.debug("addTableDefinition: " + table + " dbCheckConstraints " + String.valueOf(dbCheckConstraints));
        if (table == null || dbColumns == null) {
            return;
        }
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        for (DbColumn dbColumn : dbColumns) {
            void var12_46;
            PojoAttribute pojoAttribute = this.convertDbColumnDefinition(table, dbColumn, this.columnTypes);
            if (pojoAttribute != null) {
                attributes.put(dbColumn.getName(), pojoAttribute);
            } else {
                PojoAttribute pojoAttribute2 = this.convertDbColumnDefault(table, dbColumn);
                if (pojoAttribute2 != null) {
                    attributes.put(dbColumn.getName(), pojoAttribute2);
                }
            }
            if (dbPrimaryKeys.contains(dbColumn.getName())) {
                var12_46.setPrimaryKey(true);
            }
            if (this.versionColumn != null && this.versionColumn.equals(dbColumn.getName())) {
                var12_46.setVersion(true);
                continue;
            }
            if (this.versionColumns.containsKey(dbColumn.getName()) && this.versionColumns.get(dbColumn.getName()).contains(table)) {
                var12_46.setVersion(true);
                continue;
            }
            if (!this.notVersionColumns.containsKey(dbColumn.getName()) || this.notVersionColumns.get(dbColumn.getName()).contains(table)) continue;
            var12_46.setVersion(true);
        }
        if (this.createColumns.containsKey(table)) {
            for (Map.Entry<String, PojoAttrType> entry : this.createColumns.get(table).entrySet()) {
                PojoAttribute pojoAttribute = this.convertDbColumnDefinition(entry.getKey(), entry.getValue());
                attributes.put(entry.getKey(), pojoAttribute);
            }
        }
        this.pojos.put(table, attributes);
        this.tables.add(table);
        if (comment != null) {
            this.comments.put(table, comment);
        }
        if (this.create121Imports.containsKey(table)) {
            for (Map.Entry<String, Map<String, String>> entry : this.create121Imports.get(table).entrySet()) {
                for (Map.Entry<String, String> entry2 : entry.getValue().entrySet()) {
                    PojoAttribute attribute3 = this.convertDbColumnDefinition(entry2.getKey(), (PojoAttribute)attributes.get(entry.getKey()));
                    attribute3.setPkTable(entry2.getKey());
                    attribute3.setPkColumn(entry2.getValue());
                    attributes.put(entry2.getKey(), attribute3);
                }
            }
        }
        for (DbImport dbImport : dbImports) {
            if (this.ignoreImports.containsKey(table) && (this.ignoreImports.get(table) == null || this.ignoreImports.get(table).containsKey(dbImport.getFkColumn()) && this.ignoreImports.get(table).get(dbImport.getFkColumn()).containsKey(dbImport.getPkTable()))) continue;
            if (this.manyToManyImports.containsKey(table)) {
                PojoAttribute pojoAttribute = (PojoAttribute)attributes.get(dbImport.getFkColumn());
                pojoAttribute.setM2mTable(dbImport.getPkTable());
                pojoAttribute.setPkColumn(dbImport.getPkColumn());
                continue;
            }
            if (this.inheritImports.containsKey(table) && this.inheritImports.get(table).containsKey(dbImport.getFkColumn()) && this.inheritImports.get(table).get(dbImport.getFkColumn()).containsKey(dbImport.getPkTable())) {
                PojoAttribute pojoAttribute = (PojoAttribute)attributes.get(dbImport.getFkColumn());
                pojoAttribute.setParentTable(dbImport.getPkTable());
                pojoAttribute.setPkColumn(dbImport.getPkColumn());
                continue;
            }
            PojoAttribute pojoAttribute = (PojoAttribute)attributes.get(dbImport.getFkColumn());
            pojoAttribute.setPkTable(dbImport.getPkTable());
            pojoAttribute.setPkColumn(dbImport.getPkColumn());
        }
        if (this.createImports.containsKey(table)) {
            for (Map.Entry<String, Map<String, String>> entry : this.createImports.get(table).entrySet()) {
                PojoAttribute pojoAttribute = (PojoAttribute)attributes.get(entry.getKey());
                for (Map.Entry entry3 : entry.getValue().entrySet()) {
                    pojoAttribute.setPkTable((String)entry3.getKey());
                    pojoAttribute.setPkColumn((String)entry3.getValue());
                }
            }
        }
        for (DbExport dbExport : dbExports) {
            Set<String> set;
            if (this.ignoreExports.containsKey(table) && this.ignoreExports.get(table).containsKey(dbExport.getPkColumn()) && this.ignoreExports.get(table).get(dbExport.getPkColumn()).containsKey(dbExport.getFkTable()) && ((set = this.ignoreExports.get(table).get(dbExport.getPkColumn()).get(dbExport.getFkTable())) == null || set.size() == 0 || set.contains(dbExport.getFkColumn()))) continue;
            if (this.manyToManyImports.containsKey(dbExport.getFkTable())) {
                if (!this.manyToManyImports.get(dbExport.getFkTable()).containsKey(dbExport.getPkColumn())) continue;
                for (Map.Entry<String, String> entry : this.manyToManyImports.get(dbExport.getFkTable()).get(dbExport.getPkColumn()).entrySet()) {
                    String fkTable = entry.getKey();
                    String fkColumn = entry.getValue();
                    if (dbExport.getPkTable().equals(fkTable)) continue;
                    attribute = (PojoAttribute)attributes.get(dbExport.getPkColumn());
                    ((PojoAttribute)((Object)attribute)).getFkTables().put(fkTable, fkColumn);
                    ((PojoAttribute)((Object)attribute)).getM2Tables().put(fkTable, dbExport.getFkTable());
                }
                continue;
            }
            PojoAttribute pojoAttribute = (PojoAttribute)attributes.get(dbExport.getPkColumn());
            pojoAttribute.getFkTables().put(dbExport.getFkTable(), null);
            if (!pojoAttribute.getFkColumns().containsKey(dbExport.getFkTable())) {
                pojoAttribute.getFkColumns().put(dbExport.getFkTable(), new ArrayList());
            }
            pojoAttribute.getFkColumns().get(dbExport.getFkTable()).add(dbExport.getFkColumn());
        }
        if (this.createExports.containsKey(table)) {
            for (Map.Entry<String, Map<String, String>> entry : this.createExports.get(table).entrySet()) {
                PojoAttribute pojoAttribute = (PojoAttribute)attributes.get(entry.getKey());
                for (Map.Entry<String, String> entry4 : entry.getValue().entrySet()) {
                    pojoAttribute.getFkTables().put(entry4.getKey(), null);
                    if (!pojoAttribute.getFkColumns().containsKey(entry4.getKey())) {
                        pojoAttribute.getFkColumns().put(entry4.getKey(), new ArrayList());
                    }
                    pojoAttribute.getFkColumns().get(entry4.getKey()).add(entry4.getValue());
                }
            }
        }
        if (this.inheritance.containsKey(table)) {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (Map.Entry<String, Map<String, List<String>>> entry : this.inheritance.get(table).entrySet()) {
                String string = entry.getKey();
                LinkedHashMap<String, PojoAttribute> inheritedAttributes = new LinkedHashMap<String, PojoAttribute>();
                attribute = entry.getValue().entrySet().iterator();
                if (!attribute.hasNext()) continue;
                Map.Entry<String, List<String>> tabcols = attribute.next();
                String inheritedTable = tabcols.getKey();
                for (String dbColumn : tabcols.getValue()) {
                    if (!attributes.containsKey(dbColumn)) continue;
                    inheritedAttributes.put(dbColumn, (PojoAttribute)attributes.get(dbColumn));
                }
                linkedHashMap.putAll(inheritedAttributes);
                this.pojos.put(inheritedTable, inheritedAttributes);
                this.pojoDiscriminators.put(inheritedTable, string);
                this.pojoExtends.put(inheritedTable, table);
            }
            for (String string : linkedHashMap.keySet()) {
                attributes.remove(string);
            }
            this.pojoInheritanceDiscriminator.put(table, new LinkedHashSet());
        }
        boolean bl = false;
        int n = dbIndexes.size();
        while (var10_43 < n) {
            void var13_84;
            DbIndex dbIndex = dbIndexes.get((int)var10_43);
            List<Map<PojoAttribute, Boolean>> list = this.indexes.get(table);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                this.indexes.put(table, arrayList);
            }
            LinkedHashMap<PojoAttribute, Boolean> list2 = new LinkedHashMap<PojoAttribute, Boolean>();
            var13_84.add(list2);
            int ii = 0;
            int ll = dbIndex.getColumns().size();
            while (ii < ll) {
                DbIndex.DbIndexDetail dbIndexDetail = dbIndex.getColumns().get(ii);
                if (dbIndexDetail == null) {
                    this.debug.warn("Missing index in " + String.valueOf(dbIndex));
                } else {
                    PojoAttribute attr = (PojoAttribute)attributes.get(dbIndexDetail.getColname());
                    if (attr == null) {
                        this.debug.warn("Missing attibute for " + String.valueOf(dbIndex));
                    } else {
                        list2.put(attr, dbIndexDetail.isDesc());
                        if (ll == 1) {
                            attr.setIndex((int)(var10_43 + true));
                        }
                    }
                }
                ++ii;
            }
            ++var10_43;
        }
        boolean bl2 = false;
        int n2 = dbCheckConstraints.size();
        while (var10_45 < n2) {
            PojoAttribute pojoAttribute;
            DbCheckConstraint dbCheckConstraint = dbCheckConstraints.get((int)var10_45);
            PojoAttribute pojoAttribute3 = pojoAttribute = this.pojos.containsKey(dbCheckConstraint.getTable()) && this.pojos.get(dbCheckConstraint.getTable()).containsKey(dbCheckConstraint.getColumn()) ? this.pojos.get(dbCheckConstraint.getTable()).get(dbCheckConstraint.getColumn()) : null;
            if (pojoAttribute == null) {
                this.debug.warn("For the constraint " + dbCheckConstraint.getEnumName() + " there's no table or column");
            } else {
                Object name = dbCheckConstraint.getEnumName();
                if (((String)name).startsWith(dbCheckConstraint.getTable()) && this.tableNames.containsKey(dbCheckConstraint.getTable())) {
                    name = this.tableNames.get(dbCheckConstraint.getTable()) + ((String)name).substring(dbCheckConstraint.getTable().length());
                }
                boolean firstCheckConstraint = false;
                if (this.enumForCheckConstraints.containsKey(name)) {
                    String enumName = this.enumForCheckConstraints.get(name);
                    pojoAttribute.setDependencyClassName(enumName);
                    if (this.enumForCheckConstraints.get(enumName).equals(name)) {
                        firstCheckConstraint = true;
                    }
                } else {
                    pojoAttribute.setDependencyClassName(this.tableToCamelCase(this.getTableName((String)name)));
                    pojoAttribute.setDependencyPojo((String)name);
                    firstCheckConstraint = true;
                }
                pojoAttribute.setDependencyClassNameIsEnum(true);
                if (firstCheckConstraint) {
                    ArrayList<EnumAttribute> attrs = new ArrayList<EnumAttribute>();
                    this.enums.put((String)name, attrs);
                    this.enumsTables.put((String)name, dbCheckConstraint.getTable());
                    EnumAttribute pattr = new EnumAttribute();
                    pattr.setName("VALUE");
                    pattr.setClassName(pojoAttribute.getClassName());
                    pattr.setWrapperClassName(pojoAttribute.getWrapperClassName());
                    attrs.add(pattr);
                    for (String val : dbCheckConstraint.getValues()) {
                        EnumAttribute attr = new EnumAttribute();
                        attr.setClassName(pojoAttribute.getClassName());
                        if (pojoAttribute.isString()) {
                            attr.setStrValue(val);
                            if (val.isEmpty()) continue;
                            if (Character.isDigit(val.charAt(0))) {
                                attr.setName("I" + val);
                            } else {
                                attr.setName(val);
                            }
                        } else {
                            attr.setIntValue(val);
                            attr.setName("I" + val);
                        }
                        attrs.add(attr);
                    }
                }
            }
            ++var10_45;
        }
    }

    public void joinTables() {
        for (String table : this.joinTables.keySet()) {
            if (!this.pojos.containsKey(table)) continue;
            Stack<String> stack = new Stack<String>();
            stack.push(table);
            for (String table1 : this.joinTables.get(table)) {
                if (!this.pojos.containsKey(table1)) break;
                stack.push(table1);
            }
            if (stack.size() != this.joinTables.get(table).size() + 1) continue;
            Object table0 = (String)stack.pop();
            HashSet<String> allAttributes = new HashSet<String>();
            allAttributes.addAll(this.pojos.get(table0).keySet());
            if (this.tableNames.containsKey(table0)) {
                table0 = this.tableNames.get(table0);
            }
            while (stack.size() > 0) {
                String table1 = (String)stack.pop();
                String newTable = (this.tableNames.containsKey(table1) ? this.tableNames.get(table1) : table1) + "_" + (String)table0;
                LinkedHashMap<String, PojoAttribute> newAttributes = new LinkedHashMap<String, PojoAttribute>();
                for (Map.Entry<String, PojoAttribute> attr : this.pojos.get(table1).entrySet()) {
                    if (allAttributes.contains(attr.getKey())) continue;
                    newAttributes.put(attr.getKey(), attr.getValue());
                    allAttributes.add(attr.getKey());
                }
                this.pojos.put(newTable, newAttributes);
                this.pojoExtends.put(newTable, (String)table0);
                if (!this.onlyTables.isEmpty()) {
                    this.onlyTables.add(newTable);
                }
                table0 = newTable;
            }
        }
    }

    protected String getTableName(String name) {
        String realName = this.tableNames.get(name);
        return realName != null ? realName : name;
    }

    public void resolveReferencesOnKeys() {
        for (String string : this.pojos.keySet()) {
            TreeMap<String, PojoAttribute> newAttributes = new TreeMap<String, PojoAttribute>();
            for (Map.Entry<String, PojoAttribute> entry : this.pojos.get(string).entrySet()) {
                PojoAttribute attribute = entry.getValue();
                if (attribute.getPkTable() != null && this.pojos.containsKey(attribute.getPkTable())) {
                    attribute.setDependencyClassName(this.tableToCamelCase(this.getTableName(attribute.getPkTable())));
                    attribute.setDependencyPojo(attribute.getPkTable());
                    attribute.setRef(attribute.getPkTable());
                    if (attribute.getName().length() >= 3) {
                        if (attribute.getName().startsWith("id")) {
                            attribute.setName(this.lowerFirstChar(attribute.getName().substring(2)));
                        } else if (attribute.getName().endsWith("Id")) {
                            attribute.setName(attribute.getName().substring(0, attribute.getName().length() - 2));
                        }
                    }
                }
                if (attribute.getParentTable() != null && this.pojos.containsKey(attribute.getParentTable())) {
                    this.pojoExtends.put(string, attribute.getParentTable());
                    this.pojoInheritanceSimple.put(attribute.getParentTable(), new LinkedHashSet());
                }
                for (Map.Entry<String, String> fk : attribute.getFkTables().entrySet()) {
                    if (!this.pojos.containsKey(fk.getKey())) continue;
                    if (attribute.getFkColumns().containsKey(fk.getKey()) && attribute.getFkColumns().get(fk.getKey()).size() > 1) {
                        for (String fkColumn : attribute.getFkColumns().get(fk.getKey())) {
                            PojoAttribute attrib = new PojoAttribute(null);
                            attrib.setName(this.collectionName(fk.getKey(), fkColumn));
                            attrib.setOneToManyColumn(entry.getKey());
                            attrib.setOneToManyOppositeColumn(fkColumn);
                            attrib.setOneToManyTable(fk.getKey());
                            attrib.setClassName("java.util.List <" + this.tableToCamelCase(this.getTableName(fk.getKey())) + ">");
                            attrib.setRef(fk.getKey());
                            String dbColumnName = this.columnToDbConv(attrib.getName());
                            newAttributes.put(dbColumnName, attrib);
                        }
                    }
                    String referName = null;
                    if (fk.getValue() != null) {
                        referName = this.columnToCamelCase(fk.getValue());
                    } else {
                        if (attribute.getFkColumns().containsKey(fk.getKey()) && attribute.getFkColumns().get(fk.getKey()).size() > 1) continue;
                        referName = this.collectionName(fk.getKey(), null);
                    }
                    PojoAttribute attrib = new PojoAttribute(null);
                    attrib.setName(referName);
                    if (attribute.getM2Tables().containsKey(fk.getKey())) {
                        attrib.setManyToManyColumn(entry.getKey());
                        attrib.setManyToManyTable(fk.getKey());
                    } else if (attribute.getFkColumns().containsKey(fk.getKey())) {
                        attrib.setOneToManyColumn(entry.getKey());
                        attrib.setOneToManyOppositeColumn(attribute.getFkColumns().get(fk.getKey()).get(0));
                        attrib.setOneToManyTable(fk.getKey());
                    }
                    attrib.setClassName("java.util.List <" + this.tableToCamelCase(this.getTableName(fk.getKey())) + ">");
                    attrib.setRef(fk.getKey());
                    String dbColumnName = this.columnToDbConv(attrib.getName());
                    newAttributes.put(dbColumnName, attrib);
                }
            }
            if (newAttributes.isEmpty()) continue;
            this.pojos.get(string).putAll(newAttributes);
        }
        for (Map.Entry entry : this.pojoExtends.entrySet()) {
            if (this.pojoInheritanceDiscriminator.containsKey(entry.getValue())) {
                this.pojoInheritanceDiscriminator.get(entry.getValue()).add((String)entry.getKey());
                continue;
            }
            if (!this.pojoInheritanceSimple.containsKey(entry.getValue())) continue;
            this.pojoInheritanceSimple.get(entry.getValue()).add((String)entry.getKey());
        }
    }

    public void addProcedureDefinition(String procedure, DbTable dbProcedure, List<DbColumn> dbProcColumns, boolean isFunction, String comment) {
        PojoAttribute attribute;
        this.debug.debug("addProcedureDefinition: " + procedure + " dbProcedure " + String.valueOf(dbProcedure));
        this.debug.debug("addProcedureDefinition: " + procedure + " dbProcColumns " + String.valueOf(dbProcColumns));
        if (procedure == null || dbProcColumns == null) {
            return;
        }
        LinkedHashMap<String, PojoAttribute> attributes = new LinkedHashMap<String, PojoAttribute>();
        LinkedHashMap<String, PojoAttribute> attributesResultSet = new LinkedHashMap<String, PojoAttribute>();
        int ix = 0;
        for (DbColumn dbColumn : dbProcColumns) {
            String metaType;
            ++ix;
            if ((dbColumn.getColumnType() == 3 || dbColumn.getColumnType() == 5) && (dbColumn.getName() == null || dbColumn.getName().trim().length() == 0 || dbColumn.getName().equalsIgnoreCase("returnValue") || dbColumn.getName().equalsIgnoreCase("RETURN_VALUE") || dbColumn.getName().equalsIgnoreCase("null"))) {
                dbColumn.setName(FAKE_FUN_PROC_COLUMN_NAME);
            }
            if (this.dbType == DbResolver.DbType.INFORMIX && ix == 1 && isFunction && !FAKE_FUN_PROC_COLUMN_NAME.equals(dbColumn.getName())) continue;
            attribute = this.convertDbColumnDefinition(procedure, dbColumn, this.procedureTypes);
            if (attribute == null) {
                attribute = this.convertDbColumnDefault(procedure, dbColumn);
            }
            if (attribute != null) {
                if (!(FAKE_FUN_PROC_COLUMN_NAME.equals(dbColumn.getName()) || dbColumn.getColumnType() != 3 && dbColumn.getColumnType() != 5)) {
                    attributesResultSet.put(dbColumn.getName(), attribute);
                } else {
                    attributes.put(dbColumn.getName(), attribute);
                }
                attribute.setFunProcType(dbProcedure.getFtype());
                attribute.setFunProcColumnType(dbColumn.getColumnType());
            }
            if (FAKE_FUN_PROC_COLUMN_NAME.equals(dbColumn.getName()) && isFunction && attribute.getClassName() != null) {
                metaType = this.className2metaType(attribute.getClassName());
                if (metaType == null) continue;
                this.metaFunctionsResult.put(procedure, metaType);
                continue;
            }
            if (!FAKE_FUN_PROC_COLUMN_NAME.equals(dbColumn.getName()) || attribute.getClassName() == null || dbColumn.getColumnType() != 3 && dbColumn.getColumnType() != 5 || (metaType = this.className2metaType(attribute.getClassName())) == null) continue;
            this.metaProceduresResult.put(procedure, metaType);
        }
        if (!attributesResultSet.isEmpty()) {
            this.debug.warn("TODO " + procedure + " returns " + String.valueOf(attributesResultSet));
            String string = procedure + "_RESULT";
            this.pojos.put(string, attributesResultSet);
            this.metaProceduresResultSet.put(procedure, string);
        }
        if (this.createColumns.containsKey(procedure)) {
            for (Map.Entry entry : this.createColumns.get(procedure).entrySet()) {
                attribute = this.convertDbColumnDefinition((String)entry.getKey(), (PojoAttrType)entry.getValue());
                attributes.put((String)entry.getKey(), attribute);
                attribute.setFunProcType(dbProcedure.getFtype());
                attribute.setFunProcColumnType((short)1);
            }
        }
        this.procedures.put(procedure, attributes);
        if (comment != null) {
            this.comments.put(procedure, comment);
        }
        if ((this.dbType == DbResolver.DbType.POSTGRESQL || this.dbType == DbResolver.DbType.INFORMIX) && isFunction) {
            this.functions.put(procedure, attributes);
        }
    }

    public void addFunctionDefinition(String function, DbTable dbFunction, List<DbColumn> dbFunColumns, String comment) {
        PojoAttribute attribute;
        this.debug.debug("addFunctionDefinition: " + function + " dbFunction " + String.valueOf(dbFunction));
        this.debug.debug("addFunctionDefinition: " + function + " dbFunColumns " + String.valueOf(dbFunColumns));
        if (function == null || dbFunColumns == null) {
            return;
        }
        LinkedHashMap<String, PojoAttribute> attributes = new LinkedHashMap<String, PojoAttribute>();
        for (DbColumn dbColumn : dbFunColumns) {
            attribute = this.convertDbColumnDefinition(function, dbColumn, this.functionTypes);
            if (attribute != null) {
                attributes.put(dbColumn.getName(), attribute);
            } else {
                attribute = this.convertDbColumnDefault(function, dbColumn);
                if (attribute != null) {
                    attributes.put(dbColumn.getName(), attribute);
                }
            }
            if (attribute == null) continue;
            attribute.setFunProcType(dbFunction.getFtype());
            attribute.setFunProcColumnType(dbColumn.getColumnType());
        }
        if (this.createColumns.containsKey(function)) {
            for (Map.Entry entry : this.createColumns.get(function).entrySet()) {
                attribute = this.convertDbColumnDefinition((String)entry.getKey(), (PojoAttrType)entry.getValue());
                attributes.put((String)entry.getKey(), attribute);
                attribute.setFunProcType(dbFunction.getFtype());
                attribute.setFunProcColumnType((short)1);
            }
        }
        if (this.dbType == DbResolver.DbType.DB2 && this.metaFunctionsResult.containsKey(function)) {
            PojoAttribute pojoAttribute = this.convertDbColumnDefinition(FUN_PROC_COLUMN_NAME, this.metaFunctionsResult.get(function));
            attributes.put(FUN_PROC_COLUMN_NAME, pojoAttribute);
            pojoAttribute.setFunProcType(dbFunction.getFtype());
            pojoAttribute.setFunProcColumnType((short)5);
        }
        this.functions.put(function, attributes);
        if (comment != null) {
            this.comments.put(function, comment);
        }
    }

    protected String collectionName(String fkTable, String fkColumn) {
        Object referName;
        if (this.tableNames.containsKey(fkTable)) {
            fkTable = this.tableNames.get(fkTable);
        }
        Object object = referName = fkColumn == null ? this.lowerFirstChar(this.tableToCamelCase(fkTable)) : this.tableToCamelCase(fkTable);
        if (!((String)referName).endsWith("s")) {
            if (((String)referName).endsWith("y")) {
                referName = ((String)referName).substring(0, ((String)referName).length() - 1);
                referName = (String)referName + "ies";
            } else {
                referName = (String)referName + "s";
            }
        }
        if (fkColumn != null) {
            referName = this.lowerFirstChar(this.tableToCamelCase(fkColumn)) + (String)referName;
        }
        return referName;
    }

    protected String lowerFirstChar(String s) {
        if (s == null) {
            return null;
        }
        Object ss = s.substring(0, 1).toLowerCase();
        if (s.length() == 1) {
            return ss;
        }
        ss = (String)ss + s.substring(1);
        return ss;
    }

    public void resolveReferencesOnConvention() {
        for (String pojo : this.pojos.keySet()) {
            for (PojoAttribute attribute : this.pojos.get(pojo).values()) {
                Map<String, PojoAttribute> referPojoAttr;
                String className;
                if (!attribute.getName().startsWith("id") || attribute.getName().length() <= 2 || pojo.equals(className = attribute.getName().substring(2)) || (referPojoAttr = this.pojos.get(className)) == null) continue;
                Object name = className.substring(0, 1).toLowerCase();
                if (className.length() > 1) {
                    name = (String)name + className.substring(1);
                }
                attribute.setName((String)name);
                attribute.setPrimitive(false);
                attribute.setDependencyClassName(className);
                Object referName = pojo.substring(0, 1).toLowerCase();
                if (className.length() > 1) {
                    referName = (String)referName + pojo.substring(1);
                }
                PojoAttribute attrib = new PojoAttribute(null);
                attrib.setName((String)referName + "s");
                attrib.setClassName("java.util.List <" + pojo + ">");
                referPojoAttr.put(attrib.getName(), attrib);
            }
        }
    }

    protected String nlindent() {
        return this.doCompressMetaDirectives ? " " : NLINDENT;
    }

    protected String nlindent2() {
        return this.doCompressMetaDirectives ? " " : NLINDENTINDENT;
    }

    protected String indent() {
        return this.doCompressMetaDirectives ? " " : INDENT;
    }

    protected void appendList(StringBuilder buffer, Set<String> list) {
        boolean first = true;
        for (String name : list) {
            if (!first) {
                buffer.append(",");
            } else {
                first = false;
            }
            buffer.append(name);
        }
    }

    protected void getParentAttrs(String pojo, Set<String> isDef, Set<String> toInit, Set<String> toStr) {
        for (Map.Entry<String, PojoAttribute> pentry : this.pojos.get(pojo).entrySet()) {
            if (this.ignoreColumns.containsKey(pojo) && this.ignoreColumns.get(pojo).contains(pentry.getKey())) continue;
            PojoAttribute attribute = pentry.getValue();
            String name = this.columnNames.containsKey(pojo) ? this.columnNames.get(pojo).get(pentry.getKey()) : null;
            name = name == null ? attribute.getName() : this.columnToCamelCase(name);
            if (isDef != null && attribute.isDef()) {
                isDef.add(name);
            }
            if (toInit != null && attribute.toInit()) {
                toInit.add(name);
            }
            if (toStr == null) continue;
            if (attribute.getDependencyClassName() != null) {
                if (!attribute.isDependencyClassNameIsEnum()) continue;
                toStr.add(name);
                continue;
            }
            if (attribute.isPrimitive()) {
                toStr.add(name);
                continue;
            }
            if (attribute.getClassName().startsWith(COLLECTION_LIST)) continue;
            toStr.add(name);
        }
        if (this.pojoExtends.containsKey(pojo)) {
            this.getParentAttrs(this.pojoExtends.get(pojo), isDef, toInit, toStr);
        }
    }

    protected String tableToCamelCase(String value) {
        if (LIBRARY_GUAVA.equalsIgnoreCase(this.caseFormatLibrary)) {
            if (Character.isUpperCase(value.charAt(0))) {
                return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, value);
            }
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, value);
        }
        return CommonUtils.tableToCamelCase(value);
    }

    protected String columnToCamelCase(String value) {
        if (LIBRARY_GUAVA.equalsIgnoreCase(this.caseFormatLibrary)) {
            if (Character.isUpperCase(value.charAt(0))) {
                return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, value);
            }
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, value);
        }
        return CommonUtils.columnToCamelCase(value);
    }

    protected String columnToDbConv(String value) {
        if (LIBRARY_GUAVA.equalsIgnoreCase(this.caseFormatLibrary)) {
            if (Character.isUpperCase(value.charAt(0))) {
                return CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, value);
            }
            return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, value);
        }
        return this._columnToDbConv(value);
    }

    protected String _columnToDbConv(String value) {
        if (value == null) {
            return null;
        }
        Object result = "";
        int last = 0;
        int i = 0;
        int l = value.length();
        while (i < l) {
            if (Character.isUpperCase(value.charAt(i))) {
                result = (String)result + value.substring(last, i).toUpperCase() + "_";
                last = i;
            }
            ++i;
        }
        if (last < value.length()) {
            result = (String)result + value.substring(last).toUpperCase();
        }
        return result;
    }

    protected PojoAttribute convertDbColumnDefinition(String dbName, PojoAttrType sqlType) {
        PojoAttribute attribute = new PojoAttribute(dbName);
        attribute.setName(this.columnToCamelCase(dbName));
        attribute.setPrimitive(sqlType.isNativeType());
        attribute.setClassName(sqlType.getQualifiedName());
        return attribute;
    }

    protected PojoAttribute convertDbColumnDefinition(String dbName, String metaType) {
        PojoAttribute attribute = new PojoAttribute(dbName);
        attribute.setName(this.columnToCamelCase(dbName));
        attribute.setPrimitive(false);
        attribute.setClassName(this.metaType2className(metaType));
        return attribute;
    }

    protected PojoAttribute convertDbColumnDefinition(String dbName, PojoAttribute pkAttribute) {
        PojoAttribute attribute = new PojoAttribute(dbName);
        attribute.setName(this.columnToCamelCase(dbName));
        attribute.setPrimitive(pkAttribute.isPrimitive());
        attribute.setClassName(pkAttribute.getClassName());
        attribute.setOne2one(pkAttribute.getDbName());
        return attribute;
    }

    protected PojoAttribute convertDbColumnDefinition(String table, DbColumn dbColumn, Map<String, Map<String, PojoAttrType>> redefinedTypes) {
        PojoAttrType sqlType;
        if (dbColumn == null) {
            return null;
        }
        PojoAttrType pojoAttrType = sqlType = redefinedTypes.containsKey(table) ? redefinedTypes.get(table).get(dbColumn.getName()) : null;
        if (sqlType == null) {
            PojoAttrType pojoAttrType2 = sqlType = this.tableTypes.containsKey(table) ? this.tableTypes.get(table).get(dbColumn.getCompleteType()) : null;
        }
        if (sqlType == null) {
            sqlType = this.sqlTypes.get(dbColumn.getCompleteType());
        }
        if (sqlType == null) {
            return null;
        }
        PojoAttribute attribute = new PojoAttribute(dbColumn.getName());
        attribute.setName(this.columnToCamelCase(dbColumn.getName()));
        attribute.setRequired(!dbColumn.isNullable());
        attribute.setPrimitive(sqlType.isNativeType());
        attribute.setClassName(sqlType.getQualifiedName());
        attribute.setSqlType(dbColumn.getSqlType());
        attribute.setCompleteSqlType(dbColumn.getCompleteType());
        attribute.setSize(dbColumn.getSize());
        attribute.setComment(dbColumn.getComment());
        attribute.setDefaultValue(dbColumn.getDefaultValue());
        return attribute;
    }

    public static void main(String[] args) {
        System.out.println("127".length());
        System.out.println("32767".length());
        System.out.println("2147483647".length());
        System.out.println("9223372036854775807".length());
    }

    protected PojoAttribute convertDbColumnDefault(String table, DbColumn dbColumn) {
        if (dbColumn == null) {
            return null;
        }
        PojoAttribute attribute = new PojoAttribute(dbColumn.getName());
        attribute.setName(this.columnToCamelCase(dbColumn.getName()));
        attribute.setRequired(!dbColumn.isNullable());
        int sqlType = dbColumn.getSqlType();
        if (sqlType == 2) {
            if (dbColumn.getSize() < 3) {
                sqlType = -6;
            } else if (dbColumn.getSize() < 5) {
                sqlType = 5;
            } else if (dbColumn.getSize() < 10) {
                sqlType = 4;
            } else if (dbColumn.getSize() < 19) {
                sqlType = -5;
            }
        }
        switch (sqlType) {
            case -7: 
            case 16: {
                if (dbColumn.isNullable() || this.doGenerateWrappers) {
                    attribute.setPrimitive(false);
                    attribute.setClassName(Boolean.class.getName());
                    attribute.setWrapperClassName(Boolean.class.getName());
                    break;
                }
                attribute.setPrimitive(true);
                attribute.setClassName(PrimitiveType.BOOLEAN.getName());
                attribute.setWrapperClassName(Boolean.class.getName());
                break;
            }
            case -6: {
                if (dbColumn.isNullable() || this.doGenerateWrappers) {
                    attribute.setPrimitive(false);
                    attribute.setClassName(Byte.class.getName());
                    attribute.setWrapperClassName(Byte.class.getName());
                    break;
                }
                attribute.setPrimitive(true);
                attribute.setClassName(PrimitiveType.BYTE.getName());
                attribute.setWrapperClassName(Byte.class.getName());
                break;
            }
            case 5: {
                if (dbColumn.isNullable() || this.doGenerateWrappers) {
                    attribute.setPrimitive(false);
                    attribute.setClassName(Short.class.getName());
                    attribute.setWrapperClassName(Short.class.getName());
                    break;
                }
                attribute.setPrimitive(true);
                attribute.setClassName(PrimitiveType.SHORT.getName());
                attribute.setWrapperClassName(Short.class.getName());
                break;
            }
            case 4: {
                if (dbColumn.isNullable() || this.doGenerateWrappers) {
                    attribute.setPrimitive(false);
                    attribute.setClassName(Integer.class.getName());
                    attribute.setWrapperClassName(Integer.class.getName());
                    break;
                }
                attribute.setPrimitive(true);
                attribute.setClassName(PrimitiveType.INT.getName());
                attribute.setWrapperClassName(Integer.class.getName());
                break;
            }
            case -5: {
                if (dbColumn.isNullable() || this.doGenerateWrappers) {
                    attribute.setPrimitive(false);
                    attribute.setClassName(Long.class.getName());
                    attribute.setWrapperClassName(Long.class.getName());
                    break;
                }
                attribute.setPrimitive(true);
                attribute.setClassName(PrimitiveType.LONG.getName());
                attribute.setWrapperClassName(Long.class.getName());
                break;
            }
            case 6: 
            case 7: {
                if (dbColumn.isNullable() || this.doGenerateWrappers) {
                    attribute.setPrimitive(false);
                    attribute.setClassName(Float.class.getName());
                    attribute.setWrapperClassName(Float.class.getName());
                    break;
                }
                attribute.setPrimitive(true);
                attribute.setClassName(PrimitiveType.FLOAT.getName());
                attribute.setWrapperClassName(Float.class.getName());
                break;
            }
            case 8: {
                if (dbColumn.isNullable() || this.doGenerateWrappers) {
                    attribute.setPrimitive(false);
                    attribute.setClassName(Double.class.getName());
                    attribute.setWrapperClassName(Double.class.getName());
                    break;
                }
                attribute.setPrimitive(true);
                attribute.setClassName(PrimitiveType.DOUBLE.getName());
                attribute.setWrapperClassName(PrimitiveType.DOUBLE.getName());
                break;
            }
            case 2: {
                attribute.setPrimitive(false);
                attribute.setClassName(BigInteger.class.getName());
                attribute.setWrapperClassName(attribute.getClassName());
                break;
            }
            case 3: {
                attribute.setPrimitive(false);
                if (dbColumn.getSize() < 3) {
                    attribute.setClassName(Byte.class.getName());
                } else if (dbColumn.getSize() < 5) {
                    attribute.setClassName(Short.class.getName());
                } else if (dbColumn.getSize() < 10) {
                    attribute.setClassName(Integer.class.getName());
                } else if (dbColumn.getSize() < 19) {
                    attribute.setClassName(Long.class.getName());
                } else {
                    attribute.setClassName(BigInteger.class.getName());
                }
                attribute.setWrapperClassName(attribute.getClassName());
                break;
            }
            case -15: 
            case 1: {
                if (dbColumn.isNullable() || dbColumn.getSize() > 1 || this.doGenerateWrappers) {
                    attribute.setPrimitive(false);
                    attribute.setClassName(String.class.getName());
                    attribute.setWrapperClassName(String.class.getName());
                    break;
                }
                attribute.setPrimitive(true);
                attribute.setClassName(PrimitiveType.CHAR.getName());
                attribute.setWrapperClassName(String.class.getName());
                break;
            }
            case -16: 
            case -9: 
            case 12: {
                attribute.setPrimitive(false);
                attribute.setClassName(String.class.getName());
                attribute.setWrapperClassName(String.class.getName());
                break;
            }
            case 91: {
                attribute.setPrimitive(false);
                if (this.oldDateTime) {
                    attribute.setClassName(Date.class.getName());
                    attribute.setWrapperClassName(java.util.Date.class.getName());
                    break;
                }
                attribute.setClassName(LocalDate.class.getName());
                attribute.setWrapperClassName(LocalDate.class.getName());
                break;
            }
            case 92: {
                attribute.setPrimitive(false);
                if (this.oldDateTime) {
                    attribute.setClassName(Time.class.getName());
                    attribute.setWrapperClassName(Time.class.getName());
                    break;
                }
                attribute.setClassName(LocalTime.class.getName());
                attribute.setWrapperClassName(LocalTime.class.getName());
                break;
            }
            case 93: {
                attribute.setPrimitive(false);
                if (this.oldDateTime) {
                    attribute.setClassName(Timestamp.class.getName());
                    attribute.setWrapperClassName(Timestamp.class.getName());
                    break;
                }
                attribute.setClassName(LocalDateTime.class.getName());
                attribute.setWrapperClassName(LocalDateTime.class.getName());
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                attribute.setPrimitive(true);
                attribute.setClassName(PrimitiveType.BYTE_ARRAY.getName());
                attribute.setWrapperClassName(PrimitiveType.BYTE_ARRAY.getName());
                break;
            }
            case 2005: {
                attribute.setPrimitive(false);
                attribute.setClassName(String.class.getName());
                attribute.setWrapperClassName(String.class.getName());
                break;
            }
            default: {
                attribute.setPrimitive(false);
                if (dbColumn.getType().indexOf("TIMESTAMP") == 0 || dbColumn.getType().indexOf("timestamp") == 0) {
                    if (this.oldDateTime) {
                        attribute.setClassName(Timestamp.class.getName());
                    } else {
                        attribute.setClassName(LocalDateTime.class.getName());
                    }
                } else {
                    attribute.setClassName("java.lang.Object");
                }
                attribute.setWrapperClassName(attribute.getClassName());
            }
        }
        attribute.setSqlType(dbColumn.getSqlType());
        attribute.setCompleteSqlType(dbColumn.getCompleteType());
        attribute.setSize(dbColumn.getSize());
        attribute.setComment(dbColumn.getComment());
        attribute.setDefaultValue(dbColumn.getDefaultValue());
        return attribute;
    }

    protected String metaType2className(String metaType) {
        if (metaType == null) {
            return null;
        }
        String className = metaType2classNameMap.get(metaType.toLowerCase());
        if (className == null) {
            return metaType;
        }
        return className;
    }

    protected String className2metaType(String className) {
        if (className == null) {
            return null;
        }
        String metaType = className2metaTypeMap.get(className);
        if (metaType == null) {
            return null;
        }
        return metaType;
    }

    protected void printComment(StringBuilder buffer, String comment, String ... indents) {
        if (comment == null || comment.trim().length() == 0) {
            return;
        }
        int l = comment.length();
        while (l > 0) {
            buffer.append("\n");
            String[] stringArray = indents;
            int n = indents.length;
            int n2 = 0;
            while (n2 < n) {
                String indent = stringArray[n2];
                buffer.append(indent);
                ++n2;
            }
            buffer.append("// ");
            if (l > 100) {
                buffer.append(comment.substring(0, 100));
                comment = comment.substring(100);
            } else {
                buffer.append(comment);
                comment = "";
            }
            l = comment.length();
        }
    }

    protected String constName(Map<PojoAttribute, Boolean> l) {
        StringBuilder result = new StringBuilder("");
        boolean first = true;
        for (Map.Entry<PojoAttribute, Boolean> e : l.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("_");
            }
            result.append(this.constantName(e.getKey().getName()));
        }
        return result.toString();
    }

    protected String constantName(String name) {
        StringBuilder result = new StringBuilder("");
        char[] cArray = name.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character c = Character.valueOf(cArray[n2]);
            if (Character.isUpperCase(c.charValue())) {
                result.append("_");
                result.append(c);
            } else {
                result.append(Character.toUpperCase(c.charValue()));
            }
            ++n2;
        }
        return result.toString();
    }

    protected boolean addDefinitions(DbResolver dbResolver, IScopeProvider scopeProvider, Stats stats) {
        String comment;
        List<DbTable> ltables;
        for (TableDefinition _table : this.modelTables.values()) {
            List<DbColumn> dbColumns;
            String table = _table.getTable();
            if (table == null || table.toUpperCase().startsWith("BIN$") || !dbResolver.checkTable(this.model, table) || (dbColumns = dbResolver.getDbColumns(this.model, table)).isEmpty()) continue;
            ++stats.tables;
            stats.columns += dbColumns.size();
            List<String> dbPrimaryKeys = dbResolver.getDbPrimaryKeys(this.model, table);
            stats.primaryKeys += dbPrimaryKeys.size();
            List<DbExport> dbExports = dbResolver.getDbExports(this.model, table);
            stats.exports += dbExports.size();
            List<DbImport> dbImports = dbResolver.getDbImports(this.model, table);
            stats.imports += dbImports.size();
            List<DbIndex> dbIndexes = dbResolver.getDbIndexes(this.model, table);
            stats.indexes += dbIndexes.size();
            List<DbTable> ltables2 = dbResolver.getDbTables(this.model, table);
            String comment2 = ltables2 != null && !ltables2.isEmpty() ? ltables2.get(0).getComment() : null;
            List<DbCheckConstraint> dbCheckConstraints = dbResolver.getDbCheckConstraints(this.model, table);
            stats.checkConstraints += dbCheckConstraints.size();
            this.addTableDefinition(table, dbColumns, dbPrimaryKeys, dbExports, dbImports, dbIndexes, dbCheckConstraints, comment2);
        }
        this.resolveReferencesOnKeys();
        this.joinTables();
        for (ProcedureDefinition _procedure : this.modelProcedures.values()) {
            List<DbTable> dbProcedures;
            String procedure = _procedure.getProcedure();
            if (procedure == null || procedure.toUpperCase().startsWith("BIN$") || (dbProcedures = dbResolver.getDbProcedures(this.model, procedure)).isEmpty()) continue;
            ++stats.procedures;
            List<DbColumn> dbProcColumns = dbResolver.getDbProcColumns(this.model, procedure);
            stats.procColumns += dbProcColumns.size();
            ltables = dbResolver.getDbProcedures(this.model, procedure);
            comment = ltables != null && !ltables.isEmpty() ? ltables.get(0).getComment() : null;
            this.addProcedureDefinition(procedure, dbProcedures.get(0), dbProcColumns, this.modelFunctions.containsKey(_procedure.getName()), comment);
        }
        for (FunctionDefinition _function : this.modelFunctions.values()) {
            List<DbTable> dbFunctions;
            String function = _function.getFunction();
            if (function == null || function.toUpperCase().startsWith("BIN$") || (dbFunctions = dbResolver.getDbFunctions(this.model, function)).isEmpty()) continue;
            ++stats.functions;
            List<DbColumn> dbFunColumns = dbResolver.getDbFunColumns(this.model, function);
            stats.funColumns += dbFunColumns.size();
            ltables = dbResolver.getDbFunctions(this.model, function);
            comment = ltables != null && !ltables.isEmpty() ? ltables.get(0).getComment() : null;
            this.addFunctionDefinition(function, dbFunctions.get(0), dbFunColumns, comment);
        }
        return true;
    }

    public static class Filter {
        static final String ONLY_TABLE = "only-table";
        static final String ONLY_TABLES = "only-tables";
        static final String ADD = "add";
        static final String ADD_FILTER = "add-filter";
        Map<String, String> filters;
        Set<String> onlyTables;

        public static Filter parse(String s) {
            if (s == null) {
                return null;
            }
            if (s.startsWith("\"")) {
                s = s.substring(1);
            }
            if (s.endsWith("\"")) {
                s = s.substring(0, s.length() - 1);
            }
            Filter f = new Filter();
            f.filters = new HashMap<String, String>();
            f.onlyTables = new HashSet<String>();
            String[] ss = s.split(" ");
            boolean isFilter = false;
            boolean isTable = false;
            boolean isTables = false;
            String[] stringArray = ss;
            int n = ss.length;
            int n2 = 0;
            while (n2 < n) {
                String s1 = stringArray[n2];
                if (isFilter) {
                    f.filters.put(ADD, s1);
                    isFilter = false;
                } else if (isTable) {
                    f.onlyTables.add(s1);
                    isTable = false;
                } else if (isTables) {
                    String[] tt;
                    String[] stringArray2 = tt = s1.split(",");
                    int n3 = tt.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String t1 = stringArray2[n4];
                        f.onlyTables.add(t1);
                        ++n4;
                    }
                    isTables = false;
                } else if (s1.equalsIgnoreCase(ADD_FILTER)) {
                    isFilter = true;
                } else if (s1.equalsIgnoreCase(ONLY_TABLE)) {
                    isTable = true;
                } else if (s1.equalsIgnoreCase(ONLY_TABLES)) {
                    isTables = true;
                }
                ++n2;
            }
            return f;
        }

        public static boolean isTable(Filter f, String table) {
            if (f == null || f.onlyTables.isEmpty()) {
                return true;
            }
            return f.onlyTables.contains(table);
        }

        static String get(Filter f, String what) {
            if (f == null || !f.filters.containsKey(what)) {
                return null;
            }
            return f.filters.get(what);
        }

        public String toString() {
            return "Filter [filters=" + String.valueOf(this.filters) + "]";
        }
    }

    protected static enum PrimitiveType {
        BOOLEAN,
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        CHAR,
        BYTE_ARRAY,
        CHAR_ARRAY;


        public String getName() {
            if (this == BYTE_ARRAY) {
                return "byte[]";
            }
            if (this == CHAR_ARRAY) {
                return "char[]";
            }
            return this.name().toLowerCase();
        }
    }
}

