/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.model.property;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.sqlproc.model.processorModel.AnnotationDefinitionModel;
import org.sqlproc.plugin.lib.property.ColumnAnnotations;
import org.sqlproc.plugin.lib.util.CommonUtils;

public class ColumnAnnotationsImpl
implements ColumnAnnotations {
    String dbColumn;
    Map<String, Integer> annotations = new TreeMap<String, Integer>();
    Map<String, Set<String>> dbTables = new HashMap<String, Set<String>>();
    Map<String, Set<String>> dbNotTables = new HashMap<String, Set<String>>();

    public ColumnAnnotationsImpl(ColumnAnnotationsImpl columnAnnotations, String dbColumn, List<AnnotationDefinitionModel> annotations, List<String> dbTables, List<String> dbNotTables, int type) {
        if (columnAnnotations != null) {
            this.annotations = columnAnnotations.annotations;
            this.dbTables = columnAnnotations.dbTables;
            this.dbNotTables = columnAnnotations.dbNotTables;
        } else {
            this.annotations = new TreeMap<String, Integer>();
            this.dbTables = new HashMap<String, Set<String>>();
            this.dbNotTables = new HashMap<String, Set<String>>();
        }
        this.dbColumn = dbColumn;
        for (AnnotationDefinitionModel annotation : annotations) {
            Set<String> _dbTables;
            String name = annotation.getName();
            Integer _type = this.annotations.get(name);
            _type = _type == null ? Integer.valueOf(type) : Integer.valueOf(_type | type);
            this.annotations.put(name, _type);
            for (String dbTable : dbTables) {
                _dbTables = this.dbTables.get(name + type);
                if (_dbTables == null) {
                    _dbTables = new HashSet<String>();
                }
                _dbTables.add(dbTable);
                _dbTables.add(CommonUtils.tableToCamelCase(dbTable));
                this.dbTables.put(name + type, _dbTables);
            }
            for (String dbTable : dbNotTables) {
                _dbTables = this.dbNotTables.get(name + type);
                if (_dbTables == null) {
                    _dbTables = new HashSet<String>();
                }
                _dbTables.add(dbTable);
                _dbTables.add(CommonUtils.tableToCamelCase(dbTable));
                this.dbNotTables.put(name + type, _dbTables);
            }
        }
    }

    @Override
    public String getDbColumn() {
        return this.dbColumn;
    }

    @Override
    public Map<String, Integer> getAnnotations() {
        return this.annotations;
    }

    @Override
    public Set<String> getDbTables(String name) {
        return this.dbTables.get(name);
    }

    @Override
    public Set<String> getDbNotTables(String name) {
        return this.dbNotTables.get(name);
    }

    public String toString() {
        return "ColumnAnnotationsImpl [dbColumn=" + this.dbColumn + ", annotations=" + String.valueOf(this.annotations) + ", dbTables=" + String.valueOf(this.dbTables) + ", dbNotTables=" + String.valueOf(this.dbNotTables) + "]";
    }
}

