/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.model.generator;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.serializer.ISerializer;
import org.sqlproc.model.generator.TablePojoGenerator;
import org.sqlproc.model.processorModel.AbstractEntity;
import org.sqlproc.model.processorModel.AnnotatedEntity;
import org.sqlproc.model.processorModel.AnnotatedFeature;
import org.sqlproc.model.processorModel.Artifacts;
import org.sqlproc.model.processorModel.DaoEntity;
import org.sqlproc.model.processorModel.Package;
import org.sqlproc.model.util.Annotations;
import org.sqlproc.model.util.Utils;
import org.sqlproc.plugin.lib.generator.TableBaseGenerator;
import org.sqlproc.plugin.lib.property.ImplementsExtends;
import org.sqlproc.plugin.lib.property.ModelProperty;
import org.sqlproc.plugin.lib.property.PojoAttribute;
import org.sqlproc.plugin.lib.property.PojoEntityType;
import org.sqlproc.plugin.lib.resolver.DbResolver;
import org.sqlproc.plugin.lib.util.Debug;
import org.sqlproc.plugin.lib.util.Stats;

public class TableDaoGenerator
extends TablePojoGenerator {
    protected Logger LOGGER = Logger.getLogger(TableDaoGenerator.class);
    private Debug debug = new Debug(this.LOGGER);
    protected Map<String, String> finalDaos;
    protected Map<String, Map<String, String>> finalDaosFeatures;
    protected Annotations daoAnnotations;
    protected Set<String> daoImports;
    protected Set<String> daoIgnoreTables = new HashSet<String>();
    protected Set<String> daoOnlyTables = new HashSet<String>();
    protected Map<String, ImplementsExtends> daoToImplements = new TreeMap<String, ImplementsExtends>();
    protected ImplementsExtends daoToExtends = null;
    protected boolean daoMakeItFinal;
    protected Map<String, PojoEntityType> daoFunctionsResult = new HashMap<String, PojoEntityType>();
    protected TableBaseGenerator.Filter daoActiveFilter = null;
    protected String daoPackage;
    protected String daoImplPackage;

    public TableDaoGenerator(ModelProperty modelProperty, Artifacts artifacts, IScopeProvider scopeProvider, Map<String, String> finalDaos, Map<String, Map<String, String>> finalDaosFeatures, Annotations daoAnnotations, Set<String> daoImports, List<String> dbSequences, DbResolver.DbType dbType) {
        super(modelProperty, artifacts, Collections.emptyMap(), Collections.emptyMap(), null, null, dbSequences, dbType);
        Map<String, ImplementsExtends> daoToImplements;
        Set<String> daoOnlyTables;
        Set<String> daoIgnoreTables;
        this.debug = new Debug(modelProperty.getDaoDebugLevel(artifacts), modelProperty.getDaoDebugScope(artifacts), this.LOGGER);
        this.finalDaos = finalDaos;
        this.finalDaosFeatures = finalDaosFeatures;
        this.daoAnnotations = daoAnnotations;
        this.daoImports = new TreeSet<String>();
        if (daoImports != null) {
            this.daoImports.addAll(daoImports);
        }
        if ((daoIgnoreTables = modelProperty.getDaoIgnoreTables(artifacts)) != null) {
            this.daoIgnoreTables.addAll(daoIgnoreTables);
        }
        if ((daoOnlyTables = modelProperty.getDaoOnlyTables(artifacts)) != null) {
            this.daoOnlyTables.addAll(daoOnlyTables);
        }
        if ((daoToImplements = modelProperty.getDaoToImplements(artifacts)) != null) {
            this.daoToImplements.putAll(daoToImplements);
        }
        this.daoToExtends = modelProperty.getDaoToExtends(artifacts);
        this.daoMakeItFinal = modelProperty.isDaoMakeItFinal(artifacts);
        Map<String, PojoEntityType> daoFunctionsResult = modelProperty.getDaoFunctionsResult(artifacts);
        if (daoFunctionsResult != null) {
            this.daoFunctionsResult.putAll(daoFunctionsResult);
        }
        this.daoActiveFilter = TableBaseGenerator.Filter.parse(modelProperty.getDaoActiveFilter(artifacts));
        this.daoPackage = modelProperty.getDaoPackage(artifacts);
        this.daoImplPackage = modelProperty.getDaoImplPackage(artifacts);
        this.debug.debug("finalDaos " + String.valueOf(this.finalDaos));
        this.debug.debug("finalDaosFeatures " + String.valueOf(this.finalDaosFeatures));
        this.debug.debug("daoAnnotations " + String.valueOf(this.daoAnnotations));
        this.debug.debug("daoImports " + String.valueOf(this.daoImports));
        this.debug.debug("daoIgnoreTables " + String.valueOf(this.daoIgnoreTables));
        this.debug.debug("daoOnlyTables " + String.valueOf(this.daoOnlyTables));
        this.debug.debug("daoToImplements " + String.valueOf(this.daoToImplements));
        this.debug.debug("daoToExtends " + String.valueOf(this.daoToExtends));
        this.debug.debug("daoFunctionsResult " + String.valueOf(this.daoFunctionsResult));
        this.debug.debug("daoActiveFilter " + String.valueOf(this.daoActiveFilter));
        this.debug.debug("daoPackage " + this.daoPackage);
        this.debug.debug("daoImplPackage " + this.daoImplPackage);
    }

    public String getDaoDefinitions(ModelProperty modelProperty, Artifacts artifacts, ISerializer serializer) {
        String result = this.getDaoDefinitions(serializer);
        return Utils.replaceAll(modelProperty, result, artifacts);
    }

    public String getDaoDefinitions(ISerializer serializer) {
        StringBuilder bufferPartial = this._getDaoDefinitions(serializer);
        if (this.daoImports == null || this.daoImports.isEmpty() || this.pojoPackage == null) {
            return bufferPartial.toString();
        }
        StringBuilder buffer = new StringBuilder("\n");
        for (String name : this.daoImports) {
            buffer.append(INDENT).append("import ").append(name).append("\n");
        }
        buffer.append((CharSequence)bufferPartial);
        return buffer.toString();
    }

    public StringBuilder _getDaoDefinitions(ISerializer serializer) {
        PojoEntityType ptype;
        Iterator<Map.Entry<String, String>> dispName;
        PojoAttribute returnAttribute;
        String name;
        StringBuilder bufferMeta;
        String daoName;
        this.debug.debug("pojos " + String.valueOf(this.pojos));
        this.debug.debug("pojoExtends " + String.valueOf(this.pojoExtends));
        this.debug.debug("pojoInheritanceDiscriminator " + String.valueOf(this.pojoInheritanceDiscriminator));
        this.debug.debug("pojoInheritanceSimple " + String.valueOf(this.pojoInheritanceSimple));
        this.debug.debug("pojoDiscriminators " + String.valueOf(this.pojoDiscriminators));
        this.debug.debug("indexes " + String.valueOf(this.indexes));
        this.debug.debug("procedures " + String.valueOf(this.procedures));
        this.debug.debug("functions " + String.valueOf(this.functions));
        StringBuilder buffer = new StringBuilder();
        boolean isSerializable = false;
        HashSet<String> serializables = new HashSet<String>();
        boolean oneMoreLine = false;
        if (!this.daoToImplements.isEmpty()) {
            for (ImplementsExtends ie : this.daoToImplements.values()) {
                Object pojoName;
                String identifier = ie.getIdentifier();
                if (identifier.endsWith("Serializable")) {
                    if (!ie.getDbTables().isEmpty()) {
                        for (String dbTable : ie.getDbTables()) {
                            serializables.add(dbTable);
                        }
                        continue;
                    }
                    if (!ie.getDbNotTables().isEmpty()) {
                        for (String pojo : this.pojos.keySet()) {
                            serializables.add(pojo);
                        }
                        for (String pojo : this.enums.keySet()) {
                            serializables.add(pojo);
                        }
                        for (String pojo : this.procedures.keySet()) {
                            serializables.add(pojo);
                        }
                        for (String pojo : this.functions.keySet()) {
                            serializables.add(pojo);
                        }
                        for (String dbTable : ie.getDbNotTables()) {
                            serializables.remove(dbTable);
                        }
                        continue;
                    }
                    isSerializable = true;
                    continue;
                }
                if (ie.isGenerics()) {
                    buffer.append(NLINDENT).append("#Generics");
                }
                if (!ie.getDbTables().isEmpty()) {
                    buffer.append(NLINDENT).append("#OnlyDaos(");
                    boolean first = true;
                    for (String dbColumn : ie.getDbTables()) {
                        if (!first) {
                            buffer.append(",");
                        } else {
                            first = false;
                        }
                        pojoName = (String)this.tableNames.get(dbColumn);
                        if (pojoName == null) {
                            pojoName = dbColumn;
                        }
                        String daoName2 = this.tableToCamelCase((String)pojoName) + "Dao";
                        buffer.append(daoName2);
                    }
                    buffer.append(")");
                }
                if (!ie.getDbNotTables().isEmpty()) {
                    buffer.append(NLINDENT).append("#ExceptDaos(");
                    boolean first = true;
                    for (String dbColumn : ie.getDbNotTables()) {
                        if (!first) {
                            buffer.append(",");
                        } else {
                            first = false;
                        }
                        pojoName = (String)this.tableNames.get(dbColumn);
                        if (pojoName == null) {
                            pojoName = dbColumn;
                        }
                        String daoName2 = this.tableToCamelCase((String)pojoName) + "Dao";
                        buffer.append(daoName2);
                    }
                    buffer.append(")");
                }
                buffer.append(NLINDENT).append("implements ").append(identifier);
            }
            oneMoreLine = true;
        }
        if (this.daoToExtends != null) {
            if (this.daoToExtends.isGenerics()) {
                buffer.append(NLINDENT).append("#Generics");
            }
            if (!this.daoToExtends.getDbTables().isEmpty()) {
                buffer.append(NLINDENT).append("#OnlyDaos(");
                boolean first = true;
                for (String dbColumn : this.daoToExtends.getDbTables()) {
                    if (!first) {
                        buffer.append(",");
                    } else {
                        first = false;
                    }
                    String pojoName = (String)this.tableNames.get(dbColumn);
                    if (pojoName == null) {
                        pojoName = dbColumn;
                    }
                    daoName = this.tableToCamelCase(pojoName) + "Dao";
                    buffer.append(daoName);
                }
                buffer.append(")");
            }
            if (!this.daoToExtends.getDbNotTables().isEmpty()) {
                buffer.append(NLINDENT).append("#ExceptDaos(");
                boolean first = true;
                for (String dbColumn : this.daoToExtends.getDbNotTables()) {
                    if (!first) {
                        buffer.append(",");
                    } else {
                        first = false;
                    }
                    String pojoName = (String)this.tableNames.get(dbColumn);
                    if (pojoName == null) {
                        pojoName = dbColumn;
                    }
                    daoName = this.tableToCamelCase(pojoName) + "Dao";
                    buffer.append(daoName);
                }
                buffer.append(")");
            }
            oneMoreLine = true;
            buffer.append(NLINDENT).append("extends ").append(this.daoToExtends.getIdentifier());
        }
        if (oneMoreLine) {
            buffer.append(NL);
        }
        for (String pojo : this.pojos.keySet()) {
            String daoName3;
            if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(pojo) || this.daoIgnoreTables.contains(pojo) || this.metaProceduresResultSet.values().contains(pojo) && !this.tables.contains(pojo) || !TableBaseGenerator.Filter.isTable(this.daoActiveFilter, pojo)) continue;
            String pojoName = (String)this.tableNames.get(pojo);
            if (pojoName == null) {
                pojoName = pojo;
            }
            if (this.finalDaos.containsKey(daoName3 = (pojoName = this.tableToCamelCase(pojoName)) + "Dao")) {
                buffer.append(Utils.getFinalContent(this.finalDaos.get(daoName3)));
                continue;
            }
            if ((this.pojoInheritanceDiscriminator.containsKey(pojo) || this.pojoInheritanceSimple.containsKey(pojo)) && !this.notAbstractTables.contains(pojo)) continue;
            if (this.daoAnnotations != null) {
                buffer.append((CharSequence)this.daoAnnotations.getEntityAnnotationsDefinitions(daoName3, serializer, true, this.daoAnnotations.isNonStandardPojoAnnotations(daoName3)));
                buffer.append((CharSequence)this.daoAnnotations.getConstructorAnnotationsDefinitions(daoName3, serializer, true));
                buffer.append((CharSequence)this.daoAnnotations.getStaticAnnotationsDefinitions(daoName3, serializer, true));
                buffer.append((CharSequence)this.daoAnnotations.getConflictAnnotationsDefinitions(daoName3, serializer, true));
            }
            bufferMeta = new StringBuilder();
            if (isSerializable || serializables.contains(pojo)) {
                bufferMeta.append(this.nlindent()).append("#Serializable(1)");
            }
            LinkedHashMap<String, String> toInit = new LinkedHashMap<String, String>();
            this.toInits(pojo, toInit);
            for (Map.Entry entry : toInit.entrySet()) {
                bufferMeta.append(this.nlindent()).append("#InheritanceHandler(").append((String)entry.getKey());
                if (this.pojoInheritanceSimple.containsKey(entry.getValue())) {
                    for (String pojo2 : (Set)this.pojoInheritanceSimple.get(entry.getValue())) {
                        bufferMeta.append(",\"").append(this.columnToCamelCase(pojo2)).append("\"");
                        pojoName2 = (String)this.tableNames.get(pojo2);
                        if (pojoName2 == null) {
                            pojoName2 = pojo2;
                        }
                        bufferMeta.append("=").append(this.pojoPackage).append(".").append(this.tableToCamelCase(pojoName2));
                    }
                } else {
                    for (String pojo2 : (Set)this.pojoInheritanceDiscriminator.get(entry.getValue())) {
                        bufferMeta.append(",\"").append((String)this.pojoDiscriminators.get(pojo2)).append("\"");
                        pojoName2 = (String)this.tableNames.get(pojo2);
                        if (pojoName2 == null) {
                            pojoName2 = pojo2;
                        }
                        bufferMeta.append("=").append(this.pojoPackage).append(".").append(this.tableToCamelCase(pojoName2));
                    }
                }
                bufferMeta.append(")");
            }
            bufferMeta.append(this.nlindent()).append("#CRUD(").append(this.pojoPackage).append(".").append(pojoName).append(")");
            bufferMeta.append(this.nlindent()).append("#Query(").append(this.pojoPackage).append(".").append(pojoName).append(")");
            if (bufferMeta.length() > 0 && bufferMeta.charAt(0) == ' ') {
                buffer.append(NLINDENT).append(bufferMeta.substring(1));
            } else {
                buffer.append((CharSequence)bufferMeta);
            }
            buffer.append(NLINDENT);
            if (this.daoMakeItFinal) {
                buffer.append("final ");
            }
            buffer.append("#Dao ");
            buffer.append(daoName3);
            buffer.append(" {");
            if (this.finalDaosFeatures.containsKey(daoName3)) {
                buffer.append("\n");
                for (Map.Entry<String, String> e : this.finalDaosFeatures.get(daoName3).entrySet()) {
                    buffer.append(Utils.getFinalContent(e.getValue()));
                }
                buffer.append(INDENT).append("}\n");
                continue;
            }
            buffer.append(NLINDENT).append("}\n");
        }
        for (String procedure : this.procedures.keySet()) {
            boolean isFunction;
            if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(procedure) || this.daoIgnoreTables.contains(procedure) || !TableBaseGenerator.Filter.isTable(this.daoActiveFilter, procedure) || (isFunction = this.functions.containsKey(procedure))) continue;
            String pojoName = (String)this.tableNames.get(procedure);
            if (pojoName == null) {
                pojoName = procedure;
            }
            if (this.finalDaos.containsKey(daoName = (pojoName = this.tableToCamelCase(pojoName)) + "Dao")) {
                buffer.append(Utils.getFinalContent(this.finalDaos.get(daoName)));
                continue;
            }
            if (this.daoAnnotations != null) {
                buffer.append((CharSequence)this.daoAnnotations.getEntityAnnotationsDefinitions(daoName, serializer, true, this.daoAnnotations.isNonStandardPojoAnnotations(daoName)));
                buffer.append((CharSequence)this.daoAnnotations.getConstructorAnnotationsDefinitions(daoName, serializer, true));
                buffer.append((CharSequence)this.daoAnnotations.getStaticAnnotationsDefinitions(daoName, serializer, true));
                buffer.append((CharSequence)this.daoAnnotations.getConflictAnnotationsDefinitions(daoName, serializer, true));
            }
            bufferMeta = new StringBuilder();
            if (isSerializable || serializables.contains(procedure)) {
                bufferMeta.append(this.nlindent()).append("#Serializable(1)");
            }
            Map map = (Map)this.procedures.get(procedure);
            if (this.metaProceduresResultSet.containsKey(procedure)) {
                name = (String)this.metaProceduresResultSet.get(procedure);
                if (this.tableNames.containsKey(name)) {
                    name = (String)this.tableNames.get(name);
                }
                bufferMeta.append(this.nlindent()).append("#ProcedureCallQuery(").append("java.util.List").append("<").append((String)(this.pojos.containsKey(name) ? this.pojoPackage + "." : "")).append(this.tableToCamelCase(name)).append(">");
            } else {
                PojoAttribute pojoAttribute = returnAttribute = map.containsKey("_result_") ? (PojoAttribute)map.get("_result_") : null;
                if (returnAttribute != null && this.dbType != DbResolver.DbType.POSTGRESQL && this.dbType != DbResolver.DbType.MS_SQL) {
                    bufferMeta.append(this.nlindent()).append("#ProcedureCallQuery(").append("java.util.List").append("<").append(returnAttribute.getClassName()).append(">");
                } else {
                    bufferMeta.append(this.nlindent()).append("#ProcedureUpdate(int");
                }
            }
            dispName = null;
            ptype = (PojoEntityType)this.pojosForProcedures.get(procedure);
            if (ptype != null) {
                dispName = ptype.getSimpleName();
            }
            bufferMeta.append(",").append(this.pojoPackage).append(".").append((String)(dispName != null ? dispName : pojoName));
            bufferMeta.append(")");
            if (bufferMeta.length() > 0 && bufferMeta.charAt(0) == ' ') {
                buffer.append(NLINDENT).append(bufferMeta.substring(1));
            } else {
                buffer.append((CharSequence)bufferMeta);
            }
            buffer.append(NLINDENT);
            if (this.daoMakeItFinal) {
                buffer.append("final ");
            }
            buffer.append("#Dao ");
            buffer.append(daoName);
            buffer.append(" {");
            if (this.finalDaosFeatures.containsKey(daoName)) {
                buffer.append("\n");
                for (Map.Entry entry : this.finalDaosFeatures.get(daoName).entrySet()) {
                    buffer.append(Utils.getFinalContent((String)entry.getValue()));
                }
                buffer.append(INDENT).append("}\n");
                continue;
            }
            buffer.append(NLINDENT).append("}\n");
        }
        for (String function : this.procedures.keySet()) {
            boolean isFunction;
            if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(function) || this.daoIgnoreTables.contains(function) || !TableBaseGenerator.Filter.isTable(this.daoActiveFilter, function) || !(isFunction = this.functions.containsKey(function))) continue;
            String pojoName = (String)this.tableNames.get(function);
            if (pojoName == null) {
                pojoName = function;
            }
            if (this.finalDaos.containsKey(daoName = (pojoName = this.tableToCamelCase(pojoName)) + "Dao")) {
                buffer.append(Utils.getFinalContent(this.finalDaos.get(daoName)));
                continue;
            }
            if (this.daoAnnotations != null) {
                buffer.append((CharSequence)this.daoAnnotations.getEntityAnnotationsDefinitions(daoName, serializer, true, this.daoAnnotations.isNonStandardPojoAnnotations(daoName)));
                buffer.append((CharSequence)this.daoAnnotations.getConstructorAnnotationsDefinitions(daoName, serializer, true));
                buffer.append((CharSequence)this.daoAnnotations.getStaticAnnotationsDefinitions(daoName, serializer, true));
                buffer.append((CharSequence)this.daoAnnotations.getConflictAnnotationsDefinitions(daoName, serializer, true));
            }
            bufferMeta = new StringBuilder();
            if (isSerializable || serializables.contains(function)) {
                bufferMeta.append(this.nlindent()).append("#Serializable(1)");
            }
            Map map = (Map)this.procedures.get(function);
            if (this.metaFunctionsResultSet.containsKey(function)) {
                name = (String)this.metaFunctionsResultSet.get(function);
                if (this.tableNames.containsKey(name)) {
                    name = (String)this.tableNames.get(name);
                }
                bufferMeta.append(this.nlindent()).append("#FunctionCallQuery(").append("java.util.List").append("<").append((String)(this.pojos.containsKey(name) ? this.pojoPackage + "." : "")).append(this.tableToCamelCase(name)).append(">");
            } else if (this.metaFunctionsResult.containsKey(function)) {
                bufferMeta.append(this.nlindent()).append("#FunctionCall(").append(this.metaType2className((String)this.metaFunctionsResult.get(function)));
            } else {
                PojoAttribute pojoAttribute = returnAttribute = map.containsKey("_result_") ? (PojoAttribute)map.get("_result_") : null;
                if (returnAttribute != null) {
                    bufferMeta.append(this.nlindent()).append("#FunctionCallQuery(").append("java.util.List").append("<").append(returnAttribute.getClassName()).append(">");
                } else {
                    bufferMeta.append(this.nlindent()).append("#FunctionUpdate(int");
                }
            }
            dispName = null;
            ptype = (PojoEntityType)this.pojosForProcedures.get(function);
            if (ptype != null) {
                dispName = ptype.getSimpleName();
            }
            bufferMeta.append(",").append(this.pojoPackage).append(".").append((String)(dispName != null ? dispName : pojoName));
            bufferMeta.append(")");
            if (bufferMeta.length() > 0 && bufferMeta.charAt(0) == ' ') {
                buffer.append(NLINDENT).append(bufferMeta.substring(1));
            } else {
                buffer.append((CharSequence)bufferMeta);
            }
            buffer.append(NLINDENT);
            if (this.daoMakeItFinal) {
                buffer.append("final ");
            }
            buffer.append("#Dao ");
            buffer.append(daoName);
            buffer.append(" {");
            if (this.finalDaosFeatures.containsKey(daoName)) {
                buffer.append("\n");
                for (Map.Entry<String, String> entry : this.finalDaosFeatures.get(daoName).entrySet()) {
                    buffer.append(Utils.getFinalContent(entry.getValue()));
                }
                buffer.append(INDENT).append("}\n");
                continue;
            }
            buffer.append(NLINDENT).append("}\n");
        }
        for (String function : this.functions.keySet()) {
            boolean isProcedure;
            if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(function) || this.daoIgnoreTables.contains(function) || !TableBaseGenerator.Filter.isTable(this.daoActiveFilter, function) || (isProcedure = this.procedures.containsKey(function))) continue;
            String pojoName = (String)this.tableNames.get(function);
            if (pojoName == null) {
                pojoName = function;
            }
            if (this.finalDaos.containsKey(daoName = (pojoName = this.tableToCamelCase(pojoName)) + "Dao")) {
                buffer.append(Utils.getFinalContent(this.finalDaos.get(daoName)));
                continue;
            }
            if (this.daoAnnotations != null) {
                buffer.append((CharSequence)this.daoAnnotations.getEntityAnnotationsDefinitions(daoName, serializer, true, this.daoAnnotations.isNonStandardPojoAnnotations(daoName)));
                buffer.append((CharSequence)this.daoAnnotations.getConstructorAnnotationsDefinitions(daoName, serializer, true));
                buffer.append((CharSequence)this.daoAnnotations.getStaticAnnotationsDefinitions(daoName, serializer, true));
                buffer.append((CharSequence)this.daoAnnotations.getConflictAnnotationsDefinitions(daoName, serializer, true));
            }
            bufferMeta = new StringBuilder();
            if (isSerializable || serializables.contains(function)) {
                bufferMeta.append(this.nlindent()).append("#Serializable(1)");
            }
            Map map = (Map)this.functions.get(function);
            if (this.metaFunctionsResultSet.containsKey(function)) {
                name = (String)this.metaFunctionsResultSet.get(function);
                if (this.tableNames.containsKey(name)) {
                    name = (String)this.tableNames.get(name);
                }
                bufferMeta.append(this.nlindent()).append("#FunctionCallQuery(").append("java.util.List").append("<").append((String)(this.pojos.containsKey(name) ? this.pojoPackage + "." : "")).append(this.tableToCamelCase(name)).append(">");
            } else if (this.metaFunctionsResult.containsKey(function) && this.dbType == DbResolver.DbType.DB2) {
                bufferMeta.append(this.nlindent()).append("#FunctionQuery(").append(this.metaType2className((String)this.metaFunctionsResult.get(function)));
            } else if (this.metaFunctionsResult.containsKey(function)) {
                bufferMeta.append(this.nlindent()).append("callFunction ").append(this.metaType2className((String)this.metaFunctionsResult.get(function)));
            } else {
                PojoAttribute pojoAttribute = returnAttribute = map.containsKey("_result_") ? (PojoAttribute)map.get("_result_") : null;
                if (returnAttribute != null) {
                    bufferMeta.append(this.nlindent()).append("#FunctionCallQuery(").append("java.util.List").append("<").append(returnAttribute.getClassName()).append(">");
                } else {
                    bufferMeta.append(this.nlindent()).append("#FunctionUpdate(int");
                }
            }
            dispName = null;
            ptype = (PojoEntityType)this.pojosForProcedures.get(function);
            if (ptype != null) {
                dispName = ptype.getSimpleName();
            }
            bufferMeta.append(",").append(this.pojoPackage).append(".").append((String)(dispName != null ? dispName : pojoName));
            bufferMeta.append(")");
            if (bufferMeta.length() > 0 && bufferMeta.charAt(0) == ' ') {
                buffer.append(NLINDENT).append(bufferMeta.substring(1));
            } else {
                buffer.append((CharSequence)bufferMeta);
            }
            buffer.append(NLINDENT);
            if (this.daoMakeItFinal) {
                buffer.append("final ");
            }
            buffer.append("#Dao ");
            buffer.append(daoName);
            buffer.append(" {");
            if (this.finalDaosFeatures.containsKey(daoName)) {
                buffer.append("\n");
                for (Map.Entry<String, String> entry : this.finalDaosFeatures.get(daoName).entrySet()) {
                    buffer.append(Utils.getFinalContent(entry.getValue()));
                }
                buffer.append(INDENT).append("}\n");
                continue;
            }
            buffer.append(NLINDENT).append("}\n");
        }
        return buffer;
    }

    protected void toInits(String pojo, Map<String, String> toInit) {
        for (Map.Entry pentry : ((Map)this.pojos.get(pojo)).entrySet()) {
            if (this.ignoreColumns.containsKey(pojo) && ((Set)this.ignoreColumns.get(pojo)).contains(pentry.getKey())) continue;
            PojoAttribute attribute = (PojoAttribute)pentry.getValue();
            String name = this.columnNames.containsKey(pojo) ? (String)((Map)this.columnNames.get(pojo)).get(pentry.getKey()) : null;
            name = name == null ? attribute.getName() : this.columnToCamelCase(name);
            if (!attribute.toInit() || attribute.getRef() == null || !this.pojoInheritanceDiscriminator.containsKey(attribute.getRef()) && !this.pojoInheritanceSimple.containsKey(attribute.getRef())) continue;
            toInit.put(name, attribute.getRef());
        }
        if (this.pojoExtends.containsKey(pojo)) {
            this.toInits((String)this.pojoExtends.get(pojo), toInit);
        }
    }

    public static String generateDao(Artifacts artifacts, Package packagex, ISerializer serializer, DbResolver dbResolver, IScopeProvider scopeProvider, ModelProperty modelProperty, Stats stats) {
        if (artifacts == null || !dbResolver.isResolveDb(artifacts)) {
            return null;
        }
        if (serializer == null) {
            serializer = ((XtextResource)packagex.eResource()).getSerializer();
        }
        Set<String> imports = packagex != null ? Utils.getImports(packagex, serializer) : null;
        HashMap<String, String> finalDaos = new HashMap<String, String>();
        HashMap<String, Map<String, String>> finalFeatures = new HashMap<String, Map<String, String>>();
        Annotations annotations = new Annotations(INDENT, NL);
        if (packagex != null) {
            for (AbstractEntity ape : packagex.getElements()) {
                if (!(ape instanceof AnnotatedEntity) || !(((AnnotatedEntity)ape).getEntity() instanceof DaoEntity)) continue;
                DaoEntity dao = (DaoEntity)((AnnotatedEntity)ape).getEntity();
                Annotations.grabAnnotations((AnnotatedEntity)ape, annotations);
                if (dao.isFinal()) {
                    finalDaos.put(dao.getName(), serializer.serialize((EObject)dao));
                    continue;
                }
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                finalFeatures.put(dao.getName(), map);
                for (AnnotatedFeature feature : dao.getFeatures()) {
                    if (!feature.getFeature().isFinal()) continue;
                    map.put(feature.getFeature().getName(), serializer.serialize((EObject)feature));
                }
            }
        }
        List<String> dbSequences = dbResolver.getSequences(artifacts);
        DbResolver.DbType dbType = Utils.getDbType(dbResolver, artifacts);
        TableDaoGenerator generator = new TableDaoGenerator(modelProperty, artifacts, scopeProvider, finalDaos, finalFeatures, annotations, imports, dbSequences, dbType);
        try {
            if (generator.addDefinitions(dbResolver, scopeProvider, stats)) {
                return generator.getDaoDefinitions(modelProperty, artifacts, serializer);
            }
        }
        catch (RuntimeException ex) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            ex.printStackTrace(printWriter);
            String s = ((Object)writer).toString();
            return s;
        }
        return null;
    }
}

