/*
 * generated by Xtext
 */
package org.sqlproc.meta.validation
import org.eclipse.xtext.validation.Check

import static org.sqlproc.plugin.lib.util.Constants.*

import java.lang.reflect.Modifier
import java.lang.reflect.ParameterizedType
import java.util.Collection
import java.util.List

import org.eclipse.emf.ecore.EObject
import org.sqlproc.meta.processorMeta.Artifacts
import org.sqlproc.meta.processorMeta.Column
import org.sqlproc.meta.processorMeta.Constant
import org.sqlproc.meta.processorMeta.DatabaseColumn
import org.sqlproc.meta.processorMeta.DatabaseTable
import org.sqlproc.meta.processorMeta.FunctionDefinitionModel
import org.sqlproc.meta.processorMeta.Identifier
import org.sqlproc.meta.processorMeta.MappingColumn
import org.sqlproc.meta.processorMeta.MappingRule
import org.sqlproc.meta.processorMeta.MetaSql
import org.sqlproc.meta.processorMeta.MetaStatement
import org.sqlproc.meta.processorMeta.OptionalFeature
import org.sqlproc.meta.processorMeta.PojoDefinitionModel
import org.sqlproc.meta.processorMeta.ProcedureDefinitionModel
import org.sqlproc.meta.processorMeta.ProcessorMetaPackage
import org.sqlproc.meta.processorMeta.Property
import org.sqlproc.meta.processorMeta.TableDefinitionModel
import org.sqlproc.meta.util.Utils

import com.google.inject.Inject

import static extension org.eclipse.xtext.EcoreUtil2.*
import static extension org.eclipse.emf.ecore.util.EcoreUtil.*
import org.eclipse.emf.common.util.URI
import org.sqlproc.plugin.lib.resolver.PojoResolverFactory
import org.sqlproc.plugin.lib.resolver.DbResolver
import org.sqlproc.plugin.lib.property.ModelProperty
import org.sqlproc.plugin.lib.util.CommonUtils
import org.sqlproc.plugin.lib.property.PojoDefinition
import org.sqlproc.plugin.lib.property.TableDefinition
import java.util.TreeMap
import java.util.Map
import java.beans.PropertyDescriptor
import java.util.HashMap
import org.sqlproc.meta.processorMeta.OrdSql
import org.eclipse.xtext.common.types.JvmDeclaredType
import org.eclipse.xtext.common.types.JvmField
import java.util.Set
import org.eclipse.xtext.common.types.JvmFeature
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference
import org.eclipse.xtext.common.types.JvmType
import org.eclipse.xtext.common.types.JvmEnumerationType
import org.eclipse.xtext.common.types.JvmEnumerationLiteral
import org.eclipse.xtext.common.types.JvmTypeReference
import org.eclipse.xtext.common.types.JvmPrimitiveType
import org.eclipse.xtext.common.types.JvmOperation
import org.sqlproc.meta.processorMeta.AnnotationDefinitionModel

enum ValidationResult {
	OK, WARNING, ERROR
}

/**
 * Custom validation rules. 
 *
 * see http://www.eclipse.org/Xtext/documentation.html#validation
 */
class ProcessorMetaValidator extends AbstractProcessorMetaValidator {

    @Inject
    PojoResolverFactory pojoResolverFactory

    @Inject
    DbResolver dbResolver

    @Inject
    ModelProperty modelProperty


    val F_TYPES = <String>newHashSet("set", "update", "values", "where", "columns", "set=opt", "where=opt")

    @Check
    def checkMetaSqlFtype(MetaSql metaSql) {
        if (metaSql.getFtype() == null)
            return;
        if (CommonUtils.skipVerification(metaSql, modelProperty))
            return;
            
        if (metaSql.getFtype() != null && !F_TYPES.contains(metaSql.getFtype().toLowerCase)) {
            error("Invalid ftype : " + metaSql.getFtype(), ProcessorMetaPackage.Literals.META_SQL__FTYPE)
        }
    }

    @Check
    def checkUniqueMetaStatement(MetaStatement metaStatement) {
        if (CommonUtils.skipVerification(metaStatement, modelProperty))
            return;
        val artifacts = getArtifacts(metaStatement)
        if (artifacts == null)
            return;

        for (MetaStatement metaStmt : artifacts.getStatements()) {
            if (metaStmt != null && metaStmt !== metaStatement) {
	            if (equalsStatement(metaStatement, metaStmt)) {
	                error("Duplicate name : " + metaStatement.getName() + "[" + metaStatement.getType() + "]",
	                        ProcessorMetaPackage.Literals.META_STATEMENT__NAME)
	                return
	            }
            }
        }
    }

    def equalsStatement(MetaStatement statement1, MetaStatement statement2) {
        if (statement1 == null && statement2 == null)
            return true
        if (statement1 == null || statement1.getName() == null)
            return false
        if (statement2 == null || statement2.getName() == null)
            return false
        if (statement1.getName().equals(statement2.getName()) && statement1.getType().equals(statement2.getType())) {
            return equalsModifiers(statement1.getModifiers(), statement2.getModifiers())
        }
        return false
    }

    @Check
    def checkUniqueMappingRule(MappingRule mappingRule) {
        if (CommonUtils.skipVerification(mappingRule, modelProperty))
            return;
        val artifacts = getArtifacts(mappingRule)
        if (artifacts == null)
            return;

        for (MappingRule rule : artifacts.getMappings()) {
            if (rule != null && rule !== mappingRule) {
	            if (equalsRule(mappingRule, rule)) {
	                error("Duplicate name : " + mappingRule.getName() + "[" + mappingRule.getType() + "]",
	                        ProcessorMetaPackage.Literals.MAPPING_RULE__NAME)
	                return
	            }
            }
        }
    }

    def equalsRule(MappingRule rule1, MappingRule rule2) {
        if (rule1 == null && rule2 == null)
            return true
        if (rule1 == null || rule1.getName() == null)
            return false
        if (rule2 == null || rule2.getName() == null)
            return false
        if (rule1.getName().equals(rule2.getName()) && rule1.getType().equals(rule2.getType())) {
            return equalsModifiers(rule1.getModifiers(), rule2.getModifiers())
        }
        return false
    }

    @Check
    def checkUniqueOptionalFeature(OptionalFeature optionalFeature) {
        if (CommonUtils.skipVerification(optionalFeature, modelProperty))
            return;
        val artifacts = getArtifacts(optionalFeature)
        if (artifacts == null)
            return;

        for (OptionalFeature feature : artifacts.getFeatures()) {
            if (feature != null && feature != optionalFeature) {
	            if (equalsFeature(optionalFeature, feature)) {
	                error("Duplicate name : " + optionalFeature.getName() + "[" + optionalFeature.getType() + "]",
	                        ProcessorMetaPackage.Literals.OPTIONAL_FEATURE__NAME)
	                return
	            }
            }
        }
    }

    def equalsFeature(OptionalFeature feature1, OptionalFeature feature2) {
        if (feature1 == null && feature2 == null)
            return true
        if (feature1 == null || feature1.getName() == null)
            return false
        if (feature2 == null || feature2.getName() == null)
            return false
        if (feature1.getName().equals(feature2.getName()) && feature1.getType().equals(feature2.getType())) {
            return equalsModifiers(feature1.getModifiers(), feature2.getModifiers())
        }
        return false
    }
    
    @Check
    def checkUniquePojoDefinition(PojoDefinitionModel pojoDefinition) {
        if (CommonUtils.skipVerification(pojoDefinition, modelProperty))
            return;
        val artifacts = getArtifacts(pojoDefinition)
        if (artifacts == null)
            return;
            
        for (PojoDefinitionModel definition : artifacts.getPojos()) {
            if (definition != null && definition !== pojoDefinition) {
	            if (pojoDefinition.getName().equals(definition.getName())) {
	                error("Duplicate name : " + pojoDefinition.getName(),
	                        ProcessorMetaPackage.Literals.POJO_DEFINITION_MODEL__NAME)
	                return
	            }
            }
        }
    }
    
    @Check
    def checkUniqueAnnotationDefinition(AnnotationDefinitionModel annotationDefinition) {
        if (CommonUtils.skipVerification(annotationDefinition, modelProperty))
            return;
        val artifacts = getArtifacts(annotationDefinition)
        if (artifacts == null)
            return;
            
        for (AnnotationDefinitionModel definition : artifacts.annotations) {
            if (definition != null && definition !== annotationDefinition) {
	            if (annotationDefinition.getName().equals(definition.getName())) {
	                error("Duplicate name : " + annotationDefinition.getName(),
	                        ProcessorMetaPackage.Literals.ANNOTATION_DEFINITION_MODEL__NAME)
	                return
	            }
            }
        }
    }

    @Check
    def checkUniqueProperty(Property property) {
        if (CommonUtils.skipVerification(property, modelProperty))
            return;
        val artifacts = getArtifacts(property)
        if (artifacts == null)
            return;

        for (Property prop : artifacts.getProperties()) {
            if (prop != null && prop !== property) {
	            if (prop.getName().equals(property.getName()) && !prop.getName().startsWith("pojogen")
	                    && !prop.getName().startsWith("database") && !prop.getName().startsWith("metagen")
	                    && !prop.getName().startsWith("daogen") && !prop.getName().startsWith("replace-text")) {
	                error("Duplicate name : " + property.getName(), ProcessorMetaPackage.Literals.PROPERTY__NAME)
	                return
	            }
            }
        }
    }

    def equalsModifiers(List<String> modifiers1, List<String> modifiers2) {
        val filteredModifiers1 = filteredModifiers(modifiers1)
        val filteredModifiers2 = filteredModifiers(modifiers2)
        if (filteredModifiers1 == null && filteredModifiers2 == null)
            return true
        if (filteredModifiers1 == null)
            return false
        if (filteredModifiers2 == null)
            return false
        if (filteredModifiers1.isEmpty() && filteredModifiers2.isEmpty())
            return true
        // Filtry musi byt disjunktni, pro jednu shodu je vysledek komparace kladny
        for (String modifier1 : filteredModifiers1)
            for (String modifier2 : filteredModifiers2)
                if (modifier1.equals(modifier2))
                    return true
        return false
    }

    def List<String> filteredModifiers(List<String> modifiers) {
        if (modifiers == null)
            return null
        val filteredModifiers = <String>newArrayList()
        modifiers.forEach[modifier |
            if (modifier.indexOf('=') < 0)
                filteredModifiers.add(modifier)
        ]
        return filteredModifiers
    }

    def String getClass(PojoDefinitionModel pojo) {
        if (pojo.getClassx() != null)
            return pojo.getClassx().getQualifiedName()
        return pojo.getClass_()
    }

    @Check
    def checkMetaStatement(MetaStatement statement) {
        if (statement.getModifiers() == null || statement.getModifiers().isEmpty())
            return;
        if (CommonUtils.skipVerification(statement, modelProperty))
            return;
        val artifacts = getArtifacts(statement)
        if (artifacts == null)
            return;
        val URI uri = statement.eResource?.URI
        val Map<String, PropertyDescriptor[]> descriptorsCache = new HashMap<String, PropertyDescriptor[]>() 
        val Map<String, Class<?>> classesCache = new HashMap<String, Class<?>>()
        val Map<String, Map<String, String>> ordersCache = new HashMap<String, Map<String, String>>()

        var index = 0
        var String identPojoName
        var PojoDefinition identPojo
        var String indexPojoName
        var PojoDefinition indexPojo
        var String colPojoName
        var PojoDefinition colPojo
        var String constPojoName
        var PojoDefinition constPojo
        val TreeMap<String, TableDefinition> tablesPojo = new TreeMap<String, TableDefinition>()
        val TreeMap<String, TableDefinition> tablesPrefixPojo = new TreeMap<String, TableDefinition>()
        for (String modifier : statement.getModifiers()) {
        	val String[] values = modifier.split("=")
            if (values.length > 1) {
	            val key = values.get(0)
	            val value = values.get(1)
	            if (IDENTIFIER_USAGE.equals(key)) {
	                identPojo = modelProperty.getModelPojos(artifacts).get(value)
	                if (identPojo == null) {
	                    error("Cannot find pojo : " + value + "[" + IDENTIFIER_USAGE + "]",
	                            ProcessorMetaPackage.Literals.META_STATEMENT__MODIFIERS, index)
	                }
	                else
	                	identPojoName = value
	            }
	            if (INDEX_USAGE.equals(key)) {
	                indexPojo = modelProperty.getModelPojos(artifacts).get(value)
	                if (indexPojo == null) {
	                    error("Cannot find pojo : " + value + "[" + INDEX_USAGE + "]",
	                            ProcessorMetaPackage.Literals.META_STATEMENT__MODIFIERS, index)
	                }
	                else
	                	indexPojoName = value
	            }
				else if (COLUMN_USAGE.equals(key)) {
	                colPojo = modelProperty.getModelPojos(artifacts).get(value)
	                if (colPojo == null) {
	                    error("Cannot find pojo : " + value + "[" + COLUMN_USAGE + "]",
	                            ProcessorMetaPackage.Literals.META_STATEMENT__MODIFIERS, index)
	                }
	                else
	                	colPojoName = value
	            }
				else if (CONSTANT_USAGE.equals(key)) {
	                constPojo = modelProperty.getModelPojos(artifacts).get(value)
	                if (constPojo == null) {
	                    error("Cannot find pojo : " + value + "[" + CONSTANT_USAGE + "]",
	                            ProcessorMetaPackage.Literals.META_STATEMENT__MODIFIERS, index)
	                }
	                else
	                	constPojoName = value
	            }
				else if (TABLE_USAGE.equals(key)) {
					val prefix = if (values.length > 2) values.get(2) else "_DEFAULT_"
	                val table = modelProperty.getModelTables(artifacts).get(value)
	                if (table == null) {
	                    error("Cannot find table : " + value + "[" + TABLE_USAGE + "]",
	                            ProcessorMetaPackage.Literals.META_STATEMENT__MODIFIERS, index)
	                }
	                else {
	                	tablesPojo.put(value, table)
	                	tablesPrefixPojo.put(prefix, table)
                	}
	            }
	            index = index + 1
            }
        }
        if (indexPojo == null) {
           	indexPojo = identPojo;
           	indexPojoName = identPojoName;
        }
        val boolean newPojoValidator = !modelProperty.isOldPojoValidator(statement)
        
        if (identPojo != null) {
        	val identifiers = statement.getAllContentsOfType(typeof(Identifier))
        	val pojo = identPojo
        	val pojoName = identPojoName
        	identifiers.forEach[identifier |
        		//println("identifier for "+pojoName+" "+identifier)
        		checkIdentifier(identifier, pojo, pojoName, statement, newPojoValidator, artifacts, uri, descriptorsCache, classesCache) 
        	]
       	}
        if (indexPojo != null) {
        	val orders = statement.getAllContentsOfType(typeof(OrdSql))
        	val pojo = indexPojo
        	val pojoName = indexPojoName
        	orders.forEach[order |
        		//println("identifier for "+pojoName+" "+identifier)
        		checkOrder(order, pojo, pojoName, statement, newPojoValidator, artifacts, uri, ordersCache, classesCache) 
        	]
        }

        if (colPojo != null) {
        	val columns = statement.getAllContentsOfType(typeof(Column))
        	val pojo = colPojo
        	val pojoName = colPojoName
        	columns.forEach[column |
        		//println("column for "+pojoName+" "+column)
        		checkColumn(column, pojo, pojoName, statement, newPojoValidator, artifacts, uri, descriptorsCache, classesCache) 
        	]
        }

        if (constPojo != null) {
        	val constants = statement.getAllContentsOfType(typeof(Constant))
        	val pojo = constPojo
        	val pojoName = constPojoName
        	constants.forEach[constant |
        		//println("constant for "+pojoName+" "+constant)
        		checkConstant(constant, pojo, pojoName, statement, newPojoValidator, artifacts, uri, descriptorsCache, classesCache) 
        	]
        }
        
        if (isResolveDb(statement))
	        checkTablesColumns(tablesPojo, tablesPrefixPojo, statement)
	}
	
	def checkTablesColumns(TreeMap<String, TableDefinition> tablesPojo, TreeMap<String, TableDefinition> tablesPrefixPojo,
		MetaStatement statement
	) {
       	val tables = statement.getAllContentsOfType(typeof(DatabaseTable))

       	tables.forEach[table |
	        val tableName = table.getName()
	        val tableDefinition = tablesPojo.values.findFirst[it| it.table == tableName] 
	        if (tableDefinition == null || !dbResolver.checkTable(statement, tableName))
	            error("Cannot find table in DB : " + tableName, 
	            	table, ProcessorMetaPackage.Literals.DATABASE_TABLE__NAME)
       	]

       	val columns = statement.getAllContentsOfType(typeof(DatabaseColumn))
       	columns.forEach[column |
	        val pos = column.name.indexOf('.')
	        val prefix = if (pos > 0) column.name.substring(0, pos) else "_DEFAULT_"
	        val columnName = if (pos > 0) column.name.substring(pos + 1) else column.name
	
	        val tableDefinition = tablesPrefixPojo.get(prefix)
	        val tableName = if (tableDefinition != null) tableDefinition.getTable()
	        if (tableName == null || !dbResolver.checkColumn(column, tableName, columnName)) {
	            error("Cannot find column in DB : " + column.getName() + "[" + tableName + "]",
	                    column, ProcessorMetaPackage.Literals.DATABASE_COLUMN__NAME)
	        }
        ]
    }

    def checkIdentifier(Identifier identifier, PojoDefinition pojo, String pojoName, MetaStatement statement, boolean newPojoValidator,
    	Artifacts artifacts, URI uri, Map<String, PropertyDescriptor[]> descriptorsCache, Map<String, Class<?>> classesCache
    ) {
        if (!isResolvePojo(identifier))
            return;

        val identifierName = identifier.name
        val identifierUsageClass = pojo.qualifiedName
        var ValidationResult validationResult
        if (identifierUsageClass != null) {
	        if (newPojoValidator && pojo.classx instanceof JvmDeclaredType)
	        	validationResult = checkClassProperty(pojo.classx as JvmDeclaredType, identifierName)
	        else
	        	validationResult = checkClassProperty(identifierUsageClass, identifierName, uri, descriptorsCache, classesCache)
	        switch (validationResult) {
            case ValidationResult.WARNING:
                warning("Problem property : " + identifierName + "[" + identifierUsageClass + "]",
                        identifier, ProcessorMetaPackage.Literals.IDENTIFIER__NAME)
            case ValidationResult.ERROR:
		        error("Cannot find property : " + identifierName + "[" + identifierUsageClass + "]",
					identifier, ProcessorMetaPackage.Literals.IDENTIFIER__NAME)
            }
            return
		}
        if (pojoResolverFactory.getPojoResolver() != null) {
            error("Cannot check input form attribute : " + identifierName,
                    identifier, ProcessorMetaPackage.Literals.IDENTIFIER__NAME)
        }
    }

    def checkOrder(OrdSql order, PojoDefinition pojo, String pojoName, MetaStatement statement, boolean newPojoValidator,
    	Artifacts artifacts, URI uri, Map<String, Map<String, String>> ordersCache, Map<String, Class<?>> classesCache
    ) {
        if (!isResolvePojo(order))
            return;

        val identifierName = order.ident
        val identifierUsageClass = pojo.qualifiedName
        var ValidationResult validationResult
        if (identifierUsageClass != null) {
        	if (newPojoValidator && pojo.classx instanceof JvmDeclaredType)
	        	validationResult = checkOrderProperty(pojo.classx as JvmDeclaredType, identifierName)
	        else
	        	checkOrderProperty(identifierUsageClass, identifierName, uri, ordersCache, classesCache)
            switch (validationResult) {
            case ValidationResult.WARNING:
                warning("Problem order : " + identifierName + "[" + identifierUsageClass + "]",
                        order, ProcessorMetaPackage.Literals.ORD_SQL__IDENT)
            case ValidationResult.ERROR:
		        warning("Cannot find order : " + identifierName + "[" + identifierUsageClass + "]",
					order, ProcessorMetaPackage.Literals.ORD_SQL__IDENT)
            }
            return
        }

        if (pojoResolverFactory.getPojoResolver() != null) {
            error("Cannot check order identifier : " + identifierName,
                    order, ProcessorMetaPackage.Literals.ORD_SQL__IDENT)
        }
    }

    def checkColumn(Column column, PojoDefinition pojo, String pojoName, MetaStatement statement, boolean newPojoValidator,
    	Artifacts artifacts, URI uri, Map<String, PropertyDescriptor[]> descriptorsCache, Map<String, Class<?>> classesCache
    ) {
        if (!isResolvePojo(column))
            return;
        val columnName = Utils.getName(column)
        if (Utils.isNumber(columnName))
            return;

        val columnUsageClass = if (pojo != null) pojo.qualifiedName
        var ValidationResult validationResult
        if (columnUsageClass != null) {
	        if (newPojoValidator && pojo.classx instanceof JvmDeclaredType)
	        	validationResult = checkClassProperty(pojo.classx as JvmDeclaredType, columnName)
	        else
	        	validationResult = checkClassProperty(columnUsageClass, columnName, uri, descriptorsCache, classesCache)
            switch (validationResult) {
            case ValidationResult.WARNING:
                warning("Problem property : " + columnName + "[" + columnUsageClass + "]",
                        column, ProcessorMetaPackage.Literals.COLUMN__COLUMNS)
            case ValidationResult.ERROR:
            	checkColumnGType(column, columnName, columnUsageClass, statement)
            }
            return
        }

        if (pojoResolverFactory.getPojoResolver() != null) {
            error("Cannot check result class attribute : " + columnName, 
            	column, ProcessorMetaPackage.Literals.COLUMN__COLUMNS
            )
        }
    }
    
    def checkColumnGType(Column column, String columnName, String columnUsageClass, MetaStatement statement) {
    	if (statement.statement == null || statement.statement.sqls == null)
    		return;
    		
    	for (stmt : statement.statement.sqls) {
    		if (stmt.col != null && stmt.col.columns != null && stmt.col.columns != null) {
				for (_col : stmt.col.columns) {
					if (_col.modifiers != null) {
						for (mod : _col.modifiers) {
							if (mod.indexOf('gtype') >= 0) {
				                warning("Problem property : " + columnName + "[" + columnUsageClass + "]",
                			        column, ProcessorMetaPackage.Literals.COLUMN__COLUMNS)
                			    return
							}
						}
					}
				}
    		}
    		if (stmt.meta != null && stmt.meta.ifs != null) {
    			for (ifs : stmt.meta.ifs) {
    				if (ifs.sqls != null) {
				    	for (stmt2 : ifs.sqls) {
				    		if (stmt2.col != null && stmt2.col.columns != null && stmt2.col.columns != null) {
								for (_col : stmt2.col.columns) {
									if (_col.modifiers != null) {
										for (mod : _col.modifiers) {
											if (mod.indexOf('gtype') >= 0) {
								                warning("Problem property : " + columnName + "[" + columnUsageClass + "]",
                			    				    column, ProcessorMetaPackage.Literals.COLUMN__COLUMNS)
                			    				return
											}
										}
									}
								}
				    		}
			    		}
    				}
    			}
    		}
    	}
		error("Cannot find property : " + columnName + "[" + columnUsageClass + "]",
        	column, ProcessorMetaPackage.Literals.COLUMN__COLUMNS)
    }
    
    def checkConstant(Constant constant, PojoDefinition pojo, String pojoName, MetaStatement statement, boolean newPojoValidator,
    	Artifacts artifacts, URI uri, Map<String, PropertyDescriptor[]> descriptorsCache, Map<String, Class<?>> classesCache
    ) {
        if (!isResolvePojo(constant))
            return;

        val constantUsageClass = if (pojo != null) pojo.qualifiedName
        var ValidationResult validationResult
        if (constantUsageClass != null) {
	        if (newPojoValidator && pojo.classx instanceof JvmDeclaredType)
	        	validationResult = checkClassProperty(pojo.classx as JvmDeclaredType, constant.getName())
	        else
	        	validationResult = checkClassProperty(constantUsageClass, constant.getName(), uri, descriptorsCache, classesCache)
            switch (validationResult) {
            case ValidationResult.WARNING:
                warning("Problem property : " + constant.getName() + "[" + constantUsageClass + "]",
                        constant, ProcessorMetaPackage.Literals.CONSTANT__NAME)
            case ValidationResult.ERROR:
                error("Cannot find property : " + constant.getName() + "[" + constantUsageClass + "]",
                        constant, ProcessorMetaPackage.Literals.CONSTANT__NAME)
            }
            return
        }

        if (pojoResolverFactory.getPojoResolver() != null) {
            error("Cannot check constant form attribute : " + constant.getName(),
                    ProcessorMetaPackage.Literals.CONSTANT__NAME)
        }
    }

    @Check
    def checkMappingRule(MappingRule rule) {
        if (rule.getModifiers() == null || rule.getModifiers().isEmpty())
            return;
        if (CommonUtils.skipVerification(rule, modelProperty))
            return;
        val artifacts = getArtifacts(rule)
        if (artifacts == null)
            return;
        val URI uri = rule.eResource?.URI
        val Map<String, PropertyDescriptor[]> descriptorsCache = new HashMap<String, PropertyDescriptor[]>() 
        val Map<String, Class<?>> classesCache = new HashMap<String, Class<?>>()

        var index = 0
        var String colPojoName
        var PojoDefinition colPojo
        for (String modifier : rule.getModifiers()) {
            var ix = modifier.indexOf('=')
            if (ix > 0) {
	            val key = modifier.substring(0, ix)
	            val value = modifier.substring(ix + 1)
	            if (MAPPING_USAGE.equals(key)) {
	            	colPojo = modelProperty.getModelPojos(artifacts).get(value)
	                if (colPojo == null) {
	                    error("Cannot find pojo : " + value + "[" + MAPPING_USAGE + "]",
	                            ProcessorMetaPackage.Literals.MAPPING_RULE__MODIFIERS, index)
	                }
	                else
	                	colPojoName = value
	            }
	            index = index + 1
	        }
        }

        if (colPojo != null) {
        	val boolean newPojoValidator = !modelProperty.isOldPojoValidator(rule)
        	val columns = rule.getAllContentsOfType(typeof(MappingColumn))
        	val pojo = colPojo
        	val pojoName = colPojoName
        	columns.forEach[column |
        		//println("mapping column for "+pojoName+" "+column)
        		checkMappingColumn(column, pojo, pojoName, rule, newPojoValidator, artifacts, uri, descriptorsCache, classesCache) 
        	]
        }
    }

    def checkMappingColumn(MappingColumn column, PojoDefinition pojo, String pojoName, MappingRule rule, boolean newPojoValidator,
    	Artifacts artifacts, URI uri, Map<String, PropertyDescriptor[]> descriptorsCache, Map<String, Class<?>> classesCache
    ) {
        if (!isResolvePojo(column))
            return;
        val columnName = Utils.getName(column)
        if (Utils.isNumber(columnName))
            return;

        val mappingUsageClass = pojo.qualifiedName
        var ValidationResult validationResult
        if (mappingUsageClass != null) {
	        if (newPojoValidator && pojo.classx instanceof JvmDeclaredType)
	        	validationResult = checkClassProperty(pojo.classx as JvmDeclaredType, columnName)
	        else
	        	validationResult = checkClassProperty(mappingUsageClass, columnName, uri, descriptorsCache, classesCache)
            switch (validationResult) {
            case ValidationResult.WARNING:
                warning("Problem property : " + columnName + "[" + mappingUsageClass + "]",
                        column, ProcessorMetaPackage.Literals.MAPPING_COLUMN__ITEMS)
            case ValidationResult.ERROR:
				error("Cannot find property : " + columnName + "[" + mappingUsageClass + "]",
        			column, ProcessorMetaPackage.Literals.MAPPING_COLUMN__ITEMS)
            }
            return
        }

        if (pojoResolverFactory.getPojoResolver() != null) {
            error("Cannot check result class attribute : " + columnName,
                    column, ProcessorMetaPackage.Literals.MAPPING_COLUMN__ITEMS)
        }
    }

    def ValidationResult checkClassProperty(String className, String property, URI uri, 
    	Map<String, PropertyDescriptor[]> descriptorsCache, Map<String, Class<?>> classesCache
    ) {
        if (property == null || Utils.isNumber(property) || pojoResolverFactory.getPojoResolver() == null)
            return ValidationResult.OK
        if (className == null)
            return ValidationResult.ERROR
        //println(">>> "+className+" "+property+" "+uri)
        var descriptors = descriptorsCache.get(uri.toString()+className)
        if (descriptors == null)
        	descriptors = pojoResolverFactory.getPojoResolver().getPropertyDescriptors(className, uri)
        //println("<<< "+descriptors)
        if (descriptors == null)
            return ValidationResult.WARNING
        else
        	descriptorsCache.put(uri.toString()+className, descriptors)
        	
        var checkProperty = property
        var pos1 = checkProperty.indexOf('=')
        if (pos1 > 0) {
            var pos2 = checkProperty.indexOf('.', pos1)
            if (pos2 > pos1)
                checkProperty = checkProperty.substring(0, pos1) + checkProperty.substring(pos2)
        }
        var innerProperty = null as String
        pos1 = checkProperty.indexOf('.')
        if (pos1 > 0) {
            innerProperty = checkProperty.substring(pos1 + 1)
            checkProperty = checkProperty.substring(0, pos1)
        }
        val _checkProperty = checkProperty
        var checkDesriptor = descriptors.findFirst[descriptor |
            descriptor.name == _checkProperty
        ]
        if (checkDesriptor == null) {
            var clazz = classesCache.get(uri.toString()+className)
            if (clazz == null)
            	clazz = pojoResolverFactory.getPojoResolver().loadClass(className, uri)
            if (clazz != null && Modifier.isAbstract(clazz.getModifiers()))
                return ValidationResult.WARNING
            if (clazz != null && isPrimitive(clazz))
            	return ValidationResult.OK
            return ValidationResult.ERROR
        }
        if (innerProperty != null) {
            var innerClass = checkDesriptor.getPropertyType()
            if (innerClass.isArray()) {
                val type = checkDesriptor.getReadMethod().getGenericReturnType() as ParameterizedType
                if (type.getActualTypeArguments() == null || type.getActualTypeArguments().length == 0)
                    return ValidationResult.WARNING
                innerClass = type.getActualTypeArguments().head as Class<?>
                if (isPrimitive(innerClass))
                    return ValidationResult.ERROR
                return checkClassProperty(innerClass.getName(), innerProperty, uri, descriptorsCache, classesCache)
            } else if (typeof(Collection).isAssignableFrom(innerClass)) {
                val type = checkDesriptor.getReadMethod().getGenericReturnType() as ParameterizedType
                if (type.getActualTypeArguments() == null || type.getActualTypeArguments().length == 0)
                    return ValidationResult.WARNING
                innerClass = type.getActualTypeArguments().head as Class<?>
                if (isPrimitive(innerClass))
                    return ValidationResult.ERROR
                return checkClassProperty(innerClass.getName(), innerProperty, uri, descriptorsCache, classesCache)
            } else {
                if (isPrimitive(innerClass))
                    return ValidationResult.ERROR
                return checkClassProperty(innerClass.getName(), innerProperty, uri, descriptorsCache, classesCache)
            }
        }
        return ValidationResult.OK
    }


    def ValidationResult checkClassProperty(JvmDeclaredType jvmType, String property) {
        if (property == null || Utils.isNumber(property))
            return ValidationResult.OK
        if (jvmType == null)
            return ValidationResult.ERROR
        	
        var checkProperty = property
        var pos1 = checkProperty.indexOf('=')
        if (pos1 > 0) {
            var pos2 = checkProperty.indexOf('.', pos1)
            if (pos2 > pos1)
                checkProperty = checkProperty.substring(0, pos1) + checkProperty.substring(pos2)
        }
        var innerProperty = null as String
        pos1 = checkProperty.indexOf('.')
        if (pos1 > 0) {
            innerProperty = checkProperty.substring(pos1 + 1)
            checkProperty = checkProperty.substring(0, pos1)
        }
        var Iterable<JvmFeature> features = jvmType.findAllFeaturesByName(checkProperty)
        if (features == null || features.empty || !(features.head instanceof JvmField))
        	features = jvmType.findAllFeaturesByName("get"+checkProperty.toFirstUpper)
        if (features == null || features.empty || (!(features.head instanceof JvmOperation) && !(features.head instanceof JvmField))) {
        	if (jvmType instanceof JvmPrimitiveType || isPrimitive(jvmType.qualifiedName))
        		return ValidationResult.OK
        	if (jvmType.abstract)
        		return ValidationResult.WARNING
        	return ValidationResult.ERROR
        }
        if (innerProperty != null) {
        	if (features.head instanceof JvmOperation)
        		return ValidationResult.ERROR
        	var JvmField field = features.head as JvmField
        	if (field.type instanceof JvmParameterizedTypeReference) {
	        	val JvmType type = (field.type as JvmParameterizedTypeReference).type
//	        	if (!(type instanceof JvmDeclaredType) && type.eIsProxy())
//	        		type = EcoreUtil.resolve(type, jvmType) as JvmType
	        	if (!(type instanceof JvmDeclaredType)) {
		        	print("checkClassProperty "+property+": ")
		        	println(type)
	        	}
	        	else {
					val List<JvmTypeReference> typeArgs = (field.type as JvmParameterizedTypeReference).getArguments()
					if (typeArgs != null && !typeArgs.empty && typeArgs.head instanceof JvmParameterizedTypeReference) {
						val JvmType type2 = (typeArgs.head as JvmParameterizedTypeReference).type
						if (!(type2 instanceof JvmDeclaredType)) {
		        			print("checkClassProperty2 "+property+": ")
		        			println(type2)
	        			}
						else
		        			return checkClassProperty(type2 as JvmDeclaredType, innerProperty)
					}
					else
	        			return checkClassProperty(type as JvmDeclaredType, innerProperty)
        		}
        	}
			return ValidationResult.WARNING
        }
        return ValidationResult.OK
    }

    def Set<String> getFieldNamesForClass(JvmDeclaredType jvmType) {
      val Set<String> result = <String>newHashSet();
      for (JvmField field : jvmType.getDeclaredFields()) {
        result.add(field.getSimpleName());
      }
      return result;
    }
    
    def ValidationResult checkOrderProperty(String className, String property, URI uri, 
    	Map<String, Map<String, String>> ordersCache, Map<String, Class<?>> classesCache
    ) {
        if (property == null || pojoResolverFactory.getPojoResolver() == null)
            return ValidationResult.OK
        if (className == null)
            return ValidationResult.ERROR
        //println(">>> "+className+" "+property+" "+uri)
        var orders = ordersCache.get(uri.toString()+className)
        if (orders == null)
        	orders = pojoResolverFactory.getPojoResolver().getOrders(className, uri)
        //println("<<< "+descriptors)
        if (orders == null)
            return ValidationResult.WARNING
        else
        	ordersCache.put(uri.toString()+className, orders)
        
        val _orders = orders
        val order = orders.keySet.findFirst[k |
        	_orders.get(k).equals(property)
        ]

        if (order != null) 
        	return ValidationResult.OK 
        else 
        	return ValidationResult.ERROR 
    }
    
    def ValidationResult checkOrderProperty(JvmDeclaredType jvmType, String property) {
        if (property == null)
            return ValidationResult.OK
        if (jvmType == null)
            return ValidationResult.ERROR
        val Iterable<JvmFeature> features = jvmType.findAllFeaturesByName("ORDER_BY_" + property)
        if (features == null || features.empty || !(features.head instanceof JvmField)) {
        	val Iterable<JvmDeclaredType> nestedTypes = jvmType.findAllNestedTypesByName("Order");
        	if (nestedTypes == null || nestedTypes.empty || !(nestedTypes.head instanceof JvmEnumerationType))
	        	return ValidationResult.ERROR
	        val JvmEnumerationType type = nestedTypes.head as JvmEnumerationType
	        val Iterable<JvmFeature> features2 = type.findAllFeaturesByName(property)
	        if (features2 == null || features2.empty || !(features2.head instanceof JvmEnumerationLiteral))
	        	return ValidationResult.ERROR
        }
        return ValidationResult.OK 
    }

    @Check
    def checkTableDefinition(TableDefinitionModel tableDefinition) {
        if (CommonUtils.skipVerification(tableDefinition, modelProperty))
            return;
        val artifacts = getArtifacts(tableDefinition)
        if (artifacts == null)
            return;

        for (TableDefinitionModel table : artifacts.getTables()) {
            if (table != null && table !== tableDefinition) {
	            if (tableDefinition.getName().equals(table.getName())) {
	                error("Duplicate name : " + tableDefinition.getName() + "[table]",
	                        ProcessorMetaPackage.Literals.TABLE_DEFINITION_MODEL__NAME)
	                return
				}
	           }
        }
        if (isResolveDb(tableDefinition) && !dbResolver.checkTable(tableDefinition, tableDefinition.getTable())) {
            error("Cannot find table in DB : " + tableDefinition.getTable(),
                    ProcessorMetaPackage.Literals.TABLE_DEFINITION_MODEL__TABLE)
        }
    }

    @Check
    def checkProcedureDefinition(ProcedureDefinitionModel procedureDefinition) {
        if (CommonUtils.skipVerification(procedureDefinition, modelProperty))
            return;
        val artifacts = getArtifacts(procedureDefinition)
        if (artifacts == null)
            return;

        for (ProcedureDefinitionModel procedure : artifacts.getProcedures()) {
            if (procedure != null && procedure !== procedureDefinition) {
	            if (procedureDefinition.getName().equals(procedure.getName())) {
	                error("Duplicate name : " + procedureDefinition.getName() + "[procedure]",
	                        ProcessorMetaPackage.Literals.PROCEDURE_DEFINITION_MODEL__NAME)
	                return
	            }
	        }
        }
        if (isResolveDb(procedureDefinition)
                && !dbResolver.checkProcedure(procedureDefinition, procedureDefinition.getTable())) {
            error("Cannot find procedure in DB : " + procedureDefinition.getTable(),
                    ProcessorMetaPackage.Literals.PROCEDURE_DEFINITION_MODEL__NAME)
        }
    }

    @Check
    def checkFunctionDefinition(FunctionDefinitionModel functionDefinition) {
        if (CommonUtils.skipVerification(functionDefinition, modelProperty))
            return;
        val artifacts = getArtifacts(functionDefinition)
        if (artifacts == null)
            return;

        for (FunctionDefinitionModel function : artifacts.getFunctions()) {
            if (function != null && function !== functionDefinition) {
	            if (functionDefinition.getName().equals(function.getName())) {
	                error("Duplicate name : " + functionDefinition.getName() + "[function]",
	                        ProcessorMetaPackage.Literals.FUNCTION_DEFINITION_MODEL__NAME)
	                return
	            }
	    	}
        }
    }
    
	//@Check
    def _checkDatabaseTable(DatabaseTable databaseTable) {
        if (!isResolveDb(databaseTable))
            return;
        if (CommonUtils.skipVerification(databaseTable, modelProperty))
            return;

        val statement = databaseTable.getContainerOfType(typeof(MetaStatement))
        val artifacts = getArtifacts(statement)
        if (artifacts == null)
            return;

        val tableName = databaseTable.getName()
        val tableDefinitions = Utils.getTokensFromModifier(statement, TABLE_USAGE).map[value |
        	modelProperty.getModelTables(artifacts).get(value)
        ]
        val tableDefinition = tableDefinitions.findFirst[it | it.table == tableName] 
        if (tableDefinition == null || !dbResolver.checkTable(databaseTable, tableName)) {
            error("Cannot find table in DB : " + tableName, ProcessorMetaPackage.Literals.DATABASE_TABLE__NAME)
        }
    }
    
    //@Check
    def _checkDatabaseColumn(DatabaseColumn databaseColumn) {
        if (!isResolveDb(databaseColumn))
            return;
        if (CommonUtils.skipVerification(databaseColumn, modelProperty))
            return;
            
        var prefix = databaseColumn.getName()
        var columnName = null as String
        val pos = prefix.indexOf('.')
        if (pos > 0) {
            prefix = databaseColumn.getName().substring(0, pos)
            columnName = databaseColumn.getName().substring(pos + 1)
        } else {
            prefix = null
            columnName = databaseColumn.getName()
        }

        val statement = databaseColumn.getContainerOfType(typeof(MetaStatement))
        val artifacts = getArtifacts(statement)
        if (artifacts == null)
            return;

        val value = Utils.getTokenFromModifier(statement, TABLE_USAGE, prefix)
        val tableDefinition = if (value != null) modelProperty.getModelTables(artifacts).get(value)
        val tableName = if (tableDefinition != null) tableDefinition.getTable()
        if (tableName == null || !dbResolver.checkColumn(databaseColumn, tableName, columnName)) {
            error("Cannot find column in DB : " + databaseColumn.getName() + "[" + tableName + "]",
                    ProcessorMetaPackage.Literals.DATABASE_COLUMN__NAME)
        }
    }
    
    def Artifacts getArtifacts(EObject model) {
        val root = model.rootContainer
        if (!(root instanceof Artifacts))
            return null;
        return root as Artifacts
    }

    def isPrimitive(Class<?> clazz) {
        if (clazz == null)
            return true
        if (clazz == typeof(String))
            return true
        if (clazz == typeof(Byte))
            return true
        if (clazz == typeof(Short))
            return true
        if (clazz == typeof(Integer))
            return true
        if (clazz == typeof(Long))
            return true
        if (clazz == typeof(Double))
            return true
        if (clazz == typeof(Float))
            return true
        if (clazz == typeof(Boolean))
            return true
        if (clazz == typeof(java.util.Date))
            return true
        if (clazz == typeof(java.sql.Date))
            return true
        if (clazz == typeof(java.sql.Time))
            return true
        if (clazz == typeof(java.sql.Timestamp))
            return true
        if (clazz == typeof(java.sql.Blob))
            return true
        if (clazz == typeof(java.sql.Clob))
            return true
        if (clazz == typeof(java.math.BigDecimal))
            return true
        if (clazz == typeof(java.math.BigInteger))
            return true
        return false
    }

    def isPrimitive(String name) {
        if (name == null)
            return true
        if (name == 'java.lang.String')
            return true
        if (name == 'java.lang.Byte')
            return true
        if (name == 'java.lang.Short')
            return true
        if (name == 'java.lang.Integer')
            return true
        if (name == 'java.lang.Long')
            return true
        if (name == 'java.lang.Double')
            return true
        if (name == 'java.lang.Float')
            return true
        if (name == 'java.lang.Boolean')
            return true
        if (name == 'java.util.Date')
            return true
        if (name == 'java.sql.Date')
            return true
        if (name == 'java.sql.Time')
            return true
        if (name == 'java.sql.Timestamp')
            return true
        if (name == 'java.sql.Blob')
            return true
        if (name == 'java.sql.Clob')
            return true
        if (name == 'java.math.BigDecimal')
            return true
        if (name == 'java.math.BigInteger')
            return true
        return false
    }

    def isResolvePojo(EObject model) {
        modelProperty.isDoResolvePojo(model)
    }

    def isResolveDb(EObject model) {
        return dbResolver.isResolveDb(model)
    }
}
