/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.plugin.lib.util;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Debug {
    String logScope = null;
    Logger logger = null;
    Boolean doSysout = false;

    public Debug(Logger LOGGER) {
        this.logger = LOGGER;
    }

    public Debug(String debugLevel, String debugScope, Logger LOGGER) {
        if ("DEBUG".equals(debugLevel)) {
            LOGGER.setLevel(Level.DEBUG);
        }
        if ("TRACE".equals(debugLevel)) {
            LOGGER.setLevel(Level.TRACE);
        }
        if ("INFO".equals(debugLevel)) {
            LOGGER.setLevel(Level.INFO);
        }
        if ("WARN".equals(debugLevel)) {
            LOGGER.setLevel(Level.WARN);
        }
        if ("debug".equals(debugLevel)) {
            LOGGER.setLevel(Level.DEBUG);
        }
        if ("trace".equals(debugLevel)) {
            LOGGER.setLevel(Level.TRACE);
        }
        if ("info".equals(debugLevel)) {
            LOGGER.setLevel(Level.INFO);
        }
        if ("warn".equals(debugLevel)) {
            LOGGER.setLevel(Level.WARN);
        }
        this.logScope = debugScope != null ? debugScope.toUpperCase() : null;
        this.logger = LOGGER;
    }

    public boolean isDebug() {
        return this.logger.isDebugEnabled();
    }

    public void trace(String msg) {
        if (this.logger.isTraceEnabled()) {
            if (this.doSysout.booleanValue()) {
                System.out.println(msg);
            } else {
                this.logger.trace((Object)msg);
            }
        }
    }

    public void trace(String scope, String msg) {
        if (!this.isScopeActive(scope)) {
            return;
        }
        if (this.logger.isTraceEnabled()) {
            if (this.doSysout.booleanValue()) {
                System.out.println(scope + " " + msg);
            } else {
                this.logger.trace((Object)(scope + " " + msg));
            }
        }
    }

    public void trace(String scope, String msg, Object object) {
        if (!this.isScopeActive(scope)) {
            return;
        }
        if (this.logger.isTraceEnabled()) {
            if (this.doSysout.booleanValue()) {
                System.out.println(scope + " " + msg + " " + String.valueOf(object));
            } else {
                this.logger.trace((Object)(scope + " " + msg + " " + String.valueOf(object)));
            }
        }
    }

    public void debug(String msg) {
        if (this.logger.isDebugEnabled()) {
            if (this.doSysout.booleanValue()) {
                System.out.println(msg);
            } else {
                this.logger.debug((Object)msg);
            }
        }
    }

    public void debug(String scope, String msg) {
        if (!this.isScopeActive(scope)) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            if (this.doSysout.booleanValue()) {
                System.out.println(scope + " " + msg);
            } else {
                this.logger.debug((Object)(scope + " " + msg));
            }
        }
    }

    public void debug(String scope, String msg, Object object) {
        if (!this.isScopeActive(scope)) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            if (this.doSysout.booleanValue()) {
                System.out.println(scope + " " + msg + " " + String.valueOf(object));
            } else {
                this.logger.debug((Object)(scope + " " + msg + " " + String.valueOf(object)));
            }
        }
    }

    public void info(String scope, String msg) {
        if (!this.isScopeActive(scope)) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            if (this.doSysout.booleanValue()) {
                System.out.println(scope + " " + msg);
            } else {
                this.logger.info((Object)(scope + " " + msg));
            }
        }
    }

    public void info(String msg) {
        if (this.logger.isInfoEnabled()) {
            if (this.doSysout.booleanValue()) {
                System.out.println(msg);
            } else {
                this.logger.info((Object)msg);
            }
        }
    }

    public void warn(String msg) {
        if (this.doSysout.booleanValue()) {
            System.out.println(msg);
        } else {
            this.logger.info((Object)msg);
        }
    }

    public void error(String msg, Exception e) {
        if (this.doSysout.booleanValue()) {
            System.out.println(msg + " " + e.getMessage());
            e.printStackTrace();
        } else {
            this.logger.error((Object)msg, (Throwable)e);
        }
    }

    public void error(String msg) {
        if (this.doSysout.booleanValue()) {
            System.out.println(msg);
        } else {
            this.logger.error((Object)msg);
        }
    }

    private boolean isScopeActive(String m) {
        if (this.logScope == null || m == null) {
            return true;
        }
        return this.logScope.indexOf(m.toUpperCase()) >= 0;
    }
}

