/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.meta.scoping;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.access.ClasspathTypeProviderFactory;
import org.eclipse.xtext.common.types.access.impl.ClasspathTypeProvider;
import org.eclipse.xtext.common.types.access.impl.TypeResourceServices;
import org.sqlproc.plugin.lib.resolver.PojoClassLoader;
import org.sqlproc.plugin.lib.resolver.ProcessorClassLoader;
import org.sqlproc.plugin.lib.util.MainUtils;

public class ProcessorMetaClasspathTypeProviderFactory
extends ClasspathTypeProviderFactory
implements PojoClassLoader {
    protected Logger LOGGER = Logger.getLogger(ProcessorMetaClasspathTypeProviderFactory.class);
    @Inject
    ProcessorClassLoader processorClassLoader;
    private Map<ResourceSet, ClassLoader> loaders = new HashMap<ResourceSet, ClassLoader>();

    @Inject
    public ProcessorMetaClasspathTypeProviderFactory(ClassLoader classLoader, TypeResourceServices services) {
        super(classLoader, services);
    }

    protected ClasspathTypeProvider createClasspathTypeProvider(ResourceSet resourceSet) {
        ClasspathTypeProvider classpathTypeProvider = super.createClasspathTypeProvider(resourceSet);
        this.processorClassLoader.setPojoClassLoader(this);
        this.loaders.put(resourceSet, this.getClassLoader(resourceSet));
        return classpathTypeProvider;
    }

    @Override
    public Class<?> loadClass(Resource resource, String name) {
        this.LOGGER.info((Object)("loadClass, resource=" + String.valueOf(resource) + ", name=" + name));
        if (resource == null) {
            return null;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        ClassLoader classLoader = this.loaders.get(resourceSet);
        if (classLoader == null) {
            this.LOGGER.warn((Object)("Can't find classloader for '" + String.valueOf(resource) + "'"));
            return null;
        }
        try {
            return classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            this.LOGGER.warn((Object)("Can't load class for '" + name + "': " + e.getMessage()));
            return null;
        }
    }

    @Override
    public InputStream loadFile(Resource resource, String filename) {
        if (resource == null) {
            return null;
        }
        String sResource = resource.getURI().toString();
        int ix = sResource.lastIndexOf(File.separator);
        String source = ix >= 0 ? sResource.substring(0, ix + 1) : "";
        File file = new File(MainUtils.getFile(source, filename));
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.LOGGER.warn((Object)("Can't find file '" + filename + "' in project"));
            return null;
        }
    }
}

