/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.sqlproc.dsl.ImportManager;
import org.sqlproc.dsl.processorDsl.AbstractPojoEntity;
import org.sqlproc.dsl.processorDsl.AnnotatedEntity;
import org.sqlproc.dsl.processorDsl.AnnotationProperty;
import org.sqlproc.dsl.processorDsl.Artifacts;
import org.sqlproc.dsl.processorDsl.Column;
import org.sqlproc.dsl.processorDsl.DescendantAssignment;
import org.sqlproc.dsl.processorDsl.EnumEntity;
import org.sqlproc.dsl.processorDsl.EnumProperty;
import org.sqlproc.dsl.processorDsl.EnumPropertyValue;
import org.sqlproc.dsl.processorDsl.ExtendedColumn;
import org.sqlproc.dsl.processorDsl.ExtendedMappingItem;
import org.sqlproc.dsl.processorDsl.FunctionDefinition;
import org.sqlproc.dsl.processorDsl.MappingColumn;
import org.sqlproc.dsl.processorDsl.MappingRule;
import org.sqlproc.dsl.processorDsl.MetaStatement;
import org.sqlproc.dsl.processorDsl.Package;
import org.sqlproc.dsl.processorDsl.PackageDirective;
import org.sqlproc.dsl.processorDsl.PackageDirectiveImplementation;
import org.sqlproc.dsl.processorDsl.PackageDirectiveSuffix;
import org.sqlproc.dsl.processorDsl.PojoAnnotatedProperty;
import org.sqlproc.dsl.processorDsl.PojoDao;
import org.sqlproc.dsl.processorDsl.PojoDefinition;
import org.sqlproc.dsl.processorDsl.PojoEntity;
import org.sqlproc.dsl.processorDsl.PojoProperty;
import org.sqlproc.dsl.processorDsl.ProcedureDefinition;
import org.sqlproc.dsl.processorDsl.TableDefinition;
import org.sqlproc.dsl.resolver.DbResolver;

public class Utils {
    public static EnumEntity enumEntity(AnnotatedEntity e) {
        if (e.getEntity() instanceof EnumEntity) {
            return (EnumEntity)e.getEntity();
        }
        return null;
    }

    public static PojoEntity pojoEntity(AnnotatedEntity e) {
        if (e.getEntity() instanceof PojoEntity) {
            return (PojoEntity)e.getEntity();
        }
        return null;
    }

    public static String getAnnotationValue(AnnotationProperty a) {
        String value = a.getNumber();
        if (value != null) {
            return value;
        }
        value = a.getValue();
        if (value != null) {
            return value;
        }
        value = a.getConstant();
        if (value != null) {
            value = value.replaceAll("___", ".");
        }
        if (a.getType() != null || a.getRef() != null) {
            return "." + value;
        }
        return value;
    }

    public static String resourceDir(Resource resource) {
        String uri = resource.getURI() != null ? resource.getURI().toString() : null;
        String dir = null;
        if (uri != null) {
            dir = uri;
            int ix = uri.lastIndexOf("/");
            if (ix > 0) {
                dir = uri.substring(0, ix);
            }
        }
        return dir;
    }

    public static boolean hasName(PojoProperty f, String name) {
        return f.getName().equals(name);
    }

    public static String getTokenFromModifier(MetaStatement statement, String tokenName) {
        if (statement.getModifiers() == null || statement.getModifiers().isEmpty()) {
            return null;
        }
        for (String filter : statement.getModifiers()) {
            int ix = filter.indexOf(61);
            if (ix <= 0) continue;
            String key = filter.substring(0, ix);
            String val = filter.substring(ix + 1);
            if (!key.equals(tokenName)) continue;
            return val;
        }
        return null;
    }

    public static String getTokenFromModifier(MappingRule rule, String tokenName) {
        if (rule.getModifiers() == null || rule.getModifiers().isEmpty()) {
            return null;
        }
        for (String filter : rule.getModifiers()) {
            int ix = filter.indexOf(61);
            if (ix <= 0) continue;
            String key = filter.substring(0, ix);
            String val = filter.substring(ix + 1);
            if (!key.equals(tokenName)) continue;
            return val;
        }
        return null;
    }

    public static String getTokenFromModifier(MetaStatement statement, String tokenName, String tokenSuffix) {
        if (statement.getModifiers() == null || statement.getModifiers().isEmpty()) {
            return null;
        }
        for (String filter : statement.getModifiers()) {
            int ix = filter.indexOf(61);
            if (ix <= 0) continue;
            String key = filter.substring(0, ix);
            String val = filter.substring(ix + 1);
            if (tokenSuffix != null) {
                int ix2 = val.indexOf(61);
                if (ix2 <= 0 || !tokenSuffix.equals(val.substring(ix2 + 1))) continue;
                val = val.substring(0, ix2);
            }
            if (!key.equals(tokenName)) continue;
            return val;
        }
        return null;
    }

    public static List<String> getTokensFromModifier(MetaStatement statement, String tokenName) {
        ArrayList<String> result = new ArrayList<String>();
        if (statement.getModifiers() == null || statement.getModifiers().isEmpty()) {
            return result;
        }
        for (String filter : statement.getModifiers()) {
            int ix = filter.indexOf(61);
            if (ix <= 0) continue;
            String key = filter.substring(0, ix);
            String val = filter.substring(ix + 1);
            int ix2 = val.indexOf(61);
            String string = val = ix2 > 0 ? val.substring(0, ix2) : val;
            if (!key.equals(tokenName)) continue;
            result.add(val);
        }
        return result;
    }

    public static PojoEntity findEntity(IQualifiedNameConverter qualifiedNameConverter, Artifacts artifacts, IScope scope, String name) {
        Iterable iterable = scope.getAllElements();
        for (IEObjectDescription description : iterable) {
            Package packageDeclaration = (Package)artifacts.eResource().getResourceSet().getEObject(description.getEObjectURI(), true);
            for (AbstractPojoEntity aEntity : packageDeclaration.getElements()) {
                PojoEntity entity;
                AnnotatedEntity ae;
                if (!(aEntity instanceof AnnotatedEntity) || !((ae = (AnnotatedEntity)aEntity).getEntity() instanceof PojoEntity) || !name.equals((entity = (PojoEntity)ae.getEntity()).getName())) continue;
                return entity;
            }
        }
        return null;
    }

    public static PojoDefinition findPojo(IQualifiedNameConverter qualifiedNameConverter, Artifacts artifacts, IScope scope, String name) {
        Iterable iterable = scope.getAllElements();
        for (IEObjectDescription description : iterable) {
            if ((qualifiedNameConverter == null || !qualifiedNameConverter.toQualifiedName(name).equals((Object)description.getName())) && !name.equals(description.getName().toString())) continue;
            return (PojoDefinition)artifacts.eResource().getResourceSet().getEObject(description.getEObjectURI(), true);
        }
        return null;
    }

    public static TableDefinition findTable(IQualifiedNameConverter qualifiedNameConverter, Artifacts artifacts, IScope scope, String name) {
        Iterable iterable = scope.getAllElements();
        for (IEObjectDescription description : iterable) {
            if ((qualifiedNameConverter == null || !qualifiedNameConverter.toQualifiedName(name).equals((Object)description.getName())) && !name.equals(description.getName().toString())) continue;
            return (TableDefinition)artifacts.eResource().getResourceSet().getEObject(description.getEObjectURI(), true);
        }
        return null;
    }

    public static List<String> findTables(IQualifiedNameConverter qualifiedNameConverter, Artifacts artifacts, IScope scope) {
        ArrayList<String> names = new ArrayList<String>();
        Iterable iterable = scope.getAllElements();
        for (IEObjectDescription description : iterable) {
            EObject obj = artifacts.eResource().getResourceSet().getEObject(description.getEObjectURI(), true);
            if (!(obj instanceof TableDefinition)) continue;
            names.add(((TableDefinition)obj).getTable());
        }
        return names;
    }

    public static List<String> findFunctions(IQualifiedNameConverter qualifiedNameConverter, Artifacts artifacts, IScope scope) {
        ArrayList<String> names = new ArrayList<String>();
        Iterable iterable = scope.getAllElements();
        for (IEObjectDescription description : iterable) {
            EObject obj = artifacts.eResource().getResourceSet().getEObject(description.getEObjectURI(), true);
            if (!(obj instanceof FunctionDefinition)) continue;
            names.add(((FunctionDefinition)obj).getTable());
        }
        return names;
    }

    public static List<String> findProcedures(IQualifiedNameConverter qualifiedNameConverter, Artifacts artifacts, IScope scope) {
        ArrayList<String> names = new ArrayList<String>();
        Iterable iterable = scope.getAllElements();
        for (IEObjectDescription description : iterable) {
            EObject obj = artifacts.eResource().getResourceSet().getEObject(description.getEObjectURI(), true);
            if (!(obj instanceof ProcedureDefinition)) continue;
            names.add(((ProcedureDefinition)obj).getTable());
        }
        return names;
    }

    public static String constName(PojoProperty f) {
        return Utils.constName(f.getName());
    }

    public static String constName(List<PojoProperty> l) {
        StringBuilder result = new StringBuilder("");
        boolean first = true;
        for (PojoProperty p : l) {
            if (first) {
                first = false;
            } else {
                result.append("_");
            }
            result.append(Utils.constName(p.getName()));
        }
        return result.toString();
    }

    public static String constName(String name) {
        String result = "";
        int last = 0;
        int i = 0;
        int l = name.length();
        while (i < l) {
            if (Character.isUpperCase(name.charAt(i))) {
                result = String.valueOf(result) + name.substring(last, i).toUpperCase() + "_";
                last = i;
            }
            ++i;
        }
        if (last < name.length()) {
            result = String.valueOf(result) + name.substring(last).toUpperCase();
        }
        return result;
    }

    public static String dbName(PojoEntity e) {
        String result = "";
        int last = 0;
        boolean lastDigit = false;
        int i = 0;
        int l = e.getName().length();
        while (i < l) {
            char c = e.getName().charAt(i);
            if (Character.isUpperCase(c) || Character.isDigit(c) && !lastDigit) {
                result = String.valueOf(result) + e.getName().substring(last, i).toUpperCase() + "_";
                last = i;
            }
            lastDigit = Character.isDigit(c);
            ++i;
        }
        if (last < e.getName().length()) {
            result = String.valueOf(result) + e.getName().substring(last).toUpperCase();
        }
        return result.startsWith("_") ? result.substring(1) : result;
    }

    public static String dbName(PojoDao e) {
        String name = StringExtensions.toFirstLower((String)e.getName());
        if (name.endsWith("Dao")) {
            name = name.substring(0, name.length() - 3);
        }
        String result = "";
        int last = 0;
        boolean lastDigit = false;
        int i = 0;
        int l = name.length();
        while (i < l) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c) || Character.isDigit(c) && !lastDigit) {
                result = String.valueOf(result) + e.getName().substring(last, i).toUpperCase() + "_";
                last = i;
            }
            lastDigit = Character.isDigit(c);
            ++i;
        }
        if (last < name.length()) {
            result = String.valueOf(result) + name.substring(last).toUpperCase();
        }
        return result.startsWith("_") ? result.substring(1) : result;
    }

    public static String getPackage(PojoEntity e) {
        Package packageDeclaration = (Package)EcoreUtil2.getContainerOfType((EObject)e, Package.class);
        if (packageDeclaration == null) {
            System.out.println("XXXXXXXXXX " + e.getName());
        }
        return packageDeclaration.getName();
    }

    public static String getFullName(PojoEntity e1, PojoEntity e2, QualifiedName qn2, ImportManager im) {
        String pkg2;
        String sqn = qn2.toString();
        if (sqn.indexOf(".") > 0) {
            return sqn;
        }
        String pkg1 = Utils.getPackage(e1);
        if (!pkg1.equals(pkg2 = Utils.getPackage(e2))) {
            im.addImportFor(e2);
        }
        return sqn;
    }

    public static String getPackage(EnumEntity e) {
        Package packageDeclaration = (Package)EcoreUtil2.getContainerOfType((EObject)e, Package.class);
        return packageDeclaration.getName();
    }

    public static String getFullName(EnumEntity e1, PojoEntity e2, QualifiedName qn2, ImportManager im) {
        String pkg2;
        String sqn = qn2.toString();
        if (sqn.indexOf(".") > 0) {
            return sqn;
        }
        String pkg1 = Utils.getPackage(e1);
        if (!pkg1.equals(pkg2 = Utils.getPackage(e2))) {
            im.addImportFor(e2);
        }
        return sqn;
    }

    public static String getPackage(PojoDao e) {
        Package packageDeclaration = (Package)EcoreUtil2.getContainerOfType((EObject)e, Package.class);
        return packageDeclaration.getName();
    }

    public static String getFullName(PojoDao e1, PojoDao e2, QualifiedName qn2, ImportManager im) {
        String pkg2;
        String sqn = qn2.toString();
        if (sqn.indexOf(".") > 0) {
            return sqn;
        }
        String pkg1 = Utils.getPackage(e1);
        if (!pkg1.equals(pkg2 = Utils.getPackage(e2))) {
            im.addImportFor(e2);
        }
        return sqn;
    }

    public static String getPackage(PojoAnnotatedProperty e) {
        Package packageDeclaration = (Package)EcoreUtil2.getContainerOfType((EObject)e, Package.class);
        return packageDeclaration.getName();
    }

    public static CharSequence getFullName(PojoEntity e1, PojoAnnotatedProperty e2, CharSequence qn2, ImportManager im) {
        String pkg2;
        String sqn = qn2.toString();
        if (sqn.indexOf(".") > 0) {
            return qn2;
        }
        String pkg1 = Utils.getPackage(e1);
        if (!pkg1.equals(pkg2 = Utils.getPackage(e2))) {
            im.addImportFor(e2, sqn);
        }
        return qn2;
    }

    public static boolean isFinal(MetaStatement m) {
        String finalToken = Utils.getTokenFromModifier(m, "final");
        return finalToken != null;
    }

    public static String getName(Column column) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ExtendedColumn ei : column.getColumns()) {
            if (first) {
                first = false;
            } else {
                sb.append(".");
            }
            sb.append(ei.getCol().getName());
        }
        return sb.toString();
    }

    public static String getName(MappingColumn column) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ExtendedMappingItem ei : column.getItems()) {
            if (first) {
                first = false;
            } else {
                sb.append(".");
            }
            sb.append(ei.getAttr().getName());
        }
        return sb.toString();
    }

    public static boolean isNumber(String s) {
        if (s == null) {
            return false;
        }
        s = s.trim();
        int i = 0;
        int l = s.length();
        while (i < l) {
            char c = s.charAt(i);
            if (!Character.isDigit(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static EnumProperty getEnumAttr(EnumEntity e) {
        for (EnumProperty attr : e.getFeatures()) {
            if (attr.getType() == null) continue;
            return attr;
        }
        return null;
    }

    public static String getValue(EnumPropertyValue p) {
        if (p.getValue() == null) {
            return null;
        }
        return p.getValue().replaceAll("'", "\"");
    }

    public static String getValue(DescendantAssignment p) {
        if (p.getValue() == null) {
            return null;
        }
        return p.getValue().replaceAll("\"", "");
    }

    public static JvmType pojoMethod2jvmType(final PojoEntity e) {
        return new JvmType(){

            public String getIdentifier() {
                return e.getName();
            }

            public String getSimpleName() {
                return e.getName();
            }

            public String getQualifiedName() {
                return String.valueOf(Utils.getPackage(e)) + "." + e.getName();
            }

            public String getQualifiedName(char innerClassDelimiter) {
                return String.valueOf(Utils.getPackage(e)) + "." + e.getName();
            }

            public EClass eClass() {
                return e.eClass();
            }

            public Resource eResource() {
                return e.eResource();
            }

            public EObject eContainer() {
                return e.eContainer();
            }

            public EStructuralFeature eContainingFeature() {
                return e.eContainingFeature();
            }

            public EReference eContainmentFeature() {
                return e.eContainmentFeature();
            }

            public EList<EObject> eContents() {
                return e.eContents();
            }

            public TreeIterator<EObject> eAllContents() {
                return e.eAllContents();
            }

            public boolean eIsProxy() {
                return e.eIsProxy();
            }

            public EList<EObject> eCrossReferences() {
                return e.eCrossReferences();
            }

            public Object eGet(EStructuralFeature feature) {
                return e.eGet(feature);
            }

            public Object eGet(EStructuralFeature feature, boolean resolve) {
                return e.eGet(feature, resolve);
            }

            public void eSet(EStructuralFeature feature, Object newValue) {
                e.eSet(feature, newValue);
            }

            public boolean eIsSet(EStructuralFeature feature) {
                return e.eIsSet(feature);
            }

            public void eUnset(EStructuralFeature feature) {
                e.eUnset(feature);
            }

            public Object eInvoke(EOperation operation, EList<?> arguments) throws InvocationTargetException {
                return e.eInvoke(operation, arguments);
            }

            public EList<Adapter> eAdapters() {
                return e.eAdapters();
            }

            public boolean eDeliver() {
                return e.eDeliver();
            }

            public void eSetDeliver(boolean deliver) {
                e.eSetDeliver(deliver);
            }

            public void eNotify(Notification notification) {
                e.eNotify(notification);
            }
        };
    }

    public static String _toFirstUpper(String name) {
        int l = name.length();
        if (l == 0) {
            return name;
        }
        if (l == 1) {
            return name.toUpperCase();
        }
        char c = name.charAt(1);
        if (Character.isUpperCase(c)) {
            return name;
        }
        return String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
    }

    public static DbResolver.DbType getDbType(DbResolver dbResolver, Artifacts artifacts) {
        DbResolver.DbType[] dbTypes;
        DbResolver.DbType dbType = dbResolver.getDatabaseDirectives((EObject)artifacts).dbType;
        if (dbType == null && (dbTypes = DbResolver.DbType.fromDbMetaInfo(dbResolver.getDbMetaInfo(artifacts))) != null && dbTypes.length > 0) {
            dbType = dbTypes[0];
        }
        return dbType;
    }

    public static String getSuffix(Package pkg) {
        if (pkg.getDirectives() == null || pkg.getDirectives().isEmpty()) {
            return null;
        }
        for (PackageDirective dir : pkg.getDirectives()) {
            if (!(dir instanceof PackageDirectiveSuffix)) continue;
            return ((PackageDirectiveSuffix)dir).getSuffix();
        }
        return null;
    }

    public static String getImplPackage(PojoDao d) {
        Package packageDeclaration = (Package)EcoreUtil2.getContainerOfType((EObject)d, Package.class);
        if (packageDeclaration == null || packageDeclaration.getDirectives() == null || packageDeclaration.getDirectives().isEmpty()) {
            return null;
        }
        for (PackageDirective dir : packageDeclaration.getDirectives()) {
            if (!(dir instanceof PackageDirectiveImplementation)) continue;
            return ((PackageDirectiveImplementation)dir).getImplementation();
        }
        return null;
    }
}

