/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.resolver;

import com.google.inject.Singleton;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.sqlproc.dsl.property.ModelProperty;
import org.sqlproc.dsl.resolver.PojoResolver;
import org.sqlproc.dsl.util.MainUtils;

@Singleton
public class StandalonePojoResolverImpl
implements PojoResolver {
    protected Logger LOGGER = Logger.getLogger(StandalonePojoResolverImpl.class);
    ModelProperty modelProperty;
    String source;

    public StandalonePojoResolverImpl(ModelProperty modelProperty, String source) {
        this.modelProperty = modelProperty;
        this.source = source;
    }

    @Override
    public Class<?> loadClass(String name, URI uri) {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(name);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.LOGGER.warn((Object)("Can't find class '" + name));
            return null;
        }
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors(String name, URI uri) {
        Class<?> beanClass = this.loadClass(name, uri);
        if (beanClass == null) {
            return null;
        }
        PropertyDescriptor[] descriptors = null;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
        descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        return descriptors;
    }

    @Override
    public boolean isResolvePojo(EObject model) {
        return this.modelProperty.isDoResolvePojo(model);
    }

    @Override
    public List<Class<?>> getPojoClasses(URI uri) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public InputStream getFile(String filename, URI uri) {
        File file = new File(MainUtils.getFile(this.source, filename));
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.LOGGER.warn((Object)("Can't find file '" + filename + "' in project"));
            return null;
        }
    }
}

