/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.sqlproc.dsl.property.ModelProperty;
import org.sqlproc.dsl.resolver.DbCheckConstraint;
import org.sqlproc.dsl.resolver.DbColumn;
import org.sqlproc.dsl.resolver.DbExport;
import org.sqlproc.dsl.resolver.DbImport;
import org.sqlproc.dsl.resolver.DbIndex;
import org.sqlproc.dsl.resolver.DbResolverBean;
import org.sqlproc.dsl.resolver.DbTable;

public interface DbResolver {
    public boolean isResolveDb(EObject var1);

    public DbResolverBean.DatabaseDirectives getDatabaseDirectives(EObject var1);

    public List<String> getTables(EObject var1);

    public boolean checkTable(EObject var1, String var2);

    public List<String> getColumns(EObject var1, String var2);

    public boolean checkColumn(EObject var1, String var2, String var3);

    public List<DbColumn> getDbColumns(EObject var1, String var2);

    public List<DbExport> getDbExports(EObject var1, String var2);

    public List<DbImport> getDbImports(EObject var1, String var2);

    public List<String> getDbPrimaryKeys(EObject var1, String var2);

    public String getType(EObject var1, String var2, String var3);

    public List<DbIndex> getDbIndexes(EObject var1, String var2);

    public List<String> getSequences(EObject var1);

    public String getDbMetaInfo(EObject var1);

    public String getDbDriverInfo(EObject var1);

    public String getDbJdbcInfo(EObject var1);

    public List<String> getCatalogs(EObject var1);

    public List<String> getSchemas(EObject var1);

    public Set<String> getDriverMethods(EObject var1);

    public Object getDriverMethodOutput(EObject var1, String var2);

    public List<String> getProcedures(EObject var1);

    public List<String> getFunctions(EObject var1);

    public List<String> getProcColumns(EObject var1, String var2);

    public boolean checkProcColumn(EObject var1, String var2, String var3);

    public List<String> getFunColumns(EObject var1, String var2);

    public boolean checkFunColumn(EObject var1, String var2, String var3);

    public List<DbColumn> getDbProcColumns(EObject var1, String var2);

    public List<DbColumn> getDbFunColumns(EObject var1, String var2);

    public List<DbTable> getDbTables(EObject var1, String var2);

    public List<DbTable> getDbProcedures(EObject var1, String var2);

    public List<DbTable> getDbFunctions(EObject var1, String var2);

    public boolean checkProcedure(EObject var1, String var2);

    public boolean checkFunction(EObject var1, String var2);

    public List<DbCheckConstraint> getDbCheckConstraints(EObject var1, String var2);

    public List<String> getCheckConstraints(EObject var1);

    public List<String> getCheckColumns(EObject var1, String var2);

    public String getProcType(EObject var1, String var2, String var3);

    public String getFunType(EObject var1, String var2, String var3);

    public boolean checkTableName(EObject var1, String var2);

    public void init(ModelProperty var1, Class<?> var2, String var3, String var4);

    public static enum DbType {
        ORACLE("Oracle"),
        MY_SQL("MySQL"),
        HSQLDB("HSQLDB"),
        POSTGRESQL("PostgreSQL"),
        INFORMIX("Informix"),
        DB2("DB2"),
        MS_SQL("MSSQL");

        private static Map<String, DbType> identifierMap;
        private String value;

        static {
            identifierMap = new HashMap<String, DbType>();
            DbType[] dbTypeArray = DbType.values();
            int n = dbTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DbType value = dbTypeArray[n2];
                identifierMap.put(value.getValue(), value);
                ++n2;
            }
        }

        private DbType(String value) {
            this.value = value;
        }

        public static DbType fromValue(String value) {
            DbType result = identifierMap.get(value);
            if (result == null) {
                throw new IllegalArgumentException("No DbType for value: " + value);
            }
            return result;
        }

        public static DbType[] fromDbMetaInfo(String dbMetaInfo) {
            if (dbMetaInfo == null) {
                return DbType.values();
            }
            ArrayList<DbType> result = new ArrayList<DbType>();
            String info = dbMetaInfo.toUpperCase();
            DbType[] dbTypeArray = DbType.values();
            int n = dbTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DbType dbType = dbTypeArray[n2];
                if (info.indexOf(dbType.toString().toUpperCase()) >= 0 || info.indexOf(dbType.getValue().toUpperCase()) >= 0) {
                    result.add(dbType);
                } else if (dbType == HSQLDB && info.indexOf("HSQL") >= 0) {
                    result.add(dbType);
                } else if (dbType == MS_SQL && info.indexOf("MICROSOFT") >= 0) {
                    result.add(dbType);
                }
                ++n2;
            }
            if (!result.isEmpty()) {
                return result.toArray(new DbType[0]);
            }
            return DbType.values();
        }

        public String getValue() {
            return this.value;
        }
    }
}

