/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.property;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.sqlproc.dsl.processorDsl.Artifacts;
import org.sqlproc.dsl.processorDsl.ColumnAssignement;
import org.sqlproc.dsl.processorDsl.ColumnTypeAssignement;
import org.sqlproc.dsl.processorDsl.DaogenProperty;
import org.sqlproc.dsl.processorDsl.DatabaseProperty;
import org.sqlproc.dsl.processorDsl.ExportAssignement;
import org.sqlproc.dsl.processorDsl.FunctionPojoAssignement;
import org.sqlproc.dsl.processorDsl.ImportAssignement;
import org.sqlproc.dsl.processorDsl.InheritanceAssignement;
import org.sqlproc.dsl.processorDsl.JoinTableAssignement;
import org.sqlproc.dsl.processorDsl.ManyToManyAssignement;
import org.sqlproc.dsl.processorDsl.MetaTypeAssignement;
import org.sqlproc.dsl.processorDsl.MetagenProperty;
import org.sqlproc.dsl.processorDsl.PojoType;
import org.sqlproc.dsl.processorDsl.PojogenProperty;
import org.sqlproc.dsl.processorDsl.ProcedurePojoAssignement;
import org.sqlproc.dsl.processorDsl.Property;
import org.sqlproc.dsl.processorDsl.SqlTypeAssignement;
import org.sqlproc.dsl.processorDsl.TableAssignement;
import org.sqlproc.dsl.property.ImplementsExtends;
import org.sqlproc.dsl.property.ModelProperty;
import org.sqlproc.dsl.property.PojoAttrType;
import org.sqlproc.dsl.util.Utils;

@Singleton
public class ModelPropertyBean
extends AdapterImpl
implements ModelProperty {
    protected Logger LOGGER = Logger.getLogger(ModelPropertyBean.class);
    public static final String RESOLVE_POJO_ON = "resolve-pojo-on";
    public static final String RESOLVE_POJO_OFF = "resolve-pojo-off";
    public static final String REPLACE_ALL_REGEX = "replace-all-regex";
    public static final String REPLACE_ALL_REPLACEMENT = "replace-all-replacement";
    public static final String COMPRESS_META_DIRECTIVES = "compress-meta-directives";
    public static final String DATABASE = "database";
    public static final String DATABASE_IS_ONLINE = "is-online";
    public static final String DATABASE_IS_OFFLINE = "is-offline";
    public static final String DATABASE_HAS_URL = "has-url";
    public static final String DATABASE_EXECUTE_BEFORE = "ddl-create";
    public static final String DATABASE_EXECUTE_AFTER = "ddl-drop";
    public static final String DATABASE_LOGIN_USERNAME = "login-username";
    public static final String DATABASE_LOGIN_NPASSWORD = "login-password";
    public static final String DATABASE_IN_CATALOG = "in-catalog";
    public static final String DATABASE_ACTIVE_SCHEMA = "active-schema";
    public static final String DATABASE_JDBC_DRIVER = "jdbc-driver";
    public static final String DATABASE_INDEX_TYPES = "index-types";
    public static final String DATABASE_SKIP_INDEXES = "skip-indexes";
    public static final String DATABASE_SKIP_CHECK_CONSTRAINTS = "skip-check-constraints";
    public static final String DATABASE_SKIP_PROCEDURES = "skip-functions-procedures";
    public static final String DATABASE_OF_TYPE = "is-of-type";
    public static final String DATABASE_DEBUG_LEVEL = "debug-level";
    public static final String DATABASE_TAKE_COMMENTS = "take-comments";
    public static final String DATABASE_LOWERCASE_NAMES = "lowercase-names";
    public static final String DATABASE_UPPERCASE_NAMES = "uppercase-names";
    public static final String POJOGEN = "pojogen";
    public static final String POJOGEN_TYPE_SQLTYPES = "types-sqltypes";
    public static final String POJOGEN_TYPE_IN_TABLE = "types-in-table";
    public static final String POJOGEN_TYPE_FOR_COLUMNS = "types-for-columns";
    public static final String POJOGEN_TYPE_FOR_PROCEDURE = "types-for-procedure";
    public static final String POJOGEN_TYPE_FOR_FUNCTION = "types-for-function";
    public static final String POJOGEN_IGNORE_TABLES = "ignore-tables";
    public static final String POJOGEN_ONLY_TABLES = "only-tables";
    public static final String POJOGEN_IGNORE_COLUMNS = "ignore-columns";
    public static final String POJOGEN_REQUIRED_COLUMNS = "required-columns";
    public static final String POJOGEN_NOT_REQUIRED_COLUMNS = "not-required-columns";
    public static final String POJOGEN_CREATE_COLUMNS = "create-columns";
    public static final String POJOGEN_RENAME_TABLES = "rename-tables";
    public static final String POJOGEN_RENAME_COLUMNS = "rename-columns";
    public static final String POJOGEN_IGNORE_EXPORTS = "ignore-one-to-many";
    public static final String POJOGEN_IGNORE_IMPORTS = "ignore-many-to-one";
    public static final String POJOGEN_CREATE_EXPORTS = "create-one-to-many";
    public static final String POJOGEN_CREATE_IMPORTS = "create-many-to-one";
    public static final String POJOGEN_INHERIT_IMPORTS = "inherit-many-to-one";
    public static final String POJOGEN_MANY_TO_MANY_IMPORTS = "table-many-to-many";
    public static final String POJOGEN_INHERITANCE = "inherit-discriminator";
    public static final String POJOGEN_GENERATE_METHODS = "generate-methods";
    public static final String POJOGEN_GENERATE_OPERATORS = "generate-operators";
    public static final String POJOGEN_IMPLEMENTS_INTERFACES = "implements-interfaces";
    public static final String POJOGEN_EXTENDS_CLASS = "extends-class";
    public static final String POJOGEN_IMPLEMENTS_INTERFACES_GENERICS = "implements-interfaces-generics";
    public static final String POJOGEN_EXTENDS_CLASS_GENERICS = "extends-class-generics";
    public static final String POJOGEN_JOIN_TABLES = "join-tables";
    public static final String POJOGEN_GENERATE_WRAPPERS = "generate-wrappers";
    public static final String POJOGEN_GENERATE_VALIDATION_ANNOTATIONS = "generate-validation-annotations";
    public static final String POJOGEN_NOT_ABSTRACT_TABLES_TABLES = "not-abstract-tables";
    public static final String POJOGEN_MAKE_IT_FINAL = "make-it-final";
    public static final String POJOGEN_VERSION_COLUMN = "version-column";
    public static final String POJOGEN_DEBUG_LEVEL = "debug-level";
    public static final String POJOGEN_PRESERVE_FOREIGN_KEYS = "preserve-foreign-keys";
    public static final String POJOGEN_POJOS_FOR_PROCEDURES = "pojos-for-procedures";
    public static final String POJOGEN_POJOS_FOR_FUNCTIONS = "pojos-for-functions";
    public static final String POJOGEN_ACTIVE_FILTER = "active-filter";
    public static final String POJOGEN_PACKAGE = "package";
    public static final String POJOGEN_ENUM_FOR_CHECK_CONSTRAINTS = "enum-for-check-constraints";
    public static final String METAGEN = "metagen";
    public static final String METAGEN_GLOBAL_SEQUENCE = "global-sequence";
    public static final String METAGEN_TABLE_SEQUENCE = "table-sequence";
    public static final String METAGEN_GLOBAL_IDENTITY = "global-identity";
    public static final String METAGEN_TABLE_IDENTITY = "table-identity";
    public static final String METAGEN_COLUMN_META_TYPE = "column-meta-type";
    public static final String METAGEN_STATEMENT_META_TYPE = "statement-meta-type";
    public static final String METAGEN_MAKE_IT_FINAL = "make-it-final";
    public static final String METAGEN_LIKE_COLUMNS = "like-columns";
    public static final String METAGEN_NOT_LIKE_COLUMNS = "not-like-columns";
    public static final String METAGEN_GENERATE_SEQUENCES = "generate-sequences";
    public static final String METAGEN_GENERATE_IDENTITIES = "generate-identities";
    public static final String METAGEN_GENERATE_IDGENERATORS = "generate-idgenerators";
    public static final String METAGEN_GENERATE_INDIRECT_IDGENERATORS = "generate-default-idgenerators";
    public static final String METAGEN_FUNCTION_RESULT = "function-result";
    public static final String METAGEN_FUNCTION_RESULT_SET = "function-result-set";
    public static final String METAGEN_PROCEDURE_RESULT_SET = "procedure-result-set";
    public static final String METAGEN_DEBUG_LEVEL = "debug-level";
    public static final String METAGEN_GENERATE_OPERATORS = "generate-operators";
    public static final String METAGEN_OPTIMIZE_INSERT = "optimize-insert";
    public static final String METAGEN_OPTIONAL_FEATURES = "optional-features";
    public static final String METAGEN_ACTIVE_FILTER = "active-filter";
    public static final String DAOGEN = "daogen";
    public static final String DAOGEN_IGNORE_TABLES = "ignore-tables";
    public static final String DAOGEN_ONLY_TABLES = "only-tables";
    public static final String DAOGEN_IMPLEMENTS_INTERFACES = "implements-interfaces";
    public static final String DAOGEN_EXTENDS_CLASS = "extends-class";
    public static final String DAOGEN_IMPLEMENTS_INTERFACES_GENERICS = "implements-interfaces-generics";
    public static final String DAOGEN_EXTENDS_CLASS_GENERICS = "extends-class-generics";
    public static final String DAOGEN_MAKE_IT_FINAL = "make-it-final";
    public static final String DAOGEN_FUNCTION_RESULT = "function-result";
    public static final String DAOGEN_DEBUG_LEVEL = "debug-level";
    public static final String DAOGEN_ACTIVE_FILTER = "active-filter";
    public static final String DAOGEN_PACKAGE = "package";
    public static final String GLOBAL = "___GLOBAL";
    private ModelValues modelValues = null;
    private Map<String, ModelValues> dirs2models = new HashMap<String, ModelValues>();

    public ModelPropertyBean() {
    }

    public ModelPropertyBean(ModelValues modelValues) {
        this.init(modelValues);
    }

    @Override
    public void init(Object modelValues) {
        if (modelValues == null || !(modelValues instanceof ModelValues)) {
            this.modelValues = null;
        } else {
            this.modelValues = (ModelValues)modelValues;
            this.modelValues.dir = "XXX";
        }
    }

    public void notifyChanged(Notification msg) {
        int featureID;
        if (msg.getNotifier() == null || msg.getFeatureID(Resource.class) == -1) {
            return;
        }
        if (msg.getNotifier() instanceof XtextResource && (featureID = msg.getFeatureID(Resource.class)) == 4) {
            XtextResource resource = (XtextResource)msg.getNotifier();
            if (!msg.getNewBooleanValue()) {
                this.LOGGER.debug((Object)("UNLOADED RESOURCE " + resource));
                return;
            }
            IParseResult parseResult = resource.getParseResult();
            EObject rootASTElement = parseResult != null ? parseResult.getRootASTElement() : null;
            this.LOGGER.debug((Object)("LOADED RESOURCE " + resource + " for " + rootASTElement));
            if (parseResult == null || rootASTElement == null || !(rootASTElement instanceof Artifacts) || resource.getURI() == null) {
                this.LOGGER.error((Object)("LOADED RESOURCE IS NOT VALID: for parseResult " + parseResult + " and rootASTElement " + rootASTElement + " and msg " + msg));
                return;
            }
            String dir = Utils.resourceDir((Resource)resource);
            if (dir == null) {
                this.LOGGER.error((Object)("LOADED RESOURCE URI IS NOT VALID " + resource.getURI()));
                return;
            }
            ModelValues modelValues = null;
            if (this.dirs2models.containsKey(dir)) {
                modelValues = this.dirs2models.get(dir);
            } else {
                modelValues = new ModelValues();
                this.dirs2models.put(dir, modelValues);
                modelValues.dir = dir;
            }
            Artifacts artifacts = (Artifacts)rootASTElement;
            if (ModelPropertyBean.loadModel(modelValues, artifacts) == null) {
                return;
            }
            this.LOGGER.debug((Object)("MODEL " + modelValues.toString()));
        }
    }

    public static ModelValues loadModel(ModelValues modelValues, Artifacts artifacts) {
        if (artifacts.getProperties().isEmpty()) {
            return null;
        }
        if (modelValues == null) {
            modelValues = new ModelValues();
        }
        ModelPropertyBean.initModel(modelValues);
        boolean reloadDatabase = false;
        for (Property property : artifacts.getProperties()) {
            if (!property.getName().startsWith(DATABASE)) continue;
            reloadDatabase = true;
            break;
        }
        if (reloadDatabase) {
            ModelPropertyBean.initDatabaseModel(modelValues);
        }
        boolean reloadPojogen = false;
        for (Property property : artifacts.getProperties()) {
            if (!property.getName().startsWith(POJOGEN)) continue;
            reloadPojogen = true;
            break;
        }
        if (reloadPojogen) {
            ModelPropertyBean.initPojogenModel(modelValues);
        }
        boolean reloadMetagen = false;
        for (Property property : artifacts.getProperties()) {
            if (!property.getName().startsWith(METAGEN)) continue;
            reloadMetagen = true;
            break;
        }
        if (reloadMetagen) {
            ModelPropertyBean.initMetagenModel(modelValues);
        }
        boolean reloadDaogen = false;
        for (Property property : artifacts.getProperties()) {
            if (!property.getName().startsWith(DAOGEN)) continue;
            reloadDaogen = true;
            break;
        }
        if (reloadDaogen) {
            ModelPropertyBean.initDaogenModel(modelValues);
        }
        try {
            for (Property property : artifacts.getProperties()) {
                if (property.getName().startsWith(DATABASE)) {
                    ModelPropertyBean.setValue(modelValues, property.getDatabase());
                    continue;
                }
                if (property.getName().startsWith(POJOGEN)) {
                    ModelPropertyBean.setValue(modelValues, property.getPojogen());
                    continue;
                }
                if (property.getName().startsWith(METAGEN)) {
                    ModelPropertyBean.setValue(modelValues, property.getMetagen());
                    continue;
                }
                if (property.getName().startsWith(DAOGEN)) {
                    ModelPropertyBean.setValue(modelValues, property.getDaogen());
                    continue;
                }
                ModelPropertyBean.setValue(modelValues, property);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return modelValues;
    }

    private static void initModel(ModelValues modelValues) {
        modelValues.replaceAllRegex = new HashMap<String, String>();
        modelValues.replaceAllReplacement = new HashMap<String, String>();
        modelValues.doCompressMetaDirectives = false;
    }

    private static void initDatabaseModel(ModelValues modelValues) {
        modelValues.doResolveDb = false;
        modelValues.dbDriver = null;
        modelValues.dbUrl = null;
        modelValues.dbUsername = null;
        modelValues.dbPassword = null;
        modelValues.dbCatalog = null;
        modelValues.dbSchema = null;
        modelValues.dbSqlsBefore = null;
        modelValues.dbSqlsAfter = null;
        modelValues.dbIndexTypes = null;
        modelValues.dbSkipIndexes = false;
        modelValues.dbSkipProcedures = false;
        modelValues.dbSkipCheckConstraints = false;
        modelValues.dbType = null;
        modelValues.dbDebugLevel = null;
        modelValues.dbDebugScope = null;
        modelValues.dbTakeComments = false;
        modelValues.dbLowercaseNames = false;
        modelValues.dbUppercaseNames = false;
    }

    private static void initPojogenModel(ModelValues modelValues) {
        modelValues.sqlTypes = new HashMap<String, PojoAttrType>();
        modelValues.tableTypes = new HashMap<String, Map<String, PojoAttrType>>();
        modelValues.columnTypes = new HashMap<String, Map<String, PojoAttrType>>();
        modelValues.procedureTypes = new HashMap<String, Map<String, PojoAttrType>>();
        modelValues.functionTypes = new HashMap<String, Map<String, PojoAttrType>>();
        modelValues.tableNames = new HashMap<String, String>();
        modelValues.columnNames = new HashMap<String, Map<String, String>>();
        modelValues.ignoreTables = new HashSet<String>();
        modelValues.onlyTables = new HashSet<String>();
        modelValues.notAbstractTables = new HashSet<String>();
        modelValues.ignoreColumns = new HashMap<String, Set<String>>();
        modelValues.requiredColumns = new HashMap<String, Set<String>>();
        modelValues.notRequiredColumns = new HashMap<String, Set<String>>();
        modelValues.createColumns = new HashMap<String, Map<String, PojoAttrType>>();
        modelValues.ignoreExports = new HashMap<String, Map<String, Map<String, String>>>();
        modelValues.ignoreImports = new HashMap<String, Map<String, Map<String, String>>>();
        modelValues.createExports = new HashMap<String, Map<String, Map<String, String>>>();
        modelValues.createImports = new HashMap<String, Map<String, Map<String, String>>>();
        modelValues.inheritImports = new HashMap<String, Map<String, Map<String, String>>>();
        modelValues.manyToManyImports = new HashMap<String, Map<String, Map<String, String>>>();
        modelValues.inheritance = new HashMap<String, Map<String, Map<String, List<String>>>>();
        modelValues.inheritanceColumns = new HashMap<String, String>();
        modelValues.generateMethods = new HashSet<String>();
        modelValues.generateOperators = null;
        modelValues.toImplements = new HashMap<String, ImplementsExtends>();
        modelValues.toExtends = null;
        modelValues.joinTables = new HashMap<String, List<String>>();
        modelValues.doGenerateWrappers = false;
        modelValues.doGenerateValidationAnnotations = false;
        modelValues.makeItFinal = false;
        modelValues.versionColumn = null;
        modelValues.versionColumns = new HashMap<String, Set<String>>();
        modelValues.notVersionColumns = new HashMap<String, Set<String>>();
        modelValues.debugLevel = null;
        modelValues.debugScope = null;
        modelValues.preserveForeignKeys = new HashSet<String>();
        modelValues.pojosForProcedures = new HashMap<String, PojoType>();
        modelValues.pojosForFunctions = new HashMap<String, PojoType>();
        modelValues.activeFilter = null;
        modelValues.pckg = null;
        modelValues.enumForCheckConstraints = new HashMap<String, String>();
    }

    private static void initMetagenModel(ModelValues modelValues) {
        modelValues.metaGlobalSequence = null;
        modelValues.metaTablesSequence = new HashMap<String, PairValues>();
        modelValues.metaGlobalIdentity = null;
        modelValues.metaTablesIdentity = new HashMap<String, PairValues>();
        modelValues.metaColumnsMetaTypes = new HashMap<String, Map<String, PairValues>>();
        modelValues.metaStatementsMetaTypes = new HashMap<String, Map<String, PairValues>>();
        modelValues.metaMakeItFinal = false;
        modelValues.metaLikeColumns = new HashMap<String, Set<String>>();
        modelValues.metaNotLikeColumns = new HashMap<String, Set<String>>();
        modelValues.metaGenerateSequences = false;
        modelValues.metaGlobalSequenceForTables = new HashSet<String>();
        modelValues.metaGlobalSequenceNotForTables = new HashSet<String>();
        modelValues.metaGenerateIdentities = false;
        modelValues.metaGlobalIdentityForTables = new HashSet<String>();
        modelValues.metaGlobalIdentityNotForTables = new HashSet<String>();
        modelValues.metaGenerateIdGenerators = false;
        modelValues.metaGenerateIndirectIdGenerators = false;
        modelValues.metaFunctionsResult = new HashMap<String, String>();
        modelValues.metaFunctionsResultSet = new HashMap<String, String>();
        modelValues.metaProceduresResultSet = new HashMap<String, String>();
        modelValues.metaDebugLevel = null;
        modelValues.metaDebugScope = null;
        modelValues.metaGenerateOperators = false;
        modelValues.metaOptimizeInsert = new HashSet<String>();
        modelValues.metaOptionalFeatures = new HashMap<String, Set<String>>();
        modelValues.metaActiveFilter = null;
    }

    private static void initDaogenModel(ModelValues modelValues) {
        modelValues.daoIgnoreTables = new HashSet<String>();
        modelValues.daoOnlyTables = new HashSet<String>();
        modelValues.daoToImplements = new HashMap<String, ImplementsExtends>();
        modelValues.daoToExtends = null;
        modelValues.daoMakeItFinal = false;
        modelValues.daoFunctionsResult = new HashMap<String, PojoType>();
        modelValues.daoDebugLevel = null;
        modelValues.daoDebugScope = null;
        modelValues.daoActiveFilter = null;
        modelValues.daoPckg = null;
    }

    public static void setValue(ModelValues modelValues, Property property) {
        if (property == null) {
            return;
        }
        if (RESOLVE_POJO_ON.equals(property.getName())) {
            modelValues.doResolvePojo = true;
        } else if (RESOLVE_POJO_OFF.equals(property.getName())) {
            modelValues.doResolvePojo = false;
        } else if (REPLACE_ALL_REGEX.equals(property.getName())) {
            if (property.getRegex() != null && property.getReplaceId() != null) {
                modelValues.replaceAllRegex.put(property.getReplaceId(), property.getRegex());
            }
        } else if (REPLACE_ALL_REPLACEMENT.equals(property.getName())) {
            if (property.getReplacement() != null && property.getReplaceId() != null) {
                modelValues.replaceAllReplacement.put(property.getReplaceId(), property.getReplacement());
            }
        } else if (COMPRESS_META_DIRECTIVES.equals(property.getName())) {
            modelValues.doCompressMetaDirectives = true;
        }
    }

    public static void setValue(ModelValues modelValues, DatabaseProperty property) {
        if (property == null) {
            return;
        }
        if (DATABASE_IS_ONLINE.equals(property.getName())) {
            modelValues.doResolveDb = true;
        } else if (DATABASE_IS_OFFLINE.equals(property.getName())) {
            modelValues.doResolveDb = false;
        } else if (DATABASE_HAS_URL.equals(property.getName())) {
            modelValues.dbUrl = ModelPropertyBean.getPropertyValue(property.getDbUrl());
        } else if (DATABASE_LOGIN_USERNAME.equals(property.getName())) {
            modelValues.dbUsername = ModelPropertyBean.getPropertyValue(property.getDbUsername());
        } else if (DATABASE_LOGIN_NPASSWORD.equals(property.getName())) {
            modelValues.dbPassword = ModelPropertyBean.getPropertyValue(property.getDbPassword());
        } else if (DATABASE_IN_CATALOG.equals(property.getName())) {
            modelValues.dbCatalog = property.getDbCatalog() != null ? ModelPropertyBean.getPropertyValue(property.getDbCatalog().getDbCatalog()) : null;
        } else if (DATABASE_ACTIVE_SCHEMA.equals(property.getName())) {
            modelValues.dbSchema = property.getDbSchema() != null ? ModelPropertyBean.getPropertyValue(property.getDbSchema().getDbSchema()) : null;
        } else if (DATABASE_JDBC_DRIVER.equals(property.getName())) {
            modelValues.dbDriver = property.getDbDriverx() != null ? ModelPropertyBean.getPropertyValue(property.getDbDriverx().getQualifiedName()) : ModelPropertyBean.getPropertyValue(property.getDbDriver());
        } else if (DATABASE_EXECUTE_BEFORE.equals(property.getName())) {
            modelValues.dbSqlsBefore = ModelPropertyBean.getPropertyValue(property.getDbExecuteBefore());
        } else if (DATABASE_EXECUTE_AFTER.equals(property.getName())) {
            modelValues.dbSqlsAfter = ModelPropertyBean.getPropertyValue(property.getDbExecuteAfter());
        } else if (DATABASE_INDEX_TYPES.equals(property.getName())) {
            modelValues.dbIndexTypes = ModelPropertyBean.getPropertyValue(property.getDbIndexTypes());
        } else if (DATABASE_SKIP_INDEXES.equals(property.getName())) {
            modelValues.dbSkipIndexes = true;
        } else if (DATABASE_SKIP_PROCEDURES.equals(property.getName())) {
            modelValues.dbSkipProcedures = true;
        } else if (DATABASE_SKIP_CHECK_CONSTRAINTS.equals(property.getName())) {
            modelValues.dbSkipCheckConstraints = true;
        } else if (DATABASE_OF_TYPE.equals(property.getName())) {
            modelValues.dbType = property.getDbType() != null ? ModelPropertyBean.getPropertyValue(property.getDbType().getDbType()) : null;
        } else if ("debug-level".equals(property.getName()) && property.getDebug() != null) {
            modelValues.dbDebugLevel = property.getDebug().getDebug();
            modelValues.dbDebugScope = property.getDebug().getScope();
        } else if (DATABASE_TAKE_COMMENTS.equals(property.getName())) {
            modelValues.dbTakeComments = true;
        } else if (DATABASE_LOWERCASE_NAMES.equals(property.getName())) {
            modelValues.dbLowercaseNames = true;
        } else if (DATABASE_UPPERCASE_NAMES.equals(property.getName())) {
            modelValues.dbUppercaseNames = true;
        }
    }

    private static String getPropertyValue(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).startsWith("\"")) {
            value = value.substring(1);
        }
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private static void setValue(ModelValues modelValues, PojogenProperty property) {
        block96: {
            block118: {
                block117: {
                    block116: {
                        block115: {
                            block114: {
                                block113: {
                                    block112: {
                                        block111: {
                                            block110: {
                                                block109: {
                                                    block108: {
                                                        block107: {
                                                            block106: {
                                                                block105: {
                                                                    block104: {
                                                                        block103: {
                                                                            block102: {
                                                                                block101: {
                                                                                    block100: {
                                                                                        block99: {
                                                                                            block98: {
                                                                                                block97: {
                                                                                                    block95: {
                                                                                                        if (property == null) {
                                                                                                            return;
                                                                                                        }
                                                                                                        if (!POJOGEN_TYPE_SQLTYPES.equals(property.getName())) break block95;
                                                                                                        int i = 0;
                                                                                                        int m = property.getSqlTypes().size();
                                                                                                        while (i < m) {
                                                                                                            PojoAttrType type = new PojoAttrType(((SqlTypeAssignement)property.getSqlTypes().get(i)).getTypeName(), ((SqlTypeAssignement)property.getSqlTypes().get(i)).getSize(), ((SqlTypeAssignement)property.getSqlTypes().get(i)).getType());
                                                                                                            modelValues.sqlTypes.put(String.valueOf(type.getName()) + type.getSize(), type);
                                                                                                            ++i;
                                                                                                        }
                                                                                                        break block96;
                                                                                                    }
                                                                                                    if (!POJOGEN_TYPE_IN_TABLE.equals(property.getName())) break block97;
                                                                                                    if (!modelValues.tableTypes.containsKey(property.getDbTable())) {
                                                                                                        modelValues.tableTypes.put(property.getDbTable(), new HashMap());
                                                                                                    }
                                                                                                    int i = 0;
                                                                                                    int m = property.getSqlTypes().size();
                                                                                                    while (i < m) {
                                                                                                        PojoAttrType type = new PojoAttrType(((SqlTypeAssignement)property.getSqlTypes().get(i)).getTypeName(), ((SqlTypeAssignement)property.getSqlTypes().get(i)).getSize(), ((SqlTypeAssignement)property.getSqlTypes().get(i)).getType());
                                                                                                        modelValues.tableTypes.get(property.getDbTable()).put(String.valueOf(type.getName()) + type.getSize(), type);
                                                                                                        ++i;
                                                                                                    }
                                                                                                    break block96;
                                                                                                }
                                                                                                if (!POJOGEN_TYPE_FOR_COLUMNS.equals(property.getName())) break block98;
                                                                                                if (!modelValues.columnTypes.containsKey(property.getDbTable())) {
                                                                                                    modelValues.columnTypes.put(property.getDbTable(), new HashMap());
                                                                                                }
                                                                                                int i = 0;
                                                                                                int m = property.getColumnTypes().size();
                                                                                                while (i < m) {
                                                                                                    PojoAttrType type = new PojoAttrType(((ColumnTypeAssignement)property.getColumnTypes().get(i)).getDbColumn(), null, ((ColumnTypeAssignement)property.getColumnTypes().get(i)).getType());
                                                                                                    modelValues.columnTypes.get(property.getDbTable()).put(type.getName(), type);
                                                                                                    ++i;
                                                                                                }
                                                                                                break block96;
                                                                                            }
                                                                                            if (!POJOGEN_TYPE_FOR_PROCEDURE.equals(property.getName())) break block99;
                                                                                            if (!modelValues.procedureTypes.containsKey(property.getDbProcedure())) {
                                                                                                modelValues.procedureTypes.put(property.getDbProcedure(), new HashMap());
                                                                                            }
                                                                                            int i = 0;
                                                                                            int m = property.getColumnTypes().size();
                                                                                            while (i < m) {
                                                                                                PojoAttrType type = new PojoAttrType(((ColumnTypeAssignement)property.getColumnTypes().get(i)).getDbColumn(), null, ((ColumnTypeAssignement)property.getColumnTypes().get(i)).getType());
                                                                                                modelValues.procedureTypes.get(property.getDbProcedure()).put(type.getName(), type);
                                                                                                ++i;
                                                                                            }
                                                                                            break block96;
                                                                                        }
                                                                                        if (!POJOGEN_TYPE_FOR_FUNCTION.equals(property.getName())) break block100;
                                                                                        if (!modelValues.functionTypes.containsKey(property.getDbFunction())) {
                                                                                            modelValues.functionTypes.put(property.getDbFunction(), new HashMap());
                                                                                        }
                                                                                        int i = 0;
                                                                                        int m = property.getColumnTypes().size();
                                                                                        while (i < m) {
                                                                                            PojoAttrType type = new PojoAttrType(((ColumnTypeAssignement)property.getColumnTypes().get(i)).getDbColumn(), null, ((ColumnTypeAssignement)property.getColumnTypes().get(i)).getType());
                                                                                            modelValues.functionTypes.get(property.getDbFunction()).put(type.getName(), type);
                                                                                            ++i;
                                                                                        }
                                                                                        break block96;
                                                                                    }
                                                                                    if (!POJOGEN_RENAME_TABLES.equals(property.getName())) break block101;
                                                                                    int i = 0;
                                                                                    int m = property.getTables().size();
                                                                                    while (i < m) {
                                                                                        modelValues.tableNames.put(((TableAssignement)property.getTables().get(i)).getDbTable(), ((TableAssignement)property.getTables().get(i)).getNewName());
                                                                                        ++i;
                                                                                    }
                                                                                    break block96;
                                                                                }
                                                                                if (!POJOGEN_RENAME_COLUMNS.equals(property.getName())) break block102;
                                                                                if (!modelValues.columnNames.containsKey(property.getDbTable())) {
                                                                                    modelValues.columnNames.put(property.getDbTable(), new HashMap());
                                                                                }
                                                                                int i = 0;
                                                                                int m = property.getColumns().size();
                                                                                while (i < m) {
                                                                                    modelValues.columnNames.get(property.getDbTable()).put(((ColumnAssignement)property.getColumns().get(i)).getDbColumn(), ((ColumnAssignement)property.getColumns().get(i)).getNewName());
                                                                                    ++i;
                                                                                }
                                                                                break block96;
                                                                            }
                                                                            if (!"ignore-tables".equals(property.getName())) break block103;
                                                                            int i = 0;
                                                                            int m = property.getDbTables().size();
                                                                            while (i < m) {
                                                                                modelValues.ignoreTables.add((String)property.getDbTables().get(i));
                                                                                ++i;
                                                                            }
                                                                            break block96;
                                                                        }
                                                                        if (!"only-tables".equals(property.getName())) break block104;
                                                                        int i = 0;
                                                                        int m = property.getDbTables().size();
                                                                        while (i < m) {
                                                                            modelValues.onlyTables.add((String)property.getDbTables().get(i));
                                                                            ++i;
                                                                        }
                                                                        break block96;
                                                                    }
                                                                    if (!POJOGEN_NOT_ABSTRACT_TABLES_TABLES.equals(property.getName())) break block105;
                                                                    int i = 0;
                                                                    int m = property.getDbTables().size();
                                                                    while (i < m) {
                                                                        modelValues.notAbstractTables.add((String)property.getDbTables().get(i));
                                                                        ++i;
                                                                    }
                                                                    break block96;
                                                                }
                                                                if (!POJOGEN_IGNORE_COLUMNS.equals(property.getName())) break block106;
                                                                if (!modelValues.ignoreColumns.containsKey(property.getDbTable())) {
                                                                    modelValues.ignoreColumns.put(property.getDbTable(), new HashSet());
                                                                }
                                                                int i = 0;
                                                                int m = property.getDbColumns().size();
                                                                while (i < m) {
                                                                    modelValues.ignoreColumns.get(property.getDbTable()).add((String)property.getDbColumns().get(i));
                                                                    ++i;
                                                                }
                                                                break block96;
                                                            }
                                                            if (!POJOGEN_REQUIRED_COLUMNS.equals(property.getName())) break block107;
                                                            if (!modelValues.requiredColumns.containsKey(property.getDbTable())) {
                                                                modelValues.requiredColumns.put(property.getDbTable(), new HashSet());
                                                            }
                                                            int i = 0;
                                                            int m = property.getDbColumns().size();
                                                            while (i < m) {
                                                                modelValues.requiredColumns.get(property.getDbTable()).add((String)property.getDbColumns().get(i));
                                                                ++i;
                                                            }
                                                            break block96;
                                                        }
                                                        if (!POJOGEN_NOT_REQUIRED_COLUMNS.equals(property.getName())) break block108;
                                                        if (!modelValues.notRequiredColumns.containsKey(property.getDbTable())) {
                                                            modelValues.notRequiredColumns.put(property.getDbTable(), new HashSet());
                                                        }
                                                        int i = 0;
                                                        int m = property.getDbColumns().size();
                                                        while (i < m) {
                                                            modelValues.notRequiredColumns.get(property.getDbTable()).add((String)property.getDbColumns().get(i));
                                                            ++i;
                                                        }
                                                        break block96;
                                                    }
                                                    if (!POJOGEN_CREATE_COLUMNS.equals(property.getName())) break block109;
                                                    if (!modelValues.createColumns.containsKey(property.getDbTable())) {
                                                        modelValues.createColumns.put(property.getDbTable(), new HashMap());
                                                    }
                                                    int i = 0;
                                                    int m = property.getColumnTypes().size();
                                                    while (i < m) {
                                                        PojoAttrType type = new PojoAttrType(((ColumnTypeAssignement)property.getColumnTypes().get(i)).getDbColumn(), null, ((ColumnTypeAssignement)property.getColumnTypes().get(i)).getType());
                                                        modelValues.createColumns.get(property.getDbTable()).put(type.getName(), type);
                                                        ++i;
                                                    }
                                                    break block96;
                                                }
                                                if (!POJOGEN_IGNORE_EXPORTS.equals(property.getName())) break block110;
                                                if (!modelValues.ignoreExports.containsKey(property.getDbTable())) {
                                                    modelValues.ignoreExports.put(property.getDbTable(), new HashMap());
                                                }
                                                Map<String, Map<String, String>> exports = modelValues.ignoreExports.get(property.getDbTable());
                                                int i = 0;
                                                int m = property.getExports().size();
                                                while (i < m) {
                                                    ExportAssignement export = (ExportAssignement)property.getExports().get(i);
                                                    if (!exports.containsKey(export.getDbColumn())) {
                                                        exports.put(export.getDbColumn(), new HashMap());
                                                    }
                                                    exports.get(export.getDbColumn()).put(export.getFkTable(), export.getFkColumn());
                                                    ++i;
                                                }
                                                break block96;
                                            }
                                            if (!POJOGEN_IGNORE_IMPORTS.equals(property.getName())) break block111;
                                            if (!modelValues.ignoreImports.containsKey(property.getDbTable())) {
                                                modelValues.ignoreImports.put(property.getDbTable(), new HashMap());
                                            }
                                            Map<String, Map<String, String>> imports = modelValues.ignoreImports.get(property.getDbTable());
                                            int i = 0;
                                            int m = property.getImports().size();
                                            while (i < m) {
                                                ImportAssignement _import = (ImportAssignement)property.getImports().get(i);
                                                if (!imports.containsKey(_import.getDbColumn())) {
                                                    imports.put(_import.getDbColumn(), new HashMap());
                                                }
                                                imports.get(_import.getDbColumn()).put(_import.getPkTable(), _import.getPkColumn());
                                                ++i;
                                            }
                                            break block96;
                                        }
                                        if (!POJOGEN_CREATE_EXPORTS.equals(property.getName())) break block112;
                                        if (!modelValues.createExports.containsKey(property.getDbTable())) {
                                            modelValues.createExports.put(property.getDbTable(), new HashMap());
                                        }
                                        Map<String, Map<String, String>> exports = modelValues.createExports.get(property.getDbTable());
                                        int i = 0;
                                        int m = property.getExports().size();
                                        while (i < m) {
                                            ExportAssignement export = (ExportAssignement)property.getExports().get(i);
                                            if (!exports.containsKey(export.getDbColumn())) {
                                                exports.put(export.getDbColumn(), new HashMap());
                                            }
                                            exports.get(export.getDbColumn()).put(export.getFkTable(), export.getFkColumn());
                                            ++i;
                                        }
                                        break block96;
                                    }
                                    if (!POJOGEN_CREATE_IMPORTS.equals(property.getName())) break block113;
                                    if (!modelValues.createImports.containsKey(property.getDbTable())) {
                                        modelValues.createImports.put(property.getDbTable(), new HashMap());
                                    }
                                    Map<String, Map<String, String>> imports = modelValues.createImports.get(property.getDbTable());
                                    int i = 0;
                                    int m = property.getImports().size();
                                    while (i < m) {
                                        ImportAssignement _import = (ImportAssignement)property.getImports().get(i);
                                        if (!imports.containsKey(_import.getDbColumn())) {
                                            imports.put(_import.getDbColumn(), new HashMap());
                                        }
                                        imports.get(_import.getDbColumn()).put(_import.getPkTable(), _import.getPkColumn());
                                        ++i;
                                    }
                                    break block96;
                                }
                                if (!POJOGEN_INHERIT_IMPORTS.equals(property.getName())) break block114;
                                if (!modelValues.inheritImports.containsKey(property.getDbTable())) {
                                    modelValues.inheritImports.put(property.getDbTable(), new HashMap());
                                }
                                Map<String, Map<String, String>> imports = modelValues.inheritImports.get(property.getDbTable());
                                int i = 0;
                                int m = property.getImports().size();
                                while (i < m) {
                                    ImportAssignement _import = (ImportAssignement)property.getImports().get(i);
                                    if (!imports.containsKey(_import.getDbColumn())) {
                                        imports.put(_import.getDbColumn(), new HashMap());
                                    }
                                    imports.get(_import.getDbColumn()).put(_import.getPkTable(), _import.getPkColumn());
                                    ++i;
                                }
                                break block96;
                            }
                            if (!POJOGEN_MANY_TO_MANY_IMPORTS.equals(property.getName())) break block115;
                            if (!modelValues.manyToManyImports.containsKey(property.getDbTable())) {
                                modelValues.manyToManyImports.put(property.getDbTable(), new HashMap());
                            }
                            Map<String, Map<String, String>> many2s = modelValues.manyToManyImports.get(property.getDbTable());
                            int i = 0;
                            int m = property.getMany2s().size();
                            while (i < m) {
                                ManyToManyAssignement many2 = (ManyToManyAssignement)property.getMany2s().get(i);
                                if (!many2s.containsKey(many2.getPkColumn())) {
                                    many2s.put(many2.getPkColumn(), new HashMap());
                                }
                                many2s.get(many2.getPkColumn()).put(many2.getPkTable(), many2.getFkColumn());
                                ++i;
                            }
                            break block96;
                        }
                        if (!POJOGEN_INHERITANCE.equals(property.getName())) break block116;
                        if (!modelValues.inheritance.containsKey(property.getDbTable())) {
                            modelValues.inheritance.put(property.getDbTable(), new HashMap());
                        }
                        modelValues.inheritanceColumns.put(property.getDbTable(), property.getDbColumn());
                        Map<String, Map<String, List<String>>> inherits = modelValues.inheritance.get(property.getDbTable());
                        int i = 0;
                        int m = property.getInheritance().size();
                        while (i < m) {
                            InheritanceAssignement _inherit = (InheritanceAssignement)property.getInheritance().get(i);
                            if (!inherits.containsKey(_inherit.getDiscriminator())) {
                                inherits.put(_inherit.getDiscriminator(), new HashMap());
                            }
                            inherits.get(_inherit.getDiscriminator()).put(_inherit.getDbTable(), (List<String>)_inherit.getDbColumns());
                            ++i;
                        }
                        break block96;
                    }
                    if (!POJOGEN_GENERATE_METHODS.equals(property.getName())) break block117;
                    int i = 0;
                    int m = property.getMethods().size();
                    while (i < m) {
                        modelValues.generateMethods.add((String)property.getMethods().get(i));
                        ++i;
                    }
                    break block96;
                }
                if (!"generate-operators".equals(property.getName())) break block118;
                modelValues.generateOperators = ModelPropertyBean.getPropertyValue(property.getOperatorsSuffix());
                if (modelValues.generateOperators != null) break block96;
                modelValues.generateOperators = "operators";
                break block96;
            }
            if ("implements-interfaces".equals(property.getName())) {
                ImplementsExtends ie = new ImplementsExtends(property.getToImplements().getToImplement(), false, (List<String>)property.getToImplements().getDbTables(), (List<String>)property.getToImplements().getDbNotTables());
                modelValues.toImplements.put(property.getToImplements().getToImplement().getIdentifier(), ie);
            } else if ("extends-class".equals(property.getName())) {
                ImplementsExtends ie;
                modelValues.toExtends = ie = new ImplementsExtends(property.getToExtends().getToExtends(), false, (List<String>)property.getToExtends().getDbTables(), (List<String>)property.getToExtends().getDbNotTables());
            } else if ("implements-interfaces-generics".equals(property.getName())) {
                ImplementsExtends ie = new ImplementsExtends(property.getToImplementsGenerics().getToImplement(), true, (List<String>)property.getToImplementsGenerics().getDbTables(), (List<String>)property.getToImplementsGenerics().getDbNotTables());
                modelValues.toImplements.put(property.getToImplementsGenerics().getToImplement().getIdentifier(), ie);
            } else if ("extends-class-generics".equals(property.getName())) {
                ImplementsExtends ie;
                modelValues.toExtends = ie = new ImplementsExtends(property.getToExtendsGenerics().getToExtends(), true, (List<String>)property.getToExtendsGenerics().getDbTables(), (List<String>)property.getToExtendsGenerics().getDbNotTables());
            } else if (POJOGEN_JOIN_TABLES.equals(property.getName())) {
                int i = 0;
                int m = property.getJoinTables().size();
                while (i < m) {
                    JoinTableAssignement joinTableAssignement = (JoinTableAssignement)property.getJoinTables().get(i);
                    if (!modelValues.joinTables.containsKey(joinTableAssignement.getDbTable())) {
                        modelValues.joinTables.put(joinTableAssignement.getDbTable(), new ArrayList());
                    }
                    for (String dbTable : joinTableAssignement.getDbTables()) {
                        modelValues.joinTables.get(joinTableAssignement.getDbTable()).add(dbTable);
                    }
                    ++i;
                }
            } else if (POJOGEN_GENERATE_WRAPPERS.equals(property.getName())) {
                modelValues.doGenerateWrappers = true;
            } else if (POJOGEN_GENERATE_VALIDATION_ANNOTATIONS.equals(property.getName())) {
                modelValues.doGenerateValidationAnnotations = true;
            } else if ("make-it-final".equals(property.getName())) {
                modelValues.makeItFinal = true;
            } else if (POJOGEN_VERSION_COLUMN.equals(property.getName())) {
                String versionColumn = property.getVersion();
                if ((property.getDbTables() == null || property.getDbTables().isEmpty()) && (property.getDbNotTables() == null || property.getDbNotTables().isEmpty())) {
                    modelValues.versionColumn = versionColumn;
                } else if (property.getDbTables() != null && !property.getDbTables().isEmpty()) {
                    if (!modelValues.versionColumns.containsKey(versionColumn)) {
                        modelValues.versionColumns.put(versionColumn, new HashSet());
                    }
                    int i = 0;
                    int m = property.getDbTables().size();
                    while (i < m) {
                        modelValues.versionColumns.get(versionColumn).add((String)property.getDbTables().get(i));
                        ++i;
                    }
                } else {
                    if (!modelValues.notVersionColumns.containsKey(versionColumn)) {
                        modelValues.notVersionColumns.put(versionColumn, new HashSet());
                    }
                    int i = 0;
                    int m = property.getDbNotTables().size();
                    while (i < m) {
                        modelValues.notVersionColumns.get(versionColumn).add((String)property.getDbNotTables().get(i));
                        ++i;
                    }
                }
            } else if ("debug-level".equals(property.getName()) && property.getDebug().getDebug() != null) {
                modelValues.debugLevel = property.getDebug().getDebug();
                modelValues.debugScope = property.getDebug().getScope();
            } else if (POJOGEN_PRESERVE_FOREIGN_KEYS.equals(property.getName())) {
                if (property.getDbTables().isEmpty()) {
                    modelValues.preserveForeignKeys.add("_ALL_");
                } else {
                    int i = 0;
                    int m = property.getDbTables().size();
                    while (i < m) {
                        modelValues.preserveForeignKeys.add((String)property.getDbTables().get(i));
                        ++i;
                    }
                }
            } else if (POJOGEN_POJOS_FOR_PROCEDURES.equals(property.getName())) {
                int i = 0;
                int m = property.getProcPojos().size();
                while (i < m) {
                    modelValues.pojosForProcedures.put(((ProcedurePojoAssignement)property.getProcPojos().get(i)).getDbProcedure(), ((ProcedurePojoAssignement)property.getProcPojos().get(i)).getPojo());
                    ++i;
                }
            } else if (POJOGEN_POJOS_FOR_FUNCTIONS.equals(property.getName())) {
                int i = 0;
                int m = property.getFunPojos().size();
                while (i < m) {
                    modelValues.pojosForFunctions.put(((FunctionPojoAssignement)property.getFunPojos().get(i)).getDbFunction(), ((FunctionPojoAssignement)property.getFunPojos().get(i)).getPojo());
                    ++i;
                }
            } else if ("active-filter".equals(property.getName())) {
                modelValues.activeFilter = property.getActiveFilter();
            } else if ("package".equals(property.getName())) {
                modelValues.pckg = property.getPckg();
            } else if (POJOGEN_ENUM_FOR_CHECK_CONSTRAINTS.equals(property.getName())) {
                int i = 0;
                int m = property.getDbCheckConstraints().size();
                while (i < m) {
                    if (i == 0) {
                        modelValues.enumForCheckConstraints.put(property.getEnumName(), (String)property.getDbCheckConstraints().get(i));
                    }
                    modelValues.enumForCheckConstraints.put((String)property.getDbCheckConstraints().get(i), property.getEnumName());
                    ++i;
                }
            }
        }
    }

    private static void setValue(ModelValues modelValues, MetagenProperty property) {
        if (property == null) {
            return;
        }
        if (METAGEN_GLOBAL_IDENTITY.equals(property.getName())) {
            modelValues.metaGlobalIdentity = new PairValues(property.getIdentity(), property.getType());
            if (property.getDbTables() != null) {
                modelValues.metaGlobalIdentityForTables.addAll((Collection<String>)property.getDbTables());
            }
            if (property.getDbNotTables() != null) {
                modelValues.metaGlobalIdentityNotForTables.addAll((Collection<String>)property.getDbNotTables());
            }
        } else if (METAGEN_TABLE_IDENTITY.equals(property.getName())) {
            modelValues.metaTablesIdentity.put(property.getDbTable(), new PairValues(property.getIdentity(), property.getType()));
        } else if (METAGEN_GLOBAL_SEQUENCE.equals(property.getName())) {
            modelValues.metaGlobalSequence = new PairValues(property.getSequence(), property.getType());
            if (property.getDbTables() != null) {
                modelValues.metaGlobalSequenceForTables.addAll((Collection<String>)property.getDbTables());
            }
            if (property.getDbNotTables() != null) {
                modelValues.metaGlobalSequenceNotForTables.addAll((Collection<String>)property.getDbNotTables());
            }
        } else if (METAGEN_TABLE_SEQUENCE.equals(property.getName())) {
            modelValues.metaTablesSequence.put(property.getDbTable(), new PairValues(property.getSequence(), property.getType()));
        } else if (METAGEN_COLUMN_META_TYPE.equals(property.getName())) {
            if (!modelValues.metaColumnsMetaTypes.containsKey(property.getDbTable())) {
                modelValues.metaColumnsMetaTypes.put(property.getDbTable(), new HashMap());
            }
            int i = 0;
            int m = property.getMetaTypes().size();
            while (i < m) {
                MetaTypeAssignement metaType = (MetaTypeAssignement)property.getMetaTypes().get(i);
                modelValues.metaColumnsMetaTypes.get(property.getDbTable()).put(metaType.getDbColumn(), new PairValues(metaType.getType(), metaType.getExtension()));
                ++i;
            }
        } else if (METAGEN_STATEMENT_META_TYPE.equals(property.getName())) {
            if (!modelValues.metaStatementsMetaTypes.containsKey(property.getDbStatement())) {
                modelValues.metaStatementsMetaTypes.put(property.getDbStatement(), new HashMap());
            }
            int i = 0;
            int m = property.getMetaTypes().size();
            while (i < m) {
                MetaTypeAssignement metaType = (MetaTypeAssignement)property.getMetaTypes().get(i);
                modelValues.metaStatementsMetaTypes.get(property.getDbStatement()).put(metaType.getDbColumn(), new PairValues(metaType.getType(), metaType.getExtension()));
                ++i;
            }
        } else if ("make-it-final".equals(property.getName())) {
            modelValues.metaMakeItFinal = true;
        } else if (METAGEN_LIKE_COLUMNS.equals(property.getName())) {
            if (property.getDbTable() == null) {
                modelValues.metaLikeColumns.put(GLOBAL, new HashSet());
            } else {
                if (!modelValues.metaLikeColumns.containsKey(property.getDbTable())) {
                    modelValues.metaLikeColumns.put(property.getDbTable(), new HashSet());
                }
                int i = 0;
                int m = property.getDbColumns().size();
                while (i < m) {
                    modelValues.metaLikeColumns.get(property.getDbTable()).add((String)property.getDbColumns().get(i));
                    ++i;
                }
            }
        } else if (METAGEN_NOT_LIKE_COLUMNS.equals(property.getName())) {
            if (property.getDbTable() == null) {
                modelValues.metaNotLikeColumns.put(GLOBAL, new HashSet());
            } else {
                if (!modelValues.metaNotLikeColumns.containsKey(property.getDbTable())) {
                    modelValues.metaNotLikeColumns.put(property.getDbTable(), new HashSet());
                }
                int i = 0;
                int m = property.getDbColumns().size();
                while (i < m) {
                    modelValues.metaNotLikeColumns.get(property.getDbTable()).add((String)property.getDbColumns().get(i));
                    ++i;
                }
            }
        } else if (METAGEN_GENERATE_SEQUENCES.equals(property.getName())) {
            modelValues.metaGenerateSequences = true;
        } else if (METAGEN_GENERATE_IDENTITIES.equals(property.getName())) {
            modelValues.metaGenerateIdentities = true;
        } else if (METAGEN_GENERATE_IDGENERATORS.equals(property.getName())) {
            modelValues.metaGenerateIdGenerators = true;
        } else if (METAGEN_GENERATE_INDIRECT_IDGENERATORS.equals(property.getName())) {
            modelValues.metaGenerateIndirectIdGenerators = true;
        } else if ("function-result".equals(property.getName())) {
            modelValues.metaFunctionsResult.put(property.getDbFunction(), property.getType());
        } else if (METAGEN_FUNCTION_RESULT_SET.equals(property.getName())) {
            modelValues.metaFunctionsResultSet.put(property.getDbFunction(), property.getDbTable());
        } else if (METAGEN_PROCEDURE_RESULT_SET.equals(property.getName())) {
            modelValues.metaProceduresResultSet.put(property.getDbProcedure(), property.getDbTable());
        } else if ("debug-level".equals(property.getName()) && property.getDebug() != null) {
            modelValues.metaDebugLevel = property.getDebug().getDebug();
            modelValues.metaDebugScope = property.getDebug().getScope();
        } else if ("generate-operators".equals(property.getName())) {
            modelValues.metaGenerateOperators = true;
        } else if (METAGEN_OPTIMIZE_INSERT.equals(property.getName())) {
            if (property.getDbTables().isEmpty()) {
                modelValues.metaOptimizeInsert.add("_ALL_");
            } else {
                int i = 0;
                int m = property.getDbTables().size();
                while (i < m) {
                    modelValues.metaOptimizeInsert.add((String)property.getDbTables().get(i));
                    ++i;
                }
            }
        } else if (METAGEN_OPTIONAL_FEATURES.equals(property.getName())) {
            if (!modelValues.metaOptionalFeatures.containsKey(property.getDbStatement())) {
                modelValues.metaOptionalFeatures.put(property.getDbStatement(), new HashSet());
            }
            int i = 0;
            int m = property.getOptionalFeatures().size();
            while (i < m) {
                String optionalFeature = (String)property.getOptionalFeatures().get(i);
                modelValues.metaOptionalFeatures.get(property.getDbStatement()).add(optionalFeature);
                ++i;
            }
        } else if ("active-filter".equals(property.getName())) {
            modelValues.metaActiveFilter = property.getActiveFilter();
        }
    }

    private static void setValue(ModelValues modelValues, DaogenProperty property) {
        if (property == null) {
            return;
        }
        if ("ignore-tables".equals(property.getName())) {
            int i = 0;
            int m = property.getDbTables().size();
            while (i < m) {
                modelValues.daoIgnoreTables.add((String)property.getDbTables().get(i));
                ++i;
            }
        } else if ("only-tables".equals(property.getName())) {
            int i = 0;
            int m = property.getDbTables().size();
            while (i < m) {
                modelValues.daoOnlyTables.add((String)property.getDbTables().get(i));
                ++i;
            }
        } else if ("implements-interfaces".equals(property.getName())) {
            ImplementsExtends ie = new ImplementsExtends(property.getToImplements().getToImplement(), false, (List<String>)property.getToImplements().getDbTables(), (List<String>)property.getToImplements().getDbNotTables());
            modelValues.daoToImplements.put(property.getToImplements().getToImplement().getIdentifier(), ie);
        } else if ("extends-class".equals(property.getName())) {
            ImplementsExtends ie;
            modelValues.daoToExtends = ie = new ImplementsExtends(property.getToExtends().getToExtends(), false, (List<String>)property.getToExtends().getDbTables(), (List<String>)property.getToExtends().getDbNotTables());
        } else if ("implements-interfaces-generics".equals(property.getName())) {
            ImplementsExtends ie = new ImplementsExtends(property.getToImplementsGenerics().getToImplement(), true, (List<String>)property.getToImplementsGenerics().getDbTables(), (List<String>)property.getToImplementsGenerics().getDbNotTables());
            modelValues.daoToImplements.put(property.getToImplementsGenerics().getToImplement().getIdentifier(), ie);
        } else if ("extends-class-generics".equals(property.getName())) {
            ImplementsExtends ie;
            modelValues.daoToExtends = ie = new ImplementsExtends(property.getToExtendsGenerics().getToExtends(), true, (List<String>)property.getToExtendsGenerics().getDbTables(), (List<String>)property.getToExtendsGenerics().getDbNotTables());
        } else if ("make-it-final".equals(property.getName())) {
            modelValues.daoMakeItFinal = true;
        } else if ("function-result".equals(property.getName())) {
            modelValues.daoFunctionsResult.put(property.getDbFunction(), property.getResultType());
        } else if ("debug-level".equals(property.getName()) && property.getDebug().getDebug() != null) {
            modelValues.daoDebugLevel = property.getDebug().getDebug();
            modelValues.daoDebugScope = property.getDebug().getScope();
        } else if ("active-filter".equals(property.getName())) {
            modelValues.daoActiveFilter = property.getActiveFilter();
        } else if ("package".equals(property.getName())) {
            modelValues.daoPckg = property.getPckg();
        }
    }

    @Override
    public boolean isDoResolvePojo(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.doResolvePojo : false;
    }

    @Override
    public boolean isDoResolveDb(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.doResolveDb : false;
    }

    @Override
    public Map<String, String> getReplaceAll(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        if (modelValues == null || modelValues.replaceAllRegex == null || modelValues.replaceAllReplacement == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String replaceId : modelValues.replaceAllRegex.keySet()) {
            if (!modelValues.replaceAllReplacement.containsKey(replaceId)) continue;
            result.put(modelValues.replaceAllRegex.get(replaceId), modelValues.replaceAllReplacement.get(replaceId));
        }
        return result;
    }

    @Override
    public boolean isCompressMetaDirectives(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.doCompressMetaDirectives : false;
    }

    @Override
    public Map<String, PojoAttrType> getSqlTypes(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.sqlTypes : Collections.emptyMap();
    }

    @Override
    public Map<String, Map<String, PojoAttrType>> getTableTypes(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.tableTypes : Collections.emptyMap();
    }

    @Override
    public Map<String, Map<String, PojoAttrType>> getColumnTypes(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.columnTypes : Collections.emptyMap();
    }

    @Override
    public Map<String, Map<String, PojoAttrType>> getProcedureTypes(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.procedureTypes : Collections.emptyMap();
    }

    @Override
    public Map<String, Map<String, PojoAttrType>> getFunctionTypes(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.functionTypes : Collections.emptyMap();
    }

    @Override
    public Map<String, String> getTableNames(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.tableNames : Collections.emptyMap();
    }

    @Override
    public Map<String, Map<String, String>> getColumnNames(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.columnNames : Collections.emptyMap();
    }

    @Override
    public Set<String> getIgnoreTables(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.ignoreTables : Collections.emptySet();
    }

    @Override
    public Set<String> getOnlyTables(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.onlyTables : Collections.emptySet();
    }

    @Override
    public Set<String> getNotAbstractTables(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.notAbstractTables : Collections.emptySet();
    }

    @Override
    public Map<String, Set<String>> getIgnoreColumns(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.ignoreColumns : Collections.emptyMap();
    }

    @Override
    public Map<String, Set<String>> getRequiredColumns(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.requiredColumns : Collections.emptyMap();
    }

    @Override
    public Map<String, Set<String>> getNotRequiredColumns(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.notRequiredColumns : Collections.emptyMap();
    }

    @Override
    public Map<String, Map<String, PojoAttrType>> getCreateColumns(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.createColumns : Collections.emptyMap();
    }

    @Override
    public Map<String, Map<String, Map<String, String>>> getIgnoreExports(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.ignoreExports : Collections.emptyMap();
    }

    @Override
    public Map<String, Map<String, Map<String, String>>> getIgnoreImports(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.ignoreImports : Collections.emptyMap();
    }

    @Override
    public Map<String, Map<String, Map<String, String>>> getCreateExports(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.createExports : Collections.emptyMap();
    }

    @Override
    public Map<String, Map<String, Map<String, String>>> getCreateImports(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.createImports : Collections.emptyMap();
    }

    @Override
    public Map<String, Map<String, Map<String, String>>> getInheritImports(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.inheritImports : Collections.emptyMap();
    }

    @Override
    public Map<String, Map<String, Map<String, String>>> getManyToManyImports(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.manyToManyImports : Collections.emptyMap();
    }

    @Override
    public Map<String, Map<String, Map<String, List<String>>>> getInheritance(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.inheritance : Collections.emptyMap();
    }

    @Override
    public Map<String, String> getInheritanceColumns(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.inheritanceColumns : Collections.emptyMap();
    }

    @Override
    public Set<String> getGenerateMethods(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.generateMethods : Collections.emptySet();
    }

    @Override
    public String getGenerateOperators(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.generateOperators : null;
    }

    @Override
    public Map<String, ImplementsExtends> getToImplements(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.toImplements : Collections.emptyMap();
    }

    @Override
    public ImplementsExtends getToExtends(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.toExtends : null;
    }

    @Override
    public Map<String, List<String>> getJoinTables(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.joinTables : Collections.emptyMap();
    }

    @Override
    public boolean isDoGenerateWrappers(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.doGenerateWrappers : false;
    }

    @Override
    public boolean isDoGenerateValidationAnnotations(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.doGenerateValidationAnnotations : false;
    }

    @Override
    public boolean isMakeItFinal(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.makeItFinal : false;
    }

    @Override
    public String getVersionColumn(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.versionColumn : null;
    }

    @Override
    public Map<String, Set<String>> getVersionColumns(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.versionColumns : Collections.emptyMap();
    }

    @Override
    public Map<String, Set<String>> getNotVersionColumns(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.notVersionColumns : Collections.emptyMap();
    }

    @Override
    public String getDebugLevel(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.debugLevel : null;
    }

    @Override
    public String getDebugScope(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.debugScope : null;
    }

    @Override
    public Set<String> getPreserveForeignKeys(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.preserveForeignKeys : Collections.emptySet();
    }

    @Override
    public PairValues getMetaGlobalIdentity(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaGlobalIdentity : null;
    }

    @Override
    public Map<String, PojoType> getPojosForProcedures(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.pojosForProcedures : Collections.emptyMap();
    }

    @Override
    public Map<String, PojoType> getPojosForFunctions(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.pojosForFunctions : Collections.emptyMap();
    }

    @Override
    public String getActiveFilter(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.activeFilter : null;
    }

    @Override
    public String getPackage(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.pckg : null;
    }

    @Override
    public Map<String, String> getEnumForCheckConstraints(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.enumForCheckConstraints : Collections.emptyMap();
    }

    @Override
    public Map<String, PairValues> getMetaTablesIdentity(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaTablesIdentity : Collections.emptyMap();
    }

    @Override
    public PairValues getMetaGlobalSequence(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaGlobalSequence : null;
    }

    @Override
    public Map<String, PairValues> getMetaTablesSequence(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaTablesSequence : Collections.emptyMap();
    }

    @Override
    public Map<String, Map<String, PairValues>> getMetaColumnsMetaTypes(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaColumnsMetaTypes : Collections.emptyMap();
    }

    @Override
    public Map<String, Map<String, PairValues>> getMetaStatementsMetaTypes(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaStatementsMetaTypes : Collections.emptyMap();
    }

    @Override
    public boolean isMetaMakeItFinal(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaMakeItFinal : false;
    }

    @Override
    public Map<String, Set<String>> getMetaLikeColumns(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaLikeColumns : Collections.emptyMap();
    }

    @Override
    public Map<String, Set<String>> getMetaNotLikeColumns(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaNotLikeColumns : Collections.emptyMap();
    }

    @Override
    public boolean isMetaGenerateSequences(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaGenerateSequences : false;
    }

    @Override
    public Set<String> getMetaGlobalSequenceForTables(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaGlobalSequenceForTables : Collections.emptySet();
    }

    @Override
    public Set<String> getMetaGlobalSequenceNotForTables(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaGlobalSequenceNotForTables : Collections.emptySet();
    }

    @Override
    public boolean isMetaGenerateIdentities(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaGenerateIdentities : false;
    }

    @Override
    public Set<String> getMetaGlobalIdentityForTables(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaGlobalIdentityForTables : Collections.emptySet();
    }

    @Override
    public Set<String> getMetaGlobalIdentityNotForTables(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaGlobalIdentityNotForTables : Collections.emptySet();
    }

    @Override
    public boolean isMetaGenerateIdGenerators(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaGenerateIdGenerators : false;
    }

    @Override
    public boolean isMetaGenerateIndirectIdGenerators(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaGenerateIndirectIdGenerators : false;
    }

    @Override
    public Map<String, String> getMetaFunctionsResult(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaFunctionsResult : Collections.emptyMap();
    }

    @Override
    public Map<String, String> getMetaFunctionsResultSet(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaFunctionsResultSet : Collections.emptyMap();
    }

    @Override
    public Map<String, String> getMetaProceduresResultSet(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaProceduresResultSet : Collections.emptyMap();
    }

    @Override
    public String getMetaDebugLevel(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaDebugLevel : null;
    }

    @Override
    public String getMetaDebugScope(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaDebugScope : null;
    }

    @Override
    public boolean isMetaGenerateOperators(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaGenerateOperators : false;
    }

    @Override
    public Set<String> getMetaOptimizeInsert(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaOptimizeInsert : Collections.emptySet();
    }

    @Override
    public Map<String, Set<String>> getMetaOptionalFeatures(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaOptionalFeatures : Collections.emptyMap();
    }

    @Override
    public String getMetaActiveFilter(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.metaActiveFilter : null;
    }

    @Override
    public Set<String> getDaoIgnoreTables(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.daoIgnoreTables : Collections.emptySet();
    }

    @Override
    public Set<String> getDaoOnlyTables(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.daoOnlyTables : Collections.emptySet();
    }

    @Override
    public Map<String, ImplementsExtends> getDaoToImplements(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.daoToImplements : Collections.emptyMap();
    }

    @Override
    public ImplementsExtends getDaoToExtends(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.daoToExtends : null;
    }

    @Override
    public boolean isDaoMakeItFinal(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.daoMakeItFinal : false;
    }

    @Override
    public Map<String, PojoType> getDaoFunctionsResult(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.daoFunctionsResult : Collections.emptyMap();
    }

    @Override
    public String getDaoDebugLevel(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.daoDebugLevel : null;
    }

    @Override
    public String getDaoDebugScope(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.daoDebugScope : null;
    }

    @Override
    public String getDaoActiveFilter(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.daoActiveFilter : null;
    }

    @Override
    public String getDaoPackage(EObject model) {
        ModelValues modelValues = this.getModelValues(model);
        return modelValues != null ? modelValues.daoPckg : null;
    }

    @Override
    public ModelValues getModelValues(EObject model) {
        if (this.modelValues != null) {
            return this.modelValues;
        }
        EObject emodel = model;
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)emodel, Artifacts.class);
        if (artifacts == null) {
            this.LOGGER.error((Object)("UKNOWN ARTIFACTS FOR " + emodel));
            return null;
        }
        if (artifacts.eResource() == null) {
            this.LOGGER.error((Object)("UKNOWN RESOURCE FOR " + artifacts));
            return null;
        }
        String dir = Utils.resourceDir(artifacts.eResource());
        if (dir == null) {
            this.LOGGER.error((Object)("LOADED RESOURCE URI IS NOT VALID " + artifacts.eResource().getURI()));
            return null;
        }
        return this.dirs2models.get(dir);
    }

    public String toString() {
        return "ModelPropertyBean [dirs2models=" + this.dirs2models + "]";
    }

    public static class ModelValues {
        public boolean doResolvePojo;
        public boolean doResolveDb;
        public Map<String, String> replaceAllRegex;
        public Map<String, String> replaceAllReplacement;
        public boolean doCompressMetaDirectives;
        public String dbDriver;
        public String dbUrl;
        public String dbUsername;
        public String dbPassword;
        public String dbCatalog;
        public String dbSchema;
        public String dbSqlsBefore;
        public String dbSqlsAfter;
        public String dbIndexTypes;
        public boolean dbSkipIndexes;
        public boolean dbSkipProcedures;
        public boolean dbSkipCheckConstraints;
        public String dbType;
        public String dbDebugLevel;
        public String dbDebugScope;
        public boolean dbTakeComments;
        public boolean dbLowercaseNames;
        public boolean dbUppercaseNames;
        public String dir;
        public Map<String, PojoAttrType> sqlTypes;
        public Map<String, Map<String, PojoAttrType>> tableTypes;
        public Map<String, Map<String, PojoAttrType>> columnTypes;
        public Map<String, Map<String, PojoAttrType>> procedureTypes;
        public Map<String, Map<String, PojoAttrType>> functionTypes;
        public Map<String, String> tableNames;
        public Map<String, Map<String, String>> columnNames;
        public Set<String> ignoreTables;
        public Set<String> onlyTables;
        public Set<String> notAbstractTables;
        public Map<String, Set<String>> ignoreColumns;
        public Map<String, Set<String>> requiredColumns;
        public Map<String, Set<String>> notRequiredColumns;
        public Map<String, Map<String, PojoAttrType>> createColumns;
        public Map<String, Map<String, Map<String, String>>> ignoreExports;
        public Map<String, Map<String, Map<String, String>>> ignoreImports;
        public Map<String, Map<String, Map<String, String>>> createExports;
        public Map<String, Map<String, Map<String, String>>> createImports;
        public Map<String, Map<String, Map<String, String>>> inheritImports;
        public Map<String, Map<String, Map<String, String>>> manyToManyImports;
        public Map<String, Map<String, Map<String, List<String>>>> inheritance = new HashMap<String, Map<String, Map<String, List<String>>>>();
        public Map<String, String> inheritanceColumns;
        public Set<String> generateMethods;
        public String generateOperators;
        public Map<String, ImplementsExtends> toImplements;
        public ImplementsExtends toExtends;
        public Map<String, List<String>> joinTables;
        public boolean doGenerateWrappers;
        public boolean doGenerateValidationAnnotations;
        public boolean makeItFinal;
        public String versionColumn;
        public Map<String, Set<String>> versionColumns;
        public Map<String, Set<String>> notVersionColumns;
        public String debugLevel;
        public String debugScope;
        public Set<String> preserveForeignKeys;
        public Map<String, PojoType> pojosForProcedures;
        public Map<String, PojoType> pojosForFunctions;
        public String activeFilter;
        public String pckg;
        public Map<String, String> enumForCheckConstraints;
        public PairValues metaGlobalSequence;
        public Map<String, PairValues> metaTablesSequence;
        public PairValues metaGlobalIdentity;
        public Map<String, PairValues> metaTablesIdentity;
        public Map<String, Map<String, PairValues>> metaColumnsMetaTypes;
        public Map<String, Map<String, PairValues>> metaStatementsMetaTypes;
        public boolean metaMakeItFinal;
        public Map<String, Set<String>> metaLikeColumns;
        public Map<String, Set<String>> metaNotLikeColumns;
        public boolean metaGenerateSequences;
        public Set<String> metaGlobalSequenceForTables;
        public Set<String> metaGlobalSequenceNotForTables;
        public boolean metaGenerateIdentities;
        public Set<String> metaGlobalIdentityForTables;
        public Set<String> metaGlobalIdentityNotForTables;
        public boolean metaGenerateIdGenerators;
        public boolean metaGenerateIndirectIdGenerators;
        public Map<String, String> metaFunctionsResult;
        public Map<String, String> metaFunctionsResultSet;
        public Map<String, String> metaProceduresResultSet;
        public String metaDebugLevel;
        public String metaDebugScope;
        public boolean metaGenerateOperators;
        public Set<String> metaOptimizeInsert;
        public Map<String, Set<String>> metaOptionalFeatures;
        public String metaActiveFilter;
        public Set<String> daoIgnoreTables;
        public Set<String> daoOnlyTables;
        public Map<String, ImplementsExtends> daoToImplements;
        public ImplementsExtends daoToExtends;
        public boolean daoMakeItFinal;
        public Map<String, PojoType> daoFunctionsResult;
        public String daoDebugLevel;
        public String daoDebugScope;
        public String daoActiveFilter;
        public String daoPckg;
    }

    public static class PairValues {
        public String value1;
        public String value2;

        public PairValues(String value1, String value2) {
            this.value1 = value1;
            this.value2 = value2;
        }
    }
}

