/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.generator;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.sqlproc.dsl.generator.TableMetaGenerator;
import org.sqlproc.dsl.generator.TablePojoGenerator;
import org.sqlproc.dsl.processorDsl.Artifacts;
import org.sqlproc.dsl.processorDsl.PojoType;
import org.sqlproc.dsl.property.ImplementsExtends;
import org.sqlproc.dsl.property.ModelProperty;
import org.sqlproc.dsl.property.PojoAttribute;
import org.sqlproc.dsl.resolver.DbResolver;
import org.sqlproc.dsl.util.Debug;

public class TableDaoGenerator
extends TableMetaGenerator {
    protected Logger LOGGER = Logger.getLogger(TableDaoGenerator.class);
    private Debug debug = new Debug(this.LOGGER);
    protected Map<String, String> finalDaos;
    protected Set<String> daoIgnoreTables = new HashSet<String>();
    protected Set<String> daoOnlyTables = new HashSet<String>();
    protected Map<String, ImplementsExtends> daoToImplements = new HashMap<String, ImplementsExtends>();
    protected ImplementsExtends daoToExtends = null;
    protected boolean daoMakeItFinal;
    protected Map<String, PojoType> daoFunctionsResult = new HashMap<String, PojoType>();
    protected TablePojoGenerator.Filter daoActiveFilter = null;

    public TableDaoGenerator() {
    }

    public TableDaoGenerator(ModelProperty modelProperty, Artifacts artifacts, String suffix, IScopeProvider scopeProvider, Map<String, String> finalDaos, List<String> dbSequences, DbResolver.DbType dbType) {
        super(modelProperty, artifacts, null, Collections.emptyMap(), dbSequences, dbType);
        Map<String, ImplementsExtends> daoToImplements;
        Set<String> daoOnlyTables;
        this.debug = new Debug(modelProperty.getDaoDebugLevel(artifacts), modelProperty.getDaoDebugScope(artifacts), this.LOGGER);
        this.suffix = suffix != null ? suffix : "";
        this.finalDaos = finalDaos;
        Set<String> daoIgnoreTables = modelProperty.getDaoIgnoreTables(artifacts);
        if (daoIgnoreTables != null) {
            this.daoIgnoreTables.addAll(daoIgnoreTables);
        }
        if ((daoOnlyTables = modelProperty.getDaoOnlyTables(artifacts)) != null) {
            this.daoOnlyTables.addAll(daoOnlyTables);
        }
        if ((daoToImplements = modelProperty.getDaoToImplements(artifacts)) != null) {
            this.daoToImplements.putAll(daoToImplements);
        }
        this.daoToExtends = modelProperty.getDaoToExtends(artifacts);
        this.daoMakeItFinal = modelProperty.isDaoMakeItFinal(artifacts);
        Map<String, PojoType> daoFunctionsResult = modelProperty.getDaoFunctionsResult(artifacts);
        if (daoFunctionsResult != null) {
            this.daoFunctionsResult.putAll(daoFunctionsResult);
        }
        this.daoActiveFilter = TablePojoGenerator.Filter.parse(modelProperty.getDaoActiveFilter(artifacts));
        if (this.debug.debug) {
            System.out.println("finalDaos " + this.finalDaos);
            System.out.println("daoIgnoreTables " + this.daoIgnoreTables);
            System.out.println("daoOnlyTables " + this.daoOnlyTables);
            System.out.println("daoToImplements " + this.daoToImplements);
            System.out.println("daoToExtends " + this.daoToExtends);
            System.out.println("daoFunctionsResult " + this.daoFunctionsResult);
            System.out.println("daoActiveFilter " + this.daoActiveFilter);
        }
    }

    public String getDaoDefinitions(ModelProperty modelProperty, Artifacts artifacts) {
        String result = this.getDaoDefinitions();
        return this.replaceAll(modelProperty, result, artifacts);
    }

    /*
     * WARNING - void declaration
     */
    public String getDaoDefinitions() {
        try {
            PojoType ptype;
            String dispName;
            PojoAttribute returnAttribute;
            String name;
            StringBuilder bufferMeta;
            String daoName;
            String pojoName;
            if (this.debug.debug) {
                System.out.println("pojos " + this.pojos);
                System.out.println("pojoExtends " + this.pojoExtends);
                System.out.println("pojoInheritanceDiscriminator " + this.pojoInheritanceDiscriminator);
                System.out.println("pojoInheritanceSimple " + this.pojoInheritanceSimple);
                System.out.println("pojoDiscriminators " + this.pojoDiscriminators);
                System.out.println("indexes " + this.indexes);
                System.out.println("procedures " + this.procedures);
                System.out.println("functions " + this.functions);
            }
            StringBuilder buffer = new StringBuilder();
            boolean isSerializable = false;
            HashSet<String> serializables = new HashSet<String>();
            boolean oneMoreLine = false;
            if (!this.daoToImplements.isEmpty()) {
                for (ImplementsExtends ie : this.daoToImplements.values()) {
                    JvmType type = ie.getToImplement();
                    if (type.getIdentifier().endsWith("Serializable")) {
                        if (!ie.getDbTables().isEmpty()) {
                            for (String dbTable : ie.getDbTables()) {
                                serializables.add(dbTable);
                            }
                            continue;
                        }
                        if (!ie.getDbNotTables().isEmpty()) {
                            for (String pojo : this.pojos.keySet()) {
                                serializables.add(pojo);
                            }
                            for (String pojo : this.enums.keySet()) {
                                serializables.add(pojo);
                            }
                            for (String pojo : this.procedures.keySet()) {
                                serializables.add(pojo);
                            }
                            for (String pojo : this.functions.keySet()) {
                                serializables.add(pojo);
                            }
                            for (String dbTable : ie.getDbNotTables()) {
                                serializables.remove(dbTable);
                            }
                            continue;
                        }
                        isSerializable = true;
                        continue;
                    }
                    if (ie.isGenerics()) {
                        buffer.append("\n  ").append("#Generics");
                    }
                    buffer.append("\n  ").append("implements :").append(type.getIdentifier());
                    if (!ie.getDbTables().isEmpty()) {
                        buffer.append(" onlyDaos");
                        for (String dbColumn : ie.getDbTables()) {
                            void var12_18;
                            String string = (String)this.tableNames.get(dbColumn);
                            if (string == null) {
                                String string2 = dbColumn;
                            }
                            String daoName2 = String.valueOf(this.tableToCamelCase((String)var12_18)) + "Dao";
                            buffer.append(" ").append(daoName2);
                        }
                    }
                    if (ie.getDbNotTables().isEmpty()) continue;
                    buffer.append(" exceptDaos");
                    for (String dbColumn : ie.getDbNotTables()) {
                        void var12_21;
                        String string = (String)this.tableNames.get(dbColumn);
                        if (string == null) {
                            String string3 = dbColumn;
                        }
                        String daoName2 = String.valueOf(this.tableToCamelCase((String)var12_21)) + "Dao";
                        buffer.append(" ").append(daoName2);
                    }
                }
                oneMoreLine = true;
            }
            if (this.daoToExtends != null) {
                JvmType type = this.daoToExtends.getToImplement();
                if (this.daoToExtends.isGenerics()) {
                    buffer.append("\n  ").append("#Generics");
                }
                buffer.append("\n  ").append("extends :").append(type.getIdentifier());
                if (!this.daoToExtends.getDbTables().isEmpty()) {
                    buffer.append(" onlyDaos");
                    for (String dbColumn : this.daoToExtends.getDbTables()) {
                        pojoName = (String)this.tableNames.get(dbColumn);
                        if (pojoName == null) {
                            pojoName = dbColumn;
                        }
                        daoName = String.valueOf(this.tableToCamelCase(pojoName)) + "Dao";
                        buffer.append(" ").append(daoName);
                    }
                }
                if (!this.daoToExtends.getDbNotTables().isEmpty()) {
                    buffer.append(" exceptDaos");
                    for (String dbColumn : this.daoToExtends.getDbNotTables()) {
                        pojoName = (String)this.tableNames.get(dbColumn);
                        if (pojoName == null) {
                            pojoName = dbColumn;
                        }
                        daoName = String.valueOf(this.tableToCamelCase(pojoName)) + "Dao";
                        buffer.append(" ").append(daoName);
                    }
                }
                oneMoreLine = true;
            }
            if (oneMoreLine) {
                buffer.append("\n");
            }
            for (String pojo : this.pojos.keySet()) {
                String daoName3;
                if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(pojo) || this.daoIgnoreTables.contains(pojo) || !TablePojoGenerator.Filter.isTable(this.daoActiveFilter, pojo)) continue;
                String pojoName3 = (String)this.tableNames.get(pojo);
                if (pojoName3 == null) {
                    pojoName3 = pojo;
                }
                if (this.finalDaos.containsKey(daoName3 = String.valueOf(this.tableToCamelCase(pojoName3)) + "Dao")) {
                    buffer.append(this.getFinalContent(this.finalDaos.get(daoName3)));
                    continue;
                }
                if ((this.pojoInheritanceDiscriminator.containsKey(pojo) || this.pojoInheritanceSimple.containsKey(pojo)) && !this.notAbstractTables.contains(pojo)) continue;
                bufferMeta = new StringBuilder();
                if (isSerializable || serializables.contains(pojo)) {
                    bufferMeta.append(this.nlindent()).append("#Serializable(1)");
                }
                LinkedHashMap<String, String> toInit = new LinkedHashMap<String, String>();
                this.toInits(pojo, toInit);
                for (Map.Entry entry : toInit.entrySet()) {
                    String pojoName2;
                    bufferMeta.append(this.nlindent()).append("#InheritanceHandler(").append((String)entry.getKey());
                    if (this.pojoInheritanceSimple.containsKey(entry.getValue())) {
                        for (String pojo2 : (Set)this.pojoInheritanceSimple.get(entry.getValue())) {
                            bufferMeta.append(",\"").append(this.columnToCamelCase(pojo2)).append("\"");
                            pojoName2 = (String)this.tableNames.get(pojo2);
                            if (pojoName2 == null) {
                                pojoName2 = pojo2;
                            }
                            bufferMeta.append("=").append(this.tableToCamelCase(pojoName2));
                        }
                    } else {
                        for (String pojo2 : (Set)this.pojoInheritanceDiscriminator.get(entry.getValue())) {
                            bufferMeta.append(",\"").append((String)this.pojoDiscriminators.get(pojo2)).append("\"");
                            pojoName2 = (String)this.tableNames.get(pojo2);
                            if (pojoName2 == null) {
                                pojoName2 = pojo2;
                            }
                            bufferMeta.append("=").append(this.tableToCamelCase(pojoName2));
                        }
                    }
                    bufferMeta.append(")");
                }
                bufferMeta.append(this.nlindent()).append("#CRUD(").append(this.tableToCamelCase(pojoName3)).append(")");
                bufferMeta.append(this.nlindent()).append("#Query(").append(this.tableToCamelCase(pojoName3)).append(")");
                if (bufferMeta.length() > 0 && bufferMeta.charAt(0) == ' ') {
                    buffer.append("\n  ").append(bufferMeta.substring(1));
                } else {
                    buffer.append((CharSequence)bufferMeta);
                }
                buffer.append("\n  ");
                if (this.daoMakeItFinal) {
                    buffer.append("final ");
                }
                buffer.append("dao ");
                buffer.append(daoName3);
                buffer.append(" {");
                buffer.append("\n  ").append("}\n");
            }
            for (String procedure : this.procedures.keySet()) {
                boolean isFunction;
                if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(procedure) || this.daoIgnoreTables.contains(procedure) || !TablePojoGenerator.Filter.isTable(this.daoActiveFilter, procedure) || (isFunction = this.functions.containsKey(procedure))) continue;
                pojoName = (String)this.tableNames.get(procedure);
                if (pojoName == null) {
                    pojoName = procedure;
                }
                if (this.finalDaos.containsKey(daoName = String.valueOf(pojoName = this.tableToCamelCase(pojoName)) + "Dao")) {
                    buffer.append(this.getFinalContent(this.finalDaos.get(daoName)));
                    continue;
                }
                bufferMeta = new StringBuilder();
                if (isSerializable || serializables.contains(procedure)) {
                    bufferMeta.append(this.nlindent()).append("#Serializable(1)");
                }
                Map map = (Map)this.procedures.get(procedure);
                if (this.metaProceduresResultSet.containsKey(procedure)) {
                    name = (String)this.metaProceduresResultSet.get(procedure);
                    if (this.tableNames.containsKey(name)) {
                        name = (String)this.tableNames.get(name);
                    }
                    bufferMeta.append(this.nlindent()).append("#ProcedureCallQuery(").append(":").append("java.util.List").append("<").append(this.tableToCamelCase(name)).append(">");
                } else {
                    PojoAttribute pojoAttribute = returnAttribute = map.containsKey("_result_") ? (PojoAttribute)map.get("_result_") : null;
                    if (returnAttribute != null && this.dbType != DbResolver.DbType.POSTGRESQL && this.dbType != DbResolver.DbType.MS_SQL) {
                        bufferMeta.append(this.nlindent()).append("#ProcedureCallQuery(:").append("java.util.List").append("<").append(":").append(returnAttribute.getClassName()).append(">");
                    } else {
                        bufferMeta.append(this.nlindent()).append("#ProcedureUpdate(").append(":int");
                    }
                }
                dispName = null;
                ptype = (PojoType)this.pojosForProcedures.get(procedure);
                if (ptype != null) {
                    dispName = ptype.getRef() != null ? ptype.getRef().getName() : ":" + ptype.getType().getSimpleName();
                }
                bufferMeta.append(",").append(dispName != null ? dispName : pojoName);
                bufferMeta.append(")");
                if (bufferMeta.length() > 0 && bufferMeta.charAt(0) == ' ') {
                    buffer.append("\n  ").append(bufferMeta.substring(1));
                } else {
                    buffer.append((CharSequence)bufferMeta);
                }
                buffer.append("\n  ");
                if (this.daoMakeItFinal) {
                    buffer.append("final ");
                }
                buffer.append("dao ");
                buffer.append(daoName);
                buffer.append(" {");
                buffer.append("\n  ").append("}\n");
            }
            for (String function : this.procedures.keySet()) {
                boolean isFunction;
                if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(function) || this.daoIgnoreTables.contains(function) || !TablePojoGenerator.Filter.isTable(this.daoActiveFilter, function) || !(isFunction = this.functions.containsKey(function))) continue;
                pojoName = (String)this.tableNames.get(function);
                if (pojoName == null) {
                    pojoName = function;
                }
                if (this.finalDaos.containsKey(daoName = String.valueOf(pojoName = this.tableToCamelCase(pojoName)) + "Dao")) {
                    buffer.append(this.getFinalContent(this.finalDaos.get(daoName)));
                    continue;
                }
                bufferMeta = new StringBuilder();
                if (isSerializable || serializables.contains(function)) {
                    bufferMeta.append(this.nlindent()).append("#Serializable(1)");
                }
                Map map = (Map)this.procedures.get(function);
                if (this.metaFunctionsResultSet.containsKey(function)) {
                    name = (String)this.metaFunctionsResultSet.get(function);
                    if (this.tableNames.containsKey(name)) {
                        name = (String)this.tableNames.get(name);
                    }
                    bufferMeta.append(this.nlindent()).append("#FunctionCallQuery(").append(":").append("java.util.List").append("<").append(this.tableToCamelCase(name)).append(">");
                } else if (this.metaFunctionsResult.containsKey(function)) {
                    bufferMeta.append(this.nlindent()).append("#FunctionCall(").append(":").append(this.metaType2className((String)this.metaFunctionsResult.get(function)));
                } else {
                    PojoAttribute pojoAttribute = returnAttribute = map.containsKey("_result_") ? (PojoAttribute)map.get("_result_") : null;
                    if (returnAttribute != null) {
                        bufferMeta.append(this.nlindent()).append("#FunctionCallQuery(:").append("java.util.List").append("<").append(":").append(returnAttribute.getClassName()).append(">");
                    } else {
                        bufferMeta.append(this.nlindent()).append("#FunctionUpdate(").append(":int");
                    }
                }
                dispName = null;
                ptype = (PojoType)this.pojosForProcedures.get(function);
                if (ptype != null) {
                    dispName = ptype.getRef() != null ? ptype.getRef().getName() : ":" + ptype.getType().getSimpleName();
                }
                bufferMeta.append(",").append(dispName != null ? dispName : pojoName);
                bufferMeta.append(")");
                if (bufferMeta.length() > 0 && bufferMeta.charAt(0) == ' ') {
                    buffer.append("\n  ").append(bufferMeta.substring(1));
                } else {
                    buffer.append((CharSequence)bufferMeta);
                }
                buffer.append("\n  ");
                if (this.daoMakeItFinal) {
                    buffer.append("final ");
                }
                buffer.append("dao ");
                buffer.append(daoName);
                buffer.append(" {");
                buffer.append("\n  ").append("}\n");
            }
            for (String function : this.functions.keySet()) {
                boolean isProcedure;
                if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(function) || this.daoIgnoreTables.contains(function) || !TablePojoGenerator.Filter.isTable(this.daoActiveFilter, function) || (isProcedure = this.procedures.containsKey(function))) continue;
                pojoName = (String)this.tableNames.get(function);
                if (pojoName == null) {
                    pojoName = function;
                }
                if (this.finalDaos.containsKey(daoName = String.valueOf(pojoName = this.tableToCamelCase(pojoName)) + "Dao")) {
                    buffer.append(this.getFinalContent(this.finalDaos.get(daoName)));
                    continue;
                }
                bufferMeta = new StringBuilder();
                if (isSerializable || serializables.contains(function)) {
                    bufferMeta.append(this.nlindent()).append("#Serializable(1)");
                }
                Map map = (Map)this.functions.get(function);
                if (this.metaFunctionsResultSet.containsKey(function)) {
                    name = (String)this.metaFunctionsResultSet.get(function);
                    if (this.tableNames.containsKey(name)) {
                        name = (String)this.tableNames.get(name);
                    }
                    bufferMeta.append(this.nlindent()).append("#FunctionCallQuery(").append(":").append("java.util.List").append("<").append(this.tableToCamelCase(name)).append(">");
                } else if (this.metaFunctionsResult.containsKey(function) && this.dbType == DbResolver.DbType.DB2) {
                    bufferMeta.append(this.nlindent()).append("#FunctionQuery(").append(":").append(this.metaType2className((String)this.metaFunctionsResult.get(function)));
                } else if (this.metaFunctionsResult.containsKey(function)) {
                    bufferMeta.append(this.nlindent()).append("callFunction ").append(":").append(this.metaType2className((String)this.metaFunctionsResult.get(function)));
                } else {
                    PojoAttribute pojoAttribute = returnAttribute = map.containsKey("_result_") ? (PojoAttribute)map.get("_result_") : null;
                    if (returnAttribute != null) {
                        bufferMeta.append(this.nlindent()).append("#FunctionCallQuery(:").append("java.util.List").append("<").append(":").append(returnAttribute.getClassName()).append(">");
                    } else {
                        bufferMeta.append(this.nlindent()).append("#FunctionUpdate(").append(":int");
                    }
                }
                dispName = null;
                ptype = (PojoType)this.pojosForProcedures.get(function);
                if (ptype != null) {
                    dispName = ptype.getRef() != null ? ptype.getRef().getName() : ":" + ptype.getType().getSimpleName();
                }
                bufferMeta.append(",").append(dispName != null ? dispName : pojoName);
                bufferMeta.append(")");
                if (bufferMeta.length() > 0 && bufferMeta.charAt(0) == ' ') {
                    buffer.append("\n  ").append(bufferMeta.substring(1));
                } else {
                    buffer.append((CharSequence)bufferMeta);
                }
                buffer.append("\n  ");
                if (this.daoMakeItFinal) {
                    buffer.append("final ");
                }
                buffer.append("dao ");
                buffer.append(daoName);
                buffer.append(" {");
                buffer.append("\n  ").append("}\n");
            }
            return buffer.toString();
        }
        catch (RuntimeException ex) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            ex.printStackTrace(printWriter);
            String s = ((Object)writer).toString();
            return s;
        }
    }

    protected void toInits(String pojo, Map<String, String> toInit) {
        for (Map.Entry pentry : ((Map)this.pojos.get(pojo)).entrySet()) {
            if (this.ignoreColumns.containsKey(pojo) && ((Set)this.ignoreColumns.get(pojo)).contains(pentry.getKey())) continue;
            PojoAttribute attribute = (PojoAttribute)pentry.getValue();
            String name = this.columnNames.containsKey(pojo) ? (String)((Map)this.columnNames.get(pojo)).get(pentry.getKey()) : null;
            name = name == null ? attribute.getName() : this.columnToCamelCase(name);
            if (!attribute.toInit() || attribute.getRef() == null || !this.pojoInheritanceDiscriminator.containsKey(attribute.getRef()) && !this.pojoInheritanceSimple.containsKey(attribute.getRef())) continue;
            toInit.put(name, attribute.getRef());
        }
        if (this.pojoExtends.containsKey(pojo)) {
            this.toInits((String)this.pojoExtends.get(pojo), toInit);
        }
    }
}

