/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.sqlproc.dsl.ImportManager;
import org.sqlproc.dsl.generator.ProcessorGeneratorUtils;
import org.sqlproc.dsl.processorDsl.AnnotatedEntity;
import org.sqlproc.dsl.processorDsl.Annotation;
import org.sqlproc.dsl.processorDsl.AnnotationProperty;
import org.sqlproc.dsl.processorDsl.Entity;
import org.sqlproc.dsl.processorDsl.EnumEntity;
import org.sqlproc.dsl.processorDsl.EnumProperty;
import org.sqlproc.dsl.processorDsl.EnumPropertyDirective;
import org.sqlproc.dsl.processorDsl.EnumPropertyDirectiveValues;
import org.sqlproc.dsl.processorDsl.EnumPropertyValue;
import org.sqlproc.dsl.processorDsl.Extends;
import org.sqlproc.dsl.processorDsl.Implements;
import org.sqlproc.dsl.processorDsl.PojoAnnotatedProperty;
import org.sqlproc.dsl.processorDsl.PojoEntity;
import org.sqlproc.dsl.processorDsl.PojoProperty;
import org.sqlproc.dsl.util.Utils;

public class ProcessorPojoGenerator {
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    @Extension
    private ProcessorGeneratorUtils _processorGeneratorUtils;

    public CharSequence compile(AnnotatedEntity e) {
        Entity _entity_1;
        StringConcatenation _builder = new StringConcatenation();
        Entity _entity = e.getEntity();
        if (_entity instanceof EnumEntity) {
            EnumEntity _enumEntity = Utils.enumEntity(e);
            CharSequence _compile = this.compile(_enumEntity);
            _builder.append((Object)_compile, "");
        }
        if ((_entity_1 = e.getEntity()) instanceof PojoEntity) {
            PojoEntity _pojoEntity = Utils.pojoEntity(e);
            CharSequence _compile_1 = this.compile(_pojoEntity, e);
            _builder.append((Object)_compile_1, "");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence compile(EnumEntity e) {
        EList<EnumProperty> _features;
        boolean _isEmpty_1;
        boolean _not_1;
        String _sernum;
        boolean _notEquals_1;
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        ImportManager im = new ImportManager(true);
        _builder.newLineIfNotEmpty();
        EnumProperty eattr = Utils.getEnumAttr(e);
        _builder.newLineIfNotEmpty();
        this.addImplements(e, im);
        _builder.newLineIfNotEmpty();
        this.addExtends(e, im);
        _builder.newLineIfNotEmpty();
        CharSequence classBody = this.compile(e, im, eattr);
        _builder.newLineIfNotEmpty();
        EObject _eContainer = e.eContainer();
        boolean bl = _notEquals = !Objects.equal((Object)_eContainer, null);
        if (_notEquals) {
            _builder.append((Object)"package ");
            EObject _eContainer_1 = e.eContainer();
            EObject _eContainer_2 = _eContainer_1.eContainer();
            QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName(_eContainer_2);
            _builder.append((Object)_fullyQualifiedName, "");
            _builder.append((Object)";");
        }
        _builder.newLineIfNotEmpty();
        List<String> _imports = im.getImports();
        boolean _isEmpty = _imports.isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            _builder.newLine();
            List<String> _imports_1 = im.getImports();
            for (String i : _imports_1) {
                _builder.append((Object)"import ");
                _builder.append((Object)i, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        }
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)(_sernum = this._processorGeneratorUtils.getSernum(e)), null);
        if (_notEquals_1) {
            _builder.newLine();
            _builder.append((Object)"import java.io.Serializable;");
            _builder.newLine();
        }
        boolean bl4 = _not_1 = !(_isEmpty_1 = (_features = e.getFeatures()).isEmpty());
        if (_not_1) {
            _builder.append((Object)"import java.util.HashMap;");
            _builder.newLine();
            _builder.append((Object)"import java.util.Map;");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)classBody, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence compile(EnumEntity e, ImportManager im, EnumProperty ea) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public enum ");
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" ");
        CharSequence _compileImplements = this.compileImplements(e);
        _builder.append((Object)_compileImplements, "");
        _builder.append((Object)"{");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList<EnumProperty> _features = e.getFeatures();
        boolean _hasElements = false;
        for (EnumProperty fe : _features) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t");
            }
            _builder.append((Object)"\t");
            EList<EnumPropertyDirective> _directives = fe.getDirectives();
            Functions.Function1<EnumPropertyDirective, Boolean> _function = new Functions.Function1<EnumPropertyDirective, Boolean>(){

                public Boolean apply(EnumPropertyDirective x) {
                    return x instanceof EnumPropertyDirectiveValues;
                }
            };
            Iterable _filter = IterableExtensions.filter(_directives, (Functions.Function1)_function);
            boolean _hasElements_1 = false;
            for (EnumPropertyDirective f : _filter) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                EList<EnumPropertyValue> _values = ((EnumPropertyDirectiveValues)f).getValues();
                boolean _hasElements_2 = false;
                for (EnumPropertyValue v : _values) {
                    if (!_hasElements_2) {
                        _hasElements_2 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    String _name_1 = v.getName();
                    _builder.append((Object)_name_1, "\t");
                    _builder.append((Object)"(");
                    String _value = v.getValue();
                    _builder.append((Object)_value, "\t");
                    _builder.append((Object)")");
                }
            }
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        String _sernum = this._processorGeneratorUtils.getSernum(e);
        boolean bl = _notEquals = !Objects.equal((Object)_sernum, null);
        if (_notEquals) {
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private static final long serialVersionUID = ");
            String _sernum_1 = this._processorGeneratorUtils.getSernum(e);
            _builder.append((Object)_sernum_1, "\t");
            _builder.append((Object)"L;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static Map<");
        CharSequence _compileType = this._processorGeneratorUtils.compileType(ea, im);
        _builder.append((Object)_compileType, "\t");
        _builder.append((Object)", ");
        String _name_2 = e.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)"> identifierMap = new HashMap<");
        CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(ea, im);
        _builder.append((Object)_compileType_1, "\t");
        _builder.append((Object)", ");
        String _name_3 = e.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append((Object)">();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"static {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "\t\t");
        _builder.append((Object)" value : ");
        String _name_5 = e.getName();
        _builder.append((Object)_name_5, "\t\t");
        _builder.append((Object)".values()) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"identifierMap.put(value.getValue(), value);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private ");
        CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(ea, im);
        _builder.append((Object)_compileType_2, "\t");
        _builder.append((Object)" ");
        String _name_6 = ea.getName();
        _builder.append((Object)_name_6, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private ");
        String _name_7 = e.getName();
        _builder.append((Object)_name_7, "\t");
        _builder.append((Object)"(");
        CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(ea, im);
        _builder.append((Object)_compileType_3, "\t");
        _builder.append((Object)" value) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.");
        String _name_8 = ea.getName();
        _builder.append((Object)_name_8, "\t\t");
        _builder.append((Object)" = value;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static ");
        String _name_9 = e.getName();
        _builder.append((Object)_name_9, "\t");
        _builder.append((Object)" fromValue(");
        CharSequence _compileType_4 = this._processorGeneratorUtils.compileType(ea, im);
        _builder.append((Object)_compileType_4, "\t");
        _builder.append((Object)" value) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        String _name_10 = e.getName();
        _builder.append((Object)_name_10, "\t\t");
        _builder.append((Object)" result = identifierMap.get(value);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (result == null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException(\"No ");
        String _name_11 = e.getName();
        _builder.append((Object)_name_11, "\t\t\t");
        _builder.append((Object)" for value: \" + value);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return result;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        CharSequence _compileType_5 = this._processorGeneratorUtils.compileType(ea, im);
        _builder.append((Object)_compileType_5, "\t");
        _builder.append((Object)" getValue() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        String _name_12 = ea.getName();
        _builder.append((Object)_name_12, "\t\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String getName() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return name();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compile(PojoEntity e, AnnotatedEntity ae) {
        boolean _hasToInit;
        List<PojoAnnotatedProperty> _listFeatures;
        boolean _isEmpty_1;
        boolean _not_1;
        String _sernum;
        boolean _notEquals_1;
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        ImportManager im = new ImportManager(true);
        _builder.newLineIfNotEmpty();
        this.addImplements(e, im);
        _builder.newLineIfNotEmpty();
        this.addExtends(e, im);
        _builder.newLineIfNotEmpty();
        CharSequence classBody = this.compile(e, ae, im);
        _builder.newLineIfNotEmpty();
        EObject _eContainer = e.eContainer();
        boolean bl = _notEquals = !Objects.equal((Object)_eContainer, null);
        if (_notEquals) {
            _builder.append((Object)"package ");
            EObject _eContainer_1 = e.eContainer();
            EObject _eContainer_2 = _eContainer_1.eContainer();
            QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName(_eContainer_2);
            _builder.append((Object)_fullyQualifiedName, "");
            _builder.append((Object)";");
        }
        _builder.newLineIfNotEmpty();
        List<String> _imports = im.getImports();
        boolean _isEmpty = _imports.isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)"\t");
            _builder.newLine();
            List<String> _imports_1 = im.getImports();
            for (String i : _imports_1) {
                _builder.append((Object)"import ");
                _builder.append((Object)i, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        }
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)(_sernum = this._processorGeneratorUtils.getSernum(e)), null);
        if (_notEquals_1) {
            _builder.newLine();
            _builder.append((Object)"import java.io.Serializable;");
            _builder.newLine();
        }
        boolean bl4 = _not_1 = !(_isEmpty_1 = (_listFeatures = this.listFeatures(e)).isEmpty());
        if (_not_1) {
            _builder.append((Object)"import java.util.ArrayList;");
            _builder.newLine();
        }
        boolean _or = false;
        boolean _hasIsDef = this._processorGeneratorUtils.hasIsDef(e);
        _or = _hasIsDef ? true : (_hasToInit = this._processorGeneratorUtils.hasToInit(e));
        if (_or) {
            _builder.append((Object)"import java.util.Set;");
            _builder.newLine();
            _builder.append((Object)"import java.util.HashSet;");
            _builder.newLine();
            _builder.append((Object)"import java.lang.reflect.InvocationTargetException;");
            _builder.newLine();
            _builder.append((Object)"import org.apache.commons.beanutils.MethodUtils;");
            _builder.newLine();
        }
        boolean _and = false;
        boolean _hasOperators = this._processorGeneratorUtils.hasOperators(e);
        if (!_hasOperators) {
            _and = false;
        } else {
            boolean _equals;
            String _operatorsSuffix = this._processorGeneratorUtils.getOperatorsSuffix(e);
            _and = _equals = Objects.equal((Object)_operatorsSuffix, null);
        }
        if (_and) {
            _builder.append((Object)"import java.util.Map;");
            _builder.newLine();
            _builder.append((Object)"import java.util.HashMap;");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)classBody, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence compile(PojoEntity e, AnnotatedEntity ae, ImportManager im) {
        boolean _not_12;
        boolean _not_11;
        boolean _not_10;
        boolean _not_9;
        boolean _not_8;
        boolean _not_7;
        boolean _not_6;
        boolean _not_4;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        List<Annotation> _standardAnnotations = this._processorGeneratorUtils.standardAnnotations(ae);
        for (Annotation a : _standardAnnotations) {
            boolean _not;
            _builder.append((Object)"@");
            JvmType _type = a.getType();
            CharSequence _serialize = im.serialize(_type);
            _builder.append((Object)_serialize, "");
            EList<AnnotationProperty> _features = a.getFeatures();
            boolean _isEmpty = _features.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_1 = a.getFeatures();
                boolean _hasElements = false;
                for (Object f : _features_1) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    CharSequence _compileAnnotationProperty = this.compileAnnotationProperty((AnnotationProperty)f, im);
                    _builder.append((Object)_compileAnnotationProperty, "");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"public ");
        boolean _isAbstract = this._processorGeneratorUtils.isAbstract(e);
        if (_isAbstract) {
            _builder.append((Object)"abstract ");
        }
        _builder.append((Object)"class ");
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" ");
        CharSequence _compileExtends = this.compileExtends(e, im);
        _builder.append((Object)_compileExtends, "");
        CharSequence _compileImplements = this.compileImplements(e);
        _builder.append((Object)_compileImplements, "");
        _builder.append((Object)"{");
        _builder.newLineIfNotEmpty();
        String _sernum = this._processorGeneratorUtils.getSernum(e);
        boolean bl = _notEquals = !Objects.equal((Object)_sernum, null);
        if (_notEquals) {
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private static final long serialVersionUID = ");
            String _sernum_1 = this._processorGeneratorUtils.getSernum(e);
            _builder.append((Object)_sernum_1, "\t");
            _builder.append((Object)"L;");
            _builder.newLineIfNotEmpty();
        }
        EList<PojoAnnotatedProperty> _features_2 = e.getFeatures();
        Functions.Function1<PojoAnnotatedProperty, Boolean> _function = new Functions.Function1<PojoAnnotatedProperty, Boolean>(){

            public Boolean apply(PojoAnnotatedProperty x) {
                PojoProperty _feature = x.getFeature();
                String _index = ProcessorPojoGenerator.this._processorGeneratorUtils.getIndex(_feature);
                return !Objects.equal((Object)_index, null);
            }
        };
        Iterable _filter = IterableExtensions.filter(_features_2, (Functions.Function1)_function);
        for (PojoAnnotatedProperty f_1 : _filter) {
            List<Annotation> _staticAnnotations = this._processorGeneratorUtils.staticAnnotations(ae);
            for (Annotation a_1 : _staticAnnotations) {
                boolean _not_1;
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                JvmType _type_1 = a_1.getType();
                CharSequence _serialize_1 = im.serialize(_type_1);
                _builder.append((Object)_serialize_1, "\t");
                EList<AnnotationProperty> _features_3 = a_1.getFeatures();
                boolean _isEmpty_1 = _features_3.isEmpty();
                boolean bl2 = _not_1 = !_isEmpty_1;
                if (_not_1) {
                    _builder.append((Object)"(");
                    EList<AnnotationProperty> _features_4 = a_1.getFeatures();
                    boolean _hasElements_1 = false;
                    for (AnnotationProperty ff : _features_4) {
                        if (!_hasElements_1) {
                            _hasElements_1 = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "\t");
                        }
                        CharSequence _compileAnnotationProperty_1 = this.compileAnnotationProperty(ff, im);
                        _builder.append((Object)_compileAnnotationProperty_1, "\t");
                    }
                    _builder.append((Object)")");
                }
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"public static final int ORDER_BY_");
            PojoProperty _feature = f_1.getFeature();
            String _constName = Utils.constName(_feature);
            _builder.append((Object)_constName, "\t");
            _builder.append((Object)" = ");
            PojoProperty _feature_1 = f_1.getFeature();
            String _index = this._processorGeneratorUtils.getIndex(_feature_1);
            _builder.append((Object)_index, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        Map<String, List<PojoProperty>> _index_1 = this._processorGeneratorUtils.getIndex(e);
        Set<Map.Entry<String, List<PojoProperty>>> _entrySet = _index_1.entrySet();
        for (Object f_2 : _entrySet) {
            List<Annotation> _staticAnnotations_1 = this._processorGeneratorUtils.staticAnnotations(ae);
            for (Annotation a_2 : _staticAnnotations_1) {
                boolean _not_2;
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                JvmType _type_2 = a_2.getType();
                CharSequence _serialize_2 = im.serialize(_type_2);
                _builder.append((Object)_serialize_2, "\t");
                EList<AnnotationProperty> _features_5 = a_2.getFeatures();
                boolean _isEmpty_2 = _features_5.isEmpty();
                boolean bl3 = _not_2 = !_isEmpty_2;
                if (_not_2) {
                    _builder.append((Object)"(");
                    EList<AnnotationProperty> _features_6 = a_2.getFeatures();
                    boolean _hasElements_2 = false;
                    for (AnnotationProperty ff_1 : _features_6) {
                        if (!_hasElements_2) {
                            _hasElements_2 = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "\t");
                        }
                        CharSequence _compileAnnotationProperty_2 = this.compileAnnotationProperty(ff_1, im);
                        _builder.append((Object)_compileAnnotationProperty_2, "\t");
                    }
                    _builder.append((Object)")");
                }
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"public static final int ORDER_BY_");
            List _value = (List)f_2.getValue();
            String _constName_1 = Utils.constName(_value);
            _builder.append((Object)_constName_1, "\t");
            _builder.append((Object)" = ");
            String _key = (String)f_2.getKey();
            _builder.append((Object)_key, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        List<Annotation> _constructorAnnotations = this._processorGeneratorUtils.constructorAnnotations(ae);
        for (Annotation a_3 : _constructorAnnotations) {
            boolean _not_3;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_3 = a_3.getType();
            CharSequence _serialize_3 = im.serialize(_type_3);
            _builder.append((Object)_serialize_3, "\t");
            EList<AnnotationProperty> _features_7 = a_3.getFeatures();
            boolean _isEmpty_3 = _features_7.isEmpty();
            boolean bl4 = _not_3 = !_isEmpty_3;
            if (_not_3) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_8 = a_3.getFeatures();
                boolean _hasElements_3 = false;
                for (AnnotationProperty f_3 : _features_8) {
                    if (!_hasElements_3) {
                        _hasElements_3 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_3 = this.compileAnnotationProperty(f_3, im);
                    _builder.append((Object)_compileAnnotationProperty_3, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        List<PojoAnnotatedProperty> _requiredFeatures = this.requiredFeatures(e);
        boolean _isEmpty_4 = _requiredFeatures.isEmpty();
        boolean bl5 = _not_4 = !_isEmpty_4;
        if (_not_4) {
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.newLine();
            List<Annotation> _constructorAnnotations_1 = this._processorGeneratorUtils.constructorAnnotations(ae);
            for (Annotation a_4 : _constructorAnnotations_1) {
                boolean _not_5;
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                JvmType _type_4 = a_4.getType();
                Iterator<PojoAnnotatedProperty> _serialize_4 = im.serialize(_type_4);
                _builder.append((Object)_serialize_4, "\t");
                EList<AnnotationProperty> _features_9 = a_4.getFeatures();
                boolean _isEmpty_5 = _features_9.isEmpty();
                boolean bl6 = _not_5 = !_isEmpty_5;
                if (_not_5) {
                    _builder.append((Object)"(");
                    EList<AnnotationProperty> _features_10 = a_4.getFeatures();
                    boolean _hasElements_4 = false;
                    for (AnnotationProperty f_4 : _features_10) {
                        if (!_hasElements_4) {
                            _hasElements_4 = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "\t");
                        }
                        CharSequence _compileAnnotationProperty_4 = this.compileAnnotationProperty(f_4, im);
                        _builder.append((Object)_compileAnnotationProperty_4, "\t");
                    }
                    _builder.append((Object)")");
                }
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _name_2 = e.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)"(");
            List<PojoAnnotatedProperty> _requiredFeatures_1 = this.requiredFeatures(e);
            boolean _hasElements_5 = false;
            for (PojoAnnotatedProperty f_5 : _requiredFeatures_1) {
                if (!_hasElements_5) {
                    _hasElements_5 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                PojoProperty _feature_2 = f_5.getFeature();
                CharSequence _compileType = this._processorGeneratorUtils.compileType(_feature_2, im);
                CharSequence _fullName = Utils.getFullName(e, f_5, _compileType, im);
                _builder.append((Object)_fullName, "\t");
                _builder.append((Object)" ");
                PojoProperty _feature_3 = f_5.getFeature();
                String _name_3 = _feature_3.getName();
                _builder.append((Object)_name_3, "\t");
            }
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            ArrayList<PojoAnnotatedProperty> _requiredSuperFeatures = this.requiredSuperFeatures(e);
            boolean _hasElements_6 = false;
            for (PojoAnnotatedProperty f_6 : _requiredSuperFeatures) {
                if (!_hasElements_6) {
                    _hasElements_6 = true;
                    _builder.append((Object)"super(", "\t\t");
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t");
                }
                PojoProperty _feature_4 = f_6.getFeature();
                String _name_4 = _feature_4.getName();
                _builder.append((Object)_name_4, "\t\t");
            }
            if (_hasElements_6) {
                _builder.append((Object)");", "\t\t");
            }
            _builder.newLineIfNotEmpty();
            List<PojoAnnotatedProperty> _requiredFeatures1 = this.requiredFeatures1(e);
            Iterator f_6 = _requiredFeatures1.iterator();
            while (f_6.hasNext()) {
                PojoAnnotatedProperty f_7 = (PojoAnnotatedProperty)f_6.next();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"this.");
                PojoProperty _feature_5 = f_7.getFeature();
                String _name_5 = _feature_5.getName();
                _builder.append((Object)_name_5, "\t\t");
                _builder.append((Object)" = ");
                PojoProperty _feature_6 = f_7.getFeature();
                String _name_6 = _feature_6.getName();
                _builder.append((Object)_name_6, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        EList<PojoAnnotatedProperty> _features_11 = e.getFeatures();
        Functions.Function1<PojoAnnotatedProperty, Boolean> _function_1 = new Functions.Function1<PojoAnnotatedProperty, Boolean>(){

            public Boolean apply(PojoAnnotatedProperty x) {
                PojoProperty _feature = x.getFeature();
                return ProcessorPojoGenerator.this.isAttribute(_feature);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter(_features_11, (Functions.Function1)_function_1);
        for (PojoAnnotatedProperty f_8 : _filter_1) {
            PojoProperty _feature_7 = f_8.getFeature();
            String _operatorsSuffix = this._processorGeneratorUtils.getOperatorsSuffix(e);
            CharSequence _compile = this.compile(_feature_7, f_8, im, e, ae, _operatorsSuffix);
            _builder.append((Object)_compile, "");
            _builder.newLineIfNotEmpty();
        }
        List<PojoProperty> toInit = this._processorGeneratorUtils.toInitFeatures(e);
        boolean _isEmpty_6 = toInit.isEmpty();
        boolean bl7 = _not_6 = !_isEmpty_6;
        if (_not_6) {
            CharSequence _compileToInit = this.compileToInit(toInit, im, e, ae);
            _builder.append((Object)_compileToInit, "");
        }
        _builder.newLineIfNotEmpty();
        List<PojoProperty> enumInit = this._processorGeneratorUtils.enumInitFeatures(e);
        boolean _isEmpty_7 = enumInit.isEmpty();
        boolean bl8 = _not_7 = !_isEmpty_7;
        if (_not_7) {
            CharSequence _compileEnumInit = this.compileEnumInit(enumInit, im, e, ae);
            _builder.append((Object)_compileEnumInit, "");
        }
        _builder.newLineIfNotEmpty();
        List<PojoProperty> isDef = this._processorGeneratorUtils.isDefFeatures(e);
        boolean _isEmpty_8 = isDef.isEmpty();
        boolean bl9 = _not_8 = !_isEmpty_8;
        if (_not_8) {
            CharSequence _compileIsDef = this.compileIsDef(isDef, im, e, ae);
            _builder.append((Object)_compileIsDef, "");
        }
        _builder.newLineIfNotEmpty();
        List<PojoProperty> enumDef = this._processorGeneratorUtils.enumDefFeatures(e);
        boolean _isEmpty_9 = enumDef.isEmpty();
        boolean bl10 = _not_9 = !_isEmpty_9;
        if (_not_9) {
            CharSequence _compileEnumDef = this.compileEnumDef(enumDef, im, e, ae);
            _builder.append((Object)_compileEnumDef, "");
        }
        _builder.newLineIfNotEmpty();
        List<PojoProperty> equals = this._processorGeneratorUtils.equalsFeatures(e);
        boolean _isEmpty_10 = equals.isEmpty();
        boolean bl11 = _not_10 = !_isEmpty_10;
        if (_not_10) {
            CharSequence _compileEquals = this.compileEquals(equals, im, e, ae);
            _builder.append((Object)_compileEquals, "");
        }
        _builder.newLineIfNotEmpty();
        List<PojoProperty> hashCode = this._processorGeneratorUtils.hashCodeFeatures(e);
        boolean _isEmpty_11 = hashCode.isEmpty();
        boolean bl12 = _not_11 = !_isEmpty_11;
        if (_not_11) {
            CharSequence _compileHashCode = this.compileHashCode(hashCode, im, e, ae);
            _builder.append((Object)_compileHashCode, "");
        }
        _builder.newLineIfNotEmpty();
        List<PojoProperty> toString = this._processorGeneratorUtils.toStringFeatures(e);
        boolean _isEmpty_12 = toString.isEmpty();
        boolean bl13 = _not_12 = !_isEmpty_12;
        if (_not_12) {
            CharSequence _compileToString = this.compileToString(toString, im, e, ae);
            _builder.append((Object)_compileToString, "");
        }
        _builder.newLineIfNotEmpty();
        boolean _and = false;
        boolean _hasOperators = this._processorGeneratorUtils.hasOperators(e);
        if (!_hasOperators) {
            _and = false;
        } else {
            boolean _equals;
            String _operatorsSuffix_1 = this._processorGeneratorUtils.getOperatorsSuffix(e);
            _and = _equals = Objects.equal((Object)_operatorsSuffix_1, null);
        }
        if (_and) {
            CharSequence _compileOperators = this.compileOperators(im, e, ae);
            _builder.append((Object)_compileOperators, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileAnnotationProperty(AnnotationProperty f, ImportManager im) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _name = f.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" = ");
        JvmType _type = f.getType();
        boolean bl = _notEquals = !Objects.equal((Object)_type, null);
        if (_notEquals) {
            JvmType _type_1 = f.getType();
            CharSequence _serialize = im.serialize(_type_1);
            _builder.append((Object)_serialize, "");
        } else {
            boolean _notEquals_1;
            PojoEntity _ref = f.getRef();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_ref, null);
            if (_notEquals_1) {
                PojoEntity _ref_1 = f.getRef();
                QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)_ref_1);
                _builder.append((Object)_fullyQualifiedName, "");
            }
        }
        String _annotationValue = Utils.getAnnotationValue(f);
        _builder.append((Object)_annotationValue, "");
        return _builder;
    }

    public CharSequence compile(PojoProperty f, PojoAnnotatedProperty aaf, ImportManager im, PojoEntity e, AnnotatedEntity ae, String operatorSuffix) {
        boolean _notEquals_4;
        String _createColumn1_5;
        boolean _notEquals_3;
        boolean _notEquals_2;
        String _createColumn1;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        List<Annotation> _attributeAnnotations = this._processorGeneratorUtils.attributeAnnotations(aaf);
        for (Annotation a : _attributeAnnotations) {
            boolean _not;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type = a.getType();
            CharSequence _serialize = im.serialize(_type);
            _builder.append((Object)_serialize, "\t");
            EList<AnnotationProperty> _features = a.getFeatures();
            boolean _isEmpty = _features.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_1 = a.getFeatures();
                boolean _hasElements = false;
                for (AnnotationProperty af : _features_1) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty = this.compileAnnotationProperty(af, im);
                    _builder.append((Object)_compileAnnotationProperty, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"private ");
        CharSequence _compileType = this._processorGeneratorUtils.compileType(f, im);
        _builder.append((Object)_compileType, "\t");
        _builder.append((Object)" ");
        String _name = f.getName();
        _builder.append((Object)_name, "\t");
        boolean _isList = this._processorGeneratorUtils.isList(f);
        if (_isList) {
            _builder.append((Object)" = new Array");
            CharSequence _compileType_1 = this._processorGeneratorUtils.compileType(f, im);
            _builder.append((Object)_compileType_1, "\t");
            _builder.append((Object)"()");
        } else {
            boolean _isOptLock = this._processorGeneratorUtils.isOptLock(f);
            if (_isOptLock) {
                _builder.append((Object)" = 0");
            }
        }
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        List<Annotation> _terAnnotations = this._processorGeneratorUtils.getterAnnotations(aaf);
        for (Annotation a_1 : _terAnnotations) {
            boolean _not_1;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_1 = a_1.getType();
            CharSequence _serialize_1 = im.serialize(_type_1);
            _builder.append((Object)_serialize_1, "\t");
            EList<AnnotationProperty> _features_2 = a_1.getFeatures();
            boolean _isEmpty_1 = _features_2.isEmpty();
            boolean bl = _not_1 = !_isEmpty_1;
            if (_not_1) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_3 = a_1.getFeatures();
                boolean _hasElements_1 = false;
                for (AnnotationProperty af_1 : _features_3) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_1 = this.compileAnnotationProperty(af_1, im);
                    _builder.append((Object)_compileAnnotationProperty_1, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        CharSequence _compileType_2 = this._processorGeneratorUtils.compileType(f, im);
        _builder.append((Object)_compileType_2, "\t");
        _builder.append((Object)" get");
        String _name_1 = f.getName();
        String __toFirstUpper = Utils._toFirstUpper(_name_1);
        _builder.append((Object)__toFirstUpper, "\t");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ");
        String _name_2 = f.getName();
        _builder.append((Object)_name_2, "\t\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        List<Annotation> _setterAnnotations = this._processorGeneratorUtils.setterAnnotations(aaf);
        for (Annotation a_2 : _setterAnnotations) {
            boolean _not_2;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_2 = a_2.getType();
            CharSequence _serialize_2 = im.serialize(_type_2);
            _builder.append((Object)_serialize_2, "\t");
            EList<AnnotationProperty> _features_4 = a_2.getFeatures();
            boolean _isEmpty_2 = _features_4.isEmpty();
            boolean bl = _not_2 = !_isEmpty_2;
            if (_not_2) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_5 = a_2.getFeatures();
                boolean _hasElements_2 = false;
                for (AnnotationProperty af_2 : _features_5) {
                    if (!_hasElements_2) {
                        _hasElements_2 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_2 = this.compileAnnotationProperty(af_2, im);
                    _builder.append((Object)_compileAnnotationProperty_2, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void set");
        String _name_3 = f.getName();
        String __toFirstUpper_1 = Utils._toFirstUpper(_name_3);
        _builder.append((Object)__toFirstUpper_1, "\t");
        _builder.append((Object)"(");
        CharSequence _compileType_3 = this._processorGeneratorUtils.compileType(f, im);
        _builder.append((Object)_compileType_3, "\t");
        _builder.append((Object)" ");
        String _name_4 = f.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.");
        String _name_5 = f.getName();
        _builder.append((Object)_name_5, "\t\t");
        _builder.append((Object)" = ");
        String _name_6 = f.getName();
        _builder.append((Object)_name_6, "\t\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        String _updateColumn1 = this._processorGeneratorUtils.getUpdateColumn1(f);
        boolean bl = _notEquals = !Objects.equal((Object)_updateColumn1, null);
        if (_notEquals) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (this.");
            String _name_7 = f.getName();
            _builder.append((Object)_name_7, "\t\t");
            _builder.append((Object)" != null)");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.");
            String _updateColumn2 = this._processorGeneratorUtils.getUpdateColumn2(f);
            _builder.append((Object)_updateColumn2, "\t\t\t");
            _builder.append((Object)" = this.");
            String _name_8 = f.getName();
            _builder.append((Object)_name_8, "\t\t\t");
            _builder.append((Object)".get");
            String _updateColumn1_1 = this._processorGeneratorUtils.getUpdateColumn1(f);
            String __toFirstUpper_2 = Utils._toFirstUpper(_updateColumn1_1);
            _builder.append((Object)__toFirstUpper_2, "\t\t\t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
        }
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)(_createColumn1 = this._processorGeneratorUtils.getCreateColumn1(f)), null);
        if (_notEquals_1) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (this.");
            String _createColumn1_1 = this._processorGeneratorUtils.getCreateColumn1(f);
            _builder.append((Object)_createColumn1_1, "\t\t");
            _builder.append((Object)" == null)");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.");
            String _createColumn1_2 = this._processorGeneratorUtils.getCreateColumn1(f);
            _builder.append((Object)_createColumn1_2, "\t\t\t");
            _builder.append((Object)" = new ");
            String _createColumn1_3 = this._processorGeneratorUtils.getCreateColumn1(f);
            PojoProperty _attribute = this._processorGeneratorUtils.getAttribute(e, _createColumn1_3);
            CharSequence _compileType_4 = this._processorGeneratorUtils.compileType(_attribute, im);
            _builder.append((Object)_compileType_4, "\t\t\t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"this.");
            String _createColumn1_4 = this._processorGeneratorUtils.getCreateColumn1(f);
            _builder.append((Object)_createColumn1_4, "\t\t");
            _builder.append((Object)".set");
            String _createColumn2 = this._processorGeneratorUtils.getCreateColumn2(f);
            String __toFirstUpper_3 = Utils._toFirstUpper(_createColumn2);
            _builder.append((Object)__toFirstUpper_3, "\t\t");
            _builder.append((Object)"(");
            String _name_9 = f.getName();
            _builder.append((Object)_name_9, "\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_10 = e.getName();
        _builder.append((Object)_name_10, "\t");
        _builder.append((Object)" _set");
        String _name_11 = f.getName();
        String __toFirstUpper_4 = Utils._toFirstUpper(_name_11);
        _builder.append((Object)__toFirstUpper_4, "\t");
        _builder.append((Object)"(");
        CharSequence _compileType_5 = this._processorGeneratorUtils.compileType(f, im);
        _builder.append((Object)_compileType_5, "\t");
        _builder.append((Object)" ");
        String _name_12 = f.getName();
        _builder.append((Object)_name_12, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.");
        String _name_13 = f.getName();
        _builder.append((Object)_name_13, "\t\t");
        _builder.append((Object)" = ");
        String _name_14 = f.getName();
        _builder.append((Object)_name_14, "\t\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        String _updateColumn1_2 = this._processorGeneratorUtils.getUpdateColumn1(f);
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_updateColumn1_2, null);
        if (_notEquals_2) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (this.");
            String _name_15 = f.getName();
            _builder.append((Object)_name_15, "\t\t");
            _builder.append((Object)" != null)");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.");
            String _updateColumn2_1 = this._processorGeneratorUtils.getUpdateColumn2(f);
            _builder.append((Object)_updateColumn2_1, "\t\t\t");
            _builder.append((Object)" = this.");
            String _name_16 = f.getName();
            _builder.append((Object)_name_16, "\t\t\t");
            _builder.append((Object)".get");
            String _updateColumn1_3 = this._processorGeneratorUtils.getUpdateColumn1(f);
            String __toFirstUpper_5 = Utils._toFirstUpper(_updateColumn1_3);
            _builder.append((Object)__toFirstUpper_5, "\t\t\t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
        }
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)(_createColumn1_5 = this._processorGeneratorUtils.getCreateColumn1(f)), null);
        if (_notEquals_3) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if (this.");
            String _createColumn1_6 = this._processorGeneratorUtils.getCreateColumn1(f);
            _builder.append((Object)_createColumn1_6, "\t\t");
            _builder.append((Object)" == null)");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.");
            String _createColumn1_7 = this._processorGeneratorUtils.getCreateColumn1(f);
            _builder.append((Object)_createColumn1_7, "\t\t\t");
            _builder.append((Object)" = new ");
            String _createColumn1_8 = this._processorGeneratorUtils.getCreateColumn1(f);
            PojoProperty _attribute_1 = this._processorGeneratorUtils.getAttribute(e, _createColumn1_8);
            CharSequence _compileType_6 = this._processorGeneratorUtils.compileType(_attribute_1, im);
            _builder.append((Object)_compileType_6, "\t\t\t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"this.");
            String _createColumn1_9 = this._processorGeneratorUtils.getCreateColumn1(f);
            _builder.append((Object)_createColumn1_9, "\t\t");
            _builder.append((Object)".set");
            String _createColumn2_1 = this._processorGeneratorUtils.getCreateColumn2(f);
            String __toFirstUpper_6 = Utils._toFirstUpper(_createColumn2_1);
            _builder.append((Object)__toFirstUpper_6, "\t\t");
            _builder.append((Object)"(");
            String _name_17 = f.getName();
            _builder.append((Object)_name_17, "\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        boolean _and = false;
        boolean _hasOperators = this._processorGeneratorUtils.hasOperators(e);
        _and = !_hasOperators ? false : (_notEquals_4 = !Objects.equal((Object)operatorSuffix, null));
        if (_and) {
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private String ");
            String _name_18 = f.getName();
            _builder.append((Object)_name_18, "\t");
            _builder.append((Object)operatorSuffix, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public String get");
            String _name_19 = f.getName();
            String __toFirstUpper_7 = Utils._toFirstUpper(_name_19);
            _builder.append((Object)__toFirstUpper_7, "\t");
            _builder.append((Object)operatorSuffix, "\t");
            _builder.append((Object)"() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            String _name_20 = f.getName();
            _builder.append((Object)_name_20, "\t\t");
            _builder.append((Object)operatorSuffix, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public void set");
            String _name_21 = f.getName();
            String __toFirstUpper_8 = Utils._toFirstUpper(_name_21);
            _builder.append((Object)__toFirstUpper_8, "\t");
            _builder.append((Object)operatorSuffix, "\t");
            _builder.append((Object)"(String ");
            String _name_22 = f.getName();
            _builder.append((Object)_name_22, "\t");
            _builder.append((Object)operatorSuffix, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.");
            String _name_23 = f.getName();
            _builder.append((Object)_name_23, "\t\t");
            _builder.append((Object)operatorSuffix, "\t\t");
            _builder.append((Object)" = ");
            String _name_24 = f.getName();
            _builder.append((Object)_name_24, "\t\t");
            _builder.append((Object)operatorSuffix, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _name_25 = e.getName();
            _builder.append((Object)_name_25, "\t");
            _builder.append((Object)" _set");
            String _name_26 = f.getName();
            String __toFirstUpper_9 = Utils._toFirstUpper(_name_26);
            _builder.append((Object)__toFirstUpper_9, "\t");
            _builder.append((Object)operatorSuffix, "\t");
            _builder.append((Object)"(String ");
            String _name_27 = f.getName();
            _builder.append((Object)_name_27, "\t");
            _builder.append((Object)operatorSuffix, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.");
            String _name_28 = f.getName();
            _builder.append((Object)_name_28, "\t\t");
            _builder.append((Object)operatorSuffix, "\t\t");
            _builder.append((Object)" = ");
            String _name_29 = f.getName();
            _builder.append((Object)_name_29, "\t\t");
            _builder.append((Object)operatorSuffix, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return this;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence compileHashCode(List<PojoProperty> l, ImportManager im, PojoEntity e, AnnotatedEntity ae) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int hashCode() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"final int prime = 31;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"int result = 1;");
        _builder.newLine();
        for (PojoProperty f2 : l) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"result = prime * result + ");
            boolean _isNative = this._processorGeneratorUtils.isNative(f2);
            if (_isNative) {
                _builder.append((Object)"(int) (");
                String _name = f2.getName();
                _builder.append((Object)_name, "\t\t");
                _builder.append((Object)" ^ (");
                String _name_1 = f2.getName();
                _builder.append((Object)_name_1, "\t\t");
                _builder.append((Object)" >>> 32))");
            } else {
                _builder.append((Object)"((");
                String _name_2 = f2.getName();
                _builder.append((Object)_name_2, "\t\t");
                _builder.append((Object)" != null) ? ");
                String _name_3 = f2.getName();
                _builder.append((Object)_name_3, "\t\t");
                _builder.append((Object)".hashCode() : 0)");
            }
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return result;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}\t");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileEquals(List<PojoProperty> l, ImportManager im, PojoEntity e, AnnotatedEntity ae) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public boolean equals(Object obj) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (this == obj)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return true;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (obj == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return false;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (getClass() != obj.getClass())");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return false;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        String _name = e.getName();
        _builder.append((Object)_name, "\t\t");
        _builder.append((Object)" other = (");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "\t\t");
        _builder.append((Object)") obj;");
        _builder.newLineIfNotEmpty();
        for (PojoProperty f2 : l) {
            _builder.append((Object)"\t\t");
            boolean _isNative = this._processorGeneratorUtils.isNative(f2);
            if (_isNative) {
                _builder.append((Object)"if (");
                String _name_2 = f2.getName();
                _builder.append((Object)_name_2, "\t\t");
                _builder.append((Object)" != other.");
                String _name_3 = f2.getName();
                _builder.append((Object)_name_3, "\t\t");
                _builder.append((Object)")");
            } else {
                _builder.append((Object)"if (");
                String _name_4 = f2.getName();
                _builder.append((Object)_name_4, "\t\t");
                _builder.append((Object)" == null || !");
                String _name_5 = f2.getName();
                _builder.append((Object)_name_5, "\t\t");
                _builder.append((Object)".equals(other.");
                String _name_6 = f2.getName();
                _builder.append((Object)_name_6, "\t\t");
                _builder.append((Object)"))");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"return false;");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return true;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}\t");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileToString(List<PojoProperty> l, ImportManager im, PojoEntity e, AnnotatedEntity ae) {
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String toString() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return \"");
        String _name = e.getName();
        _builder.append((Object)_name, "\t\t");
        _builder.append((Object)" [");
        boolean _hasElements = false;
        for (PojoProperty f2 : l) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" + \", ", "\t\t");
            }
            String _name_1 = f2.getName();
            _builder.append((Object)_name_1, "\t\t");
            _builder.append((Object)"=\" + ");
            String _name_2 = f2.getName();
            _builder.append((Object)_name_2, "\t\t");
        }
        PojoEntity _superType = this._processorGeneratorUtils.getSuperType(e);
        boolean bl = _notEquals = !Objects.equal((Object)_superType, null);
        if (_notEquals) {
            _builder.append((Object)" + super.toString()");
        }
        _builder.append((Object)" + \"]\";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String toStringFull() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return \"");
        String _name_3 = e.getName();
        _builder.append((Object)_name_3, "\t\t");
        _builder.append((Object)" [");
        EList<PojoAnnotatedProperty> _features = e.getFeatures();
        Functions.Function1<PojoAnnotatedProperty, Boolean> _function = new Functions.Function1<PojoAnnotatedProperty, Boolean>(){

            public Boolean apply(PojoAnnotatedProperty x) {
                PojoProperty _feature = x.getFeature();
                return ProcessorPojoGenerator.this.isAttribute(_feature);
            }
        };
        Iterable _filter = IterableExtensions.filter(_features, (Functions.Function1)_function);
        boolean _hasElements_1 = false;
        for (PojoAnnotatedProperty f2_1 : _filter) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)" + \", ", "\t\t");
            }
            PojoProperty _feature = f2_1.getFeature();
            String _name_4 = _feature.getName();
            _builder.append((Object)_name_4, "\t\t");
            _builder.append((Object)"=\" + ");
            PojoProperty _feature_1 = f2_1.getFeature();
            String _name_5 = _feature_1.getName();
            _builder.append((Object)_name_5, "\t\t");
        }
        PojoEntity _superType_1 = this._processorGeneratorUtils.getSuperType(e);
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_superType_1, null);
        if (_notEquals_1) {
            _builder.append((Object)" + super.toString()");
        }
        _builder.append((Object)" + \"]\";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileIsDef(List<PojoProperty> l, ImportManager im, PojoEntity e, AnnotatedEntity ae) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public enum Attribute {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        boolean _hasElements = false;
        for (PojoProperty f2 : l) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t\t");
            }
            String _name = f2.getName();
            _builder.append((Object)_name, "\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private Set<String> nullValues = new HashSet<String>();");
        _builder.newLine();
        _builder.newLine();
        List<Annotation> _conflictAnnotations = this._processorGeneratorUtils.conflictAnnotations(ae);
        for (Annotation a : _conflictAnnotations) {
            boolean _not;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type = a.getType();
            CharSequence _serialize = im.serialize(_type);
            _builder.append((Object)_serialize, "\t");
            EList<AnnotationProperty> _features = a.getFeatures();
            boolean _isEmpty = _features.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_1 = a.getFeatures();
                boolean _hasElements_1 = false;
                for (AnnotationProperty ff : _features_1) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty = this.compileAnnotationProperty(ff, im);
                    _builder.append((Object)_compileAnnotationProperty, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setNull(Attribute... attributes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attributes == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (Attribute attribute : attributes)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"nullValues.add(attribute.name());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        List<Annotation> _conflictAnnotations_1 = this._processorGeneratorUtils.conflictAnnotations(ae);
        for (Annotation a_1 : _conflictAnnotations_1) {
            boolean _not_1;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_1 = a_1.getType();
            CharSequence _serialize_1 = im.serialize(_type_1);
            _builder.append((Object)_serialize_1, "\t");
            EList<AnnotationProperty> _features_2 = a_1.getFeatures();
            boolean _isEmpty_1 = _features_2.isEmpty();
            boolean bl = _not_1 = !_isEmpty_1;
            if (_not_1) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_3 = a_1.getFeatures();
                boolean _hasElements_2 = false;
                for (AnnotationProperty ff_1 : _features_3) {
                    if (!_hasElements_2) {
                        _hasElements_2 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_1 = this.compileAnnotationProperty(ff_1, im);
                    _builder.append((Object)_compileAnnotationProperty_1, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)" _setNull(Attribute... attributes) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setNull(attributes);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        List<Annotation> _conflictAnnotations_2 = this._processorGeneratorUtils.conflictAnnotations(ae);
        for (Annotation a_2 : _conflictAnnotations_2) {
            boolean _not_2;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_2 = a_2.getType();
            CharSequence _serialize_2 = im.serialize(_type_2);
            _builder.append((Object)_serialize_2, "\t");
            EList<AnnotationProperty> _features_4 = a_2.getFeatures();
            boolean _isEmpty_2 = _features_4.isEmpty();
            boolean bl = _not_2 = !_isEmpty_2;
            if (_not_2) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_5 = a_2.getFeatures();
                boolean _hasElements_3 = false;
                for (AnnotationProperty ff_2 : _features_5) {
                    if (!_hasElements_3) {
                        _hasElements_3 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_2 = this.compileAnnotationProperty(ff_2, im);
                    _builder.append((Object)_compileAnnotationProperty_2, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void clearNull(Attribute... attributes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attributes == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (Attribute attribute : attributes)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"nullValues.remove(attribute.name());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        List<Annotation> _conflictAnnotations_3 = this._processorGeneratorUtils.conflictAnnotations(ae);
        for (Annotation a_3 : _conflictAnnotations_3) {
            boolean _not_3;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_3 = a_3.getType();
            CharSequence _serialize_3 = im.serialize(_type_3);
            _builder.append((Object)_serialize_3, "\t");
            EList<AnnotationProperty> _features_6 = a_3.getFeatures();
            boolean _isEmpty_3 = _features_6.isEmpty();
            boolean bl = _not_3 = !_isEmpty_3;
            if (_not_3) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_7 = a_3.getFeatures();
                boolean _hasElements_4 = false;
                for (AnnotationProperty ff_3 : _features_7) {
                    if (!_hasElements_4) {
                        _hasElements_4 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_3 = this.compileAnnotationProperty(ff_3, im);
                    _builder.append((Object)_compileAnnotationProperty_3, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_2 = e.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)" _clearNull(Attribute... attributes) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"clearNull(attributes);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setNull(String... attributes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attributes == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (String attribute : attributes)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"nullValues.add(attribute);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_3 = e.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append((Object)" _setNull(String... attributes) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setNull(attributes);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void clearNull(String... attributes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attributes == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (String attribute : attributes)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"nullValues.remove(attribute);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)" _clearNull(String... attributes) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"clearNull(attributes);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public Boolean isNull(String attrName) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attrName == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return nullValues.contains(attrName);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        List<Annotation> _conflictAnnotations_4 = this._processorGeneratorUtils.conflictAnnotations(ae);
        for (Annotation a_4 : _conflictAnnotations_4) {
            boolean _not_4;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_4 = a_4.getType();
            CharSequence _serialize_4 = im.serialize(_type_4);
            _builder.append((Object)_serialize_4, "\t");
            EList<AnnotationProperty> _features_8 = a_4.getFeatures();
            boolean _isEmpty_4 = _features_8.isEmpty();
            boolean bl = _not_4 = !_isEmpty_4;
            if (_not_4) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_9 = a_4.getFeatures();
                boolean _hasElements_5 = false;
                for (AnnotationProperty ff_4 : _features_9) {
                    if (!_hasElements_5) {
                        _hasElements_5 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_4 = this.compileAnnotationProperty(ff_4, im);
                    _builder.append((Object)_compileAnnotationProperty_4, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public Boolean isNull(Attribute attribute) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attribute == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return nullValues.contains(attribute.name());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public Boolean isDef(String attrName) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attrName == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (nullValues.contains(attrName))");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return true;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"Object result = MethodUtils.invokeMethod(this, \"get\" + attrName.substring(0, 1).toUpperCase() + attrName.substring(1, attrName.length()), null);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return (result != null) ? true : false;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (NoSuchMethodException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (IllegalAccessException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new RuntimeException(e);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (InvocationTargetException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new RuntimeException(e);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"Object result = MethodUtils.invokeMethod(this, \"is\" + attrName.substring(0, 1).toUpperCase() + attrName.substring(1, attrName.length()), null);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return (result != null) ? true : false;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (NoSuchMethodException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (IllegalAccessException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new RuntimeException(e);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (InvocationTargetException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new RuntimeException(e);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return false;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void clearAllNull() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"nullValues = new HashSet<String>();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileEnumDef(List<PojoProperty> l, ImportManager im, PojoEntity e, AnnotatedEntity ae) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public enum Attribute {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        boolean _hasElements = false;
        for (PojoProperty f2 : l) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t\t");
            }
            String _name = f2.getName();
            _builder.append((Object)_name, "\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileToInit(List<PojoProperty> l, ImportManager im, PojoEntity e, AnnotatedEntity ae) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public enum Association {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        boolean _hasElements = false;
        for (PojoProperty f2 : l) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t\t");
            }
            String _name = f2.getName();
            _builder.append((Object)_name, "\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private Set<String> initAssociations = new HashSet<String>();");
        _builder.newLine();
        _builder.newLine();
        List<Annotation> _conflictAnnotations = this._processorGeneratorUtils.conflictAnnotations(ae);
        for (Annotation a : _conflictAnnotations) {
            boolean _not;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type = a.getType();
            CharSequence _serialize = im.serialize(_type);
            _builder.append((Object)_serialize, "\t");
            EList<AnnotationProperty> _features = a.getFeatures();
            boolean _isEmpty = _features.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_1 = a.getFeatures();
                boolean _hasElements_1 = false;
                for (AnnotationProperty ff : _features_1) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty = this.compileAnnotationProperty(ff, im);
                    _builder.append((Object)_compileAnnotationProperty, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setInit(Association... associations) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (associations == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (Association association : associations)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"initAssociations.add(association.name());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        List<Annotation> _conflictAnnotations_1 = this._processorGeneratorUtils.conflictAnnotations(ae);
        for (Annotation a_1 : _conflictAnnotations_1) {
            boolean _not_1;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_1 = a_1.getType();
            CharSequence _serialize_1 = im.serialize(_type_1);
            _builder.append((Object)_serialize_1, "\t");
            EList<AnnotationProperty> _features_2 = a_1.getFeatures();
            boolean _isEmpty_1 = _features_2.isEmpty();
            boolean bl = _not_1 = !_isEmpty_1;
            if (_not_1) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_3 = a_1.getFeatures();
                boolean _hasElements_2 = false;
                for (AnnotationProperty ff_1 : _features_3) {
                    if (!_hasElements_2) {
                        _hasElements_2 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_1 = this.compileAnnotationProperty(ff_1, im);
                    _builder.append((Object)_compileAnnotationProperty_1, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)"\t_setInit(Association... associations) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setInit(associations);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        List<Annotation> _conflictAnnotations_2 = this._processorGeneratorUtils.conflictAnnotations(ae);
        for (Annotation a_2 : _conflictAnnotations_2) {
            boolean _not_2;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_2 = a_2.getType();
            CharSequence _serialize_2 = im.serialize(_type_2);
            _builder.append((Object)_serialize_2, "\t");
            EList<AnnotationProperty> _features_4 = a_2.getFeatures();
            boolean _isEmpty_2 = _features_4.isEmpty();
            boolean bl = _not_2 = !_isEmpty_2;
            if (_not_2) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_5 = a_2.getFeatures();
                boolean _hasElements_3 = false;
                for (AnnotationProperty ff_2 : _features_5) {
                    if (!_hasElements_3) {
                        _hasElements_3 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_2 = this.compileAnnotationProperty(ff_2, im);
                    _builder.append((Object)_compileAnnotationProperty_2, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void clearInit(Association... associations) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (associations == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (Association association : associations)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"initAssociations.remove(association.name());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        List<Annotation> _conflictAnnotations_3 = this._processorGeneratorUtils.conflictAnnotations(ae);
        for (Annotation a_3 : _conflictAnnotations_3) {
            boolean _not_3;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_3 = a_3.getType();
            CharSequence _serialize_3 = im.serialize(_type_3);
            _builder.append((Object)_serialize_3, "\t");
            EList<AnnotationProperty> _features_6 = a_3.getFeatures();
            boolean _isEmpty_3 = _features_6.isEmpty();
            boolean bl = _not_3 = !_isEmpty_3;
            if (_not_3) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_7 = a_3.getFeatures();
                boolean _hasElements_4 = false;
                for (AnnotationProperty ff_3 : _features_7) {
                    if (!_hasElements_4) {
                        _hasElements_4 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_3 = this.compileAnnotationProperty(ff_3, im);
                    _builder.append((Object)_compileAnnotationProperty_3, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_2 = e.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)" _clearInit(Association... associations) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"clearInit(associations);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setInit(String... associations) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (associations == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (String association : associations)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"initAssociations.add(association);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_3 = e.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append((Object)" _setInit(String... associations) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setInit(associations);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void clearInit(String... associations) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (associations == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (String association : associations)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"initAssociations.remove(association);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)" _clearInit(String... associations) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"clearInit(associations);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public Boolean toInit(String association) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (association == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return initAssociations.contains(association);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void clearAllInit() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"initAssociations = new HashSet<String>();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileEnumInit(List<PojoProperty> l, ImportManager im, PojoEntity e, AnnotatedEntity ae) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public enum Association {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        boolean _hasElements = false;
        for (PojoProperty f2 : l) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t\t");
            }
            String _name = f2.getName();
            _builder.append((Object)_name, "\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileOperators(ImportManager im, PojoEntity e, AnnotatedEntity ae) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public enum OpAttribute {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        EList<PojoAnnotatedProperty> _features = e.getFeatures();
        Functions.Function1<PojoAnnotatedProperty, Boolean> _function = new Functions.Function1<PojoAnnotatedProperty, Boolean>(){

            public Boolean apply(PojoAnnotatedProperty x) {
                PojoProperty _feature = x.getFeature();
                return ProcessorPojoGenerator.this.isAttribute(_feature);
            }
        };
        Iterator<Annotation> _filter = IterableExtensions.filter(_features, (Functions.Function1)_function);
        boolean _hasElements = false;
        Iterator iterator = _filter.iterator();
        while (iterator.hasNext()) {
            PojoAnnotatedProperty f = (PojoAnnotatedProperty)iterator.next();
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t\t");
            }
            PojoProperty _feature = f.getFeature();
            String _name = _feature.getName();
            _builder.append((Object)_name, "\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        List<Annotation> _conflictAnnotations = this._processorGeneratorUtils.conflictAnnotations(ae);
        for (Annotation a : _conflictAnnotations) {
            boolean _not;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type = a.getType();
            CharSequence _serialize = im.serialize(_type);
            _builder.append((Object)_serialize, "\t");
            EList<AnnotationProperty> _features_1 = a.getFeatures();
            boolean _isEmpty = _features_1.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_2 = a.getFeatures();
                boolean _hasElements_1 = false;
                for (AnnotationProperty ff : _features_2) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty = this.compileAnnotationProperty(ff, im);
                    _builder.append((Object)_compileAnnotationProperty, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"private Map<String, String> operators = new HashMap<String, String>();");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public Map<String, String> getOperators() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return operators;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        List<Annotation> _conflictAnnotations_1 = this._processorGeneratorUtils.conflictAnnotations(ae);
        for (Annotation a_1 : _conflictAnnotations_1) {
            boolean _not_1;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_1 = a_1.getType();
            CharSequence _serialize_1 = im.serialize(_type_1);
            _builder.append((Object)_serialize_1, "\t");
            EList<AnnotationProperty> _features_3 = a_1.getFeatures();
            boolean _isEmpty_1 = _features_3.isEmpty();
            boolean bl = _not_1 = !_isEmpty_1;
            if (_not_1) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_4 = a_1.getFeatures();
                boolean _hasElements_2 = false;
                for (AnnotationProperty ff_1 : _features_4) {
                    if (!_hasElements_2) {
                        _hasElements_2 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_1 = this.compileAnnotationProperty(ff_1, im);
                    _builder.append((Object)_compileAnnotationProperty_1, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setOp(String operator, OpAttribute... attributes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attributes == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (OpAttribute attribute : attributes)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"operators.put(attribute.name(), operator);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        List<Annotation> _conflictAnnotations_2 = this._processorGeneratorUtils.conflictAnnotations(ae);
        for (Annotation a_2 : _conflictAnnotations_2) {
            boolean _not_2;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_2 = a_2.getType();
            CharSequence _serialize_2 = im.serialize(_type_2);
            _builder.append((Object)_serialize_2, "\t");
            EList<AnnotationProperty> _features_5 = a_2.getFeatures();
            boolean _isEmpty_2 = _features_5.isEmpty();
            boolean bl = _not_2 = !_isEmpty_2;
            if (_not_2) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_6 = a_2.getFeatures();
                boolean _hasElements_3 = false;
                for (AnnotationProperty ff_2 : _features_6) {
                    if (!_hasElements_3) {
                        _hasElements_3 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_2 = this.compileAnnotationProperty(ff_2, im);
                    _builder.append((Object)_compileAnnotationProperty_2, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)" _setOp(String operator, OpAttribute... attributes) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setOp(operator, attributes);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        List<Annotation> _conflictAnnotations_3 = this._processorGeneratorUtils.conflictAnnotations(ae);
        for (Annotation a_3 : _conflictAnnotations_3) {
            boolean _not_3;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_3 = a_3.getType();
            CharSequence _serialize_3 = im.serialize(_type_3);
            _builder.append((Object)_serialize_3, "\t");
            EList<AnnotationProperty> _features_7 = a_3.getFeatures();
            boolean _isEmpty_3 = _features_7.isEmpty();
            boolean bl = _not_3 = !_isEmpty_3;
            if (_not_3) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_8 = a_3.getFeatures();
                boolean _hasElements_4 = false;
                for (AnnotationProperty ff_3 : _features_8) {
                    if (!_hasElements_4) {
                        _hasElements_4 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_3 = this.compileAnnotationProperty(ff_3, im);
                    _builder.append((Object)_compileAnnotationProperty_3, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void clearOp(OpAttribute... attributes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attributes == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (OpAttribute attribute : attributes)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"operators.remove(attribute.name());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        List<Annotation> _conflictAnnotations_4 = this._processorGeneratorUtils.conflictAnnotations(ae);
        for (Annotation a_4 : _conflictAnnotations_4) {
            boolean _not_4;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_4 = a_4.getType();
            CharSequence _serialize_4 = im.serialize(_type_4);
            _builder.append((Object)_serialize_4, "\t");
            EList<AnnotationProperty> _features_9 = a_4.getFeatures();
            boolean _isEmpty_4 = _features_9.isEmpty();
            boolean bl = _not_4 = !_isEmpty_4;
            if (_not_4) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_10 = a_4.getFeatures();
                boolean _hasElements_5 = false;
                for (AnnotationProperty ff_4 : _features_10) {
                    if (!_hasElements_5) {
                        _hasElements_5 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_4 = this.compileAnnotationProperty(ff_4, im);
                    _builder.append((Object)_compileAnnotationProperty_4, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_2 = e.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)" _clearOp(OpAttribute... attributes) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"clearOp(attributes);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setOp(String operator, String... attributes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attributes == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (String attribute : attributes)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"operators.put(attribute, operator);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_3 = e.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append((Object)" _setOp(String operator, String... attributes) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setOp(operator, attributes);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void clearOp(String... attributes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attributes == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (String attribute : attributes)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"operators.remove(attribute);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)" _clearOp(String... attributes) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"clearOp(attributes);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        List<Annotation> _conflictAnnotations_5 = this._processorGeneratorUtils.conflictAnnotations(ae);
        for (Annotation a_5 : _conflictAnnotations_5) {
            boolean _not_5;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_5 = a_5.getType();
            CharSequence _serialize_5 = im.serialize(_type_5);
            _builder.append((Object)_serialize_5, "\t");
            EList<AnnotationProperty> _features_11 = a_5.getFeatures();
            boolean _isEmpty_5 = _features_11.isEmpty();
            boolean bl = _not_5 = !_isEmpty_5;
            if (_not_5) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_12 = a_5.getFeatures();
                boolean _hasElements_6 = false;
                for (AnnotationProperty ff_5 : _features_12) {
                    if (!_hasElements_6) {
                        _hasElements_6 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_5 = this.compileAnnotationProperty(ff_5, im);
                    _builder.append((Object)_compileAnnotationProperty_5, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setNullOp(OpAttribute... attributes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attributes == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (OpAttribute attribute : attributes)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"operators.put(attribute.name(), \"is null\");");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        List<Annotation> _conflictAnnotations_6 = this._processorGeneratorUtils.conflictAnnotations(ae);
        for (Annotation a_6 : _conflictAnnotations_6) {
            boolean _not_6;
            _builder.append((Object)"\t");
            _builder.append((Object)"@");
            JvmType _type_6 = a_6.getType();
            CharSequence _serialize_6 = im.serialize(_type_6);
            _builder.append((Object)_serialize_6, "\t");
            EList<AnnotationProperty> _features_13 = a_6.getFeatures();
            boolean _isEmpty_6 = _features_13.isEmpty();
            boolean bl = _not_6 = !_isEmpty_6;
            if (_not_6) {
                _builder.append((Object)"(");
                EList<AnnotationProperty> _features_14 = a_6.getFeatures();
                boolean _hasElements_7 = false;
                for (AnnotationProperty ff_6 : _features_14) {
                    if (!_hasElements_7) {
                        _hasElements_7 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    CharSequence _compileAnnotationProperty_6 = this.compileAnnotationProperty(ff_6, im);
                    _builder.append((Object)_compileAnnotationProperty_6, "\t");
                }
                _builder.append((Object)")");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_5 = e.getName();
        _builder.append((Object)_name_5, "\t");
        _builder.append((Object)" _setNullOp(OpAttribute... attributes) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setNullOp(attributes);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void setNullOp(String... attributes) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (attributes == null)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (String attribute : attributes)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"operators.put(attribute, \"is null\");");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_6 = e.getName();
        _builder.append((Object)_name_6, "\t");
        _builder.append((Object)" _setNullOp(String... attributes) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setNullOp(attributes);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void clearAllOps() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"operators = new HashMap<String, String>();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public List<PojoAnnotatedProperty> listFeatures(PojoEntity e) {
        boolean _notEquals;
        ArrayList<PojoAnnotatedProperty> list = new ArrayList<PojoAnnotatedProperty>();
        PojoEntity _superType = this._processorGeneratorUtils.getSuperType(e);
        boolean bl = _notEquals = !Objects.equal((Object)_superType, null);
        if (_notEquals) {
            PojoEntity _superType_1 = this._processorGeneratorUtils.getSuperType(e);
            List<PojoAnnotatedProperty> _listFeatures = this.listFeatures(_superType_1);
            list.addAll(_listFeatures);
        }
        List<PojoAnnotatedProperty> _listFeatures1 = this.listFeatures1(e);
        list.addAll(_listFeatures1);
        return list;
    }

    public List<PojoAnnotatedProperty> listFeatures1(PojoEntity e) {
        EList<PojoAnnotatedProperty> _features = e.getFeatures();
        Functions.Function1<PojoAnnotatedProperty, Boolean> _function = new Functions.Function1<PojoAnnotatedProperty, Boolean>(){

            public Boolean apply(PojoAnnotatedProperty f) {
                PojoProperty _feature = f.getFeature();
                return ProcessorPojoGenerator.this._processorGeneratorUtils.isList(_feature);
            }
        };
        Iterable _filter = IterableExtensions.filter(_features, (Functions.Function1)_function);
        return IterableExtensions.toList((Iterable)_filter);
    }

    public List<PojoAnnotatedProperty> requiredFeatures(PojoEntity e) {
        boolean _notEquals;
        ArrayList<PojoAnnotatedProperty> list = new ArrayList<PojoAnnotatedProperty>();
        PojoEntity _superType = this._processorGeneratorUtils.getSuperType(e);
        boolean bl = _notEquals = !Objects.equal((Object)_superType, null);
        if (_notEquals) {
            PojoEntity _superType_1 = this._processorGeneratorUtils.getSuperType(e);
            List<PojoAnnotatedProperty> _requiredFeatures = this.requiredFeatures(_superType_1);
            list.addAll(_requiredFeatures);
        }
        List<PojoAnnotatedProperty> _requiredFeatures1 = this.requiredFeatures1(e);
        list.addAll(_requiredFeatures1);
        return list;
    }

    public ArrayList<PojoAnnotatedProperty> requiredSuperFeatures(PojoEntity e) {
        boolean _notEquals;
        ArrayList<PojoAnnotatedProperty> list = new ArrayList<PojoAnnotatedProperty>();
        PojoEntity _superType = this._processorGeneratorUtils.getSuperType(e);
        boolean bl = _notEquals = !Objects.equal((Object)_superType, null);
        if (_notEquals) {
            PojoEntity _superType_1 = this._processorGeneratorUtils.getSuperType(e);
            List<PojoAnnotatedProperty> _requiredFeatures = this.requiredFeatures(_superType_1);
            list.addAll(_requiredFeatures);
        }
        return list;
    }

    public List<PojoAnnotatedProperty> requiredFeatures1(PojoEntity e) {
        EList<PojoAnnotatedProperty> _features = e.getFeatures();
        Functions.Function1<PojoAnnotatedProperty, Boolean> _function = new Functions.Function1<PojoAnnotatedProperty, Boolean>(){

            public Boolean apply(PojoAnnotatedProperty f) {
                PojoProperty _feature = f.getFeature();
                return ProcessorPojoGenerator.this._processorGeneratorUtils.isRequired(_feature);
            }
        };
        Iterable _filter = IterableExtensions.filter(_features, (Functions.Function1)_function);
        return IterableExtensions.toList((Iterable)_filter);
    }

    public boolean isAttribute(PojoProperty f) {
        JvmType _type;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _or = false;
        Entity _ref = f.getRef();
        boolean bl = _notEquals = !Objects.equal((Object)_ref, null);
        _or = _notEquals ? true : (_notEquals_1 = !Objects.equal((Object)(_type = f.getType()), null));
        return _or;
    }

    public CharSequence compileImplements(EnumEntity e) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _sernum = this._processorGeneratorUtils.getSernum(e);
        boolean bl = _notEquals = !Objects.equal((Object)_sernum, null);
        if (_notEquals) {
            _builder.append((Object)"implements Serializable");
        }
        _builder.append((Object)" ");
        return _builder;
    }

    public CharSequence compileExtends(PojoEntity e, ImportManager im) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        PojoEntity _superType = this._processorGeneratorUtils.getSuperType(e);
        boolean bl = _notEquals = !Objects.equal((Object)_superType, null);
        if (_notEquals) {
            _builder.append((Object)"extends ");
            PojoEntity _superType_1 = this._processorGeneratorUtils.getSuperType(e);
            PojoEntity _superType_2 = this._processorGeneratorUtils.getSuperType(e);
            QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)_superType_2);
            String _fullName = Utils.getFullName(e, _superType_1, _fullyQualifiedName, im);
            _builder.append((Object)_fullName, "");
            _builder.append((Object)" ");
        } else {
            boolean _notEquals_1;
            String _extends = this.getExtends(e);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_extends, (Object)"");
            if (_notEquals_1) {
                _builder.append((Object)"extends ");
                String _extends_1 = this.getExtends(e);
                _builder.append((Object)_extends_1, "");
                _builder.append((Object)" ");
            }
        }
        return _builder;
    }

    public CharSequence compileImplements(PojoEntity e) {
        String _sernum;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _or = false;
        boolean _isImplements = this.isImplements(e);
        _or = _isImplements ? true : (_notEquals = !Objects.equal((Object)(_sernum = this._processorGeneratorUtils.getSernum(e)), null));
        if (_or) {
            boolean _notEquals_1;
            _builder.append((Object)"implements ");
            ArrayList<Implements> _implements = this.getImplements(e);
            boolean _hasElements = false;
            for (Implements f : _implements) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                JvmType _implements_1 = f.getImplements();
                String _simpleName = _implements_1.getSimpleName();
                _builder.append((Object)_simpleName, "");
            }
            String _sernum_1 = this._processorGeneratorUtils.getSernum(e);
            boolean bl = _notEquals_1 = !Objects.equal((Object)_sernum_1, null);
            if (_notEquals_1) {
                boolean _isImplements_1 = this.isImplements(e);
                if (_isImplements_1) {
                    _builder.append((Object)", ");
                }
                _builder.append((Object)"Serializable");
            }
            _builder.append((Object)" ");
        }
        return _builder;
    }

    public boolean compile(Extends e, ImportManager im) {
        JvmType _extends = e.getExtends();
        return im.addImportFor(_extends);
    }

    public void addImplements(EnumEntity e, ImportManager im) {
        EObject _eContainer = e.eContainer();
        EObject _eContainer_1 = _eContainer.eContainer();
        EList _eContents = _eContainer_1.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Implements.class);
        for (Implements impl : _filter) {
            JvmType _implements = impl.getImplements();
            im.addImportFor(_implements);
        }
    }

    public void addExtends(EnumEntity e, ImportManager im) {
        EObject _eContainer = e.eContainer();
        EObject _eContainer_1 = _eContainer.eContainer();
        EList _eContents = _eContainer_1.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Extends.class);
        for (Extends ext : _filter) {
            JvmType _extends = ext.getExtends();
            im.addImportFor(_extends);
        }
    }

    public void addImplements(PojoEntity e, ImportManager im) {
        EObject _eContainer = e.eContainer();
        EObject _eContainer_1 = _eContainer.eContainer();
        EList _eContents = _eContainer_1.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Implements.class);
        for (Implements impl : _filter) {
            JvmType _implements = impl.getImplements();
            im.addImportFor(_implements);
        }
    }

    public void addExtends(PojoEntity e, ImportManager im) {
        EObject _eContainer = e.eContainer();
        EObject _eContainer_1 = _eContainer.eContainer();
        EList _eContents = _eContainer_1.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Extends.class);
        for (Extends ext : _filter) {
            JvmType _extends = ext.getExtends();
            im.addImportFor(_extends);
        }
    }

    public void addAnnotations(List<Annotation> annotations, ImportManager im) {
        for (Annotation a : annotations) {
            JvmType _type = a.getType();
            im.serialize(_type);
        }
    }

    public String getExtends(EnumEntity e) {
        EObject _eContainer = e.eContainer();
        EObject _eContainer_1 = _eContainer.eContainer();
        EList _eContents = _eContainer_1.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Extends.class);
        Iterator iterator = _filter.iterator();
        if (iterator.hasNext()) {
            Extends ext = (Extends)iterator.next();
            JvmType _extends = ext.getExtends();
            return _extends.getSimpleName();
        }
        return "";
    }

    public boolean isImplements(EnumEntity e) {
        EObject _eContainer = e.eContainer();
        EObject _eContainer_1 = _eContainer.eContainer();
        EList _eContents = _eContainer_1.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Implements.class);
        Iterator iterator = _filter.iterator();
        if (iterator.hasNext()) {
            Implements ext = (Implements)iterator.next();
            return true;
        }
        return false;
    }

    public boolean isExtends(PojoEntity e) {
        EObject _eContainer = e.eContainer();
        EObject _eContainer_1 = _eContainer.eContainer();
        EList _eContents = _eContainer_1.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Extends.class);
        Iterator iterator = _filter.iterator();
        if (iterator.hasNext()) {
            boolean _not;
            Extends ext = (Extends)iterator.next();
            EList<PojoEntity> _onlyPojos = ext.getOnlyPojos();
            boolean _isEmpty = _onlyPojos.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                EList<PojoEntity> _onlyPojos_1 = ext.getOnlyPojos();
                for (PojoEntity ee : _onlyPojos_1) {
                    String _name_1;
                    String _name = ee.getName();
                    boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = e.getName()));
                    if (!_equals) continue;
                    return true;
                }
                return false;
            }
            EList<PojoEntity> _exceptPojos = ext.getExceptPojos();
            for (PojoEntity ee_1 : _exceptPojos) {
                String _name_3;
                String _name_2 = ee_1.getName();
                boolean _equals_1 = Objects.equal((Object)_name_2, (Object)(_name_3 = e.getName()));
                if (!_equals_1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isExtends(PojoEntity e, Extends ext) {
        boolean _not;
        EList<PojoEntity> _onlyPojos = ext.getOnlyPojos();
        boolean _isEmpty = _onlyPojos.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList<PojoEntity> _onlyPojos_1 = ext.getOnlyPojos();
            for (PojoEntity ee : _onlyPojos_1) {
                String _name_1;
                String _name = ee.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = e.getName()));
                if (!_equals) continue;
                return true;
            }
            return false;
        }
        EList<PojoEntity> _exceptPojos = ext.getExceptPojos();
        for (PojoEntity ee_1 : _exceptPojos) {
            String _name_3;
            String _name_2 = ee_1.getName();
            boolean _equals_1 = Objects.equal((Object)_name_2, (Object)(_name_3 = e.getName()));
            if (!_equals_1) continue;
            return false;
        }
        return true;
    }

    public String getExtends(PojoEntity e) {
        EObject _eContainer = e.eContainer();
        EObject _eContainer_1 = _eContainer.eContainer();
        EList _eContents = _eContainer_1.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Extends.class);
        for (Extends ext : _filter) {
            boolean _isExtends = this.isExtends(e, ext);
            if (!_isExtends) continue;
            JvmType _extends = ext.getExtends();
            return _extends.getSimpleName();
        }
        return "";
    }

    public boolean isImplements(PojoEntity e) {
        EObject _eContainer = e.eContainer();
        EObject _eContainer_1 = _eContainer.eContainer();
        EList _eContents = _eContainer_1.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Implements.class);
        for (Implements ext : _filter) {
            boolean _not;
            EList<PojoEntity> _exceptPojos = ext.getExceptPojos();
            for (PojoEntity ee : _exceptPojos) {
                String _name_1;
                String _name = ee.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = e.getName()));
                if (!_equals) continue;
                return false;
            }
            EList<PojoEntity> _onlyPojos = ext.getOnlyPojos();
            boolean _isEmpty = _onlyPojos.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                EList<PojoEntity> _onlyPojos_1 = ext.getOnlyPojos();
                for (PojoEntity ee_1 : _onlyPojos_1) {
                    String _name_3;
                    String _name_2 = ee_1.getName();
                    boolean _equals_1 = Objects.equal((Object)_name_2, (Object)(_name_3 = e.getName()));
                    if (!_equals_1) continue;
                    return true;
                }
                continue;
            }
            return true;
        }
        return false;
    }

    public boolean isImplements(PojoEntity e, Implements ext) {
        boolean _not;
        EList<PojoEntity> _onlyPojos = ext.getOnlyPojos();
        boolean _isEmpty = _onlyPojos.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList<PojoEntity> _onlyPojos_1 = ext.getOnlyPojos();
            for (PojoEntity ee : _onlyPojos_1) {
                String _name_1;
                String _name = ee.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = e.getName()));
                if (!_equals) continue;
                return true;
            }
            return false;
        }
        EList<PojoEntity> _exceptPojos = ext.getExceptPojos();
        for (PojoEntity ee_1 : _exceptPojos) {
            String _name_3;
            String _name_2 = ee_1.getName();
            boolean _equals_1 = Objects.equal((Object)_name_2, (Object)(_name_3 = e.getName()));
            if (!_equals_1) continue;
            return false;
        }
        return true;
    }

    public ArrayList<Implements> getImplements(PojoEntity e) {
        ArrayList<Implements> list = new ArrayList<Implements>();
        EObject _eContainer = e.eContainer();
        EObject _eContainer_1 = _eContainer.eContainer();
        EList _eContents = _eContainer_1.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, Implements.class);
        for (Implements ext : _filter) {
            boolean _isImplements = this.isImplements(e, ext);
            if (!_isImplements) continue;
            list.add(ext);
        }
        return list;
    }
}

