/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.generator;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.sqlproc.dsl.ProcessorDslStandaloneSetup;
import org.sqlproc.dsl.generator.IGenerator2;
import org.sqlproc.dsl.generator.TableDaoGenerator;
import org.sqlproc.dsl.generator.TableMetaGenerator;
import org.sqlproc.dsl.generator.TablePojoGenerator;
import org.sqlproc.dsl.processorDsl.AbstractPojoEntity;
import org.sqlproc.dsl.processorDsl.AnnotatedEntity;
import org.sqlproc.dsl.processorDsl.Artifacts;
import org.sqlproc.dsl.processorDsl.Entity;
import org.sqlproc.dsl.processorDsl.EnumEntity;
import org.sqlproc.dsl.processorDsl.EnumEntityModifier1;
import org.sqlproc.dsl.processorDsl.MetaStatement;
import org.sqlproc.dsl.processorDsl.Package;
import org.sqlproc.dsl.processorDsl.PojoDao;
import org.sqlproc.dsl.processorDsl.PojoEntity;
import org.sqlproc.dsl.processorDsl.PojoEntityModifier1;
import org.sqlproc.dsl.property.ModelProperty;
import org.sqlproc.dsl.property.ModelPropertyBean;
import org.sqlproc.dsl.resolver.DbResolver;
import org.sqlproc.dsl.resolver.PojoResolverFactory;
import org.sqlproc.dsl.resolver.StandalonePojoResolverImpl;
import org.sqlproc.dsl.util.Annotations;
import org.sqlproc.dsl.util.MainUtils;
import org.sqlproc.dsl.util.Utils;

public class Main {
    @Inject
    private PojoResolverFactory pojoResolverFactory;
    @Inject
    private Provider<ResourceSet> resourceSetProvider;
    @Inject
    private IResourceValidator validator;
    @Inject
    private IGenerator2 generator;
    @Inject
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    IScopeProvider scopeProvider;
    @Inject
    private IResourceFactory resourceFactory;
    @Inject
    private ModelProperty modelProperty;
    @Inject
    private DbResolver dbResolver;

    public static void main(String[] args) throws IOException, ClassNotFoundException, ParseException {
        Options options = new Options();
        options.addOption("target", true, "target directory (eg. src-gen)");
        options.addOption("source", true, "source directory (eg. src/main/resources)");
        options.addOption("control", true, "control directives file name (eg. definitions.model)");
        options.addOption("pojo", true, "POJO models file name (eg. pojo.model)");
        options.addOption("dao", true, "DAO models file name (eg. dao.model)");
        options.addOption("sql", true, "META SQLs file name to generate (eg. statements.meta)");
        options.addOption("models", true, "comma separated list of model files names (eg. pojo.model,dao.model)");
        options.addOption("ddl", true, "DDLs file name (eg. hsqldb.ddl)");
        options.addOption("nomerge", false, "do not merge generated artefacts with existing ones");
        options.addOption("verify", false, "do not generate META SQLs, only verify existing ones");
        options.addOption("skipdb", false, "in the verification process skip database control");
        options.addOption("debug", false, "DEBUG output");
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        String target = cmd.getOptionValue("target");
        String source = cmd.getOptionValue("source");
        String control = cmd.getOptionValue("control");
        String pojo = cmd.getOptionValue("pojo");
        String dao = cmd.getOptionValue("dao");
        String sql = cmd.getOptionValue("sql");
        String models = cmd.getOptionValue("models");
        String ddl = cmd.getOptionValue("ddl");
        boolean nomerge = cmd.hasOption("nomerge");
        boolean verify = cmd.hasOption("verify");
        boolean skipdb = cmd.hasOption("skipdb");
        boolean debug = cmd.hasOption("debug");
        if (debug) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < args.length) {
                sb.append(args[i]).append(" ");
                ++i;
            }
            System.out.println(sb);
        }
        if (models == null && (control == null || pojo == null || dao == null || sql == null)) {
            Main.usage(options);
            return;
        }
        Injector injector = new ProcessorDslStandaloneSetup().createInjectorAndDoEMFRegistration();
        Main main = (Main)injector.getInstance(Main.class);
        if (target == null) {
            target = models != null ? "src-gen/" : "./";
        } else if (!target.endsWith("/")) {
            target = String.valueOf(target) + "/";
        }
        if (source == null) {
            source = "";
        } else if (!source.endsWith("/")) {
            source = String.valueOf(source) + "/";
        }
        if (models != null) {
            main.generate(control, models, source, target, !verify, skipdb, ddl);
        } else if (control != null) {
            main.generate(control, pojo, dao, sql, source, target, !nomerge, ddl);
        }
    }

    private static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String header = "POJO, DAO & META SQL models generation using control directives";
        String footer = "";
        formatter.printHelp("java -jar sqlmodel.jar", header, options, footer);
        System.exit(1);
    }

    protected void generate(String control, String models, String source, String target, boolean generate, boolean skipdb, String ddl) throws IOException, ClassNotFoundException {
        String[] models4ver = models.split(",");
        ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
        Resource controlResource = resourceSet.getResource(URI.createURI((String)MainUtils.getFile(source, control)), true);
        resourceSet.getResources().add((Object)controlResource);
        ArrayList<Resource> modelsResources = new ArrayList<Resource>();
        String[] stringArray = models4ver;
        int n = models4ver.length;
        int n2 = 0;
        while (n2 < n) {
            String model = stringArray[n2];
            Resource resource = resourceSet.getResource(URI.createURI((String)MainUtils.getFile(source, model)), true);
            resourceSet.getResources().add((Object)resource);
            modelsResources.add(resource);
            ++n2;
        }
        System.out.println("Going to validate " + controlResource);
        HashSet<String> failedReferences = new HashSet<String>();
        int controlResourceIsOk = MainUtils.isValid(controlResource, failedReferences, this.validator);
        if (controlResourceIsOk != 0) {
            System.exit(2);
        }
        System.out.println("Validated " + controlResource);
        if (!generate && !skipdb) {
            Artifacts definitions = (Artifacts)controlResource.getContents().get(0);
            if (definitions.getProperties().isEmpty()) {
                System.err.println("No control directive.");
                System.exit(3);
            }
            ModelPropertyBean.ModelValues modelValues = ModelPropertyBean.loadModel(null, definitions);
            modelValues.doResolveDb = true;
            this.modelProperty.init(modelValues);
            this.pojoResolverFactory.setPojoResolver(new StandalonePojoResolverImpl(this.modelProperty, source));
            String dbSqlsBefore = MainUtils.loadDdl(source, ddl);
            this.dbResolver.init(this.modelProperty, null, dbSqlsBefore, null);
        }
        for (Resource resource : modelsResources) {
            System.out.println("Going to validate " + resource);
            int resourceIsOk = MainUtils.isValid(resource, null, this.validator);
            if (!generate && resourceIsOk != 0 || resourceIsOk == 1) {
                System.exit(2);
            } else if (resourceIsOk == 2) {
                System.out.println("Trying to ignore this error!");
            }
            System.out.println("Validated " + resource);
        }
        System.out.println("Resource(s) validation finished.");
        if (generate) {
            this.fileAccess.setOutputPath(target);
            for (Resource resource : modelsResources) {
                System.out.println("Going to generate " + resource);
                this.generator.doGenerate(resource, (IFileSystemAccess)this.fileAccess);
                System.out.println("Generated " + resource + " into " + target);
            }
            System.out.println("Java code generation finished.");
        }
    }

    protected void generate(String control, String pojo, String dao, String sql, String source, String target, boolean merge, String ddl) throws IOException, ClassNotFoundException {
        ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
        Resource controlResource = resourceSet.getResource(URI.createURI((String)this.getFile(source, control)), true);
        resourceSet.getResources().add((Object)controlResource);
        System.out.println("Going to validate " + controlResource);
        HashSet<String> failedReferences = new HashSet<String>();
        int controlResourceIsOk = MainUtils.isValid(controlResource, failedReferences, this.validator);
        if (controlResourceIsOk == 1) {
            System.exit(2);
        } else if (controlResourceIsOk == 2) {
            String controlResourceContent = MainUtils.handleResourceReferences(controlResource, failedReferences);
            System.out.println(controlResourceContent);
            controlResource = MainUtils.reloadResourceFromString(controlResourceContent, resourceSet, this.resourceFactory, "model");
            controlResourceIsOk = MainUtils.isValid(controlResource, failedReferences, this.validator);
            if (controlResourceIsOk != 0) {
                System.exit(2);
            }
        }
        System.out.println("Validated " + controlResource);
        Artifacts definitions = (Artifacts)controlResource.getContents().get(0);
        if (definitions.getProperties().isEmpty()) {
            System.err.println("No control directive.");
            System.exit(3);
        }
        ModelPropertyBean.ModelValues modelValues = ModelPropertyBean.loadModel(null, definitions);
        modelValues.doResolveDb = true;
        this.modelProperty.init(modelValues);
        this.pojoResolverFactory.setPojoResolver(new StandalonePojoResolverImpl(this.modelProperty, source));
        String dbSqlsBefore = MainUtils.loadDdl(source, ddl);
        this.dbResolver.init(this.modelProperty, null, dbSqlsBefore, null);
        Resource pojoResource = null;
        Resource daoResource = null;
        if (merge) {
            try {
                pojoResource = resourceSet.getResource(URI.createURI((String)this.getFile(source, pojo)), true);
                resourceSet.getResources().add((Object)pojoResource);
            }
            catch (Exception ex) {
                System.out.println("Can't read " + this.getFile(source, pojo));
            }
            if (pojoResource != null && dao != null) {
                try {
                    daoResource = resourceSet.getResource(URI.createURI((String)this.getFile(source, dao)), true);
                    resourceSet.getResources().add((Object)daoResource);
                }
                catch (Exception ex) {
                    System.out.println("Can't read " + this.getFile(source, dao));
                }
            }
        }
        Resource sqlResource = null;
        if (merge) {
            try {
                sqlResource = resourceSet.getResource(URI.createURI((String)this.getFile(source, sql)), true);
                resourceSet.getResources().add((Object)sqlResource);
            }
            catch (Exception ex) {
                System.out.println("Can't read " + this.getFile(source, sql));
            }
        }
        if (merge && pojoResource != null) {
            System.out.println("Going to validate " + pojoResource);
            int pojoResourceIsOk = MainUtils.isValid(pojoResource, null, this.validator);
            if (pojoResourceIsOk != 0) {
                System.exit(2);
            }
            System.out.println("Validated " + pojoResource);
        }
        if (merge && daoResource != null) {
            System.out.println("Going to validate " + daoResource);
            int daoResourceIsOk = MainUtils.isValid(daoResource, null, this.validator);
            if (daoResourceIsOk != 0) {
                System.exit(2);
            }
            System.out.println("Validated " + daoResource);
        }
        if (merge && sqlResource != null) {
            System.out.println("Going to validate " + sqlResource);
            int sqlResourceIsOk = MainUtils.isValid(sqlResource, null, this.validator);
            if (sqlResourceIsOk != 0) {
                System.exit(2);
            }
            System.out.println("Validated " + sqlResource);
        }
        Artifacts pojos = null;
        Package pojoPackage = null;
        String pojoPackageName = null;
        if (!merge) {
            pojoPackageName = this.modelProperty.getPackage(null);
        } else if (pojoResource != null) {
            pojos = (Artifacts)pojoResource.getContents().get(0);
            if (!pojos.getPackages().isEmpty()) {
                pojoPackage = (Package)pojos.getPackages().get(0);
                pojoPackageName = pojoPackage.getName();
            }
        } else {
            pojoPackageName = this.modelProperty.getPackage(null);
        }
        if (pojoPackage == null && pojoPackageName == null) {
            System.err.println("Missing POJO package.");
            System.exit(3);
        }
        this.fileAccess.setOutputPath(target);
        Artifacts daos = null;
        Package daoPackage = null;
        String daoPackageName = null;
        if (!merge) {
            daoPackageName = this.modelProperty.getDaoPackage(null);
        } else if (daoResource != null) {
            daos = (Artifacts)daoResource.getContents().get(0);
            if (!daos.getPackages().isEmpty()) {
                daoPackage = (Package)daos.getPackages().get(0);
                daoPackageName = daoPackage.getName();
            }
        } else {
            daoPackageName = this.modelProperty.getDaoPackage(null);
        }
        if (daoPackage == null && daoPackageName == null) {
            System.err.println("Missing DAO package.");
            System.exit(3);
        }
        Artifacts sqls = null;
        ArrayList<MetaStatement> statements = null;
        if (!merge) {
            statements = new ArrayList<MetaStatement>();
        } else if (sqlResource != null) {
            sqls = (Artifacts)sqlResource.getContents().get(0);
            statements = sqls.getStatements();
        }
        System.out.println("Going to generate " + pojo);
        String pojoDefinitions = this.getPojoDefinitions(this.modelProperty, this.dbResolver, definitions, pojoPackage, ((XtextResource)controlResource).getSerializer());
        this.fileAccess.generateFile(pojo, (CharSequence)("package " + pojoPackageName + " {\n" + pojoDefinitions + "}"));
        System.out.println(String.valueOf(pojo) + " generation finished.");
        System.out.println("Going to generate " + dao);
        String daoDefinitions = this.getDaoDefinitions(this.modelProperty, this.dbResolver, definitions, daoPackage, ((XtextResource)controlResource).getSerializer());
        this.fileAccess.generateFile(dao, (CharSequence)("package " + daoPackageName + " {\n" + daoDefinitions + "}"));
        System.out.println(String.valueOf(dao) + " generation finished.");
        System.out.println("Going to generate " + sql);
        String metaDefinitions = this.getMetaDefinitions(this.modelProperty, this.dbResolver, definitions, statements, ((XtextResource)controlResource).getSerializer());
        this.fileAccess.generateFile(sql, (CharSequence)metaDefinitions);
        System.out.println(String.valueOf(sql) + " generation finished.");
    }

    protected String getFile(String source, String file) {
        if (file.startsWith("/")) {
            return file;
        }
        return String.valueOf(source) + file;
    }

    protected boolean isValid(Resource resource) throws IOException {
        resource.load(null);
        List list = this.validator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
        if (!list.isEmpty()) {
            for (Issue issue : list) {
                System.err.println(issue);
            }
            return false;
        }
        return true;
    }

    protected String getPojoDefinitions(ModelProperty modelProperty, DbResolver dbResolver, Artifacts artifacts, Package packagex, ISerializer serializer) {
        if (artifacts != null && dbResolver.isResolveDb(artifacts)) {
            DbResolver.DbType dbType;
            List<String> dbSequences;
            TablePojoGenerator generator;
            HashMap<String, String> finalEntities = new HashMap<String, String>();
            Annotations annotations = new Annotations();
            String suffix = null;
            if (packagex != null) {
                suffix = Utils.getSuffix(packagex);
                for (AbstractPojoEntity ape : packagex.getElements()) {
                    Entity pojo;
                    if (!(ape instanceof AnnotatedEntity)) continue;
                    AnnotatedEntity apojo = (AnnotatedEntity)ape;
                    if (apojo.getEntity() != null && apojo.getEntity() instanceof PojoEntity) {
                        pojo = (PojoEntity)apojo.getEntity();
                        Annotations.grabAnnotations(apojo, (PojoEntity)pojo, annotations);
                        if (!this.isFinal((PojoEntity)pojo)) continue;
                        finalEntities.put(pojo.getName(), serializer.serialize((EObject)pojo));
                        continue;
                    }
                    if (apojo.getEntity() == null || !(apojo.getEntity() instanceof EnumEntity) || !this.isFinal((EnumEntity)(pojo = (EnumEntity)apojo.getEntity()))) continue;
                    finalEntities.put(pojo.getName(), serializer.serialize((EObject)pojo));
                }
            }
            if (TablePojoGenerator.addDefinitions(this.scopeProvider, dbResolver, generator = new TablePojoGenerator(modelProperty, artifacts, suffix, finalEntities, annotations, dbSequences = dbResolver.getSequences(artifacts), dbType = Utils.getDbType(dbResolver, artifacts)), artifacts)) {
                return generator.getPojoDefinitions(modelProperty, artifacts);
            }
        }
        return null;
    }

    protected String getDaoDefinitions(ModelProperty modelProperty, DbResolver dbResolver, Artifacts artifacts, Package packagex, ISerializer serializer) {
        if (artifacts != null && dbResolver.isResolveDb(artifacts)) {
            DbResolver.DbType dbType;
            List<String> dbSequences;
            TableDaoGenerator generator;
            HashMap<String, String> finalDaos = new HashMap<String, String>();
            String suffix = null;
            if (packagex != null) {
                suffix = Utils.getSuffix(packagex);
                for (AbstractPojoEntity ape : packagex.getElements()) {
                    PojoDao dao;
                    if (!(ape instanceof PojoDao) || !this.isFinal(dao = (PojoDao)ape)) continue;
                    finalDaos.put(dao.getName(), serializer.serialize((EObject)dao));
                }
            }
            if (TablePojoGenerator.addDefinitions(this.scopeProvider, dbResolver, generator = new TableDaoGenerator(modelProperty, artifacts, suffix, this.scopeProvider, finalDaos, dbSequences = dbResolver.getSequences(artifacts), dbType = Utils.getDbType(dbResolver, artifacts)), artifacts)) {
                return generator.getDaoDefinitions(modelProperty, artifacts);
            }
        }
        return null;
    }

    protected String getMetaDefinitions(ModelProperty modelProperty, DbResolver dbResolver, Artifacts artifacts, List<MetaStatement> statements, ISerializer serializer) {
        if (artifacts != null && dbResolver.isResolveDb(artifacts)) {
            DbResolver.DbType dbType;
            HashMap<String, String> finalMetas = new HashMap<String, String>();
            for (MetaStatement meta : statements) {
                if (!Utils.isFinal(meta)) continue;
                finalMetas.put(meta.getName(), serializer.serialize((EObject)meta));
            }
            List<String> dbSequences = dbResolver.getSequences(artifacts);
            TableMetaGenerator generator = new TableMetaGenerator(modelProperty, artifacts, this.scopeProvider, finalMetas, dbSequences, dbType = Utils.getDbType(dbResolver, artifacts));
            if (TablePojoGenerator.addDefinitions(this.scopeProvider, dbResolver, generator, artifacts)) {
                return generator.getMetaDefinitions(modelProperty, artifacts);
            }
        }
        return null;
    }

    protected boolean isFinal(PojoEntity e) {
        if (e.getModifiers1() == null || e.getModifiers1().isEmpty()) {
            return false;
        }
        for (PojoEntityModifier1 modifier : e.getModifiers1()) {
            if (!modifier.isFinal()) continue;
            return true;
        }
        return false;
    }

    protected boolean isFinal(EnumEntity e) {
        if (e.getModifiers1() == null || e.getModifiers1().isEmpty()) {
            return false;
        }
        for (EnumEntityModifier1 modifier : e.getModifiers1()) {
            if (!modifier.isFinal()) continue;
            return true;
        }
        return false;
    }

    protected boolean isFinal(PojoDao d) {
        if (d.getModifiers1() == null || d.getModifiers1().isEmpty()) {
            return false;
        }
        for (PojoEntityModifier1 modifier : d.getModifiers1()) {
            if (!modifier.isFinal()) continue;
            return true;
        }
        return false;
    }
}

