/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.model.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.sqlproc.model.processorModel.AbstractEntity;
import org.sqlproc.model.processorModel.AnnotatedEntity;
import org.sqlproc.model.processorModel.AnnotatedFeature;
import org.sqlproc.model.processorModel.AnnotationDefinitionModel;
import org.sqlproc.model.processorModel.Artifacts;
import org.sqlproc.model.processorModel.DaoEntity;
import org.sqlproc.model.processorModel.Entity;
import org.sqlproc.model.processorModel.Feature;
import org.sqlproc.model.processorModel.FunctionDefinitionModel;
import org.sqlproc.model.processorModel.Package;
import org.sqlproc.model.processorModel.PojoDefinitionModel;
import org.sqlproc.model.processorModel.PojoEntity;
import org.sqlproc.model.processorModel.ProcedureDefinitionModel;
import org.sqlproc.model.processorModel.ProcessorModelPackage;
import org.sqlproc.model.processorModel.Property;
import org.sqlproc.model.processorModel.TableDefinitionModel;
import org.sqlproc.model.validation.AbstractProcessorModelValidator;
import org.sqlproc.plugin.lib.property.ModelProperty;
import org.sqlproc.plugin.lib.resolver.DbResolver;
import org.sqlproc.plugin.lib.util.CommonUtils;

public class ProcessorModelValidator
extends AbstractProcessorModelValidator {
    @Inject
    private DbResolver dbResolver;
    @Inject
    private ModelProperty modelProperty;

    @Check
    public void checkUniquePojoDefinition(PojoDefinitionModel pojoDefinition) {
        boolean _skipVerification = CommonUtils.skipVerification(pojoDefinition, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(pojoDefinition);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<PojoDefinitionModel> _pojos = artifacts.getPojos();
        for (PojoDefinitionModel definition : _pojos) {
            if (Objects.equal((Object)definition, null) || definition == pojoDefinition || !Objects.equal((Object)pojoDefinition.getName(), (Object)definition.getName())) continue;
            String _name = pojoDefinition.getName();
            String _plus = "Duplicate name : " + _name;
            this.error(_plus, (EStructuralFeature)ProcessorModelPackage.Literals.POJO_DEFINITION_MODEL__NAME);
            return;
        }
    }

    @Check
    public void checkUniqueAnnotationDefinition(AnnotationDefinitionModel annotationDefinition) {
        boolean _skipVerification = CommonUtils.skipVerification(annotationDefinition, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(annotationDefinition);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<AnnotationDefinitionModel> _annotations = artifacts.getAnnotations();
        for (AnnotationDefinitionModel definition : _annotations) {
            if (Objects.equal((Object)definition, null) || definition == annotationDefinition || !Objects.equal((Object)annotationDefinition.getName(), (Object)definition.getName())) continue;
            String _name = annotationDefinition.getName();
            String _plus = "Duplicate name : " + _name;
            this.error(_plus, (EStructuralFeature)ProcessorModelPackage.Literals.ANNOTATION_DEFINITION_MODEL__NAME);
            return;
        }
    }

    @Check
    public void checkUniqueProperty(Property property) {
        boolean _skipVerification = CommonUtils.skipVerification(property, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(property);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<Property> _properties = artifacts.getProperties();
        for (Property prop : _properties) {
            if (Objects.equal((Object)prop, null) || prop == property || !Objects.equal((Object)prop.getName(), (Object)property.getName()) || prop.getName().startsWith("pojogen") || prop.getName().startsWith("database") || prop.getName().startsWith("metagen") || prop.getName().startsWith("daogen") || prop.getName().startsWith("replace-text")) continue;
            String _name = property.getName();
            String _plus = "Duplicate name : " + _name;
            this.error(_plus, (EStructuralFeature)ProcessorModelPackage.Literals.PROPERTY__NAME);
            return;
        }
    }

    @Check
    public void checkTableDefinition(TableDefinitionModel tableDefinition) {
        boolean _skipVerification = CommonUtils.skipVerification(tableDefinition, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(tableDefinition);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<TableDefinitionModel> _tables = artifacts.getTables();
        for (TableDefinitionModel table : _tables) {
            if (Objects.equal((Object)table, null) || table == tableDefinition || !Objects.equal((Object)tableDefinition.getName(), (Object)table.getName())) continue;
            String _name = tableDefinition.getName();
            String _plus = "Duplicate name : " + _name;
            String _plus_1 = String.valueOf(_plus) + "[table]";
            this.error(_plus_1, (EStructuralFeature)ProcessorModelPackage.Literals.TABLE_DEFINITION_MODEL__NAME);
            return;
        }
        if (this.isResolveDb(tableDefinition) && !this.dbResolver.checkTable(tableDefinition, tableDefinition.getTable())) {
            String _table = tableDefinition.getTable();
            String _plus_2 = "Cannot find table in DB : " + _table;
            this.error(_plus_2, (EStructuralFeature)ProcessorModelPackage.Literals.TABLE_DEFINITION_MODEL__TABLE);
        }
    }

    @Check
    public void checkProcedureDefinition(ProcedureDefinitionModel procedureDefinition) {
        boolean _skipVerification = CommonUtils.skipVerification(procedureDefinition, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(procedureDefinition);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<ProcedureDefinitionModel> _procedures = artifacts.getProcedures();
        for (ProcedureDefinitionModel procedure : _procedures) {
            if (Objects.equal((Object)procedure, null) || procedure == procedureDefinition || !Objects.equal((Object)procedureDefinition.getName(), (Object)procedure.getName())) continue;
            String _name = procedureDefinition.getName();
            String _plus = "Duplicate name : " + _name;
            String _plus_1 = String.valueOf(_plus) + "[procedure]";
            this.error(_plus_1, (EStructuralFeature)ProcessorModelPackage.Literals.PROCEDURE_DEFINITION_MODEL__NAME);
            return;
        }
        if (this.isResolveDb(procedureDefinition) && !this.dbResolver.checkProcedure(procedureDefinition, procedureDefinition.getTable())) {
            String _table = procedureDefinition.getTable();
            String _plus_2 = "Cannot find procedure in DB : " + _table;
            this.error(_plus_2, (EStructuralFeature)ProcessorModelPackage.Literals.PROCEDURE_DEFINITION_MODEL__NAME);
        }
    }

    @Check
    public void checkFunctionDefinition(FunctionDefinitionModel functionDefinition) {
        boolean _skipVerification = CommonUtils.skipVerification(functionDefinition, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(functionDefinition);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<FunctionDefinitionModel> _functions = artifacts.getFunctions();
        for (FunctionDefinitionModel function : _functions) {
            if (Objects.equal((Object)function, null) || function == functionDefinition || !Objects.equal((Object)functionDefinition.getName(), (Object)function.getName())) continue;
            String _name = functionDefinition.getName();
            String _plus = "Duplicate name : " + _name;
            String _plus_1 = String.valueOf(_plus) + "[function]";
            this.error(_plus_1, (EStructuralFeature)ProcessorModelPackage.Literals.FUNCTION_DEFINITION_MODEL__NAME);
            return;
        }
    }

    @Check
    public void checkUniquePojoEntity(Entity entity) {
        boolean _skipVerification = CommonUtils.skipVerification(entity, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(entity);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<Package> _packages = artifacts.getPackages();
        for (Package pkg : _packages) {
            boolean _notEquals;
            boolean bl = _notEquals = !Objects.equal((Object)pkg, null);
            if (!_notEquals) continue;
            EList<AbstractEntity> _elements = pkg.getElements();
            for (AbstractEntity abstractEntity : _elements) {
                Entity _entity_1;
                Entity _entity_2;
                boolean _notEquals_1;
                if (Objects.equal((Object)abstractEntity, null) || !(abstractEntity instanceof AnnotatedEntity)) continue;
                AnnotatedEntity annotatedEntity = (AnnotatedEntity)abstractEntity;
                Entity _entity = annotatedEntity.getEntity();
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)_entity, null);
                if (!_notEquals_1 || Objects.equal((Object)(_entity_2 = (_entity_1 = annotatedEntity.getEntity())), null) || _entity_2 == entity || !Objects.equal((Object)entity.getName(), (Object)_entity_2.getName())) continue;
                String _name = entity.getName();
                String _plus = "Duplicate name : " + _name;
                this.error(_plus, (EStructuralFeature)ProcessorModelPackage.Literals.ENTITY__NAME);
                return;
            }
        }
    }

    @Check
    public void checkUniquePojoAttribute(final Feature feature) {
        block3: {
            Entity entity;
            block4: {
                boolean _notEquals;
                boolean _skipVerification = CommonUtils.skipVerification(feature, this.modelProperty);
                if (_skipVerification) {
                    return;
                }
                entity = (Entity)EcoreUtil2.getContainerOfType((EObject)feature, Entity.class);
                boolean bl = _notEquals = !Objects.equal((Object)entity, null);
                if (!_notEquals) break block3;
                if (!(entity instanceof PojoEntity)) break block4;
                PojoEntity pentity = (PojoEntity)entity;
                EList<AnnotatedFeature> _features = pentity.getFeatures();
                Functions.Function1<AnnotatedFeature, Feature> _function = new Functions.Function1<AnnotatedFeature, Feature>(){

                    public Feature apply(AnnotatedFeature it) {
                        return feature;
                    }
                };
                List _map = ListExtensions.map(_features, (Functions.Function1)_function);
                for (Feature _feature : _map) {
                    if (Objects.equal((Object)_feature, null) || _feature == feature || !Objects.equal((Object)feature.getName(), (Object)_feature.getName())) continue;
                    String _name = feature.getName();
                    String _plus = "Duplicate name : " + _name;
                    this.error(_plus, (EStructuralFeature)ProcessorModelPackage.Literals.FEATURE__NAME);
                    return;
                }
                break block3;
            }
            if (!(entity instanceof DaoEntity)) break block3;
            DaoEntity pentity_1 = (DaoEntity)entity;
            EList<AnnotatedFeature> _features_1 = pentity_1.getFeatures();
            Functions.Function1<AnnotatedFeature, Feature> _function_1 = new Functions.Function1<AnnotatedFeature, Feature>(){

                public Feature apply(AnnotatedFeature it) {
                    return feature;
                }
            };
            List _map_1 = ListExtensions.map(_features_1, (Functions.Function1)_function_1);
            for (Feature _feature_1 : _map_1) {
                if (Objects.equal((Object)_feature_1, null) || _feature_1 == feature || !Objects.equal((Object)feature.getName(), (Object)_feature_1.getName())) continue;
                String _name_1 = feature.getName();
                String _plus_1 = "Duplicate name : " + _name_1;
                this.error(_plus_1, (EStructuralFeature)ProcessorModelPackage.Literals.FEATURE__NAME);
                return;
            }
        }
    }

    public boolean isResolveDb(EObject model) {
        return this.dbResolver.isResolveDb(model);
    }

    public Artifacts getArtifacts(EObject model) {
        EObject root = EcoreUtil.getRootContainer((EObject)model);
        if (!(root instanceof Artifacts)) {
            return null;
        }
        return (Artifacts)root;
    }
}

