/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.model.ui.highlighting;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.nodemodel.util.NodeTreeIterator;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.ide.highlighting.XbaseHighlightingCalculator;
import org.sqlproc.model.processorModel.FunctionDefinitionModel;
import org.sqlproc.model.processorModel.PojoAttribute;
import org.sqlproc.model.processorModel.PojoDefinitionModel;
import org.sqlproc.model.processorModel.ProcedureDefinitionModel;
import org.sqlproc.model.processorModel.TableDefinitionModel;
import org.sqlproc.plugin.lib.resolver.PojoResolver;
import org.sqlproc.plugin.lib.resolver.PojoResolverFactory;

public class SemanticHighlightingCalculator
extends XbaseHighlightingCalculator {
    @Inject
    PojoResolver pojoResolver;
    @Inject
    PojoResolverFactory pojoResolverFactory;

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        if (this.pojoResolverFactory != null && this.pojoResolverFactory.getPojoResolver() == null) {
            this.pojoResolverFactory.setPojoResolver(this.pojoResolver);
        }
        if (resource == null) {
            return;
        }
        super.provideHighlightingFor(resource, acceptor, cancelIndicator);
        TreeIterator iter = EcoreUtil.getAllContents((Resource)resource, (boolean)true);
        while (iter.hasNext()) {
            PojoDefinitionModel object;
            EObject current = (EObject)iter.next();
            ICompositeNode node = NodeModelUtils.getNode((EObject)current);
            if (current instanceof PojoDefinitionModel) {
                object = (PojoDefinitionModel)current;
                this.provideHighlightingForNameIndetifier(null, object.getName(), node, acceptor);
                continue;
            }
            if (current instanceof TableDefinitionModel) {
                object = (TableDefinitionModel)current;
                this.provideHighlightingForNameIndetifier(null, object.getName(), node, acceptor);
                continue;
            }
            if (current instanceof ProcedureDefinitionModel) {
                object = (ProcedureDefinitionModel)current;
                this.provideHighlightingForNameIndetifier(null, object.getName(), node, acceptor);
                continue;
            }
            if (current instanceof FunctionDefinitionModel) {
                object = (FunctionDefinitionModel)current;
                this.provideHighlightingForNameIndetifier(null, object.getName(), node, acceptor);
                continue;
            }
            if (!(current instanceof PojoAttribute)) continue;
            object = (PojoAttribute)current;
            this.provideHighlightingForNameIndetifier(null, object.getName(), node, acceptor);
        }
    }

    private void provideHighlightingForNameIndetifier(String name, String pojo, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (name == null && pojo == null) {
            return;
        }
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (this.equals(name, inode)) {
                acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"name"});
                if (pojo == null) {
                    return;
                }
            }
            if (!this.equals(pojo, inode)) continue;
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"identifier"});
            return;
        }
    }

    private boolean equals(String name, INode inode) {
        if (name == null || inode == null) {
            return false;
        }
        String text = inode.getText();
        if (text == null) {
            return false;
        }
        return name.equals(text.trim());
    }
}

