/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.model.ui.scoping;

import com.google.inject.Inject;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.xtext.common.types.access.jdt.IJdtTypeProvider;
import org.eclipse.xtext.common.types.access.jdt.JdtTypeProviderFactory;
import org.sqlproc.plugin.lib.resolver.PojoClassLoader;
import org.sqlproc.plugin.lib.resolver.ProcessorClassLoader;

public class ProcessorModelJdtTypeProviderFactory
extends JdtTypeProviderFactory
implements PojoClassLoader {
    protected Logger LOGGER = Logger.getLogger(ProcessorModelJdtTypeProviderFactory.class);
    @Inject
    ProcessorClassLoader processorClassLoader;
    private Map<ResourceSet, URLClassLoader> loaders = new HashMap<ResourceSet, URLClassLoader>();

    protected IJdtTypeProvider createJdtTypeProvider(IJavaProject javaProject, ResourceSet resourceSet) {
        IJdtTypeProvider jdtTypeProvider = super.createJdtTypeProvider(javaProject, resourceSet);
        this.processorClassLoader.setPojoClassLoader((PojoClassLoader)this);
        if (javaProject != null && resourceSet != null) {
            try {
                this.loaders.put(resourceSet, this.getProjectClassLoader(javaProject));
            }
            catch (CoreException e) {
                this.LOGGER.warn((Object)("Can't get project class loader for '" + javaProject + "'"), (Throwable)e);
            }
        }
        return jdtTypeProvider;
    }

    private URLClassLoader getProjectClassLoader(IJavaProject javaProject) throws CoreException {
        String[] classPathEntries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        ArrayList<URL> urlList = new ArrayList<URL>();
        int i = 0;
        while (i < classPathEntries.length) {
            String entry = classPathEntries[i];
            Path path = new Path(entry);
            try {
                URL url = path.toFile().toURI().toURL();
                urlList.add(url);
            }
            catch (MalformedURLException e) {
                this.LOGGER.warn((Object)("Can't accept URL for '" + path + "': " + e.getMessage()));
            }
            ++i;
        }
        ClassLoader parentClassLoader = javaProject.getClass().getClassLoader();
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        URLClassLoader classLoader = new URLClassLoader(urls, parentClassLoader);
        return classLoader;
    }

    public Class<?> loadClass(Resource resource, String name) {
        this.LOGGER.info((Object)("loadClass, resource=" + resource + ", name=" + name));
        if (resource == null) {
            return null;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        URLClassLoader classLoader = this.loaders.get(resourceSet);
        if (classLoader == null) {
            this.LOGGER.warn((Object)("Can't find classloader for '" + resource + "'"));
            return null;
        }
        try {
            return classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            this.LOGGER.warn((Object)("Can't load class for '" + name + "': " + e.getMessage()));
            return null;
        }
    }

    public InputStream loadFile(Resource resource, String filename) {
        IWorkspaceRoot root;
        IFile modelFile;
        IContainer modelParent;
        if (resource == null) {
            return null;
        }
        URI uri = resource.getURI();
        if (uri.isPlatformResource() && (modelParent = (modelFile = (root = ResourcesPlugin.getWorkspace().getRoot()).getFile((IPath)new Path(uri.toPlatformString(false)))).getParent()) instanceof IFolder) {
            IFolder modelDir = (IFolder)modelParent;
            IFile file = modelDir.getFile(filename);
            try {
                return file.getContents();
            }
            catch (CoreException e) {
                this.LOGGER.warn((Object)("Can't handle file '" + filename + "': " + e.getMessage()));
            }
        }
        this.LOGGER.warn((Object)("Can't find file '" + filename + "' in project"));
        return null;
    }
}

