/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.model.ui.contentassist;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.sqlproc.model.processorModel.AbstractEntity;
import org.sqlproc.model.processorModel.AnnotatedEntity;
import org.sqlproc.model.processorModel.DatabaseProperty;
import org.sqlproc.model.processorModel.DriverMethodOutputAssignement;
import org.sqlproc.model.processorModel.Entity;
import org.sqlproc.model.processorModel.ExportAssignement;
import org.sqlproc.model.processorModel.ImportAssignement;
import org.sqlproc.model.processorModel.InheritanceAssignement;
import org.sqlproc.model.processorModel.ManyToManyAssignement;
import org.sqlproc.model.processorModel.MetagenProperty;
import org.sqlproc.model.processorModel.Package;
import org.sqlproc.model.processorModel.PojoDefinitionModel;
import org.sqlproc.model.processorModel.PojoEntity;
import org.sqlproc.model.processorModel.PojogenProperty;
import org.sqlproc.model.processorModel.Property;
import org.sqlproc.model.processorModel.ShowColumnTypeAssignement;
import org.sqlproc.model.ui.contentassist.AbstractProcessorModelProposalProvider;
import org.sqlproc.plugin.lib.resolver.DbExport;
import org.sqlproc.plugin.lib.resolver.DbImport;
import org.sqlproc.plugin.lib.resolver.DbResolver;

public class ProcessorModelProposalProvider
extends AbstractProcessorModelProposalProvider {
    @Inject
    private DbResolver dbResolver;
    private final ArrayList<String> DEBUG_LEVELS = CollectionLiterals.newArrayList((Object[])new String[]{"DEBUG", "INFO", "FATAL", "ERROR", "WARN", "TRACE"});
    private final ArrayList<String> methods = CollectionLiterals.newArrayList((Object[])new String[]{"toString", "hashCode", "equals", "isDef", "toInit", "enumDef", "enumInit", "index", "procId", "enumIndex"});

    public void addProposalList(List<String> values, final String lexerRule, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor, final String prefix) {
        if (values != null) {
            Consumer<String> _function = new Consumer<String>(){

                @Override
                public void accept(String value) {
                    IValueConverterService _valueConverter = ProcessorModelProposalProvider.this.getValueConverter();
                    String _elvis = null;
                    _elvis = prefix != null ? prefix : "";
                    String _plus = String.valueOf(_elvis) + value;
                    String proposal = _valueConverter.toString((Object)_plus, lexerRule);
                    acceptor.accept(ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context));
                }
            };
            values.forEach(_function);
        }
    }

    public StringBuilder append(StringBuilder sb, String s) {
        boolean _greaterThan;
        StringBuilder _xblockexpression = null;
        int _length = sb.length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            sb.append(".");
        }
        _xblockexpression = sb.append(s);
        return _xblockexpression;
    }

    public boolean isResolveDb(EObject model) {
        return this.dbResolver.isResolveDb(model);
    }

    public String getClass(PojoDefinitionModel pojo) {
        String _xifexpression = null;
        String _classx = pojo.getClassx();
        boolean _notEquals = !Objects.equal((Object)_classx, null);
        _xifexpression = _notEquals ? pojo.getClassx() : pojo.getClass_();
        return _xifexpression;
    }

    public boolean isPrimitive(Class<?> clazz) {
        boolean _equals = Objects.equal(clazz, null);
        if (_equals) {
            return true;
        }
        boolean _equals_1 = Objects.equal(clazz, String.class);
        if (_equals_1) {
            return true;
        }
        boolean _equals_2 = Objects.equal(clazz, java.util.Date.class);
        if (_equals_2) {
            return true;
        }
        boolean _equals_3 = Objects.equal(clazz, Date.class);
        if (_equals_3) {
            return true;
        }
        boolean _equals_4 = Objects.equal(clazz, Time.class);
        if (_equals_4) {
            return true;
        }
        boolean _equals_5 = Objects.equal(clazz, Timestamp.class);
        if (_equals_5) {
            return true;
        }
        boolean _equals_6 = Objects.equal(clazz, Blob.class);
        if (_equals_6) {
            return true;
        }
        boolean _equals_7 = Objects.equal(clazz, Clob.class);
        if (_equals_7) {
            return true;
        }
        boolean _equals_8 = Objects.equal(clazz, BigDecimal.class);
        if (_equals_8) {
            return true;
        }
        boolean _equals_9 = Objects.equal(clazz, BigInteger.class);
        return _equals_9;
    }

    public void acceptTables(EObject model, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor, final String suffix) {
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                int _indexOf = it.indexOf("$");
                return _indexOf < 0;
            }
        };
        Consumer<String> _function_1 = new Consumer<String>(){

            @Override
            public void accept(String table) {
                String proposal = ProcessorModelProposalProvider.this.getValueConverter().toString((Object)table, "IDENT");
                acceptor.accept(ProcessorModelProposalProvider.this.createCompletionProposal(String.valueOf(proposal) + suffix, context));
            }
        };
        IterableExtensions.filter((Iterable)this.dbResolver.getTables(model), (Functions.Function1)_function).forEach(_function_1);
    }

    public void acceptProcedures(EObject model, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                int _indexOf = it.indexOf("$");
                return _indexOf < 0;
            }
        };
        Consumer<String> _function_1 = new Consumer<String>(){

            @Override
            public void accept(String table) {
                String proposal = ProcessorModelProposalProvider.this.getValueConverter().toString((Object)table, "IDENT");
                acceptor.accept(ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context));
            }
        };
        IterableExtensions.filter((Iterable)this.dbResolver.getProcedures(model), (Functions.Function1)_function).forEach(_function_1);
    }

    public void acceptFunctions(EObject model, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                int _indexOf = it.indexOf("$");
                return _indexOf < 0;
            }
        };
        Consumer<String> _function_1 = new Consumer<String>(){

            @Override
            public void accept(String table) {
                String proposal = ProcessorModelProposalProvider.this.getValueConverter().toString((Object)table, "IDENT");
                acceptor.accept(ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context));
            }
        };
        IterableExtensions.filter((Iterable)this.dbResolver.getFunctions(model), (Functions.Function1)_function).forEach(_function_1);
    }

    public void acceptCheckConstraints(EObject model, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                int _indexOf = it.indexOf("$");
                return _indexOf < 0;
            }
        };
        Consumer<String> _function_1 = new Consumer<String>(){

            @Override
            public void accept(String table) {
                String proposal = ProcessorModelProposalProvider.this.getValueConverter().toString((Object)table, "IDENT");
                acceptor.accept(ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context));
            }
        };
        IterableExtensions.filter((Iterable)this.dbResolver.getCheckConstraints(model), (Functions.Function1)_function).forEach(_function_1);
    }

    public void acceptSequences(EObject model, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                int _indexOf = it.indexOf("$");
                return _indexOf < 0;
            }
        };
        Consumer<String> _function_1 = new Consumer<String>(){

            @Override
            public void accept(String table) {
                String proposal = ProcessorModelProposalProvider.this.getValueConverter().toString((Object)table, "IDENT");
                acceptor.accept(ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context));
            }
        };
        IterableExtensions.filter((Iterable)this.dbResolver.getSequences(model), (Functions.Function1)_function).forEach(_function_1);
    }

    public void acceptColumns(List<String> columns, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor, final String prefix, final String suffix) {
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String column) {
                String proposal = ProcessorModelProposalProvider.this.getValueConverter().toString((Object)column, "IDENT");
                String _xifexpression = null;
                boolean _notEquals = !Objects.equal((Object)prefix, null);
                _xifexpression = _notEquals ? String.valueOf(prefix) + "." + proposal : proposal;
                String completion = _xifexpression;
                String _xifexpression_1 = null;
                boolean _notEquals_1 = !Objects.equal((Object)suffix, null);
                _xifexpression_1 = _notEquals_1 ? String.valueOf(completion) + suffix : completion;
                completion = _xifexpression_1;
                acceptor.accept(ProcessorModelProposalProvider.this.createCompletionProposal(completion, context));
            }
        };
        columns.forEach(_function);
    }

    @Override
    public void completeTableDefinitionModel_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeTableDefinitionModel_Table(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeProcedureDefinitionModel_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeProcedureDefinitionModel_Table(model, assignment, context, acceptor);
            return;
        }
        this.acceptProcedures(model, context, acceptor);
    }

    @Override
    public void completeFunctionDefinitionModel_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeFunctionDefinitionModel_Table(model, assignment, context, acceptor);
            return;
        }
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completePojogenProperty_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptCheckConstraints(model, context, acceptor);
    }

    @Override
    public void completePojogenProperty_DbProcedure(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbProcedure(model, assignment, context, acceptor);
            return;
        }
        this.acceptProcedures(model, context, acceptor);
    }

    @Override
    public void completePojogenProperty_DbFunction(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbFunction(model, assignment, context, acceptor);
            return;
        }
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeTableAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeTableAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "->");
    }

    @Override
    public void completeInheritanceAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeInheritanceAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "->");
    }

    @Override
    public void completePojogenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completePojogenProperty_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeMetagenProperty_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completePojogenProperty_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty) && !(model instanceof Property)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, null);
        }
    }

    @Override
    public void completePojogenProperty_DbColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty) && !(model instanceof Property)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, null);
        }
    }

    @Override
    public void completeImplementsAssignement_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeImplementsAssignement_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeExtendsAssignement_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeExtendsAssignement_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeImplementsAssignement_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeImplementsAssignement_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeExtendsAssignement_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeExtendsAssignement_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeImplementsAssignementGenerics_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeImplementsAssignementGenerics_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeExtendsAssignementGenerics_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeExtendsAssignementGenerics_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeImplementsAssignementGenerics_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeImplementsAssignementGenerics_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeExtendsAssignementGenerics_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeExtendsAssignementGenerics_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeColumnTypeAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty) && !(model instanceof Property)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, "->");
        } else {
            boolean _notEquals_1;
            String _dbProcedure = prop.getDbProcedure();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_dbProcedure, null);
            if (_notEquals_1) {
                this.acceptColumns(this.dbResolver.getProcColumns(model, prop.getDbProcedure()), context, acceptor, null, "->");
            } else {
                boolean _notEquals_2;
                String _dbFunction = prop.getDbFunction();
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)_dbFunction, null);
                if (_notEquals_2) {
                    this.acceptColumns(this.dbResolver.getFunColumns(model, prop.getDbFunction()), context, acceptor, null, "->");
                }
            }
        }
    }

    @Override
    public void completeColumnAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty) && !(model instanceof Property)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, "->");
            this.acceptColumns(this.dbResolver.getCheckColumns(model, prop.getDbTable()), context, acceptor, null, "->");
        }
    }

    @Override
    public void completeImportAssignement_PkTable(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof ImportAssignement)) {
            super.completeImportAssignement_PkTable(model, assignment, context, acceptor);
            return;
        }
        final ImportAssignement imp = (ImportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (!Objects.equal((Object)prop.getDbTable(), null) && !Objects.equal((Object)imp.getDbColumn(), null)) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)"create-many-to-one", (Object)_name);
            if (_equals) {
                this.acceptTables(model, context, acceptor, "");
            } else {
                Consumer<DbImport> _function = new Consumer<DbImport>(){

                    @Override
                    public void accept(DbImport dbImport) {
                        if (!Objects.equal((Object)dbImport.getFkColumn(), null) && dbImport.getFkColumn().equals(imp.getDbColumn())) {
                            String proposal = ProcessorModelProposalProvider.this.getValueConverter().toString((Object)dbImport.getPkTable(), "IDENT");
                            acceptor.accept(ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context));
                        }
                    }
                };
                this.dbResolver.getDbImports(model, prop.getDbTable()).forEach(_function);
            }
        }
    }

    @Override
    public void completeImportAssignement_PkColumn(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof ImportAssignement)) {
            super.completeImportAssignement_PkColumn(model, assignment, context, acceptor);
            return;
        }
        final ImportAssignement imp = (ImportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (!(Objects.equal((Object)prop.getDbTable(), null) || Objects.equal((Object)imp.getDbColumn(), null) || Objects.equal((Object)imp.getPkTable(), null))) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)"create-many-to-one", (Object)_name);
            if (_equals) {
                this.acceptColumns(this.dbResolver.getColumns(model, imp.getPkTable()), context, acceptor, null, null);
            } else {
                Consumer<DbImport> _function = new Consumer<DbImport>(){

                    @Override
                    public void accept(DbImport dbImport) {
                        if (!Objects.equal((Object)dbImport.getFkColumn(), null) && dbImport.getFkColumn().equals(imp.getDbColumn()) && !Objects.equal((Object)dbImport.getPkTable(), null) && dbImport.getPkTable().equals(imp.getPkTable())) {
                            String proposal = ProcessorModelProposalProvider.this.getValueConverter().toString((Object)dbImport.getPkColumn(), "IDENT");
                            acceptor.accept(ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context));
                        }
                    }
                };
                this.dbResolver.getDbImports(model, prop.getDbTable()).forEach(_function);
            }
        }
    }

    @Override
    public void completeImportAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty) && !(model instanceof Property)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, "->");
        }
    }

    @Override
    public void completeExportAssignement_FkTable(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof ExportAssignement)) {
            super.completeExportAssignement_FkTable(model, assignment, context, acceptor);
            return;
        }
        final ExportAssignement exp = (ExportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (!Objects.equal((Object)prop.getDbTable(), null) && !Objects.equal((Object)exp.getDbColumn(), null)) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)"create-one-to-many", (Object)_name);
            if (_equals) {
                this.acceptTables(model, context, acceptor, "");
            } else {
                Consumer<DbExport> _function = new Consumer<DbExport>(){

                    @Override
                    public void accept(DbExport dbExport) {
                        if (!Objects.equal((Object)dbExport.getPkColumn(), null) && dbExport.getPkColumn().equals(exp.getDbColumn())) {
                            String proposal = ProcessorModelProposalProvider.this.getValueConverter().toString((Object)dbExport.getFkTable(), "IDENT");
                            acceptor.accept(ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context));
                        }
                    }
                };
                this.dbResolver.getDbExports(model, prop.getDbTable()).forEach(_function);
            }
        }
    }

    @Override
    public void completeExportAssignement_FkColumn(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof ExportAssignement)) {
            super.completeExportAssignement_FkColumn(model, assignment, context, acceptor);
            return;
        }
        final ExportAssignement exp = (ExportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (!(Objects.equal((Object)prop.getDbTable(), null) || Objects.equal((Object)exp.getDbColumn(), null) || Objects.equal((Object)exp.getFkTable(), null))) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)"create-one-to-many", (Object)_name);
            if (_equals) {
                this.acceptColumns(this.dbResolver.getColumns(model, exp.getFkTable()), context, acceptor, null, null);
            } else {
                Consumer<DbExport> _function = new Consumer<DbExport>(){

                    @Override
                    public void accept(DbExport dbExport) {
                        if (!Objects.equal((Object)dbExport.getPkColumn(), null) && dbExport.getPkColumn().equals(exp.getDbColumn()) && !Objects.equal((Object)dbExport.getFkTable(), null) && dbExport.getFkTable().equals(exp.getFkTable())) {
                            String proposal = ProcessorModelProposalProvider.this.getValueConverter().toString((Object)dbExport.getFkColumn(), "IDENT");
                            acceptor.accept(ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context));
                        }
                    }
                };
                this.dbResolver.getDbExports(model, prop.getDbTable()).forEach(_function);
            }
        }
    }

    @Override
    public void completeExportAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty) && !(model instanceof Property)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, "->");
        }
    }

    @Override
    public void completeManyToManyAssignement_PkColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty) && !(model instanceof Property)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, "->");
        }
    }

    @Override
    public void completeManyToManyAssignement_PkTable(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof ManyToManyAssignement)) {
            super.completeManyToManyAssignement_PkTable(model, assignment, context, acceptor);
            return;
        }
        final ManyToManyAssignement many2 = (ManyToManyAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (!Objects.equal((Object)prop.getDbTable(), null) && !Objects.equal((Object)many2.getPkColumn(), null)) {
            Consumer<DbImport> _function = new Consumer<DbImport>(){

                @Override
                public void accept(DbImport dbImport) {
                    if (!Objects.equal((Object)dbImport.getPkColumn(), null) && dbImport.getPkColumn().equals(many2.getPkColumn())) {
                        String proposal = ProcessorModelProposalProvider.this.getValueConverter().toString((Object)dbImport.getPkTable(), "IDENT");
                        acceptor.accept(ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context));
                    }
                }
            };
            this.dbResolver.getDbImports(model, prop.getDbTable()).forEach(_function);
        }
    }

    @Override
    public void completeInheritanceAssignement_DbColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof InheritanceAssignement)) {
            super.completeInheritanceAssignement_DbColumns(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, null);
        }
    }

    @Override
    public void completePojogenProperty_Methods(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        if (!(model instanceof PojogenProperty)) {
            super.completePojogenProperty_Methods(model, assignment, context, acceptor);
            return;
        }
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String method) {
                String proposal = ProcessorModelProposalProvider.this.getValueConverter().toString((Object)method, "IDENT");
                acceptor.accept(ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context));
            }
        };
        this.methods.forEach(_function);
    }

    @Override
    public void completeShowColumnTypeAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty) && !(model instanceof Property)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, "->");
        } else {
            boolean _notEquals_1;
            String _dbProcedure = prop.getDbProcedure();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_dbProcedure, null);
            if (_notEquals_1) {
                this.acceptColumns(this.dbResolver.getProcColumns(model, prop.getDbProcedure()), context, acceptor, null, "->");
            } else {
                boolean _notEquals_2;
                String _dbFunction = prop.getDbFunction();
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)_dbFunction, null);
                if (_notEquals_2) {
                    this.acceptColumns(this.dbResolver.getFunColumns(model, prop.getDbFunction()), context, acceptor, null, "->");
                }
            }
        }
    }

    @Override
    public void completeShowColumnTypeAssignement_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals_3;
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof ShowColumnTypeAssignement)) {
            super.completeShowColumnTypeAssignement_Type(model, assignment, context, acceptor);
            return;
        }
        ShowColumnTypeAssignement prop = (ShowColumnTypeAssignement)model;
        PojogenProperty prop2 = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        String type = null;
        String _dbTable = prop2.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            type = this.dbResolver.getType(model, prop2.getDbTable(), prop.getDbColumn());
        } else {
            boolean _notEquals_1;
            String _dbProcedure = prop2.getDbProcedure();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_dbProcedure, null);
            if (_notEquals_1) {
                type = this.dbResolver.getType(model, prop2.getDbProcedure(), prop.getDbColumn());
            } else {
                boolean _notEquals_2;
                String _dbFunction = prop2.getDbFunction();
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)_dbFunction, null);
                if (_notEquals_2) {
                    type = this.dbResolver.getType(model, prop2.getDbFunction(), prop.getDbColumn());
                }
            }
        }
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)type, null);
        if (_notEquals_3) {
            String proposal = this.getValueConverter().toString((Object)("\"" + type + "\""), "PropertyValue");
            acceptor.accept(this.createCompletionProposal(proposal, context));
        }
    }

    @Override
    public void completeJoinTableAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeJoinTableAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "->");
    }

    @Override
    public void completeJoinTableAssignement_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeJoinTableAssignement_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    public Set<PojoEntity> listEntities(final ResourceSet resourceSet, IScope scope) {
        Comparator<PojoEntity> _function = new Comparator<PojoEntity>(){

            @Override
            public int compare(PojoEntity o1, PojoEntity o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        final TreeSet result = CollectionLiterals.newTreeSet((Comparator)_function);
        Consumer<IEObjectDescription> _function_1 = new Consumer<IEObjectDescription>(){

            @Override
            public void accept(IEObjectDescription description) {
                EObject _eObject = resourceSet.getEObject(description.getEObjectURI(), true);
                Package packageDeclaration = (Package)_eObject;
                Consumer<AbstractEntity> _function = new Consumer<AbstractEntity>(){

                    @Override
                    public void accept(AbstractEntity aEntity) {
                        AnnotatedEntity ae;
                        Entity _entity;
                        if (aEntity instanceof AnnotatedEntity && (_entity = (ae = (AnnotatedEntity)aEntity).getEntity()) instanceof PojoEntity) {
                            Entity _entity_1 = ae.getEntity();
                            result.add((PojoEntity)_entity_1);
                        }
                    }
                };
                packageDeclaration.getElements().forEach((Consumer)_function);
            }
        };
        scope.getAllElements().forEach(_function_1);
        return result;
    }

    @Override
    public void completeMetagenProperty_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeMetagenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeMetagenProperty_DbFunction(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbFunction(model, assignment, context, acceptor);
            return;
        }
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeMetagenProperty_DbProcedure(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbProcedure(model, assignment, context, acceptor);
            return;
        }
        this.acceptProcedures(model, context, acceptor);
    }

    @Override
    public void completeMetagenProperty_Sequence(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_Sequence(model, assignment, context, acceptor);
            return;
        }
        this.acceptSequences(model, context, acceptor);
    }

    @Override
    public void completeMetaTypeAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof MetagenProperty) && !(model instanceof Property)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        MetagenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getMetagen() : (MetagenProperty)model;
        MetagenProperty prop = _xifexpression;
        this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, null);
    }

    @Override
    public void completeDaogenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDaogenProperty_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeMetagenProperty_DbColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof MetagenProperty)) {
            super.completeMetagenProperty_DbColumns(model, assignment, context, acceptor);
            return;
        }
        MetagenProperty prop = (MetagenProperty)model;
        this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, null);
    }

    @Override
    public void completeDatabaseMetaInfoAssignement_DbMetaInfo(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDatabaseMetaInfoAssignement_DbMetaInfo(model, assignment, context, acceptor);
            return;
        }
        String dbMetaInfo = this.dbResolver.getDbMetaInfo(model);
        boolean bl2 = _notEquals = !Objects.equal((Object)dbMetaInfo, null);
        if (_notEquals) {
            dbMetaInfo = "\"" + dbMetaInfo + "\"";
        }
        String proposal = this.getValueConverter().toString((Object)dbMetaInfo, "PropertyValue");
        acceptor.accept(this.createCompletionProposal(proposal, context));
    }

    @Override
    public void completeDriverMetaInfoAssignement_DbDriverInfo(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDriverMetaInfoAssignement_DbDriverInfo(model, assignment, context, acceptor);
            return;
        }
        String dbDriverInfo = this.dbResolver.getDbDriverInfo(model);
        boolean bl2 = _notEquals = !Objects.equal((Object)dbDriverInfo, null);
        if (_notEquals) {
            dbDriverInfo = "\"" + dbDriverInfo + "\"";
        }
        String proposal = this.getValueConverter().toString((Object)dbDriverInfo, "PropertyValue");
        acceptor.accept(this.createCompletionProposal(proposal, context));
    }

    @Override
    public void completeDriverMethodOutputAssignement_DriverMethod(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof DatabaseProperty)) {
            super.completeDriverMethodOutputAssignement_DriverMethod(model, assignment, context, acceptor);
            return;
        }
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String driverMetod) {
                String proposal = ProcessorModelProposalProvider.this.getValueConverter().toString((Object)driverMetod, "PropertyValue");
                acceptor.accept(ProcessorModelProposalProvider.this.createCompletionProposal(String.valueOf(proposal) + "->", context));
            }
        };
        this.dbResolver.getDriverMethods(model).forEach(_function);
    }

    @Override
    public void completeDriverMethodOutputAssignement_CallOutput(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof DriverMethodOutputAssignement)) {
            super.completeDriverMethodOutputAssignement_CallOutput(model, assignment, context, acceptor);
            return;
        }
        DriverMethodOutputAssignement prop = (DriverMethodOutputAssignement)model;
        Object _elvis = null;
        Object _driverMethodOutput = this.dbResolver.getDriverMethodOutput(model, prop.getDriverMethod());
        _elvis = _driverMethodOutput != null ? _driverMethodOutput : "null";
        Object methodCallOutput = _elvis;
        String proposal = this.getValueConverter().toString((Object)("\"" + methodCallOutput + "\""), "PropertyValue");
        acceptor.accept(this.createCompletionProposal(proposal, context));
    }

    @Override
    public void completeDatabaseTypeAssignement_DbType(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDatabaseTypeAssignement_DbType(model, assignment, context, acceptor);
            return;
        }
        String dbMetaInfo = this.dbResolver.getDbMetaInfo(model);
        Consumer<DbResolver.DbType> _function = new Consumer<DbResolver.DbType>(){

            @Override
            public void accept(DbResolver.DbType dbType) {
                String proposal = ProcessorModelProposalProvider.this.getValueConverter().toString((Object)dbType.getValue(), "PropertyValue");
                acceptor.accept(ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context));
            }
        };
        ((List)Conversions.doWrapArray((Object)DbResolver.DbType.fromDbMetaInfo((String)dbMetaInfo))).forEach(_function);
    }

    @Override
    public void completeDatabaseCatalogAssignement_DbCatalog(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDatabaseCatalogAssignement_DbCatalog(model, assignment, context, acceptor);
            return;
        }
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String catalog) {
                String proposal = ProcessorModelProposalProvider.this.getValueConverter().toString((Object)catalog, "IDENT");
                acceptor.accept(ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context));
            }
        };
        this.dbResolver.getCatalogs(model).forEach(_function);
    }

    @Override
    public void completeDatabaseSchemaAssignement_DbSchema(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDatabaseSchemaAssignement_DbSchema(model, assignment, context, acceptor);
            return;
        }
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String schema) {
                String proposal = ProcessorModelProposalProvider.this.getValueConverter().toString((Object)schema, "IDENT");
                acceptor.accept(ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context));
            }
        };
        this.dbResolver.getSchemas(model).forEach(_function);
    }

    @Override
    public void completeDebugLevelAssignement_Debug(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(this.DEBUG_LEVELS, "DEBUG_LEVELS", context, acceptor, null);
    }

    @Override
    public void completeProcedurePojoAssignement_DbProcedure(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeProcedurePojoAssignement_DbProcedure(model, assignment, context, acceptor);
            return;
        }
        this.acceptProcedures(model, context, acceptor);
    }

    @Override
    public void completeFunctionPojoAssignement_DbFunction(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeFunctionPojoAssignement_DbFunction(model, assignment, context, acceptor);
            return;
        }
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completePojogenProperty_DbCheckConstraints(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbCheckConstraints(model, assignment, context, acceptor);
            return;
        }
        this.acceptCheckConstraints(model, context, acceptor);
    }
}

