/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.model.ui.contentassist;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.sqlproc.model.processorModel.AbstractEntity;
import org.sqlproc.model.processorModel.AnnotatedEntity;
import org.sqlproc.model.processorModel.DatabaseProperty;
import org.sqlproc.model.processorModel.DriverMethodOutputAssignement;
import org.sqlproc.model.processorModel.Entity;
import org.sqlproc.model.processorModel.ExportAssignement;
import org.sqlproc.model.processorModel.ImportAssignement;
import org.sqlproc.model.processorModel.InheritanceAssignement;
import org.sqlproc.model.processorModel.ManyToManyAssignement;
import org.sqlproc.model.processorModel.MetagenProperty;
import org.sqlproc.model.processorModel.Package;
import org.sqlproc.model.processorModel.PojoDefinitionModel;
import org.sqlproc.model.processorModel.PojoEntity;
import org.sqlproc.model.processorModel.PojogenProperty;
import org.sqlproc.model.processorModel.Property;
import org.sqlproc.model.processorModel.ShowColumnTypeAssignement;
import org.sqlproc.model.ui.contentassist.AbstractProcessorModelProposalProvider;
import org.sqlproc.plugin.lib.resolver.DbExport;
import org.sqlproc.plugin.lib.resolver.DbImport;
import org.sqlproc.plugin.lib.resolver.DbResolver;

public class ProcessorModelProposalProvider
extends AbstractProcessorModelProposalProvider {
    @Inject
    private DbResolver dbResolver;
    private final ArrayList<String> DEBUG_LEVELS = CollectionLiterals.newArrayList((Object[])new String[]{"DEBUG", "INFO", "FATAL", "ERROR", "WARN", "TRACE"});
    private final ArrayList<String> methods = CollectionLiterals.newArrayList((Object[])new String[]{"toString", "hashCode", "equals", "isDef", "toInit", "enumDef", "enumInit", "index", "procId", "enumIndex"});

    public void addProposalList(List<String> values, String lexerRule, ContentAssistContext context, ICompletionProposalAcceptor acceptor, String prefix) {
        if (values != null) {
            Consumer<String> _function = value -> {
                IValueConverterService _valueConverter = this.getValueConverter();
                String _elvis = null;
                _elvis = prefix != null ? prefix : "";
                String _plus = String.valueOf(_elvis) + value;
                String proposal = _valueConverter.toString((Object)_plus, lexerRule);
                ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(_createCompletionProposal);
            };
            values.forEach(_function);
        }
    }

    public StringBuilder append(StringBuilder sb, String s) {
        boolean _greaterThan;
        StringBuilder _xblockexpression = null;
        int _length = sb.length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            sb.append(".");
        }
        _xblockexpression = sb.append(s);
        return _xblockexpression;
    }

    public boolean isResolveDb(EObject model) {
        return this.dbResolver.isResolveDb(model);
    }

    public String getClass(PojoDefinitionModel pojo) {
        String _xifexpression = null;
        String _classx = pojo.getClassx();
        boolean _notEquals = !Objects.equal((Object)_classx, null);
        _xifexpression = _notEquals ? pojo.getClassx() : pojo.getClass_();
        return _xifexpression;
    }

    public boolean isPrimitive(Class<?> clazz) {
        boolean _equals = Objects.equal(clazz, null);
        if (_equals) {
            return true;
        }
        boolean _equals_1 = Objects.equal(clazz, String.class);
        if (_equals_1) {
            return true;
        }
        boolean _equals_2 = Objects.equal(clazz, java.util.Date.class);
        if (_equals_2) {
            return true;
        }
        boolean _equals_3 = Objects.equal(clazz, Date.class);
        if (_equals_3) {
            return true;
        }
        boolean _equals_4 = Objects.equal(clazz, Time.class);
        if (_equals_4) {
            return true;
        }
        boolean _equals_5 = Objects.equal(clazz, Timestamp.class);
        if (_equals_5) {
            return true;
        }
        boolean _equals_6 = Objects.equal(clazz, Blob.class);
        if (_equals_6) {
            return true;
        }
        boolean _equals_7 = Objects.equal(clazz, Clob.class);
        if (_equals_7) {
            return true;
        }
        boolean _equals_8 = Objects.equal(clazz, BigDecimal.class);
        if (_equals_8) {
            return true;
        }
        boolean _equals_9 = Objects.equal(clazz, BigInteger.class);
        return _equals_9;
    }

    public void acceptTables(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor, String suffix) {
        List _tables = this.dbResolver.getTables(model);
        Functions.Function1 _function = it -> {
            int _indexOf = it.indexOf("$");
            return _indexOf < 0;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_tables, (Functions.Function1)_function);
        Consumer<String> _function_1 = table -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString(table, "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(String.valueOf(proposal) + suffix, context);
            acceptor.accept(_createCompletionProposal);
        };
        _filter.forEach(_function_1);
    }

    public void acceptProcedures(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        List _procedures = this.dbResolver.getProcedures(model);
        Functions.Function1 _function = it -> {
            int _indexOf = it.indexOf("$");
            return _indexOf < 0;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_procedures, (Functions.Function1)_function);
        Consumer<String> _function_1 = table -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString(table, "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
        };
        _filter.forEach(_function_1);
    }

    public void acceptFunctions(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        List _functions = this.dbResolver.getFunctions(model);
        Functions.Function1 _function = it -> {
            int _indexOf = it.indexOf("$");
            return _indexOf < 0;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_functions, (Functions.Function1)_function);
        Consumer<String> _function_1 = table -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString(table, "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
        };
        _filter.forEach(_function_1);
    }

    public void acceptCheckConstraints(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        List _checkConstraints = this.dbResolver.getCheckConstraints(model);
        Functions.Function1 _function = it -> {
            int _indexOf = it.indexOf("$");
            return _indexOf < 0;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_checkConstraints, (Functions.Function1)_function);
        Consumer<String> _function_1 = table -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString(table, "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
        };
        _filter.forEach(_function_1);
    }

    public void acceptSequences(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        List _sequences = this.dbResolver.getSequences(model);
        Functions.Function1 _function = it -> {
            int _indexOf = it.indexOf("$");
            return _indexOf < 0;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_sequences, (Functions.Function1)_function);
        Consumer<String> _function_1 = table -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString(table, "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
        };
        _filter.forEach(_function_1);
    }

    public void acceptColumns(List<String> columns, ContentAssistContext context, ICompletionProposalAcceptor acceptor, String prefix, String suffix) {
        Consumer<String> _function = column -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString(column, "IDENT");
            String _xifexpression = null;
            boolean _notEquals = !Objects.equal((Object)prefix, null);
            _xifexpression = _notEquals ? String.valueOf(prefix) + "." + proposal : proposal;
            String completion = _xifexpression;
            String _xifexpression_1 = null;
            boolean _notEquals_1 = !Objects.equal((Object)suffix, null);
            _xifexpression_1 = _notEquals_1 ? String.valueOf(completion) + suffix : completion;
            completion = _xifexpression_1;
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(completion, context);
            acceptor.accept(_createCompletionProposal);
        };
        columns.forEach(_function);
    }

    @Override
    public void completeTableDefinitionModel_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeTableDefinitionModel_Table(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeProcedureDefinitionModel_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeProcedureDefinitionModel_Table(model, assignment, context, acceptor);
            return;
        }
        this.acceptProcedures(model, context, acceptor);
    }

    @Override
    public void completeFunctionDefinitionModel_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeFunctionDefinitionModel_Table(model, assignment, context, acceptor);
            return;
        }
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completePojogenProperty_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptCheckConstraints(model, context, acceptor);
    }

    @Override
    public void completePojogenProperty_DbProcedure(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbProcedure(model, assignment, context, acceptor);
            return;
        }
        this.acceptProcedures(model, context, acceptor);
    }

    @Override
    public void completePojogenProperty_DbFunction(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbFunction(model, assignment, context, acceptor);
            return;
        }
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeTableAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeTableAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "->");
    }

    @Override
    public void completeInheritanceAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeInheritanceAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "->");
    }

    @Override
    public void completePojogenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completePojogenProperty_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeMetagenProperty_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completePojogenProperty_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty) && !(model instanceof Property)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, null);
        }
    }

    @Override
    public void completePojogenProperty_DbColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty) && !(model instanceof Property)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, null);
        }
    }

    @Override
    public void completeImplementsAssignement_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeImplementsAssignement_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeExtendsAssignement_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeExtendsAssignement_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeImplementsAssignement_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeImplementsAssignement_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeExtendsAssignement_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeExtendsAssignement_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeImplementsAssignementGenerics_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeImplementsAssignementGenerics_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeExtendsAssignementGenerics_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeExtendsAssignementGenerics_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeImplementsAssignementGenerics_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeImplementsAssignementGenerics_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeExtendsAssignementGenerics_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeExtendsAssignementGenerics_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeColumnTypeAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty) && !(model instanceof Property)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, "->");
        } else {
            boolean _notEquals_1;
            String _dbProcedure = prop.getDbProcedure();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_dbProcedure, null);
            if (_notEquals_1) {
                String _dbProcedure_1 = prop.getDbProcedure();
                List _procColumns = this.dbResolver.getProcColumns(model, _dbProcedure_1);
                this.acceptColumns(_procColumns, context, acceptor, null, "->");
            } else {
                boolean _notEquals_2;
                String _dbFunction = prop.getDbFunction();
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)_dbFunction, null);
                if (_notEquals_2) {
                    String _dbFunction_1 = prop.getDbFunction();
                    List _funColumns = this.dbResolver.getFunColumns(model, _dbFunction_1);
                    this.acceptColumns(_funColumns, context, acceptor, null, "->");
                }
            }
        }
    }

    @Override
    public void completeColumnAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty) && !(model instanceof Property)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, "->");
            String _dbTable_2 = prop.getDbTable();
            List _checkColumns = this.dbResolver.getCheckColumns(model, _dbTable_2);
            this.acceptColumns(_checkColumns, context, acceptor, null, "->");
        }
    }

    @Override
    public void completeImportAssignement_PkTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof ImportAssignement)) {
            super.completeImportAssignement_PkTable(model, assignment, context, acceptor);
            return;
        }
        ImportAssignement imp = (ImportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (!Objects.equal((Object)prop.getDbTable(), null) && !Objects.equal((Object)imp.getDbColumn(), null)) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)"create-many-to-one", (Object)_name);
            if (_equals) {
                this.acceptTables(model, context, acceptor, "");
            } else {
                String _dbTable = prop.getDbTable();
                List _dbImports = this.dbResolver.getDbImports(model, _dbTable);
                Consumer<DbImport> _function = dbImport -> {
                    if (!Objects.equal((Object)dbImport.getFkColumn(), null) && dbImport.getFkColumn().equals(imp.getDbColumn())) {
                        IValueConverterService _valueConverter = this.getValueConverter();
                        String _pkTable = dbImport.getPkTable();
                        String proposal = _valueConverter.toString((Object)_pkTable, "IDENT");
                        ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
                        acceptor.accept(_createCompletionProposal);
                    }
                };
                _dbImports.forEach(_function);
            }
        }
    }

    @Override
    public void completeImportAssignement_PkColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof ImportAssignement)) {
            super.completeImportAssignement_PkColumn(model, assignment, context, acceptor);
            return;
        }
        ImportAssignement imp = (ImportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (!(Objects.equal((Object)prop.getDbTable(), null) || Objects.equal((Object)imp.getDbColumn(), null) || Objects.equal((Object)imp.getPkTable(), null))) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)"create-many-to-one", (Object)_name);
            if (_equals) {
                String _pkTable = imp.getPkTable();
                List _columns = this.dbResolver.getColumns(model, _pkTable);
                this.acceptColumns(_columns, context, acceptor, null, null);
            } else {
                String _dbTable = prop.getDbTable();
                List _dbImports = this.dbResolver.getDbImports(model, _dbTable);
                Consumer<DbImport> _function = dbImport -> {
                    if (!Objects.equal((Object)dbImport.getFkColumn(), null) && dbImport.getFkColumn().equals(imp.getDbColumn()) && !Objects.equal((Object)dbImport.getPkTable(), null) && dbImport.getPkTable().equals(imp.getPkTable())) {
                        IValueConverterService _valueConverter = this.getValueConverter();
                        String _pkColumn = dbImport.getPkColumn();
                        String proposal = _valueConverter.toString((Object)_pkColumn, "IDENT");
                        ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
                        acceptor.accept(_createCompletionProposal);
                    }
                };
                _dbImports.forEach(_function);
            }
        }
    }

    @Override
    public void completeImportAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty) && !(model instanceof Property)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, "->");
        }
    }

    @Override
    public void completeExportAssignement_FkTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof ExportAssignement)) {
            super.completeExportAssignement_FkTable(model, assignment, context, acceptor);
            return;
        }
        ExportAssignement exp = (ExportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (!Objects.equal((Object)prop.getDbTable(), null) && !Objects.equal((Object)exp.getDbColumn(), null)) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)"create-one-to-many", (Object)_name);
            if (_equals) {
                this.acceptTables(model, context, acceptor, "");
            } else {
                String _dbTable = prop.getDbTable();
                List _dbExports = this.dbResolver.getDbExports(model, _dbTable);
                Consumer<DbExport> _function = dbExport -> {
                    if (!Objects.equal((Object)dbExport.getPkColumn(), null) && dbExport.getPkColumn().equals(exp.getDbColumn())) {
                        IValueConverterService _valueConverter = this.getValueConverter();
                        String _fkTable = dbExport.getFkTable();
                        String proposal = _valueConverter.toString((Object)_fkTable, "IDENT");
                        ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
                        acceptor.accept(_createCompletionProposal);
                    }
                };
                _dbExports.forEach(_function);
            }
        }
    }

    @Override
    public void completeExportAssignement_FkColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof ExportAssignement)) {
            super.completeExportAssignement_FkColumn(model, assignment, context, acceptor);
            return;
        }
        ExportAssignement exp = (ExportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (!(Objects.equal((Object)prop.getDbTable(), null) || Objects.equal((Object)exp.getDbColumn(), null) || Objects.equal((Object)exp.getFkTable(), null))) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)"create-one-to-many", (Object)_name);
            if (_equals) {
                String _fkTable = exp.getFkTable();
                List _columns = this.dbResolver.getColumns(model, _fkTable);
                this.acceptColumns(_columns, context, acceptor, null, null);
            } else {
                String _dbTable = prop.getDbTable();
                List _dbExports = this.dbResolver.getDbExports(model, _dbTable);
                Consumer<DbExport> _function = dbExport -> {
                    if (!Objects.equal((Object)dbExport.getPkColumn(), null) && dbExport.getPkColumn().equals(exp.getDbColumn()) && !Objects.equal((Object)dbExport.getFkTable(), null) && dbExport.getFkTable().equals(exp.getFkTable())) {
                        IValueConverterService _valueConverter = this.getValueConverter();
                        String _fkColumn = dbExport.getFkColumn();
                        String proposal = _valueConverter.toString((Object)_fkColumn, "IDENT");
                        ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
                        acceptor.accept(_createCompletionProposal);
                    }
                };
                _dbExports.forEach(_function);
            }
        }
    }

    @Override
    public void completeExportAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty) && !(model instanceof Property)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, "->");
        }
    }

    @Override
    public void completeManyToManyAssignement_PkColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty) && !(model instanceof Property)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, "->");
        }
    }

    @Override
    public void completeManyToManyAssignement_PkTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof ManyToManyAssignement)) {
            super.completeManyToManyAssignement_PkTable(model, assignment, context, acceptor);
            return;
        }
        ManyToManyAssignement many2 = (ManyToManyAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (!Objects.equal((Object)prop.getDbTable(), null) && !Objects.equal((Object)many2.getPkColumn(), null)) {
            String _dbTable = prop.getDbTable();
            List _dbImports = this.dbResolver.getDbImports(model, _dbTable);
            Consumer<DbImport> _function = dbImport -> {
                if (!Objects.equal((Object)dbImport.getPkColumn(), null) && dbImport.getPkColumn().equals(many2.getPkColumn())) {
                    IValueConverterService _valueConverter = this.getValueConverter();
                    String _pkTable = dbImport.getPkTable();
                    String proposal = _valueConverter.toString((Object)_pkTable, "IDENT");
                    ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
                    acceptor.accept(_createCompletionProposal);
                }
            };
            _dbImports.forEach(_function);
        }
    }

    @Override
    public void completeInheritanceAssignement_DbColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof InheritanceAssignement)) {
            super.completeInheritanceAssignement_DbColumns(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, null);
        }
    }

    @Override
    public void completePojogenProperty_Methods(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!(model instanceof PojogenProperty)) {
            super.completePojogenProperty_Methods(model, assignment, context, acceptor);
            return;
        }
        Consumer<String> _function = method -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString(method, "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
        };
        this.methods.forEach(_function);
    }

    @Override
    public void completeShowColumnTypeAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty) && !(model instanceof Property)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, "->");
        } else {
            boolean _notEquals_1;
            String _dbProcedure = prop.getDbProcedure();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_dbProcedure, null);
            if (_notEquals_1) {
                String _dbProcedure_1 = prop.getDbProcedure();
                List _procColumns = this.dbResolver.getProcColumns(model, _dbProcedure_1);
                this.acceptColumns(_procColumns, context, acceptor, null, "->");
            } else {
                boolean _notEquals_2;
                String _dbFunction = prop.getDbFunction();
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)_dbFunction, null);
                if (_notEquals_2) {
                    String _dbFunction_1 = prop.getDbFunction();
                    List _funColumns = this.dbResolver.getFunColumns(model, _dbFunction_1);
                    this.acceptColumns(_funColumns, context, acceptor, null, "->");
                }
            }
        }
    }

    @Override
    public void completeShowColumnTypeAssignement_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals_3;
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof ShowColumnTypeAssignement)) {
            super.completeShowColumnTypeAssignement_Type(model, assignment, context, acceptor);
            return;
        }
        ShowColumnTypeAssignement prop = (ShowColumnTypeAssignement)model;
        PojogenProperty prop2 = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        String type = null;
        String _dbTable = prop2.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _type;
            String _dbTable_1 = prop2.getDbTable();
            String _dbColumn = prop.getDbColumn();
            type = _type = this.dbResolver.getType(model, _dbTable_1, _dbColumn);
        } else {
            boolean _notEquals_1;
            String _dbProcedure = prop2.getDbProcedure();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_dbProcedure, null);
            if (_notEquals_1) {
                String _type_1;
                String _dbProcedure_1 = prop2.getDbProcedure();
                String _dbColumn_1 = prop.getDbColumn();
                type = _type_1 = this.dbResolver.getType(model, _dbProcedure_1, _dbColumn_1);
            } else {
                boolean _notEquals_2;
                String _dbFunction = prop2.getDbFunction();
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)_dbFunction, null);
                if (_notEquals_2) {
                    String _type_2;
                    String _dbFunction_1 = prop2.getDbFunction();
                    String _dbColumn_2 = prop.getDbColumn();
                    type = _type_2 = this.dbResolver.getType(model, _dbFunction_1, _dbColumn_2);
                }
            }
        }
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)type, null);
        if (_notEquals_3) {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString((Object)("\"" + type + "\""), "PropertyValue");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
        }
    }

    @Override
    public void completeJoinTableAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeJoinTableAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "->");
    }

    @Override
    public void completeJoinTableAssignement_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeJoinTableAssignement_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    public Set<PojoEntity> listEntities(ResourceSet resourceSet, IScope scope) {
        Comparator _function = (o1, o2) -> {
            String _name = o1.getName();
            String _name_1 = o2.getName();
            return _name.compareTo(_name_1);
        };
        TreeSet result = CollectionLiterals.newTreeSet((Comparator)_function, (Object[])new PojoEntity[0]);
        Iterable _allElements = scope.getAllElements();
        Consumer<IEObjectDescription> _function_1 = description -> {
            URI _eObjectURI = description.getEObjectURI();
            EObject _eObject = resourceSet.getEObject(_eObjectURI, true);
            Package packageDeclaration = (Package)_eObject;
            EList _elements = packageDeclaration.getElements();
            Consumer<AbstractEntity> _function_2 = aEntity -> {
                AnnotatedEntity ae;
                Entity _entity;
                if (aEntity instanceof AnnotatedEntity && (_entity = (ae = (AnnotatedEntity)aEntity).getEntity()) instanceof PojoEntity) {
                    Entity _entity_1 = ae.getEntity();
                    result.add((PojoEntity)_entity_1);
                }
            };
            _elements.forEach(_function_2);
        };
        _allElements.forEach(_function_1);
        return result;
    }

    @Override
    public void completeMetagenProperty_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeMetagenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeMetagenProperty_DbFunction(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbFunction(model, assignment, context, acceptor);
            return;
        }
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeMetagenProperty_DbProcedure(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbProcedure(model, assignment, context, acceptor);
            return;
        }
        this.acceptProcedures(model, context, acceptor);
    }

    @Override
    public void completeMetagenProperty_Sequence(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_Sequence(model, assignment, context, acceptor);
            return;
        }
        this.acceptSequences(model, context, acceptor);
    }

    @Override
    public void completeMetaTypeAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof MetagenProperty) && !(model instanceof Property)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        MetagenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getMetagen() : (MetagenProperty)model;
        MetagenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        List _columns = this.dbResolver.getColumns(model, _dbTable);
        this.acceptColumns(_columns, context, acceptor, null, null);
    }

    @Override
    public void completeDaogenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDaogenProperty_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeMetagenProperty_DbColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof MetagenProperty)) {
            super.completeMetagenProperty_DbColumns(model, assignment, context, acceptor);
            return;
        }
        MetagenProperty prop = (MetagenProperty)model;
        String _dbTable = prop.getDbTable();
        List _columns = this.dbResolver.getColumns(model, _dbTable);
        this.acceptColumns(_columns, context, acceptor, null, null);
    }

    @Override
    public void completeDatabaseMetaInfoAssignement_DbMetaInfo(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDatabaseMetaInfoAssignement_DbMetaInfo(model, assignment, context, acceptor);
            return;
        }
        String dbMetaInfo = this.dbResolver.getDbMetaInfo(model);
        boolean bl2 = _notEquals = !Objects.equal((Object)dbMetaInfo, null);
        if (_notEquals) {
            dbMetaInfo = "\"" + dbMetaInfo + "\"";
        }
        IValueConverterService _valueConverter = this.getValueConverter();
        String proposal = _valueConverter.toString((Object)dbMetaInfo, "PropertyValue");
        ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
        acceptor.accept(_createCompletionProposal);
    }

    @Override
    public void completeDriverMetaInfoAssignement_DbDriverInfo(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDriverMetaInfoAssignement_DbDriverInfo(model, assignment, context, acceptor);
            return;
        }
        String dbDriverInfo = this.dbResolver.getDbDriverInfo(model);
        boolean bl2 = _notEquals = !Objects.equal((Object)dbDriverInfo, null);
        if (_notEquals) {
            dbDriverInfo = "\"" + dbDriverInfo + "\"";
        }
        IValueConverterService _valueConverter = this.getValueConverter();
        String proposal = _valueConverter.toString((Object)dbDriverInfo, "PropertyValue");
        ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
        acceptor.accept(_createCompletionProposal);
    }

    @Override
    public void completeDriverMethodOutputAssignement_DriverMethod(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof DatabaseProperty)) {
            super.completeDriverMethodOutputAssignement_DriverMethod(model, assignment, context, acceptor);
            return;
        }
        Set _driverMethods = this.dbResolver.getDriverMethods(model);
        Consumer<String> _function = driverMetod -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString(driverMetod, "PropertyValue");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(String.valueOf(proposal) + "->", context);
            acceptor.accept(_createCompletionProposal);
        };
        _driverMethods.forEach(_function);
    }

    @Override
    public void completeDriverMethodOutputAssignement_CallOutput(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof DriverMethodOutputAssignement)) {
            super.completeDriverMethodOutputAssignement_CallOutput(model, assignment, context, acceptor);
            return;
        }
        DriverMethodOutputAssignement prop = (DriverMethodOutputAssignement)model;
        Object _elvis = null;
        String _driverMethod = prop.getDriverMethod();
        Object _driverMethodOutput = this.dbResolver.getDriverMethodOutput(model, _driverMethod);
        _elvis = _driverMethodOutput != null ? _driverMethodOutput : "null";
        Object methodCallOutput = _elvis;
        IValueConverterService _valueConverter = this.getValueConverter();
        String proposal = _valueConverter.toString((Object)("\"" + methodCallOutput + "\""), "PropertyValue");
        ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
        acceptor.accept(_createCompletionProposal);
    }

    @Override
    public void completeDatabaseTypeAssignement_DbType(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDatabaseTypeAssignement_DbType(model, assignment, context, acceptor);
            return;
        }
        String dbMetaInfo = this.dbResolver.getDbMetaInfo(model);
        DbResolver.DbType[] _fromDbMetaInfo = DbResolver.DbType.fromDbMetaInfo((String)dbMetaInfo);
        Consumer<DbResolver.DbType> _function = dbType -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String _value = dbType.getValue();
            String proposal = _valueConverter.toString((Object)_value, "PropertyValue");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
        };
        ((List)Conversions.doWrapArray((Object)_fromDbMetaInfo)).forEach(_function);
    }

    @Override
    public void completeDatabaseCatalogAssignement_DbCatalog(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDatabaseCatalogAssignement_DbCatalog(model, assignment, context, acceptor);
            return;
        }
        List _catalogs = this.dbResolver.getCatalogs(model);
        Consumer<String> _function = catalog -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString(catalog, "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
        };
        _catalogs.forEach(_function);
    }

    @Override
    public void completeDatabaseSchemaAssignement_DbSchema(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDatabaseSchemaAssignement_DbSchema(model, assignment, context, acceptor);
            return;
        }
        List _schemas = this.dbResolver.getSchemas(model);
        Consumer<String> _function = schema -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString(schema, "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
        };
        _schemas.forEach(_function);
    }

    @Override
    public void completeDebugLevelAssignement_Debug(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(this.DEBUG_LEVELS, "DEBUG_LEVELS", context, acceptor, null);
    }

    @Override
    public void completeProcedurePojoAssignement_DbProcedure(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeProcedurePojoAssignement_DbProcedure(model, assignment, context, acceptor);
            return;
        }
        this.acceptProcedures(model, context, acceptor);
    }

    @Override
    public void completeFunctionPojoAssignement_DbFunction(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeFunctionPojoAssignement_DbFunction(model, assignment, context, acceptor);
            return;
        }
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completePojogenProperty_DbCheckConstraints(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbCheckConstraints(model, assignment, context, acceptor);
            return;
        }
        this.acceptCheckConstraints(model, context, acceptor);
    }
}

