/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.model.ui.templates;

import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.templates.SimpleTemplateVariableResolver;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContext;
import org.eclipse.xtext.xbase.ui.templates.XbaseTemplateContextType;
import org.sqlproc.model.generator.TableDaoGenerator;
import org.sqlproc.model.generator.TablePojoGenerator;
import org.sqlproc.model.processorModel.Artifacts;
import org.sqlproc.model.processorModel.Package;
import org.sqlproc.plugin.lib.property.ModelProperty;
import org.sqlproc.plugin.lib.resolver.DbResolver;
import org.sqlproc.plugin.lib.resolver.PojoResolver;
import org.sqlproc.plugin.lib.util.CommonUtils;
import org.sqlproc.plugin.lib.util.Stats;

public class ProcessorModelTemplateContextType
extends XbaseTemplateContextType {
    @Inject
    PojoResolver pojoResolver;
    @Inject
    DbResolver dbResolver;
    @Inject
    IScopeProvider scopeProvider;
    @Inject
    ModelProperty modelProperty;

    protected void addDefaultTemplateVariables() {
        super.addDefaultTemplateVariables();
        super.addResolver((TemplateVariableResolver)new TablesDefinitionsResolver());
        super.addResolver((TemplateVariableResolver)new ProceduresDefinitionsResolver());
        super.addResolver((TemplateVariableResolver)new FunctionsDefinitionsResolver());
        super.addResolver((TemplateVariableResolver)new PojoGeneratorResolver());
        super.addResolver((TemplateVariableResolver)new DaoGeneratorResolver());
    }

    protected Artifacts getArtifacts(XtextTemplateContext xtextTemplateContext) {
        if (xtextTemplateContext == null) {
            return null;
        }
        EObject object = xtextTemplateContext.getContentAssistContext().getCurrentModel();
        if (object == null) {
            return null;
        }
        return (Artifacts)EcoreUtil2.getContainerOfType((EObject)object, Artifacts.class);
    }

    protected Package getPackage(XtextTemplateContext xtextTemplateContext) {
        if (xtextTemplateContext == null) {
            return null;
        }
        EObject object = xtextTemplateContext.getContentAssistContext().getCurrentModel();
        Package packagex = (Package)EcoreUtil2.getContainerOfType((EObject)object, Package.class);
        return packagex;
    }

    public class DaoGeneratorResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "daoGenerator";

        public DaoGeneratorResolver() {
            super(NAME, "DaoGenerator");
        }

        protected String resolve(TemplateContext context) {
            Stats stats;
            Package packagex;
            Artifacts artifacts = ProcessorModelTemplateContextType.this.getArtifacts((XtextTemplateContext)context);
            String daos = TableDaoGenerator.generateDao((Artifacts)artifacts, (Package)(packagex = ProcessorModelTemplateContextType.this.getPackage((XtextTemplateContext)context)), null, (DbResolver)ProcessorModelTemplateContextType.this.dbResolver, (IScopeProvider)ProcessorModelTemplateContextType.this.scopeProvider, (ModelProperty)ProcessorModelTemplateContextType.this.modelProperty, (Stats)(stats = new Stats()));
            if (daos != null) {
                return String.valueOf(daos) + stats.toString();
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class FunctionsDefinitionsResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "functionDefinitions";

        public FunctionsDefinitionsResolver() {
            super(NAME, "FunctionDefinitions");
        }

        protected String resolve(TemplateContext context) {
            Artifacts artifacts = ProcessorModelTemplateContextType.this.getArtifacts((XtextTemplateContext)context);
            if (artifacts != null && ProcessorModelTemplateContextType.this.dbResolver.isResolveDb((EObject)artifacts)) {
                Map functionsPresented = ProcessorModelTemplateContextType.this.modelProperty.getModelFunctions((EObject)artifacts);
                List functions = ProcessorModelTemplateContextType.this.dbResolver.getFunctions((EObject)artifacts);
                return CommonUtils.getFunctionsDefinitions((List)functions, (Map)functionsPresented);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class PojoGeneratorResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "pojoGenerator";

        public PojoGeneratorResolver() {
            super(NAME, "PojoGenerator");
        }

        protected String resolve(TemplateContext context) {
            Stats stats;
            Package packagex;
            Artifacts artifacts = ProcessorModelTemplateContextType.this.getArtifacts((XtextTemplateContext)context);
            String pojos = TablePojoGenerator.generatePojo((Artifacts)artifacts, (Package)(packagex = ProcessorModelTemplateContextType.this.getPackage((XtextTemplateContext)context)), null, (DbResolver)ProcessorModelTemplateContextType.this.dbResolver, (IScopeProvider)ProcessorModelTemplateContextType.this.scopeProvider, (ModelProperty)ProcessorModelTemplateContextType.this.modelProperty, (Stats)(stats = new Stats()));
            if (pojos != null) {
                return String.valueOf(pojos) + stats.toString();
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class ProceduresDefinitionsResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "procedureDefinitions";

        public ProceduresDefinitionsResolver() {
            super(NAME, "ProcedureDefinitions");
        }

        protected String resolve(TemplateContext context) {
            Artifacts artifacts = ProcessorModelTemplateContextType.this.getArtifacts((XtextTemplateContext)context);
            if (artifacts != null && ProcessorModelTemplateContextType.this.dbResolver.isResolveDb((EObject)artifacts)) {
                Map proceduresPresented = ProcessorModelTemplateContextType.this.modelProperty.getModelProcedures((EObject)artifacts);
                List procedures = ProcessorModelTemplateContextType.this.dbResolver.getProcedures((EObject)artifacts);
                return CommonUtils.getProceduresDefinitions((List)procedures, (Map)proceduresPresented);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class TablesDefinitionsResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "tableDefinitions";

        public TablesDefinitionsResolver() {
            super(NAME, "TableDefinitions");
        }

        protected String resolve(TemplateContext context) {
            Artifacts artifacts = ProcessorModelTemplateContextType.this.getArtifacts((XtextTemplateContext)context);
            if (artifacts != null && ProcessorModelTemplateContextType.this.dbResolver.isResolveDb((EObject)artifacts)) {
                Map tablesPresented = ProcessorModelTemplateContextType.this.modelProperty.getModelTables((EObject)artifacts);
                List tables = ProcessorModelTemplateContextType.this.dbResolver.getTables((EObject)artifacts);
                return CommonUtils.getTablesDefinitions((List)tables, (Map)tablesPresented);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }
}

