/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.model.ui.contentassist;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.sqlproc.model.processorModel.AbstractEntity;
import org.sqlproc.model.processorModel.AnnotatedEntity;
import org.sqlproc.model.processorModel.DatabaseProperty;
import org.sqlproc.model.processorModel.DriverMethodOutputAssignement;
import org.sqlproc.model.processorModel.Entity;
import org.sqlproc.model.processorModel.ExportAssignement;
import org.sqlproc.model.processorModel.ImportAssignement;
import org.sqlproc.model.processorModel.InheritanceAssignement;
import org.sqlproc.model.processorModel.ManyToManyAssignement;
import org.sqlproc.model.processorModel.MetagenProperty;
import org.sqlproc.model.processorModel.Package;
import org.sqlproc.model.processorModel.PojoDefinitionModel;
import org.sqlproc.model.processorModel.PojoEntity;
import org.sqlproc.model.processorModel.PojogenProperty;
import org.sqlproc.model.processorModel.Property;
import org.sqlproc.model.processorModel.ShowColumnTypeAssignement;
import org.sqlproc.model.ui.contentassist.AbstractProcessorModelProposalProvider;
import org.sqlproc.plugin.lib.resolver.DbExport;
import org.sqlproc.plugin.lib.resolver.DbImport;
import org.sqlproc.plugin.lib.resolver.DbResolver;

public class ProcessorModelProposalProvider
extends AbstractProcessorModelProposalProvider {
    @Inject
    private DbResolver dbResolver;
    private final ArrayList<String> DEBUG_LEVELS = CollectionLiterals.newArrayList((Object[])new String[]{"DEBUG", "INFO", "FATAL", "ERROR", "WARN", "TRACE"});
    private final ArrayList<String> methods = CollectionLiterals.newArrayList((Object[])new String[]{"toString", "hashCode", "equals", "isDef", "toInit", "enumDef", "enumInit", "index", "procId", "enumIndex"});

    public void addProposalList(List<String> values, final String lexerRule, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor, final String prefix) {
        if (values != null) {
            Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

                public void apply(String value) {
                    IValueConverterService _valueConverter = ProcessorModelProposalProvider.this.getValueConverter();
                    String _elvis = null;
                    _elvis = prefix != null ? prefix : "";
                    String _plus = String.valueOf(_elvis) + value;
                    String proposal = _valueConverter.toString((Object)_plus, lexerRule);
                    ICompletionProposal _createCompletionProposal = ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context);
                    acceptor.accept(_createCompletionProposal);
                }
            };
            IterableExtensions.forEach(values, (Procedures.Procedure1)_function);
        }
    }

    public StringBuilder append(StringBuilder sb, String s) {
        boolean _greaterThan;
        StringBuilder _xblockexpression = null;
        int _length = sb.length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            sb.append(".");
        }
        _xblockexpression = sb.append(s);
        return _xblockexpression;
    }

    public boolean isResolveDb(EObject model) {
        return this.dbResolver.isResolveDb(model);
    }

    public String getClass(PojoDefinitionModel pojo) {
        String _xifexpression = null;
        String _classx = pojo.getClassx();
        boolean _notEquals = !Objects.equal((Object)_classx, null);
        _xifexpression = _notEquals ? pojo.getClassx() : pojo.getClass_();
        return _xifexpression;
    }

    public boolean isPrimitive(Class<?> clazz) {
        boolean _equals = Objects.equal(clazz, null);
        if (_equals) {
            return true;
        }
        boolean _equals_1 = Objects.equal(clazz, String.class);
        if (_equals_1) {
            return true;
        }
        boolean _equals_2 = Objects.equal(clazz, java.util.Date.class);
        if (_equals_2) {
            return true;
        }
        boolean _equals_3 = Objects.equal(clazz, Date.class);
        if (_equals_3) {
            return true;
        }
        boolean _equals_4 = Objects.equal(clazz, Time.class);
        if (_equals_4) {
            return true;
        }
        boolean _equals_5 = Objects.equal(clazz, Timestamp.class);
        if (_equals_5) {
            return true;
        }
        boolean _equals_6 = Objects.equal(clazz, Blob.class);
        if (_equals_6) {
            return true;
        }
        boolean _equals_7 = Objects.equal(clazz, Clob.class);
        if (_equals_7) {
            return true;
        }
        boolean _equals_8 = Objects.equal(clazz, BigDecimal.class);
        if (_equals_8) {
            return true;
        }
        boolean _equals_9 = Objects.equal(clazz, BigInteger.class);
        return _equals_9;
    }

    public void acceptTables(EObject model, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor, final String suffix) {
        List _tables = this.dbResolver.getTables(model);
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                int _indexOf = it.indexOf("$");
                return _indexOf < 0;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_tables, (Functions.Function1)_function);
        Procedures.Procedure1<String> _function_1 = new Procedures.Procedure1<String>(){

            public void apply(String table) {
                IValueConverterService _valueConverter = ProcessorModelProposalProvider.this.getValueConverter();
                String proposal = _valueConverter.toString((Object)table, "IDENT");
                ICompletionProposal _createCompletionProposal = ProcessorModelProposalProvider.this.createCompletionProposal(String.valueOf(proposal) + suffix, context);
                acceptor.accept(_createCompletionProposal);
            }
        };
        IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function_1);
    }

    public void acceptProcedures(EObject model, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        List _procedures = this.dbResolver.getProcedures(model);
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                int _indexOf = it.indexOf("$");
                return _indexOf < 0;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_procedures, (Functions.Function1)_function);
        Procedures.Procedure1<String> _function_1 = new Procedures.Procedure1<String>(){

            public void apply(String table) {
                IValueConverterService _valueConverter = ProcessorModelProposalProvider.this.getValueConverter();
                String proposal = _valueConverter.toString((Object)table, "IDENT");
                ICompletionProposal _createCompletionProposal = ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context);
                acceptor.accept(_createCompletionProposal);
            }
        };
        IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function_1);
    }

    public void acceptFunctions(EObject model, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        List _functions = this.dbResolver.getFunctions(model);
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                int _indexOf = it.indexOf("$");
                return _indexOf < 0;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_functions, (Functions.Function1)_function);
        Procedures.Procedure1<String> _function_1 = new Procedures.Procedure1<String>(){

            public void apply(String table) {
                IValueConverterService _valueConverter = ProcessorModelProposalProvider.this.getValueConverter();
                String proposal = _valueConverter.toString((Object)table, "IDENT");
                ICompletionProposal _createCompletionProposal = ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context);
                acceptor.accept(_createCompletionProposal);
            }
        };
        IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function_1);
    }

    public void acceptCheckConstraints(EObject model, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        List _checkConstraints = this.dbResolver.getCheckConstraints(model);
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                int _indexOf = it.indexOf("$");
                return _indexOf < 0;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_checkConstraints, (Functions.Function1)_function);
        Procedures.Procedure1<String> _function_1 = new Procedures.Procedure1<String>(){

            public void apply(String table) {
                IValueConverterService _valueConverter = ProcessorModelProposalProvider.this.getValueConverter();
                String proposal = _valueConverter.toString((Object)table, "IDENT");
                ICompletionProposal _createCompletionProposal = ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context);
                acceptor.accept(_createCompletionProposal);
            }
        };
        IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function_1);
    }

    public void acceptSequences(EObject model, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        List _sequences = this.dbResolver.getSequences(model);
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                int _indexOf = it.indexOf("$");
                return _indexOf < 0;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_sequences, (Functions.Function1)_function);
        Procedures.Procedure1<String> _function_1 = new Procedures.Procedure1<String>(){

            public void apply(String table) {
                IValueConverterService _valueConverter = ProcessorModelProposalProvider.this.getValueConverter();
                String proposal = _valueConverter.toString((Object)table, "IDENT");
                ICompletionProposal _createCompletionProposal = ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context);
                acceptor.accept(_createCompletionProposal);
            }
        };
        IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function_1);
    }

    public void acceptColumns(List<String> columns, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor, final String prefix, final String suffix) {
        Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

            public void apply(String column) {
                IValueConverterService _valueConverter = ProcessorModelProposalProvider.this.getValueConverter();
                String proposal = _valueConverter.toString((Object)column, "IDENT");
                String _xifexpression = null;
                boolean _notEquals = !Objects.equal((Object)prefix, null);
                _xifexpression = _notEquals ? String.valueOf(prefix) + "." + proposal : proposal;
                String completion = _xifexpression;
                String _xifexpression_1 = null;
                boolean _notEquals_1 = !Objects.equal((Object)suffix, null);
                _xifexpression_1 = _notEquals_1 ? String.valueOf(completion) + suffix : completion;
                completion = _xifexpression_1;
                ICompletionProposal _createCompletionProposal = ProcessorModelProposalProvider.this.createCompletionProposal(completion, context);
                acceptor.accept(_createCompletionProposal);
            }
        };
        IterableExtensions.forEach(columns, (Procedures.Procedure1)_function);
    }

    @Override
    public void completeTableDefinitionModel_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeTableDefinitionModel_Table(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeProcedureDefinitionModel_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeProcedureDefinitionModel_Table(model, assignment, context, acceptor);
            return;
        }
        this.acceptProcedures(model, context, acceptor);
    }

    @Override
    public void completeFunctionDefinitionModel_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeFunctionDefinitionModel_Table(model, assignment, context, acceptor);
            return;
        }
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completePojogenProperty_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptCheckConstraints(model, context, acceptor);
    }

    @Override
    public void completePojogenProperty_DbProcedure(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbProcedure(model, assignment, context, acceptor);
            return;
        }
        this.acceptProcedures(model, context, acceptor);
    }

    @Override
    public void completePojogenProperty_DbFunction(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbFunction(model, assignment, context, acceptor);
            return;
        }
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeTableAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeTableAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "->");
    }

    @Override
    public void completeInheritanceAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeInheritanceAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "->");
    }

    @Override
    public void completePojogenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completePojogenProperty_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeMetagenProperty_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completePojogenProperty_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        boolean _not;
        boolean _or = false;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            _or = true;
        } else {
            boolean bl2 = _or = !(model instanceof PojogenProperty) && !(model instanceof Property);
        }
        if (_or) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl3 = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, null);
        }
    }

    @Override
    public void completePojogenProperty_DbColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        boolean _not;
        boolean _or = false;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            _or = true;
        } else {
            boolean bl2 = _or = !(model instanceof PojogenProperty) && !(model instanceof Property);
        }
        if (_or) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl3 = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, null);
        }
    }

    @Override
    public void completeImplementsAssignement_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeImplementsAssignement_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeExtendsAssignement_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeExtendsAssignement_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeImplementsAssignement_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeImplementsAssignement_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeExtendsAssignement_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeExtendsAssignement_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeImplementsAssignementGenerics_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeImplementsAssignementGenerics_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeExtendsAssignementGenerics_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeExtendsAssignementGenerics_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeImplementsAssignementGenerics_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeImplementsAssignementGenerics_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeExtendsAssignementGenerics_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeExtendsAssignementGenerics_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeColumnTypeAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        boolean _not;
        boolean _or = false;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            _or = true;
        } else {
            boolean bl2 = _or = !(model instanceof PojogenProperty) && !(model instanceof Property);
        }
        if (_or) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl3 = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, "->");
        } else {
            boolean _notEquals_1;
            String _dbProcedure = prop.getDbProcedure();
            boolean bl4 = _notEquals_1 = !Objects.equal((Object)_dbProcedure, null);
            if (_notEquals_1) {
                String _dbProcedure_1 = prop.getDbProcedure();
                List _procColumns = this.dbResolver.getProcColumns(model, _dbProcedure_1);
                this.acceptColumns(_procColumns, context, acceptor, null, "->");
            } else {
                boolean _notEquals_2;
                String _dbFunction = prop.getDbFunction();
                boolean bl5 = _notEquals_2 = !Objects.equal((Object)_dbFunction, null);
                if (_notEquals_2) {
                    String _dbFunction_1 = prop.getDbFunction();
                    List _funColumns = this.dbResolver.getFunColumns(model, _dbFunction_1);
                    this.acceptColumns(_funColumns, context, acceptor, null, "->");
                }
            }
        }
    }

    @Override
    public void completeColumnAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        boolean _not;
        boolean _or = false;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            _or = true;
        } else {
            boolean bl2 = _or = !(model instanceof PojogenProperty) && !(model instanceof Property);
        }
        if (_or) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl3 = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, "->");
            String _dbTable_2 = prop.getDbTable();
            List _checkColumns = this.dbResolver.getCheckColumns(model, _dbTable_2);
            this.acceptColumns(_checkColumns, context, acceptor, null, "->");
        }
    }

    @Override
    public void completeImportAssignement_PkTable(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        String _dbColumn;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _or = false;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            _or = true;
        } else {
            boolean bl2 = _or = !(model instanceof ImportAssignement);
        }
        if (_or) {
            super.completeImportAssignement_PkTable(model, assignment, context, acceptor);
            return;
        }
        final ImportAssignement imp = (ImportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        boolean _and = false;
        String _dbTable = prop.getDbTable();
        boolean bl3 = _notEquals = !Objects.equal((Object)_dbTable, null);
        _and = !_notEquals ? false : (_notEquals_1 = !Objects.equal((Object)(_dbColumn = imp.getDbColumn()), null));
        if (_and) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)"create-many-to-one", (Object)_name);
            if (_equals) {
                this.acceptTables(model, context, acceptor, "");
            } else {
                String _dbTable_1 = prop.getDbTable();
                List _dbImports = this.dbResolver.getDbImports(model, _dbTable_1);
                Procedures.Procedure1<DbImport> _function = new Procedures.Procedure1<DbImport>(){

                    public void apply(DbImport dbImport) {
                        boolean _notEquals;
                        boolean _and = false;
                        String _fkColumn = dbImport.getFkColumn();
                        boolean bl = _notEquals = !Objects.equal((Object)_fkColumn, null);
                        if (!_notEquals) {
                            _and = false;
                        } else {
                            boolean _equals;
                            String _fkColumn_1 = dbImport.getFkColumn();
                            String _dbColumn = imp.getDbColumn();
                            _and = _equals = _fkColumn_1.equals(_dbColumn);
                        }
                        if (_and) {
                            IValueConverterService _valueConverter = ProcessorModelProposalProvider.this.getValueConverter();
                            String _pkTable = dbImport.getPkTable();
                            String proposal = _valueConverter.toString((Object)_pkTable, "IDENT");
                            ICompletionProposal _createCompletionProposal = ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context);
                            acceptor.accept(_createCompletionProposal);
                        }
                    }
                };
                IterableExtensions.forEach((Iterable)_dbImports, (Procedures.Procedure1)_function);
            }
        }
    }

    @Override
    public void completeImportAssignement_PkColumn(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        String _pkTable;
        boolean _notEquals_2;
        String _dbColumn;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _or = false;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            _or = true;
        } else {
            boolean bl2 = _or = !(model instanceof ImportAssignement);
        }
        if (_or) {
            super.completeImportAssignement_PkColumn(model, assignment, context, acceptor);
            return;
        }
        final ImportAssignement imp = (ImportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        boolean _and = false;
        boolean _and_1 = false;
        String _dbTable = prop.getDbTable();
        boolean bl3 = _notEquals = !Objects.equal((Object)_dbTable, null);
        _and_1 = !_notEquals ? false : (_notEquals_1 = !Objects.equal((Object)(_dbColumn = imp.getDbColumn()), null));
        _and = !_and_1 ? false : (_notEquals_2 = !Objects.equal((Object)(_pkTable = imp.getPkTable()), null));
        if (_and) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)"create-many-to-one", (Object)_name);
            if (_equals) {
                String _pkTable_1 = imp.getPkTable();
                List _columns = this.dbResolver.getColumns(model, _pkTable_1);
                this.acceptColumns(_columns, context, acceptor, null, null);
            } else {
                String _dbTable_1 = prop.getDbTable();
                List _dbImports = this.dbResolver.getDbImports(model, _dbTable_1);
                Procedures.Procedure1<DbImport> _function = new Procedures.Procedure1<DbImport>(){

                    public void apply(DbImport dbImport) {
                        boolean _notEquals;
                        boolean _and = false;
                        String _fkColumn = dbImport.getFkColumn();
                        boolean bl = _notEquals = !Objects.equal((Object)_fkColumn, null);
                        if (!_notEquals) {
                            _and = false;
                        } else {
                            boolean _equals;
                            String _fkColumn_1 = dbImport.getFkColumn();
                            String _dbColumn = imp.getDbColumn();
                            _and = _equals = _fkColumn_1.equals(_dbColumn);
                        }
                        if (_and) {
                            boolean _notEquals_1;
                            boolean _and_1 = false;
                            String _pkTable = dbImport.getPkTable();
                            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_pkTable, null);
                            if (!_notEquals_1) {
                                _and_1 = false;
                            } else {
                                boolean _equals_1;
                                String _pkTable_1 = dbImport.getPkTable();
                                String _pkTable_2 = imp.getPkTable();
                                _and_1 = _equals_1 = _pkTable_1.equals(_pkTable_2);
                            }
                            if (_and_1) {
                                IValueConverterService _valueConverter = ProcessorModelProposalProvider.this.getValueConverter();
                                String _pkColumn = dbImport.getPkColumn();
                                String proposal = _valueConverter.toString((Object)_pkColumn, "IDENT");
                                ICompletionProposal _createCompletionProposal = ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context);
                                acceptor.accept(_createCompletionProposal);
                            }
                        }
                    }
                };
                IterableExtensions.forEach((Iterable)_dbImports, (Procedures.Procedure1)_function);
            }
        }
    }

    @Override
    public void completeImportAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        boolean _not;
        boolean _or = false;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            _or = true;
        } else {
            boolean bl2 = _or = !(model instanceof PojogenProperty) && !(model instanceof Property);
        }
        if (_or) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl3 = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, "->");
        }
    }

    @Override
    public void completeExportAssignement_FkTable(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        String _dbColumn;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _or = false;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            _or = true;
        } else {
            boolean bl2 = _or = !(model instanceof ExportAssignement);
        }
        if (_or) {
            super.completeExportAssignement_FkTable(model, assignment, context, acceptor);
            return;
        }
        final ExportAssignement exp = (ExportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        boolean _and = false;
        String _dbTable = prop.getDbTable();
        boolean bl3 = _notEquals = !Objects.equal((Object)_dbTable, null);
        _and = !_notEquals ? false : (_notEquals_1 = !Objects.equal((Object)(_dbColumn = exp.getDbColumn()), null));
        if (_and) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)"create-one-to-many", (Object)_name);
            if (_equals) {
                this.acceptTables(model, context, acceptor, "");
            } else {
                String _dbTable_1 = prop.getDbTable();
                List _dbExports = this.dbResolver.getDbExports(model, _dbTable_1);
                Procedures.Procedure1<DbExport> _function = new Procedures.Procedure1<DbExport>(){

                    public void apply(DbExport dbExport) {
                        boolean _notEquals;
                        boolean _and = false;
                        String _pkColumn = dbExport.getPkColumn();
                        boolean bl = _notEquals = !Objects.equal((Object)_pkColumn, null);
                        if (!_notEquals) {
                            _and = false;
                        } else {
                            boolean _equals;
                            String _pkColumn_1 = dbExport.getPkColumn();
                            String _dbColumn = exp.getDbColumn();
                            _and = _equals = _pkColumn_1.equals(_dbColumn);
                        }
                        if (_and) {
                            IValueConverterService _valueConverter = ProcessorModelProposalProvider.this.getValueConverter();
                            String _fkTable = dbExport.getFkTable();
                            String proposal = _valueConverter.toString((Object)_fkTable, "IDENT");
                            ICompletionProposal _createCompletionProposal = ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context);
                            acceptor.accept(_createCompletionProposal);
                        }
                    }
                };
                IterableExtensions.forEach((Iterable)_dbExports, (Procedures.Procedure1)_function);
            }
        }
    }

    @Override
    public void completeExportAssignement_FkColumn(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        String _fkTable;
        boolean _notEquals_2;
        String _dbColumn;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _or = false;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            _or = true;
        } else {
            boolean bl2 = _or = !(model instanceof ExportAssignement);
        }
        if (_or) {
            super.completeExportAssignement_FkColumn(model, assignment, context, acceptor);
            return;
        }
        final ExportAssignement exp = (ExportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        boolean _and = false;
        boolean _and_1 = false;
        String _dbTable = prop.getDbTable();
        boolean bl3 = _notEquals = !Objects.equal((Object)_dbTable, null);
        _and_1 = !_notEquals ? false : (_notEquals_1 = !Objects.equal((Object)(_dbColumn = exp.getDbColumn()), null));
        _and = !_and_1 ? false : (_notEquals_2 = !Objects.equal((Object)(_fkTable = exp.getFkTable()), null));
        if (_and) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)"create-one-to-many", (Object)_name);
            if (_equals) {
                String _fkTable_1 = exp.getFkTable();
                List _columns = this.dbResolver.getColumns(model, _fkTable_1);
                this.acceptColumns(_columns, context, acceptor, null, null);
            } else {
                String _dbTable_1 = prop.getDbTable();
                List _dbExports = this.dbResolver.getDbExports(model, _dbTable_1);
                Procedures.Procedure1<DbExport> _function = new Procedures.Procedure1<DbExport>(){

                    public void apply(DbExport dbExport) {
                        boolean _notEquals;
                        boolean _and = false;
                        String _pkColumn = dbExport.getPkColumn();
                        boolean bl = _notEquals = !Objects.equal((Object)_pkColumn, null);
                        if (!_notEquals) {
                            _and = false;
                        } else {
                            boolean _equals;
                            String _pkColumn_1 = dbExport.getPkColumn();
                            String _dbColumn = exp.getDbColumn();
                            _and = _equals = _pkColumn_1.equals(_dbColumn);
                        }
                        if (_and) {
                            boolean _notEquals_1;
                            boolean _and_1 = false;
                            String _fkTable = dbExport.getFkTable();
                            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_fkTable, null);
                            if (!_notEquals_1) {
                                _and_1 = false;
                            } else {
                                boolean _equals_1;
                                String _fkTable_1 = dbExport.getFkTable();
                                String _fkTable_2 = exp.getFkTable();
                                _and_1 = _equals_1 = _fkTable_1.equals(_fkTable_2);
                            }
                            if (_and_1) {
                                IValueConverterService _valueConverter = ProcessorModelProposalProvider.this.getValueConverter();
                                String _fkColumn = dbExport.getFkColumn();
                                String proposal = _valueConverter.toString((Object)_fkColumn, "IDENT");
                                ICompletionProposal _createCompletionProposal = ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context);
                                acceptor.accept(_createCompletionProposal);
                            }
                        }
                    }
                };
                IterableExtensions.forEach((Iterable)_dbExports, (Procedures.Procedure1)_function);
            }
        }
    }

    @Override
    public void completeExportAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        boolean _not;
        boolean _or = false;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            _or = true;
        } else {
            boolean bl2 = _or = !(model instanceof PojogenProperty) && !(model instanceof Property);
        }
        if (_or) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl3 = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, "->");
        }
    }

    @Override
    public void completeManyToManyAssignement_PkColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        boolean _not;
        boolean _or = false;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            _or = true;
        } else {
            boolean bl2 = _or = !(model instanceof PojogenProperty) && !(model instanceof Property);
        }
        if (_or) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl3 = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, "->");
        }
    }

    @Override
    public void completeManyToManyAssignement_PkTable(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        String _pkColumn;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _or = false;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            _or = true;
        } else {
            boolean bl2 = _or = !(model instanceof ManyToManyAssignement);
        }
        if (_or) {
            super.completeManyToManyAssignement_PkTable(model, assignment, context, acceptor);
            return;
        }
        final ManyToManyAssignement many2 = (ManyToManyAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        boolean _and = false;
        String _dbTable = prop.getDbTable();
        boolean bl3 = _notEquals = !Objects.equal((Object)_dbTable, null);
        _and = !_notEquals ? false : (_notEquals_1 = !Objects.equal((Object)(_pkColumn = many2.getPkColumn()), null));
        if (_and) {
            String _dbTable_1 = prop.getDbTable();
            List _dbImports = this.dbResolver.getDbImports(model, _dbTable_1);
            Procedures.Procedure1<DbImport> _function = new Procedures.Procedure1<DbImport>(){

                public void apply(DbImport dbImport) {
                    boolean _notEquals;
                    boolean _and = false;
                    String _pkColumn = dbImport.getPkColumn();
                    boolean bl = _notEquals = !Objects.equal((Object)_pkColumn, null);
                    if (!_notEquals) {
                        _and = false;
                    } else {
                        boolean _equals;
                        String _pkColumn_1 = dbImport.getPkColumn();
                        String _pkColumn_2 = many2.getPkColumn();
                        _and = _equals = _pkColumn_1.equals(_pkColumn_2);
                    }
                    if (_and) {
                        IValueConverterService _valueConverter = ProcessorModelProposalProvider.this.getValueConverter();
                        String _pkTable = dbImport.getPkTable();
                        String proposal = _valueConverter.toString((Object)_pkTable, "IDENT");
                        ICompletionProposal _createCompletionProposal = ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context);
                        acceptor.accept(_createCompletionProposal);
                    }
                }
            };
            IterableExtensions.forEach((Iterable)_dbImports, (Procedures.Procedure1)_function);
        }
    }

    @Override
    public void completeInheritanceAssignement_DbColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        boolean _not;
        boolean _or = false;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            _or = true;
        } else {
            boolean bl2 = _or = !(model instanceof InheritanceAssignement);
        }
        if (_or) {
            super.completeInheritanceAssignement_DbColumns(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        String _dbTable = prop.getDbTable();
        boolean bl3 = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, null);
        }
    }

    @Override
    public void completePojogenProperty_Methods(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        if (!(model instanceof PojogenProperty)) {
            super.completePojogenProperty_Methods(model, assignment, context, acceptor);
            return;
        }
        Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

            public void apply(String method) {
                IValueConverterService _valueConverter = ProcessorModelProposalProvider.this.getValueConverter();
                String proposal = _valueConverter.toString((Object)method, "IDENT");
                ICompletionProposal _createCompletionProposal = ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context);
                acceptor.accept(_createCompletionProposal);
            }
        };
        IterableExtensions.forEach(this.methods, (Procedures.Procedure1)_function);
    }

    @Override
    public void completeShowColumnTypeAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        boolean _not;
        boolean _or = false;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            _or = true;
        } else {
            boolean bl2 = _or = !(model instanceof PojogenProperty) && !(model instanceof Property);
        }
        if (_or) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getPojogen() : (PojogenProperty)model;
        PojogenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        boolean bl3 = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, "->");
        } else {
            boolean _notEquals_1;
            String _dbProcedure = prop.getDbProcedure();
            boolean bl4 = _notEquals_1 = !Objects.equal((Object)_dbProcedure, null);
            if (_notEquals_1) {
                String _dbProcedure_1 = prop.getDbProcedure();
                List _procColumns = this.dbResolver.getProcColumns(model, _dbProcedure_1);
                this.acceptColumns(_procColumns, context, acceptor, null, "->");
            } else {
                boolean _notEquals_2;
                String _dbFunction = prop.getDbFunction();
                boolean bl5 = _notEquals_2 = !Objects.equal((Object)_dbFunction, null);
                if (_notEquals_2) {
                    String _dbFunction_1 = prop.getDbFunction();
                    List _funColumns = this.dbResolver.getFunColumns(model, _dbFunction_1);
                    this.acceptColumns(_funColumns, context, acceptor, null, "->");
                }
            }
        }
    }

    @Override
    public void completeShowColumnTypeAssignement_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals_3;
        boolean _notEquals;
        boolean _not;
        boolean _or = false;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            _or = true;
        } else {
            boolean bl2 = _or = !(model instanceof ShowColumnTypeAssignement);
        }
        if (_or) {
            super.completeShowColumnTypeAssignement_Type(model, assignment, context, acceptor);
            return;
        }
        ShowColumnTypeAssignement prop = (ShowColumnTypeAssignement)model;
        PojogenProperty prop2 = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        String type = null;
        String _dbTable = prop2.getDbTable();
        boolean bl3 = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _type;
            String _dbTable_1 = prop2.getDbTable();
            String _dbColumn = prop.getDbColumn();
            type = _type = this.dbResolver.getType(model, _dbTable_1, _dbColumn);
        } else {
            boolean _notEquals_1;
            String _dbProcedure = prop2.getDbProcedure();
            boolean bl4 = _notEquals_1 = !Objects.equal((Object)_dbProcedure, null);
            if (_notEquals_1) {
                String _type_1;
                String _dbProcedure_1 = prop2.getDbProcedure();
                String _dbColumn_1 = prop.getDbColumn();
                type = _type_1 = this.dbResolver.getType(model, _dbProcedure_1, _dbColumn_1);
            } else {
                boolean _notEquals_2;
                String _dbFunction = prop2.getDbFunction();
                boolean bl5 = _notEquals_2 = !Objects.equal((Object)_dbFunction, null);
                if (_notEquals_2) {
                    String _type_2;
                    String _dbFunction_1 = prop2.getDbFunction();
                    String _dbColumn_2 = prop.getDbColumn();
                    type = _type_2 = this.dbResolver.getType(model, _dbFunction_1, _dbColumn_2);
                }
            }
        }
        boolean bl6 = _notEquals_3 = !Objects.equal((Object)type, null);
        if (_notEquals_3) {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString((Object)("\"" + type + "\""), "PropertyValue");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
        }
    }

    @Override
    public void completeJoinTableAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeJoinTableAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "->");
    }

    @Override
    public void completeJoinTableAssignement_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeJoinTableAssignement_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    public Set<PojoEntity> listEntities(final ResourceSet resourceSet, IScope scope) {
        Comparator<PojoEntity> _function = new Comparator<PojoEntity>(){

            @Override
            public int compare(PojoEntity o1, PojoEntity o2) {
                String _name = o1.getName();
                String _name_1 = o2.getName();
                return _name.compareTo(_name_1);
            }
        };
        final TreeSet result = CollectionLiterals.newTreeSet((Comparator)_function, (Object[])new PojoEntity[0]);
        Iterable _allElements = scope.getAllElements();
        Procedures.Procedure1<IEObjectDescription> _function_1 = new Procedures.Procedure1<IEObjectDescription>(){

            public void apply(IEObjectDescription description) {
                URI _eObjectURI = description.getEObjectURI();
                EObject _eObject = resourceSet.getEObject(_eObjectURI, true);
                Package packageDeclaration = (Package)_eObject;
                EList _elements = packageDeclaration.getElements();
                Procedures.Procedure1<AbstractEntity> _function = new Procedures.Procedure1<AbstractEntity>(){

                    public void apply(AbstractEntity aEntity) {
                        AnnotatedEntity ae;
                        Entity _entity;
                        if (aEntity instanceof AnnotatedEntity && (_entity = (ae = (AnnotatedEntity)aEntity).getEntity()) instanceof PojoEntity) {
                            Entity _entity_1 = ae.getEntity();
                            result.add((PojoEntity)_entity_1);
                        }
                    }
                };
                IterableExtensions.forEach((Iterable)_elements, (Procedures.Procedure1)_function);
            }
        };
        IterableExtensions.forEach((Iterable)_allElements, (Procedures.Procedure1)_function_1);
        return result;
    }

    @Override
    public void completeMetagenProperty_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeMetagenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeMetagenProperty_DbFunction(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbFunction(model, assignment, context, acceptor);
            return;
        }
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeMetagenProperty_DbProcedure(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbProcedure(model, assignment, context, acceptor);
            return;
        }
        this.acceptProcedures(model, context, acceptor);
    }

    @Override
    public void completeMetagenProperty_Sequence(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_Sequence(model, assignment, context, acceptor);
            return;
        }
        this.acceptSequences(model, context, acceptor);
    }

    @Override
    public void completeMetaTypeAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _or = false;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            _or = true;
        } else {
            boolean bl2 = _or = !(model instanceof MetagenProperty) && !(model instanceof Property);
        }
        if (_or) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        MetagenProperty _xifexpression = null;
        _xifexpression = model instanceof Property ? ((Property)model).getMetagen() : (MetagenProperty)model;
        MetagenProperty prop = _xifexpression;
        String _dbTable = prop.getDbTable();
        List _columns = this.dbResolver.getColumns(model, _dbTable);
        this.acceptColumns(_columns, context, acceptor, null, null);
    }

    @Override
    public void completeDaogenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDaogenProperty_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeMetagenProperty_DbColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _or = false;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            _or = true;
        } else {
            boolean bl2 = _or = !(model instanceof MetagenProperty);
        }
        if (_or) {
            super.completeMetagenProperty_DbColumns(model, assignment, context, acceptor);
            return;
        }
        MetagenProperty prop = (MetagenProperty)model;
        String _dbTable = prop.getDbTable();
        List _columns = this.dbResolver.getColumns(model, _dbTable);
        this.acceptColumns(_columns, context, acceptor, null, null);
    }

    @Override
    public void completeDatabaseMetaInfoAssignement_DbMetaInfo(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDatabaseMetaInfoAssignement_DbMetaInfo(model, assignment, context, acceptor);
            return;
        }
        String dbMetaInfo = this.dbResolver.getDbMetaInfo(model);
        boolean bl2 = _notEquals = !Objects.equal((Object)dbMetaInfo, null);
        if (_notEquals) {
            dbMetaInfo = "\"" + dbMetaInfo + "\"";
        }
        IValueConverterService _valueConverter = this.getValueConverter();
        String proposal = _valueConverter.toString((Object)dbMetaInfo, "PropertyValue");
        ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
        acceptor.accept(_createCompletionProposal);
    }

    @Override
    public void completeDriverMetaInfoAssignement_DbDriverInfo(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDriverMetaInfoAssignement_DbDriverInfo(model, assignment, context, acceptor);
            return;
        }
        String dbDriverInfo = this.dbResolver.getDbDriverInfo(model);
        boolean bl2 = _notEquals = !Objects.equal((Object)dbDriverInfo, null);
        if (_notEquals) {
            dbDriverInfo = "\"" + dbDriverInfo + "\"";
        }
        IValueConverterService _valueConverter = this.getValueConverter();
        String proposal = _valueConverter.toString((Object)dbDriverInfo, "PropertyValue");
        ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
        acceptor.accept(_createCompletionProposal);
    }

    @Override
    public void completeDriverMethodOutputAssignement_DriverMethod(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _or = false;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            _or = true;
        } else {
            boolean bl2 = _or = !(model instanceof DatabaseProperty);
        }
        if (_or) {
            super.completeDriverMethodOutputAssignement_DriverMethod(model, assignment, context, acceptor);
            return;
        }
        Set _driverMethods = this.dbResolver.getDriverMethods(model);
        Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

            public void apply(String driverMetod) {
                IValueConverterService _valueConverter = ProcessorModelProposalProvider.this.getValueConverter();
                String proposal = _valueConverter.toString((Object)driverMetod, "PropertyValue");
                ICompletionProposal _createCompletionProposal = ProcessorModelProposalProvider.this.createCompletionProposal(String.valueOf(proposal) + "->", context);
                acceptor.accept(_createCompletionProposal);
            }
        };
        IterableExtensions.forEach((Iterable)_driverMethods, (Procedures.Procedure1)_function);
    }

    @Override
    public void completeDriverMethodOutputAssignement_CallOutput(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _or = false;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            _or = true;
        } else {
            boolean bl2 = _or = !(model instanceof DriverMethodOutputAssignement);
        }
        if (_or) {
            super.completeDriverMethodOutputAssignement_CallOutput(model, assignment, context, acceptor);
            return;
        }
        DriverMethodOutputAssignement prop = (DriverMethodOutputAssignement)model;
        Object _elvis = null;
        String _driverMethod = prop.getDriverMethod();
        Object _driverMethodOutput = this.dbResolver.getDriverMethodOutput(model, _driverMethod);
        _elvis = _driverMethodOutput != null ? _driverMethodOutput : "null";
        Object methodCallOutput = _elvis;
        IValueConverterService _valueConverter = this.getValueConverter();
        String proposal = _valueConverter.toString((Object)("\"" + methodCallOutput + "\""), "PropertyValue");
        ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
        acceptor.accept(_createCompletionProposal);
    }

    @Override
    public void completeDatabaseTypeAssignement_DbType(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDatabaseTypeAssignement_DbType(model, assignment, context, acceptor);
            return;
        }
        String dbMetaInfo = this.dbResolver.getDbMetaInfo(model);
        DbResolver.DbType[] _fromDbMetaInfo = DbResolver.DbType.fromDbMetaInfo((String)dbMetaInfo);
        Procedures.Procedure1<DbResolver.DbType> _function = new Procedures.Procedure1<DbResolver.DbType>(){

            public void apply(DbResolver.DbType dbType) {
                IValueConverterService _valueConverter = ProcessorModelProposalProvider.this.getValueConverter();
                String _value = dbType.getValue();
                String proposal = _valueConverter.toString((Object)_value, "PropertyValue");
                ICompletionProposal _createCompletionProposal = ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context);
                acceptor.accept(_createCompletionProposal);
            }
        };
        IterableExtensions.forEach((Iterable)((Iterable)Conversions.doWrapArray((Object)_fromDbMetaInfo)), (Procedures.Procedure1)_function);
    }

    @Override
    public void completeDatabaseCatalogAssignement_DbCatalog(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDatabaseCatalogAssignement_DbCatalog(model, assignment, context, acceptor);
            return;
        }
        List _catalogs = this.dbResolver.getCatalogs(model);
        Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

            public void apply(String catalog) {
                IValueConverterService _valueConverter = ProcessorModelProposalProvider.this.getValueConverter();
                String proposal = _valueConverter.toString((Object)catalog, "IDENT");
                ICompletionProposal _createCompletionProposal = ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context);
                acceptor.accept(_createCompletionProposal);
            }
        };
        IterableExtensions.forEach((Iterable)_catalogs, (Procedures.Procedure1)_function);
    }

    @Override
    public void completeDatabaseSchemaAssignement_DbSchema(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDatabaseSchemaAssignement_DbSchema(model, assignment, context, acceptor);
            return;
        }
        List _schemas = this.dbResolver.getSchemas(model);
        Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

            public void apply(String schema) {
                IValueConverterService _valueConverter = ProcessorModelProposalProvider.this.getValueConverter();
                String proposal = _valueConverter.toString((Object)schema, "IDENT");
                ICompletionProposal _createCompletionProposal = ProcessorModelProposalProvider.this.createCompletionProposal(proposal, context);
                acceptor.accept(_createCompletionProposal);
            }
        };
        IterableExtensions.forEach((Iterable)_schemas, (Procedures.Procedure1)_function);
    }

    @Override
    public void completeDebugLevelAssignement_Debug(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(this.DEBUG_LEVELS, "DEBUG_LEVELS", context, acceptor, null);
    }

    @Override
    public void completeProcedurePojoAssignement_DbProcedure(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeProcedurePojoAssignement_DbProcedure(model, assignment, context, acceptor);
            return;
        }
        this.acceptProcedures(model, context, acceptor);
    }

    @Override
    public void completeFunctionPojoAssignement_DbFunction(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeFunctionPojoAssignement_DbFunction(model, assignment, context, acceptor);
            return;
        }
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completePojogenProperty_DbCheckConstraints(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbCheckConstraints(model, assignment, context, acceptor);
            return;
        }
        this.acceptCheckConstraints(model, context, acceptor);
    }
}

