/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.plugin.lib.util;

import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.LazyStringInputStream;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class MainUtils {
    public static final int OK = 0;
    public static final int ERROR = 1;
    public static final int REFERENCE_ERROR = 2;
    public static final String REFERENCE_MSG = "Couldn't resolve reference to JvmType";

    public static int isValid(Resource resource, Set<String> failedReferences, IResourceValidator validator) throws IOException {
        int result = 0;
        resource.load(null);
        List list = validator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
        if (!list.isEmpty()) {
            for (Issue issue : list) {
                String msg = issue.toString();
                System.err.println(msg);
                if (issue.getSeverity() != Severity.ERROR) continue;
                if (msg.indexOf(REFERENCE_MSG) < 0) {
                    result = 1;
                    continue;
                }
                if (result == 0) {
                    result = 2;
                }
                if (failedReferences == null) continue;
                int ix = (msg = msg.substring(REFERENCE_MSG.length(), msg.length())).indexOf("'");
                if (ix >= 0) {
                    msg = msg.substring(ix + 1, msg.length());
                }
                if ((ix = msg.indexOf("'")) >= 0) {
                    msg = msg.substring(0, ix);
                }
                failedReferences.add(msg);
            }
        }
        return result;
    }

    public static String loadResourceToString(Resource resource) throws IOException {
        resource.load(null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        resource.save((OutputStream)baos, null);
        return baos.toString();
    }

    public static String handleResourceReferences(Resource resource, Set<String> failedReferences) throws IOException {
        String content = MainUtils.loadResourceToString(resource);
        for (String ref : failedReferences) {
            content = content.replaceAll(ref, "::" + ref);
        }
        content = content.replaceAll("::::", "::");
        content = content.replaceAll("::::", "::");
        content = content.replaceAll("::::", "::");
        return content;
    }

    public static Resource reloadResourceFromString(String content, ResourceSet resourceSet, IResourceFactory resourceFactory, String suffix) throws IOException {
        LazyStringInputStream is = new LazyStringInputStream(content);
        Resource resource = resourceFactory.createResource(MainUtils.computeUnusedUri(resourceSet, suffix));
        resourceSet.getResources().add((Object)resource);
        resource.load((InputStream)is, null);
        return resource;
    }

    public static URI computeUnusedUri(ResourceSet resourceSet, String suffix) {
        String name = "__synthetic";
        int i = 0;
        while (i < Integer.MAX_VALUE) {
            URI syntheticUri = URI.createURI((String)(String.valueOf(name) + i + "." + suffix));
            if (resourceSet.getResource(syntheticUri, false) == null) {
                return syntheticUri;
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    public static String getFile(String source, String file) {
        if (file.startsWith(File.separator)) {
            return file;
        }
        return String.valueOf(source) + file;
    }

    public static String loadDdl(String source, String ddl) throws IOException {
        if (ddl != null) {
            File file = new File(MainUtils.getFile(source, ddl));
            return new String(Files.toByteArray((File)file));
        }
        return null;
    }
}

