/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.sqlproc.model.processorModel.AnnotatedEntity;
import org.sqlproc.model.processorModel.AnnotatedFeature;
import org.sqlproc.model.processorModel.Annotation;
import org.sqlproc.model.processorModel.AnnotationDirective;
import org.sqlproc.model.processorModel.AnnotationDirectiveAttribute;
import org.sqlproc.model.processorModel.AnnotationDirectiveConflict;
import org.sqlproc.model.processorModel.AnnotationDirectiveConstructor;
import org.sqlproc.model.processorModel.AnnotationDirectiveGetter;
import org.sqlproc.model.processorModel.AnnotationDirectiveSetter;
import org.sqlproc.model.processorModel.AnnotationDirectiveStandard;
import org.sqlproc.model.processorModel.AnnotationDirectiveStatic;
import org.sqlproc.model.processorModel.DaoEntity;
import org.sqlproc.model.processorModel.Entity;
import org.sqlproc.model.processorModel.EnumEntity;
import org.sqlproc.model.processorModel.PojoEntity;
import org.sqlproc.plugin.lib.util.CommonUtils;

public class Annotations {
    protected String INDENT = "  ";
    protected String NL = "\n";
    protected String NLINDENT = String.valueOf(this.NL) + this.INDENT;
    Map<String, List<XAnnotation>> entityAnnotations = new HashMap<String, List<XAnnotation>>();
    Map<String, List<XAnnotation>> constructorAnnotations = new HashMap<String, List<XAnnotation>>();
    Map<String, List<XAnnotation>> staticAnnotations = new HashMap<String, List<XAnnotation>>();
    Map<String, List<XAnnotation>> conflictAnnotations = new HashMap<String, List<XAnnotation>>();
    Map<String, Map<String, List<XAnnotation>>> setterAnnotations = new HashMap<String, Map<String, List<XAnnotation>>>();
    Map<String, Map<String, List<XAnnotation>>> getterAnnotations = new HashMap<String, Map<String, List<XAnnotation>>>();
    Map<String, Map<String, List<XAnnotation>>> attributeAnnotations = new HashMap<String, Map<String, List<XAnnotation>>>();
    Map<String, Map<String, List<XAnnotation>>> procedureAnnotations = new HashMap<String, Map<String, List<XAnnotation>>>();

    public Annotations(String indent, String nl) {
        this.INDENT = indent;
        this.NLINDENT = String.valueOf(nl) + indent;
        this.NL = nl;
    }

    public void addAnnotation(String pojoName, XAnnotation annotation, Map<String, List<XAnnotation>> annotations) {
        List<XAnnotation> list = annotations.get(pojoName);
        if (list == null) {
            list = new ArrayList<XAnnotation>();
            annotations.put(pojoName, list);
        }
        list.add(annotation);
    }

    public void addAnnotation(String pojoName, String featureName, XAnnotation annotation, Map<String, Map<String, List<XAnnotation>>> annotations) {
        List<XAnnotation> list;
        Map<String, List<XAnnotation>> map = annotations.get(pojoName);
        if (map == null) {
            map = new HashMap<String, List<XAnnotation>>();
            annotations.put(pojoName, map);
        }
        if ((list = map.get(featureName)) == null) {
            list = new ArrayList<XAnnotation>();
            map.put(featureName, list);
        }
        list.add(annotation);
    }

    public StringBuilder getAnnotationsDefinitions(String pojoName, ISerializer serializer, boolean simpleNames, boolean nonStandardAnnotations, Map<String, List<XAnnotation>> annotations, String directive) {
        StringBuilder sb = new StringBuilder();
        if (!annotations.containsKey(pojoName)) {
            return sb;
        }
        for (XAnnotation a : annotations.get(pojoName)) {
            if (nonStandardAnnotations) {
                sb.append(this.NLINDENT).append(directive);
            }
            sb.append(this.NLINDENT).append("final ").append(CommonUtils.removeBlankLines(serializer.serialize((EObject)a)));
        }
        return sb;
    }

    public StringBuilder getEntityAnnotationsDefinitions(String pojoName, ISerializer serializer, boolean simpleNames, boolean nonStandardAnnotations) {
        return this.getAnnotationsDefinitions(pojoName, serializer, simpleNames, nonStandardAnnotations, this.entityAnnotations, "#Standard");
    }

    public StringBuilder getConstructorAnnotationsDefinitions(String pojoName, ISerializer serializer, boolean simpleNames) {
        return this.getAnnotationsDefinitions(pojoName, serializer, simpleNames, true, this.constructorAnnotations, "#Constructor");
    }

    public StringBuilder getStaticAnnotationsDefinitions(String pojoName, ISerializer serializer, boolean simpleNames) {
        return this.getAnnotationsDefinitions(pojoName, serializer, simpleNames, true, this.staticAnnotations, "#Static");
    }

    public StringBuilder getConflictAnnotationsDefinitions(String pojoName, ISerializer serializer, boolean simpleNames) {
        return this.getAnnotationsDefinitions(pojoName, serializer, simpleNames, true, this.conflictAnnotations, "#Conflict");
    }

    public boolean isNonStandardPojoAnnotations(String pojoName) {
        return this.constructorAnnotations.containsKey(pojoName) && !this.constructorAnnotations.get(pojoName).isEmpty() || this.staticAnnotations.containsKey(pojoName) && !this.staticAnnotations.get(pojoName).isEmpty() || this.conflictAnnotations.containsKey(pojoName) && !this.conflictAnnotations.get(pojoName).isEmpty();
    }

    public StringBuilder getAnnotationsDefinitions(String pojoName, String featureName, ISerializer serializer, boolean simpleNames, Map<String, Map<String, List<XAnnotation>>> annotations, String directive) {
        StringBuilder sb = new StringBuilder();
        if (!annotations.containsKey(pojoName) || !annotations.get(pojoName).containsKey(featureName)) {
            return sb;
        }
        for (XAnnotation a : annotations.get(pojoName).get(featureName)) {
            if (directive != null) {
                sb.append(this.NLINDENT).append(this.INDENT).append(directive);
            }
            sb.append(this.NLINDENT).append(this.INDENT).append("final ").append(CommonUtils.removeBlankLines(serializer.serialize((EObject)a)));
        }
        return sb;
    }

    public StringBuilder getGetterAnnotationsDefinitions(String pojoName, String featureName, ISerializer serializer, boolean simpleNames) {
        return this.getAnnotationsDefinitions(pojoName, featureName, serializer, simpleNames, this.getterAnnotations, "#Getter");
    }

    public StringBuilder getSetterAnnotationsDefinitions(String pojoName, String featureName, ISerializer serializer, boolean simpleNames) {
        return this.getAnnotationsDefinitions(pojoName, featureName, serializer, simpleNames, this.setterAnnotations, "#Setter");
    }

    public StringBuilder getAttributeAnnotationsDefinitions(String pojoName, String featureName, ISerializer serializer, boolean simpleNames, boolean nonStandardAnnotations) {
        return this.getAnnotationsDefinitions(pojoName, featureName, serializer, simpleNames, this.attributeAnnotations, "#Attribute");
    }

    public StringBuilder getProcedureAnnotationsDefinitions(String pojoName, String featureName, ISerializer serializer, boolean simpleNames, boolean nonStandardAnnotations) {
        return this.getAnnotationsDefinitions(pojoName, featureName, serializer, simpleNames, this.procedureAnnotations, null);
    }

    public boolean isNonStandardPojoAnnotations(String pojoName, String featureName) {
        return this.getterAnnotations.containsKey(pojoName) && this.getterAnnotations.get(pojoName).containsKey(featureName) && !this.getterAnnotations.get(pojoName).get(featureName).isEmpty() || this.setterAnnotations.containsKey(pojoName) && this.setterAnnotations.get(pojoName).containsKey(featureName) && !this.setterAnnotations.get(pojoName).get(featureName).isEmpty();
    }

    public boolean hasAttributeAnnotationsDefinitions(String pojoName, String featureName, String annotationName) {
        if (this.attributeAnnotations == null) {
            return false;
        }
        if (!this.attributeAnnotations.containsKey(pojoName) || !this.attributeAnnotations.get(pojoName).containsKey(featureName)) {
            return false;
        }
        for (XAnnotation a : this.attributeAnnotations.get(pojoName).get(featureName)) {
            String aName = a.getAnnotationType().getQualifiedName();
            if (!annotationName.equals(aName)) continue;
            return true;
        }
        return false;
    }

    public static void grabAnnotations(AnnotatedEntity apojo, Annotations as) {
        String name;
        DaoEntity dao;
        Entity entity = apojo.getEntity();
        if (entity == null) {
            return;
        }
        PojoEntity pojo = entity instanceof PojoEntity ? (PojoEntity)entity : null;
        EnumEntity epojo = entity instanceof EnumEntity ? (EnumEntity)entity : null;
        DaoEntity daoEntity = dao = entity instanceof DaoEntity ? (DaoEntity)entity : null;
        String string = pojo != null ? pojo.getName() : (epojo != null ? epojo.getName() : (name = dao != null ? dao.getName() : null));
        if (name == null) {
            return;
        }
        if (apojo.getAnnotations() != null && !apojo.getAnnotations().isEmpty()) {
            for (Annotation an : apojo.getAnnotations()) {
                if (!an.isFinal()) continue;
                if (an.getDirectives() == null || an.getDirectives().isEmpty()) {
                    as.addAnnotation(name, an.getAnnotation(), as.entityAnnotations);
                    continue;
                }
                for (AnnotationDirective dir : an.getDirectives()) {
                    if (dir instanceof AnnotationDirectiveConflict) {
                        as.addAnnotation(name, an.getAnnotation(), as.conflictAnnotations);
                        continue;
                    }
                    if (dir instanceof AnnotationDirectiveConstructor) {
                        as.addAnnotation(name, an.getAnnotation(), as.constructorAnnotations);
                        continue;
                    }
                    if (dir instanceof AnnotationDirectiveStandard) {
                        as.addAnnotation(name, an.getAnnotation(), as.entityAnnotations);
                        continue;
                    }
                    if (!(dir instanceof AnnotationDirectiveStatic)) continue;
                    as.addAnnotation(name, an.getAnnotation(), as.staticAnnotations);
                }
            }
        }
        if (pojo != null) {
            for (AnnotatedFeature feature : pojo.getFeatures()) {
                if (feature.getAnnotations() == null || feature.getAnnotations().isEmpty()) continue;
                for (Annotation an : feature.getAnnotations()) {
                    if (!an.isFinal()) continue;
                    if (an.getDirectives() == null || an.getDirectives().isEmpty()) {
                        as.addAnnotation(name, feature.getFeature().getName(), an.getAnnotation(), as.attributeAnnotations);
                        continue;
                    }
                    for (AnnotationDirective dir : an.getDirectives()) {
                        if (dir instanceof AnnotationDirectiveSetter) {
                            as.addAnnotation(name, feature.getFeature().getName(), an.getAnnotation(), as.setterAnnotations);
                            continue;
                        }
                        if (dir instanceof AnnotationDirectiveGetter) {
                            as.addAnnotation(name, feature.getFeature().getName(), an.getAnnotation(), as.getterAnnotations);
                            continue;
                        }
                        if (!(dir instanceof AnnotationDirectiveAttribute)) continue;
                        as.addAnnotation(name, feature.getFeature().getName(), an.getAnnotation(), as.attributeAnnotations);
                    }
                }
            }
        }
        if (dao != null) {
            for (AnnotatedFeature feature : dao.getFeatures()) {
                if (feature.getAnnotations() == null || feature.getAnnotations().isEmpty()) continue;
                for (Annotation an : feature.getAnnotations()) {
                    if (!an.isFinal()) continue;
                    if (an.getDirectives() == null || an.getDirectives().isEmpty()) {
                        as.addAnnotation(name, feature.getFeature().getName(), an.getAnnotation(), as.attributeAnnotations);
                        continue;
                    }
                    for (AnnotationDirective dir : an.getDirectives()) {
                        if (dir instanceof AnnotationDirectiveSetter) {
                            as.addAnnotation(name, feature.getFeature().getName(), an.getAnnotation(), as.setterAnnotations);
                            continue;
                        }
                        if (dir instanceof AnnotationDirectiveGetter) {
                            as.addAnnotation(name, feature.getFeature().getName(), an.getAnnotation(), as.getterAnnotations);
                            continue;
                        }
                        if (!(dir instanceof AnnotationDirectiveAttribute)) continue;
                        as.addAnnotation(name, feature.getFeature().getName(), an.getAnnotation(), as.attributeAnnotations);
                    }
                }
            }
        }
    }

    public String toString() {
        return "Annotations [entityAnnotations=" + this.entityAnnotations + ", constructorAnnotations=" + this.constructorAnnotations + ", staticAnnotations=" + this.staticAnnotations + ", conflictAnnotations=" + this.conflictAnnotations + ", setterAnnotations=" + this.setterAnnotations + ", getterAnnotations=" + this.getterAnnotations + ", attributeAnnotations=" + this.attributeAnnotations + "]";
    }
}

