/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.model.jvmmodel;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.jvmmodel.AbstractModelInferrer;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.JvmAnnotationReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.sqlproc.model.jvmmodel.ProcessorGeneratorUtils;
import org.sqlproc.model.jvmmodel.ProcessorTypesBuilder;
import org.sqlproc.model.processorModel.AnnotatedFeature;
import org.sqlproc.model.processorModel.Annotation;
import org.sqlproc.model.processorModel.DaoDirective;
import org.sqlproc.model.processorModel.DaoDirectiveCrud;
import org.sqlproc.model.processorModel.DaoDirectiveParameters;
import org.sqlproc.model.processorModel.DaoDirectiveQuery;
import org.sqlproc.model.processorModel.DaoEntity;
import org.sqlproc.model.processorModel.DaoFunProcDirective;
import org.sqlproc.model.processorModel.Extends;
import org.sqlproc.model.processorModel.Feature;
import org.sqlproc.model.processorModel.FunProcType;
import org.sqlproc.model.processorModel.FunctionCall;
import org.sqlproc.model.processorModel.FunctionCallQuery;
import org.sqlproc.model.processorModel.FunctionQuery;
import org.sqlproc.model.processorModel.Implements;
import org.sqlproc.model.processorModel.PojoAttribute;
import org.sqlproc.model.processorModel.PojoAttributeDirectivePrimaryKey;
import org.sqlproc.model.processorModel.PojoEntity;
import org.sqlproc.model.processorModel.PojoProcedure;
import org.sqlproc.model.processorModel.ProcedureCallQuery;
import org.sqlproc.model.processorModel.ProcedureUpdate;

public class DaoJvmModelInferrer
extends AbstractModelInferrer {
    @Extension
    public JvmAnnotationReferenceBuilder _annotationTypesBuilder;
    @Extension
    public JvmTypeReferenceBuilder _typeReferenceBuilder;
    @Inject
    @Extension
    private ProcessorTypesBuilder _processorTypesBuilder;
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    @Extension
    private ProcessorGeneratorUtils _processorGeneratorUtils;
    private final String SERIALIZABLE = "java.io.Serializable";
    private final String ENGINE_FACTORY = "org.sqlproc.engine.SqlEngineFactory";
    private final String SESSION_FACTORY = "org.sqlproc.engine.SqlSessionFactory";
    private final String SQL_SESSION = "org.sqlproc.engine.SqlSession";
    private final String SQL_CONTROL = "org.sqlproc.engine.SqlControl";
    private final String SQL_RUNTIME_EXCEPTION = "org.sqlproc.engine.SqlRuntimeException";
    private final String LOGGER = "org.slf4j.Logger";
    private final String LOGGER_FACTORY = "org.slf4j.LoggerFactory";
    private final String CRUD_ENGINE = "org.sqlproc.engine.SqlCrudEngine";
    private final String QUERY_ENGINE = "org.sqlproc.engine.SqlQueryEngine";
    private final String PROCEDURE_ENGINE = "org.sqlproc.engine.SqlProcedureEngine";
    private final String SQL_ROW_PROCESSOR = "org.sqlproc.engine.SqlRowProcessor";
    private final String SET = "java.util.Set";
    private final String HASH_SET = "java.util.HashSet";
    private final String MAP = "java.util.Map";
    private final String HASH_MAP = "java.util.HashMap";
    private final String LIST = "java.util.List";
    private final String ARRAY_LIST = "java.util.ArrayList";
    private final String SQL_STANDARD_CONTROL = "org.sqlproc.engine.impl.SqlStandardControl";

    public void inferDaoIfx(final DaoEntity entity, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        JvmGenericType pojoType;
        final PojoEntity pojo = this._processorGeneratorUtils.getPojo(entity);
        if (Objects.equal((Object)pojo, null) && !this._processorGeneratorUtils.isFunctionProcedure(entity)) {
            InputOutput.println((Object)("Missing POJO for " + entity));
            return;
        }
        Procedures.Procedure1<JvmGenericType> _function = new Procedures.Procedure1<JvmGenericType>(){

            public void apply(JvmGenericType it) {
            }
        };
        final JvmGenericType entityType = this._processorTypesBuilder.toInterface(entity, this._iQualifiedNameProvider.getFullyQualifiedName((EObject)entity).toString(), (Procedures.Procedure1)_function);
        JvmGenericType _class = null;
        if (pojo != null) {
            QualifiedName _fullyQualifiedName = null;
            if (pojo != null) {
                _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)pojo);
            }
            _class = this._processorTypesBuilder.toClass(pojo, _fullyQualifiedName);
        }
        if (Objects.equal(pojoType = _class, null) && !this._processorGeneratorUtils.isFunctionProcedure(entity)) {
            InputOutput.println((Object)("Missing POJOTYPE for " + entity));
            return;
        }
        final PojoAttribute primaryKey = this._processorGeneratorUtils.getPrimaryKey(pojo);
        PojoAttributeDirectivePrimaryKey _primaryKeyDir = null;
        if (primaryKey != null) {
            _primaryKeyDir = this._processorGeneratorUtils.getPrimaryKeyDir(primaryKey);
        }
        final PojoAttributeDirectivePrimaryKey pkDir = _primaryKeyDir;
        final String simpleName = entity.getName();
        final Integer sernum = this._processorGeneratorUtils.getSernum(entity);
        Procedures.Procedure1<JvmGenericType> _function_1 = new Procedures.Procedure1<JvmGenericType>(){

            public void apply(JvmGenericType it) {
                boolean _notEquals;
                DaoJvmModelInferrer.this._processorTypesBuilder.setDocumentation((JvmIdentifiableElement)it, DaoJvmModelInferrer.this._processorTypesBuilder.getDocumentation(entity));
                List<Implements> _implements = DaoJvmModelInferrer.this._processorGeneratorUtils.getImplements(entity);
                for (Implements impl : _implements) {
                    boolean _isGenerics = DaoJvmModelInferrer.this._processorGeneratorUtils.isGenerics(impl);
                    if (_isGenerics) {
                        JvmTypeReference genericType = DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)it, new JvmTypeReference[]{impl.getImplements(), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0])});
                        EList _superTypes = it.getSuperTypes();
                        DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_superTypes, genericType);
                        continue;
                    }
                    EList _superTypes_1 = it.getSuperTypes();
                    JvmTypeReference _cloneWithProxies = DaoJvmModelInferrer.this._processorTypesBuilder.cloneWithProxies((JvmTypeReference)impl.getImplements());
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_superTypes_1, _cloneWithProxies);
                }
                boolean bl = _notEquals = !Objects.equal((Object)sernum, null);
                if (_notEquals) {
                    EList _superTypes_2 = it.getSuperTypes();
                    JvmTypeReference _typeRef = DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("java.io.Serializable", new JvmTypeReference[0]);
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_superTypes_2, _typeRef);
                }
                Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses = null;
                EList<DaoDirective> _directives = entity.getDirectives();
                for (DaoDirective dir : _directives) {
                    if (dir instanceof DaoDirectiveCrud) {
                        boolean _equals = Objects.equal((Object)moreResultClasses, null);
                        if (_equals) {
                            moreResultClasses = DaoJvmModelInferrer.this._processorGeneratorUtils.getMoreResultClasses(entity);
                        }
                        DaoJvmModelInferrer.this.inferInsertIfx(entity, (DaoDirectiveCrud)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)it.getMembers());
                        DaoJvmModelInferrer.this.inferGetIfx(entity, (DaoDirectiveCrud)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)it.getMembers(), moreResultClasses);
                        DaoJvmModelInferrer.this.inferUpdateIfx(entity, (DaoDirectiveCrud)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)it.getMembers());
                        DaoJvmModelInferrer.this.inferDeleteIfx(entity, (DaoDirectiveCrud)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)it.getMembers());
                        continue;
                    }
                    if (dir instanceof DaoDirectiveQuery) {
                        boolean _equals_1 = Objects.equal((Object)moreResultClasses, null);
                        if (_equals_1) {
                            moreResultClasses = DaoJvmModelInferrer.this._processorGeneratorUtils.getMoreResultClasses(entity);
                        }
                        DaoJvmModelInferrer.this.inferListIfx(entity, (DaoDirectiveQuery)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)it.getMembers(), moreResultClasses);
                        DaoJvmModelInferrer.this.inferQueryIfx(entity, (DaoDirectiveQuery)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)it.getMembers(), moreResultClasses);
                        if (!(Objects.equal((Object)primaryKey, null) || Objects.equal((Object)pkDir.getFromTo(), null) || DaoJvmModelInferrer.this._processorGeneratorUtils.toInitAttributes(pojo).isEmpty())) {
                            DaoJvmModelInferrer.this.inferListFromToIfx(entity, (DaoDirectiveQuery)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)it.getMembers(), moreResultClasses);
                        }
                        DaoJvmModelInferrer.this.inferCountIfx(entity, (DaoDirectiveQuery)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)it.getMembers(), moreResultClasses);
                        continue;
                    }
                    if (!(dir instanceof DaoFunProcDirective)) continue;
                    DaoJvmModelInferrer.this.inferFunctionProcedureIfx(entity, ((DaoFunProcDirective)dir).getType(), ((DaoFunProcDirective)dir).getParamlist(), entityType, simpleName, (List<JvmMember>)it.getMembers());
                }
                if (!Objects.equal(moreResultClasses, null) && !moreResultClasses.isEmpty()) {
                    DaoJvmModelInferrer.this.inferMoreResultClassesIfx(entity, entityType, simpleName, pojo, pojoType, (List<JvmMember>)it.getMembers(), moreResultClasses);
                }
            }
        };
        acceptor.accept((JvmDeclaredType)entityType, (Procedures.Procedure1)_function_1);
    }

    public void inferDao(final DaoEntity entity, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase, String implPackage) {
        JvmGenericType pojoType;
        boolean _notEquals;
        final PojoEntity pojo = this._processorGeneratorUtils.getPojo(entity);
        if (Objects.equal((Object)pojo, null) && !this._processorGeneratorUtils.isFunctionProcedure(entity)) {
            InputOutput.println((Object)("Missing POJO for " + entity));
            return;
        }
        final JvmGenericType entityType = this._processorTypesBuilder.toClass(entity, this.daoFullyQualifiedName(entity, implPackage));
        JvmGenericType _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)implPackage, null);
        if (_notEquals) {
            Procedures.Procedure1<JvmGenericType> _function = new Procedures.Procedure1<JvmGenericType>(){

                public void apply(JvmGenericType it) {
                }
            };
            _xifexpression = this._processorTypesBuilder.toInterface(entity, this._iQualifiedNameProvider.getFullyQualifiedName((EObject)entity).toString(), (Procedures.Procedure1)_function);
        }
        final JvmGenericType entityTypeIfx = _xifexpression;
        JvmGenericType _class = null;
        if (pojo != null) {
            QualifiedName _fullyQualifiedName = null;
            if (pojo != null) {
                _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)pojo);
            }
            _class = this._processorTypesBuilder.toClass(pojo, _fullyQualifiedName);
        }
        if (Objects.equal(pojoType = _class, null) && !this._processorGeneratorUtils.isFunctionProcedure(entity)) {
            InputOutput.println((Object)("Missing POJOTYPE for " + entity));
            return;
        }
        final PojoAttribute primaryKey = this._processorGeneratorUtils.getPrimaryKey(pojo);
        PojoAttributeDirectivePrimaryKey _primaryKeyDir = null;
        if (primaryKey != null) {
            _primaryKeyDir = this._processorGeneratorUtils.getPrimaryKeyDir(primaryKey);
        }
        final PojoAttributeDirectivePrimaryKey pkDir = _primaryKeyDir;
        final String simpleName = entity.getName();
        final Integer sernum = this._processorGeneratorUtils.getSernum(entity);
        Procedures.Procedure1<JvmGenericType> _function_1 = new Procedures.Procedure1<JvmGenericType>(){

            public void apply(JvmGenericType it) {
                boolean _notEquals_3;
                JvmParameterizedTypeReference _superType;
                boolean _notEquals_2;
                boolean _notEquals_1;
                boolean _notEquals;
                DaoJvmModelInferrer.this._processorTypesBuilder.setDocumentation((JvmIdentifiableElement)it, DaoJvmModelInferrer.this._processorTypesBuilder.getDocumentation(entity));
                Functions.Function1<Annotation, XAnnotation> _function = new Functions.Function1<Annotation, XAnnotation>(){

                    public XAnnotation apply(Annotation a) {
                        return a.getAnnotation();
                    }
                };
                List _map = ListExtensions.map(DaoJvmModelInferrer.this._processorGeneratorUtils.standardAnnotations(entity), (Functions.Function1)_function);
                for (XAnnotation an : _map) {
                    String _identifier = an.getAnnotationType().getIdentifier();
                    boolean _equals = Objects.equal((Object)_identifier, (Object)"java.io.Serializable");
                    if (_equals) {
                        EList _superTypes = it.getSuperTypes();
                        JvmTypeReference _typeRef = DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(an.getAnnotationType(), new JvmTypeReference[0]);
                        DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_superTypes, _typeRef);
                        continue;
                    }
                    DaoJvmModelInferrer.this._processorTypesBuilder.addAnnotation((JvmAnnotationTarget)it, an);
                }
                boolean bl = _notEquals = !Objects.equal((Object)entityTypeIfx, null);
                if (_notEquals) {
                    EList _superTypes_1 = it.getSuperTypes();
                    JvmTypeReference _typeRef_1 = DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)entityTypeIfx, new JvmTypeReference[0]);
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_superTypes_1, _typeRef_1);
                }
                List<Implements> _implements = DaoJvmModelInferrer.this._processorGeneratorUtils.getImplements(entity);
                for (Implements impl : _implements) {
                    boolean _isGenerics = DaoJvmModelInferrer.this._processorGeneratorUtils.isGenerics(impl);
                    if (_isGenerics) {
                        String name = impl.getImplements().getIdentifier();
                        JvmTypeReference ref = DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(name, new JvmTypeReference[]{DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0])});
                        EList _superTypes_2 = it.getSuperTypes();
                        DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_superTypes_2, ref);
                        continue;
                    }
                    EList _superTypes_3 = it.getSuperTypes();
                    JvmTypeReference _cloneWithProxies = DaoJvmModelInferrer.this._processorTypesBuilder.cloneWithProxies((JvmTypeReference)impl.getImplements());
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_superTypes_3, _cloneWithProxies);
                }
                Extends ext = DaoJvmModelInferrer.this._processorGeneratorUtils.getExtends(entity);
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)ext, null);
                if (_notEquals_1) {
                    EList _superTypes_4 = it.getSuperTypes();
                    JvmTypeReference _cloneWithProxies_1 = DaoJvmModelInferrer.this._processorTypesBuilder.cloneWithProxies((JvmTypeReference)ext.getExtends());
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_superTypes_4, _cloneWithProxies_1);
                }
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)(_superType = entity.getSuperType()), null);
                if (_notEquals_2) {
                    EList _superTypes_5 = it.getSuperTypes();
                    JvmTypeReference _cloneWithProxies_2 = DaoJvmModelInferrer.this._processorTypesBuilder.cloneWithProxies((JvmTypeReference)entity.getSuperType());
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_superTypes_5, _cloneWithProxies_2);
                }
                boolean bl4 = _notEquals_3 = !Objects.equal((Object)sernum, null);
                if (_notEquals_3) {
                    EList _superTypes_6 = it.getSuperTypes();
                    JvmTypeReference _typeRef_2 = DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("java.io.Serializable", new JvmTypeReference[0]);
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_superTypes_6, _typeRef_2);
                    EList _members = it.getMembers();
                    Procedures.Procedure1<JvmField> _function_1 = new Procedures.Procedure1<JvmField>(){

                        public void apply(JvmField it) {
                            it.setStatic(true);
                            it.setFinal(true);
                            StringConcatenationClient _client = new StringConcatenationClient(){

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append((Object)sernum);
                                    _builder.append((Object)"L");
                                }
                            };
                            DaoJvmModelInferrer.this._processorTypesBuilder.setInitializer(it, _client);
                        }
                    };
                    JvmField _field = DaoJvmModelInferrer.this._processorTypesBuilder.toField(entity, "serialVersionUID", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(Long.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_1);
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_members, _field);
                }
                EList _members_1 = it.getMembers();
                Procedures.Procedure1<JvmField> _function_2 = new Procedures.Procedure1<JvmField>(){

                    public void apply(JvmField it) {
                        it.setVisibility(JvmVisibility.PROTECTED);
                        it.setFinal(true);
                        StringConcatenationClient _client = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)"org.slf4j.LoggerFactory");
                                _builder.append((Object)".getLogger(getClass())");
                            }
                        };
                        DaoJvmModelInferrer.this._processorTypesBuilder.setInitializer(it, _client);
                    }
                };
                JvmField _field_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toField(entity, "logger", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.slf4j.Logger", new JvmTypeReference[0]), (Procedures.Procedure1)_function_2);
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_members_1, _field_1);
                EList _members_2 = it.getMembers();
                Procedures.Procedure1<JvmConstructor> _function_3 = new Procedures.Procedure1<JvmConstructor>(){

                    public void apply(JvmConstructor it) {
                        Functions.Function1<Annotation, XAnnotation> _function = new Functions.Function1<Annotation, XAnnotation>(){

                            public XAnnotation apply(Annotation a) {
                                return a.getAnnotation();
                            }
                        };
                        DaoJvmModelInferrer.this._processorTypesBuilder.addAnnotations((JvmAnnotationTarget)it, ListExtensions.map(DaoJvmModelInferrer.this._processorGeneratorUtils.constructorAnnotations(entity), (Functions.Function1)_function));
                    }
                };
                JvmConstructor _constructor = DaoJvmModelInferrer.this._processorTypesBuilder.toConstructor(entity, (Procedures.Procedure1)_function_3);
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_members_2, _constructor);
                EList _members_3 = it.getMembers();
                Procedures.Procedure1<JvmConstructor> _function_4 = new Procedures.Procedure1<JvmConstructor>(){

                    public void apply(JvmConstructor it) {
                        EList _parameters = it.getParameters();
                        JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlEngineFactory", (this).DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlEngineFactory", new JvmTypeReference[0]));
                        DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                        Functions.Function1<Annotation, XAnnotation> _function = new Functions.Function1<Annotation, XAnnotation>(){

                            public XAnnotation apply(Annotation a) {
                                return a.getAnnotation();
                            }
                        };
                        DaoJvmModelInferrer.this._processorTypesBuilder.addAnnotations((JvmAnnotationTarget)it, ListExtensions.map(DaoJvmModelInferrer.this._processorGeneratorUtils.constructorAnnotations(entity), (Functions.Function1)_function));
                        StringConcatenationClient _client = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)"this.sqlEngineFactory = sqlEngineFactory;");
                                _builder.newLine();
                            }
                        };
                        DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
                    }
                };
                JvmConstructor _constructor_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toConstructor(entity, (Procedures.Procedure1)_function_4);
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_members_3, _constructor_1);
                EList _members_4 = it.getMembers();
                Procedures.Procedure1<JvmConstructor> _function_5 = new Procedures.Procedure1<JvmConstructor>(){

                    public void apply(JvmConstructor it) {
                        EList _parameters = it.getParameters();
                        JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlEngineFactory", (this).DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlEngineFactory", new JvmTypeReference[0]));
                        DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                        EList _parameters_1 = it.getParameters();
                        JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSessionFactory", (this).DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSessionFactory", new JvmTypeReference[0]));
                        DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                        Functions.Function1<Annotation, XAnnotation> _function = new Functions.Function1<Annotation, XAnnotation>(){

                            public XAnnotation apply(Annotation a) {
                                return a.getAnnotation();
                            }
                        };
                        DaoJvmModelInferrer.this._processorTypesBuilder.addAnnotations((JvmAnnotationTarget)it, ListExtensions.map(DaoJvmModelInferrer.this._processorGeneratorUtils.constructorAnnotations(entity), (Functions.Function1)_function));
                        StringConcatenationClient _client = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)"this.sqlEngineFactory = sqlEngineFactory;");
                                _builder.newLine();
                                _builder.append((Object)"this.sqlSessionFactory = sqlSessionFactory;");
                                _builder.newLine();
                            }
                        };
                        DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
                    }
                };
                JvmConstructor _constructor_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toConstructor(entity, (Procedures.Procedure1)_function_5);
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_members_4, _constructor_2);
                EList _members_5 = it.getMembers();
                Procedures.Procedure1<JvmField> _function_6 = new Procedures.Procedure1<JvmField>(){

                    public void apply(JvmField it) {
                        it.setVisibility(JvmVisibility.PROTECTED);
                    }
                };
                JvmField _field_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toField(entity, "sqlEngineFactory", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlEngineFactory", new JvmTypeReference[0]), (Procedures.Procedure1)_function_6);
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_members_5, _field_2);
                EList _members_6 = it.getMembers();
                Procedures.Procedure1<JvmField> _function_7 = new Procedures.Procedure1<JvmField>(){

                    public void apply(JvmField it) {
                        it.setVisibility(JvmVisibility.PROTECTED);
                    }
                };
                JvmField _field_3 = DaoJvmModelInferrer.this._processorTypesBuilder.toField(entity, "sqlSessionFactory", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSessionFactory", new JvmTypeReference[0]), (Procedures.Procedure1)_function_7);
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_members_6, _field_3);
                Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses = null;
                EList<DaoDirective> _directives = entity.getDirectives();
                for (DaoDirective dir : _directives) {
                    if (dir instanceof DaoDirectiveCrud) {
                        boolean _equals_1 = Objects.equal((Object)moreResultClasses, null);
                        if (_equals_1) {
                            moreResultClasses = DaoJvmModelInferrer.this._processorGeneratorUtils.getMoreResultClasses(entity);
                        }
                        DaoJvmModelInferrer.this.inferInsert(entity, (DaoDirectiveCrud)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)it.getMembers());
                        DaoJvmModelInferrer.this.inferGet(entity, (DaoDirectiveCrud)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)it.getMembers(), moreResultClasses);
                        DaoJvmModelInferrer.this.inferUpdate(entity, (DaoDirectiveCrud)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)it.getMembers());
                        DaoJvmModelInferrer.this.inferDelete(entity, (DaoDirectiveCrud)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)it.getMembers());
                        continue;
                    }
                    if (dir instanceof DaoDirectiveQuery) {
                        boolean _equals_2 = Objects.equal((Object)moreResultClasses, null);
                        if (_equals_2) {
                            moreResultClasses = DaoJvmModelInferrer.this._processorGeneratorUtils.getMoreResultClasses(entity);
                        }
                        DaoJvmModelInferrer.this.inferList(entity, (DaoDirectiveQuery)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)it.getMembers(), moreResultClasses);
                        DaoJvmModelInferrer.this.inferQuery(entity, (DaoDirectiveQuery)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)it.getMembers(), moreResultClasses);
                        if (!(Objects.equal((Object)primaryKey, null) || Objects.equal((Object)pkDir.getFromTo(), null) || DaoJvmModelInferrer.this._processorGeneratorUtils.toInitAttributes(pojo).isEmpty())) {
                            DaoJvmModelInferrer.this.inferListFromTo(entity, (DaoDirectiveQuery)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)it.getMembers(), moreResultClasses, primaryKey);
                        }
                        DaoJvmModelInferrer.this.inferCount(entity, (DaoDirectiveQuery)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)it.getMembers(), moreResultClasses);
                        continue;
                    }
                    if (!(dir instanceof DaoFunProcDirective)) continue;
                    DaoJvmModelInferrer.this.inferFunctionProcedure(entity, ((DaoFunProcDirective)dir).getType(), ((DaoFunProcDirective)dir).getParamlist(), entityType, simpleName, (List<JvmMember>)it.getMembers());
                }
                if (!Objects.equal(moreResultClasses, null) && !moreResultClasses.isEmpty()) {
                    DaoJvmModelInferrer.this.inferMoreResultClasses(entity, entityType, simpleName, pojo, pojoType, (List<JvmMember>)it.getMembers(), moreResultClasses);
                }
                HashSet<String> procNames = new HashSet<String>();
                Functions.Function1<AnnotatedFeature, Feature> _function_8 = new Functions.Function1<AnnotatedFeature, Feature>(){

                    public Feature apply(AnnotatedFeature it) {
                        return it.getFeature();
                    }
                };
                Iterable _filter = Iterables.filter((Iterable)ListExtensions.map(entity.getFeatures(), (Functions.Function1)_function_8), PojoAttribute.class);
                for (final PojoAttribute attr : _filter) {
                    boolean _notEquals_5;
                    boolean _notEquals_4;
                    boolean _not;
                    JvmParameterizedTypeReference _elvis = null;
                    JvmParameterizedTypeReference _elvis_1 = null;
                    JvmParameterizedTypeReference _type = attr.getType();
                    if (_type != null) {
                        _elvis_1 = _type;
                    } else {
                        XExpression _initExpr = attr.getInitExpr();
                        JvmTypeReference _inferredType = null;
                        if (_initExpr != null) {
                            _inferredType = DaoJvmModelInferrer.this._processorTypesBuilder.inferredType(_initExpr);
                        }
                        _elvis_1 = _inferredType;
                    }
                    if (_elvis_1 != null) {
                        _elvis = _elvis_1;
                    } else {
                        JvmTypeReference _typeRef_3 = DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(String.class, new JvmTypeReference[0]);
                        _elvis = _typeRef_3;
                    }
                    JvmParameterizedTypeReference type = _elvis;
                    EList _members_7 = it.getMembers();
                    Procedures.Procedure1<JvmField> _function_9 = new Procedures.Procedure1<JvmField>((JvmTypeReference)type){
                        private final /* synthetic */ JvmTypeReference val$type;
                        {
                            this.val$type = jvmTypeReference;
                        }

                        public void apply(JvmField it) {
                            XExpression _initExpr;
                            boolean _notEquals;
                            DaoJvmModelInferrer.this._processorTypesBuilder.setDocumentation((JvmIdentifiableElement)it, DaoJvmModelInferrer.this._processorTypesBuilder.getDocumentation(attr));
                            Functions.Function1<Annotation, XAnnotation> _function = new Functions.Function1<Annotation, XAnnotation>(){

                                public XAnnotation apply(Annotation a) {
                                    return a.getAnnotation();
                                }
                            };
                            DaoJvmModelInferrer.this._processorTypesBuilder.addAnnotations((JvmAnnotationTarget)it, ListExtensions.map(DaoJvmModelInferrer.this._processorGeneratorUtils.attributeAnnotations(attr), (Functions.Function1)_function));
                            it.setStatic(attr.isStatic());
                            boolean _isStatic = attr.isStatic();
                            if (_isStatic) {
                                it.setVisibility(JvmVisibility.PUBLIC);
                            }
                            boolean bl = _notEquals = !Objects.equal((Object)(_initExpr = attr.getInitExpr()), null);
                            if (_notEquals) {
                                DaoJvmModelInferrer.this._processorTypesBuilder.setInitializer(it, attr.getInitExpr());
                            } else {
                                boolean _isList = DaoJvmModelInferrer.this._processorGeneratorUtils.isList(attr);
                                if (_isList) {
                                    StringConcatenationClient _client = new StringConcatenationClient(){

                                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                            _builder.append((Object)"new java.util.Array");
                                            String _simpleName = val$type.getSimpleName();
                                            _builder.append((Object)_simpleName);
                                            _builder.append((Object)"()");
                                        }
                                    };
                                    DaoJvmModelInferrer.this._processorTypesBuilder.setInitializer(it, _client);
                                }
                            }
                        }
                    };
                    JvmField _field_4 = DaoJvmModelInferrer.this._processorTypesBuilder.toField(entity, attr.getName(), (JvmTypeReference)type, (Procedures.Procedure1)_function_9);
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_members_7, _field_4);
                    boolean _isStatic = attr.isStatic();
                    boolean bl5 = _not = !_isStatic;
                    if (!_not) continue;
                    Procedures.Procedure1<JvmOperation> _function_10 = new Procedures.Procedure1<JvmOperation>(){

                        public void apply(JvmOperation it) {
                            Functions.Function1<Annotation, XAnnotation> _function = new Functions.Function1<Annotation, XAnnotation>(){

                                public XAnnotation apply(Annotation a) {
                                    return a.getAnnotation();
                                }
                            };
                            DaoJvmModelInferrer.this._processorTypesBuilder.addAnnotations((JvmAnnotationTarget)it, ListExtensions.map(DaoJvmModelInferrer.this._processorGeneratorUtils.getterAnnotations(attr), (Functions.Function1)_function));
                        }
                    };
                    JvmOperation m1 = DaoJvmModelInferrer.this._processorTypesBuilder.toGetter(attr, attr.getName(), attr.getName(), (JvmTypeReference)type, procNames, (Procedures.Procedure1<? super JvmOperation>)_function_10);
                    boolean bl6 = _notEquals_4 = !Objects.equal((Object)m1, null);
                    if (_notEquals_4) {
                        EList _members_8 = it.getMembers();
                        DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_members_8, m1);
                    }
                    Procedures.Procedure1<JvmOperation> _function_11 = new Procedures.Procedure1<JvmOperation>(){

                        public void apply(JvmOperation it) {
                            Functions.Function1<Annotation, XAnnotation> _function = new Functions.Function1<Annotation, XAnnotation>(){

                                public XAnnotation apply(Annotation a) {
                                    return a.getAnnotation();
                                }
                            };
                            DaoJvmModelInferrer.this._processorTypesBuilder.addAnnotations((JvmAnnotationTarget)it, ListExtensions.map(DaoJvmModelInferrer.this._processorGeneratorUtils.setterAnnotations(attr), (Functions.Function1)_function));
                        }
                    };
                    JvmOperation m2 = DaoJvmModelInferrer.this._processorTypesBuilder.toSetter(attr, attr.getName(), attr.getName(), (JvmTypeReference)type, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)entityType, new JvmTypeReference[0]), procNames, (Procedures.Procedure1<? super JvmOperation>)_function_11);
                    boolean bl7 = _notEquals_5 = !Objects.equal((Object)m2, null);
                    if (!_notEquals_5) continue;
                    EList _members_9 = it.getMembers();
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_members_9, m2);
                }
                Functions.Function1<AnnotatedFeature, Feature> _function_9 = new Functions.Function1<AnnotatedFeature, Feature>(){

                    public Feature apply(AnnotatedFeature it) {
                        return it.getFeature();
                    }
                };
                Iterable _filter_1 = Iterables.filter((Iterable)ListExtensions.map(entity.getFeatures(), (Functions.Function1)_function_9), PojoProcedure.class);
                for (final PojoProcedure proc : _filter_1) {
                    EList _members_7 = it.getMembers();
                    String _name = proc.getName();
                    JvmParameterizedTypeReference _elvis = null;
                    JvmParameterizedTypeReference _type = proc.getType();
                    if (_type != null) {
                        _elvis = _type;
                    } else {
                        JvmTypeReference _inferredType = DaoJvmModelInferrer.this._processorTypesBuilder.inferredType();
                        _elvis = _inferredType;
                    }
                    Procedures.Procedure1<JvmOperation> _function_10 = new Procedures.Procedure1<JvmOperation>(){

                        public void apply(JvmOperation it) {
                            DaoJvmModelInferrer.this._processorTypesBuilder.setDocumentation((JvmIdentifiableElement)it, DaoJvmModelInferrer.this._processorTypesBuilder.getDocumentation(proc));
                            it.setStatic(proc.isStatic());
                            EList<JvmFormalParameter> _params = proc.getParams();
                            for (JvmFormalParameter param : _params) {
                                EList _parameters = it.getParameters();
                                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter((EObject)param, param.getName(), param.getParameterType());
                                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                            }
                            DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, proc.getBody());
                        }
                    };
                    JvmOperation _method = DaoJvmModelInferrer.this._processorTypesBuilder.toMethod(proc, _name, (JvmTypeReference)_elvis, (Procedures.Procedure1)_function_10);
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_members_7, _method);
                }
            }
        };
        acceptor.accept((JvmDeclaredType)entityType, (Procedures.Procedure1)_function_1);
    }

    public void inferInsert(final DaoEntity entity, DaoDirectiveCrud dir, JvmGenericType entityType, String simpleName, final PojoEntity pojo, final JvmGenericType pojoType, List<JvmMember> members) {
        final String pojoAttrName = StringExtensions.toFirstLower((String)pojo.getName());
        final PojoEntity parent = this._processorGeneratorUtils.getParentReflectInheritance(pojo);
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        boolean _notEquals;
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql insert ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)": \" + ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)" + \" \" + sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"String sqlName = (sqlControl != null && sqlControl.getSqlName() != null) ? sqlControl.getSqlName() : \"INSERT_");
                        String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(pojo.getName());
                        _builder.append((Object)_dbName);
                        _builder.append((Object)"\";");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"org.sqlproc.engine.SqlCrudEngine");
                        _builder.append((Object)" sqlInsert");
                        String _name = pojo.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(sqlName);");
                        boolean bl = _notEquals = !Objects.equal((Object)parent, null);
                        if (_notEquals) {
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"org.sqlproc.engine.SqlCrudEngine");
                            _builder.append((Object)" sqlInsert");
                            String _name_1 = parent.getName();
                            _builder.append((Object)_name_1);
                            _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"INSERT_");
                            String _dbName_1 = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(parent.getName());
                            _builder.append((Object)_dbName_1);
                            _builder.append((Object)"\");");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"int count = sqlInsert");
                            String _name_2 = parent.getName();
                            _builder.append((Object)_name_2);
                            _builder.append((Object)".insert(sqlSession, ");
                            _builder.append((Object)pojoAttrName);
                            _builder.append((Object)", sqlControl);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"if (count > 0) {");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"sqlInsert");
                            String _name_3 = pojo.getName();
                            _builder.append((Object)_name_3, "\t");
                            _builder.append((Object)".insert(sqlSession, ");
                            _builder.append((Object)pojoAttrName, "\t");
                            _builder.append((Object)", sqlControl);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"}");
                        } else {
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"int count = sqlInsert");
                            String _name_4 = pojo.getName();
                            _builder.append((Object)_name_4);
                            _builder.append((Object)".insert(sqlSession, ");
                            _builder.append((Object)pojoAttrName);
                            _builder.append((Object)", sqlControl);");
                        }
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql insert ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)" result: \" + count + \" \" + ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"return (count > 0) ? ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)" : null;");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "insert", this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]), (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return insert(sqlSessionFactory.getSqlSession(), ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "insert", this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]), (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return insert(sqlSession, ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "insert", this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]), (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return insert(");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "insert", this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]), (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferInsertIfx(final DaoEntity entity, DaoDirectiveCrud dir, JvmGenericType entityType, String simpleName, PojoEntity pojo, final JvmGenericType pojoType, List<JvmMember> members) {
        final String pojoAttrName = StringExtensions.toFirstLower((String)pojo.getName());
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "insert", this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]), (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "insert", this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]), (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "insert", this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]), (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "insert", this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]), (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferGet(final DaoEntity entity, DaoDirectiveCrud dir, JvmGenericType entityType, String simpleName, final PojoEntity pojo, final JvmGenericType pojoType, List<JvmMember> members, final Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        final String pojoAttrName = StringExtensions.toFirstLower((String)pojo.getName());
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql get: \" + ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)" + \" \" + sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"String sqlName = (sqlControl != null && sqlControl.getSqlName() != null) ? sqlControl.getSqlName() : \"GET_");
                        String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(pojo.getName());
                        _builder.append((Object)_dbName);
                        _builder.append((Object)"\";");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"org.sqlproc.engine.SqlCrudEngine");
                        _builder.append((Object)" sqlGetEngine");
                        String _name = pojo.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(sqlName);");
                        _builder.newLineIfNotEmpty();
                        boolean _isEmpty = moreResultClasses.isEmpty();
                        if (_isEmpty) {
                            _builder.append((Object)"//");
                        }
                        _builder.append((Object)"sqlControl = getMoreResultClasses(");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                        String _name_1 = pojo.getName();
                        _builder.append((Object)_name_1);
                        _builder.append((Object)" ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)"Got = sqlGetEngine");
                        String _name_2 = pojo.getName();
                        _builder.append((Object)_name_2);
                        _builder.append((Object)".get(sqlSession, ");
                        String _name_3 = pojo.getName();
                        _builder.append((Object)_name_3);
                        _builder.append((Object)".class, ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql get ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)" result: \" + ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)"Got);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"return ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)"Got;");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "get", this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]), (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return get(sqlSessionFactory.getSqlSession(), ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "get", this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]), (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return get(sqlSession, ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "get", this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]), (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return get(");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "get", this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]), (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferGetIfx(final DaoEntity entity, DaoDirectiveCrud dir, JvmGenericType entityType, String simpleName, PojoEntity pojo, final JvmGenericType pojoType, List<JvmMember> members, Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        final String pojoAttrName = StringExtensions.toFirstLower((String)pojo.getName());
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "get", this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]), (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "get", this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]), (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "get", this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]), (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "get", this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]), (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferUpdate(final DaoEntity entity, DaoDirectiveCrud dir, JvmGenericType entityType, String simpleName, final PojoEntity pojo, final JvmGenericType pojoType, List<JvmMember> members) {
        final String pojoAttrName = StringExtensions.toFirstLower((String)pojo.getName());
        final PojoEntity parent = this._processorGeneratorUtils.getParentReflectInheritance(pojo);
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        PojoAttribute f;
                        boolean _notEquals_2;
                        boolean _notEquals_1;
                        boolean _notEquals;
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql update ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)": \" + ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)" + \" \" + sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"String sqlName = (sqlControl != null && sqlControl.getSqlName() != null) ? sqlControl.getSqlName() : \"UPDATE_");
                        String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(pojo.getName());
                        _builder.append((Object)_dbName);
                        _builder.append((Object)"\";");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"org.sqlproc.engine.SqlCrudEngine");
                        _builder.append((Object)" sqlUpdateEngine");
                        String _name = pojo.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(sqlName);");
                        boolean bl = _notEquals = !Objects.equal((Object)parent, null);
                        if (_notEquals) {
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"org.sqlproc.engine.SqlCrudEngine");
                            _builder.append((Object)" sqlUpdate");
                            String _name_1 = parent.getName();
                            _builder.append((Object)_name_1);
                            _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"UPDATE_");
                            String _dbName_1 = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(parent.getName());
                            _builder.append((Object)_dbName_1);
                            _builder.append((Object)"\");");
                        }
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"int count = sqlUpdateEngine");
                        String _name_2 = pojo.getName();
                        _builder.append((Object)_name_2);
                        _builder.append((Object)".update(sqlSession, ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", sqlControl);");
                        boolean bl2 = _notEquals_1 = !Objects.equal((Object)parent, null);
                        if (_notEquals_1) {
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"if (count > 0) {");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"sqlUpdate");
                            String _name_3 = parent.getName();
                            _builder.append((Object)_name_3, "\t");
                            _builder.append((Object)".update(sqlSession, ");
                            _builder.append((Object)pojoAttrName, "\t");
                            _builder.append((Object)", sqlControl);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"}");
                        }
                        boolean bl3 = _notEquals_2 = !Objects.equal((Object)(f = DaoJvmModelInferrer.this._processorGeneratorUtils.getOptLock(pojo)), null);
                        if (_notEquals_2) {
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"if (count > 0) {");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)pojoAttrName, "\t");
                            _builder.append((Object)".set");
                            String _firstUpper = DaoJvmModelInferrer.this._processorTypesBuilder.toFirstUpper(f.getName());
                            _builder.append((Object)_firstUpper, "\t");
                            _builder.append((Object)"(");
                            _builder.append((Object)pojoAttrName, "\t");
                            _builder.append((Object)".get");
                            String _firstUpper_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toFirstUpper(f.getName());
                            _builder.append((Object)_firstUpper_1, "\t");
                            _builder.append((Object)"() + 1);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"}");
                        }
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql update ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)" result count: \" + count);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"return count;");
                        _builder.newLine();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "update", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return update(sqlSessionFactory.getSqlSession(), ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "update", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return update(sqlSession, ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "update", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return update(");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "update", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferUpdateIfx(final DaoEntity entity, DaoDirectiveCrud dir, JvmGenericType entityType, String simpleName, PojoEntity pojo, final JvmGenericType pojoType, List<JvmMember> members) {
        final String pojoAttrName = StringExtensions.toFirstLower((String)pojo.getName());
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "update", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "update", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "update", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "update", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferDelete(final DaoEntity entity, DaoDirectiveCrud dir, JvmGenericType entityType, String simpleName, final PojoEntity pojo, final JvmGenericType pojoType, List<JvmMember> members) {
        final String pojoAttrName = StringExtensions.toFirstLower((String)pojo.getName());
        final PojoEntity parent = this._processorGeneratorUtils.getParentReflectInheritance(pojo);
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        PojoAttribute f;
                        boolean _notEquals_2;
                        boolean _notEquals_1;
                        boolean _notEquals;
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql delete ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)": \" + ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)" + \" \" + sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"String sqlName = (sqlControl != null && sqlControl.getSqlName() != null) ? sqlControl.getSqlName() : \"DELETE_");
                        String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(pojo.getName());
                        _builder.append((Object)_dbName);
                        _builder.append((Object)"\";");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"org.sqlproc.engine.SqlCrudEngine");
                        _builder.append((Object)" sqlDeleteEngine");
                        String _name = pojo.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(sqlName);");
                        boolean bl = _notEquals = !Objects.equal((Object)parent, null);
                        if (_notEquals) {
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"org.sqlproc.engine.SqlCrudEngine");
                            _builder.append((Object)" sqlDelete");
                            String _name_1 = parent.getName();
                            _builder.append((Object)_name_1);
                            _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"DELETE_");
                            String _dbName_1 = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(parent.getName());
                            _builder.append((Object)_dbName_1);
                            _builder.append((Object)"\");");
                        }
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"int count = sqlDeleteEngine");
                        String _name_2 = pojo.getName();
                        _builder.append((Object)_name_2);
                        _builder.append((Object)".delete(sqlSession, ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", sqlControl);");
                        boolean bl2 = _notEquals_1 = !Objects.equal((Object)parent, null);
                        if (_notEquals_1) {
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"if (count > 0) {");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"sqlDelete");
                            String _name_3 = parent.getName();
                            _builder.append((Object)_name_3, "\t");
                            _builder.append((Object)".delete(sqlSession, ");
                            _builder.append((Object)pojoAttrName, "\t");
                            _builder.append((Object)", sqlControl);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"}");
                        }
                        boolean bl3 = _notEquals_2 = !Objects.equal((Object)(f = DaoJvmModelInferrer.this._processorGeneratorUtils.getOptLock(pojo)), null);
                        if (_notEquals_2) {
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"if (count > 0) {");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)pojoAttrName, "\t");
                            _builder.append((Object)".set");
                            String _firstUpper = DaoJvmModelInferrer.this._processorTypesBuilder.toFirstUpper(f.getName());
                            _builder.append((Object)_firstUpper, "\t");
                            _builder.append((Object)"(");
                            _builder.append((Object)pojoAttrName, "\t");
                            _builder.append((Object)".get");
                            String _firstUpper_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toFirstUpper(f.getName());
                            _builder.append((Object)_firstUpper_1, "\t");
                            _builder.append((Object)"() + 1);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"}");
                        }
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql delete ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)" result count: \" + count);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"return count;");
                        _builder.newLine();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "delete", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return delete(sqlSessionFactory.getSqlSession(), ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "delete", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return delete(sqlSession, ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "delete", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return delete(");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "delete", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferDeleteIfx(final DaoEntity entity, DaoDirectiveCrud dir, JvmGenericType entityType, String simpleName, PojoEntity pojo, final JvmGenericType pojoType, List<JvmMember> members) {
        final String pojoAttrName = StringExtensions.toFirstLower((String)pojo.getName());
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "delete", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "delete", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "delete", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "delete", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferList(final DaoEntity entity, DaoDirectiveQuery dir, JvmGenericType entityType, String simpleName, final PojoEntity pojo, final JvmGenericType pojoType, List<JvmMember> members, final Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        final String pojoAttrName = StringExtensions.toFirstLower((String)pojo.getName());
        JvmTypeReference listType = this._typeReferenceBuilder.typeRef(List.class, new JvmTypeReference[]{this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0])});
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql list ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)": \" + ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)" + \" \" + sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"String sqlName = (sqlControl != null && sqlControl.getSqlName() != null) ? sqlControl.getSqlName() : \"SELECT_");
                        String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(pojo.getName());
                        _builder.append((Object)_dbName);
                        _builder.append((Object)"\";");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"org.sqlproc.engine.SqlQueryEngine");
                        _builder.append((Object)" sqlEngine");
                        String _name = pojo.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)" = sqlEngineFactory.getCheckedQueryEngine(sqlName);");
                        _builder.newLineIfNotEmpty();
                        boolean _isEmpty = moreResultClasses.isEmpty();
                        if (_isEmpty) {
                            _builder.append((Object)"//");
                        }
                        _builder.append((Object)"sqlControl = getMoreResultClasses(");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"List<");
                        String _name_1 = pojo.getName();
                        _builder.append((Object)_name_1);
                        _builder.append((Object)"> ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)"List = sqlEngine");
                        String _name_2 = pojo.getName();
                        _builder.append((Object)_name_2);
                        _builder.append((Object)".query(sqlSession, ");
                        String _name_3 = pojo.getName();
                        _builder.append((Object)_name_3);
                        _builder.append((Object)".class, ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql list ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)" size: \" + ((");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)"List != null) ? ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)"List.size() : \"null\"));");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"return ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)"List;");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "list", listType, (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return list(sqlSessionFactory.getSqlSession(), ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "list", listType, (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return list(sqlSession, ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "list", listType, (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return list(");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "list", listType, (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferListIfx(final DaoEntity entity, DaoDirectiveQuery dir, JvmGenericType entityType, String simpleName, PojoEntity pojo, final JvmGenericType pojoType, List<JvmMember> members, Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        final String pojoAttrName = StringExtensions.toFirstLower((String)pojo.getName());
        JvmTypeReference listType = this._typeReferenceBuilder.typeRef(List.class, new JvmTypeReference[]{this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0])});
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "list", listType, (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "list", listType, (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "list", listType, (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "list", listType, (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferListFromTo(final DaoEntity entity, DaoDirectiveQuery dir, JvmGenericType entityType, String simpleName, final PojoEntity pojo, final JvmGenericType pojoType, List<JvmMember> members, final Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses, final PojoAttribute primaryKey) {
        boolean _notEquals_1;
        boolean _notEquals;
        final String pojoAttrName = StringExtensions.toFirstLower((String)pojo.getName());
        JvmTypeReference listType = this._typeReferenceBuilder.typeRef(List.class, new JvmTypeReference[]{this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0])});
        PojoAttributeDirectivePrimaryKey pkDir = this._processorGeneratorUtils.getPrimaryKeyDir(primaryKey);
        String _xifexpression = null;
        String _type = pkDir.getType();
        boolean bl = _notEquals = !Objects.equal((Object)_type, null);
        if (_notEquals) {
            _xifexpression = pkDir.getType();
        } else {
            JvmParameterizedTypeReference _elvis = null;
            JvmParameterizedTypeReference _elvis_1 = null;
            JvmParameterizedTypeReference _type_1 = primaryKey.getType();
            if (_type_1 != null) {
                _elvis_1 = _type_1;
            } else {
                XExpression _initExpr = primaryKey.getInitExpr();
                JvmTypeReference _inferredType = null;
                if (_initExpr != null) {
                    _inferredType = this._processorTypesBuilder.inferredType(_initExpr);
                }
                _elvis_1 = _inferredType;
            }
            if (_elvis_1 != null) {
                _elvis = _elvis_1;
            } else {
                JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(String.class, new JvmTypeReference[0]);
                _elvis = _typeRef;
            }
            _xifexpression = _elvis.getQualifiedName();
        }
        final String pkType = _xifexpression;
        String _xifexpression_1 = null;
        String _name = pkDir.getName();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_name, null);
        if (_notEquals_1) {
            String _firstUpper = this._processorTypesBuilder.toFirstUpper(pkDir.getName());
            String _plus = ".get" + _firstUpper;
            _xifexpression_1 = String.valueOf(_plus) + "()";
        } else {
            _xifexpression_1 = "";
        }
        final String pkGetDep = _xifexpression_1;
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (sqlControl == null || sqlControl.getFirstResult() == null || sqlControl.getMaxResults() == null || ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)" == null)");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"return list(sqlSession, ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.newLine();
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql list ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)": \" + ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)" + \" \" + sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"String sqlName = (sqlControl != null && sqlControl.getSqlName() != null) ? sqlControl.getSqlName() : \"SELECT_");
                        String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(pojo.getName());
                        _builder.append((Object)_dbName);
                        _builder.append((Object)"\";");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"org.sqlproc.engine.SqlQueryEngine");
                        _builder.append((Object)" sqlEngine");
                        String _name = pojo.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)" = sqlEngineFactory.getCheckedQueryEngine(sqlName);");
                        _builder.newLineIfNotEmpty();
                        boolean _isEmpty = moreResultClasses.isEmpty();
                        if (_isEmpty) {
                            _builder.append((Object)"//");
                        }
                        _builder.append((Object)"sqlControl = getMoreResultClasses(");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)".setOnlyIds_(true);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"java.util.Set");
                        _builder.append((Object)"<String> initAssociations = ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)".getInitAssociations_();");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)".setInitAssociations_(new ");
                        _builder.append((Object)"java.util.HashSet");
                        _builder.append((Object)"<String>());");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"final ");
                        _builder.append((Object)"java.util.List");
                        _builder.append((Object)"<");
                        String _wrapperPrimitive = DaoJvmModelInferrer.this._processorGeneratorUtils.wrapperPrimitive(pkType);
                        _builder.append((Object)_wrapperPrimitive);
                        _builder.append((Object)"> ids_ = sqlEngine");
                        String _name_1 = pojo.getName();
                        _builder.append((Object)_name_1);
                        _builder.append((Object)".query(sqlSession, ");
                        _builder.append((Object)pkType);
                        _builder.append((Object)".class, ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)".setInitAssociations_(initAssociations);");
                        _builder.newLineIfNotEmpty();
                        _builder.newLine();
                        _builder.append((Object)"List<");
                        String _name_2 = pojo.getName();
                        _builder.append((Object)_name_2);
                        _builder.append((Object)"> ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)"List = new ");
                        _builder.append((Object)"java.util.ArrayList");
                        _builder.append((Object)"<");
                        String _name_3 = pojo.getName();
                        _builder.append((Object)_name_3);
                        _builder.append((Object)">();");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"if (!ids_.isEmpty()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"org.sqlproc.engine.impl.SqlStandardControl", "\t");
                        _builder.append((Object)" sqlc = new ");
                        _builder.append((Object)"org.sqlproc.engine.impl.SqlStandardControl", "\t");
                        _builder.append((Object)"(sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"sqlc.setFirstResult(0);");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"sqlc.setMaxResults(0);");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"sqlc.setOrder(null);");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"final ");
                        _builder.append(Map.class, "\t");
                        _builder.append((Object)"<");
                        String _wrapperPrimitive_1 = DaoJvmModelInferrer.this._processorGeneratorUtils.wrapperPrimitive(pkType);
                        _builder.append((Object)_wrapperPrimitive_1, "\t");
                        _builder.append((Object)", ");
                        String _name_4 = pojo.getName();
                        _builder.append((Object)_name_4, "\t");
                        _builder.append((Object)"> map = new ");
                        _builder.append((Object)"java.util.HashMap", "\t");
                        _builder.append((Object)"<");
                        String _wrapperPrimitive_2 = DaoJvmModelInferrer.this._processorGeneratorUtils.wrapperPrimitive(pkType);
                        _builder.append((Object)_wrapperPrimitive_2, "\t");
                        _builder.append((Object)", ");
                        String _name_5 = pojo.getName();
                        _builder.append((Object)_name_5, "\t");
                        _builder.append((Object)">();");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"final SqlRowProcessor<");
                        String _name_6 = pojo.getName();
                        _builder.append((Object)_name_6, "\t");
                        _builder.append((Object)"> sqlRowProcessor = new SqlRowProcessor<");
                        String _name_7 = pojo.getName();
                        _builder.append((Object)_name_7, "\t");
                        _builder.append((Object)">() {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"@Override");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"public boolean processRow(");
                        String _name_8 = pojo.getName();
                        _builder.append((Object)_name_8, "\t\t");
                        _builder.append((Object)" result, int rownum) throws ");
                        _builder.append((Object)"org.sqlproc.engine.SqlRuntimeException", "\t\t");
                        _builder.append((Object)" {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t\t");
                        _builder.append((Object)"map.put(result.get");
                        String _firstUpper = DaoJvmModelInferrer.this._processorTypesBuilder.toFirstUpper(primaryKey.getName());
                        _builder.append((Object)_firstUpper, "\t\t\t");
                        _builder.append((Object)"()");
                        _builder.append((Object)pkGetDep, "\t\t\t");
                        _builder.append((Object)", result);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t\t");
                        _builder.append((Object)"return true;");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"};");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"sqlEngine");
                        String _name_9 = pojo.getName();
                        _builder.append((Object)_name_9, "\t");
                        _builder.append((Object)".query(sqlSession, ");
                        String _name_10 = pojo.getName();
                        _builder.append((Object)_name_10, "\t");
                        _builder.append((Object)".class, new ");
                        String _name_11 = pojo.getName();
                        _builder.append((Object)_name_11, "\t");
                        _builder.append((Object)"().withIds_(ids_).withInit_(initAssociations.toArray(new String[initAssociations.size()])), sqlc, sqlRowProcessor);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"for (");
                        _builder.append((Object)pkType, "\t");
                        _builder.append((Object)" id : ids_)");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)pojoAttrName, "\t\t");
                        _builder.append((Object)"List.add(map.get(id));");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql list ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)" size: \" + ((");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)"List != null) ? ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)"List.size() : \"null\"));");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"return ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)"List;");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "listFromTo", listType, (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return listFromTo(sqlSessionFactory.getSqlSession(), ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "listFromTo", listType, (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return listFromTo(sqlSession, ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "listFromTo", listType, (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return listFromTo(");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "listFromTo", listType, (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferListFromToIfx(final DaoEntity entity, DaoDirectiveQuery dir, JvmGenericType entityType, String simpleName, PojoEntity pojo, final JvmGenericType pojoType, List<JvmMember> members, Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        final String pojoAttrName = StringExtensions.toFirstLower((String)pojo.getName());
        JvmTypeReference listType = this._typeReferenceBuilder.typeRef(List.class, new JvmTypeReference[]{this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0])});
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "listFromTo", listType, (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "listFromTo", listType, (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "listFromTo", listType, (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "listFromTo", listType, (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferQuery(final DaoEntity entity, DaoDirectiveQuery dir, JvmGenericType entityType, String simpleName, final PojoEntity pojo, final JvmGenericType pojoType, List<JvmMember> members, final Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        final String pojoAttrName = StringExtensions.toFirstLower((String)pojo.getName());
        final JvmTypeReference srpType = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlRowProcessor", new JvmTypeReference[]{this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0])});
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
                EList _parameters_3 = it.getParameters();
                JvmFormalParameter _parameter_3 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlRowProcessor", srpType);
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_3, _parameter_3);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql query ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)": \" + ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)" + \" \" + sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"String sqlName = (sqlControl != null && sqlControl.getSqlName() != null) ? sqlControl.getSqlName() : \"SELECT_");
                        String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(pojo.getName());
                        _builder.append((Object)_dbName);
                        _builder.append((Object)"\";");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"org.sqlproc.engine.SqlQueryEngine");
                        _builder.append((Object)" sqlEngine");
                        String _name = pojo.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)" = sqlEngineFactory.getCheckedQueryEngine(sqlName);");
                        _builder.newLineIfNotEmpty();
                        boolean _isEmpty = moreResultClasses.isEmpty();
                        if (_isEmpty) {
                            _builder.append((Object)"//");
                        }
                        _builder.append((Object)"sqlControl = getMoreResultClasses(");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"int rownums = sqlEngine");
                        String _name_1 = pojo.getName();
                        _builder.append((Object)_name_1);
                        _builder.append((Object)".query(sqlSession, ");
                        String _name_2 = pojo.getName();
                        _builder.append((Object)_name_2);
                        _builder.append((Object)".class, ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", sqlControl, sqlRowProcessor);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql query ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)" size: \" + rownums);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"return rownums;");
                        _builder.newLine();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "query", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlRowProcessor", srpType);
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return query(sqlSessionFactory.getSqlSession(), ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", sqlControl, sqlRowProcessor);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "query", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlRowProcessor", srpType);
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return query(sqlSession, ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", null, sqlRowProcessor);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "query", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlRowProcessor", srpType);
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return query(");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", null, sqlRowProcessor);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "query", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferQueryIfx(final DaoEntity entity, DaoDirectiveQuery dir, JvmGenericType entityType, String simpleName, PojoEntity pojo, final JvmGenericType pojoType, List<JvmMember> members, Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        final String pojoAttrName = StringExtensions.toFirstLower((String)pojo.getName());
        final JvmTypeReference srpType = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlRowProcessor", new JvmTypeReference[]{this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0])});
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
                EList _parameters_3 = it.getParameters();
                JvmFormalParameter _parameter_3 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlRowProcessor", srpType);
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_3, _parameter_3);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "query", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlRowProcessor", srpType);
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "query", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlRowProcessor", srpType);
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "query", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlRowProcessor", srpType);
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "query", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferCount(final DaoEntity entity, DaoDirectiveQuery dir, JvmGenericType entityType, String simpleName, final PojoEntity pojo, final JvmGenericType pojoType, List<JvmMember> members, final Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        final String pojoAttrName = StringExtensions.toFirstLower((String)pojo.getName());
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"count ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)": \" + ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)" + \" \" + sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"String sqlName = (sqlControl != null && sqlControl.getSqlName() != null) ? sqlControl.getSqlName() : \"SELECT_");
                        String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(pojo.getName());
                        _builder.append((Object)_dbName);
                        _builder.append((Object)"\";");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"org.sqlproc.engine.SqlQueryEngine");
                        _builder.append((Object)" sqlEngine");
                        String _name = pojo.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)" = sqlEngineFactory.getCheckedQueryEngine(sqlName);");
                        _builder.newLineIfNotEmpty();
                        boolean _isEmpty = moreResultClasses.isEmpty();
                        if (_isEmpty) {
                            _builder.append((Object)"//");
                        }
                        _builder.append((Object)"sqlControl = getMoreResultClasses(");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"int count = sqlEngine");
                        String _name_1 = pojo.getName();
                        _builder.append((Object)_name_1);
                        _builder.append((Object)".queryCount(sqlSession, ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"count: \" + count);");
                        _builder.newLine();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"return count;");
                        _builder.newLine();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "count", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return count(sqlSessionFactory.getSqlSession(), ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "count", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return count(sqlSession, ");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "count", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return count(");
                        _builder.append((Object)pojoAttrName);
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "count", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferCountIfx(final DaoEntity entity, DaoDirectiveQuery dir, JvmGenericType entityType, String simpleName, PojoEntity pojo, final JvmGenericType pojoType, List<JvmMember> members, Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        final String pojoAttrName = StringExtensions.toFirstLower((String)pojo.getName());
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "count", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "count", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "count", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "count", this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferMoreResultClasses(final DaoEntity entity, JvmGenericType entityType, String simpleName, final PojoEntity pojo, final JvmGenericType pojoType, List<JvmMember> members, final Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        final String pojoAttrName = StringExtensions.toFirstLower((String)pojo.getName());
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (sqlControl != null && sqlControl.getMoreResultClasses() != null)");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"return sqlControl;");
                        _builder.newLine();
                        _builder.append((Object)"java.util.Map");
                        _builder.append((Object)"<String, Class<?>> moreResultClasses = null;");
                        _builder.newLineIfNotEmpty();
                        Set _entrySet = moreResultClasses.entrySet();
                        for (Map.Entry f : _entrySet) {
                            _builder.append((Object)"if (");
                            _builder.append((Object)pojoAttrName);
                            _builder.append((Object)" != null && ");
                            _builder.append((Object)pojoAttrName);
                            _builder.append((Object)".toInit_(");
                            String _name = pojo.getName();
                            _builder.append((Object)_name);
                            _builder.append((Object)".Association.");
                            String _key = (String)f.getKey();
                            _builder.append((Object)_key);
                            _builder.append((Object)".name())) {");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"if (moreResultClasses == null)");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"moreResultClasses = new ");
                            _builder.append((Object)"java.util.HashMap", "\t\t");
                            _builder.append((Object)"<String, Class<?>>();");
                            _builder.newLineIfNotEmpty();
                            Set _entrySet_1 = ((Map)f.getValue()).entrySet();
                            for (Map.Entry a : _entrySet_1) {
                                _builder.append((Object)"\t");
                                _builder.append((Object)"moreResultClasses.put(\"");
                                String _key_1 = (String)a.getKey();
                                _builder.append((Object)_key_1, "\t");
                                _builder.append((Object)"\", ");
                                JvmParameterizedTypeReference _value = (JvmParameterizedTypeReference)a.getValue();
                                _builder.append((Object)_value, "\t");
                                _builder.append((Object)".class);");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append((Object)"}");
                            _builder.newLine();
                        }
                        _builder.append((Object)"if (moreResultClasses != null) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"sqlControl = new ");
                        _builder.append((Object)"org.sqlproc.engine.impl.SqlStandardControl", "\t");
                        _builder.append((Object)"(sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"((");
                        _builder.append((Object)"org.sqlproc.engine.impl.SqlStandardControl", "\t");
                        _builder.append((Object)") sqlControl).setMoreResultClasses(moreResultClasses);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"return sqlControl;");
                        _builder.newLine();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "getMoreResultClasses", this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]), (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
    }

    public void inferMoreResultClassesIfx(final DaoEntity entity, JvmGenericType entityType, String simpleName, PojoEntity pojo, final JvmGenericType pojoType, List<JvmMember> members, Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        final String pojoAttrName = StringExtensions.toFirstLower((String)pojo.getName());
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, pojoAttrName, DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "getMoreResultClasses", this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]), (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
    }

    protected void _inferFunctionProcedure(final DaoEntity entity, FunctionCallQuery type, final DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        JvmTypeReference listType = this._typeReferenceBuilder.typeRef(params.getOut().getType(), (JvmTypeReference[])Conversions.unwrapArray((Object)params.getOut().getArguments(), JvmTypeReference.class));
        final String fname = this._processorGeneratorUtils.getFunProcName(entity);
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters_1 = it.getParameters();
                    JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                }
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql ");
                        _builder.append((Object)fname, "\t");
                        _builder.append((Object)": \" + ");
                        EList<JvmParameterizedTypeReference> _ins = params.getIns();
                        boolean _hasElements = false;
                        for (JvmParameterizedTypeReference in : _ins) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)" + \" \" ", "\t");
                            }
                            String _firstLower = StringExtensions.toFirstLower((String)in.getSimpleName());
                            _builder.append((Object)_firstLower, "\t");
                        }
                        _builder.append((Object)" + \" \" + sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"org.sqlproc.engine.SqlProcedureEngine");
                        _builder.append((Object)" sqlFun");
                        String _name = entity.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)" = sqlEngineFactory.getCheckedProcedureEngine(\"FUN_");
                        String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(fname);
                        _builder.append((Object)_dbName);
                        _builder.append((Object)"\");");
                        _builder.newLineIfNotEmpty();
                        String _simpleName = DaoJvmModelInferrer.this._processorGeneratorUtils.getSimpleName(params.getOut());
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)" list = sqlFun");
                        String _name_1 = entity.getName();
                        _builder.append((Object)_name_1);
                        _builder.append((Object)".callQuery(sqlSession, ");
                        String _simpleName_1 = ((JvmTypeReference)IterableExtensions.head((Iterable)params.getOut().getArguments())).getSimpleName();
                        _builder.append((Object)_simpleName_1);
                        _builder.append((Object)".class, ");
                        EList<JvmParameterizedTypeReference> _ins_1 = params.getIns();
                        boolean _hasElements_1 = false;
                        for (JvmParameterizedTypeReference in_1 : _ins_1) {
                            if (!_hasElements_1) {
                                _hasElements_1 = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            String _firstLower_1 = StringExtensions.toFirstLower((String)in_1.getSimpleName());
                            _builder.append((Object)_firstLower_1);
                        }
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql ");
                        _builder.append((Object)fname, "\t");
                        _builder.append((Object)" result: \" + list);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"return list;");
                        _builder.newLine();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, fname, listType, (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters = it.getParameters();
                    JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                }
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return ");
                        _builder.append((Object)fname);
                        _builder.append((Object)"(sqlSessionFactory.getSqlSession(), ");
                        EList<JvmParameterizedTypeReference> _ins = params.getIns();
                        boolean _hasElements = false;
                        for (JvmParameterizedTypeReference in : _ins) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            String _firstLower = StringExtensions.toFirstLower((String)in.getSimpleName());
                            _builder.append((Object)_firstLower);
                        }
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, fname, listType, (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters_1 = it.getParameters();
                    JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                }
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return ");
                        _builder.append((Object)fname);
                        _builder.append((Object)"(sqlSession, ");
                        EList<JvmParameterizedTypeReference> _ins = params.getIns();
                        boolean _hasElements = false;
                        for (JvmParameterizedTypeReference in : _ins) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            String _firstLower = StringExtensions.toFirstLower((String)in.getSimpleName());
                            _builder.append((Object)_firstLower);
                        }
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, fname, listType, (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters = it.getParameters();
                    JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                }
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return ");
                        _builder.append((Object)fname);
                        _builder.append((Object)"(");
                        EList<JvmParameterizedTypeReference> _ins = params.getIns();
                        boolean _hasElements = false;
                        for (JvmParameterizedTypeReference in : _ins) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            String _firstLower = StringExtensions.toFirstLower((String)in.getSimpleName());
                            _builder.append((Object)_firstLower);
                        }
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, fname, listType, (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    protected void _inferFunctionProcedureIfx(final DaoEntity entity, FunctionCallQuery type, final DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        JvmTypeReference listType = this._typeReferenceBuilder.typeRef(params.getOut().getType(), (JvmTypeReference[])Conversions.unwrapArray((Object)params.getOut().getArguments(), JvmTypeReference.class));
        String fname = this._processorGeneratorUtils.getFunProcName(entity);
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters_1 = it.getParameters();
                    JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                }
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, fname, listType, (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters = it.getParameters();
                    JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                }
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, fname, listType, (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters_1 = it.getParameters();
                    JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                }
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, fname, listType, (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters = it.getParameters();
                    JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                }
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, fname, listType, (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    protected void _inferFunctionProcedure(final DaoEntity entity, ProcedureCallQuery type, final DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        JvmTypeReference listType = this._typeReferenceBuilder.typeRef(params.getOut().getType(), (JvmTypeReference[])Conversions.unwrapArray((Object)params.getOut().getArguments(), JvmTypeReference.class));
        final String fname = this._processorGeneratorUtils.getFunProcName(entity);
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters_1 = it.getParameters();
                    JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                }
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql ");
                        _builder.append((Object)fname, "\t");
                        _builder.append((Object)": \" + ");
                        EList<JvmParameterizedTypeReference> _ins = params.getIns();
                        boolean _hasElements = false;
                        for (JvmParameterizedTypeReference in : _ins) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)" + \" \" ", "\t");
                            }
                            String _firstLower = StringExtensions.toFirstLower((String)in.getSimpleName());
                            _builder.append((Object)_firstLower, "\t");
                        }
                        _builder.append((Object)" + \" \" + sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"org.sqlproc.engine.SqlProcedureEngine");
                        _builder.append((Object)" sqlProc");
                        String _name = entity.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)" = sqlEngineFactory.getCheckedProcedureEngine(\"PROC_");
                        String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(fname);
                        _builder.append((Object)_dbName);
                        _builder.append((Object)"\");");
                        _builder.newLineIfNotEmpty();
                        String _simpleName = DaoJvmModelInferrer.this._processorGeneratorUtils.getSimpleName(params.getOut());
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)" list = sqlProc");
                        String _name_1 = entity.getName();
                        _builder.append((Object)_name_1);
                        _builder.append((Object)".callQuery(sqlSession, ");
                        String _simpleName_1 = ((JvmTypeReference)IterableExtensions.head((Iterable)params.getOut().getArguments())).getSimpleName();
                        _builder.append((Object)_simpleName_1);
                        _builder.append((Object)".class, ");
                        EList<JvmParameterizedTypeReference> _ins_1 = params.getIns();
                        boolean _hasElements_1 = false;
                        for (JvmParameterizedTypeReference in_1 : _ins_1) {
                            if (!_hasElements_1) {
                                _hasElements_1 = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            String _firstLower_1 = StringExtensions.toFirstLower((String)in_1.getSimpleName());
                            _builder.append((Object)_firstLower_1);
                        }
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql ");
                        _builder.append((Object)fname, "\t");
                        _builder.append((Object)" result: \" + list);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"return list;");
                        _builder.newLine();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, fname, listType, (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters = it.getParameters();
                    JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                }
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return ");
                        _builder.append((Object)fname);
                        _builder.append((Object)"(sqlSessionFactory.getSqlSession(), ");
                        EList<JvmParameterizedTypeReference> _ins = params.getIns();
                        boolean _hasElements = false;
                        for (JvmParameterizedTypeReference in : _ins) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            String _firstLower = StringExtensions.toFirstLower((String)in.getSimpleName());
                            _builder.append((Object)_firstLower);
                        }
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, fname, listType, (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters_1 = it.getParameters();
                    JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                }
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return ");
                        _builder.append((Object)fname);
                        _builder.append((Object)"(sqlSession, ");
                        EList<JvmParameterizedTypeReference> _ins = params.getIns();
                        boolean _hasElements = false;
                        for (JvmParameterizedTypeReference in : _ins) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            String _firstLower = StringExtensions.toFirstLower((String)in.getSimpleName());
                            _builder.append((Object)_firstLower);
                        }
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, fname, listType, (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters = it.getParameters();
                    JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                }
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return ");
                        _builder.append((Object)fname);
                        _builder.append((Object)"(");
                        EList<JvmParameterizedTypeReference> _ins = params.getIns();
                        boolean _hasElements = false;
                        for (JvmParameterizedTypeReference in : _ins) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            String _firstLower = StringExtensions.toFirstLower((String)in.getSimpleName());
                            _builder.append((Object)_firstLower);
                        }
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, fname, listType, (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    protected void _inferFunctionProcedureIfx(final DaoEntity entity, ProcedureCallQuery type, final DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        JvmTypeReference listType = this._typeReferenceBuilder.typeRef(params.getOut().getType(), (JvmTypeReference[])Conversions.unwrapArray((Object)params.getOut().getArguments(), JvmTypeReference.class));
        String fname = this._processorGeneratorUtils.getFunProcName(entity);
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters_1 = it.getParameters();
                    JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                }
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, fname, listType, (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters = it.getParameters();
                    JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                }
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, fname, listType, (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters_1 = it.getParameters();
                    JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                }
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, fname, listType, (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters = it.getParameters();
                    JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                }
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, fname, listType, (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    protected void _inferFunctionProcedure(final DaoEntity entity, FunctionCall type, final DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        JvmTypeReference outType = this._typeReferenceBuilder.typeRef(params.getOut().getType(), (JvmTypeReference[])Conversions.unwrapArray((Object)params.getOut().getArguments(), JvmTypeReference.class));
        final String fname = this._processorGeneratorUtils.getFunProcName(entity);
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters_1 = it.getParameters();
                    JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                }
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql ");
                        _builder.append((Object)fname, "\t");
                        _builder.append((Object)": \" + ");
                        EList<JvmParameterizedTypeReference> _ins = params.getIns();
                        boolean _hasElements = false;
                        for (JvmParameterizedTypeReference in : _ins) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)" + \" \" ", "\t");
                            }
                            String _firstLower = StringExtensions.toFirstLower((String)in.getSimpleName());
                            _builder.append((Object)_firstLower, "\t");
                        }
                        _builder.append((Object)" + \" \" + sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"org.sqlproc.engine.SqlProcedureEngine");
                        _builder.append((Object)" sqlFun");
                        String _name = entity.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)" = sqlEngineFactory.getCheckedProcedureEngine(\"FUN_");
                        String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(fname);
                        _builder.append((Object)_dbName);
                        _builder.append((Object)"\");");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"Object result = sqlFun");
                        String _name_1 = entity.getName();
                        _builder.append((Object)_name_1);
                        _builder.append((Object)".callFunction(sqlSession, ");
                        EList<JvmParameterizedTypeReference> _ins_1 = params.getIns();
                        boolean _hasElements_1 = false;
                        for (JvmParameterizedTypeReference in_1 : _ins_1) {
                            if (!_hasElements_1) {
                                _hasElements_1 = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            String _firstLower_1 = StringExtensions.toFirstLower((String)in_1.getSimpleName());
                            _builder.append((Object)_firstLower_1);
                        }
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql ");
                        _builder.append((Object)fname, "\t");
                        _builder.append((Object)" result: \" + result);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"return (");
                        String _simpleName = DaoJvmModelInferrer.this._processorGeneratorUtils.getSimpleName(params.getOut());
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)") result;");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, fname, outType, (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters = it.getParameters();
                    JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                }
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return ");
                        _builder.append((Object)fname);
                        _builder.append((Object)"(sqlSessionFactory.getSqlSession(), ");
                        EList<JvmParameterizedTypeReference> _ins = params.getIns();
                        boolean _hasElements = false;
                        for (JvmParameterizedTypeReference in : _ins) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            String _firstLower = StringExtensions.toFirstLower((String)in.getSimpleName());
                            _builder.append((Object)_firstLower);
                        }
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, fname, outType, (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters_1 = it.getParameters();
                    JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                }
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return ");
                        _builder.append((Object)fname);
                        _builder.append((Object)"(sqlSession, ");
                        EList<JvmParameterizedTypeReference> _ins = params.getIns();
                        boolean _hasElements = false;
                        for (JvmParameterizedTypeReference in : _ins) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            String _firstLower = StringExtensions.toFirstLower((String)in.getSimpleName());
                            _builder.append((Object)_firstLower);
                        }
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, fname, outType, (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters = it.getParameters();
                    JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                }
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return ");
                        _builder.append((Object)fname);
                        _builder.append((Object)"(");
                        EList<JvmParameterizedTypeReference> _ins = params.getIns();
                        boolean _hasElements = false;
                        for (JvmParameterizedTypeReference in : _ins) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            String _firstLower = StringExtensions.toFirstLower((String)in.getSimpleName());
                            _builder.append((Object)_firstLower);
                        }
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, fname, outType, (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    protected void _inferFunctionProcedureIfx(final DaoEntity entity, FunctionCall type, final DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        JvmTypeReference outType = this._typeReferenceBuilder.typeRef(params.getOut().getType(), (JvmTypeReference[])Conversions.unwrapArray((Object)params.getOut().getArguments(), JvmTypeReference.class));
        String fname = this._processorGeneratorUtils.getFunProcName(entity);
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters_1 = it.getParameters();
                    JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                }
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, fname, outType, (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters = it.getParameters();
                    JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                }
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, fname, outType, (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters_1 = it.getParameters();
                    JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                }
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, fname, outType, (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters = it.getParameters();
                    JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                }
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, fname, outType, (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    protected void _inferFunctionProcedure(final DaoEntity entity, ProcedureUpdate type, final DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        final String fname = this._processorGeneratorUtils.getFunProcName(entity);
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters_1 = it.getParameters();
                    JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                }
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql ");
                        _builder.append((Object)fname, "\t");
                        _builder.append((Object)": \" + ");
                        EList<JvmParameterizedTypeReference> _ins = params.getIns();
                        boolean _hasElements = false;
                        for (JvmParameterizedTypeReference in : _ins) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)" + \" \" ", "\t");
                            }
                            String _firstLower = StringExtensions.toFirstLower((String)in.getSimpleName());
                            _builder.append((Object)_firstLower, "\t");
                        }
                        _builder.append((Object)" + \" \" + sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"org.sqlproc.engine.SqlProcedureEngine");
                        _builder.append((Object)" sqlProc");
                        String _name = entity.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)" = sqlEngineFactory.getCheckedProcedureEngine(\"PROC_");
                        String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(fname);
                        _builder.append((Object)_dbName);
                        _builder.append((Object)"\");");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"int count = sqlProc");
                        String _name_1 = entity.getName();
                        _builder.append((Object)_name_1);
                        _builder.append((Object)".callUpdate(sqlSession, ");
                        EList<JvmParameterizedTypeReference> _ins_1 = params.getIns();
                        boolean _hasElements_1 = false;
                        for (JvmParameterizedTypeReference in_1 : _ins_1) {
                            if (!_hasElements_1) {
                                _hasElements_1 = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            String _firstLower_1 = StringExtensions.toFirstLower((String)in_1.getSimpleName());
                            _builder.append((Object)_firstLower_1);
                        }
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql ");
                        _builder.append((Object)fname, "\t");
                        _builder.append((Object)" result: \" + count);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"return count;");
                        _builder.newLine();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, fname, this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters = it.getParameters();
                    JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                }
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return ");
                        _builder.append((Object)fname);
                        _builder.append((Object)"(sqlSessionFactory.getSqlSession(), ");
                        EList<JvmParameterizedTypeReference> _ins = params.getIns();
                        boolean _hasElements = false;
                        for (JvmParameterizedTypeReference in : _ins) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            String _firstLower = StringExtensions.toFirstLower((String)in.getSimpleName());
                            _builder.append((Object)_firstLower);
                        }
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, fname, this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters_1 = it.getParameters();
                    JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                }
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return ");
                        _builder.append((Object)fname);
                        _builder.append((Object)"(sqlSession, ");
                        EList<JvmParameterizedTypeReference> _ins = params.getIns();
                        boolean _hasElements = false;
                        for (JvmParameterizedTypeReference in : _ins) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            String _firstLower = StringExtensions.toFirstLower((String)in.getSimpleName());
                            _builder.append((Object)_firstLower);
                        }
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, fname, this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters = it.getParameters();
                    JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                }
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return ");
                        _builder.append((Object)fname);
                        _builder.append((Object)"(");
                        EList<JvmParameterizedTypeReference> _ins = params.getIns();
                        boolean _hasElements = false;
                        for (JvmParameterizedTypeReference in : _ins) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            String _firstLower = StringExtensions.toFirstLower((String)in.getSimpleName());
                            _builder.append((Object)_firstLower);
                        }
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, fname, this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    protected void _inferFunctionProcedureIfx(final DaoEntity entity, ProcedureUpdate type, final DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        String fname = this._processorGeneratorUtils.getFunProcName(entity);
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters_1 = it.getParameters();
                    JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                }
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, fname, this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters = it.getParameters();
                    JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                }
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, fname, this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters_1 = it.getParameters();
                    JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                }
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, fname, this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters = it.getParameters();
                    JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                }
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, fname, this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]), (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    protected void _inferFunctionProcedure(final DaoEntity entity, FunctionQuery type, final DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        JvmTypeReference outType = this._typeReferenceBuilder.typeRef(params.getOut().getType(), (JvmTypeReference[])Conversions.unwrapArray((Object)params.getOut().getArguments(), JvmTypeReference.class));
        final String fname = this._processorGeneratorUtils.getFunProcName(entity);
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters_1 = it.getParameters();
                    JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                }
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql ");
                        _builder.append((Object)fname, "\t");
                        _builder.append((Object)": \" + ");
                        EList<JvmParameterizedTypeReference> _ins = params.getIns();
                        boolean _hasElements = false;
                        for (JvmParameterizedTypeReference in : _ins) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)" + \" \" ", "\t");
                            }
                            String _firstLower = StringExtensions.toFirstLower((String)in.getSimpleName());
                            _builder.append((Object)_firstLower, "\t");
                        }
                        _builder.append((Object)" + \" \" + sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"org.sqlproc.engine.SqlQueryEngine");
                        _builder.append((Object)" sqlFun");
                        String _name = entity.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)" = sqlEngineFactory.getCheckedQueryEngine(\"FUN_");
                        String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(fname);
                        _builder.append((Object)_dbName);
                        _builder.append((Object)"\");");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"java.util.List");
                        _builder.append((Object)"<");
                        String _simpleName = ((JvmParameterizedTypeReference)IterableExtensions.head(params.getIns())).getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)"> list = sqlFun");
                        String _name_1 = entity.getName();
                        _builder.append((Object)_name_1);
                        _builder.append((Object)".query(sqlSession, ");
                        String _simpleName_1 = ((JvmParameterizedTypeReference)IterableExtensions.head(params.getIns())).getSimpleName();
                        _builder.append((Object)_simpleName_1);
                        _builder.append((Object)".class, ");
                        EList<JvmParameterizedTypeReference> _ins_1 = params.getIns();
                        boolean _hasElements_1 = false;
                        for (JvmParameterizedTypeReference in_1 : _ins_1) {
                            if (!_hasElements_1) {
                                _hasElements_1 = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            String _firstLower_1 = StringExtensions.toFirstLower((String)in_1.getSimpleName());
                            _builder.append((Object)_firstLower_1);
                        }
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"if (logger.isTraceEnabled()) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"logger.trace(\"sql ");
                        _builder.append((Object)fname, "\t");
                        _builder.append((Object)" result: \" + list);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"return (list != null && !list.isEmpty()) ? list.get(0).getResult() : null;");
                        _builder.newLine();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, fname, outType, (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters = it.getParameters();
                    JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                }
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return ");
                        _builder.append((Object)fname);
                        _builder.append((Object)"(sqlSessionFactory.getSqlSession(), ");
                        EList<JvmParameterizedTypeReference> _ins = params.getIns();
                        boolean _hasElements = false;
                        for (JvmParameterizedTypeReference in : _ins) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            String _firstLower = StringExtensions.toFirstLower((String)in.getSimpleName());
                            _builder.append((Object)_firstLower);
                        }
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, fname, outType, (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters_1 = it.getParameters();
                    JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                }
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return ");
                        _builder.append((Object)fname);
                        _builder.append((Object)"(sqlSession, ");
                        EList<JvmParameterizedTypeReference> _ins = params.getIns();
                        boolean _hasElements = false;
                        for (JvmParameterizedTypeReference in : _ins) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            String _firstLower = StringExtensions.toFirstLower((String)in.getSimpleName());
                            _builder.append((Object)_firstLower);
                        }
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, fname, outType, (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters = it.getParameters();
                    JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                }
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return ");
                        _builder.append((Object)fname);
                        _builder.append((Object)"(");
                        EList<JvmParameterizedTypeReference> _ins = params.getIns();
                        boolean _hasElements = false;
                        for (JvmParameterizedTypeReference in : _ins) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            String _firstLower = StringExtensions.toFirstLower((String)in.getSimpleName());
                            _builder.append((Object)_firstLower);
                        }
                        _builder.append((Object)", null);");
                        _builder.newLineIfNotEmpty();
                    }
                };
                DaoJvmModelInferrer.this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, fname, outType, (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    protected void _inferFunctionProcedureIfx(final DaoEntity entity, FunctionQuery type, final DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        JvmTypeReference outType = this._typeReferenceBuilder.typeRef(params.getOut().getType(), (JvmTypeReference[])Conversions.unwrapArray((Object)params.getOut().getArguments(), JvmTypeReference.class));
        String fname = this._processorGeneratorUtils.getFunProcName(entity);
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters_1 = it.getParameters();
                    JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                }
                EList _parameters_2 = it.getParameters();
                JvmFormalParameter _parameter_2 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            }
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, fname, outType, (Procedures.Procedure1)_function);
        members.add((JvmMember)_method);
        Procedures.Procedure1<JvmOperation> _function_1 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters = it.getParameters();
                    JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                }
                EList _parameters_1 = it.getParameters();
                JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlControl", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, fname, outType, (Procedures.Procedure1)_function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1<JvmOperation> _function_2 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList _parameters = it.getParameters();
                JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, "sqlSession", DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]));
                DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters_1 = it.getParameters();
                    JvmFormalParameter _parameter_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                }
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, fname, outType, (Procedures.Procedure1)_function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1<JvmOperation> _function_3 = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation it) {
                EList<JvmParameterizedTypeReference> _ins = params.getIns();
                for (JvmParameterizedTypeReference in : _ins) {
                    EList _parameters = it.getParameters();
                    JvmFormalParameter _parameter = DaoJvmModelInferrer.this._processorTypesBuilder.toParameter(entity, StringExtensions.toFirstLower((String)in.getSimpleName()), DaoJvmModelInferrer.this._typeReferenceBuilder.typeRef(in.getType(), new JvmTypeReference[0]));
                    DaoJvmModelInferrer.this._processorTypesBuilder.operator_add(_parameters, _parameter);
                }
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, fname, outType, (Procedures.Procedure1)_function_3);
        members.add((JvmMember)_method_3);
    }

    public QualifiedName daoFullyQualifiedName(DaoEntity entity, String implPackage) {
        boolean _greaterEqualsThan;
        QualifiedName fqname = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)entity);
        boolean _equals = Objects.equal((Object)implPackage, null);
        if (_equals) {
            return fqname;
        }
        int _indexOf = implPackage.indexOf(".");
        boolean bl = _greaterEqualsThan = _indexOf >= 0;
        if (_greaterEqualsThan) {
            String[] segments = implPackage.split(".");
            QualifiedName fqn = QualifiedName.create((String[])segments);
            return fqn.append(fqname.getLastSegment());
        }
        QualifiedName fqn_1 = fqname.skipLast(1);
        fqn_1 = fqn_1.append(implPackage);
        String _lastSegment = fqname.getLastSegment();
        String _plus = String.valueOf(_lastSegment) + "Impl";
        return fqn_1.append(_plus);
    }

    public void inferFunctionProcedure(DaoEntity entity, FunProcType type, DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        if (type instanceof FunctionCall) {
            this._inferFunctionProcedure(entity, (FunctionCall)type, params, entityType, simpleName, members);
            return;
        }
        if (type instanceof FunctionCallQuery) {
            this._inferFunctionProcedure(entity, (FunctionCallQuery)type, params, entityType, simpleName, members);
            return;
        }
        if (type instanceof FunctionQuery) {
            this._inferFunctionProcedure(entity, (FunctionQuery)type, params, entityType, simpleName, members);
            return;
        }
        if (type instanceof ProcedureCallQuery) {
            this._inferFunctionProcedure(entity, (ProcedureCallQuery)type, params, entityType, simpleName, members);
            return;
        }
        if (type instanceof ProcedureUpdate) {
            this._inferFunctionProcedure(entity, (ProcedureUpdate)type, params, entityType, simpleName, members);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(entity, type, params, entityType, simpleName, members).toString());
    }

    public void inferFunctionProcedureIfx(DaoEntity entity, FunProcType type, DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        if (type instanceof FunctionCall) {
            this._inferFunctionProcedureIfx(entity, (FunctionCall)type, params, entityType, simpleName, members);
            return;
        }
        if (type instanceof FunctionCallQuery) {
            this._inferFunctionProcedureIfx(entity, (FunctionCallQuery)type, params, entityType, simpleName, members);
            return;
        }
        if (type instanceof FunctionQuery) {
            this._inferFunctionProcedureIfx(entity, (FunctionQuery)type, params, entityType, simpleName, members);
            return;
        }
        if (type instanceof ProcedureCallQuery) {
            this._inferFunctionProcedureIfx(entity, (ProcedureCallQuery)type, params, entityType, simpleName, members);
            return;
        }
        if (type instanceof ProcedureUpdate) {
            this._inferFunctionProcedureIfx(entity, (ProcedureUpdate)type, params, entityType, simpleName, members);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(entity, type, params, entityType, simpleName, members).toString());
    }
}

