/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.model.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmAnnotationAnnotationValue;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmByteAnnotationValue;
import org.eclipse.xtext.common.types.JvmCharAnnotationValue;
import org.eclipse.xtext.common.types.JvmCustomAnnotationValue;
import org.eclipse.xtext.common.types.JvmDoubleAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmFloatAnnotationValue;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmIntAnnotationValue;
import org.eclipse.xtext.common.types.JvmLongAnnotationValue;
import org.eclipse.xtext.common.types.JvmShortAnnotationValue;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.JvmModelGenerator;
import org.eclipse.xtext.xbase.compiler.XbaseCompiler;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ProcessorModelGenerator
extends JvmModelGenerator {
    @Inject
    private XbaseCompiler compiler;

    public void generateEnumLiteral(JvmEnumerationLiteral it, ITreeAppendable appendable, GeneratorConfig config) {
        super.generateEnumLiteral(it, appendable, config);
        Procedures.Procedure1 _compilationStrategy = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)it);
        if (_compilationStrategy != null) {
            _compilationStrategy.apply((Object)appendable);
        }
    }

    public void generateParameter(JvmFormalParameter it, ITreeAppendable appendable, boolean vararg, GeneratorConfig config) {
        boolean _notEquals;
        String _name = it.getName();
        boolean bl = _notEquals = !Objects.equal((Object)_name, (Object)"sqlControl");
        if (_notEquals) {
            super.generateParameter(it, appendable, vararg, config);
        } else {
            ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
            this.generateAnnotations((Iterable)it.getAnnotations(), tracedAppendable, false, config);
            this._errorSafeExtensions.serializeSafely(it.getParameterType(), "Object", tracedAppendable);
            tracedAppendable.append((CharSequence)" ");
            String name = tracedAppendable.declareVariable((Object)it, this.makeJavaIdentifier(it.getSimpleName()));
            this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it).append((CharSequence)name);
        }
    }

    protected void _toJavaLiteral(JvmCustomAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        boolean _isEmpty = it.getValues().isEmpty();
        if (_isEmpty) {
            appendable.append((CharSequence)"{}");
        } else {
            Procedures.Procedure1<XExpression> _function = new Procedures.Procedure1<XExpression>(){

                public void apply(XExpression it) {
                    if (it instanceof XStringLiteral) {
                        String _doConvertToJavaString = ProcessorModelGenerator.this.doConvertToJavaString(((XStringLiteral)it).getValue());
                        String _plus = "\"" + _doConvertToJavaString;
                        String _plus_1 = String.valueOf(_plus) + "\"";
                        appendable.append((CharSequence)_plus_1);
                    } else if (it instanceof XNumberLiteral) {
                        appendable.append((CharSequence)((XNumberLiteral)it).getValue());
                    } else {
                        ProcessorModelGenerator.this.compiler.toJavaExpression(it, appendable);
                    }
                }
            };
            this._loopExtensions.forEachWithShortcut(appendable, Iterables.filter((Iterable)it.getValues(), XExpression.class), (Procedures.Procedure1)_function);
        }
    }

    public void toJavaLiteral(JvmAnnotationValue it, ITreeAppendable appendable, GeneratorConfig config) {
        if (it instanceof JvmAnnotationAnnotationValue) {
            this._toJavaLiteral((JvmAnnotationAnnotationValue)it, appendable, config);
            return;
        }
        if (it instanceof JvmBooleanAnnotationValue) {
            this._toJavaLiteral((JvmBooleanAnnotationValue)it, appendable, config);
            return;
        }
        if (it instanceof JvmByteAnnotationValue) {
            this._toJavaLiteral((JvmByteAnnotationValue)it, appendable, config);
            return;
        }
        if (it instanceof JvmCharAnnotationValue) {
            this._toJavaLiteral((JvmCharAnnotationValue)it, appendable, config);
            return;
        }
        if (it instanceof JvmCustomAnnotationValue) {
            this._toJavaLiteral((JvmCustomAnnotationValue)it, appendable, config);
            return;
        }
        if (it instanceof JvmDoubleAnnotationValue) {
            this._toJavaLiteral((JvmDoubleAnnotationValue)it, appendable, config);
            return;
        }
        if (it instanceof JvmEnumAnnotationValue) {
            this._toJavaLiteral((JvmEnumAnnotationValue)it, appendable, config);
            return;
        }
        if (it instanceof JvmFloatAnnotationValue) {
            this._toJavaLiteral((JvmFloatAnnotationValue)it, appendable, config);
            return;
        }
        if (it instanceof JvmIntAnnotationValue) {
            this._toJavaLiteral((JvmIntAnnotationValue)it, appendable, config);
            return;
        }
        if (it instanceof JvmLongAnnotationValue) {
            this._toJavaLiteral((JvmLongAnnotationValue)it, appendable, config);
            return;
        }
        if (it instanceof JvmShortAnnotationValue) {
            this._toJavaLiteral((JvmShortAnnotationValue)it, appendable, config);
            return;
        }
        if (it instanceof JvmStringAnnotationValue) {
            this._toJavaLiteral((JvmStringAnnotationValue)it, appendable, config);
            return;
        }
        if (it instanceof JvmTypeAnnotationValue) {
            this._toJavaLiteral((JvmTypeAnnotationValue)it, appendable, config);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, appendable, config).toString());
    }
}

