/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.model.property;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.sqlproc.model.processorModel.AnnotationDefinitionModel;
import org.sqlproc.model.processorModel.Artifacts;
import org.sqlproc.model.processorModel.ColumnAssignement;
import org.sqlproc.model.processorModel.ColumnTypeAssignement;
import org.sqlproc.model.processorModel.DaogenProperty;
import org.sqlproc.model.processorModel.DatabaseProperty;
import org.sqlproc.model.processorModel.ExportAssignement;
import org.sqlproc.model.processorModel.FunctionDefinitionModel;
import org.sqlproc.model.processorModel.FunctionPojoAssignement;
import org.sqlproc.model.processorModel.ImportAssignement;
import org.sqlproc.model.processorModel.InheritanceAssignement;
import org.sqlproc.model.processorModel.JoinTableAssignement;
import org.sqlproc.model.processorModel.ManyToManyAssignement;
import org.sqlproc.model.processorModel.MetaSqlTypeAssignement;
import org.sqlproc.model.processorModel.MetaTypeAssignement;
import org.sqlproc.model.processorModel.MetagenProperty;
import org.sqlproc.model.processorModel.PojoDefinitionModel;
import org.sqlproc.model.processorModel.PojogenProperty;
import org.sqlproc.model.processorModel.ProcedureDefinitionModel;
import org.sqlproc.model.processorModel.ProcedurePojoAssignement;
import org.sqlproc.model.processorModel.Property;
import org.sqlproc.model.processorModel.PropertyCondition;
import org.sqlproc.model.processorModel.SqlTypeAssignement;
import org.sqlproc.model.processorModel.TableAssignement;
import org.sqlproc.model.processorModel.TableDefinitionModel;
import org.sqlproc.model.processorModel.ValueType;
import org.sqlproc.model.property.ColumnAnnotationsImpl;
import org.sqlproc.model.property.FunctionDefinitionImpl;
import org.sqlproc.model.property.ImplementsExtendsImpl;
import org.sqlproc.model.property.PojoAnnotationsImpl;
import org.sqlproc.model.property.PojoAttrTypeImpl;
import org.sqlproc.model.property.PojoDefinitionImpl;
import org.sqlproc.model.property.PojoEntityTypeImpl;
import org.sqlproc.model.property.ProcedureDefinitionImpl;
import org.sqlproc.model.property.TableDefinitionImpl;
import org.sqlproc.model.util.Utils;
import org.sqlproc.plugin.lib.property.ModelProperty;
import org.sqlproc.plugin.lib.property.PairValues;
import org.sqlproc.plugin.lib.property.PojoDefinition;
import org.sqlproc.plugin.lib.util.CommonUtils;

@Singleton
public class ModelPropertyBean
extends ModelProperty {
    public ModelPropertyBean() {
    }

    public ModelPropertyBean(ModelProperty.ModelValues modelValues) {
        super(modelValues);
    }

    public void notifyChanged(Notification msg) {
        int featureID;
        if (msg.getNotifier() == null || msg.getFeatureID(Resource.class) == -1) {
            return;
        }
        if (msg.getNotifier() instanceof XtextResource && (featureID = msg.getFeatureID(Resource.class)) == 4) {
            XtextResource resource = (XtextResource)msg.getNotifier();
            if (!msg.getNewBooleanValue()) {
                this.LOGGER.debug((Object)("UNLOADED RESOURCE " + resource));
                return;
            }
            IParseResult parseResult = resource.getParseResult();
            EObject rootASTElement = parseResult != null ? parseResult.getRootASTElement() : null;
            this.LOGGER.debug((Object)("LOADED RESOURCE " + resource + " for " + rootASTElement));
            if (parseResult == null || rootASTElement == null || !(rootASTElement instanceof Artifacts) || resource.getURI() == null) {
                this.LOGGER.error((Object)("LOADED RESOURCE IS NOT VALID: for parseResult " + parseResult + " and rootASTElement " + rootASTElement + " and msg " + msg));
                return;
            }
            String dir = CommonUtils.resourceDir((Resource)resource);
            if (dir == null) {
                this.LOGGER.error((Object)("LOADED RESOURCE URI IS NOT VALID " + resource.getURI()));
                return;
            }
            ModelProperty.ModelValues modelValues = null;
            if (this.dirs2models.containsKey(dir)) {
                modelValues = (ModelProperty.ModelValues)this.dirs2models.get(dir);
            } else {
                modelValues = new ModelProperty.ModelValues();
                this.dirs2models.put(dir, modelValues);
                modelValues.dir = dir;
            }
            Artifacts artifacts = (Artifacts)rootASTElement;
            modelValues = ModelPropertyBean.loadModel(modelValues, artifacts);
            if (modelValues == null) {
                return;
            }
            this.LOGGER.debug((Object)("defaultAttrs = " + modelValues.defaultAttrs));
            this.LOGGER.debug((Object)("conditionalAttrs = " + modelValues.conditionalAttrs));
            this.LOGGER.debug((Object)("systemEnvAttrs = " + modelValues.systemEnvAttrs));
            this.LOGGER.debug((Object)("MODEL " + modelValues.toString()));
        }
    }

    public static boolean isNull(PropertyCondition condition) {
        return condition == null || condition.getName() == null || condition.getValue() == null;
    }

    public static boolean isValid(PropertyCondition condition) {
        if (condition == null || condition.getName() == null || condition.getValue() == null) {
            return false;
        }
        String envValue = System.getenv(condition.getName());
        String propValue = Utils.getPropertyValue(condition.getValue());
        return envValue != null && propValue != null && envValue.equals(propValue);
    }

    public static ModelProperty.ModelValues loadModel(ModelProperty.ModelValues modelValues, Artifacts artifacts) {
        PropertyCondition condition;
        Map<String, PojoDefinition> oldAnnotations;
        if (artifacts.getProperties().isEmpty()) {
            return null;
        }
        Map<String, PojoDefinition> oldPojos = modelValues != null ? modelValues.modelPojos : null;
        Map<String, PojoDefinition> map = oldAnnotations = modelValues != null ? modelValues.modelAnnotations : null;
        if (modelValues == null) {
            modelValues = new ModelProperty.ModelValues();
        }
        modelValues.initModel();
        modelValues.initialized = false;
        boolean firstDatabase = true;
        boolean firstPojogen = true;
        boolean firstMetagen = true;
        boolean firstDaogen = true;
        boolean firstModel = true;
        try {
            for (Property property : artifacts.getProperties()) {
                condition = property.getCondition();
                if (property.getName().startsWith("database")) {
                    if (firstDatabase) {
                        firstDatabase = false;
                        modelValues.initDatabaseModel();
                    }
                    if (!ModelPropertyBean.isNull(condition)) continue;
                    ModelPropertyBean.setValue(modelValues, property.getDatabase());
                    modelValues.defaultAttrs.get("database").add(property.getDatabase().getName());
                    continue;
                }
                if (property.getName().startsWith("pojogen")) {
                    if (firstPojogen) {
                        firstPojogen = false;
                        modelValues.initPojogenModel();
                    }
                    if (!ModelPropertyBean.isNull(condition)) continue;
                    ModelPropertyBean.setValue(modelValues, property.getPojogen());
                    modelValues.defaultAttrs.get("pojogen").add(property.getPojogen().getName());
                    continue;
                }
                if (property.getName().startsWith("metagen")) {
                    if (firstMetagen) {
                        firstMetagen = false;
                        modelValues.initMetagenModel();
                    }
                    if (!ModelPropertyBean.isNull(condition)) continue;
                    ModelPropertyBean.setValue(modelValues, property.getMetagen());
                    modelValues.defaultAttrs.get("metagen").add(property.getMetagen().getName());
                    continue;
                }
                if (property.getName().startsWith("daogen")) {
                    if (firstDaogen) {
                        firstDaogen = false;
                        modelValues.initDaogenModel();
                    }
                    if (!ModelPropertyBean.isNull(condition)) continue;
                    ModelPropertyBean.setValue(modelValues, property.getDaogen());
                    modelValues.defaultAttrs.get("daogen").add(property.getDaogen().getName());
                    continue;
                }
                if (!ModelPropertyBean.isNull(condition)) continue;
                ModelPropertyBean.setValue(modelValues, property);
                modelValues.defaultAttrs.get("___GLOBAL").add(property.getName());
            }
            for (Object pojo : artifacts.getPojos()) {
                if (firstModel) {
                    firstModel = false;
                    modelValues.initModelModel();
                }
                modelValues.modelPojos.put(pojo.getName(), new PojoDefinitionImpl((PojoDefinitionModel)pojo, oldPojos != null ? oldPojos.get(pojo.getName()) : null));
            }
            for (Object pojo : artifacts.getAnnotations()) {
                if (firstModel) {
                    firstModel = false;
                    modelValues.initModelModel();
                }
                modelValues.modelAnnotations.put(pojo.getName(), new PojoDefinitionImpl((AnnotationDefinitionModel)pojo, oldAnnotations != null ? oldAnnotations.get(pojo.getName()) : null));
            }
            for (TableDefinitionModel table : artifacts.getTables()) {
                if (firstModel) {
                    firstModel = false;
                    modelValues.initModelModel();
                }
                modelValues.modelTables.put(table.getName(), new TableDefinitionImpl(table.getName(), table.getTable()));
            }
            for (ProcedureDefinitionModel procedure : artifacts.getProcedures()) {
                if (firstModel) {
                    firstModel = false;
                    modelValues.initModelModel();
                }
                modelValues.modelProcedures.put(procedure.getName(), new ProcedureDefinitionImpl(procedure.getName(), procedure.getTable()));
            }
            for (FunctionDefinitionModel function : artifacts.getFunctions()) {
                if (firstModel) {
                    firstModel = false;
                    modelValues.initModelModel();
                }
                modelValues.modelFunctions.put(function.getName(), new FunctionDefinitionImpl(function.getName(), function.getTable()));
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        try {
            modelValues.setStandardValuesFromEnv();
            modelValues.setDatabaseValuesFromEnv();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        try {
            for (Property property : artifacts.getProperties()) {
                condition = property.getCondition();
                boolean condIsValid = ModelPropertyBean.isValid(condition);
                if (property.getName().startsWith("database")) {
                    if (!condIsValid) continue;
                    ModelPropertyBean.setValue(modelValues, property.getDatabase());
                    modelValues.conditionalAttrs.get("database").add(property.getDatabase().getName());
                    continue;
                }
                if (property.getName().startsWith("pojogen")) {
                    if (!condIsValid) continue;
                    ModelPropertyBean.setValue(modelValues, property.getPojogen());
                    modelValues.conditionalAttrs.get("pojogen").add(property.getPojogen().getName());
                    continue;
                }
                if (property.getName().startsWith("metagen")) {
                    if (!condIsValid) continue;
                    ModelPropertyBean.setValue(modelValues, property.getMetagen());
                    modelValues.conditionalAttrs.get("metagen").add(property.getMetagen().getName());
                    continue;
                }
                if (property.getName().startsWith("daogen")) {
                    if (!condIsValid) continue;
                    ModelPropertyBean.setValue(modelValues, property.getDaogen());
                    modelValues.conditionalAttrs.get("daogen").add(property.getDaogen().getName());
                    continue;
                }
                if (!condIsValid) continue;
                ModelPropertyBean.setValue(modelValues, property);
                modelValues.conditionalAttrs.get("___GLOBAL").add(property.getName());
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        modelValues.initialized = true;
        return modelValues;
    }

    public static void setValue(ModelProperty.ModelValues modelValues, Property property) {
        if (property == null) {
            return;
        }
        if ("resolve-pojo-on".equals(property.getName())) {
            modelValues.doResolvePojo = true;
        } else if ("resolve-pojo-off".equals(property.getName())) {
            modelValues.doResolvePojo = false;
        } else if ("replace-all-regex".equals(property.getName())) {
            if (property.getRegex() != null && property.getReplaceId() != null) {
                modelValues.replaceAllRegex.put(property.getReplaceId(), Utils.getPropertyValueRegex(property.getRegex()));
            }
        } else if ("replace-all-replacement".equals(property.getName())) {
            if (property.getReplacement() != null && property.getReplaceId() != null) {
                modelValues.replaceAllReplacement.put(property.getReplaceId(), Utils.getPropertyValueRegex(property.getReplacement()));
            }
        } else if ("replace-text".equals(property.getName())) {
            if (property.getReplacement() != null && property.getRegex() != null) {
                String uuid = UUID.randomUUID().toString();
                modelValues.replaceAllRegex.put(uuid, Utils.getPropertyValueRegex(property.getRegex()));
                modelValues.replaceAllReplacement.put(uuid, Utils.getPropertyValueRegex(property.getReplacement()));
            }
        } else if ("compress-meta-directives".equals(property.getName())) {
            modelValues.doCompressMetaDirectives = true;
        } else if ("generate-from-to".equals(property.getName())) {
            modelValues.doGenerateFromTo = true;
        } else if ("case-format-library".equals(property.getName())) {
            modelValues.caseFormatLibrary = Utils.getPropertyValue(property.getCaseFormatLibrary());
        } else if ("validate-resources".equals(property.getName())) {
            int m;
            int i;
            if (property.getDoVerifyResources() != null) {
                i = 0;
                m = property.getDoVerifyResources().size();
                while (i < m) {
                    modelValues.doVerifyResources.add(Utils.getPropertyValue((ValueType)property.getDoVerifyResources().get(i)));
                    ++i;
                }
            }
            if (property.getDoNotVerifyResources() != null) {
                i = 0;
                m = property.getDoNotVerifyResources().size();
                while (i < m) {
                    modelValues.doNotVerifyResources.add(Utils.getPropertyValue((ValueType)property.getDoNotVerifyResources().get(i)));
                    ++i;
                }
            }
        } else if ("new-pojo-validator".equals(property.getName())) {
            modelValues.oldPojoValidator = false;
        } else if ("old-pojo-validator".equals(property.getName())) {
            modelValues.oldPojoValidator = true;
        }
    }

    public static void setValue(ModelProperty.ModelValues modelValues, DatabaseProperty property) {
        if (property == null) {
            return;
        }
        if ("is-online".equals(property.getName())) {
            modelValues.doResolveDb = true;
        } else if ("is-offline".equals(property.getName())) {
            modelValues.doResolveDb = false;
        } else if ("has-url".equals(property.getName())) {
            modelValues.dbUrl = Utils.getPropertyValue(property.getDbUrl());
        } else if ("login-username".equals(property.getName())) {
            modelValues.dbUsername = Utils.getPropertyValue(property.getDbUsername());
        } else if ("login-password".equals(property.getName())) {
            modelValues.dbPassword = Utils.getPropertyValue(property.getDbPassword());
        } else if ("in-catalog".equals(property.getName())) {
            modelValues.dbCatalog = property.getDbCatalog() != null ? Utils.getPropertyValue(property.getDbCatalog().getDbCatalog()) : null;
        } else if ("active-schema".equals(property.getName())) {
            modelValues.dbSchema = property.getDbSchema() != null ? Utils.getPropertyValue(property.getDbSchema().getDbSchema()) : null;
        } else if ("jdbc-driver".equals(property.getName())) {
            modelValues.dbDriver = Utils.getPropertyValue(property.getDbDriver());
            modelValues.dbDriverPojo = new PojoEntityTypeImpl(property.getDbDriver());
        } else if ("ddl-create".equals(property.getName())) {
            modelValues.dbSqlsBefore = Utils.getPropertyValue(property.getDbExecuteBefore());
        } else if ("ddl-drop".equals(property.getName())) {
            modelValues.dbSqlsAfter = Utils.getPropertyValue(property.getDbExecuteAfter());
        } else if ("index-types".equals(property.getName())) {
            modelValues.dbIndexTypes = Utils.getPropertyValue(property.getDbIndexTypes());
        } else if ("skip-indexes".equals(property.getName())) {
            modelValues.dbSkipIndexes = true;
        } else if ("skip-functions-procedures".equals(property.getName())) {
            modelValues.dbSkipProcedures = true;
        } else if ("skip-check-constraints".equals(property.getName())) {
            modelValues.dbSkipCheckConstraints = true;
        } else if ("is-of-type".equals(property.getName())) {
            modelValues.dbType = property.getDbType() != null ? Utils.getPropertyValue(property.getDbType().getDbType()) : null;
        } else if ("debug-level".equals(property.getName()) && property.getDebug() != null) {
            modelValues.dbDebugLevel = property.getDebug().getDebug();
            modelValues.dbDebugScope = Utils.getPropertyValue(property.getDebug().getScope());
        } else if ("take-comments".equals(property.getName())) {
            modelValues.dbTakeComments = true;
        } else if ("lowercase-names".equals(property.getName())) {
            modelValues.dbLowercaseNames = true;
        } else if ("uppercase-names".equals(property.getName())) {
            modelValues.dbUppercaseNames = true;
        }
    }

    private static void setValue(ModelProperty.ModelValues modelValues, PojogenProperty property) {
        if (property == null) {
            return;
        }
        if ("types-sqltypes".equals(property.getName())) {
            int i = 0;
            int m = property.getSqlTypes().size();
            while (i < m) {
                String sqlType = Utils.getPropertyValue(((SqlTypeAssignement)property.getSqlTypes().get(i)).getSqlType());
                if (((SqlTypeAssignement)property.getSqlTypes().get(i)).getSqlSize() != 0) {
                    sqlType = String.valueOf(sqlType) + "(" + ((SqlTypeAssignement)property.getSqlTypes().get(i)).getSqlSize() + ")";
                }
                PojoAttrTypeImpl type = new PojoAttrTypeImpl(null, sqlType, ((SqlTypeAssignement)property.getSqlTypes().get(i)).getType());
                modelValues.sqlTypes.put(sqlType, type);
                ++i;
            }
        } else if ("types-in-table".equals(property.getName())) {
            if (!modelValues.tableTypes.containsKey(property.getDbTable())) {
                modelValues.tableTypes.put(property.getDbTable(), new HashMap());
            }
            int i = 0;
            int m = property.getSqlTypes().size();
            while (i < m) {
                String sqlType = Utils.getPropertyValue(((SqlTypeAssignement)property.getSqlTypes().get(i)).getSqlType());
                if (((SqlTypeAssignement)property.getSqlTypes().get(i)).getSqlSize() != 0) {
                    sqlType = String.valueOf(sqlType) + "(" + ((SqlTypeAssignement)property.getSqlTypes().get(i)).getSqlSize() + ")";
                }
                PojoAttrTypeImpl type = new PojoAttrTypeImpl(null, sqlType, ((SqlTypeAssignement)property.getSqlTypes().get(i)).getType());
                modelValues.tableTypes.get(property.getDbTable()).put(sqlType, type);
                ++i;
            }
        } else if ("types-for-columns".equals(property.getName())) {
            if (!modelValues.columnTypes.containsKey(property.getDbTable())) {
                modelValues.columnTypes.put(property.getDbTable(), new HashMap());
            }
            int i = 0;
            int m = property.getColumnTypes().size();
            while (i < m) {
                PojoAttrTypeImpl type = new PojoAttrTypeImpl(((ColumnTypeAssignement)property.getColumnTypes().get(i)).getDbColumn(), null, ((ColumnTypeAssignement)property.getColumnTypes().get(i)).getType());
                modelValues.columnTypes.get(property.getDbTable()).put(((ColumnTypeAssignement)property.getColumnTypes().get(i)).getDbColumn(), type);
                ++i;
            }
        } else if ("types-for-procedure".equals(property.getName())) {
            if (!modelValues.procedureTypes.containsKey(property.getDbProcedure())) {
                modelValues.procedureTypes.put(property.getDbProcedure(), new HashMap());
            }
            int i = 0;
            int m = property.getColumnTypes().size();
            while (i < m) {
                PojoAttrTypeImpl type = new PojoAttrTypeImpl(((ColumnTypeAssignement)property.getColumnTypes().get(i)).getDbColumn(), null, ((ColumnTypeAssignement)property.getColumnTypes().get(i)).getType());
                modelValues.procedureTypes.get(property.getDbProcedure()).put(((ColumnTypeAssignement)property.getColumnTypes().get(i)).getDbColumn(), type);
                ++i;
            }
        } else if ("types-for-function".equals(property.getName())) {
            if (!modelValues.functionTypes.containsKey(property.getDbFunction())) {
                modelValues.functionTypes.put(property.getDbFunction(), new HashMap());
            }
            int i = 0;
            int m = property.getColumnTypes().size();
            while (i < m) {
                PojoAttrTypeImpl type = new PojoAttrTypeImpl(((ColumnTypeAssignement)property.getColumnTypes().get(i)).getDbColumn(), null, ((ColumnTypeAssignement)property.getColumnTypes().get(i)).getType());
                modelValues.functionTypes.get(property.getDbFunction()).put(((ColumnTypeAssignement)property.getColumnTypes().get(i)).getDbColumn(), type);
                ++i;
            }
        } else if ("rename-tables".equals(property.getName())) {
            int i = 0;
            int m = property.getTables().size();
            while (i < m) {
                modelValues.tableNames.put(((TableAssignement)property.getTables().get(i)).getDbTable(), ((TableAssignement)property.getTables().get(i)).getNewName());
                ++i;
            }
        } else if ("rename-columns".equals(property.getName())) {
            if (!modelValues.columnNames.containsKey(property.getDbTable())) {
                modelValues.columnNames.put(property.getDbTable(), new HashMap());
            }
            int i = 0;
            int m = property.getColumns().size();
            while (i < m) {
                modelValues.columnNames.get(property.getDbTable()).put(((ColumnAssignement)property.getColumns().get(i)).getDbColumn(), ((ColumnAssignement)property.getColumns().get(i)).getNewName());
                ++i;
            }
        } else if ("ignore-tables".equals(property.getName())) {
            int i = 0;
            int m = property.getDbTables().size();
            while (i < m) {
                modelValues.ignoreTables.add((String)property.getDbTables().get(i));
                ++i;
            }
        } else if ("only-tables".equals(property.getName())) {
            int i = 0;
            int m = property.getDbTables().size();
            while (i < m) {
                modelValues.onlyTables.add((String)property.getDbTables().get(i));
                ++i;
            }
        } else if ("not-abstract-tables".equals(property.getName())) {
            int i = 0;
            int m = property.getDbTables().size();
            while (i < m) {
                modelValues.notAbstractTables.add((String)property.getDbTables().get(i));
                ++i;
            }
        } else if ("create-tables".equals(property.getName())) {
            int i = 0;
            int m = property.getDbTables().size();
            while (i < m) {
                modelValues.createTables.add((String)property.getDbTables().get(i));
                ++i;
            }
        } else if ("ignore-columns".equals(property.getName())) {
            if (!modelValues.ignoreColumns.containsKey(property.getDbTable())) {
                modelValues.ignoreColumns.put(property.getDbTable(), new HashSet());
            }
            int i = 0;
            int m = property.getDbColumns().size();
            while (i < m) {
                modelValues.ignoreColumns.get(property.getDbTable()).add((String)property.getDbColumns().get(i));
                ++i;
            }
        } else if ("required-columns".equals(property.getName())) {
            if (!modelValues.requiredColumns.containsKey(property.getDbTable())) {
                modelValues.requiredColumns.put(property.getDbTable(), new HashSet());
            }
            int i = 0;
            int m = property.getDbColumns().size();
            while (i < m) {
                modelValues.requiredColumns.get(property.getDbTable()).add((String)property.getDbColumns().get(i));
                ++i;
            }
        } else if ("not-required-columns".equals(property.getName())) {
            if (!modelValues.notRequiredColumns.containsKey(property.getDbTable())) {
                modelValues.notRequiredColumns.put(property.getDbTable(), new HashSet());
            }
            int i = 0;
            int m = property.getDbColumns().size();
            while (i < m) {
                modelValues.notRequiredColumns.get(property.getDbTable()).add((String)property.getDbColumns().get(i));
                ++i;
            }
        } else if ("create-columns".equals(property.getName())) {
            if (!modelValues.createColumns.containsKey(property.getDbTable())) {
                modelValues.createColumns.put(property.getDbTable(), new LinkedHashMap());
            }
            int i = 0;
            int m = property.getColumnTypes().size();
            while (i < m) {
                PojoAttrTypeImpl type = new PojoAttrTypeImpl(((ColumnTypeAssignement)property.getColumnTypes().get(i)).getDbColumn(), null, ((ColumnTypeAssignement)property.getColumnTypes().get(i)).getType());
                modelValues.createColumns.get(property.getDbTable()).put(((ColumnTypeAssignement)property.getColumnTypes().get(i)).getDbColumn(), type);
                ++i;
            }
        } else if ("ignore-one-to-many".equals(property.getName())) {
            if (!modelValues.ignoreExports.containsKey(property.getDbTable())) {
                modelValues.ignoreExports.put(property.getDbTable(), new HashMap());
            }
            Map<String, Map<String, String>> exports = modelValues.ignoreExports.get(property.getDbTable());
            int i = 0;
            int m = property.getExports().size();
            while (i < m) {
                ExportAssignement export = (ExportAssignement)property.getExports().get(i);
                if (!exports.containsKey(export.getDbColumn())) {
                    exports.put(export.getDbColumn(), new HashMap());
                }
                exports.get(export.getDbColumn()).put(export.getFkTable(), export.getFkColumn());
                ++i;
            }
        } else if ("ignore-many-to-one".equals(property.getName())) {
            if (!modelValues.ignoreImports.containsKey(property.getDbTable())) {
                modelValues.ignoreImports.put(property.getDbTable(), new HashMap());
            }
            Map<String, Map<String, String>> imports = modelValues.ignoreImports.get(property.getDbTable());
            int i = 0;
            int m = property.getImports().size();
            while (i < m) {
                ImportAssignement _import = (ImportAssignement)property.getImports().get(i);
                if (!imports.containsKey(_import.getDbColumn())) {
                    imports.put(_import.getDbColumn(), new HashMap());
                }
                imports.get(_import.getDbColumn()).put(_import.getPkTable(), _import.getPkColumn());
                ++i;
            }
        } else if ("create-one-to-many".equals(property.getName())) {
            if (!modelValues.createExports.containsKey(property.getDbTable())) {
                modelValues.createExports.put(property.getDbTable(), new LinkedHashMap());
            }
            Map<String, Map<String, String>> exports = modelValues.createExports.get(property.getDbTable());
            int i = 0;
            int m = property.getExports().size();
            while (i < m) {
                ExportAssignement export = (ExportAssignement)property.getExports().get(i);
                if (!exports.containsKey(export.getDbColumn())) {
                    exports.put(export.getDbColumn(), new LinkedHashMap());
                }
                exports.get(export.getDbColumn()).put(export.getFkTable(), export.getFkColumn());
                ++i;
            }
        } else if ("create-many-to-one".equals(property.getName())) {
            if (!modelValues.createImports.containsKey(property.getDbTable())) {
                modelValues.createImports.put(property.getDbTable(), new LinkedHashMap());
            }
            Map<String, Map<String, String>> imports = modelValues.createImports.get(property.getDbTable());
            int i = 0;
            int m = property.getImports().size();
            while (i < m) {
                ImportAssignement _import = (ImportAssignement)property.getImports().get(i);
                if (!imports.containsKey(_import.getDbColumn())) {
                    imports.put(_import.getDbColumn(), new LinkedHashMap());
                }
                imports.get(_import.getDbColumn()).put(_import.getPkTable(), _import.getPkColumn());
                ++i;
            }
        } else if ("association-one-to-one".equals(property.getName())) {
            if (!modelValues.create121Imports.containsKey(property.getDbTable())) {
                modelValues.create121Imports.put(property.getDbTable(), new HashMap());
            }
            Map<String, Map<String, String>> imports = modelValues.create121Imports.get(property.getDbTable());
            if (!modelValues.ignoreExports.containsKey(property.getDbTable())) {
                modelValues.ignoreExports.put(property.getDbTable(), new HashMap());
            }
            Map<String, Map<String, String>> exports = modelValues.ignoreExports.get(property.getDbTable());
            int i = 0;
            int m = property.getImports().size();
            while (i < m) {
                Map<String, Map<String, String>> _imports121;
                Map<String, Map<String, String>> _imports;
                ImportAssignement _import = (ImportAssignement)property.getImports().get(i);
                if (!imports.containsKey(_import.getDbColumn())) {
                    imports.put(_import.getDbColumn(), new HashMap());
                }
                imports.get(_import.getDbColumn()).put(_import.getPkTable(), _import.getPkColumn());
                if (!exports.containsKey(_import.getDbColumn())) {
                    exports.put(_import.getDbColumn(), new HashMap());
                }
                exports.get(_import.getDbColumn()).put(_import.getPkTable(), _import.getPkColumn());
                if (!modelValues.ignoreImports.containsKey(_import.getPkTable())) {
                    modelValues.ignoreImports.put(_import.getPkTable(), new HashMap());
                }
                if (!(_imports = modelValues.ignoreImports.get(_import.getPkTable())).containsKey(_import.getPkColumn())) {
                    _imports.put(_import.getPkColumn(), new HashMap());
                }
                _imports.get(_import.getPkColumn()).put(property.getDbTable(), _import.getDbColumn());
                if (!modelValues.create121Imports.containsKey(_import.getPkTable())) {
                    modelValues.create121Imports.put(_import.getPkTable(), new HashMap());
                }
                if (!(_imports121 = modelValues.create121Imports.get(_import.getPkTable())).containsKey(_import.getPkColumn())) {
                    _imports121.put(_import.getPkColumn(), new HashMap());
                }
                _imports121.get(_import.getPkColumn()).put(property.getDbTable(), _import.getDbColumn());
                ++i;
            }
        } else if ("inherit-many-to-one".equals(property.getName())) {
            if (!modelValues.inheritImports.containsKey(property.getDbTable())) {
                modelValues.inheritImports.put(property.getDbTable(), new HashMap());
            }
            Map<String, Map<String, String>> imports = modelValues.inheritImports.get(property.getDbTable());
            int i = 0;
            int m = property.getImports().size();
            while (i < m) {
                ImportAssignement _import = (ImportAssignement)property.getImports().get(i);
                if (!imports.containsKey(_import.getDbColumn())) {
                    imports.put(_import.getDbColumn(), new HashMap());
                }
                imports.get(_import.getDbColumn()).put(_import.getPkTable(), _import.getPkColumn());
                ++i;
            }
        } else if ("table-many-to-many".equals(property.getName())) {
            if (!modelValues.manyToManyImports.containsKey(property.getDbTable())) {
                modelValues.manyToManyImports.put(property.getDbTable(), new HashMap());
            }
            Map<String, Map<String, String>> many2s = modelValues.manyToManyImports.get(property.getDbTable());
            int i = 0;
            int m = property.getMany2s().size();
            while (i < m) {
                ManyToManyAssignement many2 = (ManyToManyAssignement)property.getMany2s().get(i);
                if (!many2s.containsKey(many2.getPkColumn())) {
                    many2s.put(many2.getPkColumn(), new HashMap());
                }
                many2s.get(many2.getPkColumn()).put(many2.getPkTable(), many2.getFkColumn());
                ++i;
            }
        } else if ("inherit-discriminator".equals(property.getName())) {
            if (!modelValues.inheritance.containsKey(property.getDbTable())) {
                modelValues.inheritance.put(property.getDbTable(), new HashMap());
            }
            modelValues.inheritanceColumns.put(property.getDbTable(), property.getDbColumn());
            Map<String, Map<String, List<String>>> inherits = modelValues.inheritance.get(property.getDbTable());
            int i = 0;
            int m = property.getInheritance().size();
            while (i < m) {
                InheritanceAssignement _inherit = (InheritanceAssignement)property.getInheritance().get(i);
                if (!inherits.containsKey(_inherit.getDiscriminator())) {
                    inherits.put(_inherit.getDiscriminator(), new HashMap());
                }
                inherits.get(_inherit.getDiscriminator()).put(_inherit.getDbTable(), (List<String>)_inherit.getDbColumns());
                ++i;
            }
        } else if ("generate-methods".equals(property.getName())) {
            int i = 0;
            int m = property.getMethods().size();
            while (i < m) {
                modelValues.generateMethods.add((String)property.getMethods().get(i));
                ++i;
            }
        } else if ("generate-operators".equals(property.getName())) {
            modelValues.generateOperators = Utils.getPropertyValue(property.getOperatorsSuffix());
            if (modelValues.generateOperators == null) {
                modelValues.generateOperators = "operators";
            }
        } else if ("implements-interfaces".equals(property.getName())) {
            ImplementsExtendsImpl ie = new ImplementsExtendsImpl(property.getToImplements().getToImplement(), false, (List<String>)property.getToImplements().getDbTables(), (List<String>)property.getToImplements().getDbNotTables());
            modelValues.toImplements.put(ie.getIdentifier(), ie);
        } else if ("extends-class".equals(property.getName())) {
            ImplementsExtendsImpl ie = new ImplementsExtendsImpl(property.getToExtends().getToExtends(), false, (List<String>)property.getToExtends().getDbTables(), (List<String>)property.getToExtends().getDbNotTables());
            modelValues.toExtends = ie;
        } else if ("implements-interfaces-generics".equals(property.getName())) {
            ImplementsExtendsImpl ie = new ImplementsExtendsImpl(property.getToImplementsGenerics().getToImplement(), true, (List<String>)property.getToImplementsGenerics().getDbTables(), (List<String>)property.getToImplementsGenerics().getDbNotTables());
            modelValues.toImplements.put(ie.getIdentifier(), ie);
        } else if ("extends-class-generics".equals(property.getName())) {
            ImplementsExtendsImpl ie = new ImplementsExtendsImpl(property.getToExtendsGenerics().getToExtends(), true, (List<String>)property.getToExtendsGenerics().getDbTables(), (List<String>)property.getToExtendsGenerics().getDbNotTables());
            modelValues.toExtends = ie;
        } else if ("join-tables".equals(property.getName())) {
            int i = 0;
            int m = property.getJoinTables().size();
            while (i < m) {
                JoinTableAssignement joinTableAssignement = (JoinTableAssignement)property.getJoinTables().get(i);
                if (!modelValues.joinTables.containsKey(joinTableAssignement.getDbTable())) {
                    modelValues.joinTables.put(joinTableAssignement.getDbTable(), new ArrayList());
                }
                for (String dbTable : joinTableAssignement.getDbTables()) {
                    modelValues.joinTables.get(joinTableAssignement.getDbTable()).add(dbTable);
                }
                ++i;
            }
        } else if ("generate-wrappers".equals(property.getName())) {
            modelValues.doGenerateWrappers = true;
        } else if ("generate-validation-annotations".equals(property.getName())) {
            modelValues.doGenerateValidationAnnotations = true;
        } else if ("make-it-final".equals(property.getName())) {
            modelValues.makeItFinal = true;
        } else if ("version-column".equals(property.getName())) {
            String versionColumn = property.getVersion();
            if ((property.getDbTables() == null || property.getDbTables().isEmpty()) && (property.getDbNotTables() == null || property.getDbNotTables().isEmpty())) {
                modelValues.versionColumn = versionColumn;
            } else if (property.getDbTables() != null && !property.getDbTables().isEmpty()) {
                if (!modelValues.versionColumns.containsKey(versionColumn)) {
                    modelValues.versionColumns.put(versionColumn, new HashSet());
                }
                int i = 0;
                int m = property.getDbTables().size();
                while (i < m) {
                    modelValues.versionColumns.get(versionColumn).add((String)property.getDbTables().get(i));
                    ++i;
                }
            } else {
                if (!modelValues.notVersionColumns.containsKey(versionColumn)) {
                    modelValues.notVersionColumns.put(versionColumn, new HashSet());
                }
                int i = 0;
                int m = property.getDbNotTables().size();
                while (i < m) {
                    modelValues.notVersionColumns.get(versionColumn).add((String)property.getDbNotTables().get(i));
                    ++i;
                }
            }
        } else if ("debug-level".equals(property.getName()) && property.getDebug().getDebug() != null) {
            modelValues.debugLevel = property.getDebug().getDebug();
            modelValues.debugScope = Utils.getPropertyValue(property.getDebug().getScope());
        } else if ("preserve-foreign-keys".equals(property.getName())) {
            if (property.getDbTables().isEmpty()) {
                modelValues.preserveForeignKeys.add("_ALL_");
            } else {
                int i = 0;
                int m = property.getDbTables().size();
                while (i < m) {
                    modelValues.preserveForeignKeys.add((String)property.getDbTables().get(i));
                    ++i;
                }
            }
        } else if ("pojos-for-procedures".equals(property.getName())) {
            int i = 0;
            int m = property.getProcPojos().size();
            while (i < m) {
                modelValues.pojosForProcedures.put(((ProcedurePojoAssignement)property.getProcPojos().get(i)).getDbProcedure(), new PojoEntityTypeImpl(((ProcedurePojoAssignement)property.getProcPojos().get(i)).getPojo()));
                ++i;
            }
        } else if ("pojos-for-functions".equals(property.getName())) {
            int i = 0;
            int m = property.getFunPojos().size();
            while (i < m) {
                modelValues.pojosForFunctions.put(((FunctionPojoAssignement)property.getFunPojos().get(i)).getDbFunction(), new PojoEntityTypeImpl(((FunctionPojoAssignement)property.getFunPojos().get(i)).getPojo()));
                ++i;
            }
        } else if ("active-filter".equals(property.getName())) {
            modelValues.activeFilter = Utils.getPropertyValue(property.getActiveFilter());
        } else if ("package".equals(property.getName())) {
            modelValues.pckg = Utils.getPropertyValue(property.getPckg());
        } else if ("enum-for-check-constraints".equals(property.getName())) {
            int i = 0;
            int m = property.getDbCheckConstraints().size();
            while (i < m) {
                if (i == 0) {
                    modelValues.enumForCheckConstraints.put(property.getEnumName(), (String)property.getDbCheckConstraints().get(i));
                }
                modelValues.enumForCheckConstraints.put((String)property.getDbCheckConstraints().get(i), property.getEnumName());
                ++i;
            }
        } else if ("column-annotations".equals(property.getName()) || "getter-annotations".equals(property.getName()) || "setter-annotations".equals(property.getName())) {
            int type = 4;
            if ("getter-annotations".equals(property.getName())) {
                type = 1;
            } else if ("setter-annotations".equals(property.getName())) {
                type = 2;
            }
            ColumnAnnotationsImpl ie = new ColumnAnnotationsImpl((ColumnAnnotationsImpl)modelValues.columnAnnotations.get(property.getDbColumn()), property.getDbColumn(), (List<AnnotationDefinitionModel>)property.getColumnAnnotations().getAnnotations(), (List<String>)property.getColumnAnnotations().getDbTables(), (List<String>)property.getColumnAnnotations().getDbNotTables(), type);
            modelValues.columnAnnotations.put(ie.getDbColumn(), ie);
        } else if ("conflict-annotations".equals(property.getName()) || "static-annotations".equals(property.getName()) || "constructor-annotations".equals(property.getName()) || "pojo-annotations".equals(property.getName())) {
            int type = 8;
            if ("conflict-annotations".equals(property.getName())) {
                type = 1;
            } else if ("constructor-annotations".equals(property.getName())) {
                type = 4;
            } else if ("static-annotations".equals(property.getName())) {
                type = 2;
            }
            modelValues.pojoAnnotations = new PojoAnnotationsImpl((PojoAnnotationsImpl)modelValues.pojoAnnotations, property.getDbColumn(), (List<AnnotationDefinitionModel>)property.getColumnAnnotations().getAnnotations(), (List<String>)property.getColumnAnnotations().getDbTables(), (List<String>)property.getColumnAnnotations().getDbNotTables(), type);
        } else if ("old-date-time".equals(property.getName())) {
            modelValues.oldDateTime = true;
        }
    }

    private static void setValue(ModelProperty.ModelValues modelValues, MetagenProperty property) {
        block66: {
            block68: {
                block67: {
                    block65: {
                        if (property == null) {
                            return;
                        }
                        if (!"global-identity".equals(property.getName())) break block65;
                        modelValues.metaGlobalIdentity = new PairValues(property.getIdentity(), property.getType());
                        if (property.getDbTables() != null) {
                            modelValues.metaGlobalIdentityForTables.addAll((Collection<String>)property.getDbTables());
                        }
                        if (property.getDbNotTables() == null) break block66;
                        modelValues.metaGlobalIdentityNotForTables.addAll((Collection<String>)property.getDbNotTables());
                        break block66;
                    }
                    if (!"table-identity".equals(property.getName())) break block67;
                    modelValues.metaTablesIdentity.put(property.getDbTable(), new PairValues(property.getIdentity(), property.getType()));
                    break block66;
                }
                if (!"global-sequence".equals(property.getName())) break block68;
                modelValues.metaGlobalSequence = new PairValues(property.getSequence(), property.getType());
                if (property.getDbTables() != null) {
                    modelValues.metaGlobalSequenceForTables.addAll((Collection<String>)property.getDbTables());
                }
                if (property.getDbNotTables() == null) break block66;
                modelValues.metaGlobalSequenceNotForTables.addAll((Collection<String>)property.getDbNotTables());
                break block66;
            }
            if ("table-sequence".equals(property.getName())) {
                modelValues.metaTablesSequence.put(property.getDbTable(), new PairValues(property.getSequence(), property.getType()));
            } else if ("sqltype-meta-type".equals(property.getName())) {
                int i = 0;
                int m = property.getSqlTypes().size();
                while (i < m) {
                    String sqlType = Utils.getPropertyValue(((MetaSqlTypeAssignement)property.getSqlTypes().get(i)).getSqlType());
                    MetaSqlTypeAssignement metaType = (MetaSqlTypeAssignement)property.getSqlTypes().get(i);
                    modelValues.metaSqlTypes.put(sqlType, new PairValues(metaType.getType(), metaType.getExtension()));
                    ++i;
                }
            } else if ("column-meta-type".equals(property.getName())) {
                if (!modelValues.metaColumnsMetaTypes.containsKey(property.getDbTable())) {
                    modelValues.metaColumnsMetaTypes.put(property.getDbTable(), new HashMap());
                }
                int i = 0;
                int m = property.getMetaTypes().size();
                while (i < m) {
                    MetaTypeAssignement metaType = (MetaTypeAssignement)property.getMetaTypes().get(i);
                    modelValues.metaColumnsMetaTypes.get(property.getDbTable()).put(metaType.getDbColumn(), new PairValues(metaType.getType(), metaType.getExtension()));
                    ++i;
                }
            } else if ("statement-meta-type".equals(property.getName())) {
                if (!modelValues.metaStatementsMetaTypes.containsKey(property.getDbStatement())) {
                    modelValues.metaStatementsMetaTypes.put(property.getDbStatement(), new HashMap());
                }
                int i = 0;
                int m = property.getMetaTypes().size();
                while (i < m) {
                    MetaTypeAssignement metaType = (MetaTypeAssignement)property.getMetaTypes().get(i);
                    modelValues.metaStatementsMetaTypes.get(property.getDbStatement()).put(metaType.getDbColumn(), new PairValues(metaType.getType(), metaType.getExtension()));
                    ++i;
                }
            } else if ("make-it-final".equals(property.getName())) {
                modelValues.metaMakeItFinal = true;
            } else if ("like-columns".equals(property.getName())) {
                if (property.getDbTable() == null) {
                    modelValues.metaLikeColumns.put("___GLOBAL", new HashSet());
                } else {
                    if (!modelValues.metaLikeColumns.containsKey(property.getDbTable())) {
                        modelValues.metaLikeColumns.put(property.getDbTable(), new HashSet());
                    }
                    int i = 0;
                    int m = property.getDbColumns().size();
                    while (i < m) {
                        modelValues.metaLikeColumns.get(property.getDbTable()).add((String)property.getDbColumns().get(i));
                        ++i;
                    }
                }
            } else if ("not-like-columns".equals(property.getName())) {
                if (property.getDbTable() == null) {
                    modelValues.metaNotLikeColumns.put("___GLOBAL", new HashSet());
                } else {
                    if (!modelValues.metaNotLikeColumns.containsKey(property.getDbTable())) {
                        modelValues.metaNotLikeColumns.put(property.getDbTable(), new HashSet());
                    }
                    int i = 0;
                    int m = property.getDbColumns().size();
                    while (i < m) {
                        modelValues.metaNotLikeColumns.get(property.getDbTable()).add((String)property.getDbColumns().get(i));
                        ++i;
                    }
                }
            } else if ("generate-sequences".equals(property.getName())) {
                modelValues.metaGenerateSequences = true;
            } else if ("generate-identities".equals(property.getName())) {
                modelValues.metaGenerateIdentities = true;
            } else if ("generate-idgenerators".equals(property.getName())) {
                modelValues.metaGenerateIdGenerators = true;
            } else if ("generate-default-idgenerators".equals(property.getName())) {
                modelValues.metaGenerateIndirectIdGenerators = true;
            } else if ("function-result".equals(property.getName())) {
                modelValues.metaFunctionsResult.put(property.getDbFunction(), property.getType());
            } else if ("function-result-set".equals(property.getName())) {
                modelValues.metaFunctionsResultSet.put(property.getDbFunction(), property.getDbTable());
            } else if ("procedure-result-set".equals(property.getName())) {
                modelValues.metaProceduresResultSet.put(property.getDbProcedure(), property.getDbTable());
            } else if ("debug-level".equals(property.getName()) && property.getDebug() != null) {
                modelValues.metaDebugLevel = property.getDebug().getDebug();
                modelValues.metaDebugScope = Utils.getPropertyValue(property.getDebug().getScope());
            } else if ("generate-operators".equals(property.getName())) {
                modelValues.metaGenerateOperators = true;
            } else if ("optimize-insert".equals(property.getName())) {
                if (property.getDbTables().isEmpty()) {
                    modelValues.metaOptimizeInsert.add("_ALL_");
                } else {
                    int i = 0;
                    int m = property.getDbTables().size();
                    while (i < m) {
                        modelValues.metaOptimizeInsert.add((String)property.getDbTables().get(i));
                        ++i;
                    }
                }
            } else if ("optional-features".equals(property.getName())) {
                if (!modelValues.metaOptionalFeatures.containsKey(property.getDbStatement())) {
                    modelValues.metaOptionalFeatures.put(property.getDbStatement(), new HashSet());
                }
                int i = 0;
                int m = property.getOptionalFeatures().size();
                while (i < m) {
                    String optionalFeature = Utils.getPropertyValue((ValueType)property.getOptionalFeatures().get(i));
                    modelValues.metaOptionalFeatures.get(property.getDbStatement()).add(optionalFeature);
                    ++i;
                }
            } else if ("active-filter".equals(property.getName())) {
                modelValues.metaActiveFilter = Utils.getPropertyValue(property.getActiveFilter());
            } else if ("insert-skip-default-values".equals(property.getName())) {
                modelValues.metaInsertSkipDefaultValues = true;
                if (property.getDbTables() != null && !property.getDbTables().isEmpty()) {
                    int i = 0;
                    int m = property.getDbTables().size();
                    while (i < m) {
                        modelValues.metaInsertSkipDefaultValuesPos.add((String)property.getDbTables().get(i));
                        ++i;
                    }
                } else if (property.getDbNotTables() != null && !property.getDbNotTables().isEmpty()) {
                    int i = 0;
                    int m = property.getDbNotTables().size();
                    while (i < m) {
                        modelValues.metaInsertSkipDefaultValuesNeg.add((String)property.getDbNotTables().get(i));
                        ++i;
                    }
                }
            }
        }
    }

    private static void setValue(ModelProperty.ModelValues modelValues, DaogenProperty property) {
        if (property == null) {
            return;
        }
        if ("ignore-tables".equals(property.getName())) {
            int i = 0;
            int m = property.getDbTables().size();
            while (i < m) {
                modelValues.daoIgnoreTables.add((String)property.getDbTables().get(i));
                ++i;
            }
        } else if ("only-tables".equals(property.getName())) {
            int i = 0;
            int m = property.getDbTables().size();
            while (i < m) {
                modelValues.daoOnlyTables.add((String)property.getDbTables().get(i));
                ++i;
            }
        } else if ("implements-interfaces".equals(property.getName())) {
            ImplementsExtendsImpl ie = new ImplementsExtendsImpl(property.getToImplements().getToImplement(), false, (List<String>)property.getToImplements().getDbTables(), (List<String>)property.getToImplements().getDbNotTables());
            modelValues.daoToImplements.put(ie.getIdentifier(), ie);
        } else if ("extends-class".equals(property.getName())) {
            ImplementsExtendsImpl ie = new ImplementsExtendsImpl(property.getToExtends().getToExtends(), false, (List<String>)property.getToExtends().getDbTables(), (List<String>)property.getToExtends().getDbNotTables());
            modelValues.daoToExtends = ie;
        } else if ("implements-interfaces-generics".equals(property.getName())) {
            ImplementsExtendsImpl ie = new ImplementsExtendsImpl(property.getToImplementsGenerics().getToImplement(), true, (List<String>)property.getToImplementsGenerics().getDbTables(), (List<String>)property.getToImplementsGenerics().getDbNotTables());
            modelValues.daoToImplements.put(ie.getIdentifier(), ie);
        } else if ("extends-class-generics".equals(property.getName())) {
            ImplementsExtendsImpl ie = new ImplementsExtendsImpl(property.getToExtendsGenerics().getToExtends(), true, (List<String>)property.getToExtendsGenerics().getDbTables(), (List<String>)property.getToExtendsGenerics().getDbNotTables());
            modelValues.daoToExtends = ie;
        } else if ("make-it-final".equals(property.getName())) {
            modelValues.daoMakeItFinal = true;
        } else if ("function-result".equals(property.getName())) {
            modelValues.daoFunctionsResult.put(property.getDbFunction(), new PojoEntityTypeImpl(property.getResultType()));
        } else if ("debug-level".equals(property.getName()) && property.getDebug().getDebug() != null) {
            modelValues.daoDebugLevel = property.getDebug().getDebug();
            modelValues.daoDebugScope = Utils.getPropertyValue(property.getDebug().getScope());
        } else if ("active-filter".equals(property.getName())) {
            modelValues.daoActiveFilter = Utils.getPropertyValue(property.getActiveFilter());
        } else if ("package".equals(property.getName())) {
            modelValues.daoPckg = Utils.getPropertyValue(property.getPckg());
        } else if ("implementation-package".equals(property.getName())) {
            modelValues.daoImplPckg = Utils.getPropertyValue(property.getImplPckg());
        }
    }

    @Override
    public ModelProperty.ModelValues getModelValues(EObject model) {
        if (this.modelValues != null) {
            return this.modelValues;
        }
        EObject emodel = model;
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)emodel, Artifacts.class);
        if (artifacts == null) {
            this.LOGGER.error((Object)("UKNOWN ARTIFACTS FOR " + emodel));
            return null;
        }
        if (artifacts.eResource() == null) {
            this.LOGGER.error((Object)("UKNOWN RESOURCE FOR " + artifacts));
            return null;
        }
        String dir = CommonUtils.resourceDir(artifacts.eResource());
        if (dir == null) {
            this.LOGGER.error((Object)("LOADED RESOURCE URI IS NOT VALID " + artifacts.eResource().getURI()));
            return null;
        }
        return (ModelProperty.ModelValues)this.dirs2models.get(dir);
    }
}

