/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.model.jvmmodel;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.jvmmodel.AbstractModelInferrer;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.JvmAnnotationReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.sqlproc.model.jvmmodel.ProcessorGeneratorUtils;
import org.sqlproc.model.jvmmodel.ProcessorTypesBuilder;
import org.sqlproc.model.processorModel.AnnotatedFeature;
import org.sqlproc.model.processorModel.Annotation;
import org.sqlproc.model.processorModel.DaoDirective;
import org.sqlproc.model.processorModel.DaoDirectiveCrud;
import org.sqlproc.model.processorModel.DaoDirectiveParameters;
import org.sqlproc.model.processorModel.DaoDirectiveQuery;
import org.sqlproc.model.processorModel.DaoEntity;
import org.sqlproc.model.processorModel.DaoFunProcDirective;
import org.sqlproc.model.processorModel.Extends;
import org.sqlproc.model.processorModel.FunProcType;
import org.sqlproc.model.processorModel.FunctionCall;
import org.sqlproc.model.processorModel.FunctionCallQuery;
import org.sqlproc.model.processorModel.FunctionQuery;
import org.sqlproc.model.processorModel.Implements;
import org.sqlproc.model.processorModel.PojoAttribute;
import org.sqlproc.model.processorModel.PojoAttributeDirectivePrimaryKey;
import org.sqlproc.model.processorModel.PojoEntity;
import org.sqlproc.model.processorModel.PojoProcedure;
import org.sqlproc.model.processorModel.ProcedureCallQuery;
import org.sqlproc.model.processorModel.ProcedureUpdate;

public class DaoJvmModelInferrer
extends AbstractModelInferrer {
    @Extension
    public JvmAnnotationReferenceBuilder _annotationTypesBuilder;
    @Extension
    public JvmTypeReferenceBuilder _typeReferenceBuilder;
    @Inject
    @Extension
    private ProcessorTypesBuilder _processorTypesBuilder;
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    @Extension
    private ProcessorGeneratorUtils _processorGeneratorUtils;
    private final String SERIALIZABLE = "java.io.Serializable";
    private final String ENGINE_FACTORY = "org.sqlproc.engine.SqlEngineFactory";
    private final String SESSION_FACTORY = "org.sqlproc.engine.SqlSessionFactory";
    private final String SQL_SESSION = "org.sqlproc.engine.SqlSession";
    private final String SQL_CONTROL = "org.sqlproc.engine.SqlControl";
    private final String SQL_RUNTIME_EXCEPTION = "org.sqlproc.engine.SqlRuntimeException";
    private final String LOGGER = "org.slf4j.Logger";
    private final String LOGGER_FACTORY = "org.slf4j.LoggerFactory";
    private final String CRUD_ENGINE = "org.sqlproc.engine.SqlCrudEngine";
    private final String QUERY_ENGINE = "org.sqlproc.engine.SqlQueryEngine";
    private final String PROCEDURE_ENGINE = "org.sqlproc.engine.SqlProcedureEngine";
    private final String SQL_ROW_PROCESSOR = "org.sqlproc.engine.SqlRowProcessor";
    private final String SET = "java.util.Set";
    private final String HASH_SET = "java.util.HashSet";
    private final String MAP = "java.util.Map";
    private final String HASH_MAP = "java.util.HashMap";
    private final String LIST = "java.util.List";
    private final String ARRAY_LIST = "java.util.ArrayList";
    private final String SQL_STANDARD_CONTROL = "org.sqlproc.engine.impl.SqlStandardControl";

    public void inferDaoIfx(DaoEntity entity, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        JvmGenericType pojoType;
        PojoEntity pojo = this._processorGeneratorUtils.getPojo(entity);
        if (Objects.equal((Object)pojo, null) && !this._processorGeneratorUtils.isFunctionProcedure(entity)) {
            InputOutput.println((Object)("Missing POJO for " + entity));
            return;
        }
        QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)entity);
        String _string = _fullyQualifiedName.toString();
        Procedures.Procedure1 _function = it -> {};
        JvmGenericType entityType = this._processorTypesBuilder.toInterface(entity, _string, _function);
        JvmGenericType _class = null;
        if (pojo != null) {
            QualifiedName _fullyQualifiedName_1 = null;
            if (pojo != null) {
                _fullyQualifiedName_1 = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)pojo);
            }
            _class = this._processorTypesBuilder.toClass(pojo, _fullyQualifiedName_1);
        }
        if (Objects.equal(pojoType = _class, null) && !this._processorGeneratorUtils.isFunctionProcedure(entity)) {
            InputOutput.println((Object)("Missing POJOTYPE for " + entity));
            return;
        }
        PojoAttribute primaryKey = this._processorGeneratorUtils.getPrimaryKey(pojo);
        PojoAttributeDirectivePrimaryKey _primaryKeyDir = null;
        if (primaryKey != null) {
            _primaryKeyDir = this._processorGeneratorUtils.getPrimaryKeyDir(primaryKey);
        }
        PojoAttributeDirectivePrimaryKey pkDir = _primaryKeyDir;
        String simpleName = entity.getName();
        Integer sernum = this._processorGeneratorUtils.getSernum(entity);
        Procedures.Procedure1 _function_1 = it -> {
            boolean _notEquals;
            String _documentation = this._processorTypesBuilder.getDocumentation(entity);
            this._processorTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _documentation);
            List<Implements> _implements = this._processorGeneratorUtils.getImplements(entity);
            for (Implements impl : _implements) {
                boolean _isGenerics = this._processorGeneratorUtils.isGenerics(impl);
                if (_isGenerics) {
                    JvmParameterizedTypeReference _implements_1 = impl.getImplements();
                    JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
                    JvmTypeReference genericType = this._typeReferenceBuilder.typeRef((JvmType)it, new JvmTypeReference[]{_implements_1, _typeRef});
                    EList _superTypes = it.getSuperTypes();
                    this._processorTypesBuilder.operator_add(_superTypes, genericType);
                    continue;
                }
                EList _superTypes_1 = it.getSuperTypes();
                JvmParameterizedTypeReference _implements_2 = impl.getImplements();
                JvmTypeReference _cloneWithProxies = this._processorTypesBuilder.cloneWithProxies((JvmTypeReference)_implements_2);
                this._processorTypesBuilder.operator_add(_superTypes_1, _cloneWithProxies);
            }
            boolean bl = _notEquals = !Objects.equal((Object)sernum, null);
            if (_notEquals) {
                EList _superTypes_2 = it.getSuperTypes();
                JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("java.io.Serializable", new JvmTypeReference[0]);
                this._processorTypesBuilder.operator_add(_superTypes_2, _typeRef_1);
            }
            Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses = null;
            EList<DaoDirective> _directives = entity.getDirectives();
            for (DaoDirective dir : _directives) {
                if (dir instanceof DaoDirectiveCrud) {
                    boolean _equals = Objects.equal((Object)moreResultClasses, null);
                    if (_equals) {
                        Map<String, Map<String, JvmParameterizedTypeReference>> _moreResultClasses;
                        moreResultClasses = _moreResultClasses = this._processorGeneratorUtils.getMoreResultClasses(entity);
                    }
                    EList _members = it.getMembers();
                    this.inferInsertIfx(entity, (DaoDirectiveCrud)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)_members);
                    EList _members_1 = it.getMembers();
                    this.inferGetIfx(entity, (DaoDirectiveCrud)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)_members_1, moreResultClasses);
                    EList _members_2 = it.getMembers();
                    this.inferUpdateIfx(entity, (DaoDirectiveCrud)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)_members_2);
                    EList _members_3 = it.getMembers();
                    this.inferDeleteIfx(entity, (DaoDirectiveCrud)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)_members_3);
                    continue;
                }
                if (dir instanceof DaoDirectiveQuery) {
                    boolean _equals_1 = Objects.equal((Object)moreResultClasses, null);
                    if (_equals_1) {
                        Map<String, Map<String, JvmParameterizedTypeReference>> _moreResultClasses_1;
                        moreResultClasses = _moreResultClasses_1 = this._processorGeneratorUtils.getMoreResultClasses(entity);
                    }
                    EList _members_4 = it.getMembers();
                    this.inferListIfx(entity, (DaoDirectiveQuery)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)_members_4, moreResultClasses);
                    EList _members_5 = it.getMembers();
                    this.inferQueryIfx(entity, (DaoDirectiveQuery)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)_members_5, moreResultClasses);
                    if (!(Objects.equal((Object)primaryKey, null) || Objects.equal((Object)pkDir.getFromTo(), null) || this._processorGeneratorUtils.toInitAttributes(pojo).isEmpty())) {
                        EList _members_6 = it.getMembers();
                        this.inferListFromToIfx(entity, (DaoDirectiveQuery)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)_members_6, moreResultClasses);
                    }
                    EList _members_7 = it.getMembers();
                    this.inferCountIfx(entity, (DaoDirectiveQuery)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)_members_7, moreResultClasses);
                    continue;
                }
                if (!(dir instanceof DaoFunProcDirective)) continue;
                FunProcType _type = ((DaoFunProcDirective)dir).getType();
                DaoDirectiveParameters _paramlist = ((DaoFunProcDirective)dir).getParamlist();
                EList _members_8 = it.getMembers();
                this.inferFunctionProcedureIfx(entity, _type, _paramlist, entityType, simpleName, (List<JvmMember>)_members_8);
            }
            if (!Objects.equal(moreResultClasses, null) && !moreResultClasses.isEmpty()) {
                EList _members_9 = it.getMembers();
                this.inferMoreResultClassesIfx(entity, entityType, simpleName, pojo, pojoType, (List<JvmMember>)_members_9, moreResultClasses);
            }
        };
        acceptor.accept((JvmDeclaredType)entityType, _function_1);
    }

    public void inferDao(DaoEntity entity, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase, String implPackage) {
        JvmGenericType pojoType;
        boolean _notEquals;
        PojoEntity pojo = this._processorGeneratorUtils.getPojo(entity);
        if (Objects.equal((Object)pojo, null) && !this._processorGeneratorUtils.isFunctionProcedure(entity)) {
            InputOutput.println((Object)("Missing POJO for " + entity));
            return;
        }
        QualifiedName _daoFullyQualifiedName = this.daoFullyQualifiedName(entity, implPackage);
        JvmGenericType entityType = this._processorTypesBuilder.toClass(entity, _daoFullyQualifiedName);
        JvmGenericType _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)implPackage, null);
        if (_notEquals) {
            QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)entity);
            String _string = _fullyQualifiedName.toString();
            Procedures.Procedure1 _function = it -> {};
            _xifexpression = this._processorTypesBuilder.toInterface(entity, _string, _function);
        }
        JvmGenericType entityTypeIfx = _xifexpression;
        JvmGenericType _class = null;
        if (pojo != null) {
            QualifiedName _fullyQualifiedName_1 = null;
            if (pojo != null) {
                _fullyQualifiedName_1 = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)pojo);
            }
            _class = this._processorTypesBuilder.toClass(pojo, _fullyQualifiedName_1);
        }
        if (Objects.equal(pojoType = _class, null) && !this._processorGeneratorUtils.isFunctionProcedure(entity)) {
            InputOutput.println((Object)("Missing POJOTYPE for " + entity));
            return;
        }
        PojoAttribute primaryKey = this._processorGeneratorUtils.getPrimaryKey(pojo);
        PojoAttributeDirectivePrimaryKey _primaryKeyDir = null;
        if (primaryKey != null) {
            _primaryKeyDir = this._processorGeneratorUtils.getPrimaryKeyDir(primaryKey);
        }
        PojoAttributeDirectivePrimaryKey pkDir = _primaryKeyDir;
        String simpleName = entity.getName();
        final Integer sernum = this._processorGeneratorUtils.getSernum(entity);
        Procedures.Procedure1 _function_1 = it -> {
            String _name;
            EList _members_17;
            boolean _notEquals_4;
            JvmParameterizedTypeReference _superType;
            boolean _notEquals_3;
            boolean _notEquals_2;
            boolean _notEquals_1;
            String _documentation = this._processorTypesBuilder.getDocumentation(entity);
            this._processorTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _documentation);
            List<Annotation> _standardAnnotations = this._processorGeneratorUtils.standardAnnotations(entity);
            Functions.Function1 _function_2 = a -> a.getAnnotation();
            List _map = ListExtensions.map(_standardAnnotations, (Functions.Function1)_function_2);
            for (XAnnotation an : _map) {
                JvmType _annotationType = an.getAnnotationType();
                String _identifier = _annotationType.getIdentifier();
                boolean _equals = Objects.equal((Object)_identifier, (Object)"java.io.Serializable");
                if (_equals) {
                    EList _superTypes = it.getSuperTypes();
                    JvmType _annotationType_1 = an.getAnnotationType();
                    JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(_annotationType_1, new JvmTypeReference[0]);
                    this._processorTypesBuilder.operator_add(_superTypes, _typeRef);
                    continue;
                }
                this._processorTypesBuilder.addAnnotation((JvmAnnotationTarget)it, an);
            }
            boolean bl = _notEquals_1 = !Objects.equal((Object)entityTypeIfx, null);
            if (_notEquals_1) {
                EList _superTypes_1 = it.getSuperTypes();
                JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef((JvmType)entityTypeIfx, new JvmTypeReference[0]);
                this._processorTypesBuilder.operator_add(_superTypes_1, _typeRef_1);
            }
            List<Implements> _implements = this._processorGeneratorUtils.getImplements(entity);
            for (Implements impl : _implements) {
                boolean _isGenerics = this._processorGeneratorUtils.isGenerics(impl);
                if (_isGenerics) {
                    JvmParameterizedTypeReference _implements_1 = impl.getImplements();
                    String name = _implements_1.getIdentifier();
                    JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
                    JvmTypeReference ref = this._typeReferenceBuilder.typeRef(name, new JvmTypeReference[]{_typeRef_2});
                    EList _superTypes_2 = it.getSuperTypes();
                    this._processorTypesBuilder.operator_add(_superTypes_2, ref);
                    continue;
                }
                EList _superTypes_3 = it.getSuperTypes();
                JvmParameterizedTypeReference _implements_2 = impl.getImplements();
                JvmTypeReference _cloneWithProxies = this._processorTypesBuilder.cloneWithProxies((JvmTypeReference)_implements_2);
                this._processorTypesBuilder.operator_add(_superTypes_3, _cloneWithProxies);
            }
            Extends ext = this._processorGeneratorUtils.getExtends(entity);
            boolean bl2 = _notEquals_2 = !Objects.equal((Object)ext, null);
            if (_notEquals_2) {
                EList _superTypes_4 = it.getSuperTypes();
                JvmParameterizedTypeReference _extends = ext.getExtends();
                JvmTypeReference _cloneWithProxies_1 = this._processorTypesBuilder.cloneWithProxies((JvmTypeReference)_extends);
                this._processorTypesBuilder.operator_add(_superTypes_4, _cloneWithProxies_1);
            }
            boolean bl3 = _notEquals_3 = !Objects.equal((Object)(_superType = entity.getSuperType()), null);
            if (_notEquals_3) {
                EList _superTypes_5 = it.getSuperTypes();
                JvmParameterizedTypeReference _superType_1 = entity.getSuperType();
                JvmTypeReference _cloneWithProxies_2 = this._processorTypesBuilder.cloneWithProxies((JvmTypeReference)_superType_1);
                this._processorTypesBuilder.operator_add(_superTypes_5, _cloneWithProxies_2);
            }
            boolean bl4 = _notEquals_4 = !Objects.equal((Object)sernum, null);
            if (_notEquals_4) {
                EList _superTypes_6 = it.getSuperTypes();
                JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("java.io.Serializable", new JvmTypeReference[0]);
                this._processorTypesBuilder.operator_add(_superTypes_6, _typeRef_3);
                EList _members = it.getMembers();
                JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef(Long.TYPE, new JvmTypeReference[0]);
                Procedures.Procedure1 _function_3 = it_1 -> {
                    it_1.setStatic(true);
                    it_1.setFinal(true);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)sernum, "");
                            _builder.append((Object)"L");
                        }
                    };
                    this._processorTypesBuilder.setInitializer((JvmField)it_1, _client);
                };
                JvmField _field = this._processorTypesBuilder.toField(entity, "serialVersionUID", _typeRef_4, _function_3);
                this._processorTypesBuilder.operator_add(_members, _field);
            }
            EList _members_1 = it.getMembers();
            JvmTypeReference _typeRef_5 = this._typeReferenceBuilder.typeRef("org.slf4j.Logger", new JvmTypeReference[0]);
            Procedures.Procedure1 _function_4 = it_1 -> {
                it_1.setVisibility(JvmVisibility.PROTECTED);
                it_1.setFinal(true);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"org.slf4j.LoggerFactory", "");
                        _builder.append((Object)".getLogger(getClass())");
                    }
                };
                this._processorTypesBuilder.setInitializer((JvmField)it_1, _client);
            };
            JvmField _field_1 = this._processorTypesBuilder.toField(entity, "logger", _typeRef_5, _function_4);
            this._processorTypesBuilder.operator_add(_members_1, _field_1);
            EList _members_2 = it.getMembers();
            Procedures.Procedure1 _function_5 = it_1 -> {
                List<Annotation> _constructorAnnotations = this._processorGeneratorUtils.constructorAnnotations(entity);
                Functions.Function1 _function_6 = a -> a.getAnnotation();
                List _map_1 = ListExtensions.map(_constructorAnnotations, (Functions.Function1)_function_6);
                this._processorTypesBuilder.addAnnotations((JvmAnnotationTarget)it_1, _map_1);
            };
            JvmConstructor _constructor = this._processorTypesBuilder.toConstructor(entity, _function_5);
            this._processorTypesBuilder.operator_add(_members_2, _constructor);
            EList _members_3 = it.getMembers();
            Procedures.Procedure1 _function_6 = it_1 -> {
                EList _parameters = it_1.getParameters();
                JvmTypeReference _typeRef_6 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlEngineFactory", new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlEngineFactory", _typeRef_6);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
                List<Annotation> _constructorAnnotations = this._processorGeneratorUtils.constructorAnnotations(entity);
                Functions.Function1 _function_7 = a -> a.getAnnotation();
                List _map_1 = ListExtensions.map(_constructorAnnotations, (Functions.Function1)_function_7);
                this._processorTypesBuilder.addAnnotations((JvmAnnotationTarget)it_1, _map_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"this.sqlEngineFactory = sqlEngineFactory;");
                        _builder.newLine();
                    }
                };
                this._processorTypesBuilder.setBody((JvmExecutable)it_1, _client);
            };
            JvmConstructor _constructor_1 = this._processorTypesBuilder.toConstructor(entity, _function_6);
            this._processorTypesBuilder.operator_add(_members_3, _constructor_1);
            EList _members_4 = it.getMembers();
            Procedures.Procedure1 _function_7 = it_1 -> {
                EList _parameters = it_1.getParameters();
                JvmTypeReference _typeRef_6 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlEngineFactory", new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlEngineFactory", _typeRef_6);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
                EList _parameters_1 = it_1.getParameters();
                JvmTypeReference _typeRef_7 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSessionFactory", new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlSessionFactory", _typeRef_7);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
                List<Annotation> _constructorAnnotations = this._processorGeneratorUtils.constructorAnnotations(entity);
                Functions.Function1 _function_8 = a -> a.getAnnotation();
                List _map_1 = ListExtensions.map(_constructorAnnotations, (Functions.Function1)_function_8);
                this._processorTypesBuilder.addAnnotations((JvmAnnotationTarget)it_1, _map_1);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"this.sqlEngineFactory = sqlEngineFactory;");
                        _builder.newLine();
                        _builder.append((Object)"this.sqlSessionFactory = sqlSessionFactory;");
                        _builder.newLine();
                    }
                };
                this._processorTypesBuilder.setBody((JvmExecutable)it_1, _client);
            };
            JvmConstructor _constructor_2 = this._processorTypesBuilder.toConstructor(entity, _function_7);
            this._processorTypesBuilder.operator_add(_members_4, _constructor_2);
            EList _members_5 = it.getMembers();
            JvmTypeReference _typeRef_6 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlEngineFactory", new JvmTypeReference[0]);
            Procedures.Procedure1 _function_8 = it_1 -> it_1.setVisibility(JvmVisibility.PROTECTED);
            JvmField _field_2 = this._processorTypesBuilder.toField(entity, "sqlEngineFactory", _typeRef_6, _function_8);
            this._processorTypesBuilder.operator_add(_members_5, _field_2);
            EList _members_6 = it.getMembers();
            JvmTypeReference _typeRef_7 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSessionFactory", new JvmTypeReference[0]);
            Procedures.Procedure1 _function_9 = it_1 -> it_1.setVisibility(JvmVisibility.PROTECTED);
            JvmField _field_3 = this._processorTypesBuilder.toField(entity, "sqlSessionFactory", _typeRef_7, _function_9);
            this._processorTypesBuilder.operator_add(_members_6, _field_3);
            Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses = null;
            EList<DaoDirective> _directives = entity.getDirectives();
            for (DaoDirective dir : _directives) {
                if (dir instanceof DaoDirectiveCrud) {
                    boolean _equals_1 = Objects.equal((Object)moreResultClasses, null);
                    if (_equals_1) {
                        Map<String, Map<String, JvmParameterizedTypeReference>> _moreResultClasses;
                        moreResultClasses = _moreResultClasses = this._processorGeneratorUtils.getMoreResultClasses(entity);
                    }
                    EList _members_7 = it.getMembers();
                    this.inferInsert(entity, (DaoDirectiveCrud)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)_members_7);
                    EList _members_8 = it.getMembers();
                    this.inferGet(entity, (DaoDirectiveCrud)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)_members_8, moreResultClasses);
                    EList _members_9 = it.getMembers();
                    this.inferUpdate(entity, (DaoDirectiveCrud)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)_members_9);
                    EList _members_10 = it.getMembers();
                    this.inferDelete(entity, (DaoDirectiveCrud)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)_members_10);
                    continue;
                }
                if (dir instanceof DaoDirectiveQuery) {
                    boolean _equals_2 = Objects.equal((Object)moreResultClasses, null);
                    if (_equals_2) {
                        Map<String, Map<String, JvmParameterizedTypeReference>> _moreResultClasses_1;
                        moreResultClasses = _moreResultClasses_1 = this._processorGeneratorUtils.getMoreResultClasses(entity);
                    }
                    EList _members_11 = it.getMembers();
                    this.inferList(entity, (DaoDirectiveQuery)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)_members_11, moreResultClasses);
                    EList _members_12 = it.getMembers();
                    this.inferQuery(entity, (DaoDirectiveQuery)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)_members_12, moreResultClasses);
                    if (!(Objects.equal((Object)primaryKey, null) || Objects.equal((Object)pkDir.getFromTo(), null) || this._processorGeneratorUtils.toInitAttributes(pojo).isEmpty())) {
                        EList _members_13 = it.getMembers();
                        this.inferListFromTo(entity, (DaoDirectiveQuery)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)_members_13, moreResultClasses, primaryKey);
                    }
                    EList _members_14 = it.getMembers();
                    this.inferCount(entity, (DaoDirectiveQuery)dir, entityType, simpleName, pojo, pojoType, (List<JvmMember>)_members_14, moreResultClasses);
                    continue;
                }
                if (!(dir instanceof DaoFunProcDirective)) continue;
                FunProcType _type = ((DaoFunProcDirective)dir).getType();
                DaoDirectiveParameters _paramlist = ((DaoFunProcDirective)dir).getParamlist();
                EList _members_15 = it.getMembers();
                this.inferFunctionProcedure(entity, _type, _paramlist, entityType, simpleName, (List<JvmMember>)_members_15);
            }
            if (!Objects.equal(moreResultClasses, null) && !moreResultClasses.isEmpty()) {
                EList _members_16 = it.getMembers();
                this.inferMoreResultClasses(entity, entityType, simpleName, pojo, pojoType, (List<JvmMember>)_members_16, moreResultClasses);
            }
            HashSet<String> procNames = new HashSet<String>();
            EList<AnnotatedFeature> _features = entity.getFeatures();
            Functions.Function1 _function_10 = it_1 -> it_1.getFeature();
            List _map_1 = ListExtensions.map(_features, (Functions.Function1)_function_10);
            Iterable _filter = Iterables.filter((Iterable)_map_1, PojoAttribute.class);
            for (PojoAttribute attr : _filter) {
                Procedures.Procedure1 _function_13;
                JvmTypeReference _typeRef_9;
                String _name_4;
                String _name_3;
                JvmOperation m2;
                boolean _notEquals_6;
                boolean _notEquals_5;
                Procedures.Procedure1 _function_12;
                String _name_2;
                boolean _not;
                JvmParameterizedTypeReference _elvis = null;
                JvmParameterizedTypeReference _elvis_1 = null;
                JvmParameterizedTypeReference _type_1 = attr.getType();
                if (_type_1 != null) {
                    _elvis_1 = _type_1;
                } else {
                    XExpression _initExpr = attr.getInitExpr();
                    JvmTypeReference _inferredType = null;
                    if (_initExpr != null) {
                        _inferredType = this._processorTypesBuilder.inferredType(_initExpr);
                    }
                    _elvis_1 = _inferredType;
                }
                if (_elvis_1 != null) {
                    _elvis = _elvis_1;
                } else {
                    JvmTypeReference _typeRef_8 = this._typeReferenceBuilder.typeRef(String.class, new JvmTypeReference[0]);
                    _elvis = _typeRef_8;
                }
                JvmParameterizedTypeReference type = _elvis;
                _members_17 = it.getMembers();
                _name = attr.getName();
                Procedures.Procedure1 _function_11 = arg_0 -> this.lambda$119(attr, (JvmTypeReference)type, arg_0);
                JvmField _field_4 = this._processorTypesBuilder.toField(entity, _name, (JvmTypeReference)type, _function_11);
                this._processorTypesBuilder.operator_add(_members_17, _field_4);
                boolean _isStatic = attr.isStatic();
                boolean bl5 = _not = !_isStatic;
                if (!_not) continue;
                String _name_1 = attr.getName();
                JvmOperation m1 = this._processorTypesBuilder.toGetter(attr, _name_1, _name_2 = attr.getName(), (JvmTypeReference)type, procNames, (Procedures.Procedure1<? super JvmOperation>)(_function_12 = it_1 -> {
                    List<Annotation> _terAnnotations = this._processorGeneratorUtils.getterAnnotations(attr);
                    Functions.Function1 _function_13 = a -> a.getAnnotation();
                    List _map_2 = ListExtensions.map(_terAnnotations, (Functions.Function1)_function_13);
                    this._processorTypesBuilder.addAnnotations((JvmAnnotationTarget)it_1, _map_2);
                }));
                boolean bl6 = _notEquals_5 = !Objects.equal((Object)m1, null);
                if (_notEquals_5) {
                    EList _members_18 = it.getMembers();
                    this._processorTypesBuilder.operator_add(_members_18, m1);
                }
                boolean bl7 = _notEquals_6 = !Objects.equal((Object)(m2 = this._processorTypesBuilder.toSetter(attr, _name_3 = attr.getName(), _name_4 = attr.getName(), (JvmTypeReference)type, _typeRef_9 = this._typeReferenceBuilder.typeRef((JvmType)entityType, new JvmTypeReference[0]), procNames, (Procedures.Procedure1<? super JvmOperation>)(_function_13 = it_1 -> {
                    List<Annotation> _setterAnnotations = this._processorGeneratorUtils.setterAnnotations(attr);
                    Functions.Function1 _function_14 = a -> a.getAnnotation();
                    List _map_2 = ListExtensions.map(_setterAnnotations, (Functions.Function1)_function_14);
                    this._processorTypesBuilder.addAnnotations((JvmAnnotationTarget)it_1, _map_2);
                }))), null);
                if (!_notEquals_6) continue;
                EList _members_19 = it.getMembers();
                this._processorTypesBuilder.operator_add(_members_19, m2);
            }
            EList<AnnotatedFeature> _features_1 = entity.getFeatures();
            Functions.Function1 _function_11 = it_1 -> it_1.getFeature();
            List _map_2 = ListExtensions.map(_features_1, (Functions.Function1)_function_11);
            Iterable _filter_1 = Iterables.filter((Iterable)_map_2, PojoProcedure.class);
            for (PojoProcedure proc : _filter_1) {
                _members_17 = it.getMembers();
                _name = proc.getName();
                JvmParameterizedTypeReference _elvis = null;
                JvmParameterizedTypeReference _type_1 = proc.getType();
                if (_type_1 != null) {
                    _elvis = _type_1;
                } else {
                    JvmTypeReference _inferredType = this._processorTypesBuilder.inferredType();
                    _elvis = _inferredType;
                }
                Procedures.Procedure1 _function_12 = it_1 -> {
                    String _documentation_1 = this._processorTypesBuilder.getDocumentation(proc);
                    this._processorTypesBuilder.setDocumentation((JvmIdentifiableElement)it_1, _documentation_1);
                    boolean _isStatic = proc.isStatic();
                    it_1.setStatic(_isStatic);
                    EList<JvmFormalParameter> _params = proc.getParams();
                    for (JvmFormalParameter param : _params) {
                        EList _parameters = it_1.getParameters();
                        String _name_1 = param.getName();
                        JvmTypeReference _parameterType = param.getParameterType();
                        JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter((EObject)param, _name_1, _parameterType);
                        this._processorTypesBuilder.operator_add(_parameters, _parameter);
                    }
                    XExpression _body = proc.getBody();
                    this._processorTypesBuilder.setBody((JvmExecutable)it_1, _body);
                };
                JvmOperation _method = this._processorTypesBuilder.toMethod(proc, _name, (JvmTypeReference)_elvis, _function_12);
                this._processorTypesBuilder.operator_add(_members_17, _method);
            }
        };
        acceptor.accept((JvmDeclaredType)entityType, _function_1);
    }

    public void inferInsert(DaoEntity entity, DaoDirectiveCrud dir, JvmGenericType entityType, String simpleName, final PojoEntity pojo, JvmGenericType pojoType, List<JvmMember> members) {
        String _name = pojo.getName();
        final String pojoAttrName = StringExtensions.toFirstLower((String)_name);
        final PojoEntity parent = this._processorGeneratorUtils.getParentReflectInheritance(pojo);
        JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    boolean _notEquals;
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql insert ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)": \" + ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)" + \" \" + sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"org.sqlproc.engine.SqlCrudEngine", "");
                    _builder.append((Object)" sqlInsert");
                    String _name = pojo.getName();
                    _builder.append((Object)_name, "");
                    _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"INSERT_");
                    String _name_1 = pojo.getName();
                    String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(_name_1);
                    _builder.append((Object)_dbName, "");
                    _builder.append((Object)"\");");
                    boolean bl = _notEquals = !Objects.equal((Object)parent, null);
                    if (_notEquals) {
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"org.sqlproc.engine.SqlCrudEngine", "");
                        _builder.append((Object)" sqlInsert");
                        String _name_2 = parent.getName();
                        _builder.append((Object)_name_2, "");
                        _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"INSERT_");
                        String _name_3 = parent.getName();
                        String _dbName_1 = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(_name_3);
                        _builder.append((Object)_dbName_1, "");
                        _builder.append((Object)"\");");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"int count = sqlInsert");
                        String _name_4 = parent.getName();
                        _builder.append((Object)_name_4, "");
                        _builder.append((Object)".insert(sqlSession, ");
                        _builder.append((Object)pojoAttrName, "");
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"if (count > 0) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"sqlInsert");
                        String _name_5 = pojo.getName();
                        _builder.append((Object)_name_5, "\t");
                        _builder.append((Object)".insert(sqlSession, ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                    } else {
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"int count = sqlInsert");
                        String _name_6 = pojo.getName();
                        _builder.append((Object)_name_6, "");
                        _builder.append((Object)".insert(sqlSession, ");
                        _builder.append((Object)pojoAttrName, "");
                        _builder.append((Object)", sqlControl);");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql insert ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)" result: \" + count + \" \" + ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"return (count > 0) ? ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)" : null;");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "insert", _typeRef, _function);
        members.add((JvmMember)_method);
        JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_1 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return insert(sqlSessionFactory.getSqlSession(), ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "insert", _typeRef_1, _function_1);
        members.add((JvmMember)_method_1);
        JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return insert(sqlSession, ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "insert", _typeRef_2, _function_2);
        members.add((JvmMember)_method_2);
        JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_3 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return insert(");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "insert", _typeRef_3, _function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferInsertIfx(DaoEntity entity, DaoDirectiveCrud dir, JvmGenericType entityType, String simpleName, PojoEntity pojo, JvmGenericType pojoType, List<JvmMember> members) {
        String _name = pojo.getName();
        String pojoAttrName = StringExtensions.toFirstLower((String)_name);
        JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "insert", _typeRef, _function);
        members.add((JvmMember)_method);
        JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_1 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "insert", _typeRef_1, _function_1);
        members.add((JvmMember)_method_1);
        JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "insert", _typeRef_2, _function_2);
        members.add((JvmMember)_method_2);
        JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_3 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "insert", _typeRef_3, _function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferGet(DaoEntity entity, DaoDirectiveCrud dir, JvmGenericType entityType, String simpleName, final PojoEntity pojo, JvmGenericType pojoType, List<JvmMember> members, final Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        String _name = pojo.getName();
        final String pojoAttrName = StringExtensions.toFirstLower((String)_name);
        JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql get: \" + ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)" + \" \" + sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"org.sqlproc.engine.SqlCrudEngine", "");
                    _builder.append((Object)" sqlGetEngine");
                    String _name = pojo.getName();
                    _builder.append((Object)_name, "");
                    _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"GET_");
                    String _name_1 = pojo.getName();
                    String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(_name_1);
                    _builder.append((Object)_dbName, "");
                    _builder.append((Object)"\");");
                    _builder.newLineIfNotEmpty();
                    boolean _isEmpty = moreResultClasses.isEmpty();
                    if (_isEmpty) {
                        _builder.append((Object)"//");
                    }
                    _builder.append((Object)"sqlControl = getMoreResultClasses(");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                    String _name_2 = pojo.getName();
                    _builder.append((Object)_name_2, "");
                    _builder.append((Object)" ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)"Got = sqlGetEngine");
                    String _name_3 = pojo.getName();
                    _builder.append((Object)_name_3, "");
                    _builder.append((Object)".get(sqlSession, ");
                    String _name_4 = pojo.getName();
                    _builder.append((Object)_name_4, "");
                    _builder.append((Object)".class, ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql get ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)" result: \" + ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)"Got);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"return ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)"Got;");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "get", _typeRef, _function);
        members.add((JvmMember)_method);
        JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_1 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return get(sqlSessionFactory.getSqlSession(), ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "get", _typeRef_1, _function_1);
        members.add((JvmMember)_method_1);
        JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return get(sqlSession, ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "get", _typeRef_2, _function_2);
        members.add((JvmMember)_method_2);
        JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_3 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return get(");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "get", _typeRef_3, _function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferGetIfx(DaoEntity entity, DaoDirectiveCrud dir, JvmGenericType entityType, String simpleName, PojoEntity pojo, JvmGenericType pojoType, List<JvmMember> members, Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        String _name = pojo.getName();
        String pojoAttrName = StringExtensions.toFirstLower((String)_name);
        JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "get", _typeRef, _function);
        members.add((JvmMember)_method);
        JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_1 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "get", _typeRef_1, _function_1);
        members.add((JvmMember)_method_1);
        JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "get", _typeRef_2, _function_2);
        members.add((JvmMember)_method_2);
        JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_3 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "get", _typeRef_3, _function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferUpdate(DaoEntity entity, DaoDirectiveCrud dir, JvmGenericType entityType, String simpleName, final PojoEntity pojo, JvmGenericType pojoType, List<JvmMember> members) {
        String _name = pojo.getName();
        final String pojoAttrName = StringExtensions.toFirstLower((String)_name);
        final PojoEntity parent = this._processorGeneratorUtils.getParentReflectInheritance(pojo);
        JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    PojoAttribute f;
                    boolean _notEquals_2;
                    boolean _notEquals_1;
                    boolean _notEquals;
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql update ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)": \" + ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)" + \" \" + sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"org.sqlproc.engine.SqlCrudEngine", "");
                    _builder.append((Object)" sqlUpdateEngine");
                    String _name = pojo.getName();
                    _builder.append((Object)_name, "");
                    _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"UPDATE_");
                    String _name_1 = pojo.getName();
                    String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(_name_1);
                    _builder.append((Object)_dbName, "");
                    _builder.append((Object)"\");");
                    boolean bl = _notEquals = !Objects.equal((Object)parent, null);
                    if (_notEquals) {
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"org.sqlproc.engine.SqlCrudEngine", "");
                        _builder.append((Object)" sqlUpdate");
                        String _name_2 = parent.getName();
                        _builder.append((Object)_name_2, "");
                        _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"UPDATE_");
                        String _name_3 = parent.getName();
                        String _dbName_1 = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(_name_3);
                        _builder.append((Object)_dbName_1, "");
                        _builder.append((Object)"\");");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"int count = sqlUpdateEngine");
                    String _name_4 = pojo.getName();
                    _builder.append((Object)_name_4, "");
                    _builder.append((Object)".update(sqlSession, ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", sqlControl);");
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)parent, null);
                    if (_notEquals_1) {
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"if (count > 0) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"sqlUpdate");
                        String _name_5 = parent.getName();
                        _builder.append((Object)_name_5, "\t");
                        _builder.append((Object)".update(sqlSession, ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                    }
                    boolean bl3 = _notEquals_2 = !Objects.equal((Object)(f = DaoJvmModelInferrer.this._processorGeneratorUtils.getOptLock(pojo)), null);
                    if (_notEquals_2) {
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"if (count > 0) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)".set");
                        String _name_6 = f.getName();
                        String _firstUpper = DaoJvmModelInferrer.this._processorTypesBuilder.toFirstUpper(_name_6);
                        _builder.append((Object)_firstUpper, "\t");
                        _builder.append((Object)"(");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)".get");
                        String _name_7 = f.getName();
                        String _firstUpper_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toFirstUpper(_name_7);
                        _builder.append((Object)_firstUpper_1, "\t");
                        _builder.append((Object)"() + 1);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql update ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)" result count: \" + count);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"return count;");
                    _builder.newLine();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "update", _typeRef, _function);
        members.add((JvmMember)_method);
        JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_1 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return update(sqlSessionFactory.getSqlSession(), ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "update", _typeRef_1, _function_1);
        members.add((JvmMember)_method_1);
        JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return update(sqlSession, ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "update", _typeRef_2, _function_2);
        members.add((JvmMember)_method_2);
        JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_3 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return update(");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "update", _typeRef_3, _function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferUpdateIfx(DaoEntity entity, DaoDirectiveCrud dir, JvmGenericType entityType, String simpleName, PojoEntity pojo, JvmGenericType pojoType, List<JvmMember> members) {
        String _name = pojo.getName();
        String pojoAttrName = StringExtensions.toFirstLower((String)_name);
        JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "update", _typeRef, _function);
        members.add((JvmMember)_method);
        JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_1 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "update", _typeRef_1, _function_1);
        members.add((JvmMember)_method_1);
        JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "update", _typeRef_2, _function_2);
        members.add((JvmMember)_method_2);
        JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_3 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "update", _typeRef_3, _function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferDelete(DaoEntity entity, DaoDirectiveCrud dir, JvmGenericType entityType, String simpleName, final PojoEntity pojo, JvmGenericType pojoType, List<JvmMember> members) {
        String _name = pojo.getName();
        final String pojoAttrName = StringExtensions.toFirstLower((String)_name);
        final PojoEntity parent = this._processorGeneratorUtils.getParentReflectInheritance(pojo);
        JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    PojoAttribute f;
                    boolean _notEquals_2;
                    boolean _notEquals_1;
                    boolean _notEquals;
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql delete ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)": \" + ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)" + \" \" + sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"org.sqlproc.engine.SqlCrudEngine", "");
                    _builder.append((Object)" sqlDeleteEngine");
                    String _name = pojo.getName();
                    _builder.append((Object)_name, "");
                    _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"DELETE_");
                    String _name_1 = pojo.getName();
                    String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(_name_1);
                    _builder.append((Object)_dbName, "");
                    _builder.append((Object)"\");");
                    boolean bl = _notEquals = !Objects.equal((Object)parent, null);
                    if (_notEquals) {
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"org.sqlproc.engine.SqlCrudEngine", "");
                        _builder.append((Object)" sqlDelete");
                        String _name_2 = parent.getName();
                        _builder.append((Object)_name_2, "");
                        _builder.append((Object)" = sqlEngineFactory.getCheckedCrudEngine(\"DELETE_");
                        String _name_3 = parent.getName();
                        String _dbName_1 = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(_name_3);
                        _builder.append((Object)_dbName_1, "");
                        _builder.append((Object)"\");");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"int count = sqlDeleteEngine");
                    String _name_4 = pojo.getName();
                    _builder.append((Object)_name_4, "");
                    _builder.append((Object)".delete(sqlSession, ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", sqlControl);");
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)parent, null);
                    if (_notEquals_1) {
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"if (count > 0) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"sqlDelete");
                        String _name_5 = parent.getName();
                        _builder.append((Object)_name_5, "\t");
                        _builder.append((Object)".delete(sqlSession, ");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)", sqlControl);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                    }
                    boolean bl3 = _notEquals_2 = !Objects.equal((Object)(f = DaoJvmModelInferrer.this._processorGeneratorUtils.getOptLock(pojo)), null);
                    if (_notEquals_2) {
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"if (count > 0) {");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)".set");
                        String _name_6 = f.getName();
                        String _firstUpper = DaoJvmModelInferrer.this._processorTypesBuilder.toFirstUpper(_name_6);
                        _builder.append((Object)_firstUpper, "\t");
                        _builder.append((Object)"(");
                        _builder.append((Object)pojoAttrName, "\t");
                        _builder.append((Object)".get");
                        String _name_7 = f.getName();
                        String _firstUpper_1 = DaoJvmModelInferrer.this._processorTypesBuilder.toFirstUpper(_name_7);
                        _builder.append((Object)_firstUpper_1, "\t");
                        _builder.append((Object)"() + 1);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"}");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql delete ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)" result count: \" + count);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"return count;");
                    _builder.newLine();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "delete", _typeRef, _function);
        members.add((JvmMember)_method);
        JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_1 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return delete(sqlSessionFactory.getSqlSession(), ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "delete", _typeRef_1, _function_1);
        members.add((JvmMember)_method_1);
        JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return delete(sqlSession, ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "delete", _typeRef_2, _function_2);
        members.add((JvmMember)_method_2);
        JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_3 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return delete(");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "delete", _typeRef_3, _function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferDeleteIfx(DaoEntity entity, DaoDirectiveCrud dir, JvmGenericType entityType, String simpleName, PojoEntity pojo, JvmGenericType pojoType, List<JvmMember> members) {
        String _name = pojo.getName();
        String pojoAttrName = StringExtensions.toFirstLower((String)_name);
        JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "delete", _typeRef, _function);
        members.add((JvmMember)_method);
        JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_1 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "delete", _typeRef_1, _function_1);
        members.add((JvmMember)_method_1);
        JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "delete", _typeRef_2, _function_2);
        members.add((JvmMember)_method_2);
        JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_3 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "delete", _typeRef_3, _function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferList(DaoEntity entity, DaoDirectiveQuery dir, JvmGenericType entityType, String simpleName, final PojoEntity pojo, JvmGenericType pojoType, List<JvmMember> members, final Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        String _name = pojo.getName();
        final String pojoAttrName = StringExtensions.toFirstLower((String)_name);
        JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        JvmTypeReference listType = this._typeReferenceBuilder.typeRef(List.class, new JvmTypeReference[]{_typeRef});
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql list ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)": \" + ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)" + \" \" + sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"org.sqlproc.engine.SqlQueryEngine", "");
                    _builder.append((Object)" sqlEngine");
                    String _name = pojo.getName();
                    _builder.append((Object)_name, "");
                    _builder.append((Object)" = sqlEngineFactory.getCheckedQueryEngine(\"SELECT_");
                    String _name_1 = pojo.getName();
                    String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(_name_1);
                    _builder.append((Object)_dbName, "");
                    _builder.append((Object)"\");");
                    _builder.newLineIfNotEmpty();
                    boolean _isEmpty = moreResultClasses.isEmpty();
                    if (_isEmpty) {
                        _builder.append((Object)"//");
                    }
                    _builder.append((Object)"sqlControl = getMoreResultClasses(");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"List<");
                    String _name_2 = pojo.getName();
                    _builder.append((Object)_name_2, "");
                    _builder.append((Object)"> ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)"List = sqlEngine");
                    String _name_3 = pojo.getName();
                    _builder.append((Object)_name_3, "");
                    _builder.append((Object)".query(sqlSession, ");
                    String _name_4 = pojo.getName();
                    _builder.append((Object)_name_4, "");
                    _builder.append((Object)".class, ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql list ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)" size: \" + ((");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)"List != null) ? ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)"List.size() : \"null\"));");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"return ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)"List;");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "list", listType, _function);
        members.add((JvmMember)_method);
        Procedures.Procedure1 _function_1 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return list(sqlSessionFactory.getSqlSession(), ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "list", listType, _function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return list(sqlSession, ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "list", listType, _function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1 _function_3 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return list(");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "list", listType, _function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferListIfx(DaoEntity entity, DaoDirectiveQuery dir, JvmGenericType entityType, String simpleName, PojoEntity pojo, JvmGenericType pojoType, List<JvmMember> members, Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        String _name = pojo.getName();
        String pojoAttrName = StringExtensions.toFirstLower((String)_name);
        JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        JvmTypeReference listType = this._typeReferenceBuilder.typeRef(List.class, new JvmTypeReference[]{_typeRef});
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "list", listType, _function);
        members.add((JvmMember)_method);
        Procedures.Procedure1 _function_1 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "list", listType, _function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "list", listType, _function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1 _function_3 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "list", listType, _function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferListFromTo(DaoEntity entity, DaoDirectiveQuery dir, JvmGenericType entityType, String simpleName, final PojoEntity pojo, JvmGenericType pojoType, List<JvmMember> members, final Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses, final PojoAttribute primaryKey) {
        boolean _notEquals_1;
        boolean _notEquals;
        String _name = pojo.getName();
        final String pojoAttrName = StringExtensions.toFirstLower((String)_name);
        JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        JvmTypeReference listType = this._typeReferenceBuilder.typeRef(List.class, new JvmTypeReference[]{_typeRef});
        PojoAttributeDirectivePrimaryKey pkDir = this._processorGeneratorUtils.getPrimaryKeyDir(primaryKey);
        String _xifexpression = null;
        String _type = pkDir.getType();
        boolean bl = _notEquals = !Objects.equal((Object)_type, null);
        if (_notEquals) {
            _xifexpression = pkDir.getType();
        } else {
            JvmParameterizedTypeReference _elvis = null;
            JvmParameterizedTypeReference _elvis_1 = null;
            JvmParameterizedTypeReference _type_1 = primaryKey.getType();
            if (_type_1 != null) {
                _elvis_1 = _type_1;
            } else {
                XExpression _initExpr = primaryKey.getInitExpr();
                JvmTypeReference _inferredType = null;
                if (_initExpr != null) {
                    _inferredType = this._processorTypesBuilder.inferredType(_initExpr);
                }
                _elvis_1 = _inferredType;
            }
            if (_elvis_1 != null) {
                _elvis = _elvis_1;
            } else {
                JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(String.class, new JvmTypeReference[0]);
                _elvis = _typeRef_1;
            }
            _xifexpression = _elvis.getQualifiedName();
        }
        final String pkType = _xifexpression;
        String _xifexpression_1 = null;
        String _name_1 = pkDir.getName();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_name_1, null);
        if (_notEquals_1) {
            String _name_2 = pkDir.getName();
            String _firstUpper = this._processorTypesBuilder.toFirstUpper(_name_2);
            String _plus = ".get" + _firstUpper;
            _xifexpression_1 = String.valueOf(_plus) + "()";
        } else {
            _xifexpression_1 = "";
        }
        final String pkGetDep = _xifexpression_1;
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"if (sqlControl == null || sqlControl.getFirstResult() == null || sqlControl.getMaxResults() == null || ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)" == null)");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return list(sqlSession, ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql list ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)": \" + ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)" + \" \" + sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"org.sqlproc.engine.SqlQueryEngine", "");
                    _builder.append((Object)" sqlEngine");
                    String _name = pojo.getName();
                    _builder.append((Object)_name, "");
                    _builder.append((Object)" = sqlEngineFactory.getCheckedQueryEngine(\"SELECT_");
                    String _name_1 = pojo.getName();
                    String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(_name_1);
                    _builder.append((Object)_dbName, "");
                    _builder.append((Object)"\");");
                    _builder.newLineIfNotEmpty();
                    boolean _isEmpty = moreResultClasses.isEmpty();
                    if (_isEmpty) {
                        _builder.append((Object)"//");
                    }
                    _builder.append((Object)"sqlControl = getMoreResultClasses(");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)".setOnlyIds_(true);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"java.util.Set", "");
                    _builder.append((Object)"<String> initAssociations = ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)".getInitAssociations_();");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)".setInitAssociations_(new ");
                    _builder.append((Object)"java.util.HashSet", "");
                    _builder.append((Object)"<String>());");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"final ");
                    _builder.append((Object)"java.util.List", "");
                    _builder.append((Object)"<");
                    String _wrapperPrimitive = DaoJvmModelInferrer.this._processorGeneratorUtils.wrapperPrimitive(pkType);
                    _builder.append((Object)_wrapperPrimitive, "");
                    _builder.append((Object)"> ids_ = sqlEngine");
                    String _name_2 = pojo.getName();
                    _builder.append((Object)_name_2, "");
                    _builder.append((Object)".query(sqlSession, ");
                    _builder.append((Object)pkType, "");
                    _builder.append((Object)".class, ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)".setInitAssociations_(initAssociations);");
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                    _builder.append((Object)"List<");
                    String _name_3 = pojo.getName();
                    _builder.append((Object)_name_3, "");
                    _builder.append((Object)"> ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)"List = new ");
                    _builder.append((Object)"java.util.ArrayList", "");
                    _builder.append((Object)"<");
                    String _name_4 = pojo.getName();
                    _builder.append((Object)_name_4, "");
                    _builder.append((Object)">();");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if (!ids_.isEmpty()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"org.sqlproc.engine.impl.SqlStandardControl", "\t");
                    _builder.append((Object)" sqlc = new ");
                    _builder.append((Object)"org.sqlproc.engine.impl.SqlStandardControl", "\t");
                    _builder.append((Object)"(sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"sqlc.setFirstResult(0);");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"sqlc.setMaxResults(0);");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"sqlc.setOrder(null);");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"final ");
                    _builder.append(Map.class, "\t");
                    _builder.append((Object)"<");
                    String _wrapperPrimitive_1 = DaoJvmModelInferrer.this._processorGeneratorUtils.wrapperPrimitive(pkType);
                    _builder.append((Object)_wrapperPrimitive_1, "\t");
                    _builder.append((Object)", ");
                    String _name_5 = pojo.getName();
                    _builder.append((Object)_name_5, "\t");
                    _builder.append((Object)"> map = new ");
                    _builder.append((Object)"java.util.HashMap", "\t");
                    _builder.append((Object)"<");
                    String _wrapperPrimitive_2 = DaoJvmModelInferrer.this._processorGeneratorUtils.wrapperPrimitive(pkType);
                    _builder.append((Object)_wrapperPrimitive_2, "\t");
                    _builder.append((Object)", ");
                    String _name_6 = pojo.getName();
                    _builder.append((Object)_name_6, "\t");
                    _builder.append((Object)">();");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"final SqlRowProcessor<");
                    String _name_7 = pojo.getName();
                    _builder.append((Object)_name_7, "\t");
                    _builder.append((Object)"> sqlRowProcessor = new SqlRowProcessor<");
                    String _name_8 = pojo.getName();
                    _builder.append((Object)_name_8, "\t");
                    _builder.append((Object)">() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"@Override");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"public boolean processRow(");
                    String _name_9 = pojo.getName();
                    _builder.append((Object)_name_9, "\t\t");
                    _builder.append((Object)" result, int rownum) throws ");
                    _builder.append((Object)"org.sqlproc.engine.SqlRuntimeException", "\t\t");
                    _builder.append((Object)" {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"map.put(result.get");
                    String _name_10 = primaryKey.getName();
                    String _firstUpper = DaoJvmModelInferrer.this._processorTypesBuilder.toFirstUpper(_name_10);
                    _builder.append((Object)_firstUpper, "\t\t\t");
                    _builder.append((Object)"()");
                    _builder.append((Object)pkGetDep, "\t\t\t");
                    _builder.append((Object)", result);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"return true;");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"};");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"sqlEngine");
                    String _name_11 = pojo.getName();
                    _builder.append((Object)_name_11, "\t");
                    _builder.append((Object)".query(sqlSession, ");
                    String _name_12 = pojo.getName();
                    _builder.append((Object)_name_12, "\t");
                    _builder.append((Object)".class, new ");
                    String _name_13 = pojo.getName();
                    _builder.append((Object)_name_13, "\t");
                    _builder.append((Object)"().withIds_(ids_), sqlc, sqlRowProcessor);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"for (");
                    _builder.append((Object)pkType, "\t");
                    _builder.append((Object)" id : ids_)");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)pojoAttrName, "\t\t");
                    _builder.append((Object)"List.add(map.get(id));");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql list ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)" size: \" + ((");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)"List != null) ? ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)"List.size() : \"null\"));");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"return ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)"List;");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "listFromTo", listType, _function);
        members.add((JvmMember)_method);
        Procedures.Procedure1 _function_1 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return listFromTo(sqlSessionFactory.getSqlSession(), ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "listFromTo", listType, _function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return listFromTo(sqlSession, ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "listFromTo", listType, _function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1 _function_3 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return listFromTo(");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "listFromTo", listType, _function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferListFromToIfx(DaoEntity entity, DaoDirectiveQuery dir, JvmGenericType entityType, String simpleName, PojoEntity pojo, JvmGenericType pojoType, List<JvmMember> members, Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        String _name = pojo.getName();
        String pojoAttrName = StringExtensions.toFirstLower((String)_name);
        JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        JvmTypeReference listType = this._typeReferenceBuilder.typeRef(List.class, new JvmTypeReference[]{_typeRef});
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "listFromTo", listType, _function);
        members.add((JvmMember)_method);
        Procedures.Procedure1 _function_1 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "listFromTo", listType, _function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "listFromTo", listType, _function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1 _function_3 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "listFromTo", listType, _function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferQuery(DaoEntity entity, DaoDirectiveQuery dir, JvmGenericType entityType, String simpleName, final PojoEntity pojo, JvmGenericType pojoType, List<JvmMember> members, final Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        String _name = pojo.getName();
        final String pojoAttrName = StringExtensions.toFirstLower((String)_name);
        JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        JvmTypeReference srpType = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlRowProcessor", new JvmTypeReference[]{_typeRef});
        JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            EList _parameters_3 = it.getParameters();
            JvmFormalParameter _parameter_3 = this._processorTypesBuilder.toParameter(entity, "sqlRowProcessor", srpType);
            this._processorTypesBuilder.operator_add(_parameters_3, _parameter_3);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql query ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)": \" + ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)" + \" \" + sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"org.sqlproc.engine.SqlQueryEngine", "");
                    _builder.append((Object)" sqlEngine");
                    String _name = pojo.getName();
                    _builder.append((Object)_name, "");
                    _builder.append((Object)" = sqlEngineFactory.getCheckedQueryEngine(\"SELECT_");
                    String _name_1 = pojo.getName();
                    String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(_name_1);
                    _builder.append((Object)_dbName, "");
                    _builder.append((Object)"\");");
                    _builder.newLineIfNotEmpty();
                    boolean _isEmpty = moreResultClasses.isEmpty();
                    if (_isEmpty) {
                        _builder.append((Object)"//");
                    }
                    _builder.append((Object)"sqlControl = getMoreResultClasses(");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"int rownums = sqlEngine");
                    String _name_2 = pojo.getName();
                    _builder.append((Object)_name_2, "");
                    _builder.append((Object)".query(sqlSession, ");
                    String _name_3 = pojo.getName();
                    _builder.append((Object)_name_3, "");
                    _builder.append((Object)".class, ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", sqlControl, sqlRowProcessor);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql query ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)" size: \" + rownums);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"return rownums;");
                    _builder.newLine();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "query", _typeRef_1, _function);
        members.add((JvmMember)_method);
        JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_1 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            EList _parameters_2 = it.getParameters();
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlRowProcessor", srpType);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return query(sqlSessionFactory.getSqlSession(), ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", sqlControl, sqlRowProcessor);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "query", _typeRef_2, _function_1);
        members.add((JvmMember)_method_1);
        JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_5 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_5);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            EList _parameters_2 = it.getParameters();
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlRowProcessor", srpType);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return query(sqlSession, ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", null, sqlRowProcessor);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "query", _typeRef_3, _function_2);
        members.add((JvmMember)_method_2);
        JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_3 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_5 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_5);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlRowProcessor", srpType);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return query(");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", null, sqlRowProcessor);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "query", _typeRef_4, _function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferQueryIfx(DaoEntity entity, DaoDirectiveQuery dir, JvmGenericType entityType, String simpleName, PojoEntity pojo, JvmGenericType pojoType, List<JvmMember> members, Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        String _name = pojo.getName();
        String pojoAttrName = StringExtensions.toFirstLower((String)_name);
        JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
        JvmTypeReference srpType = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlRowProcessor", new JvmTypeReference[]{_typeRef});
        JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            EList _parameters_3 = it.getParameters();
            JvmFormalParameter _parameter_3 = this._processorTypesBuilder.toParameter(entity, "sqlRowProcessor", srpType);
            this._processorTypesBuilder.operator_add(_parameters_3, _parameter_3);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "query", _typeRef_1, _function);
        members.add((JvmMember)_method);
        JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_1 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            EList _parameters_2 = it.getParameters();
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlRowProcessor", srpType);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "query", _typeRef_2, _function_1);
        members.add((JvmMember)_method_1);
        JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_5 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_5);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            EList _parameters_2 = it.getParameters();
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlRowProcessor", srpType);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "query", _typeRef_3, _function_2);
        members.add((JvmMember)_method_2);
        JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_3 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_5 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_5);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlRowProcessor", srpType);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "query", _typeRef_4, _function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferCount(DaoEntity entity, DaoDirectiveQuery dir, JvmGenericType entityType, String simpleName, final PojoEntity pojo, JvmGenericType pojoType, List<JvmMember> members, final Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        String _name = pojo.getName();
        final String pojoAttrName = StringExtensions.toFirstLower((String)_name);
        JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"count ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)": \" + ");
                    _builder.append((Object)pojoAttrName, "\t");
                    _builder.append((Object)" + \" \" + sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"org.sqlproc.engine.SqlQueryEngine", "");
                    _builder.append((Object)" sqlEngine");
                    String _name = pojo.getName();
                    _builder.append((Object)_name, "");
                    _builder.append((Object)" = sqlEngineFactory.getCheckedQueryEngine(\"SELECT_");
                    String _name_1 = pojo.getName();
                    String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(_name_1);
                    _builder.append((Object)_dbName, "");
                    _builder.append((Object)"\");");
                    _builder.newLineIfNotEmpty();
                    boolean _isEmpty = moreResultClasses.isEmpty();
                    if (_isEmpty) {
                        _builder.append((Object)"//");
                    }
                    _builder.append((Object)"sqlControl = getMoreResultClasses(");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"int count = sqlEngine");
                    String _name_2 = pojo.getName();
                    _builder.append((Object)_name_2, "");
                    _builder.append((Object)".queryCount(sqlSession, ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"count: \" + count);");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"return count;");
                    _builder.newLine();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "count", _typeRef, _function);
        members.add((JvmMember)_method);
        JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_1 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return count(sqlSessionFactory.getSqlSession(), ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "count", _typeRef_1, _function_1);
        members.add((JvmMember)_method_1);
        JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return count(sqlSession, ");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "count", _typeRef_2, _function_2);
        members.add((JvmMember)_method_2);
        JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_3 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return count(");
                    _builder.append((Object)pojoAttrName, "");
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "count", _typeRef_3, _function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferCountIfx(DaoEntity entity, DaoDirectiveQuery dir, JvmGenericType entityType, String simpleName, PojoEntity pojo, JvmGenericType pojoType, List<JvmMember> members, Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        String _name = pojo.getName();
        String pojoAttrName = StringExtensions.toFirstLower((String)_name);
        JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "count", _typeRef, _function);
        members.add((JvmMember)_method);
        JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_1 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, "count", _typeRef_1, _function_1);
        members.add((JvmMember)_method_1);
        JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, "count", _typeRef_2, _function_2);
        members.add((JvmMember)_method_2);
        JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_3 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_4);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, "count", _typeRef_3, _function_3);
        members.add((JvmMember)_method_3);
    }

    public void inferMoreResultClasses(DaoEntity entity, JvmGenericType entityType, String simpleName, final PojoEntity pojo, JvmGenericType pojoType, List<JvmMember> members, final Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        String _name = pojo.getName();
        final String pojoAttrName = StringExtensions.toFirstLower((String)_name);
        JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"if (sqlControl != null && sqlControl.getMoreResultClasses() != null)");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return sqlControl;");
                    _builder.newLine();
                    _builder.append((Object)"java.util.Map", "");
                    _builder.append((Object)"<String, Class<?>> moreResultClasses = null;");
                    _builder.newLineIfNotEmpty();
                    Set _entrySet = moreResultClasses.entrySet();
                    for (Map.Entry f : _entrySet) {
                        _builder.append((Object)"if (");
                        _builder.append((Object)pojoAttrName, "");
                        _builder.append((Object)" != null && ");
                        _builder.append((Object)pojoAttrName, "");
                        _builder.append((Object)".toInit_(");
                        String _name = pojo.getName();
                        _builder.append((Object)_name, "");
                        _builder.append((Object)".Association.");
                        String _key = (String)f.getKey();
                        _builder.append((Object)_key, "");
                        _builder.append((Object)".name())) {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"if (moreResultClasses == null)");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"moreResultClasses = new ");
                        _builder.append((Object)"java.util.HashMap", "\t\t");
                        _builder.append((Object)"<String, Class<?>>();");
                        _builder.newLineIfNotEmpty();
                        Map _value = (Map)f.getValue();
                        Set _entrySet_1 = _value.entrySet();
                        for (Map.Entry a : _entrySet_1) {
                            _builder.append((Object)"\t");
                            _builder.append((Object)"moreResultClasses.put(\"");
                            String _key_1 = (String)a.getKey();
                            _builder.append((Object)_key_1, "\t");
                            _builder.append((Object)"\", ");
                            JvmParameterizedTypeReference _value_1 = (JvmParameterizedTypeReference)a.getValue();
                            _builder.append((Object)_value_1, "\t");
                            _builder.append((Object)".class);");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append((Object)"}");
                        _builder.newLine();
                    }
                    _builder.append((Object)"if (moreResultClasses != null) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"sqlControl = new ");
                    _builder.append((Object)"org.sqlproc.engine.impl.SqlStandardControl", "\t");
                    _builder.append((Object)"(sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"((");
                    _builder.append((Object)"org.sqlproc.engine.impl.SqlStandardControl", "\t");
                    _builder.append((Object)") sqlControl).setMoreResultClasses(moreResultClasses);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"return sqlControl;");
                    _builder.newLine();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "getMoreResultClasses", _typeRef, _function);
        members.add((JvmMember)_method);
    }

    public void inferMoreResultClassesIfx(DaoEntity entity, JvmGenericType entityType, String simpleName, PojoEntity pojo, JvmGenericType pojoType, List<JvmMember> members, Map<String, Map<String, JvmParameterizedTypeReference>> moreResultClasses) {
        String _name = pojo.getName();
        String pojoAttrName = StringExtensions.toFirstLower((String)_name);
        JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef((JvmType)pojoType, new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, pojoAttrName, _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, "getMoreResultClasses", _typeRef, _function);
        members.add((JvmMember)_method);
    }

    protected void _inferFunctionProcedure(final DaoEntity entity, FunctionCallQuery type, final DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        JvmParameterizedTypeReference _out = params.getOut();
        JvmType _type = _out.getType();
        JvmParameterizedTypeReference _out_1 = params.getOut();
        EList _arguments = _out_1.getArguments();
        JvmTypeReference listType = this._typeReferenceBuilder.typeRef(_type, (JvmTypeReference[])Conversions.unwrapArray((Object)_arguments, JvmTypeReference.class));
        final String fname = this._processorGeneratorUtils.getFunProcName(entity);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters_1 = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_1);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql ");
                    _builder.append((Object)fname, "\t");
                    _builder.append((Object)": \" + ");
                    EList<JvmParameterizedTypeReference> _ins = params.getIns();
                    boolean _hasElements = false;
                    for (JvmParameterizedTypeReference in : _ins) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)" + \" \" ", "\t");
                        }
                        String _simpleName = in.getSimpleName();
                        String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                        _builder.append((Object)_firstLower, "\t");
                    }
                    _builder.append((Object)" + \" \" + sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"org.sqlproc.engine.SqlProcedureEngine", "");
                    _builder.append((Object)" sqlFun");
                    String _name = entity.getName();
                    _builder.append((Object)_name, "");
                    _builder.append((Object)" = sqlEngineFactory.getCheckedProcedureEngine(\"FUN_");
                    String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(fname);
                    _builder.append((Object)_dbName, "");
                    _builder.append((Object)"\");");
                    _builder.newLineIfNotEmpty();
                    JvmParameterizedTypeReference _out = params.getOut();
                    String _simpleName_1 = DaoJvmModelInferrer.this._processorGeneratorUtils.getSimpleName(_out);
                    _builder.append((Object)_simpleName_1, "");
                    _builder.append((Object)" list = sqlFun");
                    String _name_1 = entity.getName();
                    _builder.append((Object)_name_1, "");
                    _builder.append((Object)".callQuery(sqlSession, ");
                    JvmParameterizedTypeReference _out_1 = params.getOut();
                    EList _arguments = _out_1.getArguments();
                    JvmTypeReference _head = (JvmTypeReference)IterableExtensions.head((Iterable)_arguments);
                    String _simpleName_2 = _head.getSimpleName();
                    _builder.append((Object)_simpleName_2, "");
                    _builder.append((Object)".class, ");
                    EList<JvmParameterizedTypeReference> _ins_1 = params.getIns();
                    boolean _hasElements_1 = false;
                    for (JvmParameterizedTypeReference in_1 : _ins_1) {
                        if (!_hasElements_1) {
                            _hasElements_1 = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName_3 = in_1.getSimpleName();
                        String _firstLower_1 = StringExtensions.toFirstLower((String)_simpleName_3);
                        _builder.append((Object)_firstLower_1, "");
                    }
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql ");
                    _builder.append((Object)fname, "\t");
                    _builder.append((Object)" result: \" + list);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"return list;");
                    _builder.newLine();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, fname, listType, _function);
        members.add((JvmMember)_method);
        Procedures.Procedure1 _function_1 = it -> {
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return ");
                    _builder.append((Object)fname, "");
                    _builder.append((Object)"(sqlSessionFactory.getSqlSession(), ");
                    EList<JvmParameterizedTypeReference> _ins = params.getIns();
                    boolean _hasElements = false;
                    for (JvmParameterizedTypeReference in : _ins) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName = in.getSimpleName();
                        String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                        _builder.append((Object)_firstLower, "");
                    }
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, fname, listType, _function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters_1 = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_1);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return ");
                    _builder.append((Object)fname, "");
                    _builder.append((Object)"(sqlSession, ");
                    EList<JvmParameterizedTypeReference> _ins = params.getIns();
                    boolean _hasElements = false;
                    for (JvmParameterizedTypeReference in : _ins) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName = in.getSimpleName();
                        String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                        _builder.append((Object)_firstLower, "");
                    }
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, fname, listType, _function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1 _function_3 = it -> {
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return ");
                    _builder.append((Object)fname, "");
                    _builder.append((Object)"(");
                    EList<JvmParameterizedTypeReference> _ins = params.getIns();
                    boolean _hasElements = false;
                    for (JvmParameterizedTypeReference in : _ins) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName = in.getSimpleName();
                        String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                        _builder.append((Object)_firstLower, "");
                    }
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, fname, listType, _function_3);
        members.add((JvmMember)_method_3);
    }

    protected void _inferFunctionProcedureIfx(DaoEntity entity, FunctionCallQuery type, DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        JvmParameterizedTypeReference _out = params.getOut();
        JvmType _type = _out.getType();
        JvmParameterizedTypeReference _out_1 = params.getOut();
        EList _arguments = _out_1.getArguments();
        JvmTypeReference listType = this._typeReferenceBuilder.typeRef(_type, (JvmTypeReference[])Conversions.unwrapArray((Object)_arguments, JvmTypeReference.class));
        String fname = this._processorGeneratorUtils.getFunProcName(entity);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters_1 = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_1);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, fname, listType, _function);
        members.add((JvmMember)_method);
        Procedures.Procedure1 _function_1 = it -> {
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, fname, listType, _function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters_1 = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_1);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, fname, listType, _function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1 _function_3 = it -> {
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, fname, listType, _function_3);
        members.add((JvmMember)_method_3);
    }

    protected void _inferFunctionProcedure(final DaoEntity entity, ProcedureCallQuery type, final DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        JvmParameterizedTypeReference _out = params.getOut();
        JvmType _type = _out.getType();
        JvmParameterizedTypeReference _out_1 = params.getOut();
        EList _arguments = _out_1.getArguments();
        JvmTypeReference listType = this._typeReferenceBuilder.typeRef(_type, (JvmTypeReference[])Conversions.unwrapArray((Object)_arguments, JvmTypeReference.class));
        final String fname = this._processorGeneratorUtils.getFunProcName(entity);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters_1 = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_1);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql ");
                    _builder.append((Object)fname, "\t");
                    _builder.append((Object)": \" + ");
                    EList<JvmParameterizedTypeReference> _ins = params.getIns();
                    boolean _hasElements = false;
                    for (JvmParameterizedTypeReference in : _ins) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)" + \" \" ", "\t");
                        }
                        String _simpleName = in.getSimpleName();
                        String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                        _builder.append((Object)_firstLower, "\t");
                    }
                    _builder.append((Object)" + \" \" + sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"org.sqlproc.engine.SqlProcedureEngine", "");
                    _builder.append((Object)" sqlProc");
                    String _name = entity.getName();
                    _builder.append((Object)_name, "");
                    _builder.append((Object)" = sqlEngineFactory.getCheckedProcedureEngine(\"PROC_");
                    String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(fname);
                    _builder.append((Object)_dbName, "");
                    _builder.append((Object)"\");");
                    _builder.newLineIfNotEmpty();
                    JvmParameterizedTypeReference _out = params.getOut();
                    String _simpleName_1 = DaoJvmModelInferrer.this._processorGeneratorUtils.getSimpleName(_out);
                    _builder.append((Object)_simpleName_1, "");
                    _builder.append((Object)" list = sqlProc");
                    String _name_1 = entity.getName();
                    _builder.append((Object)_name_1, "");
                    _builder.append((Object)".callQuery(sqlSession, ");
                    JvmParameterizedTypeReference _out_1 = params.getOut();
                    EList _arguments = _out_1.getArguments();
                    JvmTypeReference _head = (JvmTypeReference)IterableExtensions.head((Iterable)_arguments);
                    String _simpleName_2 = _head.getSimpleName();
                    _builder.append((Object)_simpleName_2, "");
                    _builder.append((Object)".class, ");
                    EList<JvmParameterizedTypeReference> _ins_1 = params.getIns();
                    boolean _hasElements_1 = false;
                    for (JvmParameterizedTypeReference in_1 : _ins_1) {
                        if (!_hasElements_1) {
                            _hasElements_1 = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName_3 = in_1.getSimpleName();
                        String _firstLower_1 = StringExtensions.toFirstLower((String)_simpleName_3);
                        _builder.append((Object)_firstLower_1, "");
                    }
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql ");
                    _builder.append((Object)fname, "\t");
                    _builder.append((Object)" result: \" + list);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"return list;");
                    _builder.newLine();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, fname, listType, _function);
        members.add((JvmMember)_method);
        Procedures.Procedure1 _function_1 = it -> {
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return ");
                    _builder.append((Object)fname, "");
                    _builder.append((Object)"(sqlSessionFactory.getSqlSession(), ");
                    EList<JvmParameterizedTypeReference> _ins = params.getIns();
                    boolean _hasElements = false;
                    for (JvmParameterizedTypeReference in : _ins) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName = in.getSimpleName();
                        String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                        _builder.append((Object)_firstLower, "");
                    }
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, fname, listType, _function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters_1 = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_1);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return ");
                    _builder.append((Object)fname, "");
                    _builder.append((Object)"(sqlSession, ");
                    EList<JvmParameterizedTypeReference> _ins = params.getIns();
                    boolean _hasElements = false;
                    for (JvmParameterizedTypeReference in : _ins) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName = in.getSimpleName();
                        String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                        _builder.append((Object)_firstLower, "");
                    }
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, fname, listType, _function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1 _function_3 = it -> {
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return ");
                    _builder.append((Object)fname, "");
                    _builder.append((Object)"(");
                    EList<JvmParameterizedTypeReference> _ins = params.getIns();
                    boolean _hasElements = false;
                    for (JvmParameterizedTypeReference in : _ins) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName = in.getSimpleName();
                        String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                        _builder.append((Object)_firstLower, "");
                    }
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, fname, listType, _function_3);
        members.add((JvmMember)_method_3);
    }

    protected void _inferFunctionProcedureIfx(DaoEntity entity, ProcedureCallQuery type, DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        JvmParameterizedTypeReference _out = params.getOut();
        JvmType _type = _out.getType();
        JvmParameterizedTypeReference _out_1 = params.getOut();
        EList _arguments = _out_1.getArguments();
        JvmTypeReference listType = this._typeReferenceBuilder.typeRef(_type, (JvmTypeReference[])Conversions.unwrapArray((Object)_arguments, JvmTypeReference.class));
        String fname = this._processorGeneratorUtils.getFunProcName(entity);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters_1 = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_1);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, fname, listType, _function);
        members.add((JvmMember)_method);
        Procedures.Procedure1 _function_1 = it -> {
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, fname, listType, _function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters_1 = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_1);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, fname, listType, _function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1 _function_3 = it -> {
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, fname, listType, _function_3);
        members.add((JvmMember)_method_3);
    }

    protected void _inferFunctionProcedure(final DaoEntity entity, FunctionCall type, final DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        JvmParameterizedTypeReference _out = params.getOut();
        JvmType _type = _out.getType();
        JvmParameterizedTypeReference _out_1 = params.getOut();
        EList _arguments = _out_1.getArguments();
        JvmTypeReference outType = this._typeReferenceBuilder.typeRef(_type, (JvmTypeReference[])Conversions.unwrapArray((Object)_arguments, JvmTypeReference.class));
        final String fname = this._processorGeneratorUtils.getFunProcName(entity);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters_1 = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_1);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql ");
                    _builder.append((Object)fname, "\t");
                    _builder.append((Object)": \" + ");
                    EList<JvmParameterizedTypeReference> _ins = params.getIns();
                    boolean _hasElements = false;
                    for (JvmParameterizedTypeReference in : _ins) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)" + \" \" ", "\t");
                        }
                        String _simpleName = in.getSimpleName();
                        String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                        _builder.append((Object)_firstLower, "\t");
                    }
                    _builder.append((Object)" + \" \" + sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"org.sqlproc.engine.SqlProcedureEngine", "");
                    _builder.append((Object)" sqlFun");
                    String _name = entity.getName();
                    _builder.append((Object)_name, "");
                    _builder.append((Object)" = sqlEngineFactory.getCheckedProcedureEngine(\"FUN_");
                    String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(fname);
                    _builder.append((Object)_dbName, "");
                    _builder.append((Object)"\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"Object result = sqlFun");
                    String _name_1 = entity.getName();
                    _builder.append((Object)_name_1, "");
                    _builder.append((Object)".callFunction(sqlSession, ");
                    EList<JvmParameterizedTypeReference> _ins_1 = params.getIns();
                    boolean _hasElements_1 = false;
                    for (JvmParameterizedTypeReference in_1 : _ins_1) {
                        if (!_hasElements_1) {
                            _hasElements_1 = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName_1 = in_1.getSimpleName();
                        String _firstLower_1 = StringExtensions.toFirstLower((String)_simpleName_1);
                        _builder.append((Object)_firstLower_1, "");
                    }
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql ");
                    _builder.append((Object)fname, "\t");
                    _builder.append((Object)" result: \" + result);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"return (");
                    JvmParameterizedTypeReference _out = params.getOut();
                    String _simpleName_2 = DaoJvmModelInferrer.this._processorGeneratorUtils.getSimpleName(_out);
                    _builder.append((Object)_simpleName_2, "");
                    _builder.append((Object)") result;");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, fname, outType, _function);
        members.add((JvmMember)_method);
        Procedures.Procedure1 _function_1 = it -> {
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return ");
                    _builder.append((Object)fname, "");
                    _builder.append((Object)"(sqlSessionFactory.getSqlSession(), ");
                    EList<JvmParameterizedTypeReference> _ins = params.getIns();
                    boolean _hasElements = false;
                    for (JvmParameterizedTypeReference in : _ins) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName = in.getSimpleName();
                        String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                        _builder.append((Object)_firstLower, "");
                    }
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, fname, outType, _function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters_1 = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_1);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return ");
                    _builder.append((Object)fname, "");
                    _builder.append((Object)"(sqlSession, ");
                    EList<JvmParameterizedTypeReference> _ins = params.getIns();
                    boolean _hasElements = false;
                    for (JvmParameterizedTypeReference in : _ins) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName = in.getSimpleName();
                        String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                        _builder.append((Object)_firstLower, "");
                    }
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, fname, outType, _function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1 _function_3 = it -> {
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return ");
                    _builder.append((Object)fname, "");
                    _builder.append((Object)"(");
                    EList<JvmParameterizedTypeReference> _ins = params.getIns();
                    boolean _hasElements = false;
                    for (JvmParameterizedTypeReference in : _ins) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName = in.getSimpleName();
                        String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                        _builder.append((Object)_firstLower, "");
                    }
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, fname, outType, _function_3);
        members.add((JvmMember)_method_3);
    }

    protected void _inferFunctionProcedureIfx(DaoEntity entity, FunctionCall type, DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        JvmParameterizedTypeReference _out = params.getOut();
        JvmType _type = _out.getType();
        JvmParameterizedTypeReference _out_1 = params.getOut();
        EList _arguments = _out_1.getArguments();
        JvmTypeReference outType = this._typeReferenceBuilder.typeRef(_type, (JvmTypeReference[])Conversions.unwrapArray((Object)_arguments, JvmTypeReference.class));
        String fname = this._processorGeneratorUtils.getFunProcName(entity);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters_1 = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_1);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, fname, outType, _function);
        members.add((JvmMember)_method);
        Procedures.Procedure1 _function_1 = it -> {
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, fname, outType, _function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters_1 = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_1);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, fname, outType, _function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1 _function_3 = it -> {
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, fname, outType, _function_3);
        members.add((JvmMember)_method_3);
    }

    protected void _inferFunctionProcedure(final DaoEntity entity, ProcedureUpdate type, final DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        final String fname = this._processorGeneratorUtils.getFunProcName(entity);
        JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters_1 = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type = in.getType();
                JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef(_type, new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_2);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql ");
                    _builder.append((Object)fname, "\t");
                    _builder.append((Object)": \" + ");
                    EList<JvmParameterizedTypeReference> _ins = params.getIns();
                    boolean _hasElements = false;
                    for (JvmParameterizedTypeReference in : _ins) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)" + \" \" ", "\t");
                        }
                        String _simpleName = in.getSimpleName();
                        String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                        _builder.append((Object)_firstLower, "\t");
                    }
                    _builder.append((Object)" + \" \" + sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"org.sqlproc.engine.SqlProcedureEngine", "");
                    _builder.append((Object)" sqlProc");
                    String _name = entity.getName();
                    _builder.append((Object)_name, "");
                    _builder.append((Object)" = sqlEngineFactory.getCheckedProcedureEngine(\"PROC_");
                    String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(fname);
                    _builder.append((Object)_dbName, "");
                    _builder.append((Object)"\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"int count = sqlProc");
                    String _name_1 = entity.getName();
                    _builder.append((Object)_name_1, "");
                    _builder.append((Object)".callUpdate(sqlSession, ");
                    EList<JvmParameterizedTypeReference> _ins_1 = params.getIns();
                    boolean _hasElements_1 = false;
                    for (JvmParameterizedTypeReference in_1 : _ins_1) {
                        if (!_hasElements_1) {
                            _hasElements_1 = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName_1 = in_1.getSimpleName();
                        String _firstLower_1 = StringExtensions.toFirstLower((String)_simpleName_1);
                        _builder.append((Object)_firstLower_1, "");
                    }
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql ");
                    _builder.append((Object)fname, "\t");
                    _builder.append((Object)" result: \" + count);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"return count;");
                    _builder.newLine();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, fname, _typeRef, _function);
        members.add((JvmMember)_method);
        JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_1 = it -> {
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type = in.getType();
                JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef(_type, new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_2);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return ");
                    _builder.append((Object)fname, "");
                    _builder.append((Object)"(sqlSessionFactory.getSqlSession(), ");
                    EList<JvmParameterizedTypeReference> _ins = params.getIns();
                    boolean _hasElements = false;
                    for (JvmParameterizedTypeReference in : _ins) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName = in.getSimpleName();
                        String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                        _builder.append((Object)_firstLower, "");
                    }
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, fname, _typeRef_1, _function_1);
        members.add((JvmMember)_method_1);
        JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters_1 = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type = in.getType();
                JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef(_type, new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_4);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return ");
                    _builder.append((Object)fname, "");
                    _builder.append((Object)"(sqlSession, ");
                    EList<JvmParameterizedTypeReference> _ins = params.getIns();
                    boolean _hasElements = false;
                    for (JvmParameterizedTypeReference in : _ins) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName = in.getSimpleName();
                        String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                        _builder.append((Object)_firstLower, "");
                    }
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, fname, _typeRef_2, _function_2);
        members.add((JvmMember)_method_2);
        JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_3 = it -> {
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type = in.getType();
                JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef(_type, new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_4);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return ");
                    _builder.append((Object)fname, "");
                    _builder.append((Object)"(");
                    EList<JvmParameterizedTypeReference> _ins = params.getIns();
                    boolean _hasElements = false;
                    for (JvmParameterizedTypeReference in : _ins) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName = in.getSimpleName();
                        String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                        _builder.append((Object)_firstLower, "");
                    }
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, fname, _typeRef_3, _function_3);
        members.add((JvmMember)_method_3);
    }

    protected void _inferFunctionProcedureIfx(DaoEntity entity, ProcedureUpdate type, DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        String fname = this._processorGeneratorUtils.getFunProcName(entity);
        JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters_1 = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type = in.getType();
                JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef(_type, new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_2);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, fname, _typeRef, _function);
        members.add((JvmMember)_method);
        JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_1 = it -> {
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type = in.getType();
                JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef(_type, new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_2);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, fname, _typeRef_1, _function_1);
        members.add((JvmMember)_method_1);
        JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef_3);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters_1 = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type = in.getType();
                JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef(_type, new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_4);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, fname, _typeRef_2, _function_2);
        members.add((JvmMember)_method_2);
        JvmTypeReference _typeRef_3 = this._typeReferenceBuilder.typeRef(Integer.TYPE, new JvmTypeReference[0]);
        Procedures.Procedure1 _function_3 = it -> {
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type = in.getType();
                JvmTypeReference _typeRef_4 = this._typeReferenceBuilder.typeRef(_type, new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_4);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, fname, _typeRef_3, _function_3);
        members.add((JvmMember)_method_3);
    }

    protected void _inferFunctionProcedure(final DaoEntity entity, FunctionQuery type, final DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        JvmParameterizedTypeReference _out = params.getOut();
        JvmType _type = _out.getType();
        JvmParameterizedTypeReference _out_1 = params.getOut();
        EList _arguments = _out_1.getArguments();
        JvmTypeReference outType = this._typeReferenceBuilder.typeRef(_type, (JvmTypeReference[])Conversions.unwrapArray((Object)_arguments, JvmTypeReference.class));
        final String fname = this._processorGeneratorUtils.getFunProcName(entity);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters_1 = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_1);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql ");
                    _builder.append((Object)fname, "\t");
                    _builder.append((Object)": \" + ");
                    EList<JvmParameterizedTypeReference> _ins = params.getIns();
                    boolean _hasElements = false;
                    for (JvmParameterizedTypeReference in : _ins) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)" + \" \" ", "\t");
                        }
                        String _simpleName = in.getSimpleName();
                        String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                        _builder.append((Object)_firstLower, "\t");
                    }
                    _builder.append((Object)" + \" \" + sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"org.sqlproc.engine.SqlQueryEngine", "");
                    _builder.append((Object)" sqlFun");
                    String _name = entity.getName();
                    _builder.append((Object)_name, "");
                    _builder.append((Object)" = sqlEngineFactory.getCheckedQueryEngine(\"FUN_");
                    String _dbName = DaoJvmModelInferrer.this._processorGeneratorUtils.dbName(fname);
                    _builder.append((Object)_dbName, "");
                    _builder.append((Object)"\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"java.util.List", "");
                    _builder.append((Object)"<");
                    EList<JvmParameterizedTypeReference> _ins_1 = params.getIns();
                    JvmParameterizedTypeReference _head = (JvmParameterizedTypeReference)IterableExtensions.head(_ins_1);
                    String _simpleName_1 = _head.getSimpleName();
                    _builder.append((Object)_simpleName_1, "");
                    _builder.append((Object)"> list = sqlFun");
                    String _name_1 = entity.getName();
                    _builder.append((Object)_name_1, "");
                    _builder.append((Object)".query(sqlSession, ");
                    EList<JvmParameterizedTypeReference> _ins_2 = params.getIns();
                    JvmParameterizedTypeReference _head_1 = (JvmParameterizedTypeReference)IterableExtensions.head(_ins_2);
                    String _simpleName_2 = _head_1.getSimpleName();
                    _builder.append((Object)_simpleName_2, "");
                    _builder.append((Object)".class, ");
                    EList<JvmParameterizedTypeReference> _ins_3 = params.getIns();
                    boolean _hasElements_1 = false;
                    for (JvmParameterizedTypeReference in_1 : _ins_3) {
                        if (!_hasElements_1) {
                            _hasElements_1 = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName_3 = in_1.getSimpleName();
                        String _firstLower_1 = StringExtensions.toFirstLower((String)_simpleName_3);
                        _builder.append((Object)_firstLower_1, "");
                    }
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"if (logger.isTraceEnabled()) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"logger.trace(\"sql ");
                    _builder.append((Object)fname, "\t");
                    _builder.append((Object)" result: \" + list);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"return (list != null && !list.isEmpty()) ? list.get(0).getResult() : null;");
                    _builder.newLine();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, fname, outType, _function);
        members.add((JvmMember)_method);
        Procedures.Procedure1 _function_1 = it -> {
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return ");
                    _builder.append((Object)fname, "");
                    _builder.append((Object)"(sqlSessionFactory.getSqlSession(), ");
                    EList<JvmParameterizedTypeReference> _ins = params.getIns();
                    boolean _hasElements = false;
                    for (JvmParameterizedTypeReference in : _ins) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName = in.getSimpleName();
                        String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                        _builder.append((Object)_firstLower, "");
                    }
                    _builder.append((Object)", sqlControl);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, fname, outType, _function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters_1 = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_1);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return ");
                    _builder.append((Object)fname, "");
                    _builder.append((Object)"(sqlSession, ");
                    EList<JvmParameterizedTypeReference> _ins = params.getIns();
                    boolean _hasElements = false;
                    for (JvmParameterizedTypeReference in : _ins) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName = in.getSimpleName();
                        String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                        _builder.append((Object)_firstLower, "");
                    }
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, fname, outType, _function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1 _function_3 = it -> {
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"return ");
                    _builder.append((Object)fname, "");
                    _builder.append((Object)"(");
                    EList<JvmParameterizedTypeReference> _ins = params.getIns();
                    boolean _hasElements = false;
                    for (JvmParameterizedTypeReference in : _ins) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName = in.getSimpleName();
                        String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                        _builder.append((Object)_firstLower, "");
                    }
                    _builder.append((Object)", null);");
                    _builder.newLineIfNotEmpty();
                }
            };
            this._processorTypesBuilder.setBody((JvmExecutable)it, _client);
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, fname, outType, _function_3);
        members.add((JvmMember)_method_3);
    }

    protected void _inferFunctionProcedureIfx(DaoEntity entity, FunctionQuery type, DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        JvmParameterizedTypeReference _out = params.getOut();
        JvmType _type = _out.getType();
        JvmParameterizedTypeReference _out_1 = params.getOut();
        EList _arguments = _out_1.getArguments();
        JvmTypeReference outType = this._typeReferenceBuilder.typeRef(_type, (JvmTypeReference[])Conversions.unwrapArray((Object)_arguments, JvmTypeReference.class));
        String fname = this._processorGeneratorUtils.getFunProcName(entity);
        Procedures.Procedure1 _function = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters_1 = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_1);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
            EList _parameters_2 = it.getParameters();
            JvmTypeReference _typeRef_2 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_2 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_2);
            this._processorTypesBuilder.operator_add(_parameters_2, _parameter_2);
        };
        JvmOperation _method = this._processorTypesBuilder.toMethod(entity, fname, outType, _function);
        members.add((JvmMember)_method);
        Procedures.Procedure1 _function_1 = it -> {
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
            EList _parameters_1 = it.getParameters();
            JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlControl", new JvmTypeReference[0]);
            JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, "sqlControl", _typeRef_1);
            this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
        };
        JvmOperation _method_1 = this._processorTypesBuilder.toMethod(entity, fname, outType, _function_1);
        members.add((JvmMember)_method_1);
        Procedures.Procedure1 _function_2 = it -> {
            EList _parameters = it.getParameters();
            JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef("org.sqlproc.engine.SqlSession", new JvmTypeReference[0]);
            JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, "sqlSession", _typeRef);
            this._processorTypesBuilder.operator_add(_parameters, _parameter);
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters_1 = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter_1 = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef_1);
                this._processorTypesBuilder.operator_add(_parameters_1, _parameter_1);
            }
        };
        JvmOperation _method_2 = this._processorTypesBuilder.toMethod(entity, fname, outType, _function_2);
        members.add((JvmMember)_method_2);
        Procedures.Procedure1 _function_3 = it -> {
            EList<JvmParameterizedTypeReference> _ins = params.getIns();
            for (JvmParameterizedTypeReference in : _ins) {
                EList _parameters = it.getParameters();
                String _simpleName = in.getSimpleName();
                String _firstLower = StringExtensions.toFirstLower((String)_simpleName);
                JvmType _type_1 = in.getType();
                JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(_type_1, new JvmTypeReference[0]);
                JvmFormalParameter _parameter = this._processorTypesBuilder.toParameter(entity, _firstLower, _typeRef);
                this._processorTypesBuilder.operator_add(_parameters, _parameter);
            }
        };
        JvmOperation _method_3 = this._processorTypesBuilder.toMethod(entity, fname, outType, _function_3);
        members.add((JvmMember)_method_3);
    }

    public QualifiedName daoFullyQualifiedName(DaoEntity entity, String implPackage) {
        QualifiedName _append;
        boolean _greaterEqualsThan;
        QualifiedName fqname = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)entity);
        boolean _equals = Objects.equal((Object)implPackage, null);
        if (_equals) {
            return fqname;
        }
        int _indexOf = implPackage.indexOf(".");
        boolean bl = _greaterEqualsThan = _indexOf >= 0;
        if (_greaterEqualsThan) {
            String[] segments = implPackage.split(".");
            QualifiedName fqn = QualifiedName.create((String[])segments);
            String _lastSegment = fqname.getLastSegment();
            return fqn.append(_lastSegment);
        }
        QualifiedName fqn_1 = fqname.skipLast(1);
        fqn_1 = _append = fqn_1.append(implPackage);
        String _lastSegment_1 = fqname.getLastSegment();
        String _plus = String.valueOf(_lastSegment_1) + "Impl";
        return fqn_1.append(_plus);
    }

    public void inferFunctionProcedure(DaoEntity entity, FunProcType type, DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        if (type instanceof FunctionCall) {
            this._inferFunctionProcedure(entity, (FunctionCall)type, params, entityType, simpleName, members);
            return;
        }
        if (type instanceof FunctionCallQuery) {
            this._inferFunctionProcedure(entity, (FunctionCallQuery)type, params, entityType, simpleName, members);
            return;
        }
        if (type instanceof FunctionQuery) {
            this._inferFunctionProcedure(entity, (FunctionQuery)type, params, entityType, simpleName, members);
            return;
        }
        if (type instanceof ProcedureCallQuery) {
            this._inferFunctionProcedure(entity, (ProcedureCallQuery)type, params, entityType, simpleName, members);
            return;
        }
        if (type instanceof ProcedureUpdate) {
            this._inferFunctionProcedure(entity, (ProcedureUpdate)type, params, entityType, simpleName, members);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(entity, type, params, entityType, simpleName, members).toString());
    }

    public void inferFunctionProcedureIfx(DaoEntity entity, FunProcType type, DaoDirectiveParameters params, JvmGenericType entityType, String simpleName, List<JvmMember> members) {
        if (type instanceof FunctionCall) {
            this._inferFunctionProcedureIfx(entity, (FunctionCall)type, params, entityType, simpleName, members);
            return;
        }
        if (type instanceof FunctionCallQuery) {
            this._inferFunctionProcedureIfx(entity, (FunctionCallQuery)type, params, entityType, simpleName, members);
            return;
        }
        if (type instanceof FunctionQuery) {
            this._inferFunctionProcedureIfx(entity, (FunctionQuery)type, params, entityType, simpleName, members);
            return;
        }
        if (type instanceof ProcedureCallQuery) {
            this._inferFunctionProcedureIfx(entity, (ProcedureCallQuery)type, params, entityType, simpleName, members);
            return;
        }
        if (type instanceof ProcedureUpdate) {
            this._inferFunctionProcedureIfx(entity, (ProcedureUpdate)type, params, entityType, simpleName, members);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(entity, type, params, entityType, simpleName, members).toString());
    }

    private /* synthetic */ void lambda$119(PojoAttribute pojoAttribute, final JvmTypeReference jvmTypeReference, JvmField it_1) {
        XExpression _initExpr_1;
        boolean _notEquals_5;
        String _documentation_1 = this._processorTypesBuilder.getDocumentation(pojoAttribute);
        this._processorTypesBuilder.setDocumentation((JvmIdentifiableElement)it_1, _documentation_1);
        List<Annotation> _attributeAnnotations = this._processorGeneratorUtils.attributeAnnotations(pojoAttribute);
        Functions.Function1 _function_12 = a -> a.getAnnotation();
        List _map_2 = ListExtensions.map(_attributeAnnotations, (Functions.Function1)_function_12);
        this._processorTypesBuilder.addAnnotations((JvmAnnotationTarget)it_1, _map_2);
        boolean _isStatic = pojoAttribute.isStatic();
        it_1.setStatic(_isStatic);
        boolean _isStatic_1 = pojoAttribute.isStatic();
        if (_isStatic_1) {
            it_1.setVisibility(JvmVisibility.PUBLIC);
        }
        boolean bl = _notEquals_5 = !Objects.equal((Object)(_initExpr_1 = pojoAttribute.getInitExpr()), null);
        if (_notEquals_5) {
            XExpression _initExpr_2 = pojoAttribute.getInitExpr();
            this._processorTypesBuilder.setInitializer(it_1, _initExpr_2);
        } else {
            boolean _isList = this._processorGeneratorUtils.isList(pojoAttribute);
            if (_isList) {
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"new java.util.Array");
                        String _simpleName = jvmTypeReference.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)"()");
                    }
                };
                this._processorTypesBuilder.setInitializer(it_1, _client);
            }
        }
    }
}

