/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.model.generator;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmSpecializedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.common.types.util.ITypeReferenceVisitor;
import org.eclipse.xtext.xbase.compiler.ErrorSafeExtensions;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.TypeReferenceSerializer;
import org.eclipse.xtext.xbase.compiler.output.ErrorTreeAppendable;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.sqlproc.model.generator.BrokenTypeRefDetector;

public class ProcessorModelErrorSafeExtensions
extends ErrorSafeExtensions {
    @Inject
    @Extension
    private TypeReferenceSerializer _typeReferenceSerializer;

    protected ITreeAppendable openErrorAppendable(ITreeAppendable parent, ITreeAppendable child) {
        ITreeAppendable _xifexpression = null;
        if (!(child instanceof ErrorTreeAppendable)) {
            ErrorTreeAppendable _errorChild = parent.errorChild();
            _xifexpression = _errorChild.append((CharSequence)" ");
        } else {
            _xifexpression = child;
        }
        return _xifexpression;
    }

    protected ITreeAppendable closeErrorAppendable(ITreeAppendable parent, ITreeAppendable child) {
        ITreeAppendable _xblockexpression = null;
        if (child instanceof ErrorTreeAppendable && !Objects.equal((Object)child, (Object)parent)) {
            child.append((CharSequence)"");
        }
        _xblockexpression = parent;
        return _xblockexpression;
    }

    public void serializeSafely(JvmTypeReference typeRef, String surrogateType, ITreeAppendable appendable) {
        if (Objects.equal((Object)typeRef, null) || Objects.equal((Object)typeRef.getType(), null)) {
            boolean _matched = false;
            if (typeRef instanceof JvmSpecializedTypeReference) {
                _matched = true;
                JvmTypeReference _equivalent = ((JvmSpecializedTypeReference)typeRef).getEquivalent();
                this.serializeSafely(_equivalent, surrogateType, appendable);
            }
            if (!_matched && typeRef instanceof JvmUnknownTypeReference) {
                _matched = true;
                String _qualifiedName = ((JvmUnknownTypeReference)typeRef).getQualifiedName();
                appendable.append((CharSequence)_qualifiedName);
            }
            if (!_matched) {
                appendable.append((CharSequence)"Object");
                ITreeAppendable errorChild = this.openErrorAppendable(appendable, appendable);
                errorChild.append((CharSequence)"type is 'null'");
                this.closeErrorAppendable(appendable, errorChild);
            }
        } else {
            BrokenTypeRefDetector _brokenTypeRefDetector = new BrokenTypeRefDetector();
            Boolean _accept = (Boolean)typeRef.accept((ITypeReferenceVisitor)_brokenTypeRefDetector);
            if (_accept.booleanValue()) {
                ITreeAppendable errorChild = this.openErrorAppendable(appendable, appendable);
                try {
                    EObject _eContainer = typeRef.eContainer();
                    this._typeReferenceSerializer.serialize(typeRef, _eContainer, (IAppendable)errorChild);
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception exception = (Exception)_t;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                this.closeErrorAppendable(appendable, errorChild);
            } else {
                EObject _eContainer_1 = typeRef.eContainer();
                this._typeReferenceSerializer.serialize(typeRef, _eContainer_1, (IAppendable)appendable);
            }
        }
    }
}

