/*
 * generated by Xtext 2.10.0-SNAPSHOT
 */
package org.sqlproc.model.scoping

import org.eclipse.xtext.scoping.IScope
import org.eclipse.emf.ecore.EReference
import org.eclipse.xtext.scoping.Scopes
import org.sqlproc.model.processorModel.PojoEntity
import com.google.inject.Inject
import org.sqlproc.model.jvmmodel.ProcessorGeneratorUtils
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.EcoreUtil2
import org.sqlproc.model.processorModel.ProcessorModelPackage
import org.sqlproc.model.processorModel.DaoEntity

/**
 * This class contains custom scoping description.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#scoping
 * on how and when to use it.
 */
class ProcessorModelScopeProvider extends AbstractProcessorModelScopeProvider {
	
	@Inject extension ProcessorGeneratorUtils
	
    override IScope getScope(EObject context, EReference reference) {

        if (reference == ProcessorModelPackage.Literals.DIRECTIVE_PROPERTIES__FEATURES) {
            val PojoEntity pojo = EcoreUtil2.getContainerOfType(context, PojoEntity)
            //if (pojo.getSuperType() != null) {
                // TODO - problem, ze Pojo rodice nemusi byt inicializovano
                //val IScope scope = Scopes.scopeFor(allAttributes(pojo))
                val IScope scope = Scopes.scopeFor(pojo.features.map[feature])
                return scope
            //}
        }
        else if (reference == ProcessorModelPackage.Literals.DAO_DIRECTIVE_DISCRIMINATOR__ANCESTOR) {
            val DaoEntity dao = EcoreUtil2.getContainerOfType(context, DaoEntity)
            if (dao != null) {
            	val PojoEntity pojo = dao.getPojo
                val IScope scope = Scopes.scopeFor(allAttributes(pojo))
                return scope
            }
        }
        
		val IScope _scope =  super.getScope(context, reference)
        return _scope
    }

}
