/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.model.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.sqlproc.model.processorModel.AbstractEntity;
import org.sqlproc.model.processorModel.AnnotatedEntity;
import org.sqlproc.model.processorModel.AnnotatedFeature;
import org.sqlproc.model.processorModel.AnnotationDefinitionModel;
import org.sqlproc.model.processorModel.Artifacts;
import org.sqlproc.model.processorModel.DaoEntity;
import org.sqlproc.model.processorModel.Entity;
import org.sqlproc.model.processorModel.Feature;
import org.sqlproc.model.processorModel.FunctionDefinitionModel;
import org.sqlproc.model.processorModel.Package;
import org.sqlproc.model.processorModel.PojoDefinitionModel;
import org.sqlproc.model.processorModel.PojoEntity;
import org.sqlproc.model.processorModel.ProcedureDefinitionModel;
import org.sqlproc.model.processorModel.ProcessorModelPackage;
import org.sqlproc.model.processorModel.Property;
import org.sqlproc.model.processorModel.TableDefinitionModel;
import org.sqlproc.model.validation.AbstractProcessorModelValidator;
import org.sqlproc.plugin.lib.property.ModelProperty;
import org.sqlproc.plugin.lib.resolver.DbResolver;
import org.sqlproc.plugin.lib.util.CommonUtils;

public class ProcessorModelValidator
extends AbstractProcessorModelValidator {
    @Inject
    private DbResolver dbResolver;
    @Inject
    private ModelProperty modelProperty;

    @Check
    public void checkUniquePojoDefinition(PojoDefinitionModel pojoDefinition) {
        boolean _skipVerification = CommonUtils.skipVerification(pojoDefinition, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(pojoDefinition);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<PojoDefinitionModel> _pojos = artifacts.getPojos();
        for (PojoDefinitionModel definition : _pojos) {
            boolean _notEquals;
            boolean _and = false;
            boolean _and_1 = false;
            boolean bl = _notEquals = !Objects.equal((Object)definition, null);
            if (!_notEquals) {
                _and_1 = false;
            } else {
                boolean bl2 = _and_1 = definition != pojoDefinition;
            }
            if (!_and_1) {
                _and = false;
            } else {
                boolean _equals_1;
                String _name = pojoDefinition.getName();
                String _name_1 = definition.getName();
                _and = _equals_1 = Objects.equal((Object)_name, (Object)_name_1);
            }
            if (!_and) continue;
            String _name_2 = pojoDefinition.getName();
            String _plus = "Duplicate name : " + _name_2;
            this.error(_plus, (EStructuralFeature)ProcessorModelPackage.Literals.POJO_DEFINITION_MODEL__NAME);
            return;
        }
    }

    @Check
    public void checkUniqueAnnotationDefinition(AnnotationDefinitionModel annotationDefinition) {
        boolean _skipVerification = CommonUtils.skipVerification(annotationDefinition, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(annotationDefinition);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<AnnotationDefinitionModel> _annotations = artifacts.getAnnotations();
        for (AnnotationDefinitionModel definition : _annotations) {
            boolean _notEquals;
            boolean _and = false;
            boolean _and_1 = false;
            boolean bl = _notEquals = !Objects.equal((Object)definition, null);
            if (!_notEquals) {
                _and_1 = false;
            } else {
                boolean bl2 = _and_1 = definition != annotationDefinition;
            }
            if (!_and_1) {
                _and = false;
            } else {
                boolean _equals_1;
                String _name = annotationDefinition.getName();
                String _name_1 = definition.getName();
                _and = _equals_1 = Objects.equal((Object)_name, (Object)_name_1);
            }
            if (!_and) continue;
            String _name_2 = annotationDefinition.getName();
            String _plus = "Duplicate name : " + _name_2;
            this.error(_plus, (EStructuralFeature)ProcessorModelPackage.Literals.ANNOTATION_DEFINITION_MODEL__NAME);
            return;
        }
    }

    @Check
    public void checkUniqueProperty(Property property) {
        boolean _skipVerification = CommonUtils.skipVerification(property, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(property);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<Property> _properties = artifacts.getProperties();
        for (Property prop : _properties) {
            String _name_6;
            boolean _startsWith_4;
            boolean _not_4;
            String _name_5;
            boolean _startsWith_3;
            boolean _not_3;
            String _name_4;
            boolean _startsWith_2;
            boolean _not_2;
            String _name_3;
            boolean _startsWith_1;
            boolean _not_1;
            boolean _not;
            boolean _notEquals;
            boolean _and = false;
            boolean _and_1 = false;
            boolean bl = _notEquals = !Objects.equal((Object)prop, null);
            if (!_notEquals) {
                _and_1 = false;
            } else {
                boolean bl2 = _and_1 = prop != property;
            }
            if (!_and_1) {
                _and = false;
            } else {
                boolean _equals_1;
                String _name = prop.getName();
                String _name_1 = property.getName();
                _and = _equals_1 = Objects.equal((Object)_name, (Object)_name_1);
            }
            if (!_and) continue;
            boolean _and_2 = false;
            boolean _and_3 = false;
            boolean _and_4 = false;
            boolean _and_5 = false;
            String _name_2 = prop.getName();
            boolean _startsWith = _name_2.startsWith("pojogen");
            boolean bl3 = _not = !_startsWith;
            _and_5 = !_not ? false : (_not_1 = !(_startsWith_1 = (_name_3 = prop.getName()).startsWith("database")));
            _and_4 = !_and_5 ? false : (_not_2 = !(_startsWith_2 = (_name_4 = prop.getName()).startsWith("metagen")));
            _and_3 = !_and_4 ? false : (_not_3 = !(_startsWith_3 = (_name_5 = prop.getName()).startsWith("daogen")));
            _and_2 = !_and_3 ? false : (_not_4 = !(_startsWith_4 = (_name_6 = prop.getName()).startsWith("replace-text")));
            if (!_and_2) continue;
            String _name_7 = property.getName();
            String _plus = "Duplicate name : " + _name_7;
            this.error(_plus, (EStructuralFeature)ProcessorModelPackage.Literals.PROPERTY__NAME);
            return;
        }
    }

    @Check
    public void checkTableDefinition(TableDefinitionModel tableDefinition) {
        String _table;
        boolean _checkTable;
        boolean _not;
        boolean _skipVerification = CommonUtils.skipVerification(tableDefinition, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(tableDefinition);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<TableDefinitionModel> _tables = artifacts.getTables();
        for (TableDefinitionModel table : _tables) {
            boolean _notEquals;
            boolean _and = false;
            boolean _and_1 = false;
            boolean bl = _notEquals = !Objects.equal((Object)table, null);
            if (!_notEquals) {
                _and_1 = false;
            } else {
                boolean bl2 = _and_1 = table != tableDefinition;
            }
            if (!_and_1) {
                _and = false;
            } else {
                boolean _equals_1;
                String _name = tableDefinition.getName();
                String _name_1 = table.getName();
                _and = _equals_1 = Objects.equal((Object)_name, (Object)_name_1);
            }
            if (!_and) continue;
            String _name_2 = tableDefinition.getName();
            String _plus = "Duplicate name : " + _name_2;
            String _plus_1 = String.valueOf(_plus) + "[table]";
            this.error(_plus_1, (EStructuralFeature)ProcessorModelPackage.Literals.TABLE_DEFINITION_MODEL__NAME);
            return;
        }
        boolean _and_2 = false;
        boolean _isResolveDb = this.isResolveDb(tableDefinition);
        _and_2 = !_isResolveDb ? false : (_not = !(_checkTable = this.dbResolver.checkTable(tableDefinition, _table = tableDefinition.getTable())));
        if (_and_2) {
            String _table_1 = tableDefinition.getTable();
            String _plus_2 = "Cannot find table in DB : " + _table_1;
            this.error(_plus_2, (EStructuralFeature)ProcessorModelPackage.Literals.TABLE_DEFINITION_MODEL__TABLE);
        }
    }

    @Check
    public void checkProcedureDefinition(ProcedureDefinitionModel procedureDefinition) {
        String _table;
        boolean _checkProcedure;
        boolean _not;
        boolean _skipVerification = CommonUtils.skipVerification(procedureDefinition, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(procedureDefinition);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<ProcedureDefinitionModel> _procedures = artifacts.getProcedures();
        for (ProcedureDefinitionModel procedure : _procedures) {
            boolean _notEquals;
            boolean _and = false;
            boolean _and_1 = false;
            boolean bl = _notEquals = !Objects.equal((Object)procedure, null);
            if (!_notEquals) {
                _and_1 = false;
            } else {
                boolean bl2 = _and_1 = procedure != procedureDefinition;
            }
            if (!_and_1) {
                _and = false;
            } else {
                boolean _equals_1;
                String _name = procedureDefinition.getName();
                String _name_1 = procedure.getName();
                _and = _equals_1 = Objects.equal((Object)_name, (Object)_name_1);
            }
            if (!_and) continue;
            String _name_2 = procedureDefinition.getName();
            String _plus = "Duplicate name : " + _name_2;
            String _plus_1 = String.valueOf(_plus) + "[procedure]";
            this.error(_plus_1, (EStructuralFeature)ProcessorModelPackage.Literals.PROCEDURE_DEFINITION_MODEL__NAME);
            return;
        }
        boolean _and_2 = false;
        boolean _isResolveDb = this.isResolveDb(procedureDefinition);
        _and_2 = !_isResolveDb ? false : (_not = !(_checkProcedure = this.dbResolver.checkProcedure(procedureDefinition, _table = procedureDefinition.getTable())));
        if (_and_2) {
            String _table_1 = procedureDefinition.getTable();
            String _plus_2 = "Cannot find procedure in DB : " + _table_1;
            this.error(_plus_2, (EStructuralFeature)ProcessorModelPackage.Literals.PROCEDURE_DEFINITION_MODEL__NAME);
        }
    }

    @Check
    public void checkFunctionDefinition(FunctionDefinitionModel functionDefinition) {
        boolean _skipVerification = CommonUtils.skipVerification(functionDefinition, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(functionDefinition);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<FunctionDefinitionModel> _functions = artifacts.getFunctions();
        for (FunctionDefinitionModel function : _functions) {
            boolean _notEquals;
            boolean _and = false;
            boolean _and_1 = false;
            boolean bl = _notEquals = !Objects.equal((Object)function, null);
            if (!_notEquals) {
                _and_1 = false;
            } else {
                boolean bl2 = _and_1 = function != functionDefinition;
            }
            if (!_and_1) {
                _and = false;
            } else {
                boolean _equals_1;
                String _name = functionDefinition.getName();
                String _name_1 = function.getName();
                _and = _equals_1 = Objects.equal((Object)_name, (Object)_name_1);
            }
            if (!_and) continue;
            String _name_2 = functionDefinition.getName();
            String _plus = "Duplicate name : " + _name_2;
            String _plus_1 = String.valueOf(_plus) + "[function]";
            this.error(_plus_1, (EStructuralFeature)ProcessorModelPackage.Literals.FUNCTION_DEFINITION_MODEL__NAME);
            return;
        }
    }

    @Check
    public void checkUniquePojoEntity(Entity entity) {
        boolean _skipVerification = CommonUtils.skipVerification(entity, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(entity);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<Package> _packages = artifacts.getPackages();
        for (Package pkg : _packages) {
            boolean _notEquals;
            boolean bl = _notEquals = !Objects.equal((Object)pkg, null);
            if (!_notEquals) continue;
            EList<AbstractEntity> _elements = pkg.getElements();
            for (AbstractEntity abstractEntity : _elements) {
                boolean _notEquals_3;
                Entity _entity_1;
                boolean _notEquals_2;
                boolean _and = false;
                boolean _notEquals_1 = !Objects.equal((Object)abstractEntity, null);
                _and = !_notEquals_1 ? false : abstractEntity instanceof AnnotatedEntity;
                if (!_and) continue;
                AnnotatedEntity annotatedEntity = (AnnotatedEntity)abstractEntity;
                Entity _entity = annotatedEntity.getEntity();
                boolean bl2 = _notEquals_2 = !Objects.equal((Object)_entity, null);
                if (!_notEquals_2) continue;
                Entity _entity_2 = _entity_1 = annotatedEntity.getEntity();
                boolean _and_1 = false;
                boolean _and_2 = false;
                boolean bl3 = _notEquals_3 = !Objects.equal((Object)_entity_2, null);
                if (!_notEquals_3) {
                    _and_2 = false;
                } else {
                    boolean bl4 = _and_2 = _entity_2 != entity;
                }
                if (!_and_2) {
                    _and_1 = false;
                } else {
                    boolean _equals_1;
                    String _name = entity.getName();
                    String _name_1 = _entity_2.getName();
                    _and_1 = _equals_1 = Objects.equal((Object)_name, (Object)_name_1);
                }
                if (!_and_1) continue;
                String _name_2 = entity.getName();
                String _plus = "Duplicate name : " + _name_2;
                this.error(_plus, (EStructuralFeature)ProcessorModelPackage.Literals.ENTITY__NAME);
                return;
            }
        }
    }

    @Check
    public void checkUniquePojoAttribute(final Feature feature) {
        block11: {
            Entity entity;
            block12: {
                boolean _notEquals;
                boolean _skipVerification = CommonUtils.skipVerification(feature, this.modelProperty);
                if (_skipVerification) {
                    return;
                }
                entity = (Entity)EcoreUtil2.getContainerOfType((EObject)feature, Entity.class);
                boolean bl = _notEquals = !Objects.equal((Object)entity, null);
                if (!_notEquals) break block11;
                if (!(entity instanceof PojoEntity)) break block12;
                PojoEntity pentity = (PojoEntity)entity;
                EList<AnnotatedFeature> _features = pentity.getFeatures();
                Functions.Function1<AnnotatedFeature, Feature> _function = new Functions.Function1<AnnotatedFeature, Feature>(){

                    public Feature apply(AnnotatedFeature it) {
                        return feature;
                    }
                };
                List _map = ListExtensions.map(_features, (Functions.Function1)_function);
                for (Feature _feature : _map) {
                    boolean _notEquals_1;
                    boolean _and = false;
                    boolean _and_1 = false;
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)_feature, null);
                    if (!_notEquals_1) {
                        _and_1 = false;
                    } else {
                        boolean bl3 = _and_1 = _feature != feature;
                    }
                    if (!_and_1) {
                        _and = false;
                    } else {
                        boolean _equals;
                        String _name = feature.getName();
                        String _name_1 = _feature.getName();
                        _and = _equals = Objects.equal((Object)_name, (Object)_name_1);
                    }
                    if (!_and) continue;
                    String _name_2 = feature.getName();
                    String _plus = "Duplicate name : " + _name_2;
                    this.error(_plus, (EStructuralFeature)ProcessorModelPackage.Literals.FEATURE__NAME);
                    return;
                }
                break block11;
            }
            if (!(entity instanceof DaoEntity)) break block11;
            DaoEntity pentity_1 = (DaoEntity)entity;
            EList<AnnotatedFeature> _features_1 = pentity_1.getFeatures();
            Functions.Function1<AnnotatedFeature, Feature> _function_1 = new Functions.Function1<AnnotatedFeature, Feature>(){

                public Feature apply(AnnotatedFeature it) {
                    return feature;
                }
            };
            List _map_1 = ListExtensions.map(_features_1, (Functions.Function1)_function_1);
            for (Feature _feature_1 : _map_1) {
                boolean _notEquals_2;
                boolean _and_2 = false;
                boolean _and_3 = false;
                boolean bl = _notEquals_2 = !Objects.equal((Object)_feature_1, null);
                if (!_notEquals_2) {
                    _and_3 = false;
                } else {
                    boolean bl4 = _and_3 = _feature_1 != feature;
                }
                if (!_and_3) {
                    _and_2 = false;
                } else {
                    boolean _equals_1;
                    String _name_3 = feature.getName();
                    String _name_4 = _feature_1.getName();
                    _and_2 = _equals_1 = Objects.equal((Object)_name_3, (Object)_name_4);
                }
                if (!_and_2) continue;
                String _name_5 = feature.getName();
                String _plus_1 = "Duplicate name : " + _name_5;
                this.error(_plus_1, (EStructuralFeature)ProcessorModelPackage.Literals.FEATURE__NAME);
                return;
            }
        }
    }

    public boolean isResolveDb(EObject model) {
        return this.dbResolver.isResolveDb(model);
    }

    public Artifacts getArtifacts(EObject model) {
        EObject root = EcoreUtil.getRootContainer((EObject)model);
        if (!(root instanceof Artifacts)) {
            return null;
        }
        return (Artifacts)root;
    }
}

