/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.model.generator;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.serializer.ISerializer;
import org.sqlproc.model.processorModel.AbstractEntity;
import org.sqlproc.model.processorModel.AnnotatedEntity;
import org.sqlproc.model.processorModel.AnnotatedFeature;
import org.sqlproc.model.processorModel.Artifacts;
import org.sqlproc.model.processorModel.Entity;
import org.sqlproc.model.processorModel.EnumEntity;
import org.sqlproc.model.processorModel.Package;
import org.sqlproc.model.processorModel.PojoEntity;
import org.sqlproc.model.util.Annotations;
import org.sqlproc.model.util.Utils;
import org.sqlproc.plugin.lib.generator.TableBaseGenerator;
import org.sqlproc.plugin.lib.property.ColumnAnnotations;
import org.sqlproc.plugin.lib.property.EnumAttribute;
import org.sqlproc.plugin.lib.property.ImplementsExtends;
import org.sqlproc.plugin.lib.property.ModelProperty;
import org.sqlproc.plugin.lib.property.PojoAnnotations;
import org.sqlproc.plugin.lib.property.PojoAttribute;
import org.sqlproc.plugin.lib.property.PojoDefinition;
import org.sqlproc.plugin.lib.resolver.DbResolver;
import org.sqlproc.plugin.lib.util.Stats;

public class TablePojoGenerator
extends TableBaseGenerator {
    protected Artifacts artifacts;
    protected Annotations entityAnnotations;
    protected Map<String, String> finalEntities;
    protected Map<String, Map<String, String>> finalEntitiesFeatures;
    protected Set<String> entityImports;

    public TablePojoGenerator(ModelProperty modelProperty, Artifacts artifacts, Map<String, String> finalEntities, Map<String, Map<String, String>> finalEntitiesFeatures, Annotations entityAnnotations, Set<String> entityImports, List<String> dbSequences, DbResolver.DbType dbType) {
        super(modelProperty, artifacts, dbSequences, dbType);
        this.artifacts = artifacts;
        this.entityAnnotations = entityAnnotations;
        this.finalEntities = finalEntities;
        this.finalEntitiesFeatures = finalEntitiesFeatures;
        this.entityImports = new TreeSet<String>();
        if (entityImports != null) {
            this.entityImports.addAll(entityImports);
        }
        if (this.doGenerateValidationAnnotations) {
            this.entityImports.add("javax.validation.constraints.NotNull");
            this.entityImports.add("javax.validation.constraints.Size");
        }
        this.debug.debug("entityAnnotations " + this.entityAnnotations);
        this.debug.debug("finalEntities " + this.finalEntities);
        this.debug.debug("finalEntitiesFeatures " + this.finalEntitiesFeatures);
        this.debug.debug("entityImports " + this.entityImports);
    }

    public String getPojoDefinitions(ModelProperty modelProperty, Artifacts artifacts, ISerializer serializer) {
        String result = this.getPojoDefinitions(serializer);
        return Utils.replaceAll(modelProperty, result, artifacts);
    }

    /*
     * WARNING - void declaration
     */
    public String getPojoDefinitions(ISerializer serializer) {
        LinkedHashSet<String> toStr;
        StringBuilder bufferPartial;
        StringBuilder bufferMeta;
        String pojoName;
        this.debug.debug("pojos " + this.pojos);
        this.debug.debug("pojoExtends " + this.pojoExtends);
        this.debug.debug("pojoInheritanceDiscriminator " + this.pojoInheritanceDiscriminator);
        this.debug.debug("pojoInheritanceSimple " + this.pojoInheritanceSimple);
        this.debug.debug("pojoDiscriminators " + this.pojoDiscriminators);
        this.debug.debug("indexes " + this.indexes);
        this.debug.debug("procedures " + this.procedures);
        this.debug.debug("functions " + this.functions);
        this.debug.debug("enums " + this.enums);
        StringBuilder buffer = new StringBuilder();
        boolean isSerializable = false;
        HashSet<String> serializables = new HashSet<String>();
        boolean oneMoreLine = false;
        if (this.entityImports != null && !this.entityImports.isEmpty()) {
            for (String string : this.entityImports) {
                buffer.append(NLINDENT).append("import ").append(string);
            }
            oneMoreLine = true;
        }
        if (oneMoreLine) {
            buffer.append("\n");
        }
        if (!this.toImplements.isEmpty()) {
            for (ImplementsExtends implementsExtends : this.toImplements.values()) {
                String identifier = implementsExtends.getIdentifier();
                if (identifier.endsWith("Serializable")) {
                    if (!implementsExtends.getDbTables().isEmpty()) {
                        for (String dbTable : implementsExtends.getDbTables()) {
                            serializables.add(dbTable);
                        }
                        continue;
                    }
                    if (!implementsExtends.getDbNotTables().isEmpty()) {
                        for (String pojo : this.pojos.keySet()) {
                            serializables.add(pojo);
                        }
                        for (String pojo : this.enums.keySet()) {
                            serializables.add(pojo);
                        }
                        for (String pojo : this.procedures.keySet()) {
                            serializables.add(pojo);
                        }
                        for (String pojo : this.functions.keySet()) {
                            serializables.add(pojo);
                        }
                        for (String dbTable : implementsExtends.getDbNotTables()) {
                            serializables.remove(dbTable);
                        }
                        continue;
                    }
                    isSerializable = true;
                    continue;
                }
                if (implementsExtends.isGenerics()) {
                    buffer.append(NLINDENT).append("#Generics");
                }
                if (!implementsExtends.getDbTables().isEmpty()) {
                    buffer.append(NLINDENT).append("#OnlyPojos(");
                    boolean first = true;
                    for (String dbTable : implementsExtends.getDbTables()) {
                        if (!first) {
                            buffer.append(",");
                        } else {
                            first = false;
                        }
                        String pojoName2 = (String)this.tableNames.get(dbTable);
                        if (pojoName2 == null) {
                            pojoName2 = dbTable;
                        }
                        String string = this.tableToCamelCase(pojoName2);
                        buffer.append(string);
                    }
                    buffer.append(")");
                }
                if (!implementsExtends.getDbNotTables().isEmpty()) {
                    buffer.append(NLINDENT).append("#ExceptPojos(");
                    boolean first = true;
                    for (String dbTable : implementsExtends.getDbNotTables()) {
                        if (!first) {
                            buffer.append(",");
                        } else {
                            first = false;
                        }
                        String pojoName2 = (String)this.tableNames.get(dbTable);
                        if (pojoName2 == null) {
                            pojoName2 = dbTable;
                        }
                        String string = this.tableToCamelCase(pojoName2);
                        buffer.append(string);
                    }
                    buffer.append(")");
                }
                buffer.append(NLINDENT).append("implements ").append(identifier);
            }
            oneMoreLine = true;
        }
        if (this.toExtends != null) {
            String realPojoName;
            if (this.toExtends.isGenerics()) {
                buffer.append(NLINDENT).append("#Generics");
            }
            if (!this.toExtends.getDbTables().isEmpty()) {
                buffer.append(NLINDENT).append("#OnlyPojos(");
                boolean bl = true;
                for (String dbTable : this.toExtends.getDbTables()) {
                    boolean bl2;
                    if (!bl2) {
                        buffer.append(",");
                    } else {
                        bl2 = false;
                    }
                    String pojoName3 = (String)this.tableNames.get(dbTable);
                    if (pojoName3 == null) {
                        pojoName3 = dbTable;
                    }
                    realPojoName = this.tableToCamelCase(pojoName3);
                    buffer.append(realPojoName);
                }
                buffer.append(")");
            }
            if (!this.toExtends.getDbNotTables().isEmpty()) {
                buffer.append(NLINDENT).append("#ExceptPojos(");
                boolean bl = true;
                for (String dbTable : this.toExtends.getDbNotTables()) {
                    boolean bl3;
                    if (!bl3) {
                        buffer.append(",");
                    } else {
                        bl3 = false;
                    }
                    String pojoName4 = (String)this.tableNames.get(dbTable);
                    if (pojoName4 == null) {
                        pojoName4 = dbTable;
                    }
                    realPojoName = this.tableToCamelCase(pojoName4);
                    buffer.append(realPojoName);
                }
                buffer.append(")");
            }
            buffer.append(NLINDENT).append("extends ").append(this.toExtends.getIdentifier());
            oneMoreLine = true;
        }
        if (oneMoreLine) {
            buffer.append("\n");
        }
        for (Map.Entry entry : this.enums.entrySet()) {
            String string;
            String pojo = (String)entry.getKey();
            String table = (String)this.enumsTables.get(pojo);
            if (table != null && (!this.onlyTables.isEmpty() && !this.onlyTables.contains(table) || this.ignoreTables.contains(table) || !TableBaseGenerator.Filter.isTable(this.activeFilter, table))) continue;
            String pojoName5 = (String)this.tableNames.get(pojo);
            if (pojoName5 == null) {
                pojoName5 = pojo;
            }
            if (this.finalEntities.containsKey(string = this.tableToCamelCase(pojoName5))) {
                buffer.append(Utils.getFinalContent(this.finalEntities.get(string)));
                continue;
            }
            if (this.entityAnnotations != null) {
                buffer.append((CharSequence)this.entityAnnotations.getEntityAnnotationsDefinitions(string, serializer, true, this.entityAnnotations.isNonStandardPojoAnnotations(string)));
                buffer.append((CharSequence)this.entityAnnotations.getConstructorAnnotationsDefinitions(string, serializer, true));
                buffer.append((CharSequence)this.entityAnnotations.getStaticAnnotationsDefinitions(string, serializer, true));
                buffer.append((CharSequence)this.entityAnnotations.getConflictAnnotationsDefinitions(string, serializer, true));
            }
            if (isSerializable || serializables.contains(pojo)) {
                buffer.append(NLINDENT).append("#Serializable(1)");
            }
            this.printComment(buffer, (String)this.comments.get(pojo), INDENT);
            buffer.append(NLINDENT);
            if (this.makeItFinal) {
                buffer.append("final ");
            }
            buffer.append("#Enum ");
            if (this.enumForCheckConstraints.containsKey(pojoName5)) {
                buffer.append((String)this.enumForCheckConstraints.get(pojoName5));
            } else {
                buffer.append(string);
            }
            if (this.pojoExtends.containsKey(pojo)) {
                buffer.append(" extends ").append(this.tableToCamelCase((String)this.pojoExtends.get(pojo)));
            }
            buffer.append(" {");
            buffer.append(NLINDENT).append(INDENT).append("#Values(");
            TreeSet<String> values = new TreeSet<String>();
            for (EnumAttribute enumAttribute : (List)entry.getValue()) {
                String name2;
                Iterator<Object> sb = new StringBuilder();
                if (enumAttribute.getIntValue() == null && enumAttribute.getStrValue() == null) continue;
                String string2 = name2 = this.columnNames.containsKey(pojo) ? (String)((Map)this.columnNames.get(pojo)).get(enumAttribute.getName()) : null;
                if (name2 == null) {
                    name2 = enumAttribute.getName();
                }
                if (enumAttribute.getIntValue() == null && enumAttribute.getStrValue() == null) {
                    name2 = this.columnToCamelCase(name2);
                }
                ((StringBuilder)((Object)sb)).append(name2).append(" = ");
                if (enumAttribute.getIntValue() != null) {
                    ((StringBuilder)((Object)sb)).append(enumAttribute.getIntValue());
                } else if (enumAttribute.getStrValue() != null) {
                    ((StringBuilder)((Object)sb)).append("\"").append(enumAttribute.getStrValue()).append("\"");
                }
                values.add(((StringBuilder)((Object)sb)).toString());
            }
            boolean bl = true;
            for (String string3 : values) {
                boolean bl4;
                if (!bl4) {
                    buffer.append(",");
                } else {
                    bl4 = false;
                }
                buffer.append(string3);
            }
            buffer.append(")");
            for (EnumAttribute enumAttribute : (List)entry.getValue()) {
                String name;
                if (enumAttribute.getIntValue() != null || enumAttribute.getStrValue() != null) continue;
                String string4 = name = this.columnNames.containsKey(pojo) ? (String)((Map)this.columnNames.get(pojo)).get(enumAttribute.getName()) : null;
                if (name == null) {
                    name = enumAttribute.getName();
                }
                if (enumAttribute.getIntValue() == null && enumAttribute.getStrValue() == null) {
                    name = this.columnToCamelCase(name);
                }
                buffer.append(NLINDENT).append(INDENT).append("#Attr ").append(enumAttribute.getWrapperClassName()).append(' ').append(name);
            }
            if (this.finalEntitiesFeatures.containsKey(string)) {
                buffer.append("\n");
                for (Map.Entry entry2 : this.finalEntitiesFeatures.get(string).entrySet()) {
                    buffer.append(Utils.getFinalContent((String)entry2.getValue()));
                }
                buffer.append(INDENT).append("}\n");
                continue;
            }
            buffer.append(NLINDENT).append("}\n");
        }
        for (String string : this.pojos.keySet()) {
            void var17_79;
            PojoAttribute attribute;
            String realPojoName;
            if (!this.onlyTables.isEmpty() && !this.onlyTables.contains(string) || this.ignoreTables.contains(string) || !TableBaseGenerator.Filter.isTable(this.activeFilter, string)) continue;
            pojoName = (String)this.tableNames.get(string);
            if (pojoName == null) {
                pojoName = string;
            }
            if (this.finalEntities.containsKey(realPojoName = this.tableToCamelCase(pojoName))) {
                buffer.append(Utils.getFinalContent(this.finalEntities.get(realPojoName)));
                continue;
            }
            if (this.entityAnnotations != null) {
                buffer.append((CharSequence)this.entityAnnotations.getEntityAnnotationsDefinitions(realPojoName, serializer, true, this.entityAnnotations.isNonStandardPojoAnnotations(realPojoName)));
                buffer.append((CharSequence)this.entityAnnotations.getConstructorAnnotationsDefinitions(realPojoName, serializer, true));
                buffer.append((CharSequence)this.entityAnnotations.getStaticAnnotationsDefinitions(realPojoName, serializer, true));
                buffer.append((CharSequence)this.entityAnnotations.getConflictAnnotationsDefinitions(realPojoName, serializer, true));
            }
            this.addPojoAnnotations(realPojoName, buffer);
            bufferMeta = new StringBuilder();
            if (this.pojoDiscriminators.containsKey(string)) {
                bufferMeta.append(this.nlindent()).append("#InheritanceChild(").append((String)this.pojoDiscriminators.get(string)).append(")");
            }
            if (this.generateOperators != null) {
                bufferMeta.append(this.nlindent()).append("#Operators");
                if (!"operators".equals(this.generateOperators)) {
                    bufferMeta.append("(").append(this.generateOperators).append(")");
                }
            }
            if (isSerializable || serializables.contains(string)) {
                bufferMeta.append(this.nlindent()).append("#Serializable(1)");
            }
            if (this.generateMethods.contains("index") && this.indexes.containsKey(string)) {
                List mainList = (List)this.indexes.get(string);
                TreeSet<String> treeSet = new TreeSet<String>();
                int i = 0;
                int n = mainList.size();
                while (i < n) {
                    void var17_77;
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean first = true;
                    for (PojoAttribute attr : ((Map)mainList.get(i)).keySet()) {
                        if (attr.getDbName() != null && this.ignoreColumns.containsKey(string) && ((Set)this.ignoreColumns.get(string)).contains(attr.getDbName())) {
                            Object var17_76 = null;
                            break;
                        }
                        String name3 = this.columnNames.containsKey(string) ? (String)((Map)this.columnNames.get(string)).get(attr.getName()) : null;
                        name3 = name3 == null ? attr.getName() : this.columnToCamelCase(name3);
                        if (!first) {
                            stringBuilder.append(",");
                        } else {
                            first = false;
                        }
                        stringBuilder.append(name3);
                    }
                    if (var17_77 != null) {
                        treeSet.add(var17_77.toString());
                    }
                    ++i;
                }
                for (String s : treeSet) {
                    bufferMeta.append(this.nlindent());
                    if (this.generateMethods.contains("enumIndex")) {
                        bufferMeta.append("#EnumIndex(");
                    } else {
                        bufferMeta.append("#Index(");
                    }
                    bufferMeta.append(s).append(")");
                }
            }
            LinkedHashSet<String> pkeys = new LinkedHashSet<String>();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            LinkedHashSet<String> procId = new LinkedHashSet<String>();
            bufferPartial = new StringBuilder();
            this.printComment(bufferPartial, (String)this.comments.get(string), INDENT);
            bufferPartial.append(NLINDENT);
            if (this.makeItFinal) {
                bufferPartial.append("final ");
            }
            if ((this.pojoInheritanceDiscriminator.containsKey(string) || this.pojoInheritanceSimple.containsKey(string)) && !this.notAbstractTables.contains(string)) {
                bufferPartial.append("abstract ");
            }
            bufferPartial.append("#Pojo ");
            bufferPartial.append(realPojoName);
            if (this.pojoExtends.containsKey(string)) {
                bufferPartial.append(" extends ").append(this.tableToCamelCase((String)this.pojoExtends.get(string)));
            }
            bufferPartial.append(" {");
            LinkedHashMap<String, PojoAttribute> linkedHashMap = new LinkedHashMap<String, PojoAttribute>();
            Object var17_78 = null;
            for (Map.Entry pentry : ((Map)this.pojos.get(string)).entrySet()) {
                if (this.ignoreColumns.containsKey(string) && ((Set)this.ignoreColumns.get(string)).contains(pentry.getKey())) continue;
                attribute = (PojoAttribute)pentry.getValue();
                String name = this.columnNames.containsKey(string) ? (String)((Map)this.columnNames.get(string)).get(pentry.getKey()) : null;
                name = name == null ? attribute.getName() : this.columnToCamelCase(name);
                if (this.entityAnnotations != null) {
                    bufferPartial.append((CharSequence)this.entityAnnotations.getAttributeAnnotationsDefinitions(realPojoName, name, serializer, true, this.entityAnnotations.isNonStandardPojoAnnotations(realPojoName, name)));
                    bufferPartial.append((CharSequence)this.entityAnnotations.getGetterAnnotationsDefinitions(realPojoName, name, serializer, true));
                    bufferPartial.append((CharSequence)this.entityAnnotations.getSetterAnnotationsDefinitions(realPojoName, name, serializer, true));
                }
                if (this.doGenerateValidationAnnotations) {
                    if (!((!this.requiredColumns.containsKey(string) || !((Set)this.requiredColumns.get(string)).contains(pentry.getKey())) && (!attribute.isRequired() || attribute.isPrimaryKey()) || this.notRequiredColumns.containsKey(string) && ((Set)this.notRequiredColumns.get(string)).contains(pentry.getKey()) || this.entityAnnotations != null && this.entityAnnotations.hasAttributeAnnotationsDefinitions(realPojoName, name, "javax.validation.constraints.NotNull"))) {
                        bufferPartial.append(NLINDENT).append(INDENT).append("@NotNull");
                    }
                    if (!(attribute.getDependencyClassName() != null || attribute.isPrimitive() || !attribute.isString() || attribute.getSize() <= 0 || this.entityAnnotations != null && this.entityAnnotations.hasAttributeAnnotationsDefinitions(realPojoName, name, "javax.validation.constraints.Size"))) {
                        bufferPartial.append(NLINDENT).append(INDENT).append("@Size(max = ").append(attribute.getSize()).append(")");
                    }
                }
                this.addColumnAnnotations(realPojoName, name, bufferPartial);
                StringBuilder bufferMetaAttr = new StringBuilder();
                if (attribute.isDef()) {
                    if (this.generateMethods.contains("isDef")) {
                        bufferMetaAttr.append(this.nlindent2()).append("#IsDef");
                    } else if (this.generateMethods.contains("enumDef")) {
                        bufferMetaAttr.append(this.nlindent2()).append("#EnumDef");
                    }
                }
                if (attribute.toInit()) {
                    if (this.generateMethods.contains("toInit")) {
                        bufferMetaAttr.append(this.nlindent2()).append("#ToInit");
                    } else if (this.generateMethods.contains("enumInit")) {
                        bufferMetaAttr.append(this.nlindent2()).append("#EnumInit");
                    }
                }
                if (this.inheritanceColumns.containsKey(string) && ((String)pentry.getKey()).equals(this.inheritanceColumns.get(string))) {
                    bufferMetaAttr.append(this.nlindent2()).append("#InheritanceDiscriminator");
                }
                if (attribute.isVersion()) {
                    bufferMetaAttr.append(this.nlindent2()).append("#Version");
                }
                if (!attribute.isVersion() && (this.requiredColumns.containsKey(string) && ((Set)this.requiredColumns.get(string)).contains(pentry.getKey()) || attribute.isRequired() && !attribute.isPrimaryKey()) && (!this.notRequiredColumns.containsKey(string) || !((Set)this.notRequiredColumns.get(string)).contains(pentry.getKey()))) {
                    bufferMetaAttr.append(this.nlindent2()).append("#Required");
                }
                if (attribute.isPrimaryKey()) {
                    bufferMetaAttr.append(this.nlindent2()).append("#PrimaryKey");
                    if (this.doGenerateFromTo) {
                        if (var17_79 == null) {
                            PojoAttribute pojoAttribute = attribute;
                        }
                        if (attribute.getDependencyPojo() != null) {
                            if (attribute.isDependencyClassNameIsEnum()) {
                                List enumAttrs = (List)this.enums.get(attribute.getDependencyPojo());
                                if (enumAttrs != null) {
                                    bufferMetaAttr.append("(value,").append(((EnumAttribute)enumAttrs.get(0)).getClassName()).append(")");
                                }
                            } else {
                                PojoAttribute depPkAttribute = this.getPrimaryKey(attribute.getDependencyPojo());
                                if (depPkAttribute != null) {
                                    bufferMetaAttr.append("(").append(this.columnToCamelCase(depPkAttribute.getDbName())).append(",").append(depPkAttribute.getClassName()).append(")");
                                }
                            }
                        } else if (attribute.isDependencyClassNameIsEnum()) {
                            bufferMetaAttr.append("(value,").append("").append(")");
                        } else {
                            bufferMetaAttr.append("()");
                        }
                    }
                    pkeys.add(name);
                }
                if (!this.generateMethods.contains("index") && attribute.getIndex() != null) {
                    bufferMetaAttr.append(this.nlindent2());
                    if (this.generateMethods.contains("enumIndex")) {
                        bufferMetaAttr.append("#EnumIndex");
                    } else {
                        bufferMetaAttr.append("#Index");
                    }
                }
                if (attribute.getDependencyClassName() != null) {
                    if (!attribute.isDependencyClassNameIsEnum()) {
                        bufferMetaAttr.append(this.nlindent2()).append("#IsPojo");
                    }
                    if ((this.preserveForeignKeys.contains(string) || this.preserveForeignKeys.contains("_ALL_")) && attribute.getPkTable() != null) {
                        linkedHashMap.put(name, (PojoAttribute)pentry.getValue());
                        bufferMetaAttr.append(this.nlindent2()).append("#UpdateCol(").append(this.columnToCamelCase(attribute.getPkColumn())).append(",").append(this.columnToCamelCase(attribute.getDbName())).append(")");
                    }
                }
                if (bufferMetaAttr.length() > 0 && bufferMetaAttr.charAt(0) == ' ') {
                    bufferPartial.append(NLINDENTINDENT).append(bufferMetaAttr.substring(1));
                } else {
                    bufferPartial.append((CharSequence)bufferMetaAttr);
                }
                this.printComment(bufferPartial, attribute.getComment(), INDENT, INDENT);
                bufferPartial.append(NLINDENT).append(INDENT).append("#Attr ");
                if (attribute.getDependencyClassName() != null) {
                    bufferPartial.append(attribute.getDependencyClassName());
                    if (attribute.isDependencyClassNameIsEnum()) {
                        linkedHashSet.add(name);
                    }
                    procId.add(name);
                } else if (attribute.isPrimitive()) {
                    bufferPartial.append(attribute.getClassName());
                    linkedHashSet.add(name);
                    procId.add(name);
                } else {
                    bufferPartial.append(attribute.getClassName());
                    if (!attribute.getClassName().startsWith("java.util.List")) {
                        linkedHashSet.add(name);
                        procId.add(name);
                    }
                }
                bufferPartial.append(' ').append(name);
                if (!this.debug.isDebug()) continue;
                bufferPartial.append(" // ").append(attribute.getCompleteSqlType());
            }
            if (var17_79 != null) {
                this.addColumnAnnotations(realPojoName, "onlyIds_", bufferPartial);
                bufferPartial.append(NLINDENT).append(INDENT).append("#Attr boolean onlyIds_");
                this.addColumnAnnotations(realPojoName, "ids_", bufferPartial);
                bufferPartial.append(NLINDENT).append(INDENT).append("#Attr java.util.List <").append(var17_79.getWrapperClassName()).append("> ids_");
            }
            for (Map.Entry pentry : linkedHashMap.entrySet()) {
                attribute = (PojoAttribute)pentry.getValue();
                bufferPartial.append(NLINDENT).append(INDENT).append("#CreateCol(").append((String)pentry.getKey()).append(",").append(this.columnToCamelCase(attribute.getPkColumn())).append(")");
                bufferPartial.append(NLINDENT).append(INDENT).append("#Attr ").append(attribute.getClassName()).append(' ').append(this.columnToCamelCase(attribute.getDbName()));
                linkedHashSet.add(this.columnToCamelCase(attribute.getDbName()));
            }
            if (this.generateMethods.contains("equals") && !pkeys.isEmpty()) {
                bufferMeta.append(this.nlindent()).append("#Equals(");
                this.appendList(bufferMeta, pkeys);
                bufferMeta.append(")");
            }
            if (this.generateMethods.contains("hashCode") && !pkeys.isEmpty()) {
                bufferMeta.append(this.nlindent()).append("#HashCode(");
                this.appendList(bufferMeta, pkeys);
                bufferMeta.append(")");
            }
            if (this.generateMethods.contains("toString") && !linkedHashSet.isEmpty()) {
                bufferMeta.append(this.nlindent()).append("#ToString(");
                this.appendList(bufferMeta, linkedHashSet);
                bufferMeta.append(")");
            }
            if (this.generateMethods.contains("procId") && !procId.isEmpty()) {
                bufferMeta.append(this.nlindent()).append("#ProcId(");
                this.appendList(bufferMeta, procId);
                bufferMeta.append(")");
            }
            if (bufferMeta.length() > 0 && bufferMeta.charAt(0) == ' ') {
                buffer.append(NLINDENT).append(bufferMeta.substring(1));
            } else {
                buffer.append((CharSequence)bufferMeta);
            }
            buffer.append((CharSequence)bufferPartial);
            if (this.finalEntitiesFeatures.containsKey(realPojoName)) {
                buffer.append("\n");
                for (Map.Entry<String, String> entry : this.finalEntitiesFeatures.get(realPojoName).entrySet()) {
                    buffer.append(Utils.getFinalContent(entry.getValue()));
                }
                buffer.append(INDENT).append("}\n");
                continue;
            }
            buffer.append(NLINDENT).append("}\n");
        }
        for (String string : this.procedures.keySet()) {
            String realPojoName;
            if (this.ignoreTables.contains(string) || this.pojosForProcedures.containsKey(string) || !TableBaseGenerator.Filter.isTable(this.activeFilter, string)) continue;
            pojoName = (String)this.tableNames.get(string);
            if (pojoName == null) {
                pojoName = string;
            }
            if (this.finalEntities.containsKey(realPojoName = this.tableToCamelCase(pojoName))) {
                buffer.append(Utils.getFinalContent(this.finalEntities.get(realPojoName)));
                continue;
            }
            if (this.entityAnnotations != null) {
                buffer.append((CharSequence)this.entityAnnotations.getEntityAnnotationsDefinitions(realPojoName, serializer, true, this.entityAnnotations.isNonStandardPojoAnnotations(realPojoName)));
                buffer.append((CharSequence)this.entityAnnotations.getConstructorAnnotationsDefinitions(realPojoName, serializer, true));
                buffer.append((CharSequence)this.entityAnnotations.getStaticAnnotationsDefinitions(realPojoName, serializer, true));
                buffer.append((CharSequence)this.entityAnnotations.getConflictAnnotationsDefinitions(realPojoName, serializer, true));
            }
            this.addPojoAnnotations(realPojoName, buffer);
            bufferMeta = new StringBuilder();
            if (isSerializable || serializables.contains(string)) {
                bufferMeta.append(this.nlindent()).append("#Serializable(1)");
            }
            toStr = new LinkedHashSet<String>();
            bufferPartial = new StringBuilder();
            this.printComment(bufferPartial, (String)this.comments.get(string), INDENT);
            bufferPartial.append(NLINDENT);
            if (this.makeItFinal) {
                bufferPartial.append("final ");
            }
            bufferPartial.append("#Pojo ");
            bufferPartial.append(realPojoName);
            if (this.pojoExtends.containsKey(string)) {
                bufferPartial.append(" extends ").append(this.tableToCamelCase((String)this.pojoExtends.get(string)));
            }
            bufferPartial.append(" {");
            for (Map.Entry entry : ((Map)this.procedures.get(string)).entrySet()) {
                void var17_86;
                String string5;
                if ("_result_".equals(entry.getKey()) || this.ignoreColumns.containsKey(string) && ((Set)this.ignoreColumns.get(string)).contains(entry.getKey())) continue;
                PojoAttribute pojoAttribute = (PojoAttribute)entry.getValue();
                String string6 = string5 = this.columnNames.containsKey(string) ? (String)((Map)this.columnNames.get(string)).get(entry.getKey()) : null;
                if (string5 == null) {
                    String string7 = pojoAttribute.getName();
                } else {
                    String string8 = this.columnToCamelCase(string5);
                }
                this.printComment(bufferPartial, pojoAttribute.getComment(), INDENT, INDENT);
                if (this.entityAnnotations != null) {
                    bufferPartial.append((CharSequence)this.entityAnnotations.getAttributeAnnotationsDefinitions(realPojoName, (String)var17_86, serializer, true, this.entityAnnotations.isNonStandardPojoAnnotations(realPojoName, (String)var17_86)));
                    bufferPartial.append((CharSequence)this.entityAnnotations.getGetterAnnotationsDefinitions(realPojoName, (String)var17_86, serializer, true));
                    bufferPartial.append((CharSequence)this.entityAnnotations.getSetterAnnotationsDefinitions(realPojoName, (String)var17_86, serializer, true));
                }
                if (this.doGenerateValidationAnnotations) {
                    if (!((!this.requiredColumns.containsKey(string) || !((Set)this.requiredColumns.get(string)).contains(entry.getKey())) && (!pojoAttribute.isRequired() || pojoAttribute.isPrimaryKey()) || this.notRequiredColumns.containsKey(string) && ((Set)this.notRequiredColumns.get(string)).contains(entry.getKey()) || this.entityAnnotations != null && this.entityAnnotations.hasAttributeAnnotationsDefinitions(realPojoName, (String)var17_86, "javax.validation.constraints.NotNull"))) {
                        bufferPartial.append(NLINDENT).append(INDENT).append("@NotNull");
                    }
                    if (!(pojoAttribute.getDependencyClassName() != null || pojoAttribute.isPrimitive() || !pojoAttribute.isString() || pojoAttribute.getSize() <= 0 || this.entityAnnotations != null && this.entityAnnotations.hasAttributeAnnotationsDefinitions(realPojoName, (String)var17_86, "javax.validation.constraints.Size"))) {
                        bufferPartial.append(NLINDENT).append(INDENT).append("@Size(max = ").append(pojoAttribute.getSize()).append(")");
                    }
                }
                this.addColumnAnnotations(realPojoName, (String)var17_86, bufferPartial);
                if (!pojoAttribute.isVersion() && (this.requiredColumns.containsKey(string) && ((Set)this.requiredColumns.get(string)).contains(entry.getKey()) || pojoAttribute.isRequired() && !pojoAttribute.isPrimaryKey()) && (!this.notRequiredColumns.containsKey(string) || !((Set)this.notRequiredColumns.get(string)).contains(entry.getKey()))) {
                    bufferPartial.append(this.nlindent2()).append("#Required");
                }
                bufferPartial.append(NLINDENT).append(INDENT).append("#Attr ");
                if (pojoAttribute.getDependencyClassName() != null) {
                    bufferPartial.append(pojoAttribute.getDependencyClassName());
                    toStr.add((String)var17_86);
                } else if (pojoAttribute.isPrimitive()) {
                    bufferPartial.append(pojoAttribute.getClassName());
                    toStr.add((String)var17_86);
                } else {
                    bufferPartial.append(pojoAttribute.getClassName());
                    if (!pojoAttribute.getClassName().startsWith("java.util.List")) {
                        toStr.add((String)var17_86);
                    }
                }
                bufferPartial.append(' ').append((String)var17_86);
                if (!this.debug.isDebug()) continue;
                bufferPartial.append(" // ").append(pojoAttribute.getCompleteSqlType());
            }
            if (this.generateMethods.contains("toString") && !toStr.isEmpty()) {
                bufferMeta.append(this.nlindent()).append("#ToString(");
                this.appendList(bufferMeta, toStr);
                bufferMeta.append(")");
            }
            if (bufferMeta.length() > 0 && bufferMeta.charAt(0) == ' ') {
                buffer.append(NLINDENT).append(bufferMeta.substring(1));
            } else {
                buffer.append((CharSequence)bufferMeta);
            }
            buffer.append((CharSequence)bufferPartial);
            if (this.finalEntitiesFeatures.containsKey(realPojoName)) {
                buffer.append("\n");
                for (Map.Entry<Object, Object> entry : this.finalEntitiesFeatures.get(realPojoName).entrySet()) {
                    buffer.append(Utils.getFinalContent((String)entry.getValue()));
                }
                buffer.append(INDENT).append("}\n");
                continue;
            }
            buffer.append(NLINDENT).append("}\n");
        }
        for (String string : this.functions.keySet()) {
            String realPojoName;
            if (this.ignoreTables.contains(string) || this.procedures.containsKey(string) || this.pojosForFunctions.containsKey(string) || !TableBaseGenerator.Filter.isTable(this.activeFilter, string)) continue;
            pojoName = (String)this.tableNames.get(string);
            if (pojoName == null) {
                pojoName = string;
            }
            if (this.finalEntities.containsKey(realPojoName = this.tableToCamelCase(pojoName))) {
                buffer.append(Utils.getFinalContent(this.finalEntities.get(realPojoName)));
                continue;
            }
            if (this.entityAnnotations != null) {
                buffer.append((CharSequence)this.entityAnnotations.getEntityAnnotationsDefinitions(realPojoName, serializer, true, this.entityAnnotations.isNonStandardPojoAnnotations(realPojoName)));
                buffer.append((CharSequence)this.entityAnnotations.getConstructorAnnotationsDefinitions(realPojoName, serializer, true));
                buffer.append((CharSequence)this.entityAnnotations.getStaticAnnotationsDefinitions(realPojoName, serializer, true));
                buffer.append((CharSequence)this.entityAnnotations.getConflictAnnotationsDefinitions(realPojoName, serializer, true));
            }
            this.addPojoAnnotations(realPojoName, buffer);
            bufferMeta = new StringBuilder();
            if (isSerializable || serializables.contains(string)) {
                bufferMeta.append(this.nlindent()).append("#Serializable(1)");
            }
            toStr = new LinkedHashSet();
            bufferPartial = new StringBuilder();
            this.printComment(bufferPartial, (String)this.comments.get(string), INDENT);
            bufferPartial.append(NLINDENT);
            if (this.makeItFinal) {
                bufferPartial.append("final ");
            }
            bufferPartial.append("#Pojo ");
            bufferPartial.append(realPojoName);
            if (this.pojoExtends.containsKey(string)) {
                bufferPartial.append(" extends ").append(this.tableToCamelCase((String)this.pojoExtends.get(string)));
            }
            bufferPartial.append(" {");
            for (Map.Entry entry : ((Map)this.functions.get(string)).entrySet()) {
                void var17_91;
                String string9;
                if ("_result_".equals(entry.getKey()) || this.ignoreColumns.containsKey(string) && ((Set)this.ignoreColumns.get(string)).contains(entry.getKey())) continue;
                PojoAttribute pojoAttribute = (PojoAttribute)entry.getValue();
                String string10 = string9 = this.columnNames.containsKey(string) ? (String)((Map)this.columnNames.get(string)).get(entry.getKey()) : null;
                if (string9 == null) {
                    String string11 = pojoAttribute.getName();
                } else {
                    String string12 = this.columnToCamelCase(string9);
                }
                this.printComment(bufferPartial, pojoAttribute.getComment(), INDENT, INDENT);
                if (this.entityAnnotations != null) {
                    bufferPartial.append((CharSequence)this.entityAnnotations.getAttributeAnnotationsDefinitions(realPojoName, (String)var17_91, serializer, true, this.entityAnnotations.isNonStandardPojoAnnotations(realPojoName, (String)var17_91)));
                    bufferPartial.append((CharSequence)this.entityAnnotations.getGetterAnnotationsDefinitions(realPojoName, (String)var17_91, serializer, true));
                    bufferPartial.append((CharSequence)this.entityAnnotations.getSetterAnnotationsDefinitions(realPojoName, (String)var17_91, serializer, true));
                }
                if (this.doGenerateValidationAnnotations) {
                    if (!((!this.requiredColumns.containsKey(string) || !((Set)this.requiredColumns.get(string)).contains(entry.getKey())) && (!pojoAttribute.isRequired() || pojoAttribute.isPrimaryKey()) || this.notRequiredColumns.containsKey(string) && ((Set)this.notRequiredColumns.get(string)).contains(entry.getKey()) || this.entityAnnotations != null && this.entityAnnotations.hasAttributeAnnotationsDefinitions(realPojoName, (String)var17_91, "javax.validation.constraints.NotNull"))) {
                        bufferPartial.append(NLINDENT).append(INDENT).append("@NotNull");
                    }
                    if (!(pojoAttribute.getDependencyClassName() != null || pojoAttribute.isPrimitive() || !pojoAttribute.isString() || pojoAttribute.getSize() <= 0 || this.entityAnnotations != null && this.entityAnnotations.hasAttributeAnnotationsDefinitions(realPojoName, (String)var17_91, "javax.validation.constraints.Size"))) {
                        bufferPartial.append(NLINDENT).append(INDENT).append("@Size(max = ").append(pojoAttribute.getSize()).append(")");
                    }
                }
                this.addColumnAnnotations(realPojoName, (String)var17_91, bufferPartial);
                if (!pojoAttribute.isVersion() && (this.requiredColumns.containsKey(string) && ((Set)this.requiredColumns.get(string)).contains(entry.getKey()) || pojoAttribute.isRequired() && !pojoAttribute.isPrimaryKey()) && (!this.notRequiredColumns.containsKey(string) || !((Set)this.notRequiredColumns.get(string)).contains(entry.getKey()))) {
                    bufferPartial.append(this.nlindent2()).append("#Required");
                }
                bufferPartial.append(NLINDENT).append(INDENT).append("#Attr ");
                if (pojoAttribute.getDependencyClassName() != null) {
                    bufferPartial.append(pojoAttribute.getDependencyClassName());
                    toStr.add((String)var17_91);
                } else if (pojoAttribute.isPrimitive()) {
                    bufferPartial.append(pojoAttribute.getClassName());
                    toStr.add((String)var17_91);
                } else {
                    bufferPartial.append(pojoAttribute.getClassName());
                    if (!pojoAttribute.getClassName().startsWith("java.util.List")) {
                        toStr.add((String)var17_91);
                    }
                }
                bufferPartial.append(' ').append((String)var17_91);
                if (!this.debug.isDebug()) continue;
                bufferPartial.append(" // ").append(pojoAttribute.getCompleteSqlType());
            }
            if (this.generateMethods.contains("toString") && !toStr.isEmpty()) {
                bufferMeta.append(this.nlindent()).append("#ToString(");
                this.appendList(bufferMeta, toStr);
                bufferMeta.append(")");
            }
            if (bufferMeta.length() > 0 && bufferMeta.charAt(0) == ' ') {
                buffer.append(NLINDENT).append(bufferMeta.substring(1));
            } else {
                buffer.append((CharSequence)bufferMeta);
            }
            buffer.append((CharSequence)bufferPartial);
            if (this.finalEntitiesFeatures.containsKey(realPojoName)) {
                buffer.append("\n");
                for (Map.Entry<Object, Object> entry : this.finalEntitiesFeatures.get(realPojoName).entrySet()) {
                    buffer.append(Utils.getFinalContent((String)entry.getValue()));
                }
                buffer.append(INDENT).append("}\n");
                continue;
            }
            buffer.append(NLINDENT).append("}\n");
        }
        return buffer.toString();
    }

    protected PojoAttribute getPrimaryKey(String pojo) {
        for (Map.Entry pentry : ((Map)this.pojos.get(pojo)).entrySet()) {
            PojoAttribute attr = (PojoAttribute)pentry.getValue();
            if (attr == null || !attr.isPrimaryKey()) continue;
            return attr;
        }
        return null;
    }

    protected void addPojoAnnotations(String pojoName, StringBuilder buffer) {
        if (this.pojoAnnotations == null) {
            return;
        }
        for (Map.Entry<String, Integer> e : this.pojoAnnotations.getAnnotations().entrySet()) {
            PojoDefinition annotation = (PojoDefinition)this.modelAnnotations.get(e.getKey());
            if (annotation == null) continue;
            boolean doit = false;
            if ((e.getValue() & 1) != 0 && this.doAddPojoAnnotations(this.pojoAnnotations, pojoName, e.getKey(), 1)) {
                buffer.append(NLINDENT).append("#Conflict");
                doit = true;
            }
            if ((e.getValue() & 4) != 0 && this.doAddPojoAnnotations(this.pojoAnnotations, pojoName, e.getKey(), 4)) {
                buffer.append(NLINDENT).append("#Constructor");
                doit = true;
            }
            if ((e.getValue() & 2) != 0 && this.doAddPojoAnnotations(this.pojoAnnotations, pojoName, e.getKey(), 2)) {
                buffer.append(NLINDENT).append("#Static");
                doit = true;
            }
            if ((e.getValue() & 8) != 0 && this.doAddPojoAnnotations(this.pojoAnnotations, pojoName, e.getKey(), 8)) {
                buffer.append(NLINDENT).append("#Standard");
                doit = true;
            }
            if (!doit) continue;
            buffer.append(NLINDENT).append("@").append(annotation.getQualifiedName());
        }
    }

    protected boolean doAddPojoAnnotations(PojoAnnotations pa, String pojoName, String name, Integer type) {
        boolean doit = false;
        if (pa.getDbTables(String.valueOf(name) + type) != null && !pa.getDbTables(String.valueOf(name) + type).isEmpty()) {
            if (pa.getDbTables(String.valueOf(name) + type).contains(pojoName)) {
                doit = true;
            }
        } else if (pa.getDbNotTables(String.valueOf(name) + type) != null && !pa.getDbNotTables(String.valueOf(name) + type).isEmpty()) {
            if (!pa.getDbNotTables(String.valueOf(name) + type).contains(pojoName)) {
                doit = true;
            }
        } else {
            doit = true;
        }
        return doit;
    }

    protected void addColumnAnnotations(String pojoName, String attrName, StringBuilder buffer) {
        ColumnAnnotations ca = (ColumnAnnotations)this.columnAnnotations.get(attrName);
        if (ca == null) {
            ca = (ColumnAnnotations)this.columnAnnotations2.get(attrName);
        }
        if (ca == null) {
            return;
        }
        for (Map.Entry<String, Integer> e : ca.getAnnotations().entrySet()) {
            PojoDefinition annotation = (PojoDefinition)this.modelAnnotations.get(e.getKey());
            if (annotation == null) continue;
            boolean doit = false;
            if ((e.getValue() & 4) != 0 && this.doAddColumnAnnotations(ca, pojoName, e.getKey(), 4)) {
                buffer.append(NLINDENT).append(INDENT).append("#Attribute");
                doit = true;
            }
            if ((e.getValue() & 1) != 0 && this.doAddColumnAnnotations(ca, pojoName, e.getKey(), 1)) {
                buffer.append(NLINDENT).append(INDENT).append("#Getter");
                doit = true;
            }
            if ((e.getValue() & 2) != 0 && this.doAddColumnAnnotations(ca, pojoName, e.getKey(), 2)) {
                buffer.append(NLINDENT).append(INDENT).append("#Setter");
                doit = true;
            }
            if (!doit) continue;
            buffer.append(NLINDENT).append(INDENT).append("@").append(annotation.getQualifiedName());
        }
    }

    protected boolean doAddColumnAnnotations(ColumnAnnotations ca, String pojoName, String name, Integer type) {
        boolean doit = false;
        if (ca.getDbTables(String.valueOf(name) + type) != null && !ca.getDbTables(String.valueOf(name) + type).isEmpty()) {
            if (ca.getDbTables(String.valueOf(name) + type).contains(pojoName)) {
                doit = true;
            }
        } else if (ca.getDbNotTables(String.valueOf(name) + type) != null && !ca.getDbNotTables(String.valueOf(name) + type).isEmpty()) {
            if (!ca.getDbNotTables(String.valueOf(name) + type).contains(pojoName)) {
                doit = true;
            }
        } else {
            doit = true;
        }
        return doit;
    }

    public static String generatePojo(Artifacts artifacts, Package packagex, ISerializer serializer, DbResolver dbResolver, IScopeProvider scopeProvider, ModelProperty modelProperty, Stats stats) {
        if (artifacts == null || !dbResolver.isResolveDb(artifacts)) {
            return null;
        }
        if (serializer == null) {
            serializer = ((XtextResource)packagex.eResource()).getSerializer();
        }
        Set<String> imports = packagex != null ? Utils.getImports(packagex, serializer) : null;
        HashMap<String, String> finalEntities = new HashMap<String, String>();
        HashMap<String, Map<String, String>> finalFeatures = new HashMap<String, Map<String, String>>();
        Annotations annotations = new Annotations(INDENT, NL);
        if (packagex != null) {
            for (AbstractEntity ape : packagex.getElements()) {
                Entity pojo;
                if (ape instanceof AnnotatedEntity && ((AnnotatedEntity)ape).getEntity() instanceof PojoEntity) {
                    pojo = (PojoEntity)((AnnotatedEntity)ape).getEntity();
                    Annotations.grabAnnotations((AnnotatedEntity)ape, annotations);
                    if (pojo.isFinal()) {
                        finalEntities.put(pojo.getName(), serializer.serialize((EObject)pojo));
                        continue;
                    }
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    finalFeatures.put(pojo.getName(), map);
                    for (AnnotatedFeature feature : pojo.getFeatures()) {
                        if (!feature.getFeature().isFinal()) continue;
                        map.put(feature.getFeature().getName(), serializer.serialize((EObject)feature));
                    }
                    continue;
                }
                if (!(ape instanceof AnnotatedEntity) || !(((AnnotatedEntity)ape).getEntity() instanceof EnumEntity)) continue;
                pojo = (EnumEntity)((AnnotatedEntity)ape).getEntity();
                Annotations.grabAnnotations((AnnotatedEntity)ape, annotations);
                if (pojo.isFinal()) {
                    finalEntities.put(pojo.getName(), serializer.serialize((EObject)pojo));
                    continue;
                }
                finalFeatures.put(pojo.getName(), new LinkedHashMap());
            }
        }
        List<String> dbSequences = dbResolver.getSequences(artifacts);
        DbResolver.DbType dbType = Utils.getDbType(dbResolver, artifacts);
        TablePojoGenerator generator = new TablePojoGenerator(modelProperty, artifacts, finalEntities, finalFeatures, annotations, imports, dbSequences, dbType);
        try {
            if (generator.addDefinitions(dbResolver, scopeProvider, stats)) {
                return generator.getPojoDefinitions(modelProperty, artifacts, serializer);
            }
        }
        catch (RuntimeException ex) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            ex.printStackTrace(printWriter);
            String s = ((Object)writer).toString();
            return s;
        }
        return null;
    }
}

