/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.meta.ui.templates;

import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.templates.SimpleTemplateVariableResolver;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContext;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContextType;
import org.sqlproc.meta.generator.TableMetaGenerator;
import org.sqlproc.meta.processorMeta.Artifacts;
import org.sqlproc.meta.processorMeta.MetaStatement;
import org.sqlproc.meta.util.Utils;
import org.sqlproc.plugin.lib.property.ModelProperty;
import org.sqlproc.plugin.lib.property.TableDefinition;
import org.sqlproc.plugin.lib.resolver.DbResolver;
import org.sqlproc.plugin.lib.resolver.PojoResolver;
import org.sqlproc.plugin.lib.util.CommonUtils;
import org.sqlproc.plugin.lib.util.Pair;
import org.sqlproc.plugin.lib.util.Stats;

public class ProcessorMetaTemplateContextType
extends XtextTemplateContextType {
    @Inject
    PojoResolver pojoResolver;
    @Inject
    DbResolver dbResolver;
    @Inject
    IScopeProvider scopeProvider;
    @Inject
    ModelProperty modelProperty;

    protected void addDefaultTemplateVariables() {
        super.addDefaultTemplateVariables();
        super.addResolver((TemplateVariableResolver)new DbTableResolver());
        super.addResolver((TemplateVariableResolver)new PojoColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbSelectColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbInsertColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbUpdateColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbCondColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbVerUpdateColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbOptUpdateColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbOptCondColumnResolver());
        super.addResolver((TemplateVariableResolver)new PojoDefinitionsResolver());
        super.addResolver((TemplateVariableResolver)new TablesDefinitionsResolver());
        super.addResolver((TemplateVariableResolver)new ProceduresDefinitionsResolver());
        super.addResolver((TemplateVariableResolver)new FunctionsDefinitionsResolver());
        super.addResolver((TemplateVariableResolver)new MetaGeneratorResolver());
    }

    protected Artifacts getArtifacts(XtextTemplateContext xtextTemplateContext) {
        if (xtextTemplateContext == null) {
            return null;
        }
        EObject object = xtextTemplateContext.getContentAssistContext().getCurrentModel();
        if (object == null) {
            return null;
        }
        return (Artifacts)EcoreUtil2.getContainerOfType((EObject)object, Artifacts.class);
    }

    protected MetaStatement getMetaStatement(XtextTemplateContext xtextTemplateContext) {
        if (xtextTemplateContext == null) {
            return null;
        }
        EObject object = xtextTemplateContext.getContentAssistContext().getCurrentModel();
        MetaStatement statement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)object, MetaStatement.class);
        return statement;
    }

    protected Pair<Artifacts, TableDefinition> getTableDefinition(MetaStatement statement) {
        if (statement == null) {
            return null;
        }
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)statement, Artifacts.class);
        List vals = Utils.getTokensFromModifier((MetaStatement)statement, (String)"tab");
        for (String val : vals) {
            TableDefinition tableDefinition = (TableDefinition)this.modelProperty.getModelTables((EObject)artifacts).get(val);
            if (tableDefinition == null) continue;
            return new Pair((Object)artifacts, (Object)tableDefinition);
        }
        return null;
    }

    protected String toCamelCase(String value) {
        if (value == null) {
            return null;
        }
        String[] parts = value.split("_");
        String camelCaseString = "";
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (camelCaseString.length() == 0) {
                camelCaseString = String.valueOf(camelCaseString) + part.toLowerCase();
            } else if (part.length() == 1) {
                camelCaseString = String.valueOf(camelCaseString) + part.toUpperCase();
            } else if (part.length() > 1) {
                camelCaseString = String.valueOf(camelCaseString) + part.substring(0, 1).toUpperCase() + part.substring(1).toLowerCase();
            }
            ++n2;
        }
        return camelCaseString;
    }

    protected String toCamelCase(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        String camelCaseString = clazz.getSimpleName();
        if (camelCaseString.length() == 1) {
            camelCaseString = camelCaseString.toLowerCase();
        } else if (camelCaseString.length() > 1) {
            camelCaseString = String.valueOf(camelCaseString.substring(0, 1).toLowerCase()) + camelCaseString.substring(1);
        }
        return camelCaseString;
    }

    protected String getPojoColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            builder.append(':').append(this.toCamelCase(columns.get(i)));
            if (i < columns.size() - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    protected String getSelectColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            builder.append("%" + columns.get(i)).append(" @").append(this.toCamelCase(columns.get(i)));
            if (i < columns.size() - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    protected String getInsertColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            builder.append("%" + columns.get(i));
            if (i < columns.size() - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    protected String getUpdateColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            builder.append("%" + columns.get(i)).append(" = :").append(this.toCamelCase(columns.get(i)));
            if (i < columns.size() - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    protected String getCondColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            builder.append("\n  {& ").append("%" + columns.get(i)).append(" = :").append(this.toCamelCase(columns.get(i))).append(" }");
            ++i;
        }
        return builder.toString();
    }

    protected String getVerUpdateColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            if (columns.get(i).toUpperCase().indexOf("VER") == 0) {
                builder.append("%" + columns.get(i)).append(" = :").append(this.toCamelCase(columns.get(i))).append(" + 1, ");
                break;
            }
            ++i;
        }
        return builder.toString();
    }

    protected String getOptUpdateColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        boolean idFind = false;
        boolean verFind = false;
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            if (!idFind && (columns.get(i).toUpperCase().equals("ID") || columns.get(i).toUpperCase().indexOf("ID_") == 0)) {
                idFind = true;
            } else if (!verFind && columns.get(i).toUpperCase().indexOf("VER") == 0) {
                verFind = true;
            } else {
                builder.append("%" + columns.get(i)).append(" = :").append(this.toCamelCase(columns.get(i)));
                if (i < columns.size() - 1) {
                    builder.append(", ");
                }
            }
            ++i;
        }
        return builder.toString();
    }

    protected String getOptCondColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        boolean idFind = false;
        boolean verFind = false;
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            if (!idFind && (columns.get(i).toUpperCase().equals("ID") || columns.get(i).toUpperCase().indexOf("ID_") == 0)) {
                idFind = true;
                builder.append("\n  {& ").append("%" + columns.get(i)).append(" = :").append(this.toCamelCase(columns.get(i))).append(" }");
            } else if (!verFind && columns.get(i).toUpperCase().indexOf("VER") == 0) {
                verFind = true;
                builder.append("\n  {& ").append("%" + columns.get(i)).append(" = :").append(this.toCamelCase(columns.get(i))).append(" }");
            }
            ++i;
        }
        return builder.toString();
    }

    public class DbCondColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbCondColumn";

        public DbCondColumnResolver() {
            super(NAME, "DbCondColumn");
        }

        protected String resolve(TemplateContext context) {
            Pair<Artifacts, TableDefinition> pair = ProcessorMetaTemplateContextType.this.getTableDefinition(ProcessorMetaTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (pair != null && ProcessorMetaTemplateContextType.this.dbResolver.isResolveDb((EObject)pair.getFirst())) {
                List dbColumns = ProcessorMetaTemplateContextType.this.dbResolver.getColumns((EObject)pair.getFirst(), ((TableDefinition)pair.getSecond()).getTable());
                return ProcessorMetaTemplateContextType.this.getCondColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbInsertColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbInsertColumn";

        public DbInsertColumnResolver() {
            super(NAME, "DbInsertColumn");
        }

        protected String resolve(TemplateContext context) {
            Pair<Artifacts, TableDefinition> pair = ProcessorMetaTemplateContextType.this.getTableDefinition(ProcessorMetaTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (pair != null && ProcessorMetaTemplateContextType.this.dbResolver.isResolveDb((EObject)pair.getFirst())) {
                List dbColumns = ProcessorMetaTemplateContextType.this.dbResolver.getColumns((EObject)pair.getFirst(), ((TableDefinition)pair.getSecond()).getTable());
                return ProcessorMetaTemplateContextType.this.getInsertColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbOptCondColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbOptCondColumn";

        public DbOptCondColumnResolver() {
            super(NAME, "DbOptCondColumn");
        }

        protected String resolve(TemplateContext context) {
            Pair<Artifacts, TableDefinition> pair = ProcessorMetaTemplateContextType.this.getTableDefinition(ProcessorMetaTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (pair != null && ProcessorMetaTemplateContextType.this.dbResolver.isResolveDb((EObject)pair.getFirst())) {
                List dbColumns = ProcessorMetaTemplateContextType.this.dbResolver.getColumns((EObject)pair.getFirst(), ((TableDefinition)pair.getSecond()).getTable());
                return ProcessorMetaTemplateContextType.this.getOptCondColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbOptUpdateColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbOptUpdateColumn";

        public DbOptUpdateColumnResolver() {
            super(NAME, "DbOptUpdateColumn");
        }

        protected String resolve(TemplateContext context) {
            Pair<Artifacts, TableDefinition> pair = ProcessorMetaTemplateContextType.this.getTableDefinition(ProcessorMetaTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (pair != null && ProcessorMetaTemplateContextType.this.dbResolver.isResolveDb((EObject)pair.getFirst())) {
                List dbColumns = ProcessorMetaTemplateContextType.this.dbResolver.getColumns((EObject)pair.getFirst(), ((TableDefinition)pair.getSecond()).getTable());
                return ProcessorMetaTemplateContextType.this.getOptUpdateColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbSelectColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbSelectColumn";

        public DbSelectColumnResolver() {
            super(NAME, "DbSelectColumn");
        }

        protected String resolve(TemplateContext context) {
            Pair<Artifacts, TableDefinition> pair = ProcessorMetaTemplateContextType.this.getTableDefinition(ProcessorMetaTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (pair != null && ProcessorMetaTemplateContextType.this.dbResolver.isResolveDb((EObject)pair.getFirst())) {
                List dbColumns = ProcessorMetaTemplateContextType.this.dbResolver.getColumns((EObject)pair.getFirst(), ((TableDefinition)pair.getSecond()).getTable());
                return ProcessorMetaTemplateContextType.this.getSelectColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbTableResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbTable";

        public DbTableResolver() {
            super(NAME, "DbTable");
        }

        protected String resolve(TemplateContext context) {
            Pair<Artifacts, TableDefinition> pair = ProcessorMetaTemplateContextType.this.getTableDefinition(ProcessorMetaTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (pair != null && ProcessorMetaTemplateContextType.this.dbResolver.isResolveDb((EObject)pair.getFirst())) {
                return "%%" + ((TableDefinition)pair.getSecond()).getTable();
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbUpdateColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbUpdateColumn";

        public DbUpdateColumnResolver() {
            super(NAME, "DbUpdateColumn");
        }

        protected String resolve(TemplateContext context) {
            Pair<Artifacts, TableDefinition> pair = ProcessorMetaTemplateContextType.this.getTableDefinition(ProcessorMetaTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (pair != null && ProcessorMetaTemplateContextType.this.dbResolver.isResolveDb((EObject)pair.getFirst())) {
                List dbColumns = ProcessorMetaTemplateContextType.this.dbResolver.getColumns((EObject)pair.getFirst(), ((TableDefinition)pair.getSecond()).getTable());
                return ProcessorMetaTemplateContextType.this.getUpdateColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbVerUpdateColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbVerUpdateColumn";

        public DbVerUpdateColumnResolver() {
            super(NAME, "DbVerUpdateColumn");
        }

        protected String resolve(TemplateContext context) {
            Pair<Artifacts, TableDefinition> pair = ProcessorMetaTemplateContextType.this.getTableDefinition(ProcessorMetaTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (pair != null && ProcessorMetaTemplateContextType.this.dbResolver.isResolveDb((EObject)pair.getFirst())) {
                List dbColumns = ProcessorMetaTemplateContextType.this.dbResolver.getColumns((EObject)pair.getFirst(), ((TableDefinition)pair.getSecond()).getTable());
                return ProcessorMetaTemplateContextType.this.getVerUpdateColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class FunctionsDefinitionsResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "functionDefinitions";

        public FunctionsDefinitionsResolver() {
            super(NAME, "FunctionDefinitions");
        }

        protected String resolve(TemplateContext context) {
            Artifacts artifacts = ProcessorMetaTemplateContextType.this.getArtifacts((XtextTemplateContext)context);
            if (artifacts != null && ProcessorMetaTemplateContextType.this.dbResolver.isResolveDb((EObject)artifacts)) {
                Map functionsPresented = ProcessorMetaTemplateContextType.this.modelProperty.getModelFunctions((EObject)artifacts);
                List functions = ProcessorMetaTemplateContextType.this.dbResolver.getFunctions((EObject)artifacts);
                return CommonUtils.getFunctionsDefinitions((List)functions, (Map)functionsPresented);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class MetaGeneratorResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "metaGenerator";

        public MetaGeneratorResolver() {
            super(NAME, "MetaGenerator");
        }

        protected String resolve(TemplateContext context) {
            Artifacts artifacts = ProcessorMetaTemplateContextType.this.getArtifacts((XtextTemplateContext)context);
            Stats stats = new Stats();
            String metas = TableMetaGenerator.generateMeta((Artifacts)artifacts, (List)artifacts.getStatements(), null, (DbResolver)ProcessorMetaTemplateContextType.this.dbResolver, (IScopeProvider)ProcessorMetaTemplateContextType.this.scopeProvider, (ModelProperty)ProcessorMetaTemplateContextType.this.modelProperty, (Stats)stats);
            if (metas != null) {
                return String.valueOf(metas) + stats.toString();
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class PojoColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "pojoColumn";

        public PojoColumnResolver() {
            super(NAME, "PojoColumn");
        }

        protected String resolve(TemplateContext context) {
            Pair<Artifacts, TableDefinition> pair = ProcessorMetaTemplateContextType.this.getTableDefinition(ProcessorMetaTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (pair != null && ProcessorMetaTemplateContextType.this.dbResolver.isResolveDb((EObject)pair.getFirst())) {
                List dbColumns = ProcessorMetaTemplateContextType.this.dbResolver.getColumns((EObject)pair.getFirst(), ((TableDefinition)pair.getSecond()).getTable());
                return ProcessorMetaTemplateContextType.this.getPojoColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class PojoDefinitionsResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "pojoDefinitions";

        public PojoDefinitionsResolver() {
            super(NAME, "PojoDefinitions");
        }

        protected String resolve(TemplateContext context) {
            Artifacts artifacts = ProcessorMetaTemplateContextType.this.getArtifacts((XtextTemplateContext)context);
            if (artifacts != null && ProcessorMetaTemplateContextType.this.modelProperty.isDoResolvePojo((EObject)artifacts)) {
                URI uri = artifacts.eResource() != null ? artifacts.eResource().getURI() : null;
                List pojoClasses = ProcessorMetaTemplateContextType.this.pojoResolver.getPojoClasses(uri);
                return CommonUtils.getPojoDefinitions((List)pojoClasses);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class ProceduresDefinitionsResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "procedureDefinitions";

        public ProceduresDefinitionsResolver() {
            super(NAME, "ProcedureDefinitions");
        }

        protected String resolve(TemplateContext context) {
            Artifacts artifacts = ProcessorMetaTemplateContextType.this.getArtifacts((XtextTemplateContext)context);
            if (artifacts != null && ProcessorMetaTemplateContextType.this.dbResolver.isResolveDb((EObject)artifacts)) {
                Map proceduresPresented = ProcessorMetaTemplateContextType.this.modelProperty.getModelProcedures((EObject)artifacts);
                List procedures = ProcessorMetaTemplateContextType.this.dbResolver.getProcedures((EObject)artifacts);
                return CommonUtils.getProceduresDefinitions((List)procedures, (Map)proceduresPresented);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class TablesDefinitionsResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "tableDefinitions";

        public TablesDefinitionsResolver() {
            super(NAME, "TableDefinitions");
        }

        protected String resolve(TemplateContext context) {
            Artifacts artifacts = ProcessorMetaTemplateContextType.this.getArtifacts((XtextTemplateContext)context);
            if (artifacts != null && ProcessorMetaTemplateContextType.this.dbResolver.isResolveDb((EObject)artifacts)) {
                Map tablesPresented = ProcessorMetaTemplateContextType.this.modelProperty.getModelTables((EObject)artifacts);
                List tables = ProcessorMetaTemplateContextType.this.dbResolver.getTables((EObject)artifacts);
                return CommonUtils.getTablesDefinitions((List)tables, (Map)tablesPresented);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }
}

