/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.meta.ui.syntaxcoloring;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ide.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.nodemodel.util.NodeTreeIterator;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.sqlproc.meta.processorMeta.Constant;
import org.sqlproc.meta.processorMeta.DatabaseColumn;
import org.sqlproc.meta.processorMeta.DatabaseTable;
import org.sqlproc.meta.processorMeta.ExtendedColumn;
import org.sqlproc.meta.processorMeta.ExtendedMappingItem;
import org.sqlproc.meta.processorMeta.FunctionDefinitionModel;
import org.sqlproc.meta.processorMeta.Identifier;
import org.sqlproc.meta.processorMeta.MappingItem;
import org.sqlproc.meta.processorMeta.MappingRule;
import org.sqlproc.meta.processorMeta.MetaStatement;
import org.sqlproc.meta.processorMeta.OptionalFeature;
import org.sqlproc.meta.processorMeta.PojoDefinitionModel;
import org.sqlproc.meta.processorMeta.ProcedureDefinitionModel;
import org.sqlproc.meta.processorMeta.TableDefinitionModel;
import org.sqlproc.plugin.lib.resolver.PojoResolver;
import org.sqlproc.plugin.lib.resolver.PojoResolverFactory;

public class SemanticHighlightingCalculator
implements ISemanticHighlightingCalculator {
    @Inject
    PojoResolver pojoResolver;
    @Inject
    PojoResolverFactory pojoResolverFactory;

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        if (this.pojoResolverFactory != null && this.pojoResolverFactory.getPojoResolver() == null) {
            this.pojoResolverFactory.setPojoResolver(this.pojoResolver);
        }
        if (resource == null) {
            return;
        }
        TreeIterator iter = EcoreUtil.getAllContents((Resource)resource, (boolean)true);
        while (iter.hasNext()) {
            EObject current = (EObject)iter.next();
            ICompositeNode node = NodeModelUtils.getNode((EObject)current);
            if (current instanceof MetaStatement) {
                MetaStatement statement = (MetaStatement)current;
                if (statement.getName() == null) continue;
                acceptor.addPosition(node.getOffset(), statement.getName().length(), new String[]{"name"});
                this.provideHighlightingForModifiers((EList<String>)statement.getModifiers(), node, acceptor);
                continue;
            }
            if (current instanceof MappingRule) {
                MappingRule rule = (MappingRule)current;
                if (rule.getName() == null) continue;
                acceptor.addPosition(node.getOffset(), rule.getName().length(), new String[]{"name"});
                this.provideHighlightingForModifiers((EList<String>)rule.getModifiers(), node, acceptor);
                continue;
            }
            if (current instanceof OptionalFeature) {
                OptionalFeature feature = (OptionalFeature)current;
                if (feature.getName() == null) continue;
                acceptor.addPosition(node.getOffset(), feature.getName().length(), new String[]{"name"});
                this.provideHighlightingForModifiers((EList<String>)feature.getModifiers(), node, acceptor);
                continue;
            }
            if (current instanceof Constant) {
                Constant constant = (Constant)current;
                this.provideHighlightingForFragment("constant", node, constant.getName(), (EList<String>)constant.getModifiers(), acceptor);
                continue;
            }
            if (current instanceof Identifier) {
                Identifier identifier = (Identifier)current;
                this.provideHighlightingForFragment("identifier", node, identifier.getName(), (EList<String>)identifier.getModifiers(), acceptor);
                continue;
            }
            if (current instanceof ExtendedColumn) {
                ExtendedColumn column = (ExtendedColumn)current;
                this.provideHighlightingForFragment("column", node, column.getCol().getName(), (EList<String>)column.getModifiers(), acceptor);
                continue;
            }
            if (current instanceof MappingItem) {
                MappingItem item = (MappingItem)current;
                if (item.getName() == null) continue;
                acceptor.addPosition(node.getOffset(), item.getName().length(), new String[]{"column"});
                continue;
            }
            if (current instanceof ExtendedMappingItem) {
                ExtendedMappingItem mappingItem = (ExtendedMappingItem)current;
                this.provideHighlightingForFragment("column", node, mappingItem.getAttr().getName(), (EList<String>)mappingItem.getModifiers(), acceptor);
                continue;
            }
            if (current instanceof DatabaseColumn) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"dbcolumn"});
                continue;
            }
            if (current instanceof DatabaseTable) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"dbtable"});
                continue;
            }
            if (current instanceof PojoDefinitionModel) {
                PojoDefinitionModel pojo = (PojoDefinitionModel)current;
                this.provideHighlightingForPojo(null, pojo.getName(), node, acceptor);
                continue;
            }
            if (current instanceof TableDefinitionModel) {
                TableDefinitionModel table = (TableDefinitionModel)current;
                this.provideHighlightingForTable(null, table.getName(), node, acceptor);
                continue;
            }
            if (current instanceof ProcedureDefinitionModel) {
                ProcedureDefinitionModel procedure = (ProcedureDefinitionModel)current;
                this.provideHighlightingForTable(null, procedure.getName(), node, acceptor);
                continue;
            }
            if (!(current instanceof FunctionDefinitionModel)) continue;
            FunctionDefinitionModel function = (FunctionDefinitionModel)current;
            this.provideHighlightingForTable(null, function.getName(), node, acceptor);
        }
    }

    private void provideHighlightingForModifiers(EList<String> filters, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (filters != null && !filters.isEmpty()) {
            NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
            while (iterator.hasNext()) {
                INode inode = (INode)iterator.next();
                if (!filters.contains((Object)inode.getText())) continue;
                acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"statementModifier"});
            }
        }
    }

    private void provideHighlightingForPojo(String name, String pojo, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (name == null && pojo == null) {
            return;
        }
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (this.equals(name, inode)) {
                acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"name"});
                if (pojo == null) {
                    return;
                }
            }
            if (!this.equals(pojo, inode)) continue;
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"identifier"});
            return;
        }
    }

    private void provideHighlightingForTable(String name, String table, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (name == null && table == null) {
            return;
        }
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (this.equals(name, inode)) {
                acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"name"});
                if (table == null) {
                    return;
                }
            }
            if (!this.equals(table, inode)) continue;
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"identifier"});
            return;
        }
    }

    private void provideHighlightingForFragment(String defaultColor, ICompositeNode node, String name, EList<String> modifiers, IHighlightedPositionAcceptor acceptor) {
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        boolean afterName = false;
        boolean inParenthesis = false;
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (!afterName) {
                if (!this.equals(name, inode)) continue;
                acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{defaultColor});
                afterName = true;
                continue;
            }
            if (!inParenthesis && inode.getText().equals("(")) {
                inParenthesis = true;
                continue;
            }
            if (inParenthesis && inode.getText().equals(")")) {
                inParenthesis = false;
                continue;
            }
            if (inParenthesis) {
                if (modifiers == null || modifiers.isEmpty() || !modifiers.contains((Object)inode.getText())) continue;
                acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"modifier"});
                continue;
            }
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{defaultColor});
        }
    }

    private boolean equals(String name, INode inode) {
        if (name == null || inode == null) {
            return false;
        }
        String text = inode.getText();
        if (text == null) {
            return false;
        }
        return name.equals(text.trim());
    }
}

