/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.meta.ui.contentassist;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.beans.PropertyDescriptor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.sqlproc.meta.processorMeta.Artifacts;
import org.sqlproc.meta.processorMeta.Column;
import org.sqlproc.meta.processorMeta.DatabaseProperty;
import org.sqlproc.meta.processorMeta.DriverMethodOutputAssignement;
import org.sqlproc.meta.processorMeta.ExportAssignement;
import org.sqlproc.meta.processorMeta.ExtendedColumn;
import org.sqlproc.meta.processorMeta.ExtendedMappingItem;
import org.sqlproc.meta.processorMeta.ImportAssignement;
import org.sqlproc.meta.processorMeta.InheritanceAssignement;
import org.sqlproc.meta.processorMeta.ManyToManyAssignement;
import org.sqlproc.meta.processorMeta.MappingColumn;
import org.sqlproc.meta.processorMeta.MappingRule;
import org.sqlproc.meta.processorMeta.MetaStatement;
import org.sqlproc.meta.processorMeta.MetagenProperty;
import org.sqlproc.meta.processorMeta.PojoDefinitionModel;
import org.sqlproc.meta.processorMeta.PojogenProperty;
import org.sqlproc.meta.processorMeta.ProcessorMetaPackage;
import org.sqlproc.meta.processorMeta.ShowColumnTypeAssignement;
import org.sqlproc.meta.processorMeta.TableDefinitionModel;
import org.sqlproc.meta.ui.contentassist.AbstractProcessorMetaProposalProvider;
import org.sqlproc.meta.util.Utils;
import org.sqlproc.plugin.lib.property.ModelProperty;
import org.sqlproc.plugin.lib.property.PojoDefinition;
import org.sqlproc.plugin.lib.property.TableDefinition;
import org.sqlproc.plugin.lib.resolver.DbExport;
import org.sqlproc.plugin.lib.resolver.DbImport;
import org.sqlproc.plugin.lib.resolver.DbResolver;
import org.sqlproc.plugin.lib.resolver.PojoResolver;

public class ProcessorMetaProposalProvider
extends AbstractProcessorMetaProposalProvider {
    @Inject
    private PojoResolver pojoResolver;
    @Inject
    private DbResolver dbResolver;
    @Inject
    private ModelProperty modelProperty;
    private final ArrayList<String> STATEMENT_TYPE = CollectionLiterals.newArrayList((Object[])new String[]{"QRY", "CRUD", "CALL"});
    private final ArrayList<String> MAPPING_TYPE = CollectionLiterals.newArrayList((Object[])new String[]{"OUT"});
    private final ArrayList<String> OPTION_TYPE = CollectionLiterals.newArrayList((Object[])new String[]{"OPT", "LOPT", "IOPT", "SOPT", "BOPT", "MOPT"});
    private final ArrayList<String> TYPES = CollectionLiterals.newArrayList((Object[])new String[]{"int", "integer", "long", "byte", "short", "float", "double", "character", "char", "string", "str", "time", "date", "datetime", "timestamp", "stamp", "bool", "boolean", "bigint", "biginteger", "bigdec", "bigdecimal", "bytearr", "bytearray", "bytes", "text", "blob", "clob", "einteger", "eint", "enumstring", "estring", "fromdate", "todate", "cursor", "other"});
    private final ArrayList<String> MODIFIERS = CollectionLiterals.newArrayList((Object[])new String[]{"any", "null", "notnull", "seq", "seq=", "idsel", "idsel=", "id", "isDef=", "isCall=", "dtype=", "gtype=", "discr"});
    private final ArrayList<String> F_TYPES = CollectionLiterals.newArrayList((Object[])new String[]{"set", "update", "values", "where"});
    private final ArrayList<String> DEBUG_LEVELS = CollectionLiterals.newArrayList((Object[])new String[]{"DEBUG", "INFO", "FATAL", "ERROR", "WARN", "TRACE"});
    private final ArrayList<String> methods = CollectionLiterals.newArrayList((Object[])new String[]{"toString", "hashCode", "equals", "isDef", "toInit", "enumDef", "enumInit", "index", "procId", "enumIndex"});

    @Override
    public void completeMetaStatement_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(this.STATEMENT_TYPE, "STATEMENT_TYPE", context, acceptor, null);
    }

    @Override
    public void completeMappingRule_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(this.MAPPING_TYPE, "MAPPING_TYPE", context, acceptor, null);
    }

    @Override
    public void completeOptionalFeature_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(this.OPTION_TYPE, "OPTION_TYPE", context, acceptor, null);
    }

    public void addProposalList(List<String> values, final String lexerRule, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor, final String prefix) {
        if (values != null) {
            Consumer<String> _function = new Consumer<String>(){

                @Override
                public void accept(String value) {
                    IValueConverterService _valueConverter = ProcessorMetaProposalProvider.this.getValueConverter();
                    String _elvis = null;
                    _elvis = prefix != null ? prefix : "";
                    String _plus = String.valueOf(_elvis) + value;
                    String proposal = _valueConverter.toString((Object)_plus, lexerRule);
                    acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(proposal, context));
                }
            };
            values.forEach(_function);
        }
    }

    @Override
    public void completeMetaSql_Ftype(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(this.F_TYPES, "IDENT", context, acceptor, null);
    }

    @Override
    public void completeExtendedColumnName_Name(EObject model, Assignment assignment, final ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String prefix;
        boolean _completeUsage;
        boolean _not;
        Column column = (Column)EcoreUtil2.getContainerOfType((EObject)model, Column.class);
        final StringBuilder partialName = new StringBuilder("");
        EList _columns = null;
        if (column != null) {
            _columns = column.getColumns();
        }
        if (_columns != null) {
            Functions.Function1<ExtendedColumn, Boolean> _function = new Functions.Function1<ExtendedColumn, Boolean>(){

                public Boolean apply(ExtendedColumn it) {
                    boolean _xblockexpression = false;
                    ProcessorMetaProposalProvider.this.append(partialName, it.getCol().getName());
                    _xblockexpression = !Objects.equal((Object)context.getPreviousModel(), null) && it == context.getPreviousModel();
                    return _xblockexpression;
                }
            };
            IterableExtensions.findFirst((Iterable)_columns, (Functions.Function1)_function);
        }
        boolean bl = _not = !(_completeUsage = this.completeUsage(model, assignment, context, acceptor, "out", "out", prefix = this.append(partialName, context.getPrefix()).toString(), true));
        if (_not) {
            super.completeExtendedColumnName_Name(model, assignment, context, acceptor);
        }
    }

    @Override
    public void completeConstant_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _completeUsage = this.completeUsage(model, assignment, context, acceptor, "const", "const", context.getPrefix(), false);
        boolean bl = _not = !_completeUsage;
        if (_not) {
            super.completeConstant_Name(model, assignment, context, acceptor);
        }
    }

    @Override
    public void completeIdentifier_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _completeUsage = this.completeUsage(model, assignment, context, acceptor, "in", "in", context.getPrefix(), false);
        boolean bl = _not = !_completeUsage;
        if (_not) {
            super.completeIdentifier_Name(model, assignment, context, acceptor);
        }
    }

    public boolean completeUsage(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor, String usageInFilter, String usageInFilterExt, String _prefix, final boolean cutPrefix) {
        boolean newPojoValidator;
        PojoDefinition pojoDefinition;
        boolean _equals;
        boolean _notEquals;
        boolean _not;
        boolean _isResolvePojo = this.isResolvePojo(model);
        boolean bl = _not = !_isResolvePojo;
        if (_not) {
            return false;
        }
        MetaStatement metaStatement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)model, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)model, Artifacts.class);
        String pojoName = Utils.getTokenFromModifier((MetaStatement)metaStatement, (String)usageInFilter);
        PojoDefinition _xifexpression = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)pojoName, null);
        if (_notEquals) {
            _xifexpression = (PojoDefinition)this.modelProperty.getModelPojos((EObject)artifacts).get(pojoName);
        }
        if (_equals = Objects.equal(pojoDefinition = _xifexpression, null)) {
            String proposal = this.getValueConverter().toString((Object)("Error: I can't load pojo for " + model), "IDENT");
            acceptor.accept(this.createCompletionProposal(proposal, context));
            return true;
        }
        int pos = _prefix.lastIndexOf(".");
        String _xifexpression_1 = null;
        _xifexpression_1 = pos > 0 ? _prefix.substring(0, pos + 1) : "";
        final String prefix = _xifexpression_1;
        boolean _isOldPojoValidator = this.modelProperty.isOldPojoValidator(model);
        boolean bl3 = newPojoValidator = !_isOldPojoValidator;
        if (newPojoValidator && pojoDefinition.getClassx() instanceof JvmDeclaredType) {
            JvmType _classx = pojoDefinition.getClassx();
            JvmDeclaredType type = (JvmDeclaredType)_classx;
            Consumer<JvmFeature> _function = new Consumer<JvmFeature>(){

                @Override
                public void accept(JvmFeature feature) {
                    String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)feature.getSimpleName(), "IDENT");
                    InputOutput.println((Object)proposal);
                    acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(String.valueOf(prefix) + proposal, context));
                }
            };
            this.getAllFeatures(type, _prefix).forEach(_function);
        } else {
            Resource _eResource = model.eResource();
            URI _uRI = null;
            if (_eResource != null) {
                _uRI = _eResource.getURI();
            }
            URI uri = _uRI;
            String clazz = this.getClassName(pojoDefinition.getQualifiedName(), prefix, uri);
            boolean _equals_1 = Objects.equal((Object)clazz, null);
            if (_equals_1) {
                return false;
            }
            PropertyDescriptor[] descriptors = this.pojoResolver.getPropertyDescriptors(clazz, uri);
            boolean _equals_2 = Objects.equal((Object)descriptors, null);
            if (_equals_2) {
                return false;
            }
            Functions.Function1<PropertyDescriptor, Boolean> _function_1 = new Functions.Function1<PropertyDescriptor, Boolean>(){

                public Boolean apply(PropertyDescriptor it) {
                    String _name = it.getName();
                    return !Objects.equal((Object)"class", (Object)_name);
                }
            };
            Consumer<PropertyDescriptor> _function_2 = new Consumer<PropertyDescriptor>(){

                @Override
                public void accept(PropertyDescriptor descriptor) {
                    String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)descriptor.getName(), "IDENT");
                    String _xifexpression = null;
                    _xifexpression = cutPrefix ? proposal : String.valueOf(prefix) + proposal;
                    acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(_xifexpression, context));
                }
            };
            IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)descriptors)), (Functions.Function1)_function_1).forEach(_function_2);
        }
        return true;
    }

    public Iterable<JvmFeature> getAllFeatures(JvmDeclaredType _type, String _prefix) {
        JvmTypeReference _type_2;
        JvmType jvmType;
        JvmFeature _head;
        JvmField field;
        JvmTypeReference _type_1;
        Iterable features;
        Iterable _xblockexpression = null;
        JvmDeclaredType type = _type;
        int pos = _prefix.lastIndexOf(".");
        if (pos > 0 && !Objects.equal((Object)(features = type.findAllFeaturesByName(_prefix.substring(0, pos))), null) && !IterableExtensions.isEmpty((Iterable)features) && IterableExtensions.head((Iterable)features) instanceof JvmField && (_type_1 = (field = (JvmField)(_head = (JvmFeature)IterableExtensions.head((Iterable)features))).getType()) instanceof JvmParameterizedTypeReference && (jvmType = ((JvmParameterizedTypeReference)(_type_2 = field.getType())).getType()) instanceof JvmDeclaredType) {
            type = (JvmDeclaredType)jvmType;
        }
        Functions.Function1<JvmFeature, Boolean> _function = new Functions.Function1<JvmFeature, Boolean>(){

            public Boolean apply(JvmFeature it) {
                return it instanceof JvmField;
            }
        };
        Functions.Function1<JvmFeature, Boolean> _function_1 = new Functions.Function1<JvmFeature, Boolean>(){

            public Boolean apply(JvmFeature it) {
                boolean _isStatic = it.isStatic();
                return !_isStatic;
            }
        };
        Functions.Function1<JvmFeature, Boolean> _function_2 = new Functions.Function1<JvmFeature, Boolean>(){

            public Boolean apply(JvmFeature it) {
                boolean _startsWith = it.getSimpleName().startsWith("_");
                return !_startsWith;
            }
        };
        _xblockexpression = IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)type.getAllFeatures(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        return _xblockexpression;
    }

    @Override
    public void completeMappingColumnName_Name(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        boolean newPojoValidator;
        PojoDefinition pojoDefinition;
        boolean _equals;
        boolean _notEquals;
        boolean _not;
        boolean _isResolvePojo = this.isResolvePojo(model);
        boolean bl = _not = !_isResolvePojo;
        if (_not) {
            super.completeMappingColumnName_Name(model, assignment, context, acceptor);
            return;
        }
        MappingColumn mappingColumn = (MappingColumn)EcoreUtil2.getContainerOfType((EObject)model, MappingColumn.class);
        MappingRule mappingRule = (MappingRule)EcoreUtil2.getContainerOfType((EObject)model, MappingRule.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)model, Artifacts.class);
        String pojoName = Utils.getTokenFromModifier((MappingRule)mappingRule, (String)"out");
        PojoDefinition _xifexpression = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)pojoName, null);
        if (_notEquals) {
            _xifexpression = (PojoDefinition)this.modelProperty.getModelPojos((EObject)artifacts).get(pojoName);
        }
        if (_equals = Objects.equal(pojoDefinition = _xifexpression, null)) {
            String proposal = this.getValueConverter().toString((Object)("Error: I can't load pojo for " + model), "IDENT");
            acceptor.accept(this.createCompletionProposal(proposal, context));
        }
        final StringBuilder partialName = new StringBuilder("");
        boolean cutPrefix = false;
        if (model instanceof MappingColumn && !Objects.equal((Object)mappingColumn, null)) {
            cutPrefix = true;
            Functions.Function1<ExtendedMappingItem, Boolean> _function = new Functions.Function1<ExtendedMappingItem, Boolean>(){

                public Boolean apply(ExtendedMappingItem it) {
                    boolean _xblockexpression = false;
                    ProcessorMetaProposalProvider.this.append(partialName, it.getAttr().getName());
                    _xblockexpression = !Objects.equal((Object)context.getPreviousModel(), null) && it == context.getPreviousModel();
                    return _xblockexpression;
                }
            };
            IterableExtensions.findFirst((Iterable)mappingColumn.getItems(), (Functions.Function1)_function);
        }
        String prefix = this.append(partialName, context.getPrefix()).toString();
        int pos = prefix.lastIndexOf(".");
        String _xifexpression_1 = null;
        _xifexpression_1 = pos > 0 ? prefix.substring(0, pos + 1) : "";
        final String _prefix = _xifexpression_1;
        final boolean _cutPrefix = cutPrefix;
        boolean _isOldPojoValidator = this.modelProperty.isOldPojoValidator(model);
        boolean bl3 = newPojoValidator = !_isOldPojoValidator;
        if (newPojoValidator && pojoDefinition.getClassx() instanceof JvmDeclaredType) {
            JvmType _classx = pojoDefinition.getClassx();
            JvmDeclaredType type = (JvmDeclaredType)_classx;
            Consumer<JvmFeature> _function_1 = new Consumer<JvmFeature>(){

                @Override
                public void accept(JvmFeature feature) {
                    String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)feature.getSimpleName(), "IDENT");
                    InputOutput.println((Object)proposal);
                    acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(String.valueOf(_prefix) + proposal, context));
                }
            };
            this.getAllFeatures(type, _prefix).forEach(_function_1);
        } else {
            Resource _eResource = model.eResource();
            URI _uRI = null;
            if (_eResource != null) {
                _uRI = _eResource.getURI();
            }
            URI uri = _uRI;
            String clazz = this.getClassName(pojoDefinition.getQualifiedName(), prefix, uri);
            boolean _equals_1 = Objects.equal((Object)clazz, null);
            if (_equals_1) {
                return;
            }
            PropertyDescriptor[] descriptors = this.pojoResolver.getPropertyDescriptors(clazz, uri);
            boolean _equals_2 = Objects.equal((Object)descriptors, null);
            if (_equals_2) {
                super.completeMappingColumnName_Name(model, assignment, context, acceptor);
            } else {
                Functions.Function1<PropertyDescriptor, Boolean> _function_2 = new Functions.Function1<PropertyDescriptor, Boolean>(){

                    public Boolean apply(PropertyDescriptor it) {
                        String _name = it.getName();
                        return !Objects.equal((Object)"class", (Object)_name);
                    }
                };
                Consumer<PropertyDescriptor> _function_3 = new Consumer<PropertyDescriptor>(){

                    @Override
                    public void accept(PropertyDescriptor descriptor) {
                        String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)descriptor.getName(), "IDENT");
                        String _xifexpression = null;
                        _xifexpression = _cutPrefix ? proposal : String.valueOf(_prefix) + proposal;
                        acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(_xifexpression, context));
                    }
                };
                IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)descriptors)), (Functions.Function1)_function_2).forEach(_function_3);
            }
        }
    }

    public StringBuilder append(StringBuilder sb, String s) {
        boolean _greaterThan;
        StringBuilder _xblockexpression = null;
        int _length = sb.length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            sb.append(".");
        }
        _xblockexpression = sb.append(s);
        return _xblockexpression;
    }

    public boolean isResolvePojo(EObject model) {
        return this.modelProperty.isDoResolvePojo(model);
    }

    public boolean isResolveDb(EObject model) {
        return this.dbResolver.isResolveDb(model);
    }

    public boolean isPrimitive(Class<?> clazz) {
        boolean _equals = Objects.equal(clazz, null);
        if (_equals) {
            return true;
        }
        boolean _equals_1 = Objects.equal(clazz, String.class);
        if (_equals_1) {
            return true;
        }
        boolean _equals_2 = Objects.equal(clazz, java.util.Date.class);
        if (_equals_2) {
            return true;
        }
        boolean _equals_3 = Objects.equal(clazz, Date.class);
        if (_equals_3) {
            return true;
        }
        boolean _equals_4 = Objects.equal(clazz, Time.class);
        if (_equals_4) {
            return true;
        }
        boolean _equals_5 = Objects.equal(clazz, Timestamp.class);
        if (_equals_5) {
            return true;
        }
        boolean _equals_6 = Objects.equal(clazz, Blob.class);
        if (_equals_6) {
            return true;
        }
        boolean _equals_7 = Objects.equal(clazz, Clob.class);
        if (_equals_7) {
            return true;
        }
        boolean _equals_8 = Objects.equal(clazz, BigDecimal.class);
        if (_equals_8) {
            return true;
        }
        boolean _equals_9 = Objects.equal(clazz, BigInteger.class);
        return _equals_9;
    }

    public String getClassName(String baseClass, String property, URI uri) {
        PropertyDescriptor[] descriptors;
        boolean _equals;
        int pos2;
        if (Objects.equal((Object)baseClass, null) || Objects.equal((Object)property, null)) {
            return baseClass;
        }
        int pos1 = property.indexOf(".");
        if (pos1 == -1) {
            return baseClass;
        }
        String checkProperty = property;
        pos1 = checkProperty.indexOf("=");
        if (pos1 > 0 && (pos2 = checkProperty.indexOf(".", pos1)) > pos1) {
            String _plus;
            String _substring = checkProperty.substring(0, pos1);
            String _substring_1 = checkProperty.substring(pos2);
            checkProperty = _plus = String.valueOf(_substring) + _substring_1;
        }
        String innerProperty = null;
        pos1 = checkProperty.indexOf(".");
        if (pos1 > 0) {
            innerProperty = checkProperty.substring(pos1 + 1);
            checkProperty = checkProperty.substring(0, pos1);
        }
        if (_equals = Objects.equal((Object)(descriptors = this.pojoResolver.getPropertyDescriptors(baseClass, uri)), null)) {
            return null;
        }
        final String _checkProperty = checkProperty;
        PropertyDescriptor[] _converted_descriptors = descriptors;
        Functions.Function1<PropertyDescriptor, Boolean> _function = new Functions.Function1<PropertyDescriptor, Boolean>(){

            public Boolean apply(PropertyDescriptor descriptor) {
                String _name = descriptor.getName();
                return Objects.equal((Object)_name, (Object)_checkProperty);
            }
        };
        PropertyDescriptor innerDesriptor = (PropertyDescriptor)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_descriptors)), (Functions.Function1)_function);
        boolean _equals_1 = Objects.equal((Object)innerDesriptor, null);
        if (_equals_1) {
            return null;
        }
        Class innerClass = innerDesriptor.getPropertyType();
        boolean _isArray = innerClass.isArray();
        if (_isArray) {
            Type _genericReturnType = innerDesriptor.getReadMethod().getGenericReturnType();
            ParameterizedType type = (ParameterizedType)_genericReturnType;
            if (Objects.equal((Object)type.getActualTypeArguments(), null) || type.getActualTypeArguments().length == 0) {
                return null;
            }
            Type _head = (Type)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)type.getActualTypeArguments())));
            innerClass = (Class)_head;
            boolean _isPrimitive = this.isPrimitive(innerClass);
            if (_isPrimitive) {
                return null;
            }
            return this.getClassName(innerClass.getName(), innerProperty, uri);
        }
        boolean _isAssignableFrom = Collection.class.isAssignableFrom(innerClass);
        if (_isAssignableFrom) {
            Type _genericReturnType_1 = innerDesriptor.getReadMethod().getGenericReturnType();
            ParameterizedType type_1 = (ParameterizedType)_genericReturnType_1;
            if (Objects.equal((Object)type_1.getActualTypeArguments(), null) || type_1.getActualTypeArguments().length == 0) {
                return null;
            }
            Type _head_1 = (Type)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)type_1.getActualTypeArguments())));
            innerClass = (Class)_head_1;
            boolean _isPrimitive_1 = this.isPrimitive(innerClass);
            if (_isPrimitive_1) {
                return null;
            }
            return this.getClassName(innerClass.getName(), innerProperty, uri);
        }
        boolean _isPrimitive_2 = this.isPrimitive(innerClass);
        if (_isPrimitive_2) {
            return null;
        }
        return this.getClassName(innerClass.getName(), innerProperty, uri);
    }

    public void acceptTables(EObject model, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor, final String suffix) {
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                int _indexOf = it.indexOf("$");
                return _indexOf < 0;
            }
        };
        Consumer<String> _function_1 = new Consumer<String>(){

            @Override
            public void accept(String table) {
                String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)table, "IDENT");
                acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(String.valueOf(proposal) + suffix, context));
            }
        };
        IterableExtensions.filter((Iterable)this.dbResolver.getTables(model), (Functions.Function1)_function).forEach(_function_1);
    }

    public void acceptProcedures(EObject model, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                int _indexOf = it.indexOf("$");
                return _indexOf < 0;
            }
        };
        Consumer<String> _function_1 = new Consumer<String>(){

            @Override
            public void accept(String table) {
                String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)table, "IDENT");
                acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(proposal, context));
            }
        };
        IterableExtensions.filter((Iterable)this.dbResolver.getProcedures(model), (Functions.Function1)_function).forEach(_function_1);
    }

    public void acceptFunctions(EObject model, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                int _indexOf = it.indexOf("$");
                return _indexOf < 0;
            }
        };
        Consumer<String> _function_1 = new Consumer<String>(){

            @Override
            public void accept(String table) {
                String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)table, "IDENT");
                acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(proposal, context));
            }
        };
        IterableExtensions.filter((Iterable)this.dbResolver.getFunctions(model), (Functions.Function1)_function).forEach(_function_1);
    }

    public void acceptCheckConstraints(EObject model, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                int _indexOf = it.indexOf("$");
                return _indexOf < 0;
            }
        };
        Consumer<String> _function_1 = new Consumer<String>(){

            @Override
            public void accept(String table) {
                String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)table, "IDENT");
                acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(proposal, context));
            }
        };
        IterableExtensions.filter((Iterable)this.dbResolver.getCheckConstraints(model), (Functions.Function1)_function).forEach(_function_1);
    }

    public void acceptSequences(EObject model, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                int _indexOf = it.indexOf("$");
                return _indexOf < 0;
            }
        };
        Consumer<String> _function_1 = new Consumer<String>(){

            @Override
            public void accept(String table) {
                String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)table, "IDENT");
                acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(proposal, context));
            }
        };
        IterableExtensions.filter((Iterable)this.dbResolver.getSequences(model), (Functions.Function1)_function).forEach(_function_1);
    }

    public void acceptColumns(List<String> columns, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor, final String prefix, final String suffix) {
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String column) {
                String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)column, "IDENT");
                String _xifexpression = null;
                boolean _notEquals = !Objects.equal((Object)prefix, null);
                _xifexpression = _notEquals ? String.valueOf(prefix) + "." + proposal : proposal;
                String completion = _xifexpression;
                String _xifexpression_1 = null;
                boolean _notEquals_1 = !Objects.equal((Object)suffix, null);
                _xifexpression_1 = _notEquals_1 ? String.valueOf(completion) + suffix : completion;
                completion = _xifexpression_1;
                acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(completion, context));
            }
        };
        columns.forEach(_function);
    }

    @Override
    public void completeTableDefinitionModel_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeTableDefinitionModel_Table(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeProcedureDefinitionModel_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeProcedureDefinitionModel_Table(model, assignment, context, acceptor);
            return;
        }
        this.acceptProcedures(model, context, acceptor);
    }

    @Override
    public void completeFunctionDefinitionModel_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeFunctionDefinitionModel_Table(model, assignment, context, acceptor);
            return;
        }
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void complete_DatabaseColumn(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        TableDefinition tableDefinition;
        boolean _notEquals;
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.complete_DatabaseColumn(model, ruleCall, context, acceptor);
            return;
        }
        int pos = context.getPrefix().indexOf(".");
        String _xifexpression = null;
        if (pos > 0) {
            _xifexpression = context.getPrefix().substring(0, pos);
        }
        String prefix = _xifexpression;
        MetaStatement metaStatement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)model, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)model, Artifacts.class);
        String value = Utils.getTokenFromModifier((MetaStatement)metaStatement, (String)"tab", (String)prefix);
        TableDefinition _xifexpression_1 = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)value, null);
        if (_notEquals) {
            _xifexpression_1 = (TableDefinition)this.modelProperty.getModelTables((EObject)artifacts).get(value);
        }
        if (!Objects.equal(tableDefinition = _xifexpression_1, null) && !Objects.equal((Object)tableDefinition.getTable(), null)) {
            this.acceptColumns(this.dbResolver.getColumns(model, tableDefinition.getTable()), context, acceptor, prefix, null);
        }
    }

    @Override
    public void complete_DatabaseTable(EObject model, RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.complete_DatabaseTable(model, ruleCall, context, acceptor);
            return;
        }
        MetaStatement metaStatement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)model, MetaStatement.class);
        final Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)model, Artifacts.class);
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String value) {
                boolean _notEquals;
                TableDefinition tableDefinition = (TableDefinition)ProcessorMetaProposalProvider.this.modelProperty.getModelTables((EObject)artifacts).get(value);
                boolean bl = _notEquals = !Objects.equal((Object)tableDefinition, null);
                if (_notEquals) {
                    String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)tableDefinition.getTable(), "IDENT");
                    acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(proposal, context));
                }
            }
        };
        Utils.getTokensFromModifier((MetaStatement)metaStatement, (String)"tab").forEach(_function);
    }

    @Override
    public void completePojogenProperty_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptCheckConstraints(model, context, acceptor);
    }

    @Override
    public void completePojogenProperty_DbProcedure(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbProcedure(model, assignment, context, acceptor);
            return;
        }
        this.acceptProcedures(model, context, acceptor);
    }

    @Override
    public void completePojogenProperty_DbFunction(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbFunction(model, assignment, context, acceptor);
            return;
        }
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeTableAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeTableAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "->");
    }

    @Override
    public void completeInheritanceAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeInheritanceAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "->");
    }

    @Override
    public void completePojogenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completePojogenProperty_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeMetagenProperty_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completePojogenProperty_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completePojogenProperty_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, null);
        }
    }

    @Override
    public void completePojogenProperty_DbColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completePojogenProperty_DbColumns(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, null);
        }
    }

    @Override
    public void completeImplementsAssignement_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeImplementsAssignement_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeExtendsAssignement_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeExtendsAssignement_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeImplementsAssignement_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeImplementsAssignement_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeExtendsAssignement_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeExtendsAssignement_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeImplementsAssignementGenerics_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeImplementsAssignementGenerics_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeExtendsAssignementGenerics_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeExtendsAssignementGenerics_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeImplementsAssignementGenerics_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeImplementsAssignementGenerics_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeExtendsAssignementGenerics_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeExtendsAssignementGenerics_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeColumnTypeAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, "->");
        } else {
            boolean _notEquals_1;
            String _dbProcedure = prop.getDbProcedure();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_dbProcedure, null);
            if (_notEquals_1) {
                this.acceptColumns(this.dbResolver.getProcColumns(model, prop.getDbProcedure()), context, acceptor, null, "->");
            } else {
                boolean _notEquals_2;
                String _dbFunction = prop.getDbFunction();
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)_dbFunction, null);
                if (_notEquals_2) {
                    this.acceptColumns(this.dbResolver.getFunColumns(model, prop.getDbFunction()), context, acceptor, null, "->");
                }
            }
        }
    }

    @Override
    public void completeColumnAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completeColumnAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, "->");
            this.acceptColumns(this.dbResolver.getCheckColumns(model, prop.getDbTable()), context, acceptor, null, "->");
        }
    }

    @Override
    public void completeImportAssignement_PkTable(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof ImportAssignement)) {
            super.completeImportAssignement_PkTable(model, assignment, context, acceptor);
            return;
        }
        final ImportAssignement imp = (ImportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (!Objects.equal((Object)prop.getDbTable(), null) && !Objects.equal((Object)imp.getDbColumn(), null)) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)"create-many-to-one", (Object)_name);
            if (_equals) {
                this.acceptTables(model, context, acceptor, "");
            } else {
                Consumer<DbImport> _function = new Consumer<DbImport>(){

                    @Override
                    public void accept(DbImport dbImport) {
                        if (!Objects.equal((Object)dbImport.getFkColumn(), null) && dbImport.getFkColumn().equals(imp.getDbColumn())) {
                            String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)dbImport.getPkTable(), "IDENT");
                            acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(proposal, context));
                        }
                    }
                };
                this.dbResolver.getDbImports(model, prop.getDbTable()).forEach(_function);
            }
        }
    }

    @Override
    public void completeImportAssignement_PkColumn(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof ImportAssignement)) {
            super.completeImportAssignement_PkColumn(model, assignment, context, acceptor);
            return;
        }
        final ImportAssignement imp = (ImportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (!(Objects.equal((Object)prop.getDbTable(), null) || Objects.equal((Object)imp.getDbColumn(), null) || Objects.equal((Object)imp.getPkTable(), null))) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)"create-many-to-one", (Object)_name);
            if (_equals) {
                this.acceptColumns(this.dbResolver.getColumns(model, imp.getPkTable()), context, acceptor, null, null);
            } else {
                Consumer<DbImport> _function = new Consumer<DbImport>(){

                    @Override
                    public void accept(DbImport dbImport) {
                        if (!Objects.equal((Object)dbImport.getFkColumn(), null) && dbImport.getFkColumn().equals(imp.getDbColumn()) && !Objects.equal((Object)dbImport.getPkTable(), null) && dbImport.getPkTable().equals(imp.getPkTable())) {
                            String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)dbImport.getPkColumn(), "IDENT");
                            acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(proposal, context));
                        }
                    }
                };
                this.dbResolver.getDbImports(model, prop.getDbTable()).forEach(_function);
            }
        }
    }

    @Override
    public void completeImportAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completeImportAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, "->");
        }
    }

    @Override
    public void completeExportAssignement_FkTable(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof ExportAssignement)) {
            super.completeExportAssignement_FkTable(model, assignment, context, acceptor);
            return;
        }
        final ExportAssignement exp = (ExportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (!Objects.equal((Object)prop.getDbTable(), null) && !Objects.equal((Object)exp.getDbColumn(), null)) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)"create-one-to-many", (Object)_name);
            if (_equals) {
                this.acceptTables(model, context, acceptor, "");
            } else {
                Consumer<DbExport> _function = new Consumer<DbExport>(){

                    @Override
                    public void accept(DbExport dbExport) {
                        if (!Objects.equal((Object)dbExport.getPkColumn(), null) && dbExport.getPkColumn().equals(exp.getDbColumn())) {
                            String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)dbExport.getFkTable(), "IDENT");
                            acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(proposal, context));
                        }
                    }
                };
                this.dbResolver.getDbExports(model, prop.getDbTable()).forEach(_function);
            }
        }
    }

    @Override
    public void completeExportAssignement_FkColumn(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof ExportAssignement)) {
            super.completeExportAssignement_FkColumn(model, assignment, context, acceptor);
            return;
        }
        final ExportAssignement exp = (ExportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (!(Objects.equal((Object)prop.getDbTable(), null) || Objects.equal((Object)exp.getDbColumn(), null) || Objects.equal((Object)exp.getFkTable(), null))) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)"create-one-to-many", (Object)_name);
            if (_equals) {
                this.acceptColumns(this.dbResolver.getColumns(model, exp.getFkTable()), context, acceptor, null, null);
            } else {
                Consumer<DbExport> _function = new Consumer<DbExport>(){

                    @Override
                    public void accept(DbExport dbExport) {
                        if (!Objects.equal((Object)dbExport.getPkColumn(), null) && dbExport.getPkColumn().equals(exp.getDbColumn()) && !Objects.equal((Object)dbExport.getFkTable(), null) && dbExport.getFkTable().equals(exp.getFkTable())) {
                            String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)dbExport.getFkColumn(), "IDENT");
                            acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(proposal, context));
                        }
                    }
                };
                this.dbResolver.getDbExports(model, prop.getDbTable()).forEach(_function);
            }
        }
    }

    @Override
    public void completeExportAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completeExportAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, "->");
        }
    }

    @Override
    public void completeManyToManyAssignement_PkColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completeManyToManyAssignement_PkColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, "->");
        }
    }

    @Override
    public void completeManyToManyAssignement_PkTable(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof ManyToManyAssignement)) {
            super.completeManyToManyAssignement_PkTable(model, assignment, context, acceptor);
            return;
        }
        final ManyToManyAssignement many2 = (ManyToManyAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (!Objects.equal((Object)prop.getDbTable(), null) && !Objects.equal((Object)many2.getPkColumn(), null)) {
            Consumer<DbImport> _function = new Consumer<DbImport>(){

                @Override
                public void accept(DbImport dbImport) {
                    if (!Objects.equal((Object)dbImport.getPkColumn(), null) && dbImport.getPkColumn().equals(many2.getPkColumn())) {
                        String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)dbImport.getPkTable(), "IDENT");
                        acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(proposal, context));
                    }
                }
            };
            this.dbResolver.getDbImports(model, prop.getDbTable()).forEach(_function);
        }
    }

    @Override
    public void completeInheritanceAssignement_DbColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof InheritanceAssignement)) {
            super.completeInheritanceAssignement_DbColumns(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, null);
        }
    }

    @Override
    public void completePojogenProperty_Methods(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        if (!(model instanceof PojogenProperty)) {
            super.completePojogenProperty_Methods(model, assignment, context, acceptor);
            return;
        }
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String method) {
                String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)method, "IDENT");
                acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(proposal, context));
            }
        };
        this.methods.forEach(_function);
    }

    @Override
    public void completeShowColumnTypeAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completeShowColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, "->");
        } else {
            boolean _notEquals_1;
            String _dbProcedure = prop.getDbProcedure();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_dbProcedure, null);
            if (_notEquals_1) {
                this.acceptColumns(this.dbResolver.getProcColumns(model, prop.getDbProcedure()), context, acceptor, null, "->");
            } else {
                boolean _notEquals_2;
                String _dbFunction = prop.getDbFunction();
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)_dbFunction, null);
                if (_notEquals_2) {
                    this.acceptColumns(this.dbResolver.getFunColumns(model, prop.getDbFunction()), context, acceptor, null, "->");
                }
            }
        }
    }

    @Override
    public void completeShowColumnTypeAssignement_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals_3;
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof ShowColumnTypeAssignement)) {
            super.completeShowColumnTypeAssignement_Type(model, assignment, context, acceptor);
            return;
        }
        ShowColumnTypeAssignement prop = (ShowColumnTypeAssignement)model;
        PojogenProperty prop2 = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        String type = null;
        String _dbTable = prop2.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            type = this.dbResolver.getType(model, prop2.getDbTable(), prop.getDbColumn());
        } else {
            boolean _notEquals_1;
            String _dbProcedure = prop2.getDbProcedure();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_dbProcedure, null);
            if (_notEquals_1) {
                type = this.dbResolver.getType(model, prop2.getDbProcedure(), prop.getDbColumn());
            } else {
                boolean _notEquals_2;
                String _dbFunction = prop2.getDbFunction();
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)_dbFunction, null);
                if (_notEquals_2) {
                    type = this.dbResolver.getType(model, prop2.getDbFunction(), prop.getDbColumn());
                }
            }
        }
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)type, null);
        if (_notEquals_3) {
            String proposal = this.getValueConverter().toString((Object)type, "PropertyValue");
            acceptor.accept(this.createCompletionProposal(proposal, context));
        }
    }

    @Override
    public void completeJoinTableAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeJoinTableAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "->");
    }

    @Override
    public void completeJoinTableAssignement_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeJoinTableAssignement_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    public Set<PojoDefinitionModel> listPojos(final ResourceSet resourceSet, IScope scope) {
        Comparator<PojoDefinitionModel> _function = new Comparator<PojoDefinitionModel>(){

            @Override
            public int compare(PojoDefinitionModel o1, PojoDefinitionModel o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        final TreeSet result = CollectionLiterals.newTreeSet((Comparator)_function);
        Consumer<IEObjectDescription> _function_1 = new Consumer<IEObjectDescription>(){

            @Override
            public void accept(IEObjectDescription description) {
                EObject _eObject = resourceSet.getEObject(description.getEObjectURI(), true);
                PojoDefinitionModel pojo = (PojoDefinitionModel)_eObject;
                result.add(pojo);
            }
        };
        scope.getAllElements().forEach(_function_1);
        return result;
    }

    public Set<TableDefinitionModel> listTables(final ResourceSet resourceSet, IScope scope) {
        Comparator<TableDefinitionModel> _function = new Comparator<TableDefinitionModel>(){

            @Override
            public int compare(TableDefinitionModel o1, TableDefinitionModel o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        final TreeSet result = CollectionLiterals.newTreeSet((Comparator)_function);
        Consumer<IEObjectDescription> _function_1 = new Consumer<IEObjectDescription>(){

            @Override
            public void accept(IEObjectDescription description) {
                EObject _eObject = resourceSet.getEObject(description.getEObjectURI(), true);
                TableDefinitionModel table = (TableDefinitionModel)_eObject;
                result.add(table);
            }
        };
        scope.getAllElements().forEach(_function_1);
        return result;
    }

    @Override
    public void complete_StatementModifier(EObject model, RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        MetaStatement metaStatement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)model, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)metaStatement, Artifacts.class);
        Set<PojoDefinitionModel> pojos = this.listPojos(artifacts.eResource().getResourceSet(), this.getScopeProvider().getScope((EObject)artifacts, ProcessorMetaPackage.Literals.ARTIFACTS__POJOS));
        Consumer<PojoDefinitionModel> _function = new Consumer<PojoDefinitionModel>(){

            @Override
            public void accept(PojoDefinitionModel pojo) {
                String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)pojo.getName(), "IDENT");
                acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal("const=" + proposal, context));
                acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal("in=" + proposal, context));
                acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal("out=" + proposal, context));
                acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal("ix=" + proposal, context));
            }
        };
        pojos.forEach(_function);
        Set<TableDefinitionModel> tables = this.listTables(artifacts.eResource().getResourceSet(), this.getScopeProvider().getScope((EObject)artifacts, ProcessorMetaPackage.Literals.ARTIFACTS__TABLES));
        Consumer<TableDefinitionModel> _function_1 = new Consumer<TableDefinitionModel>(){

            @Override
            public void accept(TableDefinitionModel table) {
                String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)table.getName(), "IDENT");
                acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal("tab=" + proposal, context));
            }
        };
        tables.forEach(_function_1);
    }

    @Override
    public void complete_MappingRuleModifier(EObject model, RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        MappingRule mappingRule = (MappingRule)EcoreUtil2.getContainerOfType((EObject)model, MappingRule.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)mappingRule, Artifacts.class);
        Set<PojoDefinitionModel> pojos = this.listPojos(artifacts.eResource().getResourceSet(), this.getScopeProvider().getScope((EObject)artifacts, ProcessorMetaPackage.Literals.ARTIFACTS__POJOS));
        Consumer<PojoDefinitionModel> _function = new Consumer<PojoDefinitionModel>(){

            @Override
            public void accept(PojoDefinitionModel pojo) {
                String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)pojo.getName(), "IDENT");
                acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal("out=" + proposal, context));
            }
        };
        pojos.forEach(_function);
    }

    @Override
    public void complete_Modifier(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(this.TYPES, "IDENT", context, acceptor, "type=");
        this.addProposalList(this.MODIFIERS, "IDENT", context, acceptor, null);
    }

    @Override
    public void complete_MappingItemModifier(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(this.TYPES, "IDENT", context, acceptor, "type=");
        this.addProposalList(this.MODIFIERS, "IDENT", context, acceptor, null);
    }

    @Override
    public void completeMetagenProperty_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeMetagenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeMetagenProperty_DbFunction(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbFunction(model, assignment, context, acceptor);
            return;
        }
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeMetagenProperty_DbProcedure(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbProcedure(model, assignment, context, acceptor);
            return;
        }
        this.acceptProcedures(model, context, acceptor);
    }

    @Override
    public void completeMetagenProperty_Sequence(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_Sequence(model, assignment, context, acceptor);
            return;
        }
        this.acceptSequences(model, context, acceptor);
    }

    @Override
    public void completeMetaTypeAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof MetagenProperty)) {
            super.completeMetaTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, null);
    }

    @Override
    public void completeDaogenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDaogenProperty_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeMetagenProperty_DbColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof MetagenProperty)) {
            super.completeMetagenProperty_DbColumns(model, assignment, context, acceptor);
            return;
        }
        MetagenProperty prop = (MetagenProperty)model;
        this.acceptColumns(this.dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, null);
    }

    @Override
    public void completeDatabaseMetaInfoAssignement_DbMetaInfo(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDatabaseMetaInfoAssignement_DbMetaInfo(model, assignment, context, acceptor);
            return;
        }
        String dbMetaInfo = this.dbResolver.getDbMetaInfo(model);
        boolean bl2 = _notEquals = !Objects.equal((Object)dbMetaInfo, null);
        if (_notEquals) {
            dbMetaInfo = "\"" + dbMetaInfo + "\"";
        }
        String proposal = this.getValueConverter().toString((Object)dbMetaInfo, "PropertyValue");
        acceptor.accept(this.createCompletionProposal(proposal, context));
    }

    @Override
    public void completeDriverMetaInfoAssignement_DbDriverInfo(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDriverMetaInfoAssignement_DbDriverInfo(model, assignment, context, acceptor);
            return;
        }
        String dbDriverInfo = this.dbResolver.getDbDriverInfo(model);
        boolean bl2 = _notEquals = !Objects.equal((Object)dbDriverInfo, null);
        if (_notEquals) {
            dbDriverInfo = "\"" + dbDriverInfo + "\"";
        }
        String proposal = this.getValueConverter().toString((Object)dbDriverInfo, "PropertyValue");
        acceptor.accept(this.createCompletionProposal(proposal, context));
    }

    @Override
    public void completeDriverMethodOutputAssignement_DriverMethod(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof DatabaseProperty)) {
            super.completeDriverMethodOutputAssignement_DriverMethod(model, assignment, context, acceptor);
            return;
        }
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String driverMetod) {
                String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)driverMetod, "PropertyValue");
                acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(String.valueOf(proposal) + "->", context));
            }
        };
        this.dbResolver.getDriverMethods(model).forEach(_function);
    }

    @Override
    public void completeDriverMethodOutputAssignement_CallOutput(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof DriverMethodOutputAssignement)) {
            super.completeDriverMethodOutputAssignement_CallOutput(model, assignment, context, acceptor);
            return;
        }
        DriverMethodOutputAssignement prop = (DriverMethodOutputAssignement)model;
        Object _elvis = null;
        Object _driverMethodOutput = this.dbResolver.getDriverMethodOutput(model, prop.getDriverMethod());
        _elvis = _driverMethodOutput != null ? _driverMethodOutput : "null";
        Object methodCallOutput = _elvis;
        String proposal = this.getValueConverter().toString((Object)("\"" + methodCallOutput + "\""), "PropertyValue");
        acceptor.accept(this.createCompletionProposal(proposal, context));
    }

    @Override
    public void completeDatabaseTypeAssignement_DbType(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDatabaseTypeAssignement_DbType(model, assignment, context, acceptor);
            return;
        }
        String dbMetaInfo = this.dbResolver.getDbMetaInfo(model);
        Consumer<DbResolver.DbType> _function = new Consumer<DbResolver.DbType>(){

            @Override
            public void accept(DbResolver.DbType dbType) {
                String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)dbType.getValue(), "PropertyValue");
                acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(proposal, context));
            }
        };
        ((List)Conversions.doWrapArray((Object)DbResolver.DbType.fromDbMetaInfo((String)dbMetaInfo))).forEach(_function);
    }

    @Override
    public void completeDatabaseCatalogAssignement_DbCatalog(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDatabaseCatalogAssignement_DbCatalog(model, assignment, context, acceptor);
            return;
        }
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String catalog) {
                String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)catalog, "IDENT");
                acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(proposal, context));
            }
        };
        this.dbResolver.getCatalogs(model).forEach(_function);
    }

    @Override
    public void completeDatabaseSchemaAssignement_DbSchema(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDatabaseSchemaAssignement_DbSchema(model, assignment, context, acceptor);
            return;
        }
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String schema) {
                String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)schema, "IDENT");
                acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(proposal, context));
            }
        };
        this.dbResolver.getSchemas(model).forEach(_function);
    }

    @Override
    public void completeDebugLevelAssignement_Debug(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(this.DEBUG_LEVELS, "DEBUG_LEVELS", context, acceptor, null);
    }

    @Override
    public void completeProcedurePojoAssignement_DbProcedure(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeProcedurePojoAssignement_DbProcedure(model, assignment, context, acceptor);
            return;
        }
        this.acceptProcedures(model, context, acceptor);
    }

    @Override
    public void completeFunctionPojoAssignement_DbFunction(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeFunctionPojoAssignement_DbFunction(model, assignment, context, acceptor);
            return;
        }
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeOrdSql_Ident(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        boolean newPojoValidator;
        PojoDefinition pojoDefinition;
        boolean _equals_1;
        boolean _notEquals;
        boolean _not;
        boolean _isResolvePojo = this.isResolvePojo(model);
        boolean bl = _not = !_isResolvePojo;
        if (_not) {
            super.completeOrdSql_Ident(model, assignment, context, acceptor);
            return;
        }
        MetaStatement metaStatement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)model, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)model, Artifacts.class);
        String pojoName = Utils.getTokenFromModifier((MetaStatement)metaStatement, (String)"ix");
        boolean _equals = Objects.equal((Object)pojoName, null);
        if (_equals) {
            pojoName = Utils.getTokenFromModifier((MetaStatement)metaStatement, (String)"in");
        }
        PojoDefinition _xifexpression = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)pojoName, null);
        if (_notEquals) {
            _xifexpression = (PojoDefinition)this.modelProperty.getModelPojos((EObject)artifacts).get(pojoName);
        }
        if (_equals_1 = Objects.equal(pojoDefinition = _xifexpression, null)) {
            String proposal = this.getValueConverter().toString((Object)("Error: I can't load pojo for " + model), "IDENT");
            acceptor.accept(this.createCompletionProposal(proposal, context));
            return;
        }
        boolean _isOldPojoValidator = this.modelProperty.isOldPojoValidator(model);
        boolean bl3 = newPojoValidator = !_isOldPojoValidator;
        if (newPojoValidator && pojoDefinition.getClassx() instanceof JvmDeclaredType) {
            Iterable nestedTypes;
            final Founder founder = new Founder();
            JvmType _classx = pojoDefinition.getClassx();
            JvmDeclaredType type = (JvmDeclaredType)_classx;
            Functions.Function1<JvmFeature, Boolean> _function = new Functions.Function1<JvmFeature, Boolean>(){

                public Boolean apply(JvmFeature it) {
                    return it instanceof JvmField;
                }
            };
            Functions.Function1<JvmFeature, Boolean> _function_1 = new Functions.Function1<JvmFeature, Boolean>(){

                public Boolean apply(JvmFeature it) {
                    return it.isStatic();
                }
            };
            Functions.Function1<JvmFeature, Boolean> _function_2 = new Functions.Function1<JvmFeature, Boolean>(){

                public Boolean apply(JvmFeature it) {
                    return it.getSimpleName().startsWith("ORDER_BY_");
                }
            };
            Consumer<JvmFeature> _function_3 = new Consumer<JvmFeature>(){

                @Override
                public void accept(JvmFeature feature) {
                    founder.found = true;
                    String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)feature.getSimpleName(), "IDENT").substring(9);
                    InputOutput.println((Object)proposal);
                    acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(proposal, context));
                }
            };
            IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)type.getAllFeatures(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2).forEach(_function_3);
            if (!founder.found && !Objects.equal((Object)(nestedTypes = type.findAllNestedTypesByName("Order")), null) && !IterableExtensions.isEmpty((Iterable)nestedTypes) && IterableExtensions.head((Iterable)nestedTypes) instanceof JvmEnumerationType) {
                JvmDeclaredType _head = (JvmDeclaredType)IterableExtensions.head((Iterable)nestedTypes);
                JvmEnumerationType enumType = (JvmEnumerationType)_head;
                Functions.Function1<JvmFeature, Boolean> _function_4 = new Functions.Function1<JvmFeature, Boolean>(){

                    public Boolean apply(JvmFeature it) {
                        return it instanceof JvmEnumerationLiteral;
                    }
                };
                Consumer<JvmFeature> _function_5 = new Consumer<JvmFeature>(){

                    @Override
                    public void accept(JvmFeature feature) {
                        String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)feature.getSimpleName(), "IDENT");
                        InputOutput.println((Object)proposal);
                        acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(proposal, context));
                    }
                };
                IterableExtensions.filter((Iterable)enumType.getAllFeatures(), (Functions.Function1)_function_4).forEach(_function_5);
            }
        } else {
            boolean _notEquals_1;
            Resource _eResource = model.eResource();
            URI _uRI = null;
            if (_eResource != null) {
                _uRI = _eResource.getURI();
            }
            URI uri = _uRI;
            String clazz = pojoDefinition.getQualifiedName();
            Map orders = this.pojoResolver.getOrders(clazz, uri);
            boolean bl4 = _notEquals_1 = !Objects.equal((Object)orders, null);
            if (_notEquals_1) {
                Consumer<String> _function_6 = new Consumer<String>(){

                    @Override
                    public void accept(String order) {
                        String proposal = ProcessorMetaProposalProvider.this.getValueConverter().toString((Object)order, "IDENT");
                        acceptor.accept(ProcessorMetaProposalProvider.this.createCompletionProposal(proposal, context));
                    }
                };
                orders.values().forEach(_function_6);
            }
        }
    }

    public static class Founder {
        private boolean found = false;
    }
}

