/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.meta.ui.resolver;

import com.google.inject.Singleton;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.sqlproc.plugin.lib.resolver.PojoResolver;

@Singleton
public class WorkspacePojoResolverImpl
implements PojoResolver {
    protected Logger LOGGER = Logger.getLogger(WorkspacePojoResolverImpl.class);
    private Map<String, URLClassLoader> allLoaders;
    private Set<String> nokLoaders = new HashSet<String>();
    private static final String PREFIX1 = "platform:/resource/";
    private static final int PLEN1 = "platform:/resource/".length();

    protected void init() {
        IProject[] projects;
        this.LOGGER.info((Object)"POJO START");
        LinkedHashMap<String, URLClassLoader> loaders = null;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            String pname = project.toString();
            pname = pname.startsWith("P/") ? pname.substring(2) : project.getName();
            try {
                if (!(this.nokLoaders.contains(pname) || this.allLoaders != null && this.allLoaders.containsKey(pname))) {
                    project.open(null);
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    URLClassLoader classLoader = this.getProjectClassLoader(javaProject);
                    if (loaders == null) {
                        loaders = new LinkedHashMap<String, URLClassLoader>();
                    }
                    loaders.put(pname, classLoader);
                }
            }
            catch (CoreException e) {
                this.nokLoaders.add(pname);
                this.LOGGER.warn((Object)("Can't handle project '" + project + "': " + e.getMessage()));
            }
            ++n2;
        }
        if (loaders != null && !loaders.isEmpty()) {
            if (this.allLoaders != null) {
                this.allLoaders.putAll((Map<String, URLClassLoader>)loaders);
            } else {
                this.allLoaders = loaders;
            }
        }
    }

    private URLClassLoader getProjectClassLoader(IJavaProject javaProject) throws CoreException {
        String[] classPathEntries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        ArrayList<URL> urlList = new ArrayList<URL>();
        int i = 0;
        while (i < classPathEntries.length) {
            String entry = classPathEntries[i];
            Path path = new Path(entry);
            try {
                URL url = path.toFile().toURI().toURL();
                urlList.add(url);
            }
            catch (MalformedURLException e) {
                this.LOGGER.warn((Object)("Can't accept URL for '" + path + "': " + e.getMessage()));
            }
            ++i;
        }
        ClassLoader parentClassLoader = javaProject.getClass().getClassLoader();
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        URLClassLoader classLoader = new URLClassLoader(urls, parentClassLoader);
        return classLoader;
    }

    public Class<?> loadClass(String name, URI uri) {
        return this.loadClass(name, uri, false);
    }

    public Class<?> loadClass(String name, URI uri, boolean ignoreNotFound) {
        String pname = this.getProjectName(uri);
        if (this.allLoaders == null) {
            this.init();
        }
        boolean retry = false;
        if (pname != null) {
            URLClassLoader loader = this.allLoaders.get(pname);
            if (loader != null) {
                try {
                    return loader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.init();
                    loader = this.allLoaders.get(pname);
                    if (loader != null) {
                        try {
                            return loader.loadClass(name);
                        }
                        catch (ClassNotFoundException ignore) {
                            if (!ignoreNotFound) {
                                this.LOGGER.warn((Object)("Can't find class '" + name + "' in loader " + loader + " " + uri));
                            }
                        }
                    } else {
                        retry = true;
                    }
                }
            } else {
                retry = true;
            }
        }
        if (!retry) {
            return null;
        }
        for (Map.Entry<String, URLClassLoader> e : this.allLoaders.entrySet()) {
            try {
                Class<?> clazz = e.getValue().loadClass(name);
                this.LOGGER.warn((Object)("Found " + name + "(" + uri + ") in " + e.getKey()));
                return clazz;
            }
            catch (ClassNotFoundException clazz) {
                // empty catch block
            }
        }
        this.init();
        for (Map.Entry<String, URLClassLoader> e : this.allLoaders.entrySet()) {
            try {
                Class<?> clazz = e.getValue().loadClass(name);
                this.LOGGER.warn((Object)("Found " + name + "(" + uri + ") in " + e.getKey()));
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (!ignoreNotFound) {
            this.LOGGER.warn((Object)("Can't find class '" + name + "' in any loader " + this.allLoaders));
        }
        return null;
    }

    public PropertyDescriptor[] getPropertyDescriptors(String name, URI uri) {
        Class<?> beanClass;
        if (this.allLoaders == null) {
            this.init();
        }
        if ((beanClass = this.loadClass(name, uri)) == null) {
            return null;
        }
        PropertyDescriptor[] descriptors = null;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
        descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        return descriptors;
    }

    public Map<String, String> getOrders(String name, URI uri) {
        int n;
        int n2;
        Field[] fieldArray;
        Class<?> beanClass;
        if (this.allLoaders == null) {
            this.init();
        }
        if ((beanClass = this.loadClass(name, uri)) == null) {
            return null;
        }
        HashMap<String, String> orders = new HashMap<String, String>();
        while (beanClass != null) {
            Field[] fields = beanClass.getFields();
            fieldArray = fields;
            n2 = fields.length;
            n = 0;
            while (n < n2) {
                Field f = fieldArray[n];
                if (Modifier.isStatic(f.getModifiers())) {
                    try {
                        if (f.getType() == Integer.TYPE) {
                            orders.put(f.getName(), "" + f.getInt(null));
                        } else if (f.getType() == String.class) {
                            orders.put(f.getName(), (String)f.get(null));
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException exception) {
                        // empty catch block
                    }
                }
                ++n;
            }
            beanClass = beanClass.getSuperclass();
        }
        beanClass = this.loadClass(name, uri);
        Class<?> orderBeanClass = this.loadClass(String.valueOf(name) + "$Order", uri, true);
        while (orderBeanClass != null && orderBeanClass.isEnum()) {
            fieldArray = orderBeanClass.getEnumConstants();
            n2 = fieldArray.length;
            n = 0;
            while (n < n2) {
                Field en = fieldArray[n];
                String ename = ((Object)en).toString();
                orders.put(ename, ename);
                ++n;
            }
            if ((beanClass = beanClass.getSuperclass()) == null) break;
            orderBeanClass = this.loadClass(String.valueOf(beanClass.getName()) + "$Order", uri, true);
        }
        return orders;
    }

    public List<Class<?>> getPojoClasses(URI uri) {
        ArrayList pojos = new ArrayList();
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart != null) {
            IFileEditorInput input = (IFileEditorInput)editorPart.getEditorInput();
            IProject project = input.getFile().getProject();
            try {
                project.open(null);
                IJavaProject javaProject = JavaCore.create((IProject)project);
                URLClassLoader classLoader = this.getProjectClassLoader(javaProject);
                IPackageFragment[] iPackageFragmentArray = javaProject.getPackageFragments();
                int n = iPackageFragmentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragment fragment = iPackageFragmentArray[n2];
                    if (fragment.getKind() == 1) {
                        ICompilationUnit[] iCompilationUnitArray = fragment.getCompilationUnits();
                        int n3 = iCompilationUnitArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ICompilationUnit unit = iCompilationUnitArray[n4];
                            if (unit.getTypes() != null && unit.getTypes().length > 0) {
                                String classname = String.valueOf(unit.getParent().getElementName()) + "." + unit.getTypes()[0].getElementName();
                                Class<?> clazz = null;
                                try {
                                    clazz = classLoader.loadClass(classname);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    // empty catch block
                                }
                                if (clazz != null) {
                                    Annotation[] annotationArray = clazz.getAnnotations();
                                    int n5 = annotationArray.length;
                                    int n6 = 0;
                                    while (n6 < n5) {
                                        Annotation annotation = annotationArray[n6];
                                        if ("org.sqlproc.engine.annotation.Pojo".equals(annotation.annotationType().getName())) {
                                            pojos.add(clazz);
                                            break;
                                        }
                                        ++n6;
                                    }
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                this.LOGGER.warn((Object)("Can't handle project '" + project + "': " + e.getMessage()));
            }
        }
        return pojos;
    }

    public InputStream getFile(String filename, URI uri) {
        IWorkspaceRoot root;
        IFile modelFile;
        IContainer modelParent;
        if (uri.isPlatformResource() && (modelParent = (modelFile = (root = ResourcesPlugin.getWorkspace().getRoot()).getFile((IPath)new Path(uri.toPlatformString(false)))).getParent()) instanceof IFolder) {
            IFolder modelDir = (IFolder)modelParent;
            IFile file = modelDir.getFile(filename);
            try {
                return file.getContents();
            }
            catch (CoreException e) {
                this.LOGGER.warn((Object)("Can't handle file '" + filename + "': " + e.getMessage()));
            }
        }
        this.LOGGER.warn((Object)("Can't find file '" + filename + "' in project"));
        return null;
    }

    private String getProjectName(URI uri) {
        int ix;
        if (uri == null) {
            return null;
        }
        String name = uri.toString();
        if (name.startsWith(PREFIX1)) {
            name = name.substring(PLEN1);
        }
        if ((ix = name.indexOf("/")) >= 0) {
            name = name.substring(0, ix);
        }
        return name;
    }
}

