/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.meta.ui.contentassist;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.sqlproc.meta.processorMeta.Artifacts;
import org.sqlproc.meta.processorMeta.Column;
import org.sqlproc.meta.processorMeta.DatabaseProperty;
import org.sqlproc.meta.processorMeta.DriverMethodOutputAssignement;
import org.sqlproc.meta.processorMeta.ExportAssignement;
import org.sqlproc.meta.processorMeta.ExtendedColumnName;
import org.sqlproc.meta.processorMeta.ImportAssignement;
import org.sqlproc.meta.processorMeta.InheritanceAssignement;
import org.sqlproc.meta.processorMeta.ManyToManyAssignement;
import org.sqlproc.meta.processorMeta.MappingColumn;
import org.sqlproc.meta.processorMeta.MappingColumnName;
import org.sqlproc.meta.processorMeta.MappingRule;
import org.sqlproc.meta.processorMeta.MetaStatement;
import org.sqlproc.meta.processorMeta.MetagenProperty;
import org.sqlproc.meta.processorMeta.PojoDefinitionModel;
import org.sqlproc.meta.processorMeta.PojogenProperty;
import org.sqlproc.meta.processorMeta.ProcessorMetaPackage;
import org.sqlproc.meta.processorMeta.ShowColumnTypeAssignement;
import org.sqlproc.meta.processorMeta.TableDefinitionModel;
import org.sqlproc.meta.ui.contentassist.AbstractProcessorMetaProposalProvider;
import org.sqlproc.meta.util.Utils;
import org.sqlproc.plugin.lib.property.ModelProperty;
import org.sqlproc.plugin.lib.property.PojoDefinition;
import org.sqlproc.plugin.lib.property.TableDefinition;
import org.sqlproc.plugin.lib.resolver.DbExport;
import org.sqlproc.plugin.lib.resolver.DbImport;
import org.sqlproc.plugin.lib.resolver.DbResolver;
import org.sqlproc.plugin.lib.resolver.PojoResolver;

public class ProcessorMetaProposalProvider
extends AbstractProcessorMetaProposalProvider {
    @Inject
    private PojoResolver pojoResolver;
    @Inject
    private DbResolver dbResolver;
    @Inject
    private ModelProperty modelProperty;
    private final ArrayList<String> STATEMENT_TYPE = CollectionLiterals.newArrayList((Object[])new String[]{"QRY", "CRUD", "CALL"});
    private final ArrayList<String> MAPPING_TYPE = CollectionLiterals.newArrayList((Object[])new String[]{"OUT"});
    private final ArrayList<String> OPTION_TYPE = CollectionLiterals.newArrayList((Object[])new String[]{"OPT", "LOPT", "IOPT", "SOPT", "BOPT", "MOPT"});
    private final ArrayList<String> TYPES = CollectionLiterals.newArrayList((Object[])new String[]{"int", "integer", "long", "byte", "short", "float", "double", "character", "char", "string", "str", "time", "date", "datetime", "timestamp", "stamp", "bool", "boolean", "bigint", "biginteger", "bigdec", "bigdecimal", "bytearr", "bytearray", "bytes", "text", "blob", "clob", "einteger", "eint", "enumstring", "estring", "fromdate", "todate", "cursor", "other"});
    private final ArrayList<String> MODIFIERS = CollectionLiterals.newArrayList((Object[])new String[]{"any", "null", "notnull", "seq", "seq=", "idsel", "idsel=", "id", "isDef=", "isCall=", "dtype=", "gtype=", "discr"});
    private final ArrayList<String> F_TYPES = CollectionLiterals.newArrayList((Object[])new String[]{"set", "update", "values", "where"});
    private final ArrayList<String> DEBUG_LEVELS = CollectionLiterals.newArrayList((Object[])new String[]{"DEBUG", "INFO", "FATAL", "ERROR", "WARN", "TRACE"});
    private final ArrayList<String> methods = CollectionLiterals.newArrayList((Object[])new String[]{"toString", "hashCode", "equals", "isDef", "toInit", "enumDef", "enumInit", "index", "procId", "enumIndex"});

    @Override
    public void completeMetaStatement_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(this.STATEMENT_TYPE, "STATEMENT_TYPE", context, acceptor, null);
    }

    @Override
    public void completeMappingRule_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(this.MAPPING_TYPE, "MAPPING_TYPE", context, acceptor, null);
    }

    @Override
    public void completeOptionalFeature_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(this.OPTION_TYPE, "OPTION_TYPE", context, acceptor, null);
    }

    public void addProposalList(List<String> values, String lexerRule, ContentAssistContext context, ICompletionProposalAcceptor acceptor, String prefix) {
        if (values != null) {
            Consumer<String> _function = value -> {
                IValueConverterService _valueConverter = this.getValueConverter();
                String _elvis = null;
                _elvis = prefix != null ? prefix : "";
                String _plus = String.valueOf(_elvis) + value;
                String proposal = _valueConverter.toString((Object)_plus, lexerRule);
                ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(_createCompletionProposal);
            };
            values.forEach(_function);
        }
    }

    @Override
    public void completeMetaSql_Ftype(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(this.F_TYPES, "IDENT", context, acceptor, null);
    }

    @Override
    public void completeExtendedColumnName_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String _prefix;
        StringBuilder _append;
        String prefix;
        boolean _completeUsage;
        boolean _not;
        Column column = (Column)EcoreUtil2.getContainerOfType((EObject)model, Column.class);
        StringBuilder partialName = new StringBuilder("");
        EList _columns = null;
        if (column != null) {
            _columns = column.getColumns();
        }
        if (_columns != null) {
            Functions.Function1 _function = it -> {
                boolean _xblockexpression = false;
                ExtendedColumnName _col = it.getCol();
                String _name = _col.getName();
                this.append(partialName, _name);
                _xblockexpression = !Objects.equal((Object)context.getPreviousModel(), null) && it == context.getPreviousModel();
                return _xblockexpression;
            };
            IterableExtensions.findFirst((Iterable)_columns, (Functions.Function1)_function);
        }
        boolean bl = _not = !(_completeUsage = this.completeUsage(model, assignment, context, acceptor, "out", "out", prefix = (_append = this.append(partialName, _prefix = context.getPrefix())).toString(), true));
        if (_not) {
            super.completeExtendedColumnName_Name(model, assignment, context, acceptor);
        }
    }

    @Override
    public void completeConstant_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        String _prefix = context.getPrefix();
        boolean _completeUsage = this.completeUsage(model, assignment, context, acceptor, "const", "const", _prefix, false);
        boolean bl = _not = !_completeUsage;
        if (_not) {
            super.completeConstant_Name(model, assignment, context, acceptor);
        }
    }

    @Override
    public void completeIdentifier_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        String _prefix = context.getPrefix();
        boolean _completeUsage = this.completeUsage(model, assignment, context, acceptor, "in", "in", _prefix, false);
        boolean bl = _not = !_completeUsage;
        if (_not) {
            super.completeIdentifier_Name(model, assignment, context, acceptor);
        }
    }

    public boolean completeUsage(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor, String usageInFilter, String usageInFilterExt, String _prefix, boolean cutPrefix) {
        boolean newPojoValidator;
        PojoDefinition pojoDefinition;
        boolean _equals;
        boolean _notEquals;
        boolean _not;
        boolean _isResolvePojo = this.isResolvePojo(model);
        boolean bl = _not = !_isResolvePojo;
        if (_not) {
            return false;
        }
        MetaStatement metaStatement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)model, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)model, Artifacts.class);
        String pojoName = Utils.getTokenFromModifier((MetaStatement)metaStatement, (String)usageInFilter);
        PojoDefinition _xifexpression = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)pojoName, null);
        if (_notEquals) {
            Map _modelPojos = this.modelProperty.getModelPojos((EObject)artifacts);
            _xifexpression = (PojoDefinition)_modelPojos.get(pojoName);
        }
        if (_equals = Objects.equal(pojoDefinition = _xifexpression, null)) {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString((Object)("Error: I can't load pojo for " + model), "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
            return true;
        }
        int pos = _prefix.lastIndexOf(".");
        String _xifexpression_1 = null;
        _xifexpression_1 = pos > 0 ? _prefix.substring(0, pos + 1) : "";
        String prefix = _xifexpression_1;
        boolean _isOldPojoValidator = this.modelProperty.isOldPojoValidator(model);
        boolean bl3 = newPojoValidator = !_isOldPojoValidator;
        if (newPojoValidator && pojoDefinition.getClassx() instanceof JvmDeclaredType) {
            JvmType _classx = pojoDefinition.getClassx();
            JvmDeclaredType type = (JvmDeclaredType)_classx;
            Iterable<JvmFeature> _allFeatures = this.getAllFeatures(type, _prefix);
            Consumer<JvmFeature> _function = feature -> {
                IValueConverterService _valueConverter_1 = this.getValueConverter();
                String _simpleName = feature.getSimpleName();
                String proposal_1 = _valueConverter_1.toString((Object)_simpleName, "IDENT");
                InputOutput.println((Object)proposal_1);
                ICompletionProposal _createCompletionProposal_1 = this.createCompletionProposal(String.valueOf(prefix) + proposal_1, context);
                acceptor.accept(_createCompletionProposal_1);
            };
            _allFeatures.forEach(_function);
        } else {
            Resource _eResource = model.eResource();
            URI _uRI = null;
            if (_eResource != null) {
                _uRI = _eResource.getURI();
            }
            URI uri = _uRI;
            String _qualifiedName = pojoDefinition.getQualifiedName();
            String clazz = this.getClassName(_qualifiedName, prefix, uri);
            boolean _equals_1 = Objects.equal((Object)clazz, null);
            if (_equals_1) {
                return false;
            }
            PropertyDescriptor[] descriptors = this.pojoResolver.getPropertyDescriptors(clazz, uri);
            boolean _equals_2 = Objects.equal((Object)descriptors, null);
            if (_equals_2) {
                return false;
            }
            Functions.Function1 _function_1 = it -> {
                String _name = it.getName();
                return !Objects.equal((Object)"class", (Object)_name);
            };
            Iterable _filter = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)descriptors)), (Functions.Function1)_function_1);
            Consumer<PropertyDescriptor> _function_2 = descriptor -> {
                IValueConverterService _valueConverter_1 = this.getValueConverter();
                String _name = descriptor.getName();
                String proposal_1 = _valueConverter_1.toString((Object)_name, "IDENT");
                String _xifexpression_2 = null;
                _xifexpression_2 = cutPrefix ? proposal_1 : String.valueOf(prefix) + proposal_1;
                ICompletionProposal _createCompletionProposal_1 = this.createCompletionProposal(_xifexpression_2, context);
                acceptor.accept(_createCompletionProposal_1);
            };
            _filter.forEach(_function_2);
        }
        return true;
    }

    public Iterable<JvmFeature> getAllFeatures(JvmDeclaredType _type, String _prefix) {
        JvmTypeReference _type_2;
        JvmType jvmType;
        JvmFeature _head;
        JvmField field;
        JvmTypeReference _type_1;
        String _substring;
        Iterable features;
        Iterable _xblockexpression = null;
        JvmDeclaredType type = _type;
        int pos = _prefix.lastIndexOf(".");
        if (pos > 0 && !Objects.equal((Object)(features = type.findAllFeaturesByName(_substring = _prefix.substring(0, pos))), null) && !IterableExtensions.isEmpty((Iterable)features) && IterableExtensions.head((Iterable)features) instanceof JvmField && (_type_1 = (field = (JvmField)(_head = (JvmFeature)IterableExtensions.head((Iterable)features))).getType()) instanceof JvmParameterizedTypeReference && (jvmType = ((JvmParameterizedTypeReference)(_type_2 = field.getType())).getType()) instanceof JvmDeclaredType) {
            type = (JvmDeclaredType)jvmType;
        }
        Iterable _allFeatures = type.getAllFeatures();
        Functions.Function1 _function = it -> it instanceof JvmField;
        Iterable _filter = IterableExtensions.filter((Iterable)_allFeatures, (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> {
            boolean _isStatic = it.isStatic();
            return !_isStatic;
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = it -> {
            String _simpleName = it.getSimpleName();
            boolean _startsWith = _simpleName.startsWith("_");
            return !_startsWith;
        };
        _xblockexpression = IterableExtensions.filter((Iterable)_filter_1, (Functions.Function1)_function_2);
        return _xblockexpression;
    }

    @Override
    public void completeMappingColumnName_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean newPojoValidator;
        PojoDefinition pojoDefinition;
        boolean _equals;
        boolean _notEquals;
        boolean _not;
        boolean _isResolvePojo = this.isResolvePojo(model);
        boolean bl = _not = !_isResolvePojo;
        if (_not) {
            super.completeMappingColumnName_Name(model, assignment, context, acceptor);
            return;
        }
        MappingColumn mappingColumn = (MappingColumn)EcoreUtil2.getContainerOfType((EObject)model, MappingColumn.class);
        MappingRule mappingRule = (MappingRule)EcoreUtil2.getContainerOfType((EObject)model, MappingRule.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)model, Artifacts.class);
        String pojoName = Utils.getTokenFromModifier((MappingRule)mappingRule, (String)"out");
        PojoDefinition _xifexpression = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)pojoName, null);
        if (_notEquals) {
            Map _modelPojos = this.modelProperty.getModelPojos((EObject)artifacts);
            _xifexpression = (PojoDefinition)_modelPojos.get(pojoName);
        }
        if (_equals = Objects.equal(pojoDefinition = _xifexpression, null)) {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString((Object)("Error: I can't load pojo for " + model), "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
        }
        StringBuilder partialName = new StringBuilder("");
        boolean cutPrefix = false;
        if (model instanceof MappingColumn && !Objects.equal((Object)mappingColumn, null)) {
            cutPrefix = true;
            EList _items = mappingColumn.getItems();
            Functions.Function1 _function = it -> {
                boolean _xblockexpression = false;
                MappingColumnName _attr = it.getAttr();
                String _name = _attr.getName();
                this.append(partialName, _name);
                _xblockexpression = !Objects.equal((Object)context.getPreviousModel(), null) && it == context.getPreviousModel();
                return _xblockexpression;
            };
            IterableExtensions.findFirst((Iterable)_items, (Functions.Function1)_function);
        }
        String _prefix = context.getPrefix();
        StringBuilder _append = this.append(partialName, _prefix);
        String prefix = _append.toString();
        int pos = prefix.lastIndexOf(".");
        String _xifexpression_1 = null;
        _xifexpression_1 = pos > 0 ? prefix.substring(0, pos + 1) : "";
        String _prefix_1 = _xifexpression_1;
        boolean _cutPrefix = cutPrefix;
        boolean _isOldPojoValidator = this.modelProperty.isOldPojoValidator(model);
        boolean bl3 = newPojoValidator = !_isOldPojoValidator;
        if (newPojoValidator && pojoDefinition.getClassx() instanceof JvmDeclaredType) {
            JvmType _classx = pojoDefinition.getClassx();
            JvmDeclaredType type = (JvmDeclaredType)_classx;
            Iterable<JvmFeature> _allFeatures = this.getAllFeatures(type, _prefix_1);
            Consumer<JvmFeature> _function_1 = feature -> {
                IValueConverterService _valueConverter_1 = this.getValueConverter();
                String _simpleName = feature.getSimpleName();
                String proposal_1 = _valueConverter_1.toString((Object)_simpleName, "IDENT");
                InputOutput.println((Object)proposal_1);
                ICompletionProposal _createCompletionProposal_1 = this.createCompletionProposal(String.valueOf(_prefix_1) + proposal_1, context);
                acceptor.accept(_createCompletionProposal_1);
            };
            _allFeatures.forEach(_function_1);
        } else {
            Resource _eResource = model.eResource();
            URI _uRI = null;
            if (_eResource != null) {
                _uRI = _eResource.getURI();
            }
            URI uri = _uRI;
            String _qualifiedName = pojoDefinition.getQualifiedName();
            String clazz = this.getClassName(_qualifiedName, prefix, uri);
            boolean _equals_1 = Objects.equal((Object)clazz, null);
            if (_equals_1) {
                return;
            }
            PropertyDescriptor[] descriptors = this.pojoResolver.getPropertyDescriptors(clazz, uri);
            boolean _equals_2 = Objects.equal((Object)descriptors, null);
            if (_equals_2) {
                super.completeMappingColumnName_Name(model, assignment, context, acceptor);
            } else {
                Functions.Function1 _function_2 = it -> {
                    String _name = it.getName();
                    return !Objects.equal((Object)"class", (Object)_name);
                };
                Iterable _filter = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)descriptors)), (Functions.Function1)_function_2);
                Consumer<PropertyDescriptor> _function_3 = descriptor -> {
                    IValueConverterService _valueConverter_1 = this.getValueConverter();
                    String _name = descriptor.getName();
                    String proposal_1 = _valueConverter_1.toString((Object)_name, "IDENT");
                    String _xifexpression_2 = null;
                    _xifexpression_2 = _cutPrefix ? proposal_1 : String.valueOf(_prefix_1) + proposal_1;
                    ICompletionProposal _createCompletionProposal_1 = this.createCompletionProposal(_xifexpression_2, context);
                    acceptor.accept(_createCompletionProposal_1);
                };
                _filter.forEach(_function_3);
            }
        }
    }

    public StringBuilder append(StringBuilder sb, String s) {
        boolean _greaterThan;
        StringBuilder _xblockexpression = null;
        int _length = sb.length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            sb.append(".");
        }
        _xblockexpression = sb.append(s);
        return _xblockexpression;
    }

    public boolean isResolvePojo(EObject model) {
        return this.modelProperty.isDoResolvePojo(model);
    }

    public boolean isResolveDb(EObject model) {
        return this.dbResolver.isResolveDb(model);
    }

    public boolean isPrimitive(Class<?> clazz) {
        boolean _equals = Objects.equal(clazz, null);
        if (_equals) {
            return true;
        }
        boolean _equals_1 = Objects.equal(clazz, String.class);
        if (_equals_1) {
            return true;
        }
        boolean _equals_2 = Objects.equal(clazz, java.util.Date.class);
        if (_equals_2) {
            return true;
        }
        boolean _equals_3 = Objects.equal(clazz, Date.class);
        if (_equals_3) {
            return true;
        }
        boolean _equals_4 = Objects.equal(clazz, Time.class);
        if (_equals_4) {
            return true;
        }
        boolean _equals_5 = Objects.equal(clazz, Timestamp.class);
        if (_equals_5) {
            return true;
        }
        boolean _equals_6 = Objects.equal(clazz, Blob.class);
        if (_equals_6) {
            return true;
        }
        boolean _equals_7 = Objects.equal(clazz, Clob.class);
        if (_equals_7) {
            return true;
        }
        boolean _equals_8 = Objects.equal(clazz, BigDecimal.class);
        if (_equals_8) {
            return true;
        }
        boolean _equals_9 = Objects.equal(clazz, BigInteger.class);
        return _equals_9;
    }

    public String getClassName(String baseClass, String property, URI uri) {
        PropertyDescriptor[] descriptors;
        boolean _equals;
        int pos2;
        if (Objects.equal((Object)baseClass, null) || Objects.equal((Object)property, null)) {
            return baseClass;
        }
        int pos1 = property.indexOf(".");
        if (pos1 == -1) {
            return baseClass;
        }
        String checkProperty = property;
        int _indexOf = checkProperty.indexOf("=");
        pos1 = _indexOf;
        if (pos1 > 0 && (pos2 = checkProperty.indexOf(".", pos1)) > pos1) {
            String _plus;
            String _substring = checkProperty.substring(0, pos1);
            String _substring_1 = checkProperty.substring(pos2);
            checkProperty = _plus = String.valueOf(_substring) + _substring_1;
        }
        String innerProperty = null;
        int _indexOf_1 = checkProperty.indexOf(".");
        pos1 = _indexOf_1;
        if (pos1 > 0) {
            String _substring_3;
            String _substring_2;
            innerProperty = _substring_2 = checkProperty.substring(pos1 + 1);
            checkProperty = _substring_3 = checkProperty.substring(0, pos1);
        }
        if (_equals = Objects.equal((Object)(descriptors = this.pojoResolver.getPropertyDescriptors(baseClass, uri)), null)) {
            return null;
        }
        String _checkProperty = checkProperty;
        PropertyDescriptor[] _converted_descriptors = descriptors;
        Functions.Function1 _function = descriptor -> {
            String _name = descriptor.getName();
            return Objects.equal((Object)_name, (Object)_checkProperty);
        };
        PropertyDescriptor innerDesriptor = (PropertyDescriptor)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_descriptors)), (Functions.Function1)_function);
        boolean _equals_1 = Objects.equal((Object)innerDesriptor, null);
        if (_equals_1) {
            return null;
        }
        Class innerClass = innerDesriptor.getPropertyType();
        boolean _isArray = innerClass.isArray();
        if (_isArray) {
            Method _readMethod = innerDesriptor.getReadMethod();
            Type _genericReturnType = _readMethod.getGenericReturnType();
            ParameterizedType type = (ParameterizedType)_genericReturnType;
            if (Objects.equal((Object)type.getActualTypeArguments(), null) || type.getActualTypeArguments().length == 0) {
                return null;
            }
            Type[] _actualTypeArguments = type.getActualTypeArguments();
            Type _head = (Type)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_actualTypeArguments)));
            innerClass = (Class)_head;
            boolean _isPrimitive = this.isPrimitive(innerClass);
            if (_isPrimitive) {
                return null;
            }
            String _name = innerClass.getName();
            return this.getClassName(_name, innerProperty, uri);
        }
        boolean _isAssignableFrom = Collection.class.isAssignableFrom(innerClass);
        if (_isAssignableFrom) {
            Method _readMethod_1 = innerDesriptor.getReadMethod();
            Type _genericReturnType_1 = _readMethod_1.getGenericReturnType();
            ParameterizedType type_1 = (ParameterizedType)_genericReturnType_1;
            if (Objects.equal((Object)type_1.getActualTypeArguments(), null) || type_1.getActualTypeArguments().length == 0) {
                return null;
            }
            Type[] _actualTypeArguments_1 = type_1.getActualTypeArguments();
            Type _head_1 = (Type)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_actualTypeArguments_1)));
            innerClass = (Class)_head_1;
            boolean _isPrimitive_1 = this.isPrimitive(innerClass);
            if (_isPrimitive_1) {
                return null;
            }
            String _name_1 = innerClass.getName();
            return this.getClassName(_name_1, innerProperty, uri);
        }
        boolean _isPrimitive_2 = this.isPrimitive(innerClass);
        if (_isPrimitive_2) {
            return null;
        }
        String _name_2 = innerClass.getName();
        return this.getClassName(_name_2, innerProperty, uri);
    }

    public void acceptTables(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor, String suffix) {
        List _tables = this.dbResolver.getTables(model);
        Functions.Function1 _function = it -> {
            int _indexOf = it.indexOf("$");
            return _indexOf < 0;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_tables, (Functions.Function1)_function);
        Consumer<String> _function_1 = table -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString(table, "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(String.valueOf(proposal) + suffix, context);
            acceptor.accept(_createCompletionProposal);
        };
        _filter.forEach(_function_1);
    }

    public void acceptProcedures(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        List _procedures = this.dbResolver.getProcedures(model);
        Functions.Function1 _function = it -> {
            int _indexOf = it.indexOf("$");
            return _indexOf < 0;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_procedures, (Functions.Function1)_function);
        Consumer<String> _function_1 = table -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString(table, "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
        };
        _filter.forEach(_function_1);
    }

    public void acceptFunctions(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        List _functions = this.dbResolver.getFunctions(model);
        Functions.Function1 _function = it -> {
            int _indexOf = it.indexOf("$");
            return _indexOf < 0;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_functions, (Functions.Function1)_function);
        Consumer<String> _function_1 = table -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString(table, "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
        };
        _filter.forEach(_function_1);
    }

    public void acceptCheckConstraints(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        List _checkConstraints = this.dbResolver.getCheckConstraints(model);
        Functions.Function1 _function = it -> {
            int _indexOf = it.indexOf("$");
            return _indexOf < 0;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_checkConstraints, (Functions.Function1)_function);
        Consumer<String> _function_1 = table -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString(table, "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
        };
        _filter.forEach(_function_1);
    }

    public void acceptSequences(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        List _sequences = this.dbResolver.getSequences(model);
        Functions.Function1 _function = it -> {
            int _indexOf = it.indexOf("$");
            return _indexOf < 0;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_sequences, (Functions.Function1)_function);
        Consumer<String> _function_1 = table -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString(table, "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
        };
        _filter.forEach(_function_1);
    }

    public void acceptColumns(List<String> columns, ContentAssistContext context, ICompletionProposalAcceptor acceptor, String prefix, String suffix) {
        Consumer<String> _function = column -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString(column, "IDENT");
            String _xifexpression = null;
            boolean _notEquals = !Objects.equal((Object)prefix, null);
            _xifexpression = _notEquals ? String.valueOf(prefix) + "." + proposal : proposal;
            String completion = _xifexpression;
            String _xifexpression_1 = null;
            boolean _notEquals_1 = !Objects.equal((Object)suffix, null);
            _xifexpression_1 = _notEquals_1 ? String.valueOf(completion) + suffix : completion;
            completion = _xifexpression_1;
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(completion, context);
            acceptor.accept(_createCompletionProposal);
        };
        columns.forEach(_function);
    }

    @Override
    public void completeTableDefinitionModel_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeTableDefinitionModel_Table(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeProcedureDefinitionModel_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeProcedureDefinitionModel_Table(model, assignment, context, acceptor);
            return;
        }
        this.acceptProcedures(model, context, acceptor);
    }

    @Override
    public void completeFunctionDefinitionModel_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeFunctionDefinitionModel_Table(model, assignment, context, acceptor);
            return;
        }
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void complete_DatabaseColumn(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        TableDefinition tableDefinition;
        boolean _notEquals;
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.complete_DatabaseColumn(model, ruleCall, context, acceptor);
            return;
        }
        String _prefix = context.getPrefix();
        int pos = _prefix.indexOf(".");
        String _xifexpression = null;
        if (pos > 0) {
            String _prefix_1 = context.getPrefix();
            _xifexpression = _prefix_1.substring(0, pos);
        }
        String prefix = _xifexpression;
        MetaStatement metaStatement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)model, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)model, Artifacts.class);
        String value = Utils.getTokenFromModifier((MetaStatement)metaStatement, (String)"tab", (String)prefix);
        TableDefinition _xifexpression_1 = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)value, null);
        if (_notEquals) {
            Map _modelTables = this.modelProperty.getModelTables((EObject)artifacts);
            _xifexpression_1 = (TableDefinition)_modelTables.get(value);
        }
        if (!Objects.equal(tableDefinition = _xifexpression_1, null) && !Objects.equal((Object)tableDefinition.getTable(), null)) {
            String _table = tableDefinition.getTable();
            List _columns = this.dbResolver.getColumns(model, _table);
            this.acceptColumns(_columns, context, acceptor, prefix, null);
        }
    }

    @Override
    public void complete_DatabaseTable(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.complete_DatabaseTable(model, ruleCall, context, acceptor);
            return;
        }
        MetaStatement metaStatement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)model, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)model, Artifacts.class);
        List _tokensFromModifier = Utils.getTokensFromModifier((MetaStatement)metaStatement, (String)"tab");
        Consumer<String> _function = value -> {
            boolean _notEquals;
            Map _modelTables = this.modelProperty.getModelTables((EObject)artifacts);
            TableDefinition tableDefinition = (TableDefinition)_modelTables.get(value);
            boolean bl = _notEquals = !Objects.equal((Object)tableDefinition, null);
            if (_notEquals) {
                IValueConverterService _valueConverter = this.getValueConverter();
                String _table = tableDefinition.getTable();
                String proposal = _valueConverter.toString((Object)_table, "IDENT");
                ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(_createCompletionProposal);
            }
        };
        _tokensFromModifier.forEach(_function);
    }

    @Override
    public void completePojogenProperty_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptCheckConstraints(model, context, acceptor);
    }

    @Override
    public void completePojogenProperty_DbProcedure(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbProcedure(model, assignment, context, acceptor);
            return;
        }
        this.acceptProcedures(model, context, acceptor);
    }

    @Override
    public void completePojogenProperty_DbFunction(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbFunction(model, assignment, context, acceptor);
            return;
        }
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeTableAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeTableAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "->");
    }

    @Override
    public void completeInheritanceAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeInheritanceAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "->");
    }

    @Override
    public void completePojogenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completePojogenProperty_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completePojogenProperty_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeMetagenProperty_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completePojogenProperty_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completePojogenProperty_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, null);
        }
    }

    @Override
    public void completePojogenProperty_DbColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completePojogenProperty_DbColumns(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, null);
        }
    }

    @Override
    public void completeImplementsAssignement_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeImplementsAssignement_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeExtendsAssignement_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeExtendsAssignement_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeImplementsAssignement_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeImplementsAssignement_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeExtendsAssignement_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeExtendsAssignement_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeImplementsAssignementGenerics_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeImplementsAssignementGenerics_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeExtendsAssignementGenerics_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeExtendsAssignementGenerics_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeImplementsAssignementGenerics_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeImplementsAssignementGenerics_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeExtendsAssignementGenerics_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeExtendsAssignementGenerics_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
        this.acceptProcedures(model, context, acceptor);
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeColumnTypeAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, "->");
        } else {
            boolean _notEquals_1;
            String _dbProcedure = prop.getDbProcedure();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_dbProcedure, null);
            if (_notEquals_1) {
                String _dbProcedure_1 = prop.getDbProcedure();
                List _procColumns = this.dbResolver.getProcColumns(model, _dbProcedure_1);
                this.acceptColumns(_procColumns, context, acceptor, null, "->");
            } else {
                boolean _notEquals_2;
                String _dbFunction = prop.getDbFunction();
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)_dbFunction, null);
                if (_notEquals_2) {
                    String _dbFunction_1 = prop.getDbFunction();
                    List _funColumns = this.dbResolver.getFunColumns(model, _dbFunction_1);
                    this.acceptColumns(_funColumns, context, acceptor, null, "->");
                }
            }
        }
    }

    @Override
    public void completeColumnAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completeColumnAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, "->");
            String _dbTable_2 = prop.getDbTable();
            List _checkColumns = this.dbResolver.getCheckColumns(model, _dbTable_2);
            this.acceptColumns(_checkColumns, context, acceptor, null, "->");
        }
    }

    @Override
    public void completeImportAssignement_PkTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof ImportAssignement)) {
            super.completeImportAssignement_PkTable(model, assignment, context, acceptor);
            return;
        }
        ImportAssignement imp = (ImportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (!Objects.equal((Object)prop.getDbTable(), null) && !Objects.equal((Object)imp.getDbColumn(), null)) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)"create-many-to-one", (Object)_name);
            if (_equals) {
                this.acceptTables(model, context, acceptor, "");
            } else {
                String _dbTable = prop.getDbTable();
                List _dbImports = this.dbResolver.getDbImports(model, _dbTable);
                Consumer<DbImport> _function = dbImport -> {
                    if (!Objects.equal((Object)dbImport.getFkColumn(), null) && dbImport.getFkColumn().equals(imp.getDbColumn())) {
                        IValueConverterService _valueConverter = this.getValueConverter();
                        String _pkTable = dbImport.getPkTable();
                        String proposal = _valueConverter.toString((Object)_pkTable, "IDENT");
                        ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
                        acceptor.accept(_createCompletionProposal);
                    }
                };
                _dbImports.forEach(_function);
            }
        }
    }

    @Override
    public void completeImportAssignement_PkColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof ImportAssignement)) {
            super.completeImportAssignement_PkColumn(model, assignment, context, acceptor);
            return;
        }
        ImportAssignement imp = (ImportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (!(Objects.equal((Object)prop.getDbTable(), null) || Objects.equal((Object)imp.getDbColumn(), null) || Objects.equal((Object)imp.getPkTable(), null))) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)"create-many-to-one", (Object)_name);
            if (_equals) {
                String _pkTable = imp.getPkTable();
                List _columns = this.dbResolver.getColumns(model, _pkTable);
                this.acceptColumns(_columns, context, acceptor, null, null);
            } else {
                String _dbTable = prop.getDbTable();
                List _dbImports = this.dbResolver.getDbImports(model, _dbTable);
                Consumer<DbImport> _function = dbImport -> {
                    if (!Objects.equal((Object)dbImport.getFkColumn(), null) && dbImport.getFkColumn().equals(imp.getDbColumn()) && !Objects.equal((Object)dbImport.getPkTable(), null) && dbImport.getPkTable().equals(imp.getPkTable())) {
                        IValueConverterService _valueConverter = this.getValueConverter();
                        String _pkColumn = dbImport.getPkColumn();
                        String proposal = _valueConverter.toString((Object)_pkColumn, "IDENT");
                        ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
                        acceptor.accept(_createCompletionProposal);
                    }
                };
                _dbImports.forEach(_function);
            }
        }
    }

    @Override
    public void completeImportAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completeImportAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, "->");
        }
    }

    @Override
    public void completeExportAssignement_FkTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof ExportAssignement)) {
            super.completeExportAssignement_FkTable(model, assignment, context, acceptor);
            return;
        }
        ExportAssignement exp = (ExportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (!Objects.equal((Object)prop.getDbTable(), null) && !Objects.equal((Object)exp.getDbColumn(), null)) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)"create-one-to-many", (Object)_name);
            if (_equals) {
                this.acceptTables(model, context, acceptor, "");
            } else {
                String _dbTable = prop.getDbTable();
                List _dbExports = this.dbResolver.getDbExports(model, _dbTable);
                Consumer<DbExport> _function = dbExport -> {
                    if (!Objects.equal((Object)dbExport.getPkColumn(), null) && dbExport.getPkColumn().equals(exp.getDbColumn())) {
                        IValueConverterService _valueConverter = this.getValueConverter();
                        String _fkTable = dbExport.getFkTable();
                        String proposal = _valueConverter.toString((Object)_fkTable, "IDENT");
                        ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
                        acceptor.accept(_createCompletionProposal);
                    }
                };
                _dbExports.forEach(_function);
            }
        }
    }

    @Override
    public void completeExportAssignement_FkColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof ExportAssignement)) {
            super.completeExportAssignement_FkColumn(model, assignment, context, acceptor);
            return;
        }
        ExportAssignement exp = (ExportAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (!(Objects.equal((Object)prop.getDbTable(), null) || Objects.equal((Object)exp.getDbColumn(), null) || Objects.equal((Object)exp.getFkTable(), null))) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)"create-one-to-many", (Object)_name);
            if (_equals) {
                String _fkTable = exp.getFkTable();
                List _columns = this.dbResolver.getColumns(model, _fkTable);
                this.acceptColumns(_columns, context, acceptor, null, null);
            } else {
                String _dbTable = prop.getDbTable();
                List _dbExports = this.dbResolver.getDbExports(model, _dbTable);
                Consumer<DbExport> _function = dbExport -> {
                    if (!Objects.equal((Object)dbExport.getPkColumn(), null) && dbExport.getPkColumn().equals(exp.getDbColumn()) && !Objects.equal((Object)dbExport.getFkTable(), null) && dbExport.getFkTable().equals(exp.getFkTable())) {
                        IValueConverterService _valueConverter = this.getValueConverter();
                        String _fkColumn = dbExport.getFkColumn();
                        String proposal = _valueConverter.toString((Object)_fkColumn, "IDENT");
                        ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
                        acceptor.accept(_createCompletionProposal);
                    }
                };
                _dbExports.forEach(_function);
            }
        }
    }

    @Override
    public void completeExportAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completeExportAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, "->");
        }
    }

    @Override
    public void completeManyToManyAssignement_PkColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completeManyToManyAssignement_PkColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, "->");
        }
    }

    @Override
    public void completeManyToManyAssignement_PkTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof ManyToManyAssignement)) {
            super.completeManyToManyAssignement_PkTable(model, assignment, context, acceptor);
            return;
        }
        ManyToManyAssignement many2 = (ManyToManyAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (!Objects.equal((Object)prop.getDbTable(), null) && !Objects.equal((Object)many2.getPkColumn(), null)) {
            String _dbTable = prop.getDbTable();
            List _dbImports = this.dbResolver.getDbImports(model, _dbTable);
            Consumer<DbImport> _function = dbImport -> {
                if (!Objects.equal((Object)dbImport.getPkColumn(), null) && dbImport.getPkColumn().equals(many2.getPkColumn())) {
                    IValueConverterService _valueConverter = this.getValueConverter();
                    String _pkTable = dbImport.getPkTable();
                    String proposal = _valueConverter.toString((Object)_pkTable, "IDENT");
                    ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
                    acceptor.accept(_createCompletionProposal);
                }
            };
            _dbImports.forEach(_function);
        }
    }

    @Override
    public void completeInheritanceAssignement_DbColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof InheritanceAssignement)) {
            super.completeInheritanceAssignement_DbColumns(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, null);
        }
    }

    @Override
    public void completePojogenProperty_Methods(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!(model instanceof PojogenProperty)) {
            super.completePojogenProperty_Methods(model, assignment, context, acceptor);
            return;
        }
        Consumer<String> _function = method -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString(method, "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
        };
        this.methods.forEach(_function);
    }

    @Override
    public void completeShowColumnTypeAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completeShowColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        String _dbTable = prop.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _dbTable_1 = prop.getDbTable();
            List _columns = this.dbResolver.getColumns(model, _dbTable_1);
            this.acceptColumns(_columns, context, acceptor, null, "->");
        } else {
            boolean _notEquals_1;
            String _dbProcedure = prop.getDbProcedure();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_dbProcedure, null);
            if (_notEquals_1) {
                String _dbProcedure_1 = prop.getDbProcedure();
                List _procColumns = this.dbResolver.getProcColumns(model, _dbProcedure_1);
                this.acceptColumns(_procColumns, context, acceptor, null, "->");
            } else {
                boolean _notEquals_2;
                String _dbFunction = prop.getDbFunction();
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)_dbFunction, null);
                if (_notEquals_2) {
                    String _dbFunction_1 = prop.getDbFunction();
                    List _funColumns = this.dbResolver.getFunColumns(model, _dbFunction_1);
                    this.acceptColumns(_funColumns, context, acceptor, null, "->");
                }
            }
        }
    }

    @Override
    public void completeShowColumnTypeAssignement_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals_3;
        boolean _notEquals;
        if (!this.isResolveDb(model) || !(model instanceof ShowColumnTypeAssignement)) {
            super.completeShowColumnTypeAssignement_Type(model, assignment, context, acceptor);
            return;
        }
        ShowColumnTypeAssignement prop = (ShowColumnTypeAssignement)model;
        PojogenProperty prop2 = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        String type = null;
        String _dbTable = prop2.getDbTable();
        boolean bl = _notEquals = !Objects.equal((Object)_dbTable, null);
        if (_notEquals) {
            String _type;
            String _dbTable_1 = prop2.getDbTable();
            String _dbColumn = prop.getDbColumn();
            type = _type = this.dbResolver.getType(model, _dbTable_1, _dbColumn);
        } else {
            boolean _notEquals_1;
            String _dbProcedure = prop2.getDbProcedure();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_dbProcedure, null);
            if (_notEquals_1) {
                String _type_1;
                String _dbProcedure_1 = prop2.getDbProcedure();
                String _dbColumn_1 = prop.getDbColumn();
                type = _type_1 = this.dbResolver.getType(model, _dbProcedure_1, _dbColumn_1);
            } else {
                boolean _notEquals_2;
                String _dbFunction = prop2.getDbFunction();
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)_dbFunction, null);
                if (_notEquals_2) {
                    String _type_2;
                    String _dbFunction_1 = prop2.getDbFunction();
                    String _dbColumn_2 = prop.getDbColumn();
                    type = _type_2 = this.dbResolver.getType(model, _dbFunction_1, _dbColumn_2);
                }
            }
        }
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)type, null);
        if (_notEquals_3) {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString((Object)type, "PropertyValue");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
        }
    }

    @Override
    public void completeJoinTableAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeJoinTableAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "->");
    }

    @Override
    public void completeJoinTableAssignement_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeJoinTableAssignement_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    public Set<PojoDefinitionModel> listPojos(ResourceSet resourceSet, IScope scope) {
        Comparator _function = (o1, o2) -> {
            String _name = o1.getName();
            String _name_1 = o2.getName();
            return _name.compareTo(_name_1);
        };
        TreeSet result = CollectionLiterals.newTreeSet((Comparator)_function, (Object[])new PojoDefinitionModel[0]);
        Iterable _allElements = scope.getAllElements();
        Consumer<IEObjectDescription> _function_1 = description -> {
            URI _eObjectURI = description.getEObjectURI();
            EObject _eObject = resourceSet.getEObject(_eObjectURI, true);
            PojoDefinitionModel pojo = (PojoDefinitionModel)_eObject;
            result.add(pojo);
        };
        _allElements.forEach(_function_1);
        return result;
    }

    public Set<TableDefinitionModel> listTables(ResourceSet resourceSet, IScope scope) {
        Comparator _function = (o1, o2) -> {
            String _name = o1.getName();
            String _name_1 = o2.getName();
            return _name.compareTo(_name_1);
        };
        TreeSet result = CollectionLiterals.newTreeSet((Comparator)_function, (Object[])new TableDefinitionModel[0]);
        Iterable _allElements = scope.getAllElements();
        Consumer<IEObjectDescription> _function_1 = description -> {
            URI _eObjectURI = description.getEObjectURI();
            EObject _eObject = resourceSet.getEObject(_eObjectURI, true);
            TableDefinitionModel table = (TableDefinitionModel)_eObject;
            result.add(table);
        };
        _allElements.forEach(_function_1);
        return result;
    }

    @Override
    public void complete_StatementModifier(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        MetaStatement metaStatement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)model, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)metaStatement, Artifacts.class);
        Resource _eResource = artifacts.eResource();
        ResourceSet _resourceSet = _eResource.getResourceSet();
        IScopeProvider _scopeProvider = this.getScopeProvider();
        IScope _scope = _scopeProvider.getScope((EObject)artifacts, ProcessorMetaPackage.Literals.ARTIFACTS__POJOS);
        Set<PojoDefinitionModel> pojos = this.listPojos(_resourceSet, _scope);
        Consumer<PojoDefinitionModel> _function = pojo -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String _name = pojo.getName();
            String proposal = _valueConverter.toString((Object)_name, "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal("const=" + proposal, context);
            acceptor.accept(_createCompletionProposal);
            ICompletionProposal _createCompletionProposal_1 = this.createCompletionProposal("in=" + proposal, context);
            acceptor.accept(_createCompletionProposal_1);
            ICompletionProposal _createCompletionProposal_2 = this.createCompletionProposal("out=" + proposal, context);
            acceptor.accept(_createCompletionProposal_2);
            ICompletionProposal _createCompletionProposal_3 = this.createCompletionProposal("ix=" + proposal, context);
            acceptor.accept(_createCompletionProposal_3);
        };
        pojos.forEach(_function);
        Resource _eResource_1 = artifacts.eResource();
        ResourceSet _resourceSet_1 = _eResource_1.getResourceSet();
        IScopeProvider _scopeProvider_1 = this.getScopeProvider();
        IScope _scope_1 = _scopeProvider_1.getScope((EObject)artifacts, ProcessorMetaPackage.Literals.ARTIFACTS__TABLES);
        Set<TableDefinitionModel> tables = this.listTables(_resourceSet_1, _scope_1);
        Consumer<TableDefinitionModel> _function_1 = table -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String _name = table.getName();
            String proposal = _valueConverter.toString((Object)_name, "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal("tab=" + proposal, context);
            acceptor.accept(_createCompletionProposal);
        };
        tables.forEach(_function_1);
    }

    @Override
    public void complete_MappingRuleModifier(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        MappingRule mappingRule = (MappingRule)EcoreUtil2.getContainerOfType((EObject)model, MappingRule.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)mappingRule, Artifacts.class);
        Resource _eResource = artifacts.eResource();
        ResourceSet _resourceSet = _eResource.getResourceSet();
        IScopeProvider _scopeProvider = this.getScopeProvider();
        IScope _scope = _scopeProvider.getScope((EObject)artifacts, ProcessorMetaPackage.Literals.ARTIFACTS__POJOS);
        Set<PojoDefinitionModel> pojos = this.listPojos(_resourceSet, _scope);
        Consumer<PojoDefinitionModel> _function = pojo -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String _name = pojo.getName();
            String proposal = _valueConverter.toString((Object)_name, "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal("out=" + proposal, context);
            acceptor.accept(_createCompletionProposal);
        };
        pojos.forEach(_function);
    }

    @Override
    public void complete_Modifier(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(this.TYPES, "IDENT", context, acceptor, "type=");
        this.addProposalList(this.MODIFIERS, "IDENT", context, acceptor, null);
    }

    @Override
    public void complete_MappingItemModifier(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(this.TYPES, "IDENT", context, acceptor, "type=");
        this.addProposalList(this.MODIFIERS, "IDENT", context, acceptor, null);
    }

    @Override
    public void completeMetagenProperty_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbTable(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeMetagenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeMetagenProperty_DbFunction(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbFunction(model, assignment, context, acceptor);
            return;
        }
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeMetagenProperty_DbProcedure(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_DbProcedure(model, assignment, context, acceptor);
            return;
        }
        this.acceptProcedures(model, context, acceptor);
    }

    @Override
    public void completeMetagenProperty_Sequence(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeMetagenProperty_Sequence(model, assignment, context, acceptor);
            return;
        }
        this.acceptSequences(model, context, acceptor);
    }

    @Override
    public void completeMetaTypeAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof MetagenProperty)) {
            super.completeMetaTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        String _dbTable = prop.getDbTable();
        List _columns = this.dbResolver.getColumns(model, _dbTable);
        this.acceptColumns(_columns, context, acceptor, null, null);
    }

    @Override
    public void completeDaogenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDaogenProperty_DbTables(model, assignment, context, acceptor);
            return;
        }
        this.acceptTables(model, context, acceptor, "");
    }

    @Override
    public void completeMetagenProperty_DbColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof MetagenProperty)) {
            super.completeMetagenProperty_DbColumns(model, assignment, context, acceptor);
            return;
        }
        MetagenProperty prop = (MetagenProperty)model;
        String _dbTable = prop.getDbTable();
        List _columns = this.dbResolver.getColumns(model, _dbTable);
        this.acceptColumns(_columns, context, acceptor, null, null);
    }

    @Override
    public void completeDatabaseMetaInfoAssignement_DbMetaInfo(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDatabaseMetaInfoAssignement_DbMetaInfo(model, assignment, context, acceptor);
            return;
        }
        String dbMetaInfo = this.dbResolver.getDbMetaInfo(model);
        boolean bl2 = _notEquals = !Objects.equal((Object)dbMetaInfo, null);
        if (_notEquals) {
            dbMetaInfo = "\"" + dbMetaInfo + "\"";
        }
        IValueConverterService _valueConverter = this.getValueConverter();
        String proposal = _valueConverter.toString((Object)dbMetaInfo, "PropertyValue");
        ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
        acceptor.accept(_createCompletionProposal);
    }

    @Override
    public void completeDriverMetaInfoAssignement_DbDriverInfo(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _notEquals;
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDriverMetaInfoAssignement_DbDriverInfo(model, assignment, context, acceptor);
            return;
        }
        String dbDriverInfo = this.dbResolver.getDbDriverInfo(model);
        boolean bl2 = _notEquals = !Objects.equal((Object)dbDriverInfo, null);
        if (_notEquals) {
            dbDriverInfo = "\"" + dbDriverInfo + "\"";
        }
        IValueConverterService _valueConverter = this.getValueConverter();
        String proposal = _valueConverter.toString((Object)dbDriverInfo, "PropertyValue");
        ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
        acceptor.accept(_createCompletionProposal);
    }

    @Override
    public void completeDriverMethodOutputAssignement_DriverMethod(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof DatabaseProperty)) {
            super.completeDriverMethodOutputAssignement_DriverMethod(model, assignment, context, acceptor);
            return;
        }
        Set _driverMethods = this.dbResolver.getDriverMethods(model);
        Consumer<String> _function = driverMetod -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString(driverMetod, "PropertyValue");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(String.valueOf(proposal) + "->", context);
            acceptor.accept(_createCompletionProposal);
        };
        _driverMethods.forEach(_function);
    }

    @Override
    public void completeDriverMethodOutputAssignement_CallOutput(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) || !(model instanceof DriverMethodOutputAssignement)) {
            super.completeDriverMethodOutputAssignement_CallOutput(model, assignment, context, acceptor);
            return;
        }
        DriverMethodOutputAssignement prop = (DriverMethodOutputAssignement)model;
        Object _elvis = null;
        String _driverMethod = prop.getDriverMethod();
        Object _driverMethodOutput = this.dbResolver.getDriverMethodOutput(model, _driverMethod);
        _elvis = _driverMethodOutput != null ? _driverMethodOutput : "null";
        Object methodCallOutput = _elvis;
        IValueConverterService _valueConverter = this.getValueConverter();
        String proposal = _valueConverter.toString((Object)("\"" + methodCallOutput + "\""), "PropertyValue");
        ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
        acceptor.accept(_createCompletionProposal);
    }

    @Override
    public void completeDatabaseTypeAssignement_DbType(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDatabaseTypeAssignement_DbType(model, assignment, context, acceptor);
            return;
        }
        String dbMetaInfo = this.dbResolver.getDbMetaInfo(model);
        DbResolver.DbType[] _fromDbMetaInfo = DbResolver.DbType.fromDbMetaInfo((String)dbMetaInfo);
        Consumer<DbResolver.DbType> _function = dbType -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String _value = dbType.getValue();
            String proposal = _valueConverter.toString((Object)_value, "PropertyValue");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
        };
        ((List)Conversions.doWrapArray((Object)_fromDbMetaInfo)).forEach(_function);
    }

    @Override
    public void completeDatabaseCatalogAssignement_DbCatalog(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDatabaseCatalogAssignement_DbCatalog(model, assignment, context, acceptor);
            return;
        }
        List _catalogs = this.dbResolver.getCatalogs(model);
        Consumer<String> _function = catalog -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString(catalog, "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
        };
        _catalogs.forEach(_function);
    }

    @Override
    public void completeDatabaseSchemaAssignement_DbSchema(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeDatabaseSchemaAssignement_DbSchema(model, assignment, context, acceptor);
            return;
        }
        List _schemas = this.dbResolver.getSchemas(model);
        Consumer<String> _function = schema -> {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString(schema, "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
        };
        _schemas.forEach(_function);
    }

    @Override
    public void completeDebugLevelAssignement_Debug(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(this.DEBUG_LEVELS, "DEBUG_LEVELS", context, acceptor, null);
    }

    @Override
    public void completeProcedurePojoAssignement_DbProcedure(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeProcedurePojoAssignement_DbProcedure(model, assignment, context, acceptor);
            return;
        }
        this.acceptProcedures(model, context, acceptor);
    }

    @Override
    public void completeFunctionPojoAssignement_DbFunction(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(model);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            super.completeFunctionPojoAssignement_DbFunction(model, assignment, context, acceptor);
            return;
        }
        this.acceptFunctions(model, context, acceptor);
    }

    @Override
    public void completeOrdSql_Ident(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean newPojoValidator;
        PojoDefinition pojoDefinition;
        boolean _equals_1;
        boolean _notEquals;
        boolean _not;
        boolean _isResolvePojo = this.isResolvePojo(model);
        boolean bl = _not = !_isResolvePojo;
        if (_not) {
            super.completeOrdSql_Ident(model, assignment, context, acceptor);
            return;
        }
        MetaStatement metaStatement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)model, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)model, Artifacts.class);
        String pojoName = Utils.getTokenFromModifier((MetaStatement)metaStatement, (String)"ix");
        boolean _equals = Objects.equal((Object)pojoName, null);
        if (_equals) {
            String _tokenFromModifier;
            pojoName = _tokenFromModifier = Utils.getTokenFromModifier((MetaStatement)metaStatement, (String)"in");
        }
        PojoDefinition _xifexpression = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)pojoName, null);
        if (_notEquals) {
            Map _modelPojos = this.modelProperty.getModelPojos((EObject)artifacts);
            _xifexpression = (PojoDefinition)_modelPojos.get(pojoName);
        }
        if (_equals_1 = Objects.equal(pojoDefinition = _xifexpression, null)) {
            IValueConverterService _valueConverter = this.getValueConverter();
            String proposal = _valueConverter.toString((Object)("Error: I can't load pojo for " + model), "IDENT");
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(_createCompletionProposal);
            return;
        }
        boolean _isOldPojoValidator = this.modelProperty.isOldPojoValidator(model);
        boolean bl3 = newPojoValidator = !_isOldPojoValidator;
        if (newPojoValidator && pojoDefinition.getClassx() instanceof JvmDeclaredType) {
            Iterable nestedTypes;
            Founder founder = new Founder();
            JvmType _classx = pojoDefinition.getClassx();
            JvmDeclaredType type = (JvmDeclaredType)_classx;
            Iterable _allFeatures = type.getAllFeatures();
            Functions.Function1 _function = it -> it instanceof JvmField;
            Iterable _filter = IterableExtensions.filter((Iterable)_allFeatures, (Functions.Function1)_function);
            Functions.Function1 _function_1 = it -> it.isStatic();
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function_1);
            Functions.Function1 _function_2 = it -> {
                String _simpleName = it.getSimpleName();
                return _simpleName.startsWith("ORDER_BY_");
            };
            Iterable _filter_2 = IterableExtensions.filter((Iterable)_filter_1, (Functions.Function1)_function_2);
            Consumer<JvmFeature> _function_3 = feature -> {
                founder.found = true;
                IValueConverterService _valueConverter_1 = this.getValueConverter();
                String _simpleName = feature.getSimpleName();
                String _string = _valueConverter_1.toString((Object)_simpleName, "IDENT");
                String proposal_1 = _string.substring(9);
                InputOutput.println((Object)proposal_1);
                ICompletionProposal _createCompletionProposal_1 = this.createCompletionProposal(proposal_1, context);
                acceptor.accept(_createCompletionProposal_1);
            };
            _filter_2.forEach(_function_3);
            if (!founder.found && !Objects.equal((Object)(nestedTypes = type.findAllNestedTypesByName("Order")), null) && !IterableExtensions.isEmpty((Iterable)nestedTypes) && IterableExtensions.head((Iterable)nestedTypes) instanceof JvmEnumerationType) {
                JvmDeclaredType _head = (JvmDeclaredType)IterableExtensions.head((Iterable)nestedTypes);
                JvmEnumerationType enumType = (JvmEnumerationType)_head;
                Iterable _allFeatures_1 = enumType.getAllFeatures();
                Functions.Function1 _function_4 = it -> it instanceof JvmEnumerationLiteral;
                Iterable _filter_3 = IterableExtensions.filter((Iterable)_allFeatures_1, (Functions.Function1)_function_4);
                Consumer<JvmFeature> _function_5 = feature -> {
                    IValueConverterService _valueConverter_1 = this.getValueConverter();
                    String _simpleName = feature.getSimpleName();
                    String proposal_1 = _valueConverter_1.toString((Object)_simpleName, "IDENT");
                    InputOutput.println((Object)proposal_1);
                    ICompletionProposal _createCompletionProposal_1 = this.createCompletionProposal(proposal_1, context);
                    acceptor.accept(_createCompletionProposal_1);
                };
                _filter_3.forEach(_function_5);
            }
        } else {
            boolean _notEquals_1;
            Resource _eResource = model.eResource();
            URI _uRI = null;
            if (_eResource != null) {
                _uRI = _eResource.getURI();
            }
            URI uri = _uRI;
            String clazz = pojoDefinition.getQualifiedName();
            Map orders = this.pojoResolver.getOrders(clazz, uri);
            boolean bl4 = _notEquals_1 = !Objects.equal((Object)orders, null);
            if (_notEquals_1) {
                Collection _values = orders.values();
                Consumer<String> _function_6 = order -> {
                    IValueConverterService _valueConverter_1 = this.getValueConverter();
                    String proposal_1 = _valueConverter_1.toString(order, "IDENT");
                    ICompletionProposal _createCompletionProposal_1 = this.createCompletionProposal(proposal_1, context);
                    acceptor.accept(_createCompletionProposal_1);
                };
                _values.forEach(_function_6);
            }
        }
    }

    public static class Founder {
        private boolean found = false;
    }
}

