/*
 * generated by Xtext
 */
package org.sqlproc.meta.ui.contentassist

import static org.sqlproc.plugin.lib.util.Constants.*

import java.lang.reflect.ParameterizedType
import java.util.Collection
import java.util.List
import java.util.Set

import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.resource.ResourceSet
import org.eclipse.xtext.Assignment
import org.eclipse.xtext.RuleCall
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor
import org.sqlproc.meta.processorMeta.Artifacts
import org.sqlproc.meta.processorMeta.Column
import org.sqlproc.meta.processorMeta.DatabaseProperty
import org.sqlproc.meta.processorMeta.DriverMethodOutputAssignement
import org.sqlproc.meta.processorMeta.ExportAssignement
import org.sqlproc.meta.processorMeta.ImportAssignement
import org.sqlproc.meta.processorMeta.InheritanceAssignement
import org.sqlproc.meta.processorMeta.ManyToManyAssignement
import org.sqlproc.meta.processorMeta.MappingColumn
import org.sqlproc.meta.processorMeta.MappingRule
import org.sqlproc.meta.processorMeta.MetaStatement
import org.sqlproc.meta.processorMeta.MetagenProperty
import org.sqlproc.meta.processorMeta.PojoDefinitionModel
import org.sqlproc.meta.processorMeta.PojogenProperty
import org.sqlproc.meta.processorMeta.ProcessorMetaPackage
import org.sqlproc.meta.processorMeta.ShowColumnTypeAssignement
import org.sqlproc.meta.processorMeta.TableDefinitionModel
import org.sqlproc.meta.util.Utils
import org.sqlproc.plugin.lib.resolver.DbResolver.DbType

import com.google.inject.Inject

import static extension org.eclipse.xtext.EcoreUtil2.*
import org.eclipse.emf.common.util.URI
import org.sqlproc.plugin.lib.resolver.PojoResolver
import org.sqlproc.plugin.lib.resolver.DbResolver
import org.sqlproc.plugin.lib.property.ModelProperty
import org.eclipse.xtext.common.types.JvmDeclaredType
import org.eclipse.xtext.common.types.JvmField
import org.eclipse.xtext.common.types.JvmFeature
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference
import org.eclipse.xtext.common.types.JvmType
import org.eclipse.xtext.common.types.JvmEnumerationType
import org.eclipse.xtext.common.types.JvmEnumerationLiteral
import org.sqlproc.plugin.lib.property.PojoDefinition

/**
 * see http://www.eclipse.org/Xtext/documentation.html#contentAssist on how to customize content assistant
 */
class ProcessorMetaProposalProvider extends AbstractProcessorMetaProposalProvider {

	@Inject
	PojoResolver pojoResolver

	@Inject
	DbResolver dbResolver

    @Inject
    ModelProperty modelProperty;

	val STATEMENT_TYPE = <String>newArrayList("QRY", "CRUD", "CALL")
	val MAPPING_TYPE = <String>newArrayList("OUT")
	val OPTION_TYPE = <String>newArrayList("OPT", "LOPT", "IOPT", "SOPT", "BOPT", "MOPT")
	val TYPES = <String>newArrayList("int", "integer", "long", "byte", "short",
            "float", "double", "character", "char", "string", "str", "time", "date", "datetime", "timestamp", "stamp",
            "bool", "boolean", "bigint", "biginteger", "bigdec", "bigdecimal", "bytearr", "bytearray", "bytes", "text",
            "blob", "clob", "einteger", "eint", "enumstring", "estring", "fromdate", "todate", "cursor", "other"
	)
    val MODIFIERS = <String>newArrayList("any", "null", "notnull", "seq", "seq=",
            "idsel", "idsel=", "id", "isDef=", "isCall=", "dtype=", "gtype=", "discr")
    val F_TYPES = <String>newArrayList("set", "update", "values", "where")
    val DEBUG_LEVELS = <String>newArrayList("DEBUG", "INFO", "FATAL", "ERROR", "WARN", "TRACE")

    override completeMetaStatement_Type(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        addProposalList(STATEMENT_TYPE, "STATEMENT_TYPE", context, acceptor, null)
    }

    override completeMappingRule_Type(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        addProposalList(MAPPING_TYPE, "MAPPING_TYPE", context, acceptor, null)
    }

    override completeOptionalFeature_Type(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        addProposalList(OPTION_TYPE, "OPTION_TYPE", context, acceptor, null)
    }

    def addProposalList(List<String> values, String lexerRule, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor, String prefix) {
        values?.forEach[value |
            val proposal = getValueConverter().toString((prefix ?: "") + value, lexerRule)
            acceptor.accept(createCompletionProposal(proposal, context))
        ]
    }

    override completeMetaSql_Ftype(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        addProposalList(F_TYPES, "IDENT", context, acceptor, null)
    }

    override completeExtendedColumnName_Name(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        val column = model.getContainerOfType(typeof(Column)) 
        val partialName = new StringBuilder("")
        column?.columns?.findFirst[
            append(partialName, col.name)
            context.previousModel != null && it === context.previousModel
        ]
        val prefix = append(partialName, context.prefix).toString()
        if (!completeUsage(model, assignment, context, acceptor, COLUMN_USAGE, COLUMN_USAGE_EXTENDED, prefix, true))
            super.completeExtendedColumnName_Name(model, assignment, context, acceptor)
    }

    override completeConstant_Name(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!completeUsage(model, assignment, context, acceptor, CONSTANT_USAGE, CONSTANT_USAGE_EXTENDED, context.prefix, false))
            super.completeConstant_Name(model, assignment, context, acceptor)
    }

    override completeIdentifier_Name(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!completeUsage(model, assignment, context, acceptor, IDENTIFIER_USAGE, IDENTIFIER_USAGE_EXTENDED, context.prefix,
                false))
            super.completeIdentifier_Name(model, assignment, context, acceptor)
    }

    def boolean completeUsage(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor, String usageInFilter, String usageInFilterExt, String _prefix,
            boolean cutPrefix) {
        if (!isResolvePojo(model))
            return false
        val metaStatement = model.getContainerOfType(typeof(MetaStatement))
        val artifacts = model.getContainerOfType(typeof(Artifacts))

        val pojoName = Utils.getTokenFromModifier(metaStatement, usageInFilter)
        val PojoDefinition pojoDefinition = if (pojoName != null) modelProperty.getModelPojos(artifacts).get(pojoName)

        if (pojoDefinition == null) {
            val proposal = getValueConverter().toString("Error: I can't load pojo for " + model, "IDENT")
            acceptor.accept(createCompletionProposal(proposal, context))
            return true
        }

        val pos = _prefix.lastIndexOf('.')
		val prefix = if (pos > 0) _prefix.substring(0, pos + 1) else ""
		
		val boolean newPojoValidator = !modelProperty.isOldPojoValidator(model)
		if (newPojoValidator && pojoDefinition.classx instanceof JvmDeclaredType) {
			val JvmDeclaredType type = pojoDefinition.classx as JvmDeclaredType
	        getAllFeatures(type, _prefix).forEach[feature |
				val proposal = getValueConverter().toString(feature.simpleName, "IDENT")
				println(proposal)
				acceptor.accept(createCompletionProposal(prefix + proposal, context))
	        ]
		}
		else {
		    val URI uri = model.eResource?.URI
	        val clazz = getClassName(pojoDefinition.qualifiedName, prefix, uri)
	        if (clazz == null)
	        	return false
	        val descriptors = pojoResolver.getPropertyDescriptors(clazz, uri)
	        if (descriptors == null)
	        	return false
	        descriptors.filter["class" != name].forEach[descriptor |
				val proposal = getValueConverter().toString(descriptor.getName(), "IDENT")
				acceptor.accept(createCompletionProposal(if (cutPrefix) proposal else prefix + proposal, context))
	        ]
        }
        return true
    }
    
    def Iterable<JvmFeature> getAllFeatures(JvmDeclaredType _type, String _prefix) {
    	var JvmDeclaredType type = _type
        val pos = _prefix.lastIndexOf('.')
		if (pos > 0) {
	        val Iterable<JvmFeature> features = type.findAllFeaturesByName(_prefix.substring(0, pos))
        	if (features != null && !features.empty && (features.head instanceof JvmField)) {
	        	var JvmField field = features.head as JvmField
        		if (field.type instanceof JvmParameterizedTypeReference) {
	        		val JvmType jvmType = (field.type as JvmParameterizedTypeReference).type
	        		if (jvmType instanceof JvmDeclaredType)
	        			type = jvmType as JvmDeclaredType
	        	}
        	}
		}
		type.allFeatures.filter[it instanceof JvmField].filter[!static].filter[!simpleName.startsWith("_")]
    }

    override completeMappingColumnName_Name(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolvePojo(model)) {
            super.completeMappingColumnName_Name(model, assignment, context, acceptor)
            return
        }
        
        val mappingColumn = model.getContainerOfType(typeof(MappingColumn))
        val mappingRule = model.getContainerOfType(typeof(MappingRule))
        val artifacts = model.getContainerOfType(typeof(Artifacts))

        val pojoName = Utils.getTokenFromModifier(mappingRule, MAPPING_USAGE)
        val pojoDefinition = if (pojoName != null) modelProperty.getModelPojos(artifacts).get(pojoName)

        if (pojoDefinition == null) {
            val proposal = getValueConverter().toString("Error: I can't load pojo for " + model, "IDENT")
            acceptor.accept(createCompletionProposal(proposal, context))
        }

        val partialName = new StringBuilder("")
        var cutPrefix = false
        if (model instanceof MappingColumn && mappingColumn != null) {
            cutPrefix = true
            mappingColumn.items.findFirst[
            	append(partialName, attr.name)
	            context.previousModel != null && it === context.previousModel
            ]
        }
        var prefix = append(partialName, context.prefix).toString()
        val pos = prefix.lastIndexOf('.')
        val _prefix = if (pos > 0) prefix.substring(0, pos + 1) else ""
        val _cutPrefix = cutPrefix

		val boolean newPojoValidator = !modelProperty.isOldPojoValidator(model)
		if (newPojoValidator && pojoDefinition.classx instanceof JvmDeclaredType) {
			val JvmDeclaredType type = pojoDefinition.classx as JvmDeclaredType
	        getAllFeatures(type, _prefix).forEach[feature |
				val proposal = getValueConverter().toString(feature.simpleName, "IDENT")
				println(proposal)
				acceptor.accept(createCompletionProposal(_prefix + proposal, context))
	        ]
		}
		else {
	        val URI uri = model.eResource?.URI
            val clazz = getClassName(pojoDefinition.qualifiedName, prefix, uri)
            if (clazz == null)
                return
            val descriptors = pojoResolver.getPropertyDescriptors(clazz, uri)
            if (descriptors == null) {
                super.completeMappingColumnName_Name(model, assignment, context, acceptor)
            } else {
	            descriptors.filter["class" != name].forEach[descriptor |
					val proposal = getValueConverter().toString(descriptor.getName(), "IDENT")
					acceptor.accept(createCompletionProposal(if (_cutPrefix) proposal else _prefix + proposal, context))
            	]
            }
        }
    }
    
    def append(StringBuilder sb, String s) {
    	if (sb.length > 0)
    		sb.append(".")
    	sb.append(s)
    }

    def boolean isResolvePojo(EObject model) {
        modelProperty.isDoResolvePojo(model)
    }

    def boolean isResolveDb(EObject model) {
        dbResolver.isResolveDb(model)
    }

    def isPrimitive(Class<?> clazz) {
        if (clazz == null)
            return true
        if (clazz == typeof(String))
            return true
        if (clazz == typeof(java.util.Date))
            return true
        if (clazz == typeof(java.sql.Date))
            return true
        if (clazz == typeof(java.sql.Time))
            return true
        if (clazz == typeof(java.sql.Timestamp))
            return true
        if (clazz == typeof(java.sql.Blob))
            return true
        if (clazz == typeof(java.sql.Clob))
            return true
        if (clazz == typeof(java.math.BigDecimal))
            return true
        if (clazz == typeof(java.math.BigInteger))
            return true
        return false
    }

    def String getClassName(String baseClass, String property, URI uri) {
        if (baseClass == null || property == null)
            return baseClass
        var pos1 = property.indexOf('.')
        if (pos1 == -1)
            return baseClass
        var checkProperty = property
        pos1 = checkProperty.indexOf('=')
        if (pos1 > 0) {
            var pos2 = checkProperty.indexOf('.', pos1)
            if (pos2 > pos1)
                checkProperty = checkProperty.substring(0, pos1) + checkProperty.substring(pos2)
        }
        var innerProperty = null as String
        pos1 = checkProperty.indexOf('.')
        if (pos1 > 0) {
            innerProperty = checkProperty.substring(pos1 + 1)
            checkProperty = checkProperty.substring(0, pos1)
        }
        var descriptors = pojoResolver.getPropertyDescriptors(baseClass, uri)
        if (descriptors == null)
            return null
        val _checkProperty = checkProperty
        var innerDesriptor = descriptors.findFirst[descriptor |
        	descriptor.name == _checkProperty
        ]
        if (innerDesriptor == null)
            return null
        var innerClass = innerDesriptor.getPropertyType()
        if (innerClass.isArray()) {
            var type = innerDesriptor.getReadMethod().getGenericReturnType() as ParameterizedType
            if (type.getActualTypeArguments() == null || type.getActualTypeArguments().length == 0)
                return null
            innerClass = type.getActualTypeArguments().head as Class<?>
            if (isPrimitive(innerClass))
                return null
            return getClassName(innerClass.getName(), innerProperty, uri)
        } else if (typeof(Collection).isAssignableFrom(innerClass)) {
            var type = innerDesriptor.getReadMethod().getGenericReturnType() as ParameterizedType
            if (type.getActualTypeArguments() == null || type.getActualTypeArguments().length == 0)
                return null
            innerClass = type.getActualTypeArguments().head as Class<?>
            if (isPrimitive(innerClass))
                return null
            return getClassName(innerClass.getName(), innerProperty, uri)
        } else {
            if (isPrimitive(innerClass))
                return null
            return getClassName(innerClass.getName(), innerProperty, uri)
        }
    }

	def acceptTables(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor, String suffix) {
        dbResolver.getTables(model).filter[indexOf('$') < 0].forEach[table |
            val proposal = getValueConverter().toString(table, "IDENT")
            acceptor.accept(createCompletionProposal(proposal + suffix, context))
        ]
	}

	def acceptProcedures(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        dbResolver.getProcedures(model).filter[indexOf('$') < 0].forEach[table |
            val proposal = getValueConverter().toString(table, "IDENT")
            acceptor.accept(createCompletionProposal(proposal, context))
        ]
	}

	def acceptFunctions(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        dbResolver.getFunctions(model).filter[indexOf('$') < 0].forEach[table |
            val proposal = getValueConverter().toString(table, "IDENT")
            acceptor.accept(createCompletionProposal(proposal, context))
        ]
	}

	def acceptCheckConstraints(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        dbResolver.getCheckConstraints(model).filter[indexOf('$') < 0].forEach[table |
            val proposal = getValueConverter().toString(table, "IDENT")
            acceptor.accept(createCompletionProposal(proposal, context))
        ]
	}

	def acceptSequences(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        dbResolver.getSequences(model).filter[indexOf('$') < 0].forEach[table |
            val proposal = getValueConverter().toString(table, "IDENT")
            acceptor.accept(createCompletionProposal(proposal, context))
        ]
	}

	def acceptColumns(List<String> columns, ContentAssistContext context, ICompletionProposalAcceptor acceptor, String prefix, String suffix) {
        columns.forEach[column |
        	val proposal = getValueConverter().toString(column, "IDENT")
            var completion = if (prefix != null) prefix + '.' + proposal else proposal
            completion = if (suffix != null) completion + suffix else completion
            acceptor.accept(createCompletionProposal(completion, context))
        ]
	}

    override completeTableDefinitionModel_Table(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeTableDefinitionModel_Table(model, assignment, context, acceptor)
            return
        }
        acceptTables(model, context, acceptor, "")
    }

    override completeProcedureDefinitionModel_Table(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeProcedureDefinitionModel_Table(model, assignment, context, acceptor)
            return
        }
        acceptProcedures(model, context, acceptor)
    }

    override completeFunctionDefinitionModel_Table(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeFunctionDefinitionModel_Table(model, assignment, context, acceptor)
            return
        }
        acceptFunctions(model, context, acceptor)
    }

    override complete_DatabaseColumn(EObject model, RuleCall ruleCall, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.complete_DatabaseColumn(model, ruleCall, context, acceptor)
            return
        }
        val pos = context.prefix.indexOf('.')
        val prefix = if (pos > 0) context.prefix.substring(0, pos)
        val metaStatement = model.getContainerOfType(typeof(MetaStatement))
        val artifacts = model.getContainerOfType(typeof(Artifacts))
        val value = Utils.getTokenFromModifier(metaStatement, TABLE_USAGE, prefix)
        val tableDefinition = if (value != null) modelProperty.getModelTables(artifacts).get(value)
        if (tableDefinition != null && tableDefinition.table != null) {
        	acceptColumns(dbResolver.getColumns(model, tableDefinition.table), context, acceptor, prefix, null)
        }
    }

    override complete_DatabaseTable(EObject model, RuleCall ruleCall, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.complete_DatabaseTable(model, ruleCall, context, acceptor)
            return
        }
        val metaStatement = model.getContainerOfType(typeof(MetaStatement))
        val artifacts = model.getContainerOfType(typeof(Artifacts))
        Utils.getTokensFromModifier(metaStatement, TABLE_USAGE).forEach[value |
            val tableDefinition = modelProperty.getModelTables(artifacts).get(value)
            if (tableDefinition != null) {
                val proposal = getValueConverter().toString(tableDefinition.getTable(), "IDENT")
                acceptor.accept(createCompletionProposal(proposal, context))
            }
        ]
    }

    override completePojogenProperty_DbTable(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completePojogenProperty_DbTable(model, assignment, context, acceptor)
            return
        }
        acceptTables(model, context, acceptor, "")
        acceptCheckConstraints(model, context, acceptor)
    }

    override completePojogenProperty_DbProcedure(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completePojogenProperty_DbProcedure(model, assignment, context, acceptor)
            return
        }
        acceptProcedures(model, context, acceptor)
    }

    override completePojogenProperty_DbFunction(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completePojogenProperty_DbFunction(model, assignment, context, acceptor)
            return
        }
        acceptFunctions(model, context, acceptor)
    }

    override completeTableAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeTableAssignement_DbTable(model, assignment, context, acceptor)
            return
        }
        acceptTables(model, context, acceptor, "->")
    }

    override completeInheritanceAssignement_DbTable(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeInheritanceAssignement_DbTable(model, assignment, context, acceptor)
            return
        }
        acceptTables(model, context, acceptor, "->")
    }
    
    override completePojogenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completePojogenProperty_DbTables(model, assignment, context, acceptor)
            return
        }
        acceptTables(model, context, acceptor, "")
    }

    override completePojogenProperty_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completePojogenProperty_DbNotTables(model, assignment, context, acceptor)
            return
        }
        acceptTables(model, context, acceptor, "")
    }

    override completeMetagenProperty_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeMetagenProperty_DbNotTables(model, assignment, context, acceptor)
            return
        }
        acceptTables(model, context, acceptor, "")
    }

    override completePojogenProperty_DbColumn(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completePojogenProperty_DbColumn(model, assignment, context, acceptor)
            return
        }
        val prop = model as PojogenProperty
        if (prop.dbTable != null) {
        	acceptColumns(dbResolver.getColumns(model, prop.dbTable), context, acceptor, null, null)
        }
    }

    override completePojogenProperty_DbColumns(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completePojogenProperty_DbColumns(model, assignment, context, acceptor)
            return
        }
        val prop = model as PojogenProperty
        if (prop.dbTable != null) {
        	acceptColumns(dbResolver.getColumns(model, prop.dbTable), context, acceptor, null, null)
        }
    }

    override completeImplementsAssignement_DbTables(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeImplementsAssignement_DbTables(model, assignment, context, acceptor)
            return
        }
        acceptTables(model, context, acceptor, "")
        acceptProcedures(model, context, acceptor)
        acceptFunctions(model, context, acceptor)
    }

    override completeExtendsAssignement_DbTables(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeExtendsAssignement_DbTables(model, assignment, context, acceptor)
            return
        }
        acceptTables(model, context, acceptor, "")
        acceptProcedures(model, context, acceptor)
        acceptFunctions(model, context, acceptor)
    }

    override completeImplementsAssignement_DbNotTables(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeImplementsAssignement_DbNotTables(model, assignment, context, acceptor)
            return
        }
        acceptTables(model, context, acceptor, "")
        acceptProcedures(model, context, acceptor)
        acceptFunctions(model, context, acceptor)
    }

    override completeExtendsAssignement_DbNotTables(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeExtendsAssignement_DbNotTables(model, assignment, context, acceptor)
            return
        }
        acceptTables(model, context, acceptor, "")
        acceptProcedures(model, context, acceptor)
        acceptFunctions(model, context, acceptor)
    }

    override completeImplementsAssignementGenerics_DbTables(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeImplementsAssignementGenerics_DbTables(model, assignment, context, acceptor)
            return
        }
        acceptTables(model, context, acceptor, "")
        acceptProcedures(model, context, acceptor)
        acceptFunctions(model, context, acceptor)
    }

    override completeExtendsAssignementGenerics_DbTables(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeExtendsAssignementGenerics_DbTables(model, assignment, context, acceptor)
            return
        }
        acceptTables(model, context, acceptor, "")
        acceptProcedures(model, context, acceptor)
        acceptFunctions(model, context, acceptor)
    }

    override completeImplementsAssignementGenerics_DbNotTables(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeImplementsAssignementGenerics_DbNotTables(model, assignment, context, acceptor)
            return
        }
        acceptTables(model, context, acceptor, "")
        acceptProcedures(model, context, acceptor)
        acceptFunctions(model, context, acceptor)
    }

    override completeExtendsAssignementGenerics_DbNotTables(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeExtendsAssignementGenerics_DbNotTables(model, assignment, context, acceptor)
            return
        }
        acceptTables(model, context, acceptor, "")
        acceptProcedures(model, context, acceptor)
        acceptFunctions(model, context, acceptor)
    }

    override completeColumnTypeAssignement_DbColumn(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor)
            return
        }
        val prop = model as PojogenProperty
        if (prop.getDbTable() != null) {
        	acceptColumns(dbResolver.getColumns(model, prop.dbTable), context, acceptor, null, "->")
        } else if (prop.getDbProcedure() != null) {
        	acceptColumns(dbResolver.getProcColumns(model, prop.dbProcedure), context, acceptor, null, "->")
        } else if (prop.getDbFunction() != null) {
        	acceptColumns(dbResolver.getFunColumns(model, prop.dbFunction), context, acceptor, null, "->")
        }
    }

    override completeColumnAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completeColumnAssignement_DbColumn(model, assignment, context, acceptor)
            return
        }
        val prop = model as PojogenProperty
        if (prop.getDbTable() != null) {
        	acceptColumns(dbResolver.getColumns(model, prop.dbTable), context, acceptor, null, "->")
        	acceptColumns(dbResolver.getCheckColumns(model, prop.dbTable), context, acceptor, null, "->")
        }
    }

    override completeImportAssignement_PkTable(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model) || !(model instanceof ImportAssignement)) {
            super.completeImportAssignement_PkTable(model, assignment, context, acceptor)
            return
        }
        val imp = model as ImportAssignement
        val prop = model.getContainerOfType(typeof(PojogenProperty))
        if (prop.getDbTable() != null && imp.getDbColumn() != null) {
            if ("create-many-to-one" == prop.name) {
            	acceptTables(model, context, acceptor, "")
            } else {
                dbResolver.getDbImports(model, prop.getDbTable()).forEach[dbImport |
                    if (dbImport.getFkColumn() != null && dbImport.getFkColumn().equals(imp.getDbColumn())) {
                        val proposal = getValueConverter().toString(dbImport.getPkTable(), "IDENT")
                        acceptor.accept(createCompletionProposal(proposal, context))
                    }
                ]
            }
        }
    }

    override completeImportAssignement_PkColumn(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model) || !(model instanceof ImportAssignement)) {
            super.completeImportAssignement_PkColumn(model, assignment, context, acceptor)
            return
        }
        val imp = model as ImportAssignement
        val prop = model.getContainerOfType(typeof(PojogenProperty))
        if (prop.getDbTable() != null && imp.getDbColumn() != null && imp.getPkTable() != null) {
            if ("create-many-to-one" == prop.name) {
            	acceptColumns(dbResolver.getColumns(model, imp.getPkTable()), context, acceptor, null, null)
            } else {
                dbResolver.getDbImports(model, prop.getDbTable()).forEach[dbImport |
                    if (dbImport.getFkColumn() != null && dbImport.getFkColumn().equals(imp.getDbColumn())) {
                        if (dbImport.getPkTable() != null && dbImport.getPkTable().equals(imp.getPkTable())) {
                            val proposal = getValueConverter().toString(dbImport.getPkColumn(), "IDENT")
                            acceptor.accept(createCompletionProposal(proposal, context))
                        }
                    }
                ]
            }
        }
    }

    override completeImportAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completeImportAssignement_DbColumn(model, assignment, context, acceptor)
            return
        }
        val prop = model as PojogenProperty
        if (prop.getDbTable() != null) {
        	acceptColumns(dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, "->")
        }
    }

    override completeExportAssignement_FkTable(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model) || !(model instanceof ExportAssignement)) {
            super.completeExportAssignement_FkTable(model, assignment, context, acceptor)
            return
        }
        val exp = model as ExportAssignement
        val prop = model.getContainerOfType(typeof(PojogenProperty))
        if (prop.getDbTable() != null && exp.getDbColumn() != null) {
            if ("create-one-to-many" == prop.name) {
            	acceptTables(model, context, acceptor, "")
            } else {
                dbResolver.getDbExports(model, prop.getDbTable()).forEach[dbExport |
                    if (dbExport.getPkColumn() != null && dbExport.getPkColumn().equals(exp.getDbColumn())) {
                        val proposal = getValueConverter().toString(dbExport.getFkTable(), "IDENT")
                        acceptor.accept(createCompletionProposal(proposal, context))
                    }
                ]
            }
        }
    }

    override completeExportAssignement_FkColumn(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model) || !(model instanceof ExportAssignement)) {
            super.completeExportAssignement_FkColumn(model, assignment, context, acceptor)
            return
        }
        val exp = model as ExportAssignement
        val prop = model.getContainerOfType(typeof(PojogenProperty))
        if (prop.getDbTable() != null && exp.getDbColumn() != null && exp.getFkTable() != null) {
            if ("create-one-to-many" == prop.name) {
            	acceptColumns(dbResolver.getColumns(model, exp.getFkTable()), context, acceptor, null, null)
            } else {
                dbResolver.getDbExports(model, prop.getDbTable()).forEach[dbExport |
                    if (dbExport.getPkColumn() != null && dbExport.getPkColumn().equals(exp.getDbColumn())) {
                        if (dbExport.getFkTable() != null && dbExport.getFkTable().equals(exp.getFkTable())) {
                            val proposal = getValueConverter().toString(dbExport.getFkColumn(), "IDENT")
                            acceptor.accept(createCompletionProposal(proposal, context))
                        }
                    }
                ]
            }
        }
    }

    override completeExportAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completeExportAssignement_DbColumn(model, assignment, context, acceptor)
            return
        }
        val prop = model as PojogenProperty
        if (prop.getDbTable() != null) {
        	acceptColumns(dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, "->")
        }
    }

    override completeManyToManyAssignement_PkColumn(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completeManyToManyAssignement_PkColumn(model, assignment, context, acceptor)
            return
        }
        val prop = model as PojogenProperty
        if (prop.getDbTable() != null) {
        	acceptColumns(dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, "->")
        }
    }

    override completeManyToManyAssignement_PkTable(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model) || !(model instanceof ManyToManyAssignement)) {
            super.completeManyToManyAssignement_PkTable(model, assignment, context, acceptor)
            return
        }
        val many2 = model as ManyToManyAssignement
        val prop = model.getContainerOfType(typeof(PojogenProperty))
        if (prop.getDbTable() != null && many2.getPkColumn() != null) {
            dbResolver.getDbImports(model, prop.getDbTable()).forEach[dbImport |
                if (dbImport.getPkColumn() != null && dbImport.getPkColumn().equals(many2.getPkColumn())) {
                    val proposal = getValueConverter().toString(dbImport.getPkTable(), "IDENT")
                    acceptor.accept(createCompletionProposal(proposal, context))
                }
            ]
        }
    }

    override completeInheritanceAssignement_DbColumns(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model) || !(model instanceof InheritanceAssignement)) {
            super.completeInheritanceAssignement_DbColumns(model, assignment, context, acceptor)
            return
        }
        val prop = model.getContainerOfType(typeof(PojogenProperty))
        if (prop.getDbTable() != null) {
        	acceptColumns(dbResolver.getColumns(model, prop.getDbTable()), context, acceptor, null, null)
        }
    }

    val methods = newArrayList("toString", "hashCode", "equals", "isDef", "toInit", "enumDef",
            "enumInit", "index", "procId", "enumIndex")

    override completePojogenProperty_Methods(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!(model instanceof PojogenProperty)) {
            super.completePojogenProperty_Methods(model, assignment, context, acceptor)
            return
        }
        methods.forEach[method |
            val proposal = getValueConverter().toString(method, "IDENT")
            acceptor.accept(createCompletionProposal(proposal, context))
        ]
    }

    override completeShowColumnTypeAssignement_DbColumn(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model) || !(model instanceof PojogenProperty)) {
            super.completeShowColumnTypeAssignement_DbColumn(model, assignment, context, acceptor)
            return
        }
        val prop = model as PojogenProperty
        if (prop.getDbTable() != null) {
        	acceptColumns(dbResolver.getColumns(model, prop.dbTable), context, acceptor, null, "->")
        } else if (prop.getDbProcedure() != null) {
        	acceptColumns(dbResolver.getProcColumns(model, prop.dbProcedure), context, acceptor, null, "->")
        } else if (prop.getDbFunction() != null) {
        	acceptColumns(dbResolver.getFunColumns(model, prop.dbFunction), context, acceptor, null, "->")
        }
    }

    override completeShowColumnTypeAssignement_Type(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model) || !(model instanceof ShowColumnTypeAssignement)) {
            super.completeShowColumnTypeAssignement_Type(model, assignment, context, acceptor)
            return
        }
        val prop = model as ShowColumnTypeAssignement
        val prop2 = model.getContainerOfType(typeof(PojogenProperty))
        var type = null as String
        if (prop2.getDbTable() != null) {
            type = dbResolver.getType(model, prop2.getDbTable(), prop.getDbColumn())
        } else if (prop2.getDbProcedure() != null) {
            type = dbResolver.getType(model, prop2.getDbProcedure(), prop.getDbColumn())
        } else if (prop2.getDbFunction() != null) {
            type = dbResolver.getType(model, prop2.getDbFunction(), prop.getDbColumn())
        }
        if (type != null) {
            val proposal = getValueConverter().toString(type, "PropertyValue")
            acceptor.accept(createCompletionProposal(proposal, context))
        }
    }

    override completeJoinTableAssignement_DbTable(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeJoinTableAssignement_DbTable(model, assignment, context, acceptor)
            return
        }
		acceptTables(model, context, acceptor, "->")
    }

    override completeJoinTableAssignement_DbTables(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeJoinTableAssignement_DbTables(model, assignment, context, acceptor)
            return
        }
		acceptTables(model, context, acceptor, "")
    }
    
    def Set<PojoDefinitionModel> listPojos(ResourceSet resourceSet, IScope scope) {
        val result = <PojoDefinitionModel>newTreeSet[o1, o2 | o1.name.compareTo(o2.name)]
        scope.getAllElements().forEach[description |
            val pojo = resourceSet.getEObject(description.getEObjectURI(), true) as PojoDefinitionModel
            result.add(pojo)
        ]
        return result
    }

    def Set<TableDefinitionModel> listTables(ResourceSet resourceSet, IScope scope) {
        val result = <TableDefinitionModel>newTreeSet[o1, o2 | o1.name.compareTo(o2.name)]
        scope.getAllElements().forEach[description |
            val table = resourceSet.getEObject(description.getEObjectURI(), true) as TableDefinitionModel
            result.add(table)
        ]
        return result
    }

    override complete_StatementModifier(EObject model, RuleCall ruleCall, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        val metaStatement = model.getContainerOfType(typeof(MetaStatement))
        val artifacts = metaStatement.getContainerOfType(typeof(Artifacts))
        val pojos = listPojos(artifacts.eResource().getResourceSet(),
                getScopeProvider().getScope(artifacts, ProcessorMetaPackage.Literals.ARTIFACTS__POJOS))
        pojos.forEach[pojo |
            val proposal = getValueConverter().toString(pojo.getName(), "IDENT")
            acceptor.accept(createCompletionProposal(CONSTANT_USAGE + "=" + proposal, context))
            acceptor.accept(createCompletionProposal(IDENTIFIER_USAGE + "=" + proposal, context))
            acceptor.accept(createCompletionProposal(COLUMN_USAGE + "=" + proposal, context))
            acceptor.accept(createCompletionProposal(INDEX_USAGE + "=" + proposal, context))
        ]
        val tables = listTables(artifacts.eResource().getResourceSet(),
                getScopeProvider().getScope(artifacts, ProcessorMetaPackage.Literals.ARTIFACTS__TABLES))
        tables.forEach[table |
            val proposal = getValueConverter().toString(table.getName(), "IDENT")
            acceptor.accept(createCompletionProposal(TABLE_USAGE + "=" + proposal, context))
        ]
    }

    override complete_MappingRuleModifier(EObject model, RuleCall ruleCall, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        val mappingRule = model.getContainerOfType(typeof(MappingRule))
        val artifacts = mappingRule.getContainerOfType(typeof(Artifacts))
        val pojos = listPojos(artifacts.eResource().getResourceSet(),
                getScopeProvider().getScope(artifacts, ProcessorMetaPackage.Literals.ARTIFACTS__POJOS))
        pojos.forEach[pojo |
            val proposal = getValueConverter().toString(pojo.getName(), "IDENT")
            acceptor.accept(createCompletionProposal(MAPPING_USAGE + "=" + proposal, context))
        ]
    }

    override complete_Modifier(EObject model, RuleCall ruleCall, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        addProposalList(TYPES, "IDENT", context, acceptor, "type=")
        addProposalList(MODIFIERS, "IDENT", context, acceptor, null)
    }

    override complete_MappingItemModifier(EObject model, RuleCall ruleCall, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        addProposalList(TYPES, "IDENT", context, acceptor, "type=")
        addProposalList(MODIFIERS, "IDENT", context, acceptor, null)
    }

    override completeMetagenProperty_DbTable(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeMetagenProperty_DbTable(model, assignment, context, acceptor)
            return
        }
		acceptTables(model, context, acceptor, "")
    }

    override completeMetagenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeMetagenProperty_DbTables(model, assignment, context, acceptor)
            return
        }
		acceptTables(model, context, acceptor, "")
    }

    override completeMetagenProperty_DbFunction(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeMetagenProperty_DbFunction(model, assignment, context, acceptor)
            return
        }
		acceptFunctions(model, context, acceptor)
    }

    override completeMetagenProperty_DbProcedure(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeMetagenProperty_DbProcedure(model, assignment, context, acceptor)
            return
        }
		acceptProcedures(model, context, acceptor)
    }

    override completeMetagenProperty_Sequence(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeMetagenProperty_Sequence(model, assignment, context, acceptor)
            return
        }
		acceptSequences(model, context, acceptor)
    }

    override completeMetaTypeAssignement_DbColumn(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model) || !(model instanceof MetagenProperty)) {
            super.completeMetaTypeAssignement_DbColumn(model, assignment, context, acceptor)
            return
        }
        val prop = model as PojogenProperty
        acceptColumns(dbResolver.getColumns(model, prop.dbTable), context, acceptor, null, null)
    }

    override completeDaogenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeDaogenProperty_DbTables(model, assignment, context, acceptor)
            return
        }
		acceptTables(model, context, acceptor, "")
    }

    override completeMetagenProperty_DbColumns(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model) || !(model instanceof MetagenProperty)) {
            super.completeMetagenProperty_DbColumns(model, assignment, context, acceptor)
            return
        }
        val prop = model as MetagenProperty
        acceptColumns(dbResolver.getColumns(model, prop.dbTable), context, acceptor, null, null)
    }

	override completeDatabaseMetaInfoAssignement_DbMetaInfo(EObject model, Assignment assignment,
		ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		if (!isResolveDb(model)) {
			super.completeDatabaseMetaInfoAssignement_DbMetaInfo(model, assignment, context, acceptor)
			return
		}
		var String dbMetaInfo = dbResolver.getDbMetaInfo(model)
		if (dbMetaInfo != null)
			dbMetaInfo = '"'+dbMetaInfo+'"'
		val proposal = getValueConverter().toString(dbMetaInfo, "PropertyValue")
		acceptor.accept(createCompletionProposal(proposal, context))
	}

	override completeDriverMetaInfoAssignement_DbDriverInfo(EObject model, Assignment assignment,
		ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		if (!isResolveDb(model)) {
			super.completeDriverMetaInfoAssignement_DbDriverInfo(model, assignment, context, acceptor)
			return
		}
		var String dbDriverInfo = dbResolver.getDbDriverInfo(model)
		if (dbDriverInfo != null)
			dbDriverInfo = '"'+dbDriverInfo+'"'
		val proposal = getValueConverter().toString(dbDriverInfo, "PropertyValue")
		acceptor.accept(createCompletionProposal(proposal, context))
	}

	override completeDriverMethodOutputAssignement_DriverMethod(EObject model, Assignment assignment,
		ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		if (!isResolveDb(model) || !(model instanceof DatabaseProperty)) {
			super.completeDriverMethodOutputAssignement_DriverMethod(model, assignment, context, acceptor)
			return
		}
		dbResolver.getDriverMethods(model).forEach [ driverMetod |
			val proposal = getValueConverter().toString(driverMetod, "PropertyValue")
			acceptor.accept(createCompletionProposal(proposal + "->", context))
		]
	}

	override completeDriverMethodOutputAssignement_CallOutput(EObject model, Assignment assignment,
		ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
		if (!isResolveDb(model) || !(model instanceof DriverMethodOutputAssignement)) {
			super.completeDriverMethodOutputAssignement_CallOutput(model, assignment, context, acceptor)
			return
		}
		val prop = model as DriverMethodOutputAssignement
		var methodCallOutput = dbResolver.getDriverMethodOutput(model, prop.getDriverMethod()) ?: "null"
		val proposal = getValueConverter().toString('"' + methodCallOutput + '"', "PropertyValue")
		acceptor.accept(createCompletionProposal(proposal, context))
	}

    override completeDatabaseTypeAssignement_DbType(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeDatabaseTypeAssignement_DbType(model, assignment, context, acceptor)
            return
        }
        val dbMetaInfo = dbResolver.getDbMetaInfo(model)
        DbType.fromDbMetaInfo(dbMetaInfo).forEach[dbType |
            val proposal = getValueConverter().toString(dbType.getValue(), "PropertyValue")
            acceptor.accept(createCompletionProposal(proposal, context))
        ]
    }

    override completeDatabaseCatalogAssignement_DbCatalog(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeDatabaseCatalogAssignement_DbCatalog(model, assignment, context, acceptor)
            return
        }
        dbResolver.getCatalogs(model).forEach[catalog |
            val proposal = getValueConverter().toString(catalog, "IDENT")
            acceptor.accept(createCompletionProposal(proposal, context))
        ]
    }

    override completeDatabaseSchemaAssignement_DbSchema(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeDatabaseSchemaAssignement_DbSchema(model, assignment, context, acceptor)
            return
        }
        dbResolver.getSchemas(model).forEach[schema |
            val proposal = getValueConverter().toString(schema, "IDENT")
            acceptor.accept(createCompletionProposal(proposal, context))
        ]
    }

    override completeDebugLevelAssignement_Debug(EObject model, Assignment assignment, ContentAssistContext context,
            ICompletionProposalAcceptor acceptor) {
        addProposalList(DEBUG_LEVELS, "DEBUG_LEVELS", context, acceptor, null)
    }

    override completeProcedurePojoAssignement_DbProcedure(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeProcedurePojoAssignement_DbProcedure(model, assignment, context, acceptor)
            return
        }
		acceptProcedures(model, context, acceptor)
    }

    override completeFunctionPojoAssignement_DbFunction(EObject model, Assignment assignment,
            ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolveDb(model)) {
            super.completeFunctionPojoAssignement_DbFunction(model, assignment, context, acceptor)
            return
        }
		acceptFunctions(model, context, acceptor)
    }

	static class Founder {
		boolean found = false 
	}
	
	override completeOrdSql_Ident(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!isResolvePojo(model)) {
            super.completeOrdSql_Ident(model, assignment, context, acceptor)
            return
        }
        val metaStatement = model.getContainerOfType(typeof(MetaStatement))
        val artifacts = model.getContainerOfType(typeof(Artifacts))

        var pojoName = Utils.getTokenFromModifier(metaStatement, INDEX_USAGE)
        if (pojoName == null)
        	pojoName =  Utils.getTokenFromModifier(metaStatement, IDENTIFIER_USAGE)
        val pojoDefinition = if (pojoName != null) modelProperty.getModelPojos(artifacts).get(pojoName)

        if (pojoDefinition == null) {
            val proposal = getValueConverter().toString("Error: I can't load pojo for " + model, "IDENT")
            acceptor.accept(createCompletionProposal(proposal, context))
            return
        }

		val boolean newPojoValidator = !modelProperty.isOldPojoValidator(model)
		if (newPojoValidator && pojoDefinition.classx instanceof JvmDeclaredType) {
			val Founder founder = new Founder()
			val JvmDeclaredType type = pojoDefinition.classx as JvmDeclaredType
			type.allFeatures.filter[it instanceof JvmField].filter[static].filter[simpleName.startsWith("ORDER_BY_")].forEach[feature |
				founder.found = true
				val proposal = getValueConverter().toString(feature.simpleName, "IDENT").substring(9)
				println(proposal)
				acceptor.accept(createCompletionProposal(proposal, context))
	        ]
	        if (!founder.found) {
	        	val Iterable<JvmDeclaredType> nestedTypes = type.findAllNestedTypesByName("Order");
	        	if (nestedTypes != null && !nestedTypes.empty && (nestedTypes.head instanceof JvmEnumerationType)) {
			        val JvmEnumerationType enumType = nestedTypes.head as JvmEnumerationType
		        	enumType.allFeatures.filter[it instanceof JvmEnumerationLiteral].forEach[feature |
						val proposal = getValueConverter().toString(feature.simpleName, "IDENT")
						println(proposal)
						acceptor.accept(createCompletionProposal(proposal, context))
		        	]
	        	}
	        }
		}
		else {
	        val URI uri = model.eResource?.URI
            val clazz = pojoDefinition.qualifiedName
            val orders = pojoResolver.getOrders(clazz, uri)
            if (orders != null) {
            	orders.values.forEach[order |
					val proposal = getValueConverter().toString(order, "IDENT")
					acceptor.accept(createCompletionProposal(proposal, context))
            	]
            }
        }
	}
}
