/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.meta.ui.outline;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineFilterAndSorter;

@Singleton
public class FixedOutlineFilterAndSorter
extends OutlineFilterAndSorter {
    private OutlineFilterAndSorter.IComparator comparator;

    public IOutlineNode[] filterAndSort(Iterable<IOutlineNode> nodes) {
        final Iterable enabledFilters = this.getEnabledFilters();
        Iterable filteredNodes = null;
        filteredNodes = Iterables.isEmpty((Iterable)enabledFilters) ? nodes : Iterables.filter(nodes, (Predicate)new Predicate<IOutlineNode>(){

            public boolean apply(final IOutlineNode node) {
                return Iterables.all((Iterable)enabledFilters, (Predicate)new Predicate<OutlineFilterAndSorter.IFilter>(){

                    public boolean apply(OutlineFilterAndSorter.IFilter filter) {
                        return filter.apply((Object)node);
                    }
                });
            }
        });
        IOutlineNode[] nodesAsArray = (IOutlineNode[])Iterables.toArray(filteredNodes, IOutlineNode.class);
        if (this.comparator != null && this.comparator.isEnabled()) {
            Arrays.sort(nodesAsArray, this.comparator);
        }
        return nodesAsArray;
    }

    public void setComparator(OutlineFilterAndSorter.IComparator comparator) {
        this.comparator = comparator;
    }
}

