/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.plugin.lib.resolver;

import com.google.inject.Singleton;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.sqlproc.plugin.lib.resolver.PojoResolver;
import org.sqlproc.plugin.lib.util.MainUtils;

@Singleton
public class StandalonePojoResolverImpl
implements PojoResolver {
    protected Logger LOGGER = Logger.getLogger(StandalonePojoResolverImpl.class);
    String source;

    public StandalonePojoResolverImpl(String source) {
        this.source = source;
    }

    @Override
    public Class<?> loadClass(String name, URI uri) {
        this.LOGGER.info((Object)("loadClass, name=" + name + ", uri=" + uri));
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(name);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.LOGGER.warn((Object)("Can't find class '" + name));
            return null;
        }
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors(String name, URI uri) {
        Class<?> beanClass = this.loadClass(name, uri);
        if (beanClass == null) {
            return null;
        }
        PropertyDescriptor[] descriptors = null;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
        descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        return descriptors;
    }

    @Override
    public Map<String, String> getOrders(String name, URI uri) {
        int n;
        int n2;
        Field[] fieldArray;
        Class<?> beanClass = this.loadClass(name, uri);
        if (beanClass == null) {
            return null;
        }
        HashMap<String, String> orders = new HashMap<String, String>();
        while (beanClass != null) {
            Field[] fields = beanClass.getFields();
            fieldArray = fields;
            n2 = fields.length;
            n = 0;
            while (n < n2) {
                Field f = fieldArray[n];
                if (Modifier.isStatic(f.getModifiers())) {
                    try {
                        if (f.getType() == Integer.TYPE) {
                            orders.put(f.getName(), "" + f.getInt(null));
                        } else if (f.getType() == String.class) {
                            orders.put(f.getName(), (String)f.get(null));
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException exception) {
                        // empty catch block
                    }
                }
                ++n;
            }
            beanClass = beanClass.getSuperclass();
        }
        beanClass = this.loadClass(name, uri);
        Class<?> orderBeanClass = this.loadClass(String.valueOf(name) + "$Order", uri);
        while (orderBeanClass != null && orderBeanClass.isEnum()) {
            fieldArray = orderBeanClass.getEnumConstants();
            n2 = fieldArray.length;
            n = 0;
            while (n < n2) {
                Field en = fieldArray[n];
                String ename = ((Object)en).toString();
                orders.put(ename, ename);
                ++n;
            }
            if ((beanClass = beanClass.getSuperclass()) == null) break;
            orderBeanClass = this.loadClass(String.valueOf(beanClass.getName()) + "$Order", uri);
        }
        return orders;
    }

    @Override
    public List<Class<?>> getPojoClasses(URI uri) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public InputStream getFile(String filename, URI uri) {
        File file = new File(MainUtils.getFile(this.source, filename));
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.LOGGER.warn((Object)("Can't find file '" + filename + "' in project"));
            return null;
        }
    }
}

