/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.meta.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.sqlproc.meta.processorMeta.AnnotationDefinitionModel;
import org.sqlproc.meta.processorMeta.Artifacts;
import org.sqlproc.meta.processorMeta.Column;
import org.sqlproc.meta.processorMeta.Constant;
import org.sqlproc.meta.processorMeta.DatabaseColumn;
import org.sqlproc.meta.processorMeta.DatabaseTable;
import org.sqlproc.meta.processorMeta.ExtendedColumn;
import org.sqlproc.meta.processorMeta.FunctionDefinitionModel;
import org.sqlproc.meta.processorMeta.Identifier;
import org.sqlproc.meta.processorMeta.IfSql;
import org.sqlproc.meta.processorMeta.IfSqlFragment;
import org.sqlproc.meta.processorMeta.MappingColumn;
import org.sqlproc.meta.processorMeta.MappingRule;
import org.sqlproc.meta.processorMeta.MetaSql;
import org.sqlproc.meta.processorMeta.MetaStatement;
import org.sqlproc.meta.processorMeta.OptionalFeature;
import org.sqlproc.meta.processorMeta.OrdSql;
import org.sqlproc.meta.processorMeta.PojoDefinitionModel;
import org.sqlproc.meta.processorMeta.ProcedureDefinitionModel;
import org.sqlproc.meta.processorMeta.ProcessorMetaPackage;
import org.sqlproc.meta.processorMeta.Property;
import org.sqlproc.meta.processorMeta.SqlFragment;
import org.sqlproc.meta.processorMeta.TableDefinitionModel;
import org.sqlproc.meta.util.Utils;
import org.sqlproc.meta.validation.AbstractProcessorMetaValidator;
import org.sqlproc.meta.validation.ValidationResult;
import org.sqlproc.plugin.lib.property.ModelProperty;
import org.sqlproc.plugin.lib.property.PojoDefinition;
import org.sqlproc.plugin.lib.property.TableDefinition;
import org.sqlproc.plugin.lib.resolver.DbResolver;
import org.sqlproc.plugin.lib.resolver.PojoResolver;
import org.sqlproc.plugin.lib.resolver.PojoResolverFactory;
import org.sqlproc.plugin.lib.util.CommonUtils;

public class ProcessorMetaValidator
extends AbstractProcessorMetaValidator {
    @Inject
    private PojoResolverFactory pojoResolverFactory;
    @Inject
    private DbResolver dbResolver;
    @Inject
    private ModelProperty modelProperty;
    private final HashSet<String> F_TYPES = CollectionLiterals.newHashSet((Object[])new String[]{"set", "update", "values", "where", "columns", "set=opt", "where=opt"});

    @Check
    public void checkMetaSqlFtype(MetaSql metaSql) {
        String _ftype = metaSql.getFtype();
        boolean _equals = Objects.equal((Object)_ftype, null);
        if (_equals) {
            return;
        }
        boolean _skipVerification = CommonUtils.skipVerification(metaSql, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        if (!Objects.equal((Object)metaSql.getFtype(), null) && !this.F_TYPES.contains(metaSql.getFtype().toLowerCase())) {
            String _ftype_1 = metaSql.getFtype();
            String _plus = "Invalid ftype : " + _ftype_1;
            this.error(_plus, (EStructuralFeature)ProcessorMetaPackage.Literals.META_SQL__FTYPE);
        }
    }

    @Check
    public void checkUniqueMetaStatement(MetaStatement metaStatement) {
        boolean _skipVerification = CommonUtils.skipVerification(metaStatement, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(metaStatement);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<MetaStatement> _statements = artifacts.getStatements();
        for (MetaStatement metaStmt : _statements) {
            boolean _equalsStatement;
            if (Objects.equal((Object)metaStmt, null) || metaStmt == metaStatement || !(_equalsStatement = this.equalsStatement(metaStatement, metaStmt))) continue;
            String _name = metaStatement.getName();
            String _plus = "Duplicate name : " + _name;
            String _plus_1 = String.valueOf(_plus) + "[";
            String _type = metaStatement.getType();
            String _plus_2 = String.valueOf(_plus_1) + _type;
            String _plus_3 = String.valueOf(_plus_2) + "]";
            this.error(_plus_3, (EStructuralFeature)ProcessorMetaPackage.Literals.META_STATEMENT__NAME);
            return;
        }
    }

    public boolean equalsStatement(MetaStatement statement1, MetaStatement statement2) {
        if (Objects.equal((Object)statement1, null) && Objects.equal((Object)statement2, null)) {
            return true;
        }
        if (Objects.equal((Object)statement1, null) || Objects.equal((Object)statement1.getName(), null)) {
            return false;
        }
        if (Objects.equal((Object)statement2, null) || Objects.equal((Object)statement2.getName(), null)) {
            return false;
        }
        if (statement1.getName().equals(statement2.getName()) && statement1.getType().equals(statement2.getType())) {
            return this.equalsModifiers((List<String>)statement1.getModifiers(), (List<String>)statement2.getModifiers());
        }
        return false;
    }

    @Check
    public void checkUniqueMappingRule(MappingRule mappingRule) {
        boolean _skipVerification = CommonUtils.skipVerification(mappingRule, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(mappingRule);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<MappingRule> _mappings = artifacts.getMappings();
        for (MappingRule rule : _mappings) {
            boolean _equalsRule;
            if (Objects.equal((Object)rule, null) || rule == mappingRule || !(_equalsRule = this.equalsRule(mappingRule, rule))) continue;
            String _name = mappingRule.getName();
            String _plus = "Duplicate name : " + _name;
            String _plus_1 = String.valueOf(_plus) + "[";
            String _type = mappingRule.getType();
            String _plus_2 = String.valueOf(_plus_1) + _type;
            String _plus_3 = String.valueOf(_plus_2) + "]";
            this.error(_plus_3, (EStructuralFeature)ProcessorMetaPackage.Literals.MAPPING_RULE__NAME);
            return;
        }
    }

    public boolean equalsRule(MappingRule rule1, MappingRule rule2) {
        if (Objects.equal((Object)rule1, null) && Objects.equal((Object)rule2, null)) {
            return true;
        }
        if (Objects.equal((Object)rule1, null) || Objects.equal((Object)rule1.getName(), null)) {
            return false;
        }
        if (Objects.equal((Object)rule2, null) || Objects.equal((Object)rule2.getName(), null)) {
            return false;
        }
        if (rule1.getName().equals(rule2.getName()) && rule1.getType().equals(rule2.getType())) {
            return this.equalsModifiers((List<String>)rule1.getModifiers(), (List<String>)rule2.getModifiers());
        }
        return false;
    }

    @Check
    public void checkUniqueOptionalFeature(OptionalFeature optionalFeature) {
        boolean _skipVerification = CommonUtils.skipVerification(optionalFeature, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(optionalFeature);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<OptionalFeature> _features = artifacts.getFeatures();
        for (OptionalFeature feature : _features) {
            boolean _equalsFeature;
            if (Objects.equal((Object)feature, null) || Objects.equal((Object)feature, (Object)optionalFeature) || !(_equalsFeature = this.equalsFeature(optionalFeature, feature))) continue;
            String _name = optionalFeature.getName();
            String _plus = "Duplicate name : " + _name;
            String _plus_1 = String.valueOf(_plus) + "[";
            String _type = optionalFeature.getType();
            String _plus_2 = String.valueOf(_plus_1) + _type;
            String _plus_3 = String.valueOf(_plus_2) + "]";
            this.error(_plus_3, (EStructuralFeature)ProcessorMetaPackage.Literals.OPTIONAL_FEATURE__NAME);
            return;
        }
    }

    public boolean equalsFeature(OptionalFeature feature1, OptionalFeature feature2) {
        if (Objects.equal((Object)feature1, null) && Objects.equal((Object)feature2, null)) {
            return true;
        }
        if (Objects.equal((Object)feature1, null) || Objects.equal((Object)feature1.getName(), null)) {
            return false;
        }
        if (Objects.equal((Object)feature2, null) || Objects.equal((Object)feature2.getName(), null)) {
            return false;
        }
        if (feature1.getName().equals(feature2.getName()) && feature1.getType().equals(feature2.getType())) {
            return this.equalsModifiers((List<String>)feature1.getModifiers(), (List<String>)feature2.getModifiers());
        }
        return false;
    }

    @Check
    public void checkUniquePojoDefinition(PojoDefinitionModel pojoDefinition) {
        boolean _skipVerification = CommonUtils.skipVerification(pojoDefinition, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(pojoDefinition);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<PojoDefinitionModel> _pojos = artifacts.getPojos();
        for (PojoDefinitionModel definition : _pojos) {
            boolean _equals_1;
            if (Objects.equal((Object)definition, null) || definition == pojoDefinition || !(_equals_1 = pojoDefinition.getName().equals(definition.getName()))) continue;
            String _name = pojoDefinition.getName();
            String _plus = "Duplicate name : " + _name;
            this.error(_plus, (EStructuralFeature)ProcessorMetaPackage.Literals.POJO_DEFINITION_MODEL__NAME);
            return;
        }
    }

    @Check
    public void checkUniqueAnnotationDefinition(AnnotationDefinitionModel annotationDefinition) {
        boolean _skipVerification = CommonUtils.skipVerification(annotationDefinition, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(annotationDefinition);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<AnnotationDefinitionModel> _annotations = artifacts.getAnnotations();
        for (AnnotationDefinitionModel definition : _annotations) {
            boolean _equals_1;
            if (Objects.equal((Object)definition, null) || definition == annotationDefinition || !(_equals_1 = annotationDefinition.getName().equals(definition.getName()))) continue;
            String _name = annotationDefinition.getName();
            String _plus = "Duplicate name : " + _name;
            this.error(_plus, (EStructuralFeature)ProcessorMetaPackage.Literals.ANNOTATION_DEFINITION_MODEL__NAME);
            return;
        }
    }

    @Check
    public void checkUniqueProperty(Property property) {
        boolean _skipVerification = CommonUtils.skipVerification(property, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(property);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<Property> _properties = artifacts.getProperties();
        for (Property prop : _properties) {
            if (Objects.equal((Object)prop, null) || prop == property || !prop.getName().equals(property.getName()) || prop.getName().startsWith("pojogen") || prop.getName().startsWith("database") || prop.getName().startsWith("metagen") || prop.getName().startsWith("daogen") || prop.getName().startsWith("replace-text")) continue;
            String _name = property.getName();
            String _plus = "Duplicate name : " + _name;
            this.error(_plus, (EStructuralFeature)ProcessorMetaPackage.Literals.PROPERTY__NAME);
            return;
        }
    }

    public boolean equalsModifiers(List<String> modifiers1, List<String> modifiers2) {
        List<String> filteredModifiers1 = this.filteredModifiers(modifiers1);
        List<String> filteredModifiers2 = this.filteredModifiers(modifiers2);
        if (Objects.equal(filteredModifiers1, null) && Objects.equal(filteredModifiers2, null)) {
            return true;
        }
        boolean _equals = Objects.equal(filteredModifiers1, null);
        if (_equals) {
            return false;
        }
        boolean _equals_1 = Objects.equal(filteredModifiers2, null);
        if (_equals_1) {
            return false;
        }
        if (filteredModifiers1.isEmpty() && filteredModifiers2.isEmpty()) {
            return true;
        }
        for (String modifier1 : filteredModifiers1) {
            for (String modifier2 : filteredModifiers2) {
                boolean _equals_2 = modifier1.equals(modifier2);
                if (!_equals_2) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> filteredModifiers(List<String> modifiers) {
        boolean _equals = Objects.equal(modifiers, null);
        if (_equals) {
            return null;
        }
        final ArrayList filteredModifiers = CollectionLiterals.newArrayList();
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String modifier) {
                boolean _lessThan;
                int _indexOf = modifier.indexOf("=");
                boolean bl = _lessThan = _indexOf < 0;
                if (_lessThan) {
                    filteredModifiers.add(modifier);
                }
            }
        };
        modifiers.forEach(_function);
        return filteredModifiers;
    }

    public String getClass(PojoDefinitionModel pojo) {
        boolean _notEquals;
        JvmType _classx = pojo.getClassx();
        boolean bl = _notEquals = !Objects.equal((Object)_classx, null);
        if (_notEquals) {
            return pojo.getClassx().getQualifiedName();
        }
        return pojo.getClass_();
    }

    @Check
    public void checkMetaStatement(final MetaStatement statement) {
        boolean _isResolveDb;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _isOldPojoValidator;
        if (Objects.equal(statement.getModifiers(), null) || statement.getModifiers().isEmpty()) {
            return;
        }
        boolean _skipVerification = CommonUtils.skipVerification(statement, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        final Artifacts artifacts = this.getArtifacts(statement);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        Resource _eResource = statement.eResource();
        URI _uRI = null;
        if (_eResource != null) {
            _uRI = _eResource.getURI();
        }
        final URI uri = _uRI;
        final HashMap descriptorsCache = new HashMap();
        final HashMap classesCache = new HashMap();
        final HashMap ordersCache = new HashMap();
        int index = 0;
        String identPojoName = null;
        PojoDefinition identPojo = null;
        String indexPojoName = null;
        PojoDefinition indexPojo = null;
        String colPojoName = null;
        PojoDefinition colPojo = null;
        String constPojoName = null;
        PojoDefinition constPojo = null;
        TreeMap<String, TableDefinition> tablesPojo = new TreeMap<String, TableDefinition>();
        TreeMap<String, TableDefinition> tablesPrefixPojo = new TreeMap<String, TableDefinition>();
        EList<String> _modifiers = statement.getModifiers();
        for (String modifier : _modifiers) {
            boolean _equals_3;
            boolean _greaterThan;
            String[] values = modifier.split("=");
            int _length = values.length;
            boolean bl = _greaterThan = _length > 1;
            if (!_greaterThan) continue;
            String key = values[0];
            String value = values[1];
            boolean _equals_1 = "in".equals(key);
            if (_equals_1) {
                identPojo = this.modelProperty.getModelPojos(artifacts).get(value);
                boolean _equals_2 = Objects.equal((Object)identPojo, null);
                if (_equals_2) {
                    this.error("Cannot find pojo : " + value + "[" + "in" + "]", (EStructuralFeature)ProcessorMetaPackage.Literals.META_STATEMENT__MODIFIERS, index);
                } else {
                    identPojoName = value;
                }
            }
            if (_equals_3 = "ix".equals(key)) {
                indexPojo = this.modelProperty.getModelPojos(artifacts).get(value);
                boolean _equals_4 = Objects.equal((Object)indexPojo, null);
                if (_equals_4) {
                    this.error("Cannot find pojo : " + value + "[" + "ix" + "]", (EStructuralFeature)ProcessorMetaPackage.Literals.META_STATEMENT__MODIFIERS, index);
                } else {
                    indexPojoName = value;
                }
            } else {
                boolean _equals_5 = "out".equals(key);
                if (_equals_5) {
                    colPojo = this.modelProperty.getModelPojos(artifacts).get(value);
                    boolean _equals_6 = Objects.equal((Object)colPojo, null);
                    if (_equals_6) {
                        this.error("Cannot find pojo : " + value + "[" + "out" + "]", (EStructuralFeature)ProcessorMetaPackage.Literals.META_STATEMENT__MODIFIERS, index);
                    } else {
                        colPojoName = value;
                    }
                } else {
                    boolean _equals_7 = "const".equals(key);
                    if (_equals_7) {
                        constPojo = this.modelProperty.getModelPojos(artifacts).get(value);
                        boolean _equals_8 = Objects.equal((Object)constPojo, null);
                        if (_equals_8) {
                            this.error("Cannot find pojo : " + value + "[" + "const" + "]", (EStructuralFeature)ProcessorMetaPackage.Literals.META_STATEMENT__MODIFIERS, index);
                        } else {
                            constPojoName = value;
                        }
                    } else {
                        boolean _equals_9 = "tab".equals(key);
                        if (_equals_9) {
                            String _xifexpression = null;
                            int _length_1 = values.length;
                            boolean _greaterThan_1 = _length_1 > 2;
                            _xifexpression = _greaterThan_1 ? values[2] : "_DEFAULT_";
                            String prefix = _xifexpression;
                            TableDefinition table = this.modelProperty.getModelTables(artifacts).get(value);
                            boolean _equals_10 = Objects.equal((Object)table, null);
                            if (_equals_10) {
                                this.error("Cannot find table : " + value + "[" + "tab" + "]", (EStructuralFeature)ProcessorMetaPackage.Literals.META_STATEMENT__MODIFIERS, index);
                            } else {
                                tablesPojo.put(value, table);
                                tablesPrefixPojo.put(prefix, table);
                            }
                        }
                    }
                }
            }
            ++index;
        }
        boolean _equals_1 = Objects.equal(indexPojo, null);
        if (_equals_1) {
            indexPojo = identPojo;
            indexPojoName = identPojoName;
        }
        final boolean newPojoValidator = !(_isOldPojoValidator = this.modelProperty.isOldPojoValidator(statement));
        boolean bl = _notEquals = !Objects.equal(identPojo, null);
        if (_notEquals) {
            List identifiers = EcoreUtil2.getAllContentsOfType((EObject)statement, Identifier.class);
            final PojoDefinition pojo = identPojo;
            final String pojoName = identPojoName;
            Consumer<Identifier> _function = new Consumer<Identifier>(){

                @Override
                public void accept(Identifier identifier) {
                    ProcessorMetaValidator.this.checkIdentifier(identifier, pojo, pojoName, statement, newPojoValidator, artifacts, uri, descriptorsCache, classesCache);
                }
            };
            identifiers.forEach(_function);
        }
        boolean bl2 = _notEquals_1 = !Objects.equal(indexPojo, null);
        if (_notEquals_1) {
            List orders = EcoreUtil2.getAllContentsOfType((EObject)statement, OrdSql.class);
            final PojoDefinition pojo_1 = indexPojo;
            final String pojoName_1 = indexPojoName;
            Consumer<OrdSql> _function_1 = new Consumer<OrdSql>(){

                @Override
                public void accept(OrdSql order) {
                    ProcessorMetaValidator.this.checkOrder(order, pojo_1, pojoName_1, statement, newPojoValidator, artifacts, uri, ordersCache, classesCache);
                }
            };
            orders.forEach(_function_1);
        }
        boolean bl3 = _notEquals_2 = !Objects.equal(colPojo, null);
        if (_notEquals_2) {
            List columns = EcoreUtil2.getAllContentsOfType((EObject)statement, Column.class);
            final PojoDefinition pojo_2 = colPojo;
            final String pojoName_2 = colPojoName;
            Consumer<Column> _function_2 = new Consumer<Column>(){

                @Override
                public void accept(Column column) {
                    ProcessorMetaValidator.this.checkColumn(column, pojo_2, pojoName_2, statement, newPojoValidator, artifacts, uri, descriptorsCache, classesCache);
                }
            };
            columns.forEach(_function_2);
        }
        boolean bl4 = _notEquals_3 = !Objects.equal(constPojo, null);
        if (_notEquals_3) {
            List constants = EcoreUtil2.getAllContentsOfType((EObject)statement, Constant.class);
            final PojoDefinition pojo_3 = constPojo;
            final String pojoName_3 = constPojoName;
            Consumer<Constant> _function_3 = new Consumer<Constant>(){

                @Override
                public void accept(Constant constant) {
                    ProcessorMetaValidator.this.checkConstant(constant, pojo_3, pojoName_3, statement, newPojoValidator, artifacts, uri, descriptorsCache, classesCache);
                }
            };
            constants.forEach(_function_3);
        }
        if (_isResolveDb = this.isResolveDb(statement)) {
            this.checkTablesColumns(tablesPojo, tablesPrefixPojo, statement);
        }
    }

    public void checkTablesColumns(final TreeMap<String, TableDefinition> tablesPojo, final TreeMap<String, TableDefinition> tablesPrefixPojo, final MetaStatement statement) {
        List tables = EcoreUtil2.getAllContentsOfType((EObject)statement, DatabaseTable.class);
        Consumer<DatabaseTable> _function = new Consumer<DatabaseTable>(){

            @Override
            public void accept(DatabaseTable table) {
                final String tableName = table.getName();
                Functions.Function1<TableDefinition, Boolean> _function = new Functions.Function1<TableDefinition, Boolean>(){

                    public Boolean apply(TableDefinition it) {
                        String _table = it.getTable();
                        return Objects.equal((Object)_table, (Object)tableName);
                    }
                };
                TableDefinition tableDefinition = (TableDefinition)IterableExtensions.findFirst(tablesPojo.values(), (Functions.Function1)_function);
                if (Objects.equal((Object)tableDefinition, null) || !ProcessorMetaValidator.this.dbResolver.checkTable(statement, tableName)) {
                    ProcessorMetaValidator.this.error("Cannot find table in DB : " + tableName, table, (EStructuralFeature)ProcessorMetaPackage.Literals.DATABASE_TABLE__NAME);
                }
            }
        };
        tables.forEach(_function);
        List columns = EcoreUtil2.getAllContentsOfType((EObject)statement, DatabaseColumn.class);
        Consumer<DatabaseColumn> _function_1 = new Consumer<DatabaseColumn>(){

            @Override
            public void accept(DatabaseColumn column) {
                String tableName;
                boolean _notEquals;
                int pos = column.getName().indexOf(".");
                String _xifexpression = null;
                _xifexpression = pos > 0 ? column.getName().substring(0, pos) : "_DEFAULT_";
                String prefix = _xifexpression;
                String _xifexpression_1 = null;
                _xifexpression_1 = pos > 0 ? column.getName().substring(pos + 1) : column.getName();
                String columnName = _xifexpression_1;
                TableDefinition tableDefinition = (TableDefinition)tablesPrefixPojo.get(prefix);
                String _xifexpression_2 = null;
                boolean bl = _notEquals = !Objects.equal((Object)tableDefinition, null);
                if (_notEquals) {
                    _xifexpression_2 = tableDefinition.getTable();
                }
                if (Objects.equal((Object)(tableName = _xifexpression_2), null) || !ProcessorMetaValidator.this.dbResolver.checkColumn(column, tableName, columnName)) {
                    String _name = column.getName();
                    String _plus = "Cannot find column in DB : " + _name;
                    String _plus_1 = String.valueOf(_plus) + "[";
                    String _plus_2 = String.valueOf(_plus_1) + tableName;
                    String _plus_3 = String.valueOf(_plus_2) + "]";
                    ProcessorMetaValidator.this.error(_plus_3, column, (EStructuralFeature)ProcessorMetaPackage.Literals.DATABASE_COLUMN__NAME);
                }
            }
        };
        columns.forEach(_function_1);
    }

    public void checkIdentifier(Identifier identifier, PojoDefinition pojo, String pojoName, MetaStatement statement, boolean newPojoValidator, Artifacts artifacts, URI uri, Map<String, PropertyDescriptor[]> descriptorsCache, Map<String, Class<?>> classesCache) {
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _isResolvePojo = this.isResolvePojo(identifier);
        boolean bl = _not = !_isResolvePojo;
        if (_not) {
            return;
        }
        String identifierName = identifier.getName();
        String identifierUsageClass = pojo.getQualifiedName();
        ValidationResult validationResult = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)identifierUsageClass, null);
        if (_notEquals) {
            if (newPojoValidator && pojo.getClassx() instanceof JvmDeclaredType) {
                JvmType _classx = pojo.getClassx();
                validationResult = this.checkClassProperty((JvmDeclaredType)_classx, identifierName);
            } else {
                validationResult = this.checkClassProperty(identifierUsageClass, identifierName, uri, descriptorsCache, classesCache);
            }
            if (validationResult != null) {
                switch (validationResult) {
                    case WARNING: {
                        this.warning("Problem property : " + identifierName + "[" + identifierUsageClass + "]", identifier, (EStructuralFeature)ProcessorMetaPackage.Literals.IDENTIFIER__NAME);
                        break;
                    }
                    case ERROR: {
                        this.error("Cannot find property : " + identifierName + "[" + identifierUsageClass + "]", identifier, (EStructuralFeature)ProcessorMetaPackage.Literals.IDENTIFIER__NAME);
                        break;
                    }
                }
            }
            return;
        }
        PojoResolver _pojoResolver = this.pojoResolverFactory.getPojoResolver();
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)_pojoResolver, null);
        if (_notEquals_1) {
            this.error("Cannot check input form attribute : " + identifierName, identifier, (EStructuralFeature)ProcessorMetaPackage.Literals.IDENTIFIER__NAME);
        }
    }

    public void checkOrder(OrdSql order, PojoDefinition pojo, String pojoName, MetaStatement statement, boolean newPojoValidator, Artifacts artifacts, URI uri, Map<String, Map<String, String>> ordersCache, Map<String, Class<?>> classesCache) {
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _isResolvePojo = this.isResolvePojo(order);
        boolean bl = _not = !_isResolvePojo;
        if (_not) {
            return;
        }
        String identifierName = order.getIdent();
        String identifierUsageClass = pojo.getQualifiedName();
        ValidationResult validationResult = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)identifierUsageClass, null);
        if (_notEquals) {
            if (newPojoValidator && pojo.getClassx() instanceof JvmDeclaredType) {
                JvmType _classx = pojo.getClassx();
                validationResult = this.checkOrderProperty((JvmDeclaredType)_classx, identifierName);
            } else {
                this.checkOrderProperty(identifierUsageClass, identifierName, uri, ordersCache, classesCache);
            }
            if (validationResult != null) {
                switch (validationResult) {
                    case WARNING: {
                        this.warning("Problem order : " + identifierName + "[" + identifierUsageClass + "]", order, (EStructuralFeature)ProcessorMetaPackage.Literals.ORD_SQL__IDENT);
                        break;
                    }
                    case ERROR: {
                        this.warning("Cannot find order : " + identifierName + "[" + identifierUsageClass + "]", order, (EStructuralFeature)ProcessorMetaPackage.Literals.ORD_SQL__IDENT);
                        break;
                    }
                }
            }
            return;
        }
        PojoResolver _pojoResolver = this.pojoResolverFactory.getPojoResolver();
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)_pojoResolver, null);
        if (_notEquals_1) {
            this.error("Cannot check order identifier : " + identifierName, order, (EStructuralFeature)ProcessorMetaPackage.Literals.ORD_SQL__IDENT);
        }
    }

    public void checkColumn(Column column, PojoDefinition pojo, String pojoName, MetaStatement statement, boolean newPojoValidator, Artifacts artifacts, URI uri, Map<String, PropertyDescriptor[]> descriptorsCache, Map<String, Class<?>> classesCache) {
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _isResolvePojo = this.isResolvePojo(column);
        boolean bl = _not = !_isResolvePojo;
        if (_not) {
            return;
        }
        String columnName = Utils.getName(column);
        boolean _isNumber = Utils.isNumber(columnName);
        if (_isNumber) {
            return;
        }
        String _xifexpression = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)pojo, null);
        if (_notEquals) {
            _xifexpression = pojo.getQualifiedName();
        }
        String columnUsageClass = _xifexpression;
        ValidationResult validationResult = null;
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)columnUsageClass, null);
        if (_notEquals_1) {
            if (newPojoValidator && pojo.getClassx() instanceof JvmDeclaredType) {
                JvmType _classx = pojo.getClassx();
                validationResult = this.checkClassProperty((JvmDeclaredType)_classx, columnName);
            } else {
                validationResult = this.checkClassProperty(columnUsageClass, columnName, uri, descriptorsCache, classesCache);
            }
            if (validationResult != null) {
                switch (validationResult) {
                    case WARNING: {
                        this.warning("Problem property : " + columnName + "[" + columnUsageClass + "]", column, (EStructuralFeature)ProcessorMetaPackage.Literals.COLUMN__COLUMNS);
                        break;
                    }
                    case ERROR: {
                        this.checkColumnGType(column, columnName, columnUsageClass, statement);
                        break;
                    }
                }
            }
            return;
        }
        PojoResolver _pojoResolver = this.pojoResolverFactory.getPojoResolver();
        boolean bl4 = _notEquals_2 = !Objects.equal((Object)_pojoResolver, null);
        if (_notEquals_2) {
            this.error("Cannot check result class attribute : " + columnName, column, (EStructuralFeature)ProcessorMetaPackage.Literals.COLUMN__COLUMNS);
        }
    }

    public void checkColumnGType(Column column, String columnName, String columnUsageClass, MetaStatement statement) {
        if (Objects.equal((Object)statement.getStatement(), null) || Objects.equal(statement.getStatement().getSqls(), null)) {
            return;
        }
        EList<SqlFragment> _sqls = statement.getStatement().getSqls();
        for (SqlFragment stmt : _sqls) {
            if (!(Objects.equal((Object)stmt.getCol(), null) || Objects.equal(stmt.getCol().getColumns(), null) || Objects.equal(stmt.getCol().getColumns(), null))) {
                EList<ExtendedColumn> _columns = stmt.getCol().getColumns();
                for (ExtendedColumn _col : _columns) {
                    boolean _notEquals;
                    EList<String> _modifiers = _col.getModifiers();
                    boolean bl = _notEquals = !Objects.equal(_modifiers, null);
                    if (!_notEquals) continue;
                    EList<String> _modifiers_1 = _col.getModifiers();
                    for (String mod : _modifiers_1) {
                        boolean _greaterEqualsThan;
                        int _indexOf = mod.indexOf("gtype");
                        boolean bl2 = _greaterEqualsThan = _indexOf >= 0;
                        if (!_greaterEqualsThan) continue;
                        this.warning("Problem property : " + columnName + "[" + columnUsageClass + "]", column, (EStructuralFeature)ProcessorMetaPackage.Literals.COLUMN__COLUMNS);
                        return;
                    }
                }
            }
            if (Objects.equal((Object)stmt.getMeta(), null) || Objects.equal(stmt.getMeta().getIfs(), null)) continue;
            EList<IfSql> _ifs = stmt.getMeta().getIfs();
            for (IfSql ifs : _ifs) {
                boolean _notEquals_1;
                EList<IfSqlFragment> _sqls_1 = ifs.getSqls();
                boolean bl = _notEquals_1 = !Objects.equal(_sqls_1, null);
                if (!_notEquals_1) continue;
                EList<IfSqlFragment> _sqls_2 = ifs.getSqls();
                for (IfSqlFragment stmt2 : _sqls_2) {
                    if (Objects.equal((Object)stmt2.getCol(), null) || Objects.equal(stmt2.getCol().getColumns(), null) || Objects.equal(stmt2.getCol().getColumns(), null)) continue;
                    EList<ExtendedColumn> _columns_1 = stmt2.getCol().getColumns();
                    for (ExtendedColumn _col_1 : _columns_1) {
                        boolean _notEquals_2;
                        EList<String> _modifiers_2 = _col_1.getModifiers();
                        boolean bl3 = _notEquals_2 = !Objects.equal(_modifiers_2, null);
                        if (!_notEquals_2) continue;
                        EList<String> _modifiers_3 = _col_1.getModifiers();
                        for (String mod_1 : _modifiers_3) {
                            boolean _greaterEqualsThan_1;
                            int _indexOf_1 = mod_1.indexOf("gtype");
                            boolean bl4 = _greaterEqualsThan_1 = _indexOf_1 >= 0;
                            if (!_greaterEqualsThan_1) continue;
                            this.warning("Problem property : " + columnName + "[" + columnUsageClass + "]", column, (EStructuralFeature)ProcessorMetaPackage.Literals.COLUMN__COLUMNS);
                            return;
                        }
                    }
                }
            }
        }
        this.error("Cannot find property : " + columnName + "[" + columnUsageClass + "]", column, (EStructuralFeature)ProcessorMetaPackage.Literals.COLUMN__COLUMNS);
    }

    public void checkConstant(Constant constant, PojoDefinition pojo, String pojoName, MetaStatement statement, boolean newPojoValidator, Artifacts artifacts, URI uri, Map<String, PropertyDescriptor[]> descriptorsCache, Map<String, Class<?>> classesCache) {
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _isResolvePojo = this.isResolvePojo(constant);
        boolean bl = _not = !_isResolvePojo;
        if (_not) {
            return;
        }
        String _xifexpression = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)pojo, null);
        if (_notEquals) {
            _xifexpression = pojo.getQualifiedName();
        }
        String constantUsageClass = _xifexpression;
        ValidationResult validationResult = null;
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)constantUsageClass, null);
        if (_notEquals_1) {
            if (newPojoValidator && pojo.getClassx() instanceof JvmDeclaredType) {
                JvmType _classx = pojo.getClassx();
                validationResult = this.checkClassProperty((JvmDeclaredType)_classx, constant.getName());
            } else {
                validationResult = this.checkClassProperty(constantUsageClass, constant.getName(), uri, descriptorsCache, classesCache);
            }
            if (validationResult != null) {
                switch (validationResult) {
                    case WARNING: {
                        String _name = constant.getName();
                        String _plus = "Problem property : " + _name;
                        String _plus_1 = String.valueOf(_plus) + "[";
                        String _plus_2 = String.valueOf(_plus_1) + constantUsageClass;
                        String _plus_3 = String.valueOf(_plus_2) + "]";
                        this.warning(_plus_3, constant, (EStructuralFeature)ProcessorMetaPackage.Literals.CONSTANT__NAME);
                        break;
                    }
                    case ERROR: {
                        String _name_1 = constant.getName();
                        String _plus_4 = "Cannot find property : " + _name_1;
                        String _plus_5 = String.valueOf(_plus_4) + "[";
                        String _plus_6 = String.valueOf(_plus_5) + constantUsageClass;
                        String _plus_7 = String.valueOf(_plus_6) + "]";
                        this.error(_plus_7, constant, (EStructuralFeature)ProcessorMetaPackage.Literals.CONSTANT__NAME);
                        break;
                    }
                }
            }
            return;
        }
        PojoResolver _pojoResolver = this.pojoResolverFactory.getPojoResolver();
        boolean bl4 = _notEquals_2 = !Objects.equal((Object)_pojoResolver, null);
        if (_notEquals_2) {
            String _name_2 = constant.getName();
            String _plus_8 = "Cannot check constant form attribute : " + _name_2;
            this.error(_plus_8, (EStructuralFeature)ProcessorMetaPackage.Literals.CONSTANT__NAME);
        }
    }

    @Check
    public void checkMappingRule(final MappingRule rule) {
        boolean _notEquals;
        if (Objects.equal(rule.getModifiers(), null) || rule.getModifiers().isEmpty()) {
            return;
        }
        boolean _skipVerification = CommonUtils.skipVerification(rule, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        final Artifacts artifacts = this.getArtifacts(rule);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        Resource _eResource = rule.eResource();
        URI _uRI = null;
        if (_eResource != null) {
            _uRI = _eResource.getURI();
        }
        final URI uri = _uRI;
        final HashMap descriptorsCache = new HashMap();
        final HashMap classesCache = new HashMap();
        int index = 0;
        String colPojoName = null;
        PojoDefinition colPojo = null;
        EList<String> _modifiers = rule.getModifiers();
        for (String modifier : _modifiers) {
            int ix = modifier.indexOf("=");
            if (ix <= 0) continue;
            String key = modifier.substring(0, ix);
            String value = modifier.substring(ix + 1);
            boolean _equals_1 = "out".equals(key);
            if (_equals_1) {
                colPojo = this.modelProperty.getModelPojos(artifacts).get(value);
                boolean _equals_2 = Objects.equal((Object)colPojo, null);
                if (_equals_2) {
                    this.error("Cannot find pojo : " + value + "[" + "out" + "]", (EStructuralFeature)ProcessorMetaPackage.Literals.MAPPING_RULE__MODIFIERS, index);
                } else {
                    colPojoName = value;
                }
            }
            ++index;
        }
        boolean bl = _notEquals = !Objects.equal(colPojo, null);
        if (_notEquals) {
            boolean _isOldPojoValidator = this.modelProperty.isOldPojoValidator(rule);
            final boolean newPojoValidator = !_isOldPojoValidator;
            List columns = EcoreUtil2.getAllContentsOfType((EObject)rule, MappingColumn.class);
            final PojoDefinition pojo = colPojo;
            final String pojoName = colPojoName;
            Consumer<MappingColumn> _function = new Consumer<MappingColumn>(){

                @Override
                public void accept(MappingColumn column) {
                    ProcessorMetaValidator.this.checkMappingColumn(column, pojo, pojoName, rule, newPojoValidator, artifacts, uri, descriptorsCache, classesCache);
                }
            };
            columns.forEach(_function);
        }
    }

    public void checkMappingColumn(MappingColumn column, PojoDefinition pojo, String pojoName, MappingRule rule, boolean newPojoValidator, Artifacts artifacts, URI uri, Map<String, PropertyDescriptor[]> descriptorsCache, Map<String, Class<?>> classesCache) {
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _isResolvePojo = this.isResolvePojo(column);
        boolean bl = _not = !_isResolvePojo;
        if (_not) {
            return;
        }
        String columnName = Utils.getName(column);
        boolean _isNumber = Utils.isNumber(columnName);
        if (_isNumber) {
            return;
        }
        String mappingUsageClass = pojo.getQualifiedName();
        ValidationResult validationResult = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)mappingUsageClass, null);
        if (_notEquals) {
            if (newPojoValidator && pojo.getClassx() instanceof JvmDeclaredType) {
                JvmType _classx = pojo.getClassx();
                validationResult = this.checkClassProperty((JvmDeclaredType)_classx, columnName);
            } else {
                validationResult = this.checkClassProperty(mappingUsageClass, columnName, uri, descriptorsCache, classesCache);
            }
            if (validationResult != null) {
                switch (validationResult) {
                    case WARNING: {
                        this.warning("Problem property : " + columnName + "[" + mappingUsageClass + "]", column, (EStructuralFeature)ProcessorMetaPackage.Literals.MAPPING_COLUMN__ITEMS);
                        break;
                    }
                    case ERROR: {
                        this.error("Cannot find property : " + columnName + "[" + mappingUsageClass + "]", column, (EStructuralFeature)ProcessorMetaPackage.Literals.MAPPING_COLUMN__ITEMS);
                        break;
                    }
                }
            }
            return;
        }
        PojoResolver _pojoResolver = this.pojoResolverFactory.getPojoResolver();
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)_pojoResolver, null);
        if (_notEquals_1) {
            this.error("Cannot check result class attribute : " + columnName, column, (EStructuralFeature)ProcessorMetaPackage.Literals.MAPPING_COLUMN__ITEMS);
        }
    }

    public ValidationResult checkClassProperty(String className, String property, URI uri, Map<String, PropertyDescriptor[]> descriptorsCache, Map<String, Class<?>> classesCache) {
        boolean _notEquals;
        int pos2;
        boolean _equals_2;
        if (Objects.equal((Object)property, null) || Utils.isNumber(property) || Objects.equal((Object)this.pojoResolverFactory.getPojoResolver(), null)) {
            return ValidationResult.OK;
        }
        boolean _equals = Objects.equal((Object)className, null);
        if (_equals) {
            return ValidationResult.ERROR;
        }
        String _string = uri.toString();
        String _plus = String.valueOf(_string) + className;
        PropertyDescriptor[] descriptors = descriptorsCache.get(_plus);
        boolean _equals_1 = Objects.equal((Object)descriptors, null);
        if (_equals_1) {
            descriptors = this.pojoResolverFactory.getPojoResolver().getPropertyDescriptors(className, uri);
        }
        if (_equals_2 = Objects.equal((Object)descriptors, null)) {
            return ValidationResult.WARNING;
        }
        String _string_1 = uri.toString();
        String _plus_1 = String.valueOf(_string_1) + className;
        descriptorsCache.put(_plus_1, descriptors);
        String checkProperty = property;
        int pos1 = checkProperty.indexOf("=");
        if (pos1 > 0 && (pos2 = checkProperty.indexOf(".", pos1)) > pos1) {
            String _plus_2;
            String _substring = checkProperty.substring(0, pos1);
            String _substring_1 = checkProperty.substring(pos2);
            checkProperty = _plus_2 = String.valueOf(_substring) + _substring_1;
        }
        String innerProperty = null;
        pos1 = checkProperty.indexOf(".");
        if (pos1 > 0) {
            innerProperty = checkProperty.substring(pos1 + 1);
            checkProperty = checkProperty.substring(0, pos1);
        }
        final String _checkProperty = checkProperty;
        PropertyDescriptor[] _converted_descriptors = descriptors;
        Functions.Function1<PropertyDescriptor, Boolean> _function = new Functions.Function1<PropertyDescriptor, Boolean>(){

            public Boolean apply(PropertyDescriptor descriptor) {
                String _name = descriptor.getName();
                return Objects.equal((Object)_name, (Object)_checkProperty);
            }
        };
        PropertyDescriptor checkDesriptor = (PropertyDescriptor)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_descriptors)), (Functions.Function1)_function);
        boolean _equals_3 = Objects.equal((Object)checkDesriptor, null);
        if (_equals_3) {
            String _string_2 = uri.toString();
            String _plus_3 = String.valueOf(_string_2) + className;
            Class<?> clazz = classesCache.get(_plus_3);
            boolean _equals_4 = Objects.equal(clazz, null);
            if (_equals_4) {
                clazz = this.pojoResolverFactory.getPojoResolver().loadClass(className, uri);
            }
            if (!Objects.equal(clazz, null) && Modifier.isAbstract(clazz.getModifiers())) {
                return ValidationResult.WARNING;
            }
            if (!Objects.equal(clazz, null) && this.isPrimitive(clazz)) {
                return ValidationResult.OK;
            }
            return ValidationResult.ERROR;
        }
        boolean bl = _notEquals = !Objects.equal((Object)innerProperty, null);
        if (_notEquals) {
            Class innerClass = checkDesriptor.getPropertyType();
            boolean _isArray = innerClass.isArray();
            if (_isArray) {
                Type _genericReturnType = checkDesriptor.getReadMethod().getGenericReturnType();
                ParameterizedType type = (ParameterizedType)_genericReturnType;
                if (Objects.equal((Object)type.getActualTypeArguments(), null) || type.getActualTypeArguments().length == 0) {
                    return ValidationResult.WARNING;
                }
                Type _head = (Type)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)type.getActualTypeArguments())));
                innerClass = (Class)_head;
                boolean _isPrimitive = this.isPrimitive(innerClass);
                if (_isPrimitive) {
                    return ValidationResult.ERROR;
                }
                return this.checkClassProperty(innerClass.getName(), innerProperty, uri, descriptorsCache, classesCache);
            }
            boolean _isAssignableFrom = Collection.class.isAssignableFrom(innerClass);
            if (_isAssignableFrom) {
                Type _genericReturnType_1 = checkDesriptor.getReadMethod().getGenericReturnType();
                ParameterizedType type_1 = (ParameterizedType)_genericReturnType_1;
                if (Objects.equal((Object)type_1.getActualTypeArguments(), null) || type_1.getActualTypeArguments().length == 0) {
                    return ValidationResult.WARNING;
                }
                Type _head_1 = (Type)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)type_1.getActualTypeArguments())));
                innerClass = (Class)_head_1;
                boolean _isPrimitive_1 = this.isPrimitive(innerClass);
                if (_isPrimitive_1) {
                    return ValidationResult.ERROR;
                }
                return this.checkClassProperty(innerClass.getName(), innerProperty, uri, descriptorsCache, classesCache);
            }
            boolean _isPrimitive_2 = this.isPrimitive(innerClass);
            if (_isPrimitive_2) {
                return ValidationResult.ERROR;
            }
            return this.checkClassProperty(innerClass.getName(), innerProperty, uri, descriptorsCache, classesCache);
        }
        return ValidationResult.OK;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ValidationResult checkClassProperty(JvmDeclaredType jvmType, String property) {
        boolean _notEquals;
        Iterable features;
        int pos2;
        if (Objects.equal((Object)property, null) || Utils.isNumber(property)) {
            return ValidationResult.OK;
        }
        boolean _equals = Objects.equal((Object)jvmType, null);
        if (_equals) {
            return ValidationResult.ERROR;
        }
        String checkProperty = property;
        int pos1 = checkProperty.indexOf("=");
        if (pos1 > 0 && (pos2 = checkProperty.indexOf(".", pos1)) > pos1) {
            String _plus;
            String _substring = checkProperty.substring(0, pos1);
            String _substring_1 = checkProperty.substring(pos2);
            checkProperty = _plus = String.valueOf(_substring) + _substring_1;
        }
        String innerProperty = null;
        pos1 = checkProperty.indexOf(".");
        if (pos1 > 0) {
            innerProperty = checkProperty.substring(pos1 + 1);
            checkProperty = checkProperty.substring(0, pos1);
        }
        if (Objects.equal((Object)(features = jvmType.findAllFeaturesByName(checkProperty)), null) || IterableExtensions.isEmpty((Iterable)features) || !(IterableExtensions.head((Iterable)features) instanceof JvmField)) {
            String _firstUpper = StringExtensions.toFirstUpper((String)checkProperty);
            String _plus_1 = "get" + _firstUpper;
            features = jvmType.findAllFeaturesByName(_plus_1);
        }
        if (Objects.equal((Object)features, null) || IterableExtensions.isEmpty((Iterable)features) || !(IterableExtensions.head((Iterable)features) instanceof JvmOperation) && !(IterableExtensions.head((Iterable)features) instanceof JvmField)) {
            if (jvmType instanceof JvmPrimitiveType || this.isPrimitive(jvmType.getQualifiedName())) {
                return ValidationResult.OK;
            }
            boolean _isAbstract = jvmType.isAbstract();
            if (!_isAbstract) return ValidationResult.ERROR;
            return ValidationResult.WARNING;
        }
        boolean bl = _notEquals = !Objects.equal((Object)innerProperty, null);
        if (!_notEquals) return ValidationResult.OK;
        JvmFeature _head = (JvmFeature)IterableExtensions.head((Iterable)features);
        if (_head instanceof JvmOperation) {
            return ValidationResult.ERROR;
        }
        JvmFeature _head_1 = (JvmFeature)IterableExtensions.head((Iterable)features);
        JvmField field = (JvmField)_head_1;
        JvmTypeReference _type = field.getType();
        if (!(_type instanceof JvmParameterizedTypeReference)) return ValidationResult.WARNING;
        JvmTypeReference _type_1 = field.getType();
        JvmType type = ((JvmParameterizedTypeReference)_type_1).getType();
        if (!(type instanceof JvmDeclaredType)) {
            InputOutput.print((Object)("checkClassProperty " + property + ": "));
            InputOutput.println((Object)type);
            return ValidationResult.WARNING;
        } else {
            JvmTypeReference _type_2 = field.getType();
            EList typeArgs = ((JvmParameterizedTypeReference)_type_2).getArguments();
            if (Objects.equal((Object)typeArgs, null) || typeArgs.isEmpty() || !(IterableExtensions.head((Iterable)typeArgs) instanceof JvmParameterizedTypeReference)) return this.checkClassProperty((JvmDeclaredType)type, innerProperty);
            JvmTypeReference _head_2 = (JvmTypeReference)IterableExtensions.head((Iterable)typeArgs);
            JvmType type2 = ((JvmParameterizedTypeReference)_head_2).getType();
            if (type2 instanceof JvmDeclaredType) return this.checkClassProperty((JvmDeclaredType)type2, innerProperty);
            InputOutput.print((Object)("checkClassProperty2 " + property + ": "));
            InputOutput.println((Object)type2);
        }
        return ValidationResult.WARNING;
    }

    public Set<String> getFieldNamesForClass(JvmDeclaredType jvmType) {
        HashSet result = CollectionLiterals.newHashSet();
        Iterable _declaredFields = jvmType.getDeclaredFields();
        for (JvmField field : _declaredFields) {
            result.add(field.getSimpleName());
        }
        return result;
    }

    public ValidationResult checkOrderProperty(String className, final String property, URI uri, Map<String, Map<String, String>> ordersCache, Map<String, Class<?>> classesCache) {
        boolean _notEquals;
        boolean _equals_2;
        if (Objects.equal((Object)property, null) || Objects.equal((Object)this.pojoResolverFactory.getPojoResolver(), null)) {
            return ValidationResult.OK;
        }
        boolean _equals = Objects.equal((Object)className, null);
        if (_equals) {
            return ValidationResult.ERROR;
        }
        String _string = uri.toString();
        String _plus = String.valueOf(_string) + className;
        Map<String, String> orders = ordersCache.get(_plus);
        boolean _equals_1 = Objects.equal(orders, null);
        if (_equals_1) {
            orders = this.pojoResolverFactory.getPojoResolver().getOrders(className, uri);
        }
        if (_equals_2 = Objects.equal(orders, null)) {
            return ValidationResult.WARNING;
        }
        String _string_1 = uri.toString();
        String _plus_1 = String.valueOf(_string_1) + className;
        ordersCache.put(_plus_1, orders);
        final Map<String, String> _orders = orders;
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String k) {
                return ((String)_orders.get(k)).equals(property);
            }
        };
        String order = (String)IterableExtensions.findFirst(orders.keySet(), (Functions.Function1)_function);
        boolean bl = _notEquals = !Objects.equal((Object)order, null);
        if (_notEquals) {
            return ValidationResult.OK;
        }
        return ValidationResult.ERROR;
    }

    public ValidationResult checkOrderProperty(JvmDeclaredType jvmType, String property) {
        boolean _equals = Objects.equal((Object)property, null);
        if (_equals) {
            return ValidationResult.OK;
        }
        boolean _equals_1 = Objects.equal((Object)jvmType, null);
        if (_equals_1) {
            return ValidationResult.ERROR;
        }
        Iterable features = jvmType.findAllFeaturesByName("ORDER_BY_" + property);
        if (Objects.equal((Object)features, null) || IterableExtensions.isEmpty((Iterable)features) || !(IterableExtensions.head((Iterable)features) instanceof JvmField)) {
            Iterable nestedTypes = jvmType.findAllNestedTypesByName("Order");
            if (Objects.equal((Object)nestedTypes, null) || IterableExtensions.isEmpty((Iterable)nestedTypes) || !(IterableExtensions.head((Iterable)nestedTypes) instanceof JvmEnumerationType)) {
                return ValidationResult.ERROR;
            }
            JvmDeclaredType _head = (JvmDeclaredType)IterableExtensions.head((Iterable)nestedTypes);
            JvmEnumerationType type = (JvmEnumerationType)_head;
            Iterable features2 = type.findAllFeaturesByName(property);
            if (Objects.equal((Object)features2, null) || IterableExtensions.isEmpty((Iterable)features2) || !(IterableExtensions.head((Iterable)features2) instanceof JvmEnumerationLiteral)) {
                return ValidationResult.ERROR;
            }
        }
        return ValidationResult.OK;
    }

    @Check
    public void checkTableDefinition(TableDefinitionModel tableDefinition) {
        boolean _skipVerification = CommonUtils.skipVerification(tableDefinition, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(tableDefinition);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<TableDefinitionModel> _tables = artifacts.getTables();
        for (TableDefinitionModel table : _tables) {
            boolean _equals_1;
            if (Objects.equal((Object)table, null) || table == tableDefinition || !(_equals_1 = tableDefinition.getName().equals(table.getName()))) continue;
            String _name = tableDefinition.getName();
            String _plus = "Duplicate name : " + _name;
            String _plus_1 = String.valueOf(_plus) + "[table]";
            this.error(_plus_1, (EStructuralFeature)ProcessorMetaPackage.Literals.TABLE_DEFINITION_MODEL__NAME);
            return;
        }
        if (this.isResolveDb(tableDefinition) && !this.dbResolver.checkTable(tableDefinition, tableDefinition.getTable())) {
            String _table = tableDefinition.getTable();
            String _plus_2 = "Cannot find table in DB : " + _table;
            this.error(_plus_2, (EStructuralFeature)ProcessorMetaPackage.Literals.TABLE_DEFINITION_MODEL__TABLE);
        }
    }

    @Check
    public void checkProcedureDefinition(ProcedureDefinitionModel procedureDefinition) {
        boolean _skipVerification = CommonUtils.skipVerification(procedureDefinition, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(procedureDefinition);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<ProcedureDefinitionModel> _procedures = artifacts.getProcedures();
        for (ProcedureDefinitionModel procedure : _procedures) {
            boolean _equals_1;
            if (Objects.equal((Object)procedure, null) || procedure == procedureDefinition || !(_equals_1 = procedureDefinition.getName().equals(procedure.getName()))) continue;
            String _name = procedureDefinition.getName();
            String _plus = "Duplicate name : " + _name;
            String _plus_1 = String.valueOf(_plus) + "[procedure]";
            this.error(_plus_1, (EStructuralFeature)ProcessorMetaPackage.Literals.PROCEDURE_DEFINITION_MODEL__NAME);
            return;
        }
        if (this.isResolveDb(procedureDefinition) && !this.dbResolver.checkProcedure(procedureDefinition, procedureDefinition.getTable())) {
            String _table = procedureDefinition.getTable();
            String _plus_2 = "Cannot find procedure in DB : " + _table;
            this.error(_plus_2, (EStructuralFeature)ProcessorMetaPackage.Literals.PROCEDURE_DEFINITION_MODEL__NAME);
        }
    }

    @Check
    public void checkFunctionDefinition(FunctionDefinitionModel functionDefinition) {
        boolean _skipVerification = CommonUtils.skipVerification(functionDefinition, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(functionDefinition);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<FunctionDefinitionModel> _functions = artifacts.getFunctions();
        for (FunctionDefinitionModel function : _functions) {
            boolean _equals_1;
            if (Objects.equal((Object)function, null) || function == functionDefinition || !(_equals_1 = functionDefinition.getName().equals(function.getName()))) continue;
            String _name = functionDefinition.getName();
            String _plus = "Duplicate name : " + _name;
            String _plus_1 = String.valueOf(_plus) + "[function]";
            this.error(_plus_1, (EStructuralFeature)ProcessorMetaPackage.Literals.FUNCTION_DEFINITION_MODEL__NAME);
            return;
        }
    }

    public void _checkDatabaseTable(DatabaseTable databaseTable) {
        Functions.Function1<TableDefinition, Boolean> _function_1;
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(databaseTable);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            return;
        }
        boolean _skipVerification = CommonUtils.skipVerification(databaseTable, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        MetaStatement statement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)databaseTable, MetaStatement.class);
        final Artifacts artifacts = this.getArtifacts(statement);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        final String tableName = databaseTable.getName();
        Functions.Function1<String, TableDefinition> _function = new Functions.Function1<String, TableDefinition>(){

            public TableDefinition apply(String value) {
                return ProcessorMetaValidator.this.modelProperty.getModelTables(artifacts).get(value);
            }
        };
        List tableDefinitions = ListExtensions.map(Utils.getTokensFromModifier(statement, "tab"), (Functions.Function1)_function);
        TableDefinition tableDefinition = (TableDefinition)IterableExtensions.findFirst((Iterable)tableDefinitions, (Functions.Function1)(_function_1 = new Functions.Function1<TableDefinition, Boolean>(){

            public Boolean apply(TableDefinition it) {
                String _table = it.getTable();
                return Objects.equal((Object)_table, (Object)tableName);
            }
        }));
        if (Objects.equal((Object)tableDefinition, null) || !this.dbResolver.checkTable(databaseTable, tableName)) {
            this.error("Cannot find table in DB : " + tableName, (EStructuralFeature)ProcessorMetaPackage.Literals.DATABASE_TABLE__NAME);
        }
    }

    public void _checkDatabaseColumn(DatabaseColumn databaseColumn) {
        String tableName;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(databaseColumn);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            return;
        }
        boolean _skipVerification = CommonUtils.skipVerification(databaseColumn, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        String prefix = databaseColumn.getName();
        String columnName = null;
        int pos = prefix.indexOf(".");
        if (pos > 0) {
            prefix = databaseColumn.getName().substring(0, pos);
            columnName = databaseColumn.getName().substring(pos + 1);
        } else {
            prefix = null;
            columnName = databaseColumn.getName();
        }
        MetaStatement statement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)databaseColumn, MetaStatement.class);
        Artifacts artifacts = this.getArtifacts(statement);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        String value = Utils.getTokenFromModifier(statement, "tab", prefix);
        TableDefinition _xifexpression = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)value, null);
        if (_notEquals) {
            _xifexpression = this.modelProperty.getModelTables(artifacts).get(value);
        }
        TableDefinition tableDefinition = _xifexpression;
        String _xifexpression_1 = null;
        boolean bl3 = _notEquals_1 = !Objects.equal(tableDefinition, null);
        if (_notEquals_1) {
            _xifexpression_1 = tableDefinition.getTable();
        }
        if (Objects.equal((Object)(tableName = _xifexpression_1), null) || !this.dbResolver.checkColumn(databaseColumn, tableName, columnName)) {
            String _name = databaseColumn.getName();
            String _plus = "Cannot find column in DB : " + _name;
            String _plus_1 = String.valueOf(_plus) + "[";
            String _plus_2 = String.valueOf(_plus_1) + tableName;
            String _plus_3 = String.valueOf(_plus_2) + "]";
            this.error(_plus_3, (EStructuralFeature)ProcessorMetaPackage.Literals.DATABASE_COLUMN__NAME);
        }
    }

    public Artifacts getArtifacts(EObject model) {
        EObject root = EcoreUtil.getRootContainer((EObject)model);
        if (!(root instanceof Artifacts)) {
            return null;
        }
        return (Artifacts)root;
    }

    public boolean isPrimitive(Class<?> clazz) {
        boolean _equals = Objects.equal(clazz, null);
        if (_equals) {
            return true;
        }
        boolean _equals_1 = Objects.equal(clazz, String.class);
        if (_equals_1) {
            return true;
        }
        boolean _equals_2 = Objects.equal(clazz, Byte.class);
        if (_equals_2) {
            return true;
        }
        boolean _equals_3 = Objects.equal(clazz, Short.class);
        if (_equals_3) {
            return true;
        }
        boolean _equals_4 = Objects.equal(clazz, Integer.class);
        if (_equals_4) {
            return true;
        }
        boolean _equals_5 = Objects.equal(clazz, Long.class);
        if (_equals_5) {
            return true;
        }
        boolean _equals_6 = Objects.equal(clazz, Double.class);
        if (_equals_6) {
            return true;
        }
        boolean _equals_7 = Objects.equal(clazz, Float.class);
        if (_equals_7) {
            return true;
        }
        boolean _equals_8 = Objects.equal(clazz, Boolean.class);
        if (_equals_8) {
            return true;
        }
        boolean _equals_9 = Objects.equal(clazz, java.util.Date.class);
        if (_equals_9) {
            return true;
        }
        boolean _equals_10 = Objects.equal(clazz, Date.class);
        if (_equals_10) {
            return true;
        }
        boolean _equals_11 = Objects.equal(clazz, Time.class);
        if (_equals_11) {
            return true;
        }
        boolean _equals_12 = Objects.equal(clazz, Timestamp.class);
        if (_equals_12) {
            return true;
        }
        boolean _equals_13 = Objects.equal(clazz, Blob.class);
        if (_equals_13) {
            return true;
        }
        boolean _equals_14 = Objects.equal(clazz, Clob.class);
        if (_equals_14) {
            return true;
        }
        boolean _equals_15 = Objects.equal(clazz, BigDecimal.class);
        if (_equals_15) {
            return true;
        }
        boolean _equals_16 = Objects.equal(clazz, BigInteger.class);
        return _equals_16;
    }

    public boolean isPrimitive(String name) {
        boolean _equals = Objects.equal((Object)name, null);
        if (_equals) {
            return true;
        }
        boolean _equals_1 = Objects.equal((Object)name, (Object)"java.lang.String");
        if (_equals_1) {
            return true;
        }
        boolean _equals_2 = Objects.equal((Object)name, (Object)"java.lang.Byte");
        if (_equals_2) {
            return true;
        }
        boolean _equals_3 = Objects.equal((Object)name, (Object)"java.lang.Short");
        if (_equals_3) {
            return true;
        }
        boolean _equals_4 = Objects.equal((Object)name, (Object)"java.lang.Integer");
        if (_equals_4) {
            return true;
        }
        boolean _equals_5 = Objects.equal((Object)name, (Object)"java.lang.Long");
        if (_equals_5) {
            return true;
        }
        boolean _equals_6 = Objects.equal((Object)name, (Object)"java.lang.Double");
        if (_equals_6) {
            return true;
        }
        boolean _equals_7 = Objects.equal((Object)name, (Object)"java.lang.Float");
        if (_equals_7) {
            return true;
        }
        boolean _equals_8 = Objects.equal((Object)name, (Object)"java.lang.Boolean");
        if (_equals_8) {
            return true;
        }
        boolean _equals_9 = Objects.equal((Object)name, (Object)"java.util.Date");
        if (_equals_9) {
            return true;
        }
        boolean _equals_10 = Objects.equal((Object)name, (Object)"java.sql.Date");
        if (_equals_10) {
            return true;
        }
        boolean _equals_11 = Objects.equal((Object)name, (Object)"java.sql.Time");
        if (_equals_11) {
            return true;
        }
        boolean _equals_12 = Objects.equal((Object)name, (Object)"java.sql.Timestamp");
        if (_equals_12) {
            return true;
        }
        boolean _equals_13 = Objects.equal((Object)name, (Object)"java.sql.Blob");
        if (_equals_13) {
            return true;
        }
        boolean _equals_14 = Objects.equal((Object)name, (Object)"java.sql.Clob");
        if (_equals_14) {
            return true;
        }
        boolean _equals_15 = Objects.equal((Object)name, (Object)"java.math.BigDecimal");
        if (_equals_15) {
            return true;
        }
        boolean _equals_16 = Objects.equal((Object)name, (Object)"java.math.BigInteger");
        return _equals_16;
    }

    public boolean isResolvePojo(EObject model) {
        return this.modelProperty.isDoResolvePojo(model);
    }

    public boolean isResolveDb(EObject model) {
        return this.dbResolver.isResolveDb(model);
    }
}

