/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.meta.generator;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.sqlproc.meta.processorMeta.Artifacts;
import org.sqlproc.meta.processorMeta.MetaStatement;
import org.sqlproc.meta.util.Utils;
import org.sqlproc.plugin.lib.generator.TableBaseGenerator;
import org.sqlproc.plugin.lib.property.ModelProperty;
import org.sqlproc.plugin.lib.property.PairValues;
import org.sqlproc.plugin.lib.property.PojoAttribute;
import org.sqlproc.plugin.lib.property.PojoEntityType;
import org.sqlproc.plugin.lib.property.TableDefinition;
import org.sqlproc.plugin.lib.resolver.DbResolver;
import org.sqlproc.plugin.lib.util.Debug;
import org.sqlproc.plugin.lib.util.Stats;

public class TableMetaGenerator
extends TableBaseGenerator {
    protected Logger LOGGER = Logger.getLogger(TableMetaGenerator.class);
    private Debug debug = new Debug(this.LOGGER);
    protected Map<String, String> finalMetas;
    protected Artifacts artifacts;
    protected IScopeProvider scopeProvider;
    protected PairValues metaGlobalSequence;
    protected Map<String, PairValues> metaTablesSequence = new HashMap<String, PairValues>();
    protected PairValues metaGlobalIdentity;
    protected Map<String, PairValues> metaTablesIdentity = new HashMap<String, PairValues>();
    protected Map<String, PairValues> metaSqlTypes = new HashMap<String, PairValues>();
    protected Map<String, Map<String, PairValues>> metaColumnsMetaTypes = new HashMap<String, Map<String, PairValues>>();
    protected Map<String, Map<String, PairValues>> metaStatementsMetaTypes = new HashMap<String, Map<String, PairValues>>();
    protected boolean metaMakeItFinal;
    protected Map<String, Set<String>> metaLikeColumns = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> metaNotLikeColumns = new HashMap<String, Set<String>>();
    protected boolean metaGenerateSequences;
    protected Set<String> metaGlobalSequenceForTables = new HashSet<String>();
    protected Set<String> metaGlobalSequenceNotForTables = new HashSet<String>();
    protected boolean metaGenerateIdentities;
    protected Set<String> metaGlobalIdentityForTables = new HashSet<String>();
    protected Set<String> metaGlobalIdentityNotForTables = new HashSet<String>();
    protected boolean metaGenerateIdGenerators;
    protected boolean metaGenerateIndirectIdGenerators;
    protected Map<String, StringBuilder> sequences = null;
    protected Map<String, StringBuilder> identities = null;
    protected boolean metaGenerateOperators = false;
    protected Set<String> metaOptimizeInsert = new HashSet<String>();
    protected Map<String, Set<String>> metaOptionalFeatures = new HashMap<String, Set<String>>();
    protected MetaFilter metaActiveFilter = null;
    protected boolean metaInsertSkipDefaultValues = false;
    protected Set<String> metaInsertSkipDefaultValuesPos = new HashSet<String>();
    protected Set<String> metaInsertSkipDefaultValuesNeg = new HashSet<String>();

    public TableMetaGenerator(ModelProperty modelProperty, Artifacts artifacts, IScopeProvider scopeProvider, Map<String, String> finalMetas, List<String> dbSequences, DbResolver.DbType dbType) {
        super(modelProperty, artifacts, dbSequences, dbType);
        Set<String> metaInsertSkipDefaultValuesNeg;
        Map<String, Set<String>> metaOptionalFeatures;
        Set<String> metaGlobalIdentityNotForTables;
        Set<String> metaGlobalSequenceNotForTables;
        Map<String, Set<String>> metaNotLikeColumns;
        Map<String, Map<String, PairValues>> statementsMetaTypes;
        Map<String, Map<String, PairValues>> columnsMetaTypes;
        Map<String, PairValues> metaSqlTypes;
        this.scopeProvider = scopeProvider;
        this.artifacts = artifacts;
        this.finalMetas = finalMetas;
        this.debug = new Debug(modelProperty.getMetaDebugLevel(artifacts), modelProperty.getMetaDebugScope(artifacts), this.LOGGER);
        this.metaGlobalSequence = modelProperty.getMetaGlobalSequence(artifacts);
        Map<String, PairValues> tablesSequence = modelProperty.getMetaTablesSequence(artifacts);
        if (tablesSequence != null) {
            this.metaTablesSequence.putAll(tablesSequence);
        }
        this.metaGlobalIdentity = modelProperty.getMetaGlobalIdentity(artifacts);
        Map<String, PairValues> tablesIdentity = modelProperty.getMetaTablesIdentity(artifacts);
        if (tablesIdentity != null) {
            this.metaTablesIdentity.putAll(tablesIdentity);
        }
        if ((metaSqlTypes = modelProperty.getMetaSqlTypes(this.model)) != null) {
            this.metaSqlTypes.putAll(metaSqlTypes);
            for (Map.Entry<String, PairValues> e : metaSqlTypes.entrySet()) {
                this.metaSqlTypes.put(e.getKey().toLowerCase(), e.getValue());
                this.metaSqlTypes.put(e.getKey().toUpperCase(), e.getValue());
            }
        }
        if ((columnsMetaTypes = modelProperty.getMetaColumnsMetaTypes(artifacts)) != null) {
            this.metaColumnsMetaTypes.putAll(columnsMetaTypes);
        }
        if ((statementsMetaTypes = modelProperty.getMetaStatementsMetaTypes(artifacts)) != null) {
            this.metaStatementsMetaTypes.putAll(statementsMetaTypes);
        }
        this.metaMakeItFinal = modelProperty.isMetaMakeItFinal(artifacts);
        Map<String, Set<String>> metaLikeColumns = modelProperty.getMetaLikeColumns(artifacts);
        if (metaLikeColumns != null) {
            this.metaLikeColumns.putAll(metaLikeColumns);
        }
        if ((metaNotLikeColumns = modelProperty.getMetaNotLikeColumns(artifacts)) != null) {
            this.metaNotLikeColumns.putAll(metaNotLikeColumns);
        }
        this.metaGenerateSequences = modelProperty.isMetaGenerateSequences(artifacts);
        Set<String> metaGlobalSequenceForTables = modelProperty.getMetaGlobalSequenceForTables(artifacts);
        if (metaGlobalSequenceForTables != null) {
            this.metaGlobalSequenceForTables.addAll(metaGlobalSequenceForTables);
        }
        if ((metaGlobalSequenceNotForTables = modelProperty.getMetaGlobalSequenceNotForTables(artifacts)) != null) {
            this.metaGlobalSequenceNotForTables.addAll(metaGlobalSequenceNotForTables);
        }
        this.metaGenerateIdentities = modelProperty.isMetaGenerateIdentities(artifacts);
        Set<String> metaGlobalIdentityForTables = modelProperty.getMetaGlobalIdentityForTables(artifacts);
        if (metaGlobalIdentityForTables != null) {
            this.metaGlobalIdentityForTables.addAll(metaGlobalIdentityForTables);
        }
        if ((metaGlobalIdentityNotForTables = modelProperty.getMetaGlobalIdentityNotForTables(artifacts)) != null) {
            this.metaGlobalIdentityNotForTables.addAll(metaGlobalIdentityNotForTables);
        }
        this.metaGenerateIdGenerators = modelProperty.isMetaGenerateIdGenerators(artifacts);
        this.metaGenerateIndirectIdGenerators = modelProperty.isMetaGenerateIndirectIdGenerators(artifacts);
        if (this.metaGenerateIdGenerators || this.metaGenerateIndirectIdGenerators) {
            if (!(this.metaGlobalSequence == null && this.metaTablesSequence.isEmpty() && this.metaGlobalSequenceForTables.isEmpty() && this.metaGlobalSequenceNotForTables.isEmpty())) {
                this.metaGenerateSequences = true;
            }
            if (!(this.metaGlobalIdentity == null && this.metaTablesIdentity.isEmpty() && this.metaGlobalIdentityForTables.isEmpty() && this.metaGlobalIdentityNotForTables.isEmpty())) {
                this.metaGenerateIdentities = true;
            }
        }
        if (this.metaGenerateSequences && dbType != null) {
            this.sequences = new HashMap<String, StringBuilder>();
            for (String sequence : dbSequences) {
                this.metaSequenceDefinition(sequence, this.sequences);
            }
            if (this.metaGlobalSequence != null) {
                this.metaSequenceDefinition(this.metaGlobalSequence.value1, this.sequences);
            }
            for (PairValues metaTableSequence : this.metaTablesSequence.values()) {
                this.metaSequenceDefinition(metaTableSequence.value1, this.sequences);
            }
            if (this.sequences.isEmpty()) {
                this.metaSequenceDefinition(null, this.sequences);
            }
        }
        if (this.metaGenerateIdentities && dbType != null) {
            this.identities = new HashMap<String, StringBuilder>();
            if (this.metaGlobalIdentity != null) {
                this.metaIdentityDefinition(this.metaGlobalIdentity.value1, this.identities);
            }
            for (PairValues metaTableIdentity : this.metaTablesIdentity.values()) {
                this.metaIdentityDefinition(metaTableIdentity.value1, this.identities);
            }
            if (this.identities.isEmpty()) {
                this.metaIdentityDefinition(null, this.identities);
            }
        }
        this.metaGenerateOperators = modelProperty.isMetaGenerateOperators(artifacts);
        Set<String> metaOptimizeInsert = modelProperty.getMetaOptimizeInsert(artifacts);
        if (metaOptimizeInsert != null) {
            this.metaOptimizeInsert.addAll(metaOptimizeInsert);
        }
        if ((metaOptionalFeatures = modelProperty.getMetaOptionalFeatures(artifacts)) != null) {
            this.metaOptionalFeatures.putAll(metaOptionalFeatures);
        }
        this.metaActiveFilter = MetaFilter.parse(modelProperty.getMetaActiveFilter(artifacts));
        this.metaInsertSkipDefaultValues = modelProperty.isMetaInsertSkipDefaultValues(artifacts);
        Set<String> metaInsertSkipDefaultValuesPos = modelProperty.getMetaInsertSkipDefaultValuesPos(artifacts);
        if (metaInsertSkipDefaultValuesPos != null) {
            this.metaInsertSkipDefaultValuesPos.addAll(metaInsertSkipDefaultValuesPos);
        }
        if ((metaInsertSkipDefaultValuesNeg = modelProperty.getMetaInsertSkipDefaultValuesNeg(artifacts)) != null) {
            this.metaInsertSkipDefaultValuesNeg.addAll(metaInsertSkipDefaultValuesNeg);
        }
        for (String pojo : this.metaTablesIdentity.keySet()) {
            this.metaGlobalIdentityNotForTables.add(pojo);
            this.metaGlobalSequenceNotForTables.add(pojo);
        }
        for (String pojo : this.metaTablesSequence.keySet()) {
            this.metaGlobalIdentityNotForTables.add(pojo);
            this.metaGlobalSequenceNotForTables.add(pojo);
        }
        if (this.metaGlobalIdentity != null) {
            this.metaGlobalSequence = null;
            for (String pojo : this.pojos.keySet()) {
                if (this.metaTablesSequence.containsKey(pojo)) continue;
                metaGlobalIdentityNotForTables.add(pojo);
            }
        }
        if (this.metaGlobalSequence != null) {
            this.metaGlobalIdentity = null;
            for (String pojo : this.pojos.keySet()) {
                if (this.metaTablesIdentity.containsKey(pojo)) continue;
                metaGlobalSequenceNotForTables.add(pojo);
            }
        }
        this.debug.debug("finalMetas " + this.finalMetas);
        this.debug.debug("metaGlobalSequence " + this.metaGlobalSequence);
        this.debug.debug("metaTablesSequence " + this.metaTablesSequence);
        this.debug.debug("metaGlobalIdentity " + this.metaGlobalIdentity);
        this.debug.debug("metaTablesIdentity " + this.metaTablesIdentity);
        this.debug.debug("metaSqlTypes " + this.metaSqlTypes);
        this.debug.debug("metaColumnsMetaTypes " + this.metaColumnsMetaTypes);
        this.debug.debug("metaStatementsMetaTypes " + this.metaStatementsMetaTypes);
        this.debug.debug("metaMakeItFinal " + this.metaMakeItFinal);
        this.debug.debug("metaLikeColumns " + this.metaLikeColumns);
        this.debug.debug("metaNotLikeColumns " + this.metaNotLikeColumns);
        this.debug.debug("metaGenerateSequences " + this.metaGenerateSequences);
        this.debug.debug("metaGlobalSequenceForTables " + this.metaGlobalSequenceForTables);
        this.debug.debug("metaGlobalSequenceNotForTables " + this.metaGlobalSequenceNotForTables);
        this.debug.debug("metaGenerateIdentities " + this.metaGenerateIdentities);
        this.debug.debug("metaGlobalIdentityForTables " + this.metaGlobalIdentityForTables);
        this.debug.debug("metaGlobalIdentityNotForTables " + this.metaGlobalIdentityNotForTables);
        this.debug.debug("metaGenerateIdGenerators " + this.metaGenerateIdGenerators);
        this.debug.debug("metaGenerateIndirectIdGenerators " + this.metaGenerateIndirectIdGenerators);
        this.debug.debug("metaGenerateOperators " + this.metaGenerateOperators);
        this.debug.debug("metaOptimizeInsert " + this.metaOptimizeInsert);
        this.debug.debug("metaOptionalFeatures " + this.metaOptionalFeatures);
        this.debug.debug("metaActiveFilter " + this.metaActiveFilter);
        this.debug.debug("metaInsertSkipDefaultValues " + this.metaInsertSkipDefaultValues);
        this.debug.debug("metaInsertSkipDefaultValuesPos " + this.metaInsertSkipDefaultValuesPos);
        this.debug.debug("metaInsertSkipDefaultValuesNeg " + this.metaInsertSkipDefaultValuesNeg);
    }

    public String getMetaDefinitions(ModelProperty modelProperty, Artifacts artifacts) {
        String result = this.getMetaDefinitions();
        return Utils.replaceAll(modelProperty, result, artifacts);
    }

    public String getMetaDefinitions() {
        this.debug.debug("pojos " + this.pojos);
        this.debug.debug("pojoExtends " + this.pojoExtends);
        this.debug.debug("pojoInheritanceDiscriminator " + this.pojoInheritanceDiscriminator);
        this.debug.debug("pojoInheritanceSimple " + this.pojoInheritanceSimple);
        this.debug.debug("pojoDiscriminators " + this.pojoDiscriminators);
        this.debug.debug("indexes " + this.indexes);
        this.debug.debug("procedures " + this.procedures);
        this.debug.debug("functions " + this.functions);
        if (this.metaGenerateSequences && this.dbType == DbResolver.DbType.MY_SQL) {
            for (String pojo : this.pojos.keySet()) {
                this.metaSequenceDefinition(pojo, null, this.sequences);
            }
        }
        if (this.metaGenerateIdentities && this.dbType == DbResolver.DbType.POSTGRESQL) {
            for (String pojo : this.pojos.keySet()) {
                Pair<String, String> primaryKey = this.getPrimaryKey(pojo);
                if (primaryKey == null) continue;
                this.metaIdentityDefinition(pojo, (String)primaryKey.getFirst(), this.identities);
            }
        }
        StringBuilder buffer = new StringBuilder();
        if (this.sequences != null && MetaFilter.isGenerate(this.metaActiveFilter, "only-insert")) {
            for (StringBuilder sequence : this.sequences.values()) {
                buffer.append((CharSequence)sequence);
            }
        }
        if (this.identities != null && MetaFilter.isGenerate(this.metaActiveFilter, "only-insert")) {
            for (StringBuilder identity : this.identities.values()) {
                buffer.append((CharSequence)identity);
            }
        }
        for (String pojo : this.pojos.keySet()) {
            if (!this.onlyTables.isEmpty() && !this.onlyTables.contains(pojo) || this.ignoreTables.contains(pojo) || this.pojoInheritanceDiscriminator.containsKey(pojo) || this.metaProceduresResultSet.values().contains(pojo) && !this.tables.contains(pojo) || !MetaFilter.isTable(this.metaActiveFilter, pojo)) continue;
            if (MetaFilter.isGenerate(this.metaActiveFilter, "only-insert")) {
                buffer.append((CharSequence)this.metaInsertDefinition(pojo));
            }
            if (MetaFilter.isGenerate(this.metaActiveFilter, "only-get")) {
                buffer.append((CharSequence)this.metaGetSelectDefinition(pojo, false));
            }
            if (MetaFilter.isGenerate(this.metaActiveFilter, "only-update")) {
                buffer.append((CharSequence)this.metaUpdateDefinition(pojo));
            }
            if (MetaFilter.isGenerate(this.metaActiveFilter, "only-delete")) {
                buffer.append((CharSequence)this.metaDeleteDefinition(pojo));
            }
            if (!MetaFilter.isGenerate(this.metaActiveFilter, "only-select")) continue;
            buffer.append((CharSequence)this.metaGetSelectDefinition(pojo, true));
        }
        if (MetaFilter.isGenerate(this.metaActiveFilter, "only-call")) {
            for (String pojo : this.procedures.keySet()) {
                if (this.ignoreTables.contains(pojo)) continue;
                boolean isFunction = this.functions.containsKey(pojo);
                buffer.append((CharSequence)this.metaCallProcedureDefinition(pojo, isFunction));
            }
            for (String pojo : this.functions.keySet()) {
                if (this.ignoreTables.contains(pojo) || this.procedures.containsKey(pojo)) continue;
                buffer.append((CharSequence)this.metaCallFunctionDefinition(pojo));
            }
        }
        return buffer.toString();
    }

    StringBuilder metaInsertDefinition(String pojo) {
        StringBuilder buffer = new StringBuilder();
        Header header = this.getStatementHeader(pojo, buffer, StatementType.INSERT, null);
        if (header == null) {
            return buffer;
        }
        buffer.append("\n  insert into %%").append(header.table.realTableName);
        if (this.metaOptimizeInsert.contains(pojo) || this.metaOptimizeInsert.contains("_ALL_")) {
            buffer.append(" {= columns (");
        } else {
            buffer.append(" (");
        }
        String parentPojo = this.pojoDiscriminators.containsKey(header.table.tableName) ? (String)this.pojoExtends.get(header.table.tableName) : null;
        boolean first = !this.metaOptimizeInsert.contains(pojo) && !this.metaOptimizeInsert.contains("_ALL_");
        first = this.insertColumns(buffer, pojo, first);
        if (parentPojo != null) {
            this.insertColumns(buffer, parentPojo, first);
        }
        if (this.metaOptimizeInsert.contains(pojo) || this.metaOptimizeInsert.contains("_ALL_")) {
            buffer.append("\n  ) }\n  {= values (");
        } else {
            buffer.append(")\n  {= values (");
        }
        first = !this.metaOptimizeInsert.contains(pojo) && !this.metaOptimizeInsert.contains("_ALL_");
        first = this.insertIdentity(buffer, pojo, first);
        if (parentPojo != null) {
            first = this.insertIdentity(buffer, parentPojo, first);
        }
        first = this.insertValues(buffer, pojo, first, header.statementName);
        if (parentPojo != null) {
            this.insertValues(buffer, parentPojo, first, header.statementName);
        }
        if (this.metaOptimizeInsert.contains(pojo) || this.metaOptimizeInsert.contains("_ALL_")) {
            buffer.append("\n  ) }");
        } else {
            buffer.append(") }");
        }
        buffer.append("\n;\n");
        return buffer;
    }

    Pair<String, String> getPrimaryKey(String pojo) {
        for (Map.Entry pentry : ((Map)this.pojos.get(pojo)).entrySet()) {
            PojoAttribute attr = (PojoAttribute)pentry.getValue();
            if (attr == null || !attr.isPrimaryKey()) continue;
            return Tuples.pair((Object)attr.getDbName(), (Object)attr.getName());
        }
        return null;
    }

    StringBuilder metaGetSelectDefinition(String pojo, boolean select) {
        Table table;
        StringBuilder buffer = new StringBuilder();
        Header header = this.getStatementHeader(pojo, buffer, select ? StatementType.SELECT : StatementType.GET, null);
        if (header == null) {
            return buffer;
        }
        Pair<String, String> primaryKey = this.getPrimaryKey(pojo);
        buffer.append("\n  select ");
        if (this.doGenerateFromTo && select && primaryKey != null) {
            buffer.append("{? :onlyIds_ | %").append(this.tablePrefix(header.table.tablePrefix)).append((String)primaryKey.getFirst()).append(" @" + (String)primaryKey.getSecond() + "(id) |\n    ");
        }
        String parentPojo = this.pojoDiscriminators.containsKey(header.table.tableName) ? (String)this.pojoExtends.get(header.table.tableName) : null;
        boolean first = this.selectColumns(buffer, pojo, true, header.statementName, header.table.tablePrefix, null, false, header.assocTables, null, header.discrTables, header.inherTables, null);
        if (parentPojo != null) {
            first = this.selectColumns(buffer, parentPojo, first, header.statementName, header.table.tablePrefix, null, false, header.assocTables, null, header.discrTables, header.inherTables, null);
        }
        if (header.table.tablePrefix != null) {
            if (header.extendTable.tableName != null) {
                if (!first) {
                    if (this.doGenerateFromTo && select && primaryKey != null) {
                        buffer.append("\n    ");
                    } else {
                        buffer.append("\n         ");
                    }
                }
                first = this.selectColumns(buffer, header.extendTable.tableName, first, header.statementName, header.extendTable.tablePrefix, null, true, header.assocTables, null, header.discrTables, header.inherTables, null);
            }
            if (!header.assocTables.isEmpty()) {
                for (Map.Entry<String, Table> entry : header.assocTables.entrySet()) {
                    table = entry.getValue();
                    if (!first) {
                        if (this.doGenerateFromTo && select && primaryKey != null) {
                            buffer.append("\n    ");
                        } else {
                            buffer.append("\n         ");
                        }
                    }
                    if (table.toInit) {
                        buffer.append("{? :").append(table.attrName).append("(call=toInit) | ");
                    }
                    if (table.many2many) {
                        if (header.inherTables.containsKey(entry.getKey())) {
                            for (Table table2 : header.inherTables.get(entry.getKey())) {
                                first = this.selectColumns(buffer, table2.realTableName, first, header.statementName, table2.tablePrefix, table2.attrName, false, header.assocTables, table2.discriminator, Collections.EMPTY_MAP, Collections.EMPTY_MAP, table2.inheritance);
                            }
                        }
                        Table table3 = header.m2mTables.get(entry.getKey());
                        first = this.selectColumns(buffer, table3.realTableName, first, header.statementName, table3.tablePrefix, table.attrName, false, Collections.EMPTY_MAP, null, Collections.EMPTY_MAP, Collections.EMPTY_MAP, null);
                    } else {
                        if (header.inherTables.containsKey(entry.getKey())) {
                            for (Table table4 : header.inherTables.get(entry.getKey())) {
                                first = this.selectColumns(buffer, table4.realTableName, first, header.statementName, table4.tablePrefix, table4.attrName, false, header.assocTables, table4.discriminator, Collections.EMPTY_MAP, Collections.EMPTY_MAP, table4.inheritance);
                            }
                        }
                        first = this.selectColumns(buffer, table.realTableName, first, header.statementName, table.tablePrefix, table.attrName, !table.one2many, header.assocTables, table.discriminator, Collections.EMPTY_MAP, Collections.EMPTY_MAP, table.inheritance);
                    }
                    if (table.discriminator != null && this.inheritance.containsKey(table.tableName)) {
                        for (Map.Entry entry2 : ((Map)this.inheritance.get(table.tableName)).entrySet()) {
                            for (Map.Entry tentry : ((Map)entry2.getValue()).entrySet()) {
                                String tableName = (String)tentry.getKey();
                                first = this.selectColumns(buffer, tableName, first, header.statementName, table.tablePrefix, table.attrName, true, Collections.EMPTY_MAP, null, Collections.EMPTY_MAP, Collections.EMPTY_MAP, null);
                            }
                        }
                    }
                    if (!table.toInit) continue;
                    buffer.append(" }");
                }
            }
        }
        if (this.doGenerateFromTo && select && primaryKey != null) {
            buffer.append("\n  }");
        }
        buffer.append("\n  from %%").append(header.table.realTableName);
        if (header.table.tablePrefix != null) {
            buffer.append(" ").append(header.table.tablePrefix);
            if (header.extendTable.tableName != null) {
                buffer.append("\n  join %%").append(header.extendTable.tableName);
                buffer.append(" ").append(header.extendTable.tablePrefix);
                buffer.append(" on %").append(header.table.tablePrefix).append(".");
                buffer.append(header.extendTable.primaryKey);
                buffer.append(" = %").append(header.extendTable.tablePrefix).append(".");
                buffer.append(header.extendTable.tableKey);
            }
            if (!header.assocTables.isEmpty()) {
                for (Map.Entry<String, Table> entry : header.assocTables.entrySet()) {
                    table = entry.getValue();
                    buffer.append("\n  ");
                    if (table.toInit) {
                        buffer.append("{? :").append(table.attrName).append("(call=toInit) | ");
                    }
                    buffer.append("left join %%").append(table.realTableName);
                    buffer.append(" ").append(table.tablePrefix);
                    buffer.append(" on %").append(table.oppositePrefix).append(".");
                    buffer.append(table.primaryKey);
                    buffer.append(" = %").append(table.tablePrefix).append(".");
                    buffer.append(table.tableKey);
                    if (header.m2mTables.containsKey(entry.getKey())) {
                        Table table5 = header.m2mTables.get(entry.getKey());
                        buffer.append(" left join %%").append(table5.realTableName);
                        buffer.append(" ").append(table5.tablePrefix);
                        buffer.append(" on %").append(table5.oppositePrefix).append(".");
                        buffer.append(table5.primaryKey);
                        buffer.append(" = %").append(table5.tablePrefix).append(".");
                        buffer.append(table5.tableKey);
                    }
                    if (header.inherTables.containsKey(entry.getKey())) {
                        for (Table table6 : header.inherTables.get(entry.getKey())) {
                            buffer.append(" left join %%").append(table6.realTableName);
                            buffer.append(" ").append(table6.tablePrefix);
                            buffer.append(" on %").append(table6.oppositePrefix).append(".");
                            buffer.append(table6.primaryKey);
                            buffer.append(" = %").append(table6.tablePrefix).append(".");
                            buffer.append(table6.tableKey);
                        }
                    }
                    if (!table.toInit) continue;
                    buffer.append(" }");
                }
            }
        }
        buffer.append("\n  {= where");
        first = this.whereColumns(buffer, pojo, first, header.statementName, header.table.tablePrefix, false, select);
        if (parentPojo != null) {
            this.whereColumns(buffer, parentPojo, first, header.statementName, header.table.tablePrefix, false, select);
        } else if (header.extendTable.tableName != null) {
            this.whereColumns(buffer, header.extendTable.tableName, first, header.statementName, header.extendTable.tablePrefix, true, select);
        }
        if (this.doGenerateFromTo && select && primaryKey != null) {
            buffer.append("\n    {& %").append(this.tablePrefix(header.table.tablePrefix)).append((String)primaryKey.getFirst()).append(" in :ids_ }");
        }
        buffer.append("\n  }");
        if (select) {
            first = this.generateMethods.contains("index") && this.indexes.containsKey(pojo) ? this.index2Columns(buffer, pojo, first, header.statementName, header.table.tablePrefix) : this.indexColumns(buffer, pojo, first, header.statementName, header.table.tablePrefix);
        }
        buffer.append("\n;\n");
        return buffer;
    }

    StringBuilder metaUpdateDefinition(String pojo) {
        StringBuilder buffer = new StringBuilder();
        Header header = this.getStatementHeader(pojo, buffer, StatementType.UPDATE, null);
        if (header == null) {
            return buffer;
        }
        buffer.append("\n  update %%").append(header.table.realTableName);
        buffer.append("\n  {= set");
        String parentPojo = this.pojoDiscriminators.containsKey(header.table.tableName) ? (String)this.pojoExtends.get(header.table.tableName) : null;
        boolean first = this.updateColumns(buffer, pojo, true, header.statementName);
        if (parentPojo != null) {
            this.updateColumns(buffer, parentPojo, first, header.statementName);
        }
        buffer.append("\n  }\n  {= where");
        first = this.wherePrimaryKeys(buffer, pojo, first, header.statementName);
        if (parentPojo != null) {
            this.wherePrimaryKeys(buffer, parentPojo, first, header.statementName);
        }
        buffer.append("\n  }");
        buffer.append("\n;\n");
        return buffer;
    }

    StringBuilder metaDeleteDefinition(String pojo) {
        StringBuilder buffer = new StringBuilder();
        Header header = this.getStatementHeader(pojo, buffer, StatementType.DELETE, null);
        if (header == null) {
            return buffer;
        }
        buffer.append("\n  delete from %%").append(header.table.realTableName);
        buffer.append("\n  {= where");
        String parentPojo = this.pojoDiscriminators.containsKey(header.table.tableName) ? (String)this.pojoExtends.get(header.table.tableName) : null;
        boolean first = this.wherePrimaryKeys(buffer, pojo, true, header.statementName);
        if (parentPojo != null) {
            this.wherePrimaryKeys(buffer, parentPojo, first, header.statementName);
        }
        buffer.append("\n  }");
        buffer.append("\n;\n");
        return buffer;
    }

    boolean insertColumns(StringBuilder buffer, String pojo, boolean first) {
        for (Map.Entry pentry : ((Map)this.pojos.get(pojo)).entrySet()) {
            PojoAttribute attribute;
            PairValues identity;
            if (this.createColumns.containsKey(pojo) && ((Map)this.createColumns.get(pojo)).containsKey(pentry.getKey())) continue;
            if (this.ignoreColumns.containsKey(pojo) && ((Set)this.ignoreColumns.get(pojo)).contains(pentry.getKey())) {
                boolean ignore = true;
                if (this.inheritImports.containsKey(pojo) && ((Map)this.inheritImports.get(pojo)).containsKey(pentry.getKey())) {
                    ignore = false;
                }
                if (ignore) continue;
            }
            if (this.metaInsertSkipDefaultValues && ((PojoAttribute)pentry.getValue()).getDefaultValue() != null && (this.metaInsertSkipDefaultValuesPos.isEmpty() && this.metaInsertSkipDefaultValuesNeg.isEmpty() || !this.metaInsertSkipDefaultValuesPos.isEmpty() && !this.metaInsertSkipDefaultValuesPos.contains(pojo) || !this.metaInsertSkipDefaultValuesNeg.isEmpty() && this.metaInsertSkipDefaultValuesNeg.contains(pojo)) || (identity = this.getIdentity(pojo, (PojoAttribute)pentry.getValue())) != null && !this.metaGenerateIdGenerators && !this.metaGenerateIndirectIdGenerators || (attribute = (PojoAttribute)pentry.getValue()).getClassName().startsWith("java.util.List") || attribute.getOne2one() != null) continue;
            String name = null;
            if (this.metaOptimizeInsert.contains(pojo) || this.metaOptimizeInsert.contains("_ALL_")) {
                if (!attribute.isRequired()) {
                    Attribute attr = this.getStatementAttribute(pojo, (String)pentry.getKey(), (PojoAttribute)pentry.getValue(), true);
                    if (attr == null) continue;
                    name = this.columnNames.containsKey(attr.tableName) ? (String)((Map)this.columnNames.get(attr.tableName)).get(attr.attributeName) : null;
                    name = name == null ? attr.attribute.getName() : this.columnToCamelCase(name);
                }
                buffer.append("\n    ");
                if (name != null) {
                    buffer.append("{? :").append(name).append(" | ");
                }
            }
            if (!first) {
                buffer.append(name != null ? ",%" : ", %");
            } else {
                buffer.append("%");
            }
            buffer.append((String)pentry.getKey());
            if (name != null) {
                buffer.append("}");
            }
            first = false;
        }
        return first;
    }

    boolean insertIdentity(StringBuilder buffer, String pojo, boolean first) {
        PairValues identity = null;
        for (Map.Entry pentry : ((Map)this.pojos.get(pojo)).entrySet()) {
            if (this.createColumns.containsKey(pojo) && ((Map)this.createColumns.get(pojo)).containsKey(pentry.getKey()) || (identity = this.getIdentity(pojo, (PojoAttribute)pentry.getValue())) == null) continue;
            String name = this.columnNames.containsKey(pojo) ? (String)((Map)this.columnNames.get(pojo)).get(pentry.getKey()) : null;
            name = name == null ? ((PojoAttribute)pentry.getValue()).getName() : this.columnToCamelCase(name);
            if (this.metaOptimizeInsert.contains(pojo) || this.metaOptimizeInsert.contains("_ALL_")) {
                buffer.append("\n    :");
            } else {
                buffer.append(":");
            }
            buffer.append(name);
            buffer.append("(");
            if (identity.value2 != null) {
                buffer.append("type=").append(identity.value2).append(",");
            }
            if (this.metaGenerateIdGenerators) {
                buffer.append("idgen=");
                if (identity.value1 != null && !"null".equals(identity.value1)) {
                    buffer.append(identity.value1);
                } else {
                    buffer.append("IDSEL");
                }
                buffer.append(",id=").append((String)pentry.getKey());
            } else if (this.metaGenerateIndirectIdGenerators) {
                buffer.append("idgen=");
                if (identity.value1 != null && !"null".equals(identity.value1)) {
                    buffer.append(identity.value1);
                } else {
                    buffer.append("IDSEL");
                }
                buffer.append(",id=").append((String)pentry.getKey());
            } else {
                buffer.append("idsel");
                if (identity.value1 != null) {
                    buffer.append("=").append(identity.value1);
                }
            }
            buffer.append(")");
            first = false;
            break;
        }
        return first;
    }

    boolean insertValues(StringBuilder buffer, String pojo, boolean first, String statementName) {
        for (Map.Entry pentry : ((Map)this.pojos.get(pojo)).entrySet()) {
            Attribute attr;
            if (((PojoAttribute)pentry.getValue()).getOne2one() != null || (attr = this.getStatementAttribute(pojo, (String)pentry.getKey(), (PojoAttribute)pentry.getValue(), true)) == null || this.metaInsertSkipDefaultValues && ((PojoAttribute)pentry.getValue()).getDefaultValue() != null && (this.metaInsertSkipDefaultValuesPos.isEmpty() && this.metaInsertSkipDefaultValuesNeg.isEmpty() || !this.metaInsertSkipDefaultValuesPos.isEmpty() && !this.metaInsertSkipDefaultValuesPos.contains(pojo) || !this.metaInsertSkipDefaultValuesNeg.isEmpty() && this.metaInsertSkipDefaultValuesNeg.contains(pojo))) continue;
            String name = this.columnNames.containsKey(attr.tableName) ? (String)((Map)this.columnNames.get(attr.tableName)).get(attr.attributeName) : null;
            name = name == null ? attr.attribute.getName() : this.columnToCamelCase(name);
            if (this.metaOptimizeInsert.contains(pojo) || this.metaOptimizeInsert.contains("_ALL_")) {
                buffer.append("\n    ");
                if (!((PojoAttribute)pentry.getValue()).isRequired()) {
                    buffer.append("{? :").append(name).append(" | ");
                }
                if (!first) {
                    buffer.append(",:");
                } else {
                    buffer.append(":");
                }
            } else if (!first) {
                buffer.append(", :");
            } else {
                buffer.append(":");
            }
            buffer.append(name);
            if (attr.attribute.getPkTable() != null && attr.attribute.getRef() != null) {
                buffer.append(".").append(this.columnToCamelCase(attr.attribute.getPkColumn()));
            }
            if (attr.sequence != null) {
                buffer.append("(");
                if (attr.sequence.value2 != null) {
                    buffer.append("type=").append(attr.sequence.value2).append(",");
                }
                if (this.metaGenerateIdGenerators) {
                    buffer.append("idgen=");
                    buffer.append(attr.sequence.value1);
                    buffer.append(",id=").append((String)pentry.getKey());
                } else if (this.metaGenerateIndirectIdGenerators) {
                    buffer.append("idgen=");
                    buffer.append(attr.sequence.value1);
                    buffer.append(",id=").append((String)pentry.getKey());
                } else {
                    buffer.append("seq");
                    if (attr.sequence.value1 != null) {
                        buffer.append("=").append(attr.sequence.value1);
                    }
                }
            }
            if (this.metaTypes(buffer, attr.tableName, attr.attributeName, statementName, attr.completeSqlType, attr.sequence == null) || attr.sequence != null) {
                buffer.append(")");
            }
            if ((this.metaOptimizeInsert.contains(pojo) || this.metaOptimizeInsert.contains("_ALL_")) && !((PojoAttribute)pentry.getValue()).isRequired()) {
                buffer.append("}");
            }
            first = false;
        }
        return first;
    }

    boolean selectColumns(StringBuilder buffer, String pojo, boolean first, String statementName, String tablePrefix, String pojoPrefix, boolean notPrimaryKeys, Map<String, Table> assocTables, String discriminator, Map<String, Table> discrTables, Map<String, List<Table>> inherTables, String inheritance) {
        if (discriminator != null) {
            Attribute attr = this.getStatementAttribute(pojo, discriminator, (PojoAttribute)((Map)this.pojos.get(pojo)).get(discriminator), false);
            first = this.selectColumn(discriminator, attr, buffer, pojo, first, statementName, tablePrefix, pojoPrefix, notPrimaryKeys, assocTables, discriminator, inherTables, inheritance, false);
        }
        if (this.pojos.get(pojo) == null) {
            return first;
        }
        for (Map.Entry pentry : ((Map)this.pojos.get(pojo)).entrySet()) {
            if (discriminator != null && discriminator.equals(pentry.getKey()) || ((PojoAttribute)pentry.getValue()).getPkTable() != null && inherTables.containsKey(((PojoAttribute)pentry.getValue()).getPkTable()) || ((PojoAttribute)pentry.getValue()).getPkTable() != null && discrTables.containsKey(((PojoAttribute)pentry.getValue()).getPkTable()) || ((PojoAttribute)pentry.getValue()).getOne2one() != null) continue;
            Attribute attr = this.getStatementAttribute(pojo, (String)pentry.getKey(), (PojoAttribute)pentry.getValue(), false);
            first = this.selectColumn((String)pentry.getKey(), attr, buffer, pojo, first, statementName, tablePrefix, pojoPrefix, notPrimaryKeys, assocTables, null, inherTables, null, false);
            if (!this.preserveForeignKeys.contains(pojo) && !this.preserveForeignKeys.contains("_ALL_") || ((PojoAttribute)pentry.getValue()).getPkTable() == null) continue;
            first = this.selectColumn((String)pentry.getKey(), attr, buffer, pojo, first, statementName, tablePrefix, pojoPrefix, notPrimaryKeys, assocTables, null, inherTables, null, true);
        }
        return first;
    }

    boolean selectColumn(String colname, Attribute attr, StringBuilder buffer, String pojo, boolean first, String statementName, String tablePrefix, String pojoPrefix, boolean notPrimaryKeys, Map<String, Table> assocTables, String discriminator, Map<String, List<Table>> inherTables, String inheritance, boolean foreignKey) {
        if (attr == null) {
            return first;
        }
        if (attr.attribute.isPrimaryKey() && notPrimaryKeys) {
            return first;
        }
        String name = this.columnNames.containsKey(attr.tableName) ? (String)((Map)this.columnNames.get(attr.tableName)).get(attr.attributeName) : null;
        name = name == null ? attr.attribute.getName() : this.columnToCamelCase(name);
        if (!first) {
            buffer.append(", %");
        } else {
            buffer.append("%");
        }
        if (tablePrefix != null) {
            buffer.append(tablePrefix).append(".");
        }
        buffer.append(colname);
        buffer.append(" @");
        if (pojoPrefix != null) {
            buffer.append(pojoPrefix);
        }
        if (discriminator != null) {
            if (inheritance != null) {
                buffer.append("(gtype=").append(inheritance).append(")");
            } else {
                buffer.append("(discr)");
            }
        }
        if (pojoPrefix != null && discriminator == null) {
            buffer.append(".");
        }
        if (!foreignKey) {
            buffer.append(name);
            if (attr.attribute.getPkTable() != null && attr.attribute.getRef() != null) {
                buffer.append(".").append(this.columnToCamelCase(attr.attribute.getPkColumn()));
            }
            if (attr.attribute.isPrimaryKey() || assocTables.containsKey(colname)) {
                buffer.append("(id");
            }
            if (this.metaTypes(buffer, attr.tableName, attr.attributeName, statementName, attr.completeSqlType, !attr.attribute.isPrimaryKey() && !assocTables.containsKey(colname)) || attr.attribute.isPrimaryKey() || assocTables.containsKey(colname)) {
                buffer.append(")");
            }
        } else {
            buffer.append(this.columnToCamelCase(attr.attribute.getDbName()));
        }
        return false;
    }

    boolean whereColumns(StringBuilder buffer, String pojo, boolean first, String statementName, String prefix, boolean notPrimaryKeys, boolean select) {
        for (Map.Entry pentry : ((Map)this.pojos.get(pojo)).entrySet()) {
            Attribute attr = this.getStatementAttribute(pojo, (String)pentry.getKey(), (PojoAttribute)pentry.getValue(), false);
            if (attr == null || attr.attribute.isPrimaryKey() && notPrimaryKeys || attr.attribute.isVersion() || ((PojoAttribute)pentry.getValue()).getOne2one() != null) continue;
            boolean useLike = false;
            if (select) {
                if ((!this.metaNotLikeColumns.containsKey("___GLOBAL") || this.metaLikeColumns.containsKey("___GLOBAL")) && attr.attribute.getClassName() != null && attr.attribute.getClassName().endsWith("String")) {
                    useLike = true;
                }
                if (this.metaLikeColumns.containsKey(pojo) && this.metaLikeColumns.get(pojo).contains(attr.attribute.getDbName())) {
                    useLike = true;
                }
                if (this.metaNotLikeColumns.containsKey(pojo) && this.metaNotLikeColumns.get(pojo).contains(attr.attribute.getDbName())) {
                    useLike = false;
                }
            }
            String name = this.columnNames.containsKey(attr.tableName) ? (String)((Map)this.columnNames.get(attr.tableName)).get(attr.attributeName) : null;
            name = name == null ? attr.attribute.getName() : this.columnToCamelCase(name);
            buffer.append("\n    {& ");
            if (useLike) {
                buffer.append("UPPER(%");
            } else {
                buffer.append("%");
            }
            if (prefix != null) {
                buffer.append(prefix).append(".");
            }
            buffer.append((String)pentry.getKey());
            if (useLike) {
                buffer.append(") like :+");
            } else if (this.metaGenerateOperators || this.generateOperators != null) {
                buffer.append(" ::= :");
            } else {
                buffer.append(" = :");
            }
            buffer.append(name);
            if (attr.attribute.getPkTable() != null && attr.attribute.getRef() != null) {
                buffer.append(".").append(this.columnToCamelCase(attr.attribute.getPkColumn()));
            }
            if (this.metaTypes(buffer, attr.tableName, attr.attributeName, statementName, attr.completeSqlType, true)) {
                buffer.append(")");
            }
            buffer.append(" }");
            first = false;
        }
        return first;
    }

    boolean wherePrimaryKeys(StringBuilder buffer, String pojo, boolean first, String statementName) {
        for (Map.Entry pentry : ((Map)this.pojos.get(pojo)).entrySet()) {
            Attribute attr = this.getStatementAttribute(pojo, (String)pentry.getKey(), (PojoAttribute)pentry.getValue(), false);
            if (attr == null || !attr.attribute.isPrimaryKey() && !attr.attribute.isVersion()) continue;
            String name = this.columnNames.containsKey(attr.tableName) ? (String)((Map)this.columnNames.get(attr.tableName)).get(attr.attributeName) : null;
            name = name == null ? attr.attribute.getName() : this.columnToCamelCase(name);
            buffer.append("\n    {& %").append((String)pentry.getKey());
            buffer.append(" = :").append(name);
            if (attr.attribute.getPkTable() != null) {
                buffer.append(".").append(this.columnToCamelCase(attr.attribute.getPkColumn()));
            }
            if (!this.metaTypes(buffer, attr.tableName, attr.attributeName, statementName, attr.completeSqlType, true)) {
                buffer.append("(!empty)");
            } else {
                buffer.append(")");
            }
            buffer.append(" }");
            first = false;
        }
        return first;
    }

    boolean updateColumns(StringBuilder buffer, String pojo, boolean first, String statementName) {
        boolean isDef = false;
        for (Map.Entry pentry : ((Map)this.pojos.get(pojo)).entrySet()) {
            if (!((PojoAttribute)pentry.getValue()).isDef()) continue;
            isDef = true;
            break;
        }
        for (Map.Entry pentry : ((Map)this.pojos.get(pojo)).entrySet()) {
            Attribute attr = this.getStatementAttribute(pojo, (String)pentry.getKey(), (PojoAttribute)pentry.getValue(), false);
            if (attr == null || attr.attribute.isPrimaryKey() || ((PojoAttribute)pentry.getValue()).getOne2one() != null) continue;
            String name = this.columnNames.containsKey(attr.tableName) ? (String)((Map)this.columnNames.get(attr.tableName)).get(attr.attributeName) : null;
            name = name == null ? attr.attribute.getName() : this.columnToCamelCase(name);
            buffer.append("\n    { ,%").append((String)pentry.getKey());
            if (attr.attribute.isVersion()) {
                buffer.append(" = %").append((String)pentry.getKey()).append(" + 1");
            } else {
                buffer.append(" = :").append(name);
                if (attr.attribute.getPkTable() != null && attr.attribute.getRef() != null) {
                    buffer.append(".").append(this.columnToCamelCase(attr.attribute.getPkColumn()));
                }
                boolean hasMetaType = this.metaTypes(buffer, attr.tableName, attr.attributeName, statementName, attr.completeSqlType, true);
                if (isDef) {
                    if (!hasMetaType) {
                        buffer.append("(");
                    } else {
                        buffer.append(",");
                    }
                    buffer.append("call=isDef)");
                } else if (hasMetaType) {
                    buffer.append(")");
                }
            }
            buffer.append(" }");
            first = false;
        }
        return first;
    }

    boolean indexColumns(StringBuilder buffer, String pojo, boolean first, String statementName, String prefix) {
        for (Map.Entry pentry : ((Map)this.pojos.get(pojo)).entrySet()) {
            Attribute attr = this.getStatementAttribute(pojo, (String)pentry.getKey(), (PojoAttribute)pentry.getValue(), false);
            if (attr == null || attr.attribute.getIndex() == null) continue;
            String name = this.columnNames.containsKey(pojo) ? (String)((Map)this.columnNames.get(pojo)).get(pentry.getKey()) : null;
            name = name == null ? attr.attribute.getName() : this.columnToCamelCase(name);
            buffer.append("\n  {#").append(this.constantName(name)).append(" order by %");
            if (prefix != null) {
                buffer.append(prefix).append(".");
            }
            buffer.append((String)pentry.getKey());
            buffer.append(" }");
            first = false;
        }
        return first;
    }

    boolean index2Columns(StringBuilder buffer, String pojo, boolean first, String statementName, String prefix) {
        List mainList = (List)this.indexes.get(pojo);
        TreeMap<String, String> indMap = new TreeMap<String, String>();
        TreeMap<String, Map> indMap2 = new TreeMap<String, Map>();
        int i = 0;
        int l = mainList.size();
        while (i < l) {
            StringBuilder sb = new StringBuilder();
            StringBuilder sb2 = new StringBuilder();
            boolean firstcol = true;
            for (Map.Entry entry : ((Map)mainList.get(i)).entrySet()) {
                if (((PojoAttribute)entry.getKey()).getDbName() != null && this.ignoreColumns.containsKey(pojo) && ((Set)this.ignoreColumns.get(pojo)).contains(((PojoAttribute)entry.getKey()).getDbName())) {
                    sb = null;
                    break;
                }
                String name = this.columnNames.containsKey(pojo) ? (String)((Map)this.columnNames.get(pojo)).get(((PojoAttribute)entry.getKey()).getName()) : null;
                name = name == null ? ((PojoAttribute)entry.getKey()).getName() : this.columnToCamelCase(name);
                sb2.append(name);
                if (firstcol) {
                    firstcol = false;
                } else {
                    sb.append(",");
                }
                sb.append(" %");
                if (prefix != null) {
                    sb.append(prefix).append(".");
                }
                sb.append(((PojoAttribute)entry.getKey()).getDbName());
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                sb.append(" DESC");
            }
            if (sb != null) {
                indMap.put(sb2.toString(), sb.toString());
                indMap2.put(sb2.toString(), (Map)mainList.get(i));
                first = false;
            }
            ++i;
        }
        i = 0;
        for (Map.Entry e : indMap.entrySet()) {
            ++i;
            buffer.append("\n  {#").append(this.constName((Map)indMap2.get(e.getKey()))).append(" order by").append((String)e.getValue()).append(" }");
        }
        return first;
    }

    boolean metaTypes(StringBuilder buffer, String tableName, String attributeName, String statementName, String completeSqlType, boolean first) {
        if (this.metaColumnsMetaTypes.containsKey(tableName) && this.metaColumnsMetaTypes.get(tableName).containsKey(attributeName)) {
            PairValues metaType = this.metaColumnsMetaTypes.get(tableName).get(attributeName);
            if (first) {
                buffer.append("(");
            } else {
                buffer.append(",");
            }
            if (!"null".equalsIgnoreCase(metaType.value1)) {
                buffer.append("type=").append(metaType.value1);
            }
            if (metaType.value2 != null) {
                buffer.append(",").append(metaType.value2);
            }
            return true;
        }
        if (statementName != null && this.metaStatementsMetaTypes.containsKey(statementName) && this.metaStatementsMetaTypes.get(statementName).containsKey(attributeName)) {
            PairValues metaType = this.metaStatementsMetaTypes.get(statementName).get(attributeName);
            if (first) {
                buffer.append("(");
            } else {
                buffer.append(",");
            }
            if (!"null".equalsIgnoreCase(metaType.value1)) {
                buffer.append("type=").append(metaType.value1);
            }
            if (metaType.value2 != null) {
                buffer.append(",").append(metaType.value2);
            }
            return true;
        }
        if (completeSqlType != null && this.metaSqlTypes.containsKey(completeSqlType)) {
            PairValues metaType = this.metaSqlTypes.get(completeSqlType);
            if (first) {
                buffer.append("(");
            } else {
                buffer.append(",");
            }
            if (!"null".equalsIgnoreCase(metaType.value1)) {
                buffer.append("type=").append(metaType.value1);
            }
            if (metaType.value2 != null) {
                buffer.append(",").append(metaType.value2);
            }
            return true;
        }
        return false;
    }

    PojoAttribute resultSetAttribute(String pojo, boolean isFunction) {
        for (Map.Entry pentry : ((Map)this.procedures.get(pojo)).entrySet()) {
            PojoAttribute attribute = (PojoAttribute)pentry.getValue();
            if (this.dbType == DbResolver.DbType.ORACLE && attribute.getSqlType() == 1111) {
                return attribute;
            }
            if (this.dbType == DbResolver.DbType.POSTGRESQL && attribute.getSqlType() == 1111) {
                return attribute;
            }
            if (this.dbType != DbResolver.DbType.POSTGRESQL || attribute.getSqlType() != 2012) continue;
            return attribute;
        }
        return null;
    }

    StringBuilder metaCallProcedureDefinition(String pojo, boolean isFunction) {
        String name;
        String outPojoName;
        String outPojo;
        PojoAttribute attribute;
        PojoEntityType ptype;
        String pojoName;
        String dispName;
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n").append(isFunction ? "FUN_" : "PROC_").append(pojo.toUpperCase()).append("(CALL");
        if (this.metaMakeItFinal) {
            buffer.append(",final=");
        }
        if ((dispName = (pojoName = (String)this.tableNames.get(pojo))) == null && (ptype = (PojoEntityType)this.pojosForProcedures.get(pojo)) != null) {
            dispName = ptype.getSimpleName();
        }
        if (dispName == null && (ptype = (PojoEntityType)this.pojosForFunctions.get(pojo)) != null) {
            dispName = ptype.getSimpleName();
        }
        if (pojoName == null) {
            pojoName = pojo;
        }
        buffer.append(",").append("in").append("=").append(dispName != null ? dispName : this.tableToCamelCase(pojoName));
        buffer.append(")=");
        buffer.append("\n  ");
        PojoAttribute resultSetAttribute = this.resultSetAttribute(pojoName, isFunction);
        if (this.dbType == DbResolver.DbType.ORACLE) {
            if (isFunction && this.metaFunctionsResult.containsKey(pojo)) {
                buffer.append(":<1(type=").append((String)this.metaFunctionsResult.get(pojo)).append(") = ");
            } else if (isFunction && resultSetAttribute != null) {
                buffer.append(":<1(type=oracle_cursor) = ");
            }
        } else if (this.dbType == DbResolver.DbType.POSTGRESQL) {
            if (isFunction && this.metaFunctionsResult.containsKey(pojo)) {
                buffer.append(":<1(type=").append((String)this.metaFunctionsResult.get(pojo)).append(") = ");
            } else if (resultSetAttribute != null) {
                buffer.append(":<1(type=other) = ");
            }
        } else if ((this.dbType == DbResolver.DbType.MY_SQL || this.dbType == DbResolver.DbType.MS_SQL) && isFunction && this.metaFunctionsResult.containsKey(pojo)) {
            buffer.append(":<1(type=").append((String)this.metaFunctionsResult.get(pojo)).append(") = ");
        }
        buffer.append("call ").append(pojo).append("(");
        boolean first = true;
        ArrayList<String> warnings = new ArrayList<String>();
        int ix = 0;
        for (Map.Entry pentry : ((Map)this.procedures.get(pojo)).entrySet()) {
            Attribute attr;
            if ("_result_".equals(pentry.getKey()) || (attr = this.getStatementAttribute(pojo, (String)pentry.getKey(), (PojoAttribute)pentry.getValue(), true)) == null) continue;
            ++ix;
            String name2 = this.columnNames.containsKey(attr.tableName) ? (String)((Map)this.columnNames.get(attr.tableName)).get(attr.attributeName) : null;
            name2 = name2 == null ? attr.attribute.getName() : this.columnToCamelCase(name2);
            attribute = (PojoAttribute)pentry.getValue();
            if (!first) {
                buffer.append(", ");
            } else {
                first = false;
            }
            buffer.append(":");
            if (this.dbType == DbResolver.DbType.ORACLE && attribute.getSqlType() == 1111) {
                buffer.append("<1(type=oracle_cursor)");
                continue;
            }
            if (this.dbType == DbResolver.DbType.POSTGRESQL && attribute.getSqlType() == 1111) {
                buffer.append("<1(type=other)");
                continue;
            }
            if (attribute.getFunProcColumnType() != null) {
                if (attribute.getFunProcColumnType() == 4) {
                    buffer.append("<");
                } else if (attribute.getFunProcColumnType() == 2) {
                    buffer.append("=");
                }
            }
            buffer.append(name2);
            if (!this.metaTypes(buffer, attr.tableName, attr.attributeName, null, attr.completeSqlType, attr.sequence == null) && attr.sequence == null) continue;
            buffer.append(")");
        }
        buffer.append(")\n;");
        if ((this.dbType == DbResolver.DbType.HSQLDB || this.dbType == DbResolver.DbType.INFORMIX) && isFunction && this.metaFunctionsResult.containsKey(pojo)) {
            buffer.append("\n").append(isFunction ? "FUN_" : "PROC_").append(pojo.toUpperCase()).append("(OUT");
            if (this.metaMakeItFinal) {
                buffer.append(",final=");
            }
            buffer.append(")=");
            buffer.append("\n  1$1(type=").append((String)this.metaFunctionsResult.get(pojo));
            buffer.append(")\n;");
        } else if ((this.dbType == DbResolver.DbType.HSQLDB || this.dbType == DbResolver.DbType.INFORMIX) && this.metaProceduresResult.containsKey(pojo)) {
            buffer.append("\n").append(isFunction ? "FUN_" : "PROC_").append(pojo.toUpperCase()).append("(OUT");
            if (this.metaMakeItFinal) {
                buffer.append(",final=");
            }
            buffer.append(")=");
            buffer.append("\n  1$1(type=").append((String)this.metaProceduresResult.get(pojo));
            buffer.append(")\n;");
        } else if (!isFunction && this.metaProceduresResultSet.containsKey(pojo)) {
            outPojo = (String)this.metaProceduresResultSet.get(pojo);
            if (this.pojos.containsKey(outPojo)) {
                buffer.append("\n").append(isFunction ? "FUN_" : "PROC_").append(pojo.toUpperCase()).append("(OUT");
                if (this.metaMakeItFinal) {
                    buffer.append(",final=");
                }
                if ((outPojoName = (String)this.tableNames.get(outPojo)) == null) {
                    outPojoName = outPojo;
                }
                buffer.append(",").append("out").append("=").append(this.tableToCamelCase(outPojoName));
                buffer.append(")=\n ");
                for (Map.Entry pentry : ((Map)this.pojos.get(outPojo)).entrySet()) {
                    if (((PojoAttribute)pentry.getValue()).getOne2one() != null || this.ignoreColumns.containsKey(outPojo) && ((Set)this.ignoreColumns.get(outPojo)).contains(pentry.getKey()) || (attribute = (PojoAttribute)pentry.getValue()).getDbName() == null || this.dbType == DbResolver.DbType.ORACLE && attribute.getSqlType() == 1111) continue;
                    name = this.columnNames.containsKey(outPojo) ? (String)((Map)this.columnNames.get(outPojo)).get(pentry.getKey()) : null;
                    name = name == null ? attribute.getName() : this.columnToCamelCase(name);
                    String dbName = this.dbType == DbResolver.DbType.H2 ? "" + ix : attribute.getDbName();
                    buffer.append(" ").append(dbName).append("$").append(name);
                }
                buffer.append("\n;");
            } else {
                warnings.add("Missing pojo " + outPojo + " for a mapping rule devoted to " + pojo);
            }
        } else if (isFunction && this.metaFunctionsResultSet.containsKey(pojo)) {
            outPojo = (String)this.metaFunctionsResultSet.get(pojo);
            if (this.pojos.containsKey(outPojo)) {
                buffer.append("\n").append(isFunction ? "FUN_" : "PROC_").append(pojo.toUpperCase()).append("(OUT");
                if (this.metaMakeItFinal) {
                    buffer.append(",final=");
                }
                if ((outPojoName = (String)this.tableNames.get(outPojo)) == null) {
                    outPojoName = outPojo;
                }
                buffer.append(",").append("out").append("=").append(this.tableToCamelCase(outPojoName));
                buffer.append(")=\n ");
                for (Map.Entry pentry : ((Map)this.pojos.get(outPojo)).entrySet()) {
                    if (this.ignoreColumns.containsKey(outPojo) && ((Set)this.ignoreColumns.get(outPojo)).contains(pentry.getKey()) || (attribute = (PojoAttribute)pentry.getValue()).getDbName() == null) continue;
                    name = this.columnNames.containsKey(outPojo) ? (String)((Map)this.columnNames.get(outPojo)).get(pentry.getKey()) : null;
                    name = name == null ? attribute.getName() : this.columnToCamelCase(name);
                    buffer.append(" ").append(attribute.getDbName()).append("$").append(name);
                }
                buffer.append("\n;");
            } else {
                warnings.add("Missing pojo " + outPojo + " for a mapping rule devoted to " + pojo);
            }
        }
        buffer.append("\n");
        for (String warning : warnings) {
            buffer.append("// ").append(warning);
        }
        return buffer;
    }

    PojoAttribute resultSetAttribute(String pojo) {
        for (Map.Entry pentry : ((Map)this.functions.get(pojo)).entrySet()) {
            PojoAttribute attribute = (PojoAttribute)pentry.getValue();
            if (this.dbType == DbResolver.DbType.ORACLE && attribute.getSqlType() == 1111) {
                return attribute;
            }
            if (this.dbType != DbResolver.DbType.POSTGRESQL || attribute.getSqlType() != 1111) continue;
            return attribute;
        }
        return null;
    }

    StringBuilder metaCallFunctionDefinition(String pojo) {
        String pojoName;
        StringBuilder buffer = new StringBuilder();
        if (this.dbType != DbResolver.DbType.DB2) {
            return buffer;
        }
        buffer.append("\n").append("FUN_").append(pojo.toUpperCase()).append("(QRY");
        if (this.metaMakeItFinal) {
            buffer.append(",final=");
        }
        if ((pojoName = (String)this.tableNames.get(pojo)) == null) {
            pojoName = pojo;
        }
        buffer.append(",").append("in").append("=").append(this.tableToCamelCase(pojoName));
        buffer.append(")=");
        buffer.append("\n  ");
        buffer.append("select ").append(pojo).append("(");
        boolean first = true;
        ArrayList warnings = new ArrayList();
        for (Map.Entry pentry : ((Map)this.functions.get(pojo)).entrySet()) {
            Attribute attr;
            if ("_result_".equals(pentry.getKey()) || "RESULT".equals(pentry.getKey()) || (attr = this.getStatementAttribute(pojo, (String)pentry.getKey(), (PojoAttribute)pentry.getValue(), true)) == null) continue;
            String name = this.columnNames.containsKey(attr.tableName) ? (String)((Map)this.columnNames.get(attr.tableName)).get(attr.attributeName) : null;
            name = name == null ? attr.attribute.getName() : this.columnToCamelCase(name);
            if (!first) {
                buffer.append(", ");
            } else {
                first = false;
            }
            buffer.append(":").append(name);
            if (!this.metaTypes(buffer, attr.tableName, attr.attributeName, null, attr.completeSqlType, attr.sequence == null) && attr.sequence == null) continue;
            buffer.append(")");
        }
        buffer.append(") from SYSIBM.DUAL\n;");
        buffer.append("\n").append("FUN_").append(pojo.toUpperCase()).append("(OUT");
        if (this.metaMakeItFinal) {
            buffer.append(",final=");
        }
        buffer.append(",").append("out").append("=").append(this.tableToCamelCase(pojoName));
        buffer.append(")=\n ");
        buffer.append("  1$result\n;");
        buffer.append("\n");
        for (String warning : warnings) {
            buffer.append("// ").append(warning);
        }
        return buffer;
    }

    Header getStatementHeader(String pojo, StringBuilder buffer, StatementType type, String suffix) {
        String string;
        this.debug.trace("\n--- " + pojo + " " + suffix);
        Header header = new Header();
        HashSet<String> prefixes = new HashSet<String>();
        header.table.setNames(pojo);
        if (this.pojoDiscriminators.containsKey(header.table.tableName)) {
            header.table.realTableName = (String)this.pojoExtends.get(header.table.tableName);
            this.debug.trace("000 " + pojo + " " + header.table.realTableName);
        } else if (this.pojoExtends.containsKey(header.table.realTableName) && this.pojoInheritanceSimple.containsKey(this.pojoExtends.get(header.table.realTableName))) {
            header.extendTable.setNames((String)this.pojoExtends.get(header.table.realTableName));
            header.table.tablePrefix = this.newPrefix(prefixes, header.table);
            header.extendTable.tablePrefix = this.newPrefix(prefixes, header.extendTable);
            for (Map.Entry entry : ((Map)this.inheritImports.get(header.table.realTableName)).entrySet()) {
                Iterator iterator = ((Map)entry.getValue()).entrySet().iterator();
                if (!iterator.hasNext()) continue;
                Map.Entry e2 = iterator.next();
                if (!((String)e2.getKey()).equals(header.extendTable.tableName)) break;
                header.extendTable.primaryKey = (String)entry.getKey();
                header.extendTable.tableKey = (String)e2.getValue();
                break;
            }
            this.debug.trace("001 " + pojo + " " + header.extendTable.realTableName);
        }
        this.debug.trace("111 " + pojo + " " + header.table);
        this.debug.trace("222 " + pojo + " " + header.extendTable);
        if (type == StatementType.GET || type == StatementType.SELECT) {
            String[] kk;
            Table table2;
            Object table12;
            Table table;
            PojoAttribute attr1;
            PojoAttribute attr;
            for (Map.Entry entry : ((Map)this.pojos.get(header.table.realTableName)).entrySet()) {
                attr = (PojoAttribute)entry.getValue();
                if (attr.isVersion() && header.version == null) {
                    header.version = attr.getName();
                }
                if (attr.getPkTable() != null && attr.getRef() != null) {
                    if (header.table.tablePrefix == null) {
                        header.table.tablePrefix = this.newPrefix(prefixes, header.table);
                    }
                    Table table3 = new Table();
                    table3.setNames(attr.getPkTable());
                    table3.primaryKey = attr.getOne2one() != null ? attr.getOne2one() : (String)entry.getKey();
                    table3.tableKey = attr.getPkColumn();
                    table3.tablePrefix = this.newPrefix(prefixes, table3);
                    table3.attrName = this.attrName(pojo, (String)entry.getKey(), attr);
                    table3.oppositePrefix = header.table.tablePrefix;
                    table3.toInit = attr.toInit();
                    if (this.inheritanceColumns.containsKey(entry.getKey())) {
                        table3.discriminator = (String)this.inheritanceColumns.get(entry.getKey());
                        header.discrTables.put(table3.realTableName, table3);
                    }
                    header.assocTables.put((String)entry.getKey(), table3);
                    this.debug.trace("333 " + (String)entry.getKey() + " " + table3 + " " + attr);
                    if (this.pojoInheritanceSimple.containsKey(table3.realTableName)) {
                        header.inherTables.put((String)entry.getKey(), new ArrayList());
                        for (String name : (Set)this.pojoInheritanceSimple.get(table3.realTableName)) {
                            Table table23 = new Table();
                            table23.setNames(name);
                            String[] kk3 = this.findInheritanceKeysName(name, table3.realTableName);
                            table23.primaryKey = kk3[1];
                            table23.tableKey = kk3[0];
                            table23.tablePrefix = this.newPrefix(prefixes, table23);
                            table23.attrName = this.attrName(pojo, (String)entry.getKey(), attr);
                            table23.oppositePrefix = table3.tablePrefix;
                            table23.discriminator = kk3[0];
                            table23.inheritance = table23.realTableName.toLowerCase();
                            header.inherTables.get(entry.getKey()).add(table23);
                        }
                    }
                    this.debug.trace("333b " + header.inherTables);
                    continue;
                }
                if (attr.getOneToManyColumn() != null) {
                    attr1 = (PojoAttribute)((Map)this.pojos.get(header.table.realTableName)).get(attr.getOneToManyColumn());
                    if (header.table.tablePrefix == null) {
                        header.table.tablePrefix = this.newPrefix(prefixes, header.table);
                    }
                    table = new Table();
                    table.setNames(attr.getOneToManyTable());
                    table.primaryKey = attr.getOneToManyColumn();
                    table.tableKey = attr.getOneToManyOppositeColumn();
                    table.tablePrefix = this.newPrefix(prefixes, table);
                    table.attrName = this.attrName(pojo, (String)entry.getKey(), attr);
                    table.oppositePrefix = header.table.tablePrefix;
                    table.toInit = attr.toInit();
                    table.one2many = true;
                    if (this.inheritanceColumns.containsKey(entry.getKey())) {
                        table.discriminator = (String)this.inheritanceColumns.get(entry.getKey());
                        header.discrTables.put(table.realTableName, table);
                    }
                    header.assocTables.put((String)entry.getKey(), table);
                    this.debug.trace("444 " + (String)entry.getKey() + " " + table + " " + attr + " " + attr1);
                    if (this.pojoInheritanceSimple.containsKey(table.realTableName)) {
                        header.inherTables.put((String)entry.getKey(), new ArrayList());
                        for (String name : (Set)this.pojoInheritanceSimple.get(table.realTableName)) {
                            Table table22 = new Table();
                            table22.setNames(name);
                            String[] kk2 = this.findInheritanceKeysName(name, table.realTableName);
                            table22.primaryKey = kk2[1];
                            table22.tableKey = kk2[0];
                            table22.tablePrefix = this.newPrefix(prefixes, table22);
                            table22.attrName = this.attrName(pojo, (String)entry.getKey(), attr);
                            table22.oppositePrefix = table.tablePrefix;
                            table22.discriminator = kk2[0];
                            table22.inheritance = table22.realTableName.toLowerCase();
                            header.inherTables.get(entry.getKey()).add(table22);
                        }
                    }
                    this.debug.trace("444b " + header.inherTables);
                    continue;
                }
                if (attr.getManyToManyColumn() == null) continue;
                attr1 = (PojoAttribute)((Map)this.pojos.get(header.table.realTableName)).get(attr.getManyToManyColumn());
                if (header.table.tablePrefix == null) {
                    header.table.tablePrefix = this.newPrefix(prefixes, header.table);
                }
                table = new Table();
                table.setNames(attr1.getM2Tables().get(attr.getManyToManyTable()));
                table.primaryKey = attr.getManyToManyColumn();
                table.tableKey = this.findM2mKeyName(table.realTableName, header.table.realTableName);
                if (table.tableKey == null) {
                    this.debug.warn("Error for findM2mKeyName " + table.realTableName + " " + header.table.realTableName);
                    continue;
                }
                table.tablePrefix = this.newPrefix(prefixes, table);
                table.attrName = this.attrName(pojo, (String)entry.getKey(), attr);
                table.oppositePrefix = header.table.tablePrefix;
                table.toInit = attr.toInit();
                table.many2many = true;
                header.assocTables.put((String)entry.getKey(), table);
                table12 = new Table();
                ((Table)table12).setNames(attr.getManyToManyTable());
                ((Table)table12).tableKey = this.findPKeyName(table.realTableName);
                ((Table)table12).primaryKey = this.findM2mKeyName(table.realTableName, ((Table)table12).realTableName);
                if (((Table)table12).tableKey == null) {
                    this.debug.warn("Error for findM2mKeyName " + ((Table)table12).realTableName + " " + table.realTableName);
                    continue;
                }
                ((Table)table12).tablePrefix = this.newPrefix(prefixes, (Table)table12);
                ((Table)table12).attrName = null;
                ((Table)table12).oppositePrefix = table.tablePrefix;
                header.m2mTables.put((String)entry.getKey(), (Table)table12);
                this.debug.trace("555 " + (String)entry.getKey() + " " + table + " " + attr + " " + attr1 + " " + table12);
                if (this.pojoInheritanceSimple.containsKey(((Table)table12).realTableName)) {
                    header.inherTables.put((String)entry.getKey(), new ArrayList());
                    for (String name : (Set)this.pojoInheritanceSimple.get(((Table)table12).realTableName)) {
                        table2 = new Table();
                        table2.setNames(name);
                        kk = this.findInheritanceKeysName(name, ((Table)table12).realTableName);
                        table2.primaryKey = kk[1];
                        table2.tableKey = kk[0];
                        table2.tablePrefix = this.newPrefix(prefixes, table2);
                        table2.attrName = this.attrName(pojo, (String)entry.getKey(), attr);
                        table2.oppositePrefix = ((Table)table12).tablePrefix;
                        table2.discriminator = kk[0];
                        table2.inheritance = table2.realTableName.toLowerCase();
                        header.inherTables.get(entry.getKey()).add(table2);
                    }
                }
                this.debug.trace("555b " + header.inherTables);
            }
            if (header.extendTable.tableName != null) {
                for (Map.Entry entry : ((Map)this.pojos.get(header.extendTable.realTableName)).entrySet()) {
                    attr = (PojoAttribute)entry.getValue();
                    if (attr.isVersion() && header.version == null) {
                        header.version = attr.getName();
                    }
                    if (attr.getPkTable() != null && attr.getRef() != null) {
                        if (header.extendTable.tablePrefix == null) {
                            header.extendTable.tablePrefix = this.newPrefix(prefixes, header.extendTable);
                        }
                        Table table3 = new Table();
                        table3.setNames(attr.getPkTable());
                        table3.primaryKey = (String)entry.getKey();
                        table3.tableKey = attr.getPkColumn();
                        table3.tablePrefix = this.newPrefix(prefixes, table3);
                        table3.attrName = this.attrName(pojo, (String)entry.getKey(), attr);
                        table3.oppositePrefix = header.extendTable.tablePrefix;
                        table3.toInit = attr.toInit();
                        if (this.inheritanceColumns.containsKey(entry.getKey())) {
                            table3.discriminator = (String)this.inheritanceColumns.get(entry.getKey());
                            header.discrTables.put(table3.realTableName, table3);
                        }
                        header.assocTables.put((String)entry.getKey(), table3);
                        this.debug.trace("666 " + (String)entry.getKey() + " " + table3 + " " + attr);
                        if (this.pojoInheritanceSimple.containsKey(table3.realTableName)) {
                            header.inherTables.put((String)entry.getKey(), new ArrayList());
                            for (String name : (Set)this.pojoInheritanceSimple.get(table3.realTableName)) {
                                Table table22 = new Table();
                                table22.setNames(name);
                                String[] kk2 = this.findInheritanceKeysName(name, (String)entry.getKey());
                                table22.primaryKey = kk2[1];
                                table22.tableKey = kk2[0];
                                table22.tablePrefix = this.newPrefix(prefixes, table22);
                                table22.attrName = this.attrName(pojo, (String)entry.getKey(), attr);
                                table22.oppositePrefix = table3.tablePrefix;
                                table22.discriminator = kk2[0];
                                table22.inheritance = table22.realTableName.toLowerCase();
                                header.inherTables.get(entry.getKey()).add(table22);
                            }
                        }
                        this.debug.trace("666b " + header.inherTables);
                        continue;
                    }
                    if (attr.getOneToManyColumn() != null) {
                        attr1 = (PojoAttribute)((Map)this.pojos.get(header.extendTable.realTableName)).get(attr.getOneToManyColumn());
                        if (header.extendTable.tablePrefix == null) {
                            header.extendTable.tablePrefix = this.newPrefix(prefixes, header.extendTable);
                        }
                        table = new Table();
                        table.setNames(attr.getOneToManyTable());
                        table.primaryKey = attr.getOneToManyColumn();
                        table.tableKey = attr.getOneToManyOppositeColumn();
                        table.tablePrefix = this.newPrefix(prefixes, table);
                        table.attrName = this.attrName(pojo, (String)entry.getKey(), attr);
                        table.oppositePrefix = header.extendTable.tablePrefix;
                        table.toInit = attr.toInit();
                        table.one2many = true;
                        if (this.inheritanceColumns.containsKey(entry.getKey())) {
                            table.discriminator = (String)this.inheritanceColumns.get(entry.getKey());
                            header.discrTables.put(table.realTableName, table);
                        }
                        header.assocTables.put((String)entry.getKey(), table);
                        this.debug.trace("777 " + (String)entry.getKey() + " " + table + " " + attr + " " + attr1);
                        if (this.pojoInheritanceSimple.containsKey(table.realTableName)) {
                            header.inherTables.put((String)entry.getKey(), new ArrayList());
                            for (String name : (Set)this.pojoInheritanceSimple.get(table.realTableName)) {
                                Table table23 = new Table();
                                table23.setNames(name);
                                String[] kk3 = this.findInheritanceKeysName(name, table.realTableName);
                                table23.primaryKey = kk3[1];
                                table23.tableKey = kk3[0];
                                table23.tablePrefix = this.newPrefix(prefixes, table23);
                                table23.attrName = this.attrName(pojo, (String)entry.getKey(), attr);
                                table23.oppositePrefix = table.tablePrefix;
                                table23.discriminator = kk3[0];
                                table23.inheritance = table23.realTableName.toLowerCase();
                                header.inherTables.get(entry.getKey()).add(table23);
                            }
                        }
                        this.debug.trace("777b " + header.inherTables);
                        continue;
                    }
                    if (attr.getManyToManyColumn() == null) continue;
                    attr1 = (PojoAttribute)((Map)this.pojos.get(header.extendTable.realTableName)).get(attr.getManyToManyColumn());
                    if (header.extendTable.tablePrefix == null) {
                        header.extendTable.tablePrefix = this.newPrefix(prefixes, header.extendTable);
                    }
                    table = new Table();
                    table.setNames(attr1.getM2Tables().get(attr.getManyToManyTable()));
                    table.primaryKey = attr.getManyToManyColumn();
                    table.tableKey = this.findM2mKeyName(table.realTableName, header.extendTable.realTableName);
                    if (table.tableKey == null) {
                        this.debug.warn("Error for findM2mKeyName " + table.realTableName + " " + header.extendTable.realTableName);
                        continue;
                    }
                    table.tablePrefix = this.newPrefix(prefixes, table);
                    table.attrName = this.attrName(pojo, (String)entry.getKey(), attr);
                    table.oppositePrefix = header.extendTable.tablePrefix;
                    table.toInit = attr.toInit();
                    table.many2many = true;
                    header.assocTables.put((String)entry.getKey(), table);
                    table12 = new Table();
                    ((Table)table12).setNames(attr.getManyToManyTable());
                    ((Table)table12).tableKey = this.findPKeyName(table.realTableName);
                    ((Table)table12).primaryKey = this.findM2mKeyName(((Table)table12).realTableName, table.realTableName);
                    if (((Table)table12).tableKey == null) {
                        this.debug.warn("Error for findM2mKeyName " + ((Table)table12).realTableName + " " + table.realTableName);
                        continue;
                    }
                    ((Table)table12).tablePrefix = this.newPrefix(prefixes, (Table)table12);
                    ((Table)table12).attrName = null;
                    ((Table)table12).oppositePrefix = table.tablePrefix;
                    header.m2mTables.put((String)entry.getKey(), (Table)table12);
                    this.debug.trace("888 " + (String)entry.getKey() + " " + table + " " + attr + " " + attr1 + " " + table12);
                    if (this.pojoInheritanceSimple.containsKey(((Table)table12).realTableName)) {
                        header.inherTables.put((String)entry.getKey(), new ArrayList());
                        for (String name : (Set)this.pojoInheritanceSimple.get(((Table)table12).realTableName)) {
                            table2 = new Table();
                            table2.setNames(name);
                            kk = this.findInheritanceKeysName(name, ((Table)table12).realTableName);
                            table2.primaryKey = kk[1];
                            table2.tableKey = kk[0];
                            table2.tablePrefix = this.newPrefix(prefixes, table2);
                            table2.attrName = this.attrName(pojo, (String)entry.getKey(), attr);
                            table2.oppositePrefix = ((Table)table12).tablePrefix;
                            table2.discriminator = kk[0];
                            table2.inheritance = table2.realTableName.toLowerCase();
                            header.inherTables.get(entry.getKey()).add(table2);
                        }
                    }
                    this.debug.trace("888b " + header.inherTables);
                }
            }
        }
        if (type == StatementType.INSERT) {
            header.statementName = "INSERT_";
        } else if (type == StatementType.GET) {
            header.statementName = "GET_";
        } else if (type == StatementType.UPDATE) {
            header.statementName = "UPDATE_";
        } else if (type == StatementType.DELETE) {
            header.statementName = "DELETE_";
        } else if (type == StatementType.SELECT) {
            header.statementName = "SELECT_";
        }
        header.statementName = String.valueOf(header.statementName) + header.table.tableName.toUpperCase();
        if (suffix != null) {
            header.statementName = String.valueOf(header.statementName) + "_" + suffix;
        }
        if (this.finalMetas.containsKey(header.statementName)) {
            buffer.append("\n").append(Utils.getFinalContent(this.finalMetas.get(header.statementName)));
            return null;
        }
        buffer.append("\n").append(header.statementName);
        if (type == StatementType.SELECT) {
            buffer.append("(QRY,");
        } else {
            buffer.append("(CRUD,");
        }
        if (this.metaMakeItFinal) {
            buffer.append("final=,");
        }
        if (this.metaOptionalFeatures.containsKey(header.statementName)) {
            for (String string2 : this.metaOptionalFeatures.get(header.statementName)) {
                buffer.append(string2).append(",");
            }
        }
        buffer.append("in").append("=").append(this.tableToCamelCase(header.table.tableName));
        buffer.append(",").append("out").append("=").append(this.tableToCamelCase(header.table.tableName));
        buffer.append(",").append("tab").append("=");
        buffer.append(header.table.getTableName());
        if (header.table.tablePrefix != null && (type == StatementType.GET || type == StatementType.SELECT)) {
            buffer.append("=").append(header.table.tablePrefix);
            if (header.extendTable.tableName != null) {
                buffer.append(",").append("tab").append("=");
                buffer.append(header.extendTable.getTableName());
                buffer.append("=").append(header.extendTable.tablePrefix);
            }
            if (!header.assocTables.isEmpty()) {
                for (Map.Entry entry : header.assocTables.entrySet()) {
                    Table table = (Table)entry.getValue();
                    buffer.append(",").append("tab").append("=");
                    buffer.append(table.getTableName());
                    buffer.append("=").append(table.tablePrefix);
                    if (header.m2mTables.containsKey(entry.getKey())) {
                        Table table2 = header.m2mTables.get(entry.getKey());
                        buffer.append(",").append("tab").append("=");
                        buffer.append(table2.getTableName());
                        buffer.append("=").append(table2.tablePrefix);
                    }
                    if (!header.inherTables.containsKey(entry.getKey())) continue;
                    for (Table table2 : header.inherTables.get(entry.getKey())) {
                        buffer.append(",").append("tab").append("=");
                        buffer.append(table2.getTableName());
                        buffer.append("=").append(table2.tablePrefix);
                    }
                }
            }
        }
        if ((string = MetaFilter.get(this.metaActiveFilter, "add")) != null) {
            buffer.append(",").append(string);
        }
        buffer.append(")=");
        return header;
    }

    String findPKeyName(String pojo) {
        if (!this.pojos.containsKey(pojo)) {
            return null;
        }
        for (Map.Entry pentry : ((Map)this.pojos.get(pojo)).entrySet()) {
            PojoAttribute attr = (PojoAttribute)pentry.getValue();
            if (!attr.isPrimaryKey()) continue;
            return (String)pentry.getKey();
        }
        return null;
    }

    String findM2mKeyName(String pojo, String tablename) {
        if (!this.pojos.containsKey(pojo)) {
            return null;
        }
        for (Map.Entry pentry : ((Map)this.pojos.get(pojo)).entrySet()) {
            PojoAttribute attr = (PojoAttribute)pentry.getValue();
            if (attr.getM2mTable() == null || !attr.getM2mTable().equals(tablename)) continue;
            return (String)pentry.getKey();
        }
        return null;
    }

    String attrName(String pojo, String colname, PojoAttribute attr) {
        String name = this.columnNames.containsKey(pojo) ? (String)((Map)this.columnNames.get(pojo)).get(colname) : null;
        name = name == null ? attr.getName() : this.columnToCamelCase(name);
        return name;
    }

    String[] findInheritanceKeysName(String name1, String name2) {
        String[] result = new String[2];
        if (!this.inheritImports.containsKey(name1)) {
            return null;
        }
        for (Map.Entry entry : ((Map)this.inheritImports.get(name1)).entrySet()) {
            if (!((Map)entry.getValue()).containsKey(name2)) continue;
            result[0] = (String)entry.getKey();
            result[1] = (String)((Map)entry.getValue()).get(name2);
            return result;
        }
        return null;
    }

    String newPrefix(Set<String> prefixes, Table table) {
        String pp;
        String p = pp = table.realTableName.substring(0, 1).toLowerCase();
        int i = 0;
        while (i < 1000) {
            if (i > 0) {
                p = String.valueOf(pp) + i;
            }
            if (!prefixes.contains(p)) {
                prefixes.add(p);
                return p;
            }
            ++i;
        }
        return pp;
    }

    Attribute getStatementAttribute(String pojo, String colname, PojoAttribute colattr, boolean checkIdentity) {
        Attribute attr = new Attribute();
        if (this.createColumns.containsKey(pojo) && ((Map)this.createColumns.get(pojo)).containsKey(colname)) {
            return null;
        }
        if (checkIdentity) {
            if (this.getIdentity(pojo, colattr) != null) {
                return null;
            }
            attr.sequence = this.getSequence(pojo, colattr);
        }
        attr.tableName = null;
        attr.attributeName = null;
        attr.attribute = null;
        if (this.ignoreColumns.containsKey(pojo) && ((Set)this.ignoreColumns.get(pojo)).contains(colname)) {
            boolean ignore = true;
            if (this.inheritImports.containsKey(pojo) && ((Map)this.inheritImports.get(pojo)).containsKey(colname)) {
                ignore = false;
                Iterator iterator = ((Map)((Map)this.inheritImports.get(pojo)).get(colname)).entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry pentry2 = iterator.next();
                    attr.tableName = (String)pentry2.getKey();
                    attr.attributeName = (String)pentry2.getValue();
                    attr.attribute = (PojoAttribute)((Map)this.pojos.get(attr.tableName)).get(attr.attributeName);
                }
            }
            if (ignore) {
                return null;
            }
        }
        if (attr.tableName == null) {
            attr.tableName = pojo;
        }
        if (attr.attributeName == null) {
            attr.attributeName = colname;
        }
        if (attr.attribute == null) {
            attr.attribute = colattr;
            attr.completeSqlType = colattr.getCompleteSqlType();
        }
        if (attr.attribute.getClassName().startsWith("java.util.List")) {
            return null;
        }
        return attr;
    }

    PairValues getIdentity(String pojo, PojoAttribute attribute) {
        if (attribute.isPrimaryKey()) {
            this.debug.trace("getIdentity " + pojo + " :" + this.metaTablesSequence + "|" + this.metaTablesIdentity + "|" + this.metaGlobalIdentity + "|" + this.metaGlobalIdentityForTables + "|" + this.metaGlobalIdentityNotForTables + "|" + this.identities);
            if (this.metaTablesSequence.containsKey(pojo)) {
                return null;
            }
            if (this.metaTablesIdentity.containsKey(pojo)) {
                return this.metaTablesIdentity.get(pojo);
            }
            if (this.metaGlobalIdentity != null) {
                boolean generateIdentity = true;
                if (!this.metaGlobalIdentityForTables.isEmpty() && !this.metaGlobalIdentityForTables.contains(pojo)) {
                    generateIdentity = false;
                }
                if (!this.metaGlobalIdentityNotForTables.isEmpty() && this.metaGlobalIdentityNotForTables.contains(pojo)) {
                    generateIdentity = false;
                }
                return generateIdentity ? this.metaGlobalIdentity : null;
            }
            if (this.identities != null) {
                PairValues result = null;
                for (Map.Entry<String, StringBuilder> entry : this.identities.entrySet()) {
                    if (entry.getKey().toUpperCase().indexOf(pojo.toUpperCase()) < 0 || result != null && result.value1.length() <= entry.getKey().length()) continue;
                    result = new PairValues(entry.getKey(), null);
                }
                if (result != null) {
                    return result;
                }
            }
        }
        return null;
    }

    PairValues getSequence(String pojo, PojoAttribute attribute) {
        if (attribute.isPrimaryKey()) {
            this.debug.trace("getSequence " + pojo + " :" + this.metaTablesSequence + "|" + this.metaGlobalSequence + "|" + this.metaGlobalSequenceForTables + "|" + this.metaGlobalSequenceNotForTables + "|" + this.sequences);
            if (this.metaTablesSequence.containsKey(pojo)) {
                return this.metaTablesSequence.get(pojo);
            }
            if (this.metaGlobalSequence != null) {
                boolean generateSequence = true;
                if (!this.metaGlobalSequenceForTables.isEmpty() && !this.metaGlobalSequenceForTables.contains(pojo)) {
                    generateSequence = false;
                }
                if (!this.metaGlobalSequenceNotForTables.isEmpty() && this.metaGlobalSequenceNotForTables.contains(pojo)) {
                    generateSequence = false;
                }
                return generateSequence ? this.metaGlobalSequence : null;
            }
            if (this.sequences != null) {
                PairValues result = null;
                for (Map.Entry<String, StringBuilder> entry : this.sequences.entrySet()) {
                    if (entry.getKey().toUpperCase().indexOf(pojo.toUpperCase()) < 0 || result != null && result.value1.length() <= entry.getKey().length()) continue;
                    result = new PairValues(entry.getKey(), null);
                }
                if (result != null) {
                    return result;
                }
            }
        }
        return null;
    }

    StringBuilder metaSequenceDefinition(String sequenceName, Map<String, StringBuilder> sequences) {
        StringBuilder buffer = new StringBuilder();
        String sequence = null;
        if (this.dbType == DbResolver.DbType.HSQLDB) {
            sequence = this.substituteName("call next value for $n", sequenceName);
        } else if (this.dbType == DbResolver.DbType.H2) {
            sequence = this.substituteName("call next value for $n", sequenceName);
        } else if (this.dbType == DbResolver.DbType.ORACLE) {
            sequence = this.substituteName("select $n.nextval from dual", sequenceName);
        } else if (this.dbType == DbResolver.DbType.POSTGRESQL) {
            sequence = this.substituteName("select nextval('$n')", sequenceName);
        } else if (this.dbType == DbResolver.DbType.INFORMIX) {
            sequence = this.substituteName("SELECT FIRST 1 $n.NEXTVAL FROM systables", sequenceName);
        } else if (this.dbType == DbResolver.DbType.DB2) {
            sequence = this.substituteName("values nextval for $n", sequenceName);
        }
        if (sequence != null) {
            String name;
            String string = name = sequenceName != null ? sequenceName : "SQLPROC_SEQUENCE";
            if (!sequences.containsKey(name)) {
                if (this.metaGenerateIdGenerators) {
                    buffer.append("SEQ=");
                } else if (this.metaGenerateIndirectIdGenerators) {
                    buffer.append("IDGEN=");
                }
                buffer.append(name);
                buffer.append("(OPT");
                if (this.metaMakeItFinal) {
                    buffer.append(",final=");
                }
                buffer.append(")=");
                if (this.metaGenerateIndirectIdGenerators) {
                    buffer.append("seq=").append(name);
                } else {
                    buffer.append(sequence);
                }
                buffer.append(";\n");
                sequences.put(name, buffer);
            }
        }
        return buffer;
    }

    StringBuilder metaIdentityDefinition(String identityName, Map<String, StringBuilder> identities) {
        StringBuilder buffer = new StringBuilder();
        String identity = null;
        String identity2 = null;
        if (this.dbType == DbResolver.DbType.HSQLDB) {
            identity = this.substituteName("call identity()", identityName);
        } else if (this.dbType == DbResolver.DbType.H2) {
            identity = this.substituteName("call identity()", identityName);
        } else if (this.dbType == DbResolver.DbType.MY_SQL) {
            identity = this.substituteName("select last_insert_id()", identityName);
        } else if (this.dbType == DbResolver.DbType.INFORMIX) {
            if (this.metaGenerateIndirectIdGenerators) {
                identity = this.substituteName("SELECT FIRST 1 dbinfo('bigserial') FROM systables", identityName);
            } else {
                identity = this.substituteName("select dbinfo('bigserial') from informix.systables where tabid=1", identityName);
                identity2 = this.substituteName("select dbinfo('sqlca.sqlerrd1') from informix.systables where tabid=1", identityName);
            }
        } else if (this.dbType == DbResolver.DbType.MS_SQL) {
            identity = this.substituteName("JDBC", identityName);
        } else if (this.dbType == DbResolver.DbType.DB2) {
            identity = this.substituteName("SELECT identity_val_local() FROM SYSIBM.DUAL", identityName);
        }
        String name = null;
        if (identity2 != null) {
            name = this.metaIdentityDefinition1(buffer, identityName, identity, "_Long");
            this.metaIdentityDefinition1(buffer, identityName, identity2, "_Integer");
        } else if (identity != null) {
            name = this.metaIdentityDefinition1(buffer, identityName, identity, null);
        }
        if (name != null) {
            identities.put(name, buffer);
        }
        return buffer;
    }

    String metaIdentityDefinition1(StringBuilder buffer, String identityName, String identity, String suffix) {
        if (identity != null) {
            String name;
            String string = name = identityName != null ? identityName : "IDSEL";
            if (!this.identities.containsKey(name)) {
                if (this.metaGenerateIdGenerators) {
                    buffer.append("IDSEL=");
                } else if (this.metaGenerateIndirectIdGenerators) {
                    buffer.append("IDGEN=");
                }
                buffer.append(name);
                if (suffix != null) {
                    buffer.append(suffix);
                }
                buffer.append("(OPT");
                if (this.metaMakeItFinal) {
                    buffer.append(",final=");
                }
                buffer.append(")=");
                if (this.metaGenerateIndirectIdGenerators) {
                    buffer.append("idsel");
                } else {
                    buffer.append(identity);
                }
                buffer.append(";\n");
                return name;
            }
        }
        return null;
    }

    StringBuilder metaSequenceDefinition(String table, String column, Map<String, StringBuilder> sequences) {
        String name;
        StringBuilder buffer = new StringBuilder();
        String sequence = null;
        if (this.dbType == DbResolver.DbType.MY_SQL) {
            sequence = this.substituteName("select auto_increment from information_schema.tables where table_name = '$t'", table, column);
        }
        if (sequence != null && !sequences.containsKey(name = table.toUpperCase())) {
            if (this.metaGenerateIdGenerators) {
                buffer.append("SEQ_");
            } else if (this.metaGenerateIndirectIdGenerators) {
                buffer.append("IDGEN=");
            } else {
                buffer.append("SEQ=");
            }
            buffer.append(name);
            buffer.append("(OPT");
            if (this.metaMakeItFinal) {
                buffer.append(",final=");
            }
            buffer.append(")=");
            if (this.metaGenerateIndirectIdGenerators) {
                buffer.append("seq=").append(name);
            } else {
                buffer.append(sequence);
            }
            buffer.append(";\n");
            sequences.put(name, buffer);
        }
        return buffer;
    }

    StringBuilder metaIdentityDefinition(String table, String column, Map<String, StringBuilder> identities) {
        String name;
        StringBuilder buffer = new StringBuilder();
        String identity = null;
        if (this.dbType == DbResolver.DbType.POSTGRESQL) {
            identity = this.substituteName("select currval(pg_get_serial_sequence('$t','$c'))", table, column);
        }
        if (identity != null && !identities.containsKey(name = table.toUpperCase())) {
            if (this.metaGenerateIdGenerators) {
                buffer.append("IDSEL=");
            } else if (this.metaGenerateIndirectIdGenerators) {
                buffer.append("IDGEN=");
            } else {
                buffer.append("IDSEL=");
            }
            buffer.append(name);
            buffer.append("(OPT");
            if (this.metaMakeItFinal) {
                buffer.append(",final=");
            }
            buffer.append(")=");
            if (this.metaGenerateIndirectIdGenerators) {
                buffer.append("idsel");
            } else {
                buffer.append(identity);
            }
            buffer.append(";\n");
            identities.put(name, buffer);
        }
        return buffer;
    }

    private String substituteName(String pattern, String name) {
        int ix = pattern.indexOf("$n");
        if (ix < 0) {
            return pattern;
        }
        if (name == null) {
            return String.valueOf(pattern.substring(0, ix)) + "SQLPROC_SEQUENCE" + pattern.substring(ix + 2);
        }
        return String.valueOf(pattern.substring(0, ix)) + name + pattern.substring(ix + 2);
    }

    private String substituteName(String pattern, String table, String column) {
        int ix = pattern.indexOf("$t");
        if (ix >= 0) {
            pattern = String.valueOf(pattern.substring(0, ix)) + table + pattern.substring(ix + 2);
        }
        if ((ix = pattern.indexOf("$c")) >= 0) {
            pattern = String.valueOf(pattern.substring(0, ix)) + column + pattern.substring(ix + 2);
        }
        return pattern;
    }

    private String tablePrefix(String prefix) {
        if (prefix == null) {
            return "";
        }
        return String.valueOf(prefix) + ".";
    }

    public static String generateMeta(Artifacts artifacts, List<MetaStatement> statements, ISerializer serializer, DbResolver dbResolver, IScopeProvider scopeProvider, ModelProperty modelProperty, Stats stats) {
        if (artifacts == null || !dbResolver.isResolveDb(artifacts)) {
            return null;
        }
        HashMap<String, String> finalMetas = new HashMap<String, String>();
        for (MetaStatement meta : statements) {
            if (serializer == null) {
                serializer = ((XtextResource)meta.eResource()).getSerializer();
            }
            if (!Utils.isFinal(meta)) continue;
            finalMetas.put(meta.getName(), serializer.serialize((EObject)meta));
        }
        List<String> dbSequences = dbResolver.getSequences(artifacts);
        DbResolver.DbType dbType = Utils.getDbType(dbResolver, artifacts);
        TableMetaGenerator generator = new TableMetaGenerator(modelProperty, artifacts, scopeProvider, finalMetas, dbSequences, dbType);
        try {
            if (generator.addDefinitions(dbResolver, scopeProvider, stats)) {
                return generator.getMetaDefinitions(modelProperty, artifacts);
            }
        }
        catch (RuntimeException ex) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            ex.printStackTrace(printWriter);
            String s = ((Object)writer).toString();
            return s;
        }
        return null;
    }

    static class Attribute {
        String tableName;
        String attributeName;
        PojoAttribute attribute;
        PairValues sequence;
        String completeSqlType;

        Attribute() {
        }
    }

    class Header {
        Table table;
        Table extendTable;
        String statementName;
        Map<String, Table> assocTables;
        Map<String, Table> m2mTables;
        Map<String, Table> discrTables;
        Map<String, List<Table>> inherTables;
        String version;

        Header() {
            this.table = new Table();
            this.extendTable = new Table();
            this.assocTables = new TreeMap<String, Table>();
            this.m2mTables = new TreeMap<String, Table>();
            this.discrTables = new TreeMap<String, Table>();
            this.inherTables = new TreeMap<String, List<Table>>();
        }
    }

    static class MetaFilter {
        static final String ONLY = "only";
        static final String ONLY_DELETE = "only-delete";
        static final String ONLY_UPDATE = "only-update";
        static final String ONLY_INSERT = "only-insert";
        static final String ONLY_GET = "only-get";
        static final String ONLY_SELECT = "only-select";
        static final String ONLY_CALL = "only-call";
        static final String ONLY_TABLE = "only-table";
        static final String ONLY_TABLES = "only-tables";
        static final Set<String> onlyKeys = new HashSet<String>();
        static final String ADD = "add";
        static final String ADD_FILTER = "add-filter";
        Map<String, String> filters;
        Set<String> onlyTables;

        static {
            onlyKeys.add(ONLY_DELETE);
            onlyKeys.add(ONLY_UPDATE);
            onlyKeys.add(ONLY_INSERT);
            onlyKeys.add(ONLY_GET);
            onlyKeys.add(ONLY_SELECT);
            onlyKeys.add(ONLY_CALL);
        }

        MetaFilter() {
        }

        static MetaFilter parse(String s) {
            if (s == null) {
                return null;
            }
            if (s.startsWith("\"")) {
                s = s.substring(1);
            }
            if (s.endsWith("\"")) {
                s = s.substring(0, s.length() - 1);
            }
            MetaFilter f = new MetaFilter();
            f.filters = new HashMap<String, String>();
            f.onlyTables = new HashSet<String>();
            String[] ss = s.split(" ");
            boolean isFilter = false;
            boolean isTable = false;
            boolean isTables = false;
            String[] stringArray = ss;
            int n = ss.length;
            int n2 = 0;
            while (n2 < n) {
                String s1 = stringArray[n2];
                if (isFilter) {
                    f.filters.put(ADD, s1);
                    isFilter = false;
                } else if (isTable) {
                    f.onlyTables.add(s1);
                    isTable = false;
                } else if (isTables) {
                    String[] tt;
                    String[] stringArray2 = tt = s1.split(",");
                    int n3 = tt.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String t1 = stringArray2[n4];
                        f.onlyTables.add(t1);
                        ++n4;
                    }
                    isTables = false;
                } else if (onlyKeys.contains(s1)) {
                    f.filters.put(ONLY, s1.toLowerCase());
                } else if (s1.equalsIgnoreCase(ADD_FILTER)) {
                    isFilter = true;
                } else if (s1.equalsIgnoreCase(ONLY_TABLE)) {
                    isTable = true;
                } else if (s1.equalsIgnoreCase(ONLY_TABLES)) {
                    isTables = true;
                }
                ++n2;
            }
            return f;
        }

        static boolean isGenerate(MetaFilter f, String what) {
            if (f == null || !f.filters.containsKey(ONLY)) {
                return true;
            }
            return what.equals(f.filters.get(ONLY));
        }

        static boolean isTable(MetaFilter f, String table) {
            if (f == null || f.onlyTables.isEmpty()) {
                return true;
            }
            return f.onlyTables.contains(table);
        }

        static String get(MetaFilter f, String what) {
            if (f == null || !f.filters.containsKey(what)) {
                return null;
            }
            return f.filters.get(what);
        }

        public String toString() {
            return "Filter [filters=" + this.filters + "]";
        }
    }

    static enum StatementType {
        INSERT,
        GET,
        UPDATE,
        DELETE,
        SELECT;

    }

    class Table {
        String tableName;
        String realTableName;
        String tablePrefix;
        String primaryKey;
        String tableKey;
        String attrName;
        String oppositePrefix;
        boolean toInit;
        boolean one2many;
        boolean many2many;
        String discriminator;
        String inheritance;

        Table() {
        }

        void setNames(String pojo) {
            this.tableName = (String)TableMetaGenerator.this.tableNames.get(pojo);
            if (this.tableName == null) {
                this.tableName = pojo;
            }
            this.realTableName = pojo;
        }

        String getTableName() {
            TableDefinition tableDefinition = (TableDefinition)TableMetaGenerator.this.modelTablesInv.get(this.realTableName != null ? this.realTableName : this.tableName);
            if (tableDefinition != null) {
                return tableDefinition.getName();
            }
            return this.tableName;
        }

        public String toString() {
            return "Table [tableName=" + this.tableName + ", realTableName=" + this.realTableName + ", tablePrefix=" + this.tablePrefix + ", primaryKey=" + this.primaryKey + ", tableKey=" + this.tableKey + ", attrName=" + this.attrName + ", oppositePrefix=" + this.oppositePrefix + ", toInit=" + this.toInit + "]";
        }
    }
}

