/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.meta.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.sqlproc.meta.processorMeta.AnnotationDefinitionModel;
import org.sqlproc.meta.processorMeta.Artifacts;
import org.sqlproc.meta.processorMeta.Column;
import org.sqlproc.meta.processorMeta.Constant;
import org.sqlproc.meta.processorMeta.DatabaseColumn;
import org.sqlproc.meta.processorMeta.DatabaseTable;
import org.sqlproc.meta.processorMeta.ExtendedColumn;
import org.sqlproc.meta.processorMeta.FunctionDefinitionModel;
import org.sqlproc.meta.processorMeta.Identifier;
import org.sqlproc.meta.processorMeta.IfSql;
import org.sqlproc.meta.processorMeta.IfSqlFragment;
import org.sqlproc.meta.processorMeta.MappingColumn;
import org.sqlproc.meta.processorMeta.MappingRule;
import org.sqlproc.meta.processorMeta.MetaSql;
import org.sqlproc.meta.processorMeta.MetaStatement;
import org.sqlproc.meta.processorMeta.OptionalFeature;
import org.sqlproc.meta.processorMeta.OrdSql;
import org.sqlproc.meta.processorMeta.PojoDefinitionModel;
import org.sqlproc.meta.processorMeta.ProcedureDefinitionModel;
import org.sqlproc.meta.processorMeta.ProcessorMetaPackage;
import org.sqlproc.meta.processorMeta.Property;
import org.sqlproc.meta.processorMeta.Sql;
import org.sqlproc.meta.processorMeta.SqlFragment;
import org.sqlproc.meta.processorMeta.TableDefinitionModel;
import org.sqlproc.meta.util.Utils;
import org.sqlproc.meta.validation.AbstractProcessorMetaValidator;
import org.sqlproc.meta.validation.ValidationResult;
import org.sqlproc.plugin.lib.property.ModelProperty;
import org.sqlproc.plugin.lib.property.PojoDefinition;
import org.sqlproc.plugin.lib.property.TableDefinition;
import org.sqlproc.plugin.lib.resolver.DbResolver;
import org.sqlproc.plugin.lib.resolver.PojoResolver;
import org.sqlproc.plugin.lib.resolver.PojoResolverFactory;
import org.sqlproc.plugin.lib.util.CommonUtils;

public class ProcessorMetaValidator
extends AbstractProcessorMetaValidator {
    @Inject
    private PojoResolverFactory pojoResolverFactory;
    @Inject
    private DbResolver dbResolver;
    @Inject
    private ModelProperty modelProperty;
    private final HashSet<String> F_TYPES = CollectionLiterals.newHashSet((Object[])new String[]{"set", "update", "values", "where", "columns", "set=opt", "where=opt"});

    @Check
    public void checkMetaSqlFtype(MetaSql metaSql) {
        String _ftype_2;
        String _lowerCase;
        boolean _contains;
        boolean _not;
        boolean _notEquals;
        String _ftype = metaSql.getFtype();
        boolean _equals = Objects.equal((Object)_ftype, null);
        if (_equals) {
            return;
        }
        boolean _skipVerification = CommonUtils.skipVerification(metaSql, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        boolean _and = false;
        String _ftype_1 = metaSql.getFtype();
        boolean bl = _notEquals = !Objects.equal((Object)_ftype_1, null);
        _and = !_notEquals ? false : (_not = !(_contains = this.F_TYPES.contains(_lowerCase = (_ftype_2 = metaSql.getFtype()).toLowerCase())));
        if (_and) {
            String _ftype_3 = metaSql.getFtype();
            String _plus = "Invalid ftype : " + _ftype_3;
            this.error(_plus, (EStructuralFeature)ProcessorMetaPackage.Literals.META_SQL__FTYPE);
        }
    }

    @Check
    public void checkUniqueMetaStatement(MetaStatement metaStatement) {
        boolean _skipVerification = CommonUtils.skipVerification(metaStatement, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(metaStatement);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<MetaStatement> _statements = artifacts.getStatements();
        for (MetaStatement metaStmt : _statements) {
            boolean _equalsStatement;
            boolean _notEquals;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)metaStmt, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean bl2 = _and = metaStmt != metaStatement;
            }
            if (!_and || !(_equalsStatement = this.equalsStatement(metaStatement, metaStmt))) continue;
            String _name = metaStatement.getName();
            String _plus = "Duplicate name : " + _name;
            String _plus_1 = String.valueOf(_plus) + "[";
            String _type = metaStatement.getType();
            String _plus_2 = String.valueOf(_plus_1) + _type;
            String _plus_3 = String.valueOf(_plus_2) + "]";
            this.error(_plus_3, (EStructuralFeature)ProcessorMetaPackage.Literals.META_STATEMENT__NAME);
            return;
        }
    }

    public boolean equalsStatement(MetaStatement statement1, MetaStatement statement2) {
        String _name_3;
        boolean _equals_1;
        boolean _and = false;
        boolean _equals = Objects.equal((Object)statement1, null);
        _and = !_equals ? false : (_equals_1 = Objects.equal((Object)statement2, null));
        if (_and) {
            return true;
        }
        boolean _or = false;
        boolean _equals_2 = Objects.equal((Object)statement1, null);
        if (_equals_2) {
            _or = true;
        } else {
            boolean _equals_3;
            String _name = statement1.getName();
            _or = _equals_3 = Objects.equal((Object)_name, null);
        }
        if (_or) {
            return false;
        }
        boolean _or_1 = false;
        boolean _equals_4 = Objects.equal((Object)statement2, null);
        if (_equals_4) {
            _or_1 = true;
        } else {
            boolean _equals_5;
            String _name_1 = statement2.getName();
            _or_1 = _equals_5 = Objects.equal((Object)_name_1, null);
        }
        if (_or_1) {
            return false;
        }
        boolean _and_1 = false;
        String _name_2 = statement1.getName();
        boolean _equals_6 = _name_2.equals(_name_3 = statement2.getName());
        if (!_equals_6) {
            _and_1 = false;
        } else {
            boolean _equals_7;
            String _type = statement1.getType();
            String _type_1 = statement2.getType();
            _and_1 = _equals_7 = _type.equals(_type_1);
        }
        if (_and_1) {
            EList<String> _modifiers = statement1.getModifiers();
            EList<String> _modifiers_1 = statement2.getModifiers();
            return this.equalsModifiers((List<String>)_modifiers, (List<String>)_modifiers_1);
        }
        return false;
    }

    @Check
    public void checkUniqueMappingRule(MappingRule mappingRule) {
        boolean _skipVerification = CommonUtils.skipVerification(mappingRule, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(mappingRule);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<MappingRule> _mappings = artifacts.getMappings();
        for (MappingRule rule : _mappings) {
            boolean _equalsRule;
            boolean _notEquals;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)rule, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean bl2 = _and = rule != mappingRule;
            }
            if (!_and || !(_equalsRule = this.equalsRule(mappingRule, rule))) continue;
            String _name = mappingRule.getName();
            String _plus = "Duplicate name : " + _name;
            String _plus_1 = String.valueOf(_plus) + "[";
            String _type = mappingRule.getType();
            String _plus_2 = String.valueOf(_plus_1) + _type;
            String _plus_3 = String.valueOf(_plus_2) + "]";
            this.error(_plus_3, (EStructuralFeature)ProcessorMetaPackage.Literals.MAPPING_RULE__NAME);
            return;
        }
    }

    public boolean equalsRule(MappingRule rule1, MappingRule rule2) {
        String _name_3;
        boolean _equals_1;
        boolean _and = false;
        boolean _equals = Objects.equal((Object)rule1, null);
        _and = !_equals ? false : (_equals_1 = Objects.equal((Object)rule2, null));
        if (_and) {
            return true;
        }
        boolean _or = false;
        boolean _equals_2 = Objects.equal((Object)rule1, null);
        if (_equals_2) {
            _or = true;
        } else {
            boolean _equals_3;
            String _name = rule1.getName();
            _or = _equals_3 = Objects.equal((Object)_name, null);
        }
        if (_or) {
            return false;
        }
        boolean _or_1 = false;
        boolean _equals_4 = Objects.equal((Object)rule2, null);
        if (_equals_4) {
            _or_1 = true;
        } else {
            boolean _equals_5;
            String _name_1 = rule2.getName();
            _or_1 = _equals_5 = Objects.equal((Object)_name_1, null);
        }
        if (_or_1) {
            return false;
        }
        boolean _and_1 = false;
        String _name_2 = rule1.getName();
        boolean _equals_6 = _name_2.equals(_name_3 = rule2.getName());
        if (!_equals_6) {
            _and_1 = false;
        } else {
            boolean _equals_7;
            String _type = rule1.getType();
            String _type_1 = rule2.getType();
            _and_1 = _equals_7 = _type.equals(_type_1);
        }
        if (_and_1) {
            EList<String> _modifiers = rule1.getModifiers();
            EList<String> _modifiers_1 = rule2.getModifiers();
            return this.equalsModifiers((List<String>)_modifiers, (List<String>)_modifiers_1);
        }
        return false;
    }

    @Check
    public void checkUniqueOptionalFeature(OptionalFeature optionalFeature) {
        boolean _skipVerification = CommonUtils.skipVerification(optionalFeature, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(optionalFeature);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<OptionalFeature> _features = artifacts.getFeatures();
        for (OptionalFeature feature : _features) {
            boolean _equalsFeature;
            boolean _notEquals_1;
            boolean _notEquals;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)feature, null);
            _and = !_notEquals ? false : (_notEquals_1 = !Objects.equal((Object)feature, (Object)optionalFeature));
            if (!_and || !(_equalsFeature = this.equalsFeature(optionalFeature, feature))) continue;
            String _name = optionalFeature.getName();
            String _plus = "Duplicate name : " + _name;
            String _plus_1 = String.valueOf(_plus) + "[";
            String _type = optionalFeature.getType();
            String _plus_2 = String.valueOf(_plus_1) + _type;
            String _plus_3 = String.valueOf(_plus_2) + "]";
            this.error(_plus_3, (EStructuralFeature)ProcessorMetaPackage.Literals.OPTIONAL_FEATURE__NAME);
            return;
        }
    }

    public boolean equalsFeature(OptionalFeature feature1, OptionalFeature feature2) {
        String _name_3;
        boolean _equals_1;
        boolean _and = false;
        boolean _equals = Objects.equal((Object)feature1, null);
        _and = !_equals ? false : (_equals_1 = Objects.equal((Object)feature2, null));
        if (_and) {
            return true;
        }
        boolean _or = false;
        boolean _equals_2 = Objects.equal((Object)feature1, null);
        if (_equals_2) {
            _or = true;
        } else {
            boolean _equals_3;
            String _name = feature1.getName();
            _or = _equals_3 = Objects.equal((Object)_name, null);
        }
        if (_or) {
            return false;
        }
        boolean _or_1 = false;
        boolean _equals_4 = Objects.equal((Object)feature2, null);
        if (_equals_4) {
            _or_1 = true;
        } else {
            boolean _equals_5;
            String _name_1 = feature2.getName();
            _or_1 = _equals_5 = Objects.equal((Object)_name_1, null);
        }
        if (_or_1) {
            return false;
        }
        boolean _and_1 = false;
        String _name_2 = feature1.getName();
        boolean _equals_6 = _name_2.equals(_name_3 = feature2.getName());
        if (!_equals_6) {
            _and_1 = false;
        } else {
            boolean _equals_7;
            String _type = feature1.getType();
            String _type_1 = feature2.getType();
            _and_1 = _equals_7 = _type.equals(_type_1);
        }
        if (_and_1) {
            EList<String> _modifiers = feature1.getModifiers();
            EList<String> _modifiers_1 = feature2.getModifiers();
            return this.equalsModifiers((List<String>)_modifiers, (List<String>)_modifiers_1);
        }
        return false;
    }

    @Check
    public void checkUniquePojoDefinition(PojoDefinitionModel pojoDefinition) {
        boolean _skipVerification = CommonUtils.skipVerification(pojoDefinition, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(pojoDefinition);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<PojoDefinitionModel> _pojos = artifacts.getPojos();
        for (PojoDefinitionModel definition : _pojos) {
            String _name_1;
            String _name;
            boolean _equals_1;
            boolean _notEquals;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)definition, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean bl2 = _and = definition != pojoDefinition;
            }
            if (!_and || !(_equals_1 = (_name = pojoDefinition.getName()).equals(_name_1 = definition.getName()))) continue;
            String _name_2 = pojoDefinition.getName();
            String _plus = "Duplicate name : " + _name_2;
            this.error(_plus, (EStructuralFeature)ProcessorMetaPackage.Literals.POJO_DEFINITION_MODEL__NAME);
            return;
        }
    }

    @Check
    public void checkUniqueAnnotationDefinition(AnnotationDefinitionModel annotationDefinition) {
        boolean _skipVerification = CommonUtils.skipVerification(annotationDefinition, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(annotationDefinition);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<AnnotationDefinitionModel> _annotations = artifacts.getAnnotations();
        for (AnnotationDefinitionModel definition : _annotations) {
            String _name_1;
            String _name;
            boolean _equals_1;
            boolean _notEquals;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)definition, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean bl2 = _and = definition != annotationDefinition;
            }
            if (!_and || !(_equals_1 = (_name = annotationDefinition.getName()).equals(_name_1 = definition.getName()))) continue;
            String _name_2 = annotationDefinition.getName();
            String _plus = "Duplicate name : " + _name_2;
            this.error(_plus, (EStructuralFeature)ProcessorMetaPackage.Literals.ANNOTATION_DEFINITION_MODEL__NAME);
            return;
        }
    }

    @Check
    public void checkUniqueProperty(Property property) {
        boolean _skipVerification = CommonUtils.skipVerification(property, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(property);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<Property> _properties = artifacts.getProperties();
        for (Property prop : _properties) {
            String _name_6;
            boolean _startsWith_4;
            boolean _not_4;
            String _name_5;
            boolean _startsWith_3;
            boolean _not_3;
            String _name_4;
            boolean _startsWith_2;
            boolean _not_2;
            String _name_3;
            boolean _startsWith_1;
            boolean _not_1;
            String _name_2;
            boolean _startsWith;
            boolean _not;
            String _name_1;
            boolean _notEquals;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)prop, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean bl2 = _and = prop != property;
            }
            if (!_and) continue;
            boolean _and_1 = false;
            boolean _and_2 = false;
            boolean _and_3 = false;
            boolean _and_4 = false;
            boolean _and_5 = false;
            String _name = prop.getName();
            boolean _equals_1 = _name.equals(_name_1 = property.getName());
            _and_5 = !_equals_1 ? false : (_not = !(_startsWith = (_name_2 = prop.getName()).startsWith("pojogen")));
            _and_4 = !_and_5 ? false : (_not_1 = !(_startsWith_1 = (_name_3 = prop.getName()).startsWith("database")));
            _and_3 = !_and_4 ? false : (_not_2 = !(_startsWith_2 = (_name_4 = prop.getName()).startsWith("metagen")));
            _and_2 = !_and_3 ? false : (_not_3 = !(_startsWith_3 = (_name_5 = prop.getName()).startsWith("daogen")));
            _and_1 = !_and_2 ? false : (_not_4 = !(_startsWith_4 = (_name_6 = prop.getName()).startsWith("replace-text")));
            if (!_and_1) continue;
            String _name_7 = property.getName();
            String _plus = "Duplicate name : " + _name_7;
            this.error(_plus, (EStructuralFeature)ProcessorMetaPackage.Literals.PROPERTY__NAME);
            return;
        }
    }

    public boolean equalsModifiers(List<String> modifiers1, List<String> modifiers2) {
        boolean _isEmpty_1;
        boolean _equals_1;
        List<String> filteredModifiers1 = this.filteredModifiers(modifiers1);
        List<String> filteredModifiers2 = this.filteredModifiers(modifiers2);
        boolean _and = false;
        boolean _equals = Objects.equal(filteredModifiers1, null);
        _and = !_equals ? false : (_equals_1 = Objects.equal(filteredModifiers2, null));
        if (_and) {
            return true;
        }
        boolean _equals_2 = Objects.equal(filteredModifiers1, null);
        if (_equals_2) {
            return false;
        }
        boolean _equals_3 = Objects.equal(filteredModifiers2, null);
        if (_equals_3) {
            return false;
        }
        boolean _and_1 = false;
        boolean _isEmpty = filteredModifiers1.isEmpty();
        _and_1 = !_isEmpty ? false : (_isEmpty_1 = filteredModifiers2.isEmpty());
        if (_and_1) {
            return true;
        }
        for (String modifier1 : filteredModifiers1) {
            for (String modifier2 : filteredModifiers2) {
                boolean _equals_4 = modifier1.equals(modifier2);
                if (!_equals_4) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> filteredModifiers(List<String> modifiers) {
        boolean _equals = Objects.equal(modifiers, null);
        if (_equals) {
            return null;
        }
        final ArrayList filteredModifiers = CollectionLiterals.newArrayList((Object[])new String[0]);
        Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

            public void apply(String modifier) {
                boolean _lessThan;
                int _indexOf = modifier.indexOf("=");
                boolean bl = _lessThan = _indexOf < 0;
                if (_lessThan) {
                    filteredModifiers.add(modifier);
                }
            }
        };
        IterableExtensions.forEach(modifiers, (Procedures.Procedure1)_function);
        return filteredModifiers;
    }

    public String getClass(PojoDefinitionModel pojo) {
        boolean _notEquals;
        JvmType _classx = pojo.getClassx();
        boolean bl = _notEquals = !Objects.equal((Object)_classx, null);
        if (_notEquals) {
            JvmType _classx_1 = pojo.getClassx();
            return _classx_1.getQualifiedName();
        }
        return pojo.getClass_();
    }

    @Check
    public void checkMetaStatement(final MetaStatement statement) {
        boolean _isResolveDb;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _isOldPojoValidator;
        boolean _or = false;
        EList<String> _modifiers = statement.getModifiers();
        boolean _equals = Objects.equal(_modifiers, null);
        if (_equals) {
            _or = true;
        } else {
            boolean _isEmpty;
            EList<String> _modifiers_1 = statement.getModifiers();
            _or = _isEmpty = _modifiers_1.isEmpty();
        }
        if (_or) {
            return;
        }
        boolean _skipVerification = CommonUtils.skipVerification(statement, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        final Artifacts artifacts = this.getArtifacts(statement);
        boolean _equals_1 = Objects.equal((Object)artifacts, null);
        if (_equals_1) {
            return;
        }
        Resource _eResource = statement.eResource();
        URI _uRI = null;
        if (_eResource != null) {
            _uRI = _eResource.getURI();
        }
        final URI uri = _uRI;
        final HashMap descriptorsCache = new HashMap();
        final HashMap classesCache = new HashMap();
        final HashMap ordersCache = new HashMap();
        int index = 0;
        String identPojoName = null;
        PojoDefinition identPojo = null;
        String indexPojoName = null;
        PojoDefinition indexPojo = null;
        String colPojoName = null;
        PojoDefinition colPojo = null;
        String constPojoName = null;
        PojoDefinition constPojo = null;
        TreeMap<String, TableDefinition> tablesPojo = new TreeMap<String, TableDefinition>();
        TreeMap<String, TableDefinition> tablesPrefixPojo = new TreeMap<String, TableDefinition>();
        EList<String> _modifiers_2 = statement.getModifiers();
        for (String modifier : _modifiers_2) {
            boolean _equals_4;
            boolean _greaterThan;
            String[] values = modifier.split("=");
            int _length = values.length;
            boolean bl = _greaterThan = _length > 1;
            if (!_greaterThan) continue;
            String key = values[0];
            String value = values[1];
            boolean _equals_2 = "in".equals(key);
            if (_equals_2) {
                Map<String, PojoDefinition> _modelPojos = this.modelProperty.getModelPojos(artifacts);
                PojoDefinition _get = _modelPojos.get(value);
                identPojo = _get;
                boolean _equals_3 = Objects.equal((Object)identPojo, null);
                if (_equals_3) {
                    this.error("Cannot find pojo : " + value + "[" + "in" + "]", (EStructuralFeature)ProcessorMetaPackage.Literals.META_STATEMENT__MODIFIERS, index);
                } else {
                    identPojoName = value;
                }
            }
            if (_equals_4 = "ix".equals(key)) {
                Map<String, PojoDefinition> _modelPojos_1 = this.modelProperty.getModelPojos(artifacts);
                PojoDefinition _get_1 = _modelPojos_1.get(value);
                indexPojo = _get_1;
                boolean _equals_5 = Objects.equal((Object)indexPojo, null);
                if (_equals_5) {
                    this.error("Cannot find pojo : " + value + "[" + "ix" + "]", (EStructuralFeature)ProcessorMetaPackage.Literals.META_STATEMENT__MODIFIERS, index);
                } else {
                    indexPojoName = value;
                }
            } else {
                boolean _equals_6 = "out".equals(key);
                if (_equals_6) {
                    Map<String, PojoDefinition> _modelPojos_2 = this.modelProperty.getModelPojos(artifacts);
                    PojoDefinition _get_2 = _modelPojos_2.get(value);
                    colPojo = _get_2;
                    boolean _equals_7 = Objects.equal((Object)colPojo, null);
                    if (_equals_7) {
                        this.error("Cannot find pojo : " + value + "[" + "out" + "]", (EStructuralFeature)ProcessorMetaPackage.Literals.META_STATEMENT__MODIFIERS, index);
                    } else {
                        colPojoName = value;
                    }
                } else {
                    boolean _equals_8 = "const".equals(key);
                    if (_equals_8) {
                        Map<String, PojoDefinition> _modelPojos_3 = this.modelProperty.getModelPojos(artifacts);
                        PojoDefinition _get_3 = _modelPojos_3.get(value);
                        constPojo = _get_3;
                        boolean _equals_9 = Objects.equal((Object)constPojo, null);
                        if (_equals_9) {
                            this.error("Cannot find pojo : " + value + "[" + "const" + "]", (EStructuralFeature)ProcessorMetaPackage.Literals.META_STATEMENT__MODIFIERS, index);
                        } else {
                            constPojoName = value;
                        }
                    } else {
                        boolean _equals_10 = "tab".equals(key);
                        if (_equals_10) {
                            String _xifexpression = null;
                            int _length_1 = values.length;
                            boolean _greaterThan_1 = _length_1 > 2;
                            _xifexpression = _greaterThan_1 ? values[2] : "_DEFAULT_";
                            String prefix = _xifexpression;
                            Map<String, TableDefinition> _modelTables = this.modelProperty.getModelTables(artifacts);
                            TableDefinition table = _modelTables.get(value);
                            boolean _equals_11 = Objects.equal((Object)table, null);
                            if (_equals_11) {
                                this.error("Cannot find table : " + value + "[" + "tab" + "]", (EStructuralFeature)ProcessorMetaPackage.Literals.META_STATEMENT__MODIFIERS, index);
                            } else {
                                tablesPojo.put(value, table);
                                tablesPrefixPojo.put(prefix, table);
                            }
                        }
                    }
                }
            }
            ++index;
        }
        boolean _equals_2 = Objects.equal(indexPojo, null);
        if (_equals_2) {
            indexPojo = identPojo;
            indexPojoName = identPojoName;
        }
        final boolean newPojoValidator = !(_isOldPojoValidator = this.modelProperty.isOldPojoValidator(statement));
        boolean bl = _notEquals = !Objects.equal(identPojo, null);
        if (_notEquals) {
            List identifiers = EcoreUtil2.getAllContentsOfType((EObject)statement, Identifier.class);
            final PojoDefinition pojo = identPojo;
            final String pojoName = identPojoName;
            Procedures.Procedure1<Identifier> _function = new Procedures.Procedure1<Identifier>(){

                public void apply(Identifier identifier) {
                    ProcessorMetaValidator.this.checkIdentifier(identifier, pojo, pojoName, statement, newPojoValidator, artifacts, uri, descriptorsCache, classesCache);
                }
            };
            IterableExtensions.forEach((Iterable)identifiers, (Procedures.Procedure1)_function);
        }
        boolean bl2 = _notEquals_1 = !Objects.equal(indexPojo, null);
        if (_notEquals_1) {
            List orders = EcoreUtil2.getAllContentsOfType((EObject)statement, OrdSql.class);
            final PojoDefinition pojo_1 = indexPojo;
            final String pojoName_1 = indexPojoName;
            Procedures.Procedure1<OrdSql> _function_1 = new Procedures.Procedure1<OrdSql>(){

                public void apply(OrdSql order) {
                    ProcessorMetaValidator.this.checkOrder(order, pojo_1, pojoName_1, statement, newPojoValidator, artifacts, uri, ordersCache, classesCache);
                }
            };
            IterableExtensions.forEach((Iterable)orders, (Procedures.Procedure1)_function_1);
        }
        boolean bl3 = _notEquals_2 = !Objects.equal(colPojo, null);
        if (_notEquals_2) {
            List columns = EcoreUtil2.getAllContentsOfType((EObject)statement, Column.class);
            final PojoDefinition pojo_2 = colPojo;
            final String pojoName_2 = colPojoName;
            Procedures.Procedure1<Column> _function_2 = new Procedures.Procedure1<Column>(){

                public void apply(Column column) {
                    ProcessorMetaValidator.this.checkColumn(column, pojo_2, pojoName_2, statement, newPojoValidator, artifacts, uri, descriptorsCache, classesCache);
                }
            };
            IterableExtensions.forEach((Iterable)columns, (Procedures.Procedure1)_function_2);
        }
        boolean bl4 = _notEquals_3 = !Objects.equal(constPojo, null);
        if (_notEquals_3) {
            List constants = EcoreUtil2.getAllContentsOfType((EObject)statement, Constant.class);
            final PojoDefinition pojo_3 = constPojo;
            final String pojoName_3 = constPojoName;
            Procedures.Procedure1<Constant> _function_3 = new Procedures.Procedure1<Constant>(){

                public void apply(Constant constant) {
                    ProcessorMetaValidator.this.checkConstant(constant, pojo_3, pojoName_3, statement, newPojoValidator, artifacts, uri, descriptorsCache, classesCache);
                }
            };
            IterableExtensions.forEach((Iterable)constants, (Procedures.Procedure1)_function_3);
        }
        if (_isResolveDb = this.isResolveDb(statement)) {
            this.checkTablesColumns(tablesPojo, tablesPrefixPojo, statement);
        }
    }

    public void checkTablesColumns(final TreeMap<String, TableDefinition> tablesPojo, final TreeMap<String, TableDefinition> tablesPrefixPojo, final MetaStatement statement) {
        List tables = EcoreUtil2.getAllContentsOfType((EObject)statement, DatabaseTable.class);
        Procedures.Procedure1<DatabaseTable> _function = new Procedures.Procedure1<DatabaseTable>(){

            public void apply(DatabaseTable table) {
                boolean _checkTable;
                boolean _not;
                final String tableName = table.getName();
                Collection _values = tablesPojo.values();
                Functions.Function1<TableDefinition, Boolean> _function = new Functions.Function1<TableDefinition, Boolean>(){

                    public Boolean apply(TableDefinition it) {
                        String _table = it.getTable();
                        return Objects.equal((Object)_table, (Object)tableName);
                    }
                };
                TableDefinition tableDefinition = (TableDefinition)IterableExtensions.findFirst(_values, (Functions.Function1)_function);
                boolean _or = false;
                boolean _equals = Objects.equal((Object)tableDefinition, null);
                _or = _equals ? true : (_not = !(_checkTable = ProcessorMetaValidator.this.dbResolver.checkTable(statement, tableName)));
                if (_or) {
                    ProcessorMetaValidator.this.error("Cannot find table in DB : " + tableName, table, (EStructuralFeature)ProcessorMetaPackage.Literals.DATABASE_TABLE__NAME);
                }
            }
        };
        IterableExtensions.forEach((Iterable)tables, (Procedures.Procedure1)_function);
        List columns = EcoreUtil2.getAllContentsOfType((EObject)statement, DatabaseColumn.class);
        Procedures.Procedure1<DatabaseColumn> _function_1 = new Procedures.Procedure1<DatabaseColumn>(){

            public void apply(DatabaseColumn column) {
                boolean _checkColumn;
                boolean _not;
                boolean _notEquals;
                String _name = column.getName();
                int pos = _name.indexOf(".");
                String _xifexpression = null;
                if (pos > 0) {
                    String _name_1 = column.getName();
                    _xifexpression = _name_1.substring(0, pos);
                } else {
                    _xifexpression = "_DEFAULT_";
                }
                String prefix = _xifexpression;
                String _xifexpression_1 = null;
                if (pos > 0) {
                    String _name_2 = column.getName();
                    _xifexpression_1 = _name_2.substring(pos + 1);
                } else {
                    _xifexpression_1 = column.getName();
                }
                String columnName = _xifexpression_1;
                TableDefinition tableDefinition = (TableDefinition)tablesPrefixPojo.get(prefix);
                String _xifexpression_2 = null;
                boolean bl = _notEquals = !Objects.equal((Object)tableDefinition, null);
                if (_notEquals) {
                    _xifexpression_2 = tableDefinition.getTable();
                }
                String tableName = _xifexpression_2;
                boolean _or = false;
                boolean _equals = Objects.equal((Object)tableName, null);
                _or = _equals ? true : (_not = !(_checkColumn = ProcessorMetaValidator.this.dbResolver.checkColumn(column, tableName, columnName)));
                if (_or) {
                    String _name_3 = column.getName();
                    String _plus = "Cannot find column in DB : " + _name_3;
                    String _plus_1 = String.valueOf(_plus) + "[";
                    String _plus_2 = String.valueOf(_plus_1) + tableName;
                    String _plus_3 = String.valueOf(_plus_2) + "]";
                    ProcessorMetaValidator.this.error(_plus_3, column, (EStructuralFeature)ProcessorMetaPackage.Literals.DATABASE_COLUMN__NAME);
                }
            }
        };
        IterableExtensions.forEach((Iterable)columns, (Procedures.Procedure1)_function_1);
    }

    public void checkIdentifier(Identifier identifier, PojoDefinition pojo, String pojoName, MetaStatement statement, boolean newPojoValidator, Artifacts artifacts, URI uri, Map<String, PropertyDescriptor[]> descriptorsCache, Map<String, Class<?>> classesCache) {
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _isResolvePojo = this.isResolvePojo(identifier);
        boolean bl = _not = !_isResolvePojo;
        if (_not) {
            return;
        }
        String identifierName = identifier.getName();
        String identifierUsageClass = pojo.getQualifiedName();
        ValidationResult validationResult = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)identifierUsageClass, null);
        if (_notEquals) {
            boolean _and = false;
            if (!newPojoValidator) {
                _and = false;
            } else {
                JvmType _classx = pojo.getClassx();
                _and = _classx instanceof JvmDeclaredType;
            }
            if (_and) {
                ValidationResult _checkClassProperty;
                JvmType _classx_1 = pojo.getClassx();
                validationResult = _checkClassProperty = this.checkClassProperty((JvmDeclaredType)_classx_1, identifierName);
            } else {
                ValidationResult _checkClassProperty_1;
                validationResult = _checkClassProperty_1 = this.checkClassProperty(identifierUsageClass, identifierName, uri, descriptorsCache, classesCache);
            }
            if (validationResult != null) {
                switch (validationResult) {
                    case WARNING: {
                        this.warning("Problem property : " + identifierName + "[" + identifierUsageClass + "]", identifier, (EStructuralFeature)ProcessorMetaPackage.Literals.IDENTIFIER__NAME);
                        break;
                    }
                    case ERROR: {
                        this.error("Cannot find property : " + identifierName + "[" + identifierUsageClass + "]", identifier, (EStructuralFeature)ProcessorMetaPackage.Literals.IDENTIFIER__NAME);
                        break;
                    }
                }
            }
            return;
        }
        PojoResolver _pojoResolver = this.pojoResolverFactory.getPojoResolver();
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)_pojoResolver, null);
        if (_notEquals_1) {
            this.error("Cannot check input form attribute : " + identifierName, identifier, (EStructuralFeature)ProcessorMetaPackage.Literals.IDENTIFIER__NAME);
        }
    }

    public void checkOrder(OrdSql order, PojoDefinition pojo, String pojoName, MetaStatement statement, boolean newPojoValidator, Artifacts artifacts, URI uri, Map<String, Map<String, String>> ordersCache, Map<String, Class<?>> classesCache) {
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _isResolvePojo = this.isResolvePojo(order);
        boolean bl = _not = !_isResolvePojo;
        if (_not) {
            return;
        }
        String identifierName = order.getIdent();
        String identifierUsageClass = pojo.getQualifiedName();
        ValidationResult validationResult = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)identifierUsageClass, null);
        if (_notEquals) {
            boolean _and = false;
            if (!newPojoValidator) {
                _and = false;
            } else {
                JvmType _classx = pojo.getClassx();
                _and = _classx instanceof JvmDeclaredType;
            }
            if (_and) {
                ValidationResult _checkOrderProperty;
                JvmType _classx_1 = pojo.getClassx();
                validationResult = _checkOrderProperty = this.checkOrderProperty((JvmDeclaredType)_classx_1, identifierName);
            } else {
                this.checkOrderProperty(identifierUsageClass, identifierName, uri, ordersCache, classesCache);
            }
            if (validationResult != null) {
                switch (validationResult) {
                    case WARNING: {
                        this.warning("Problem order : " + identifierName + "[" + identifierUsageClass + "]", order, (EStructuralFeature)ProcessorMetaPackage.Literals.ORD_SQL__IDENT);
                        break;
                    }
                    case ERROR: {
                        this.warning("Cannot find order : " + identifierName + "[" + identifierUsageClass + "]", order, (EStructuralFeature)ProcessorMetaPackage.Literals.ORD_SQL__IDENT);
                        break;
                    }
                }
            }
            return;
        }
        PojoResolver _pojoResolver = this.pojoResolverFactory.getPojoResolver();
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)_pojoResolver, null);
        if (_notEquals_1) {
            this.error("Cannot check order identifier : " + identifierName, order, (EStructuralFeature)ProcessorMetaPackage.Literals.ORD_SQL__IDENT);
        }
    }

    public void checkColumn(Column column, PojoDefinition pojo, String pojoName, MetaStatement statement, boolean newPojoValidator, Artifacts artifacts, URI uri, Map<String, PropertyDescriptor[]> descriptorsCache, Map<String, Class<?>> classesCache) {
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _isResolvePojo = this.isResolvePojo(column);
        boolean bl = _not = !_isResolvePojo;
        if (_not) {
            return;
        }
        String columnName = Utils.getName(column);
        boolean _isNumber = Utils.isNumber(columnName);
        if (_isNumber) {
            return;
        }
        String _xifexpression = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)pojo, null);
        if (_notEquals) {
            _xifexpression = pojo.getQualifiedName();
        }
        String columnUsageClass = _xifexpression;
        ValidationResult validationResult = null;
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)columnUsageClass, null);
        if (_notEquals_1) {
            boolean _and = false;
            if (!newPojoValidator) {
                _and = false;
            } else {
                JvmType _classx = pojo.getClassx();
                _and = _classx instanceof JvmDeclaredType;
            }
            if (_and) {
                ValidationResult _checkClassProperty;
                JvmType _classx_1 = pojo.getClassx();
                validationResult = _checkClassProperty = this.checkClassProperty((JvmDeclaredType)_classx_1, columnName);
            } else {
                ValidationResult _checkClassProperty_1;
                validationResult = _checkClassProperty_1 = this.checkClassProperty(columnUsageClass, columnName, uri, descriptorsCache, classesCache);
            }
            if (validationResult != null) {
                switch (validationResult) {
                    case WARNING: {
                        this.warning("Problem property : " + columnName + "[" + columnUsageClass + "]", column, (EStructuralFeature)ProcessorMetaPackage.Literals.COLUMN__COLUMNS);
                        break;
                    }
                    case ERROR: {
                        this.checkColumnGType(column, columnName, columnUsageClass, statement);
                        break;
                    }
                }
            }
            return;
        }
        PojoResolver _pojoResolver = this.pojoResolverFactory.getPojoResolver();
        boolean bl4 = _notEquals_2 = !Objects.equal((Object)_pojoResolver, null);
        if (_notEquals_2) {
            this.error("Cannot check result class attribute : " + columnName, column, (EStructuralFeature)ProcessorMetaPackage.Literals.COLUMN__COLUMNS);
        }
    }

    public void checkColumnGType(Column column, String columnName, String columnUsageClass, MetaStatement statement) {
        boolean _or = false;
        Sql _statement = statement.getStatement();
        boolean _equals = Objects.equal((Object)_statement, null);
        if (_equals) {
            _or = true;
        } else {
            boolean _equals_1;
            Sql _statement_1 = statement.getStatement();
            EList<SqlFragment> _sqls = _statement_1.getSqls();
            _or = _equals_1 = Objects.equal(_sqls, null);
        }
        if (_or) {
            return;
        }
        Sql _statement_2 = statement.getStatement();
        EList<SqlFragment> _sqls_1 = _statement_2.getSqls();
        for (SqlFragment stmt : _sqls_1) {
            MetaSql _meta_1;
            EList<IfSql> _ifs;
            boolean _notEquals_5;
            boolean _notEquals_4;
            Column _col_2;
            EList<ExtendedColumn> _columns_1;
            boolean _notEquals_2;
            Column _col_1;
            EList<ExtendedColumn> _columns;
            boolean _notEquals_1;
            boolean _notEquals;
            boolean _and = false;
            boolean _and_1 = false;
            Column _col = stmt.getCol();
            boolean bl = _notEquals = !Objects.equal((Object)_col, null);
            _and_1 = !_notEquals ? false : (_notEquals_1 = !Objects.equal(_columns = (_col_1 = stmt.getCol()).getColumns(), null));
            _and = !_and_1 ? false : (_notEquals_2 = !Objects.equal(_columns_1 = (_col_2 = stmt.getCol()).getColumns(), null));
            if (_and) {
                Column _col_3 = stmt.getCol();
                EList<ExtendedColumn> _columns_2 = _col_3.getColumns();
                for (ExtendedColumn _col_4 : _columns_2) {
                    boolean _notEquals_3;
                    EList<String> _modifiers = _col_4.getModifiers();
                    boolean bl2 = _notEquals_3 = !Objects.equal(_modifiers, null);
                    if (!_notEquals_3) continue;
                    EList<String> _modifiers_1 = _col_4.getModifiers();
                    for (String mod : _modifiers_1) {
                        boolean _greaterEqualsThan;
                        int _indexOf = mod.indexOf("gtype");
                        boolean bl3 = _greaterEqualsThan = _indexOf >= 0;
                        if (!_greaterEqualsThan) continue;
                        this.warning("Problem property : " + columnName + "[" + columnUsageClass + "]", column, (EStructuralFeature)ProcessorMetaPackage.Literals.COLUMN__COLUMNS);
                        return;
                    }
                }
            }
            boolean _and_2 = false;
            MetaSql _meta = stmt.getMeta();
            boolean bl4 = _notEquals_4 = !Objects.equal((Object)_meta, null);
            _and_2 = !_notEquals_4 ? false : (_notEquals_5 = !Objects.equal(_ifs = (_meta_1 = stmt.getMeta()).getIfs(), null));
            if (!_and_2) continue;
            MetaSql _meta_2 = stmt.getMeta();
            EList<IfSql> _ifs_1 = _meta_2.getIfs();
            for (IfSql ifs : _ifs_1) {
                boolean _notEquals_6;
                EList<IfSqlFragment> _sqls_2 = ifs.getSqls();
                boolean bl5 = _notEquals_6 = !Objects.equal(_sqls_2, null);
                if (!_notEquals_6) continue;
                EList<IfSqlFragment> _sqls_3 = ifs.getSqls();
                for (IfSqlFragment stmt2 : _sqls_3) {
                    Column _col_7;
                    EList<ExtendedColumn> _columns_4;
                    boolean _notEquals_9;
                    Column _col_6;
                    EList<ExtendedColumn> _columns_3;
                    boolean _notEquals_8;
                    boolean _notEquals_7;
                    boolean _and_3 = false;
                    boolean _and_4 = false;
                    Column _col_5 = stmt2.getCol();
                    boolean bl6 = _notEquals_7 = !Objects.equal((Object)_col_5, null);
                    _and_4 = !_notEquals_7 ? false : (_notEquals_8 = !Objects.equal(_columns_3 = (_col_6 = stmt2.getCol()).getColumns(), null));
                    _and_3 = !_and_4 ? false : (_notEquals_9 = !Objects.equal(_columns_4 = (_col_7 = stmt2.getCol()).getColumns(), null));
                    if (!_and_3) continue;
                    Column _col_8 = stmt2.getCol();
                    EList<ExtendedColumn> _columns_5 = _col_8.getColumns();
                    for (ExtendedColumn _col_9 : _columns_5) {
                        boolean _notEquals_10;
                        EList<String> _modifiers_2 = _col_9.getModifiers();
                        boolean bl7 = _notEquals_10 = !Objects.equal(_modifiers_2, null);
                        if (!_notEquals_10) continue;
                        EList<String> _modifiers_3 = _col_9.getModifiers();
                        for (String mod_1 : _modifiers_3) {
                            boolean _greaterEqualsThan_1;
                            int _indexOf_1 = mod_1.indexOf("gtype");
                            boolean bl8 = _greaterEqualsThan_1 = _indexOf_1 >= 0;
                            if (!_greaterEqualsThan_1) continue;
                            this.warning("Problem property : " + columnName + "[" + columnUsageClass + "]", column, (EStructuralFeature)ProcessorMetaPackage.Literals.COLUMN__COLUMNS);
                            return;
                        }
                    }
                }
            }
        }
        this.error("Cannot find property : " + columnName + "[" + columnUsageClass + "]", column, (EStructuralFeature)ProcessorMetaPackage.Literals.COLUMN__COLUMNS);
    }

    public void checkConstant(Constant constant, PojoDefinition pojo, String pojoName, MetaStatement statement, boolean newPojoValidator, Artifacts artifacts, URI uri, Map<String, PropertyDescriptor[]> descriptorsCache, Map<String, Class<?>> classesCache) {
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _isResolvePojo = this.isResolvePojo(constant);
        boolean bl = _not = !_isResolvePojo;
        if (_not) {
            return;
        }
        String _xifexpression = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)pojo, null);
        if (_notEquals) {
            _xifexpression = pojo.getQualifiedName();
        }
        String constantUsageClass = _xifexpression;
        ValidationResult validationResult = null;
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)constantUsageClass, null);
        if (_notEquals_1) {
            boolean _and = false;
            if (!newPojoValidator) {
                _and = false;
            } else {
                JvmType _classx = pojo.getClassx();
                _and = _classx instanceof JvmDeclaredType;
            }
            if (_and) {
                ValidationResult _checkClassProperty;
                JvmType _classx_1 = pojo.getClassx();
                String _name = constant.getName();
                validationResult = _checkClassProperty = this.checkClassProperty((JvmDeclaredType)_classx_1, _name);
            } else {
                ValidationResult _checkClassProperty_1;
                String _name_1 = constant.getName();
                validationResult = _checkClassProperty_1 = this.checkClassProperty(constantUsageClass, _name_1, uri, descriptorsCache, classesCache);
            }
            if (validationResult != null) {
                switch (validationResult) {
                    case WARNING: {
                        String _name_2 = constant.getName();
                        String _plus = "Problem property : " + _name_2;
                        String _plus_1 = String.valueOf(_plus) + "[";
                        String _plus_2 = String.valueOf(_plus_1) + constantUsageClass;
                        String _plus_3 = String.valueOf(_plus_2) + "]";
                        this.warning(_plus_3, constant, (EStructuralFeature)ProcessorMetaPackage.Literals.CONSTANT__NAME);
                        break;
                    }
                    case ERROR: {
                        String _name_3 = constant.getName();
                        String _plus_4 = "Cannot find property : " + _name_3;
                        String _plus_5 = String.valueOf(_plus_4) + "[";
                        String _plus_6 = String.valueOf(_plus_5) + constantUsageClass;
                        String _plus_7 = String.valueOf(_plus_6) + "]";
                        this.error(_plus_7, constant, (EStructuralFeature)ProcessorMetaPackage.Literals.CONSTANT__NAME);
                        break;
                    }
                }
            }
            return;
        }
        PojoResolver _pojoResolver = this.pojoResolverFactory.getPojoResolver();
        boolean bl4 = _notEquals_2 = !Objects.equal((Object)_pojoResolver, null);
        if (_notEquals_2) {
            String _name_4 = constant.getName();
            String _plus_8 = "Cannot check constant form attribute : " + _name_4;
            this.error(_plus_8, (EStructuralFeature)ProcessorMetaPackage.Literals.CONSTANT__NAME);
        }
    }

    @Check
    public void checkMappingRule(final MappingRule rule) {
        boolean _notEquals;
        boolean _or = false;
        EList<String> _modifiers = rule.getModifiers();
        boolean _equals = Objects.equal(_modifiers, null);
        if (_equals) {
            _or = true;
        } else {
            boolean _isEmpty;
            EList<String> _modifiers_1 = rule.getModifiers();
            _or = _isEmpty = _modifiers_1.isEmpty();
        }
        if (_or) {
            return;
        }
        boolean _skipVerification = CommonUtils.skipVerification(rule, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        final Artifacts artifacts = this.getArtifacts(rule);
        boolean _equals_1 = Objects.equal((Object)artifacts, null);
        if (_equals_1) {
            return;
        }
        Resource _eResource = rule.eResource();
        URI _uRI = null;
        if (_eResource != null) {
            _uRI = _eResource.getURI();
        }
        final URI uri = _uRI;
        final HashMap descriptorsCache = new HashMap();
        final HashMap classesCache = new HashMap();
        int index = 0;
        String colPojoName = null;
        PojoDefinition colPojo = null;
        EList<String> _modifiers_2 = rule.getModifiers();
        for (String modifier : _modifiers_2) {
            int ix = modifier.indexOf("=");
            if (ix <= 0) continue;
            String key = modifier.substring(0, ix);
            String value = modifier.substring(ix + 1);
            boolean _equals_2 = "out".equals(key);
            if (_equals_2) {
                Map<String, PojoDefinition> _modelPojos = this.modelProperty.getModelPojos(artifacts);
                PojoDefinition _get = _modelPojos.get(value);
                colPojo = _get;
                boolean _equals_3 = Objects.equal((Object)colPojo, null);
                if (_equals_3) {
                    this.error("Cannot find pojo : " + value + "[" + "out" + "]", (EStructuralFeature)ProcessorMetaPackage.Literals.MAPPING_RULE__MODIFIERS, index);
                } else {
                    colPojoName = value;
                }
            }
            ++index;
        }
        boolean bl = _notEquals = !Objects.equal(colPojo, null);
        if (_notEquals) {
            boolean _isOldPojoValidator = this.modelProperty.isOldPojoValidator(rule);
            final boolean newPojoValidator = !_isOldPojoValidator;
            List columns = EcoreUtil2.getAllContentsOfType((EObject)rule, MappingColumn.class);
            final PojoDefinition pojo = colPojo;
            final String pojoName = colPojoName;
            Procedures.Procedure1<MappingColumn> _function = new Procedures.Procedure1<MappingColumn>(){

                public void apply(MappingColumn column) {
                    ProcessorMetaValidator.this.checkMappingColumn(column, pojo, pojoName, rule, newPojoValidator, artifacts, uri, descriptorsCache, classesCache);
                }
            };
            IterableExtensions.forEach((Iterable)columns, (Procedures.Procedure1)_function);
        }
    }

    public void checkMappingColumn(MappingColumn column, PojoDefinition pojo, String pojoName, MappingRule rule, boolean newPojoValidator, Artifacts artifacts, URI uri, Map<String, PropertyDescriptor[]> descriptorsCache, Map<String, Class<?>> classesCache) {
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _isResolvePojo = this.isResolvePojo(column);
        boolean bl = _not = !_isResolvePojo;
        if (_not) {
            return;
        }
        String columnName = Utils.getName(column);
        boolean _isNumber = Utils.isNumber(columnName);
        if (_isNumber) {
            return;
        }
        String mappingUsageClass = pojo.getQualifiedName();
        ValidationResult validationResult = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)mappingUsageClass, null);
        if (_notEquals) {
            boolean _and = false;
            if (!newPojoValidator) {
                _and = false;
            } else {
                JvmType _classx = pojo.getClassx();
                _and = _classx instanceof JvmDeclaredType;
            }
            if (_and) {
                ValidationResult _checkClassProperty;
                JvmType _classx_1 = pojo.getClassx();
                validationResult = _checkClassProperty = this.checkClassProperty((JvmDeclaredType)_classx_1, columnName);
            } else {
                ValidationResult _checkClassProperty_1;
                validationResult = _checkClassProperty_1 = this.checkClassProperty(mappingUsageClass, columnName, uri, descriptorsCache, classesCache);
            }
            if (validationResult != null) {
                switch (validationResult) {
                    case WARNING: {
                        this.warning("Problem property : " + columnName + "[" + mappingUsageClass + "]", column, (EStructuralFeature)ProcessorMetaPackage.Literals.MAPPING_COLUMN__ITEMS);
                        break;
                    }
                    case ERROR: {
                        this.error("Cannot find property : " + columnName + "[" + mappingUsageClass + "]", column, (EStructuralFeature)ProcessorMetaPackage.Literals.MAPPING_COLUMN__ITEMS);
                        break;
                    }
                }
            }
            return;
        }
        PojoResolver _pojoResolver = this.pojoResolverFactory.getPojoResolver();
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)_pojoResolver, null);
        if (_notEquals_1) {
            this.error("Cannot check result class attribute : " + columnName, column, (EStructuralFeature)ProcessorMetaPackage.Literals.MAPPING_COLUMN__ITEMS);
        }
    }

    public ValidationResult checkClassProperty(String className, String property, URI uri, Map<String, PropertyDescriptor[]> descriptorsCache, Map<String, Class<?>> classesCache) {
        boolean _notEquals_2;
        int pos2;
        boolean _equals_4;
        boolean _isNumber;
        boolean _or = false;
        boolean _or_1 = false;
        boolean _equals = Objects.equal((Object)property, null);
        _or_1 = _equals ? true : (_isNumber = Utils.isNumber(property));
        if (_or_1) {
            _or = true;
        } else {
            boolean _equals_1;
            PojoResolver _pojoResolver = this.pojoResolverFactory.getPojoResolver();
            _or = _equals_1 = Objects.equal((Object)_pojoResolver, null);
        }
        if (_or) {
            return ValidationResult.OK;
        }
        boolean _equals_2 = Objects.equal((Object)className, null);
        if (_equals_2) {
            return ValidationResult.ERROR;
        }
        String _string = uri.toString();
        String _plus = String.valueOf(_string) + className;
        PropertyDescriptor[] descriptors = descriptorsCache.get(_plus);
        boolean _equals_3 = Objects.equal((Object)descriptors, null);
        if (_equals_3) {
            PojoResolver _pojoResolver_1 = this.pojoResolverFactory.getPojoResolver();
            PropertyDescriptor[] _propertyDescriptors = _pojoResolver_1.getPropertyDescriptors(className, uri);
            descriptors = _propertyDescriptors;
        }
        if (_equals_4 = Objects.equal((Object)descriptors, null)) {
            return ValidationResult.WARNING;
        }
        String _string_1 = uri.toString();
        String _plus_1 = String.valueOf(_string_1) + className;
        descriptorsCache.put(_plus_1, descriptors);
        String checkProperty = property;
        int pos1 = checkProperty.indexOf("=");
        if (pos1 > 0 && (pos2 = checkProperty.indexOf(".", pos1)) > pos1) {
            String _plus_2;
            String _substring = checkProperty.substring(0, pos1);
            String _substring_1 = checkProperty.substring(pos2);
            checkProperty = _plus_2 = String.valueOf(_substring) + _substring_1;
        }
        String innerProperty = null;
        int _indexOf = checkProperty.indexOf(".");
        pos1 = _indexOf;
        if (pos1 > 0) {
            String _substring_3;
            String _substring_2;
            innerProperty = _substring_2 = checkProperty.substring(pos1 + 1);
            checkProperty = _substring_3 = checkProperty.substring(0, pos1);
        }
        final String _checkProperty = checkProperty;
        PropertyDescriptor[] _converted_descriptors = descriptors;
        Functions.Function1<PropertyDescriptor, Boolean> _function = new Functions.Function1<PropertyDescriptor, Boolean>(){

            public Boolean apply(PropertyDescriptor descriptor) {
                String _name = descriptor.getName();
                return Objects.equal((Object)_name, (Object)_checkProperty);
            }
        };
        PropertyDescriptor checkDesriptor = (PropertyDescriptor)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_descriptors)), (Functions.Function1)_function);
        boolean _equals_5 = Objects.equal((Object)checkDesriptor, null);
        if (_equals_5) {
            boolean _isPrimitive;
            boolean _notEquals;
            String _string_2 = uri.toString();
            String _plus_3 = String.valueOf(_string_2) + className;
            Class<?> clazz = classesCache.get(_plus_3);
            boolean _equals_6 = Objects.equal(clazz, null);
            if (_equals_6) {
                PojoResolver _pojoResolver_2 = this.pojoResolverFactory.getPojoResolver();
                Class<?> _loadClass = _pojoResolver_2.loadClass(className, uri);
                clazz = _loadClass;
            }
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal(clazz, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean _isAbstract;
                int _modifiers = clazz.getModifiers();
                _and = _isAbstract = Modifier.isAbstract(_modifiers);
            }
            if (_and) {
                return ValidationResult.WARNING;
            }
            boolean _and_1 = false;
            boolean _notEquals_1 = !Objects.equal(clazz, null);
            _and_1 = !_notEquals_1 ? false : (_isPrimitive = this.isPrimitive(clazz));
            if (_and_1) {
                return ValidationResult.OK;
            }
            return ValidationResult.ERROR;
        }
        boolean bl = _notEquals_2 = !Objects.equal((Object)innerProperty, null);
        if (_notEquals_2) {
            Class innerClass = checkDesriptor.getPropertyType();
            boolean _isArray = innerClass.isArray();
            if (_isArray) {
                Type[] _actualTypeArguments_1;
                int _length;
                boolean _equals_8;
                Method _readMethod = checkDesriptor.getReadMethod();
                Type _genericReturnType = _readMethod.getGenericReturnType();
                ParameterizedType type = (ParameterizedType)_genericReturnType;
                boolean _or_2 = false;
                Type[] _actualTypeArguments = type.getActualTypeArguments();
                boolean _equals_7 = Objects.equal((Object)_actualTypeArguments, null);
                _or_2 = _equals_7 ? true : (_equals_8 = (_length = (_actualTypeArguments_1 = type.getActualTypeArguments()).length) == 0);
                if (_or_2) {
                    return ValidationResult.WARNING;
                }
                Type[] _actualTypeArguments_2 = type.getActualTypeArguments();
                Type _head = (Type)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_actualTypeArguments_2)));
                innerClass = (Class)_head;
                boolean _isPrimitive_1 = this.isPrimitive(innerClass);
                if (_isPrimitive_1) {
                    return ValidationResult.ERROR;
                }
                String _name = innerClass.getName();
                return this.checkClassProperty(_name, innerProperty, uri, descriptorsCache, classesCache);
            }
            boolean _isAssignableFrom = Collection.class.isAssignableFrom(innerClass);
            if (_isAssignableFrom) {
                Type[] _actualTypeArguments_4;
                int _length_1;
                boolean _equals_10;
                Method _readMethod_1 = checkDesriptor.getReadMethod();
                Type _genericReturnType_1 = _readMethod_1.getGenericReturnType();
                ParameterizedType type_1 = (ParameterizedType)_genericReturnType_1;
                boolean _or_3 = false;
                Type[] _actualTypeArguments_3 = type_1.getActualTypeArguments();
                boolean _equals_9 = Objects.equal((Object)_actualTypeArguments_3, null);
                _or_3 = _equals_9 ? true : (_equals_10 = (_length_1 = (_actualTypeArguments_4 = type_1.getActualTypeArguments()).length) == 0);
                if (_or_3) {
                    return ValidationResult.WARNING;
                }
                Type[] _actualTypeArguments_5 = type_1.getActualTypeArguments();
                Type _head_1 = (Type)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_actualTypeArguments_5)));
                innerClass = (Class)_head_1;
                boolean _isPrimitive_2 = this.isPrimitive(innerClass);
                if (_isPrimitive_2) {
                    return ValidationResult.ERROR;
                }
                String _name_1 = innerClass.getName();
                return this.checkClassProperty(_name_1, innerProperty, uri, descriptorsCache, classesCache);
            }
            boolean _isPrimitive_3 = this.isPrimitive(innerClass);
            if (_isPrimitive_3) {
                return ValidationResult.ERROR;
            }
            String _name_2 = innerClass.getName();
            return this.checkClassProperty(_name_2, innerProperty, uri, descriptorsCache, classesCache);
        }
        return ValidationResult.OK;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ValidationResult checkClassProperty(JvmDeclaredType jvmType, String property) {
        boolean _notEquals;
        boolean _isEmpty_1;
        JvmFeature _head;
        boolean _not;
        boolean _isEmpty;
        int pos2;
        boolean _isNumber;
        boolean _or = false;
        boolean _equals = Objects.equal((Object)property, null);
        _or = _equals ? true : (_isNumber = Utils.isNumber(property));
        if (_or) {
            return ValidationResult.OK;
        }
        boolean _equals_1 = Objects.equal((Object)jvmType, null);
        if (_equals_1) {
            return ValidationResult.ERROR;
        }
        String checkProperty = property;
        int pos1 = checkProperty.indexOf("=");
        if (pos1 > 0 && (pos2 = checkProperty.indexOf(".", pos1)) > pos1) {
            String _plus;
            String _substring = checkProperty.substring(0, pos1);
            String _substring_1 = checkProperty.substring(pos2);
            checkProperty = _plus = String.valueOf(_substring) + _substring_1;
        }
        String innerProperty = null;
        int _indexOf = checkProperty.indexOf(".");
        pos1 = _indexOf;
        if (pos1 > 0) {
            String _substring_3;
            String _substring_2;
            innerProperty = _substring_2 = checkProperty.substring(pos1 + 1);
            checkProperty = _substring_3 = checkProperty.substring(0, pos1);
        }
        Iterable features = jvmType.findAllFeaturesByName(checkProperty);
        boolean _or_1 = false;
        boolean _or_2 = false;
        boolean _equals_2 = Objects.equal((Object)features, null);
        _or_2 = _equals_2 ? true : (_isEmpty = IterableExtensions.isEmpty((Iterable)features));
        _or_1 = _or_2 ? true : (_not = !((_head = (JvmFeature)IterableExtensions.head((Iterable)features)) instanceof JvmField));
        if (_or_1) {
            Iterable _findAllFeaturesByName;
            String _firstUpper = StringExtensions.toFirstUpper((String)checkProperty);
            String _plus_1 = "get" + _firstUpper;
            features = _findAllFeaturesByName = jvmType.findAllFeaturesByName(_plus_1);
        }
        boolean _or_3 = false;
        boolean _or_4 = false;
        boolean _equals_3 = Objects.equal((Object)features, null);
        _or_4 = _equals_3 ? true : (_isEmpty_1 = IterableExtensions.isEmpty((Iterable)features));
        if (_or_4) {
            _or_3 = true;
        } else {
            JvmFeature _head_2;
            boolean _not_2;
            boolean _not_1;
            boolean _and = false;
            JvmFeature _head_1 = (JvmFeature)IterableExtensions.head((Iterable)features);
            boolean bl = _not_1 = !(_head_1 instanceof JvmOperation);
            _and = !_not_1 ? false : (_not_2 = !((_head_2 = (JvmFeature)IterableExtensions.head((Iterable)features)) instanceof JvmField));
            _or_3 = _and;
        }
        if (_or_3) {
            boolean _or_5 = false;
            if (jvmType instanceof JvmPrimitiveType) {
                _or_5 = true;
            } else {
                boolean _isPrimitive;
                String _qualifiedName = jvmType.getQualifiedName();
                _or_5 = _isPrimitive = this.isPrimitive(_qualifiedName);
            }
            if (_or_5) {
                return ValidationResult.OK;
            }
            boolean _isAbstract = jvmType.isAbstract();
            if (!_isAbstract) return ValidationResult.ERROR;
            return ValidationResult.WARNING;
        }
        boolean bl = _notEquals = !Objects.equal((Object)innerProperty, null);
        if (!_notEquals) return ValidationResult.OK;
        JvmFeature _head_3 = (JvmFeature)IterableExtensions.head((Iterable)features);
        if (_head_3 instanceof JvmOperation) {
            return ValidationResult.ERROR;
        }
        JvmFeature _head_4 = (JvmFeature)IterableExtensions.head((Iterable)features);
        JvmField field = (JvmField)_head_4;
        JvmTypeReference _type = field.getType();
        if (!(_type instanceof JvmParameterizedTypeReference)) return ValidationResult.WARNING;
        JvmTypeReference _type_1 = field.getType();
        JvmType type = ((JvmParameterizedTypeReference)_type_1).getType();
        if (!(type instanceof JvmDeclaredType)) {
            InputOutput.print((Object)("checkClassProperty " + property + ": "));
            InputOutput.println((Object)type);
            return ValidationResult.WARNING;
        } else {
            boolean _isEmpty_2;
            boolean _not_3;
            boolean _notEquals_1;
            JvmTypeReference _type_2 = field.getType();
            EList typeArgs = ((JvmParameterizedTypeReference)_type_2).getArguments();
            boolean _and_1 = false;
            boolean _and_2 = false;
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)typeArgs, null);
            _and_2 = !_notEquals_1 ? false : (_not_3 = !(_isEmpty_2 = typeArgs.isEmpty()));
            if (!_and_2) {
                _and_1 = false;
            } else {
                JvmTypeReference _head_5 = (JvmTypeReference)IterableExtensions.head((Iterable)typeArgs);
                _and_1 = _head_5 instanceof JvmParameterizedTypeReference;
            }
            if (!_and_1) return this.checkClassProperty((JvmDeclaredType)type, innerProperty);
            JvmTypeReference _head_6 = (JvmTypeReference)IterableExtensions.head((Iterable)typeArgs);
            JvmType type2 = ((JvmParameterizedTypeReference)_head_6).getType();
            if (type2 instanceof JvmDeclaredType) return this.checkClassProperty((JvmDeclaredType)type2, innerProperty);
            InputOutput.print((Object)("checkClassProperty2 " + property + ": "));
            InputOutput.println((Object)type2);
        }
        return ValidationResult.WARNING;
    }

    public Set<String> getFieldNamesForClass(JvmDeclaredType jvmType) {
        HashSet result = CollectionLiterals.newHashSet((Object[])new String[0]);
        Iterable _declaredFields = jvmType.getDeclaredFields();
        for (JvmField field : _declaredFields) {
            String _simpleName = field.getSimpleName();
            result.add(_simpleName);
        }
        return result;
    }

    public ValidationResult checkOrderProperty(String className, final String property, URI uri, Map<String, Map<String, String>> ordersCache, Map<String, Class<?>> classesCache) {
        boolean _notEquals;
        boolean _equals_4;
        boolean _or = false;
        boolean _equals = Objects.equal((Object)property, null);
        if (_equals) {
            _or = true;
        } else {
            boolean _equals_1;
            PojoResolver _pojoResolver = this.pojoResolverFactory.getPojoResolver();
            _or = _equals_1 = Objects.equal((Object)_pojoResolver, null);
        }
        if (_or) {
            return ValidationResult.OK;
        }
        boolean _equals_2 = Objects.equal((Object)className, null);
        if (_equals_2) {
            return ValidationResult.ERROR;
        }
        String _string = uri.toString();
        String _plus = String.valueOf(_string) + className;
        Map<String, String> orders = ordersCache.get(_plus);
        boolean _equals_3 = Objects.equal(orders, null);
        if (_equals_3) {
            PojoResolver _pojoResolver_1 = this.pojoResolverFactory.getPojoResolver();
            Map<String, String> _orders = _pojoResolver_1.getOrders(className, uri);
            orders = _orders;
        }
        if (_equals_4 = Objects.equal(orders, null)) {
            return ValidationResult.WARNING;
        }
        String _string_1 = uri.toString();
        String _plus_1 = String.valueOf(_string_1) + className;
        ordersCache.put(_plus_1, orders);
        final Map<String, String> _orders_1 = orders;
        Set<String> _keySet = orders.keySet();
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String k) {
                String _get = (String)_orders_1.get(k);
                return _get.equals(property);
            }
        };
        String order = (String)IterableExtensions.findFirst(_keySet, (Functions.Function1)_function);
        boolean bl = _notEquals = !Objects.equal((Object)order, null);
        if (_notEquals) {
            return ValidationResult.OK;
        }
        return ValidationResult.ERROR;
    }

    public ValidationResult checkOrderProperty(JvmDeclaredType jvmType, String property) {
        JvmFeature _head;
        boolean _not;
        boolean _isEmpty;
        boolean _equals = Objects.equal((Object)property, null);
        if (_equals) {
            return ValidationResult.OK;
        }
        boolean _equals_1 = Objects.equal((Object)jvmType, null);
        if (_equals_1) {
            return ValidationResult.ERROR;
        }
        Iterable features = jvmType.findAllFeaturesByName("ORDER_BY_" + property);
        boolean _or = false;
        boolean _or_1 = false;
        boolean _equals_2 = Objects.equal((Object)features, null);
        _or_1 = _equals_2 ? true : (_isEmpty = IterableExtensions.isEmpty((Iterable)features));
        _or = _or_1 ? true : (_not = !((_head = (JvmFeature)IterableExtensions.head((Iterable)features)) instanceof JvmField));
        if (_or) {
            JvmFeature _head_3;
            boolean _not_2;
            boolean _isEmpty_2;
            JvmDeclaredType _head_1;
            boolean _not_1;
            boolean _isEmpty_1;
            Iterable nestedTypes = jvmType.findAllNestedTypesByName("Order");
            boolean _or_2 = false;
            boolean _or_3 = false;
            boolean _equals_3 = Objects.equal((Object)nestedTypes, null);
            _or_3 = _equals_3 ? true : (_isEmpty_1 = IterableExtensions.isEmpty((Iterable)nestedTypes));
            _or_2 = _or_3 ? true : (_not_1 = !((_head_1 = (JvmDeclaredType)IterableExtensions.head((Iterable)nestedTypes)) instanceof JvmEnumerationType));
            if (_or_2) {
                return ValidationResult.ERROR;
            }
            JvmDeclaredType _head_2 = (JvmDeclaredType)IterableExtensions.head((Iterable)nestedTypes);
            JvmEnumerationType type = (JvmEnumerationType)_head_2;
            Iterable features2 = type.findAllFeaturesByName(property);
            boolean _or_4 = false;
            boolean _or_5 = false;
            boolean _equals_4 = Objects.equal((Object)features2, null);
            _or_5 = _equals_4 ? true : (_isEmpty_2 = IterableExtensions.isEmpty((Iterable)features2));
            _or_4 = _or_5 ? true : (_not_2 = !((_head_3 = (JvmFeature)IterableExtensions.head((Iterable)features2)) instanceof JvmEnumerationLiteral));
            if (_or_4) {
                return ValidationResult.ERROR;
            }
        }
        return ValidationResult.OK;
    }

    @Check
    public void checkTableDefinition(TableDefinitionModel tableDefinition) {
        String _table;
        boolean _checkTable;
        boolean _not;
        boolean _skipVerification = CommonUtils.skipVerification(tableDefinition, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(tableDefinition);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<TableDefinitionModel> _tables = artifacts.getTables();
        for (TableDefinitionModel table : _tables) {
            String _name_1;
            String _name;
            boolean _equals_1;
            boolean _notEquals;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)table, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean bl2 = _and = table != tableDefinition;
            }
            if (!_and || !(_equals_1 = (_name = tableDefinition.getName()).equals(_name_1 = table.getName()))) continue;
            String _name_2 = tableDefinition.getName();
            String _plus = "Duplicate name : " + _name_2;
            String _plus_1 = String.valueOf(_plus) + "[table]";
            this.error(_plus_1, (EStructuralFeature)ProcessorMetaPackage.Literals.TABLE_DEFINITION_MODEL__NAME);
            return;
        }
        boolean _and_1 = false;
        boolean _isResolveDb = this.isResolveDb(tableDefinition);
        _and_1 = !_isResolveDb ? false : (_not = !(_checkTable = this.dbResolver.checkTable(tableDefinition, _table = tableDefinition.getTable())));
        if (_and_1) {
            String _table_1 = tableDefinition.getTable();
            String _plus_2 = "Cannot find table in DB : " + _table_1;
            this.error(_plus_2, (EStructuralFeature)ProcessorMetaPackage.Literals.TABLE_DEFINITION_MODEL__TABLE);
        }
    }

    @Check
    public void checkProcedureDefinition(ProcedureDefinitionModel procedureDefinition) {
        String _table;
        boolean _checkProcedure;
        boolean _not;
        boolean _skipVerification = CommonUtils.skipVerification(procedureDefinition, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(procedureDefinition);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<ProcedureDefinitionModel> _procedures = artifacts.getProcedures();
        for (ProcedureDefinitionModel procedure : _procedures) {
            String _name_1;
            String _name;
            boolean _equals_1;
            boolean _notEquals;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)procedure, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean bl2 = _and = procedure != procedureDefinition;
            }
            if (!_and || !(_equals_1 = (_name = procedureDefinition.getName()).equals(_name_1 = procedure.getName()))) continue;
            String _name_2 = procedureDefinition.getName();
            String _plus = "Duplicate name : " + _name_2;
            String _plus_1 = String.valueOf(_plus) + "[procedure]";
            this.error(_plus_1, (EStructuralFeature)ProcessorMetaPackage.Literals.PROCEDURE_DEFINITION_MODEL__NAME);
            return;
        }
        boolean _and_1 = false;
        boolean _isResolveDb = this.isResolveDb(procedureDefinition);
        _and_1 = !_isResolveDb ? false : (_not = !(_checkProcedure = this.dbResolver.checkProcedure(procedureDefinition, _table = procedureDefinition.getTable())));
        if (_and_1) {
            String _table_1 = procedureDefinition.getTable();
            String _plus_2 = "Cannot find procedure in DB : " + _table_1;
            this.error(_plus_2, (EStructuralFeature)ProcessorMetaPackage.Literals.PROCEDURE_DEFINITION_MODEL__NAME);
        }
    }

    @Check
    public void checkFunctionDefinition(FunctionDefinitionModel functionDefinition) {
        boolean _skipVerification = CommonUtils.skipVerification(functionDefinition, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        Artifacts artifacts = this.getArtifacts(functionDefinition);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        EList<FunctionDefinitionModel> _functions = artifacts.getFunctions();
        for (FunctionDefinitionModel function : _functions) {
            String _name_1;
            String _name;
            boolean _equals_1;
            boolean _notEquals;
            boolean _and = false;
            boolean bl = _notEquals = !Objects.equal((Object)function, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean bl2 = _and = function != functionDefinition;
            }
            if (!_and || !(_equals_1 = (_name = functionDefinition.getName()).equals(_name_1 = function.getName()))) continue;
            String _name_2 = functionDefinition.getName();
            String _plus = "Duplicate name : " + _name_2;
            String _plus_1 = String.valueOf(_plus) + "[function]";
            this.error(_plus_1, (EStructuralFeature)ProcessorMetaPackage.Literals.FUNCTION_DEFINITION_MODEL__NAME);
            return;
        }
    }

    public void _checkDatabaseTable(DatabaseTable databaseTable) {
        boolean _checkTable;
        boolean _not_1;
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(databaseTable);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            return;
        }
        boolean _skipVerification = CommonUtils.skipVerification(databaseTable, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        MetaStatement statement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)databaseTable, MetaStatement.class);
        final Artifacts artifacts = this.getArtifacts(statement);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        final String tableName = databaseTable.getName();
        List<String> _tokensFromModifier = Utils.getTokensFromModifier(statement, "tab");
        Functions.Function1<String, TableDefinition> _function = new Functions.Function1<String, TableDefinition>(){

            public TableDefinition apply(String value) {
                Map<String, TableDefinition> _modelTables = ProcessorMetaValidator.this.modelProperty.getModelTables(artifacts);
                return _modelTables.get(value);
            }
        };
        List tableDefinitions = ListExtensions.map(_tokensFromModifier, (Functions.Function1)_function);
        Functions.Function1<TableDefinition, Boolean> _function_1 = new Functions.Function1<TableDefinition, Boolean>(){

            public Boolean apply(TableDefinition it) {
                String _table = it.getTable();
                return Objects.equal((Object)_table, (Object)tableName);
            }
        };
        TableDefinition tableDefinition = (TableDefinition)IterableExtensions.findFirst((Iterable)tableDefinitions, (Functions.Function1)_function_1);
        boolean _or = false;
        boolean _equals_1 = Objects.equal((Object)tableDefinition, null);
        _or = _equals_1 ? true : (_not_1 = !(_checkTable = this.dbResolver.checkTable(databaseTable, tableName)));
        if (_or) {
            this.error("Cannot find table in DB : " + tableName, (EStructuralFeature)ProcessorMetaPackage.Literals.DATABASE_TABLE__NAME);
        }
    }

    public void _checkDatabaseColumn(DatabaseColumn databaseColumn) {
        boolean _checkColumn;
        boolean _not_1;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        boolean _isResolveDb = this.isResolveDb(databaseColumn);
        boolean bl = _not = !_isResolveDb;
        if (_not) {
            return;
        }
        boolean _skipVerification = CommonUtils.skipVerification(databaseColumn, this.modelProperty);
        if (_skipVerification) {
            return;
        }
        String prefix = databaseColumn.getName();
        String columnName = null;
        int pos = prefix.indexOf(".");
        if (pos > 0) {
            String _substring_1;
            String _substring;
            String _name = databaseColumn.getName();
            prefix = _substring = _name.substring(0, pos);
            String _name_1 = databaseColumn.getName();
            columnName = _substring_1 = _name_1.substring(pos + 1);
        } else {
            String _name_2;
            prefix = null;
            columnName = _name_2 = databaseColumn.getName();
        }
        MetaStatement statement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)databaseColumn, MetaStatement.class);
        Artifacts artifacts = this.getArtifacts(statement);
        boolean _equals = Objects.equal((Object)artifacts, null);
        if (_equals) {
            return;
        }
        String value = Utils.getTokenFromModifier(statement, "tab", prefix);
        TableDefinition _xifexpression = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)value, null);
        if (_notEquals) {
            Map<String, TableDefinition> _modelTables = this.modelProperty.getModelTables(artifacts);
            _xifexpression = _modelTables.get(value);
        }
        TableDefinition tableDefinition = _xifexpression;
        String _xifexpression_1 = null;
        boolean bl3 = _notEquals_1 = !Objects.equal(tableDefinition, null);
        if (_notEquals_1) {
            _xifexpression_1 = tableDefinition.getTable();
        }
        String tableName = _xifexpression_1;
        boolean _or = false;
        boolean _equals_1 = Objects.equal((Object)tableName, null);
        _or = _equals_1 ? true : (_not_1 = !(_checkColumn = this.dbResolver.checkColumn(databaseColumn, tableName, columnName)));
        if (_or) {
            String _name_3 = databaseColumn.getName();
            String _plus = "Cannot find column in DB : " + _name_3;
            String _plus_1 = String.valueOf(_plus) + "[";
            String _plus_2 = String.valueOf(_plus_1) + tableName;
            String _plus_3 = String.valueOf(_plus_2) + "]";
            this.error(_plus_3, (EStructuralFeature)ProcessorMetaPackage.Literals.DATABASE_COLUMN__NAME);
        }
    }

    public Artifacts getArtifacts(EObject model) {
        EObject root = EcoreUtil.getRootContainer((EObject)model);
        if (!(root instanceof Artifacts)) {
            return null;
        }
        return (Artifacts)root;
    }

    public boolean isPrimitive(Class<?> clazz) {
        boolean _equals = Objects.equal(clazz, null);
        if (_equals) {
            return true;
        }
        boolean _equals_1 = Objects.equal(clazz, String.class);
        if (_equals_1) {
            return true;
        }
        boolean _equals_2 = Objects.equal(clazz, Byte.class);
        if (_equals_2) {
            return true;
        }
        boolean _equals_3 = Objects.equal(clazz, Short.class);
        if (_equals_3) {
            return true;
        }
        boolean _equals_4 = Objects.equal(clazz, Integer.class);
        if (_equals_4) {
            return true;
        }
        boolean _equals_5 = Objects.equal(clazz, Long.class);
        if (_equals_5) {
            return true;
        }
        boolean _equals_6 = Objects.equal(clazz, Double.class);
        if (_equals_6) {
            return true;
        }
        boolean _equals_7 = Objects.equal(clazz, Float.class);
        if (_equals_7) {
            return true;
        }
        boolean _equals_8 = Objects.equal(clazz, Boolean.class);
        if (_equals_8) {
            return true;
        }
        boolean _equals_9 = Objects.equal(clazz, java.util.Date.class);
        if (_equals_9) {
            return true;
        }
        boolean _equals_10 = Objects.equal(clazz, Date.class);
        if (_equals_10) {
            return true;
        }
        boolean _equals_11 = Objects.equal(clazz, Time.class);
        if (_equals_11) {
            return true;
        }
        boolean _equals_12 = Objects.equal(clazz, Timestamp.class);
        if (_equals_12) {
            return true;
        }
        boolean _equals_13 = Objects.equal(clazz, Blob.class);
        if (_equals_13) {
            return true;
        }
        boolean _equals_14 = Objects.equal(clazz, Clob.class);
        if (_equals_14) {
            return true;
        }
        boolean _equals_15 = Objects.equal(clazz, BigDecimal.class);
        if (_equals_15) {
            return true;
        }
        boolean _equals_16 = Objects.equal(clazz, BigInteger.class);
        return _equals_16;
    }

    public boolean isPrimitive(String name) {
        boolean _equals = Objects.equal((Object)name, null);
        if (_equals) {
            return true;
        }
        boolean _equals_1 = Objects.equal((Object)name, (Object)"java.lang.String");
        if (_equals_1) {
            return true;
        }
        boolean _equals_2 = Objects.equal((Object)name, (Object)"java.lang.Byte");
        if (_equals_2) {
            return true;
        }
        boolean _equals_3 = Objects.equal((Object)name, (Object)"java.lang.Short");
        if (_equals_3) {
            return true;
        }
        boolean _equals_4 = Objects.equal((Object)name, (Object)"java.lang.Integer");
        if (_equals_4) {
            return true;
        }
        boolean _equals_5 = Objects.equal((Object)name, (Object)"java.lang.Long");
        if (_equals_5) {
            return true;
        }
        boolean _equals_6 = Objects.equal((Object)name, (Object)"java.lang.Double");
        if (_equals_6) {
            return true;
        }
        boolean _equals_7 = Objects.equal((Object)name, (Object)"java.lang.Float");
        if (_equals_7) {
            return true;
        }
        boolean _equals_8 = Objects.equal((Object)name, (Object)"java.lang.Boolean");
        if (_equals_8) {
            return true;
        }
        boolean _equals_9 = Objects.equal((Object)name, (Object)"java.util.Date");
        if (_equals_9) {
            return true;
        }
        boolean _equals_10 = Objects.equal((Object)name, (Object)"java.sql.Date");
        if (_equals_10) {
            return true;
        }
        boolean _equals_11 = Objects.equal((Object)name, (Object)"java.sql.Time");
        if (_equals_11) {
            return true;
        }
        boolean _equals_12 = Objects.equal((Object)name, (Object)"java.sql.Timestamp");
        if (_equals_12) {
            return true;
        }
        boolean _equals_13 = Objects.equal((Object)name, (Object)"java.sql.Blob");
        if (_equals_13) {
            return true;
        }
        boolean _equals_14 = Objects.equal((Object)name, (Object)"java.sql.Clob");
        if (_equals_14) {
            return true;
        }
        boolean _equals_15 = Objects.equal((Object)name, (Object)"java.math.BigDecimal");
        if (_equals_15) {
            return true;
        }
        boolean _equals_16 = Objects.equal((Object)name, (Object)"java.math.BigInteger");
        return _equals_16;
    }

    public boolean isResolvePojo(EObject model) {
        return this.modelProperty.isDoResolvePojo(model);
    }

    public boolean isResolveDb(EObject model) {
        return this.dbResolver.isResolveDb(model);
    }
}

