/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.meta.generator;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.validation.IResourceValidator;
import org.sqlproc.meta.ProcessorMetaStandaloneSetup;
import org.sqlproc.meta.generator.TableMetaGenerator;
import org.sqlproc.meta.processorMeta.Artifacts;
import org.sqlproc.meta.processorMeta.MetaStatement;
import org.sqlproc.meta.property.ModelPropertyBean;
import org.sqlproc.plugin.lib.property.ModelProperty;
import org.sqlproc.plugin.lib.resolver.DbResolver;
import org.sqlproc.plugin.lib.resolver.PojoResolverFactory;
import org.sqlproc.plugin.lib.resolver.StandalonePojoResolverImpl;
import org.sqlproc.plugin.lib.util.MainUtils;
import org.sqlproc.plugin.lib.util.Stats;

public class Main {
    @Inject
    private PojoResolverFactory pojoResolverFactory;
    @Inject
    private Provider<ResourceSet> resourceSetProvider;
    @Inject
    private IResourceValidator validator;
    @Inject
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    IScopeProvider scopeProvider;
    @Inject
    private IResourceFactory resourceFactory;
    @Inject
    private ModelProperty modelProperty;
    @Inject
    private DbResolver dbResolver;

    public static void main(String[] args) throws IOException, ClassNotFoundException, ParseException {
        Options options = new Options();
        options.addOption("target", true, "target directory (eg. src-gen)");
        options.addOption("source", true, "source directory (eg. src/main/resources)");
        options.addOption("control", true, "control directives file name (eg. definitions.meta)");
        options.addOption("sql", true, "META SQLs file name to generate (eg. statements.meta)");
        options.addOption("metas", true, "META SQLs file names to verify (eg. statements.meta,custom-statements.meta)");
        options.addOption("ddl", true, "DDLs file name (eg. hsqldb.ddl)");
        options.addOption("nomerge", false, "do not merge generated artefacts with existing ones");
        options.addOption("verify", false, "do not generate META SQLs, only verify existing ones");
        options.addOption("skipdb", false, "in the verification process skip database control");
        options.addOption("debug", false, "DEBUG output");
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        String target = cmd.getOptionValue("target");
        String source = cmd.getOptionValue("source");
        String control = cmd.getOptionValue("control");
        String sql = cmd.getOptionValue("sql");
        String metas = cmd.getOptionValue("metas");
        String ddl = cmd.getOptionValue("ddl");
        boolean nomerge = cmd.hasOption("nomerge");
        boolean verify = cmd.hasOption("verify");
        boolean skipdb = cmd.hasOption("skipdb");
        boolean debug = cmd.hasOption("debug");
        if (debug) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < args.length) {
                sb.append(args[i]).append(" ");
                ++i;
            }
            System.out.println(sb);
        }
        if (verify) {
            if (control == null || metas == null) {
                Main.usage(options);
            }
        } else if (control == null || sql == null) {
            Main.usage(options);
        }
        Injector injector = new ProcessorMetaStandaloneSetup().createInjectorAndDoEMFRegistration();
        Main main = (Main)injector.getInstance(Main.class);
        if (target == null) {
            target = "./";
        } else if (!target.endsWith("/")) {
            target = String.valueOf(target) + "/";
        }
        if (source == null) {
            source = "";
        } else if (!source.endsWith("/")) {
            source = String.valueOf(source) + "/";
        }
        if (verify) {
            main.verify(control, metas, source, skipdb, ddl);
        } else {
            main.generate(control, sql, ddl, source, target, !nomerge);
        }
    }

    private static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String header = "META SQL models generation using control directives";
        String footer = "";
        formatter.printHelp("java -jar sqlmeta.jar", header, options, footer);
        System.exit(1);
    }

    protected void verify(String control, String metas, String source, boolean skipdb, String ddl) throws IOException, ClassNotFoundException {
        this.pojoResolverFactory.setPojoResolver(new StandalonePojoResolverImpl(source));
        ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
        Resource controlResource = resourceSet.getResource(URI.createURI((String)MainUtils.getFile(source, control)), true);
        resourceSet.getResources().add((Object)controlResource);
        String[] sqls = metas.split(",");
        ArrayList<Resource> sqlResources = new ArrayList<Resource>();
        String[] stringArray = sqls;
        int n = sqls.length;
        int n2 = 0;
        while (n2 < n) {
            String sql = stringArray[n2];
            Resource sqlResource = resourceSet.getResource(URI.createURI((String)MainUtils.getFile(source, sql)), true);
            resourceSet.getResources().add((Object)sqlResource);
            sqlResources.add(sqlResource);
            ++n2;
        }
        System.out.println("Going to validate " + controlResource);
        HashSet<String> failedReferences = new HashSet<String>();
        int controlResourceIsOk = MainUtils.isValid(controlResource, failedReferences, this.validator);
        if (controlResourceIsOk != 0) {
            System.exit(2);
        }
        System.out.println("Validated " + controlResource);
        if (!skipdb) {
            Artifacts definitions = (Artifacts)controlResource.getContents().get(0);
            if (definitions.getProperties().isEmpty()) {
                System.err.println("No control directive.");
                System.exit(3);
            }
            ModelProperty.ModelValues modelValues = ModelPropertyBean.loadModel(null, definitions);
            modelValues.doResolveDb = true;
            this.modelProperty.init(modelValues);
            String dbSqlsBefore = MainUtils.loadDdl(source, ddl);
            this.dbResolver.init(this.modelProperty, null, dbSqlsBefore, null);
        }
        for (Resource sqlResource : sqlResources) {
            System.out.println("Going to validate " + sqlResource);
            int sqlResourceIsOk = MainUtils.isValid(sqlResource, null, this.validator);
            if (sqlResourceIsOk != 0) {
                System.exit(2);
            }
            System.out.println("Validated " + sqlResource);
        }
    }

    protected void generate(String control, String sql, String ddl, String source, String target, boolean merge) throws IOException, ClassNotFoundException {
        this.pojoResolverFactory.setPojoResolver(new StandalonePojoResolverImpl(source));
        ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
        Resource controlResource = resourceSet.getResource(URI.createURI((String)MainUtils.getFile(source, control)), true);
        resourceSet.getResources().add((Object)controlResource);
        System.out.println("Going to validate " + controlResource);
        HashSet<String> failedReferences = new HashSet<String>();
        int controlResourceIsOk = MainUtils.isValid(controlResource, failedReferences, this.validator);
        if (controlResourceIsOk == 1) {
            System.exit(2);
        } else if (controlResourceIsOk == 2) {
            String controlResourceContent = MainUtils.handleResourceReferences(controlResource, failedReferences);
            System.out.println(controlResourceContent);
            controlResource = MainUtils.reloadResourceFromString(controlResourceContent, resourceSet, this.resourceFactory, "meta");
            controlResourceIsOk = MainUtils.isValid(controlResource, failedReferences, this.validator);
            if (controlResourceIsOk != 0) {
                System.exit(2);
            }
        }
        System.out.println("Validated " + controlResource);
        Artifacts definitions = (Artifacts)controlResource.getContents().get(0);
        if (definitions.getProperties().isEmpty()) {
            System.err.println("No control directive.");
            System.exit(3);
        }
        ModelProperty.ModelValues modelValues = ModelPropertyBean.loadModel(null, definitions);
        modelValues.doResolveDb = true;
        this.modelProperty.init(modelValues);
        String dbSqlsBefore = MainUtils.loadDdl(source, ddl);
        this.dbResolver.init(this.modelProperty, null, dbSqlsBefore, null);
        Resource sqlResource = null;
        if (merge) {
            try {
                sqlResource = resourceSet.getResource(URI.createURI((String)MainUtils.getFile(source, sql)), true);
                resourceSet.getResources().add((Object)sqlResource);
            }
            catch (Exception exception) {
                System.out.println("Can't read " + MainUtils.getFile(source, sql));
            }
        }
        if (merge && sqlResource != null) {
            System.out.println("Going to validate " + sqlResource);
            int sqlResourceIsOk = MainUtils.isValid(sqlResource, null, this.validator);
            if (sqlResourceIsOk != 0) {
                System.exit(2);
            }
            System.out.println("Validated " + sqlResource);
        }
        Artifacts sqls = null;
        ArrayList<MetaStatement> statements = null;
        if (!merge) {
            statements = new ArrayList<MetaStatement>();
        } else if (sqlResource != null) {
            sqls = (Artifacts)sqlResource.getContents().get(0);
            statements = sqls.getStatements();
        }
        this.fileAccess.setOutputPath(target);
        System.out.println("Going to generate " + sql);
        Stats stats = new Stats();
        String metaDefinitions = TableMetaGenerator.generateMeta(definitions, statements, ((XtextResource)controlResource).getSerializer(), this.dbResolver, this.scopeProvider, this.modelProperty, stats);
        this.fileAccess.generateFile(sql, (CharSequence)metaDefinitions);
        System.out.println(String.valueOf(sql) + " generation finished.");
        System.out.println(stats.toString());
    }
}

