/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.ui.syntaxcoloring;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.nodemodel.util.NodeTreeIterator;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.sqlproc.dsl.processorDsl.Constant;
import org.sqlproc.dsl.processorDsl.DaoDirective;
import org.sqlproc.dsl.processorDsl.DaoDirectiveCrud;
import org.sqlproc.dsl.processorDsl.DaoDirectiveDiscriminator;
import org.sqlproc.dsl.processorDsl.DaoDirectiveParameters;
import org.sqlproc.dsl.processorDsl.DaoDirectiveQuery;
import org.sqlproc.dsl.processorDsl.DatabaseColumn;
import org.sqlproc.dsl.processorDsl.DatabaseTable;
import org.sqlproc.dsl.processorDsl.DescendantAssignment;
import org.sqlproc.dsl.processorDsl.Entity;
import org.sqlproc.dsl.processorDsl.EnumEntity;
import org.sqlproc.dsl.processorDsl.EnumProperty;
import org.sqlproc.dsl.processorDsl.ExtendedColumn;
import org.sqlproc.dsl.processorDsl.ExtendedMappingItem;
import org.sqlproc.dsl.processorDsl.Extends;
import org.sqlproc.dsl.processorDsl.FunProcDirective;
import org.sqlproc.dsl.processorDsl.FunctionDefinition;
import org.sqlproc.dsl.processorDsl.Identifier;
import org.sqlproc.dsl.processorDsl.Implements;
import org.sqlproc.dsl.processorDsl.MappingItem;
import org.sqlproc.dsl.processorDsl.MappingRule;
import org.sqlproc.dsl.processorDsl.MetaStatement;
import org.sqlproc.dsl.processorDsl.OptionalFeature;
import org.sqlproc.dsl.processorDsl.Package;
import org.sqlproc.dsl.processorDsl.PojoDao;
import org.sqlproc.dsl.processorDsl.PojoDefinition;
import org.sqlproc.dsl.processorDsl.PojoDirective;
import org.sqlproc.dsl.processorDsl.PojoDirectiveEquals;
import org.sqlproc.dsl.processorDsl.PojoDirectiveHashCode;
import org.sqlproc.dsl.processorDsl.PojoDirectiveIndex;
import org.sqlproc.dsl.processorDsl.PojoDirectiveToString;
import org.sqlproc.dsl.processorDsl.PojoEntity;
import org.sqlproc.dsl.processorDsl.PojoEntityModifier2;
import org.sqlproc.dsl.processorDsl.PojoProperty;
import org.sqlproc.dsl.processorDsl.PojoType;
import org.sqlproc.dsl.processorDsl.ProcedureDefinition;
import org.sqlproc.dsl.processorDsl.TableDefinition;
import org.sqlproc.dsl.resolver.PojoResolver;
import org.sqlproc.dsl.resolver.PojoResolverFactory;
import org.sqlproc.dsl.util.Pair;

public class SemanticHighlightingCalculator
implements ISemanticHighlightingCalculator {
    public static final String CARET = "^";
    public static final String STRING = "$";
    public static final String LPAREN = "(";
    public static final String RPAREN = ")";
    @Inject
    PojoResolver pojoResolver;
    @Inject
    PojoResolverFactory pojoResolverFactory;

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        if (this.pojoResolverFactory != null && this.pojoResolverFactory.getPojoResolver() == null) {
            this.pojoResolverFactory.setPojoResolver(this.pojoResolver);
        }
        if (resource == null) {
            return;
        }
        TreeIterator iter = EcoreUtil.getAllContents((Resource)resource, (boolean)true);
        while (iter.hasNext()) {
            DaoDirective dir;
            ArrayList<Object> tokens;
            EObject current = (EObject)iter.next();
            ICompositeNode node = NodeModelUtils.getNode((EObject)current);
            if (current instanceof MetaStatement) {
                MetaStatement statement = (MetaStatement)current;
                if (statement.getName() == null) continue;
                acceptor.addPosition(node.getOffset(), statement.getName().length(), new String[]{"name"});
                this.provideHighlightingForModifiers((EList<String>)statement.getModifiers(), node, acceptor);
                continue;
            }
            if (current instanceof MappingRule) {
                MappingRule rule = (MappingRule)current;
                if (rule.getName() == null) continue;
                acceptor.addPosition(node.getOffset(), rule.getName().length(), new String[]{"name"});
                this.provideHighlightingForModifiers((EList<String>)rule.getModifiers(), node, acceptor);
                continue;
            }
            if (current instanceof OptionalFeature) {
                OptionalFeature feature = (OptionalFeature)current;
                if (feature.getName() == null) continue;
                acceptor.addPosition(node.getOffset(), feature.getName().length(), new String[]{"name"});
                this.provideHighlightingForModifiers((EList<String>)feature.getModifiers(), node, acceptor);
                continue;
            }
            if (current instanceof Constant) {
                Constant constant = (Constant)current;
                this.provideHighlightingForFragment("constant", node, constant.getName(), (EList<String>)constant.getModifiers(), acceptor);
                continue;
            }
            if (current instanceof Identifier) {
                Identifier identifier = (Identifier)current;
                this.provideHighlightingForFragment("identifier", node, identifier.getName(), (EList<String>)identifier.getModifiers(), acceptor);
                continue;
            }
            if (current instanceof ExtendedColumn) {
                ExtendedColumn column = (ExtendedColumn)current;
                this.provideHighlightingForFragment("column", node, column.getCol().getName(), (EList<String>)column.getModifiers(), acceptor);
                continue;
            }
            if (current instanceof MappingItem) {
                MappingItem item = (MappingItem)current;
                if (item.getName() == null) continue;
                acceptor.addPosition(node.getOffset(), item.getName().length(), new String[]{"column"});
                continue;
            }
            if (current instanceof ExtendedMappingItem) {
                ExtendedMappingItem mappingItem = (ExtendedMappingItem)current;
                this.provideHighlightingForFragment("column", node, mappingItem.getAttr().getName(), (EList<String>)mappingItem.getModifiers(), acceptor);
                continue;
            }
            if (current instanceof DatabaseColumn) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"dbcolumn"});
                continue;
            }
            if (current instanceof DatabaseTable) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"dbtable"});
                continue;
            }
            if (current instanceof PojoDefinition) {
                PojoDefinition pojo = (PojoDefinition)current;
                this.provideHighlightingForPojo(null, pojo.getName(), node, acceptor);
                continue;
            }
            if (current instanceof TableDefinition) {
                TableDefinition table = (TableDefinition)current;
                this.provideHighlightingForTable(null, table.getName(), node, acceptor);
                continue;
            }
            if (current instanceof ProcedureDefinition) {
                ProcedureDefinition procedure = (ProcedureDefinition)current;
                this.provideHighlightingForTable(null, procedure.getName(), node, acceptor);
                continue;
            }
            if (current instanceof FunctionDefinition) {
                FunctionDefinition function = (FunctionDefinition)current;
                this.provideHighlightingForTable(null, function.getName(), node, acceptor);
                continue;
            }
            if (current instanceof Package) {
                this.provideSimpleHighlighting(node, acceptor, this.newPair(((Package)current).getName(), "packageName"));
                continue;
            }
            if (current instanceof PojoEntity) {
                tokens = new ArrayList<Pair<String, String>>();
                PojoEntity pojo = (PojoEntity)current;
                if (pojo.getName() != null) {
                    tokens.add(this.newPair(pojo.getName(), "entityName"));
                }
                if (pojo.getDirectives() != null && !pojo.getDirectives().isEmpty()) {
                    for (PojoEntityModifier2 mod : pojo.getModifiers2()) {
                        if (mod.getSuperType() == null || mod.getSuperType().getName() == null) continue;
                        tokens.add(this.newPair(mod.getSuperType().getName(), "entityName"));
                    }
                }
                this.provideSimpleHighlighting(node, acceptor, tokens);
                continue;
            }
            if (current instanceof PojoProperty) {
                this.provideSimpleHighlighting(node, acceptor, this.newPair((PojoProperty)current, "propertyName", "entityName"));
                continue;
            }
            if (current instanceof EnumEntity) {
                this.provideSimpleHighlighting(node, acceptor, this.newPair(((EnumEntity)current).getName(), "entityName"));
                continue;
            }
            if (current instanceof EnumProperty) {
                this.provideSimpleHighlighting(node, acceptor, this.newPair(((EnumProperty)current).getName(), "propertyName"));
                continue;
            }
            if (current instanceof PojoDao) {
                this.provideSimpleHighlighting(node, acceptor, this.newPair(((PojoDao)current).getName(), "daoName"));
                continue;
            }
            if (current instanceof DaoDirective) {
                tokens = new ArrayList();
                dir = (DaoDirective)current;
                if (dir instanceof DaoDirectiveCrud) {
                    tokens.addAll(this.newPair(((DaoDirectiveCrud)dir).getPojo(), "entityName"));
                    this.provideSimpleHighlighting(node, acceptor, tokens);
                } else if (dir instanceof DaoDirectiveQuery) {
                    tokens.addAll(this.newPair(((DaoDirectiveQuery)dir).getPojo(), "entityName"));
                } else if (dir instanceof DaoDirectiveDiscriminator) {
                    tokens.add(new Pair((Object)((DaoDirectiveDiscriminator)dir).getAncestor().getName(), (Object)"propertyName"));
                    for (DescendantAssignment da : ((DaoDirectiveDiscriminator)dir).getDescendants()) {
                        tokens.addAll(this.newPair(da.getDescendant(), "entityName"));
                    }
                } else if (dir instanceof FunProcDirective) {
                    DaoDirectiveParameters dp = ((FunProcDirective)current).getParamlist();
                    tokens.addAll(this.newPair(dp.getOut(), "entityName"));
                    for (PojoType pojo : dp.getIns()) {
                        tokens.addAll(this.newPair(pojo, "entityName"));
                    }
                }
                this.provideSimpleHighlighting(node, acceptor, tokens);
                continue;
            }
            if (current instanceof PojoDirective) {
                tokens = new ArrayList();
                dir = (PojoDirective)current;
                if (dir instanceof PojoDirectiveToString) {
                    for (PojoProperty prop : ((PojoDirectiveToString)dir).getProplist().getFeatures()) {
                        tokens.add(new Pair((Object)prop.getName(), (Object)"propertyName"));
                    }
                } else if (dir instanceof PojoDirectiveIndex) {
                    for (PojoProperty prop : ((PojoDirectiveIndex)dir).getProplist().getFeatures()) {
                        tokens.add(new Pair((Object)prop.getName(), (Object)"propertyName"));
                    }
                } else if (dir instanceof PojoDirectiveEquals) {
                    for (PojoProperty prop : ((PojoDirectiveEquals)dir).getProplist().getFeatures()) {
                        tokens.add(new Pair((Object)prop.getName(), (Object)"propertyName"));
                    }
                } else if (dir instanceof PojoDirectiveHashCode) {
                    for (PojoProperty prop : ((PojoDirectiveHashCode)dir).getProplist().getFeatures()) {
                        tokens.add(new Pair((Object)prop.getName(), (Object)"propertyName"));
                    }
                }
                this.provideSimpleHighlighting(node, acceptor, tokens);
                continue;
            }
            if (current instanceof Implements) {
                tokens = new ArrayList();
                Implements imp = (Implements)current;
                for (PojoEntity pojo : imp.getOnlyPojos()) {
                    tokens.add(new Pair((Object)pojo.getName(), (Object)"entityName"));
                }
                for (PojoDao dao : imp.getOnlyDaos()) {
                    tokens.add(new Pair((Object)dao.getName(), (Object)"daoName"));
                }
                for (PojoEntity pojo : imp.getExceptPojos()) {
                    tokens.add(new Pair((Object)pojo.getName(), (Object)"entityName"));
                }
                for (PojoDao dao : imp.getExceptDaos()) {
                    tokens.add(new Pair((Object)dao.getName(), (Object)"daoName"));
                }
                this.provideSimpleHighlighting(node, acceptor, tokens);
                continue;
            }
            if (!(current instanceof Extends)) continue;
            tokens = new ArrayList();
            Extends ext = (Extends)current;
            for (PojoEntity pojo : ext.getOnlyPojos()) {
                tokens.add(new Pair((Object)pojo.getName(), (Object)"entityName"));
            }
            for (PojoDao dao : ext.getOnlyDaos()) {
                tokens.add(new Pair((Object)dao.getName(), (Object)"daoName"));
            }
            for (PojoEntity pojo : ext.getExceptPojos()) {
                tokens.add(new Pair((Object)pojo.getName(), (Object)"entityName"));
            }
            for (PojoDao dao : ext.getExceptDaos()) {
                tokens.add(new Pair((Object)dao.getName(), (Object)"daoName"));
            }
            this.provideSimpleHighlighting(node, acceptor, tokens);
        }
    }

    private Pair<String, String> newPair(String name, String highlightingId) {
        if (name != null) {
            return new Pair((Object)name, (Object)highlightingId);
        }
        return null;
    }

    private List<Pair<String, String>> newPair(PojoType pojo, String highlightingId) {
        String name2;
        String name1;
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        String string = name1 = pojo != null && pojo.getRef() != null ? pojo.getRef().getName() : null;
        if (name1 != null) {
            list.add(new Pair((Object)name1, (Object)highlightingId));
        }
        String string2 = name2 = pojo != null && pojo.getGref() != null ? pojo.getGref().getName() : null;
        if (name2 != null) {
            list.add((Pair<String, String>)new Pair((Object)name2, (Object)highlightingId));
        }
        return list;
    }

    private List<Pair<String, String>> newPair(PojoProperty prop, String highlightingId, String highlightingId2) {
        PojoEntity gref;
        Entity ref;
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        if (prop.getName() != null) {
            list.add(new Pair((Object)prop.getName(), (Object)highlightingId));
        }
        if ((ref = prop.getRef()) != null && (ref instanceof PojoEntity || ref instanceof EnumEntity)) {
            list.add((Pair<String, String>)new Pair((Object)ref.getName(), (Object)highlightingId2));
        }
        if ((gref = prop.getGref()) != null && (gref instanceof PojoEntity || gref instanceof EnumEntity)) {
            list.add((Pair<String, String>)new Pair((Object)gref.getName(), (Object)highlightingId2));
        }
        return list;
    }

    private void provideSimpleHighlighting(ICompositeNode node, IHighlightedPositionAcceptor acceptor, List<Pair<String, String>> tokens) {
        if (tokens == null || tokens.isEmpty()) {
            return;
        }
        int ix = 0;
        int lx = tokens.size();
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            int i = ix;
            while (i < lx) {
                if (this.equals((String)tokens.get(i).getFirst(), inode)) {
                    acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{(String)tokens.get(i).getSecond()});
                    if (i == lx - 1) {
                        return;
                    }
                    ix = i + 1;
                }
                ++i;
            }
        }
    }

    private void provideSimpleHighlighting(ICompositeNode node, IHighlightedPositionAcceptor acceptor, Pair<String, String> ... tokens) {
        if (tokens == null || tokens.length == 0) {
            return;
        }
        int ix = 0;
        int lx = tokens.length;
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            int i = ix;
            while (i < lx) {
                if (this.equals((String)tokens[i].getFirst(), inode)) {
                    acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{(String)tokens[i].getSecond()});
                    if (i == lx - 1) {
                        return;
                    }
                    ix = i + 1;
                }
                ++i;
            }
        }
    }

    private void provideHighlightingForModifiers(EList<String> filters, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (filters != null && !filters.isEmpty()) {
            NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
            while (iterator.hasNext()) {
                INode inode = (INode)iterator.next();
                if (!filters.contains((Object)inode.getText())) continue;
                acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"statementModifier"});
            }
        }
    }

    private void provideHighlightingForPojo(String name, String pojo, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (name == null && pojo == null) {
            return;
        }
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (this.equals(name, inode)) {
                acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"name"});
                if (pojo == null) {
                    return;
                }
            }
            if (!this.equals(pojo, inode)) continue;
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"identifier"});
            return;
        }
    }

    private void provideHighlightingForTable(String name, String table, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (name == null && table == null) {
            return;
        }
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (this.equals(name, inode)) {
                acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"name"});
                if (table == null) {
                    return;
                }
            }
            if (!this.equals(table, inode)) continue;
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"identifier"});
            return;
        }
    }

    private void provideHighlightingForFragment(String defaultColor, ICompositeNode node, String name, EList<String> modifiers, IHighlightedPositionAcceptor acceptor) {
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        boolean afterName = false;
        boolean inParenthesis = false;
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (!afterName) {
                if (!this.equals(name, inode)) continue;
                acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{defaultColor});
                afterName = true;
                continue;
            }
            if (!inParenthesis && inode.getText().equals(LPAREN)) {
                inParenthesis = true;
                continue;
            }
            if (inParenthesis && inode.getText().equals(RPAREN)) {
                inParenthesis = false;
                continue;
            }
            if (inParenthesis) {
                if (modifiers == null || modifiers.isEmpty() || !modifiers.contains((Object)inode.getText())) continue;
                acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"modifier"});
                continue;
            }
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{defaultColor});
        }
    }

    private boolean equals(String name, INode inode) {
        if (name == null || inode == null) {
            return false;
        }
        String text = inode.getText();
        if (text == null) {
            return false;
        }
        return name.equals(text.trim());
    }
}

