/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.ui.templates;

import com.google.inject.Inject;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ITemplateAcceptor;
import org.eclipse.xtext.ui.editor.templates.ContextTypeIdHelper;
import org.eclipse.xtext.ui.editor.templates.DefaultTemplateProposalProvider;
import org.sqlproc.dsl.services.ProcessorDslGrammarAccess;

public class ProcessorTemplateProposalProvider
extends DefaultTemplateProposalProvider {
    ContextTypeIdHelper helper;
    @Inject
    ProcessorDslGrammarAccess ga;
    static final String HSQLDB = "resolve-pojo-on;\ndatabase-is-online;\ndatabase-jdbc-driver :org.hsqldb.jdbcDriver;\ndatabase-has-url jdbc:hsqldb:mem:hsqldb;\ndatabase-login-username sa;\ndatabase-login-password \"\";\ndatabase-take-comments;\n\npojogen-generate-wrappers;\npojogen-generate-methods toString equals hashCode isDef toInit;\npojogen-implements-interfaces java.io.Serializable;\npojogen-generate-operators;\npojogen-generate-validation-annotations;\n\nmetagen-global-sequence TODO_SEQUENCE_NAME;\n";
    static final String POSTGRESQL = "resolve-pojo-on;\ndatabase-is-online;\ndatabase-jdbc-driver :org.postgresql.Driver;\ndatabase-has-url jdbc:postgresql:\\//TODO_DB_SERVER:5432/TODO_DB_NAME;\ndatabase-login-username TODO_DB_USER;\ndatabase-login-password TODO_DB_PASSWORD;\ndatabase-in-catalog TODO_DB_CATALOG;\ndatabase-take-comments;\n\npojogen-generate-wrappers;\npojogen-generate-methods toString equals hashCode isDef toInit;\npojogen-implements-interfaces java.io.Serializable;\npojogen-generate-operators;\npojogen-generate-validation-annotations;\n\nmetagen-table-sequence TODO_TABLE_X TODO_TABLE_X_id_seq;\n";
    static final String MYSQL = "resolve-pojo-on;\ndatabase-is-online;\ndatabase-jdbc-driver :com.mysql.jdbc.Driver;\ndatabase-has-url jdbc:mysql:\\//TODO_DB_SERVER:3306/TODO_DB_NAME?zeroDateTimeBehavior=convertToNull;\ndatabase-login-username TODO_DB_USER;\ndatabase-login-password TODO_DB_PASSWORD;\ndatabase-in-catalog TODO_DB_CATALOG;\ndatabase-take-comments;\n\npojogen-generate-wrappers;\npojogen-generate-methods toString equals hashCode isDef toInit;\npojogen-implements-interfaces java.io.Serializable;\npojogen-generate-operators;\npojogen-generate-validation-annotations;\n\nmetagen-global-identity;\n";
    static final String ORACLE = "resolve-pojo-on;\ndatabase-is-online;\ndatabase-jdbc-driver :oracle.jdbc.OracleDriver;\ndatabase-has-url jdbc:oracle:thin:@TODO_DB_SERVER:1521:TODO_SID;\ndatabase-login-username TODO_DB_USER;\ndatabase-login-password TODO_DB_PASSWORD;\ndatabase-active-schema TODO_DB_SCHEMA;\ndatabase-take-comments;\n\npojogen-generate-wrappers;\npojogen-generate-methods toString equals hashCode isDef toInit;\npojogen-implements-interfaces java.io.Serializable;\npojogen-generate-operators;\npojogen-generate-validation-annotations;\n\nmetagen-global-sequence TODO_SEQUENCE_NAME;\n";
    static final String DB2 = "resolve-pojo-on;\ndatabase-is-online;\ndatabase-jdbc-driver :com.ibm.db2.jcc.DB2Driver;\ndatabase-has-url jdbc:db2:\\//TODO_DB_SERVER:50001/TODO_DB_NAME:deferPrepares=0\\;progressiveStreaming=2\\;;\ndatabase-login-username TODO_DB_USER;\ndatabase-login-password TODO_DB_PASSWORD;\ndatabase-active-schema TODO_DB_SCHEMA;\ndatabase-take-comments;\n\npojogen-generate-wrappers;\npojogen-generate-methods toString equals hashCode isDef toInit;\npojogen-implements-interfaces java.io.Serializable;\npojogen-generate-operators;\npojogen-generate-validation-annotations;\n\nmetagen-global-sequence TODO_SEQUENCE_NAME;\n";
    static final String INFORMIX = "resolve-pojo-on;\ndatabase-is-online;\ndatabase-jdbc-driver :com.informix.jdbc.IfxDriver;\ndatabase-has-url jdbc:informix-sqli:\\//TODO_DB_SERVER:1551/TODO_DB_NAME:informixserver=TODO_IFX_NAME\\;DB_LOCALE=en_US\\.57372;\ndatabase-login-username TODO_DB_USER;\ndatabase-login-password TODO_DB_PASSWORD;\ndatabase-in-catalog TODO_DB_CATALOG;\ndatabase-take-comments;\n\npojogen-generate-wrappers;\npojogen-generate-methods toString equals hashCode isDef toInit;\npojogen-implements-interfaces java.io.Serializable;\npojogen-generate-operators;\npojogen-generate-validation-annotations;\n\nmetagen-global-sequence TODO_SEQUENCE_NAME;\n";

    @Inject
    public ProcessorTemplateProposalProvider(TemplateStore templateStore, ContextTypeRegistry registry, ContextTypeIdHelper helper) {
        super(templateStore, registry, helper);
        this.helper = helper;
    }

    protected boolean validate1(Template template, ContentAssistContext context) {
        boolean result = context.getMatcher().isCandidateMatchingPrefix(template.getName(), context.getPrefix());
        return result;
    }

    protected TemplateProposal createProposal1(Template template, TemplateContext templateContext, ContentAssistContext context, Image image, int relevance) {
        if (!this.validate1(template, context)) {
            return null;
        }
        return this.doCreateProposal(template, templateContext, context, image, relevance);
    }

    protected void createTemplates(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor) {
        TemplateProposal tp;
        Template template;
        super.createTemplates(templateContext, context, acceptor);
        if (templateContext.getContextType().getId().equals(this.helper.getId((AbstractRule)this.ga.getSqlValueRule()))) {
            template = new Template("ins", "CRUD insert statement", "insertTemplateID", "\n  insert into ${dbTable}\n  (${dbInsertColumn})\n  {= values (${pojoColumn}) }\n", false);
            tp = this.createProposal1(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("get", "CRUD get statement", "getTemplateID", "\n  select ${dbSelectColumn}\n  from ${dbTable}\n  {= where${dbCondColumn}\n  }\n", false);
            tp = this.createProposal1(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("upd", "CRUD update statement", "updateTemplateID", "\n  update ${dbTable}\n  {= set (${dbUpdateColumn})}\n  {= where${dbCondColumn}\n  }\n", false);
            tp = this.createProposal1(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("upd-opt", "CRUD optimistic update statement", "updateOptTemplateID", "\n  update ${dbTable}\n  {= set (${dbVerUpdateColumn}${dbOptUpdateColumn})}\n  {= where${dbOptCondColumn}\n  }\n", false);
            tp = this.createProposal1(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("del", "CRUD delete statement", "deleteTemplateID", "\n  delete from ${dbTable}\n  {= where${dbCondColumn}\n  }\n", false);
            tp = this.createProposal1(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("select", "QRY select statement", "selectTemplateID", "\n  select ${dbSelectColumn}\n  from ${dbTable}\n  {= where${dbCondColumn}\n  }\n", false);
            tp = this.createProposal1(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
        }
        if (templateContext.getContextType().getId().equals(this.helper.getId((AbstractRule)this.ga.getOptionalFeatureRule()))) {
            template = new Template("pojos", "Pojos definitions", "pojosTemplateID", "${pojoDefinitions}", false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("tables", "Tables definitions", "uniqueTemplateID", "${tableDefinitions}", false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("metagen", "Meta SQL generator", "metagenTemplateID", "${metaGenerator}", false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("procedures", "Procedures definitions", "uniqueTemplateID", "${procedureDefinitions}", false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("functions", "Functions definitions", "uniqueTemplateID", "${functionDefinitions}", false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("hsqldb", "HSQLDB initial control directives", "uniqueTemplateID", HSQLDB, false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("postgresql", "PostgreSQL initial control directives", "uniqueTemplateID", POSTGRESQL, false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("mysql", "MySQL initial control directives", "uniqueTemplateID", MYSQL, false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("oracle", "Oracle initial control directives", "uniqueTemplateID", ORACLE, false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("db2", "DB2 initial control directives", "uniqueTemplateID", DB2, false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
            template = new Template("informix", "Informix initial control directives", "uniqueTemplateID", INFORMIX, false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
        }
        if (templateContext.getContextType().getId().equals(this.helper.getId((AbstractRule)this.ga.getAbstractPojoEntityRule()))) {
            template = new Template("pojogen", "Pojo generator", "pojogenTemplateID", "${pojoGenerator}", false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
        }
        if (templateContext.getContextType().getId().equals(this.helper.getId((AbstractRule)this.ga.getAbstractPojoEntityRule()))) {
            template = new Template("daogen", "DAO generator", "daogenTemplateID", "${daoGenerator}", false);
            tp = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
            acceptor.accept(tp);
        }
    }
}

