/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.ui.templates;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.templates.SimpleTemplateVariableResolver;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContext;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContextType;
import org.sqlproc.dsl.processorDsl.AbstractPojoEntity;
import org.sqlproc.dsl.processorDsl.AnnotatedEntity;
import org.sqlproc.dsl.processorDsl.Annotation;
import org.sqlproc.dsl.processorDsl.Artifacts;
import org.sqlproc.dsl.processorDsl.EnumEntity;
import org.sqlproc.dsl.processorDsl.MetaStatement;
import org.sqlproc.dsl.processorDsl.PackageDeclaration;
import org.sqlproc.dsl.processorDsl.PojoAnnotatedProperty;
import org.sqlproc.dsl.processorDsl.PojoDao;
import org.sqlproc.dsl.processorDsl.PojoEntity;
import org.sqlproc.dsl.processorDsl.ProcessorDslPackage;
import org.sqlproc.dsl.processorDsl.TableDefinition;
import org.sqlproc.dsl.property.ModelProperty;
import org.sqlproc.dsl.resolver.DbResolver;
import org.sqlproc.dsl.resolver.DbTable;
import org.sqlproc.dsl.resolver.PojoResolver;
import org.sqlproc.dsl.ui.templates.Annotations;
import org.sqlproc.dsl.ui.templates.TableDaoConverter;
import org.sqlproc.dsl.ui.templates.TableMetaConverter;
import org.sqlproc.dsl.ui.templates.TablePojoConverter;
import org.sqlproc.dsl.util.Utils;

public class ProcessorDslTemplateContextType
extends XtextTemplateContextType {
    @Inject
    PojoResolver pojoResolver;
    @Inject
    DbResolver dbResolver;
    @Inject
    IScopeProvider scopeProvider;
    @Inject
    ModelProperty modelProperty;

    protected void addDefaultTemplateVariables() {
        super.addDefaultTemplateVariables();
        super.addResolver((TemplateVariableResolver)new DbTableResolver());
        super.addResolver((TemplateVariableResolver)new PojoColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbSelectColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbInsertColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbUpdateColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbCondColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbVerUpdateColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbOptUpdateColumnResolver());
        super.addResolver((TemplateVariableResolver)new DbOptCondColumnResolver());
        super.addResolver((TemplateVariableResolver)new PojoDefinitionsResolver());
        super.addResolver((TemplateVariableResolver)new TablesDefinitionsResolver());
        super.addResolver((TemplateVariableResolver)new ProceduresDefinitionsResolver());
        super.addResolver((TemplateVariableResolver)new FunctionsDefinitionsResolver());
        super.addResolver((TemplateVariableResolver)new PojoGeneratorResolver());
        super.addResolver((TemplateVariableResolver)new MetaGeneratorResolver());
        super.addResolver((TemplateVariableResolver)new DaoGeneratorResolver());
    }

    protected Artifacts getArtifacts(XtextTemplateContext xtextTemplateContext) {
        if (xtextTemplateContext == null) {
            return null;
        }
        EObject object = xtextTemplateContext.getContentAssistContext().getCurrentModel();
        if (object == null) {
            return null;
        }
        return (Artifacts)EcoreUtil2.getContainerOfType((EObject)object, Artifacts.class);
    }

    protected MetaStatement getMetaStatement(XtextTemplateContext xtextTemplateContext) {
        if (xtextTemplateContext == null) {
            return null;
        }
        EObject object = xtextTemplateContext.getContentAssistContext().getCurrentModel();
        MetaStatement statement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)object, MetaStatement.class);
        return statement;
    }

    protected PackageDeclaration getPackage(XtextTemplateContext xtextTemplateContext) {
        if (xtextTemplateContext == null) {
            return null;
        }
        EObject object = xtextTemplateContext.getContentAssistContext().getCurrentModel();
        PackageDeclaration packagex = (PackageDeclaration)EcoreUtil2.getContainerOfType((EObject)object, PackageDeclaration.class);
        return packagex;
    }

    protected TableDefinition getTableDefinition(MetaStatement statement) {
        if (statement == null) {
            return null;
        }
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)statement, Artifacts.class);
        TableDefinition tableDefinition = null;
        List vals = Utils.getTokensFromModifier((MetaStatement)statement, (String)"tab");
        for (String val : vals) {
            tableDefinition = Utils.findTable(null, (Artifacts)artifacts, (IScope)this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__TABLES), (String)val);
            if (tableDefinition == null) continue;
            return tableDefinition;
        }
        return null;
    }

    protected String toCamelCase(String value) {
        if (value == null) {
            return null;
        }
        String[] parts = value.split("_");
        String camelCaseString = "";
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (camelCaseString.length() == 0) {
                camelCaseString = String.valueOf(camelCaseString) + part.toLowerCase();
            } else if (part.length() == 1) {
                camelCaseString = String.valueOf(camelCaseString) + part.toUpperCase();
            } else if (part.length() > 1) {
                camelCaseString = String.valueOf(camelCaseString) + part.substring(0, 1).toUpperCase() + part.substring(1).toLowerCase();
            }
            ++n2;
        }
        return camelCaseString;
    }

    protected String toCamelCase(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        String camelCaseString = clazz.getSimpleName();
        if (camelCaseString.length() == 1) {
            camelCaseString = camelCaseString.toLowerCase();
        } else if (camelCaseString.length() > 1) {
            camelCaseString = String.valueOf(camelCaseString.substring(0, 1).toLowerCase()) + camelCaseString.substring(1);
        }
        return camelCaseString;
    }

    protected String getPojoColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            builder.append(':').append(this.toCamelCase(columns.get(i)));
            if (i < columns.size() - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    protected String getSelectColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            builder.append("%" + columns.get(i)).append(" @").append(this.toCamelCase(columns.get(i)));
            if (i < columns.size() - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    protected String getInsertColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            builder.append("%" + columns.get(i));
            if (i < columns.size() - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    protected String getUpdateColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            builder.append("%" + columns.get(i)).append(" = :").append(this.toCamelCase(columns.get(i)));
            if (i < columns.size() - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    protected String getCondColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            builder.append("\n  {& ").append("%" + columns.get(i)).append(" = :").append(this.toCamelCase(columns.get(i))).append(" }");
            ++i;
        }
        return builder.toString();
    }

    protected String getVerUpdateColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            if (columns.get(i).toUpperCase().indexOf("VER") == 0) {
                builder.append("%" + columns.get(i)).append(" = :").append(this.toCamelCase(columns.get(i))).append(" + 1, ");
                break;
            }
            ++i;
        }
        return builder.toString();
    }

    protected String getOptUpdateColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        boolean idFind = false;
        boolean verFind = false;
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            if (!idFind && (columns.get(i).toUpperCase().equals("ID") || columns.get(i).toUpperCase().indexOf("ID_") == 0)) {
                idFind = true;
            } else if (!verFind && columns.get(i).toUpperCase().indexOf("VER") == 0) {
                verFind = true;
            } else {
                builder.append("%" + columns.get(i)).append(" = :").append(this.toCamelCase(columns.get(i)));
                if (i < columns.size() - 1) {
                    builder.append(", ");
                }
            }
            ++i;
        }
        return builder.toString();
    }

    protected String getOptCondColumns(List<String> columns) {
        if (columns == null) {
            return null;
        }
        boolean idFind = false;
        boolean verFind = false;
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < columns.size()) {
            if (!idFind && (columns.get(i).toUpperCase().equals("ID") || columns.get(i).toUpperCase().indexOf("ID_") == 0)) {
                idFind = true;
                builder.append("\n  {& ").append("%" + columns.get(i)).append(" = :").append(this.toCamelCase(columns.get(i))).append(" }");
            } else if (!verFind && columns.get(i).toUpperCase().indexOf("VER") == 0) {
                verFind = true;
                builder.append("\n  {& ").append("%" + columns.get(i)).append(" = :").append(this.toCamelCase(columns.get(i))).append(" }");
            }
            ++i;
        }
        return builder.toString();
    }

    protected String getPojoDefinitions(List<Class<?>> pojoClasses) {
        if (pojoClasses == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Class<?> clazz : pojoClasses) {
            map.put(this.toCamelCase(clazz), clazz.getName());
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry pojo : map.entrySet()) {
            builder.append("pojo ").append((String)pojo.getKey()).append(' ').append((String)pojo.getValue()).append(";\n");
        }
        return builder.toString();
    }

    protected String getTablesDefinitions(List<String> tables, List<String> tablesPresented) {
        if (tables == null) {
            return null;
        }
        HashSet<String> set = tablesPresented != null ? new HashSet<String>(tablesPresented) : new HashSet();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String table : tables) {
            if (table.toUpperCase().startsWith("BIN$") || set.contains(table)) continue;
            map.put(this.toCamelCase(table), table);
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry table : map.entrySet()) {
            builder.append("table ").append((String)table.getKey()).append(' ').append((String)table.getValue()).append(";\n");
        }
        return builder.toString();
    }

    protected String getProceduresDefinitions(List<String> procedures, List<String> proceduresPresented) {
        if (procedures == null) {
            return null;
        }
        HashSet<String> set = proceduresPresented != null ? new HashSet<String>(proceduresPresented) : new HashSet();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String procedure : procedures) {
            if (procedure.toUpperCase().startsWith("BIN$") || set.contains(procedure)) continue;
            map.put(this.toCamelCase(procedure), procedure);
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry procedure : map.entrySet()) {
            builder.append("procedure ").append((String)procedure.getKey()).append(' ').append((String)procedure.getValue()).append(";\n");
        }
        return builder.toString();
    }

    protected String getFunctionsDefinitions(List<String> functions, List<String> functionsPresented) {
        if (functions == null) {
            return null;
        }
        HashSet<String> set = functionsPresented != null ? new HashSet<String>(functionsPresented) : new HashSet();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String function : functions) {
            if (function.toUpperCase().startsWith("BIN$") || set.contains(function)) continue;
            map.put(this.toCamelCase(function), function);
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry function : map.entrySet()) {
            builder.append("function ").append((String)function.getKey()).append(' ').append((String)function.getValue()).append(";\n");
        }
        return builder.toString();
    }

    private DbResolver.DbType getDbType(Artifacts artifacts) {
        DbResolver.DbType[] dbTypes;
        DbResolver.DbType dbType = this.dbResolver.getDatabaseDirectives((EObject)artifacts).dbType;
        if (dbType == null && (dbTypes = DbResolver.DbType.fromDbMetaInfo((String)this.dbResolver.getDbMetaInfo((EObject)artifacts))) != null && dbTypes.length > 0) {
            dbType = dbTypes[0];
        }
        return dbType;
    }

    private void grabAnnotations(AnnotatedEntity apojo, PojoEntity pojo, Annotations as) {
        String pojoName = pojo.getName();
        as.addEntityAnnotations(pojoName, (List<Annotation>)apojo.getAnnotations());
        as.addConstructorAnnotations(pojoName, (List<Annotation>)apojo.getConstructorAnnotations());
        as.addStaticAnnotations(pojoName, (List<Annotation>)apojo.getStaticAnnotations());
        as.addConflictAnnotations(pojoName, (List<Annotation>)apojo.getConflictAnnotations());
        for (PojoAnnotatedProperty feature : pojo.getFeatures()) {
            if (feature.getFeature() == null) continue;
            if (feature.getAttributeAnnotations() != null) {
                as.addAttributeAnnotations(pojoName, feature.getFeature().getName(), (List<Annotation>)feature.getAttributeAnnotations());
            }
            if (feature.getSetterAnnotations() != null) {
                as.addSetterAnnotations(pojoName, feature.getFeature().getName(), (List<Annotation>)feature.getSetterAnnotations());
            }
            if (feature.getGetterAnnotations() == null) continue;
            as.addGetterAnnotations(pojoName, feature.getFeature().getName(), (List<Annotation>)feature.getGetterAnnotations());
        }
    }

    private String replaceAll(String buffer, Artifacts artifacts) {
        for (Map.Entry entry : this.modelProperty.getReplaceAll((EObject)artifacts).entrySet()) {
            String regex = (String)entry.getKey();
            String replacement = (String)entry.getValue();
            System.out.println("REGEX " + regex);
            System.out.println("REPLACEMENT " + replacement);
            buffer = buffer.replaceAll(regex, replacement);
        }
        return buffer;
    }

    protected boolean addDefinitions(TablePojoConverter converter, Artifacts artifacts) {
        List functions;
        List procedures;
        List tables;
        block9: {
            tables = Utils.findTables(null, (Artifacts)artifacts, (IScope)this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__TABLES));
            procedures = Utils.findProcedures(null, (Artifacts)artifacts, (IScope)this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__PROCEDURES));
            functions = Utils.findFunctions(null, (Artifacts)artifacts, (IScope)this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__FUNCTIONS));
            if (tables != null || procedures != null || functions != null) break block9;
            return false;
        }
        try {
            String comment;
            List ltables;
            if (tables != null) {
                for (String table : tables) {
                    List dbColumns;
                    if (table.toUpperCase().startsWith("BIN$") || !this.dbResolver.checkTable((EObject)artifacts, table) || (dbColumns = this.dbResolver.getDbColumns((EObject)artifacts, table)).isEmpty()) continue;
                    List dbPrimaryKeys = this.dbResolver.getDbPrimaryKeys((EObject)artifacts, table);
                    List dbExports = this.dbResolver.getDbExports((EObject)artifacts, table);
                    List dbImports = this.dbResolver.getDbImports((EObject)artifacts, table);
                    List dbIndexes = this.dbResolver.getDbIndexes((EObject)artifacts, table);
                    List ltables2 = this.dbResolver.getDbTables((EObject)artifacts, table);
                    String comment2 = ltables2 != null && !ltables2.isEmpty() ? ((DbTable)ltables2.get(0)).getComment() : null;
                    List dbCheckConstraints = this.dbResolver.getDbCheckConstraints((EObject)artifacts, table);
                    converter.addTableDefinition(table, dbColumns, dbPrimaryKeys, dbExports, dbImports, dbIndexes, dbCheckConstraints, comment2);
                }
                converter.resolveReferencesOnKeys();
                converter.joinTables();
            }
            if (procedures != null) {
                for (String procedure : procedures) {
                    List dbProcedures;
                    if (procedure.toUpperCase().startsWith("BIN$") || (dbProcedures = this.dbResolver.getDbProcedures((EObject)artifacts, procedure)).isEmpty()) continue;
                    List dbProcColumns = this.dbResolver.getDbProcColumns((EObject)artifacts, procedure);
                    ltables = this.dbResolver.getDbProcedures((EObject)artifacts, procedure);
                    comment = ltables != null && !ltables.isEmpty() ? ((DbTable)ltables.get(0)).getComment() : null;
                    converter.addProcedureDefinition(procedure, (DbTable)dbProcedures.get(0), dbProcColumns, functions.contains(procedure), comment);
                }
            }
            if (functions != null) {
                for (String function : functions) {
                    List dbFunctions;
                    if (function.toUpperCase().startsWith("BIN$") || (dbFunctions = this.dbResolver.getDbFunctions((EObject)artifacts, function)).isEmpty()) continue;
                    List dbFunColumns = this.dbResolver.getDbFunColumns((EObject)artifacts, function);
                    ltables = this.dbResolver.getDbFunctions((EObject)artifacts, function);
                    comment = ltables != null && !ltables.isEmpty() ? ((DbTable)ltables.get(0)).getComment() : null;
                    converter.addFunctionDefinition(function, (DbTable)dbFunctions.get(0), dbFunColumns, comment);
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public class DaoGeneratorResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "daoGenerator";

        public DaoGeneratorResolver() {
            super(NAME, "DaoGenerator");
        }

        protected String resolve(TemplateContext context) {
            Artifacts artifacts = ProcessorDslTemplateContextType.this.getArtifacts((XtextTemplateContext)context);
            PackageDeclaration packagex = ProcessorDslTemplateContextType.this.getPackage((XtextTemplateContext)context);
            if (artifacts != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)artifacts)) {
                DbResolver.DbType dbType;
                ArrayList<PojoDao> daosToRemove = new ArrayList<PojoDao>();
                HashSet<String> finalDaos = new HashSet<String>();
                String suffix = packagex.getSuffix();
                for (AbstractPojoEntity ape : packagex.getElements()) {
                    if (!(ape instanceof PojoDao)) continue;
                    PojoDao dao = (PojoDao)ape;
                    if (Utils.isFinal((PojoDao)dao)) {
                        finalDaos.add(dao.getName());
                        continue;
                    }
                    daosToRemove.add(dao);
                }
                List dbSequences = ProcessorDslTemplateContextType.this.dbResolver.getSequences((EObject)artifacts);
                TableDaoConverter converter = new TableDaoConverter(ProcessorDslTemplateContextType.this.modelProperty, artifacts, suffix, ProcessorDslTemplateContextType.this.scopeProvider, finalDaos, (List<String>)dbSequences, dbType = ProcessorDslTemplateContextType.this.getDbType(artifacts));
                if (ProcessorDslTemplateContextType.this.addDefinitions(converter, artifacts)) {
                    return ProcessorDslTemplateContextType.this.replaceAll(converter.getDaoDefinitions(), artifacts);
                }
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbCondColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbCondColumn";

        public DbCondColumnResolver() {
            super(NAME, "DbCondColumn");
        }

        protected String resolve(TemplateContext context) {
            TableDefinition tableDefinition = ProcessorDslTemplateContextType.this.getTableDefinition(ProcessorDslTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (tableDefinition != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)tableDefinition)) {
                List dbColumns = ProcessorDslTemplateContextType.this.dbResolver.getColumns((EObject)tableDefinition, tableDefinition.getTable());
                return ProcessorDslTemplateContextType.this.getCondColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbInsertColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbInsertColumn";

        public DbInsertColumnResolver() {
            super(NAME, "DbInsertColumn");
        }

        protected String resolve(TemplateContext context) {
            TableDefinition tableDefinition = ProcessorDslTemplateContextType.this.getTableDefinition(ProcessorDslTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (tableDefinition != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)tableDefinition)) {
                List dbColumns = ProcessorDslTemplateContextType.this.dbResolver.getColumns((EObject)tableDefinition, tableDefinition.getTable());
                return ProcessorDslTemplateContextType.this.getInsertColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbOptCondColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbOptCondColumn";

        public DbOptCondColumnResolver() {
            super(NAME, "DbOptCondColumn");
        }

        protected String resolve(TemplateContext context) {
            TableDefinition tableDefinition = ProcessorDslTemplateContextType.this.getTableDefinition(ProcessorDslTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (tableDefinition != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)tableDefinition)) {
                List dbColumns = ProcessorDslTemplateContextType.this.dbResolver.getColumns((EObject)tableDefinition, tableDefinition.getTable());
                return ProcessorDslTemplateContextType.this.getOptCondColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbOptUpdateColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbOptUpdateColumn";

        public DbOptUpdateColumnResolver() {
            super(NAME, "DbOptUpdateColumn");
        }

        protected String resolve(TemplateContext context) {
            TableDefinition tableDefinition = ProcessorDslTemplateContextType.this.getTableDefinition(ProcessorDslTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (tableDefinition != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)tableDefinition)) {
                List dbColumns = ProcessorDslTemplateContextType.this.dbResolver.getColumns((EObject)tableDefinition, tableDefinition.getTable());
                return ProcessorDslTemplateContextType.this.getOptUpdateColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbSelectColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbSelectColumn";

        public DbSelectColumnResolver() {
            super(NAME, "DbSelectColumn");
        }

        protected String resolve(TemplateContext context) {
            TableDefinition tableDefinition = ProcessorDslTemplateContextType.this.getTableDefinition(ProcessorDslTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (tableDefinition != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)tableDefinition)) {
                List dbColumns = ProcessorDslTemplateContextType.this.dbResolver.getColumns((EObject)tableDefinition, tableDefinition.getTable());
                return ProcessorDslTemplateContextType.this.getSelectColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbTableResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbTable";

        public DbTableResolver() {
            super(NAME, "DbTable");
        }

        protected String resolve(TemplateContext context) {
            TableDefinition tableDefinition = ProcessorDslTemplateContextType.this.getTableDefinition(ProcessorDslTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (tableDefinition != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)tableDefinition)) {
                return "%%" + tableDefinition.getTable();
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbUpdateColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbUpdateColumn";

        public DbUpdateColumnResolver() {
            super(NAME, "DbUpdateColumn");
        }

        protected String resolve(TemplateContext context) {
            TableDefinition tableDefinition = ProcessorDslTemplateContextType.this.getTableDefinition(ProcessorDslTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (tableDefinition != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)tableDefinition)) {
                List dbColumns = ProcessorDslTemplateContextType.this.dbResolver.getColumns((EObject)tableDefinition, tableDefinition.getTable());
                return ProcessorDslTemplateContextType.this.getUpdateColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class DbVerUpdateColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "dbVerUpdateColumn";

        public DbVerUpdateColumnResolver() {
            super(NAME, "DbVerUpdateColumn");
        }

        protected String resolve(TemplateContext context) {
            TableDefinition tableDefinition = ProcessorDslTemplateContextType.this.getTableDefinition(ProcessorDslTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (tableDefinition != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)tableDefinition)) {
                List dbColumns = ProcessorDslTemplateContextType.this.dbResolver.getColumns((EObject)tableDefinition, tableDefinition.getTable());
                return ProcessorDslTemplateContextType.this.getVerUpdateColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class FunctionsDefinitionsResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "functionDefinitions";

        public FunctionsDefinitionsResolver() {
            super(NAME, "FunctionDefinitions");
        }

        protected String resolve(TemplateContext context) {
            Artifacts artifacts = ProcessorDslTemplateContextType.this.getArtifacts((XtextTemplateContext)context);
            if (artifacts != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)artifacts)) {
                List functionsPresented = Utils.findFunctions(null, (Artifacts)artifacts, (IScope)ProcessorDslTemplateContextType.this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__FUNCTIONS));
                List functions = ProcessorDslTemplateContextType.this.dbResolver.getFunctions((EObject)artifacts);
                return ProcessorDslTemplateContextType.this.getFunctionsDefinitions(functions, functionsPresented);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class MetaGeneratorResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "metaGenerator";

        public MetaGeneratorResolver() {
            super(NAME, "MetaGenerator");
        }

        protected String resolve(TemplateContext context) {
            Artifacts artifacts = ProcessorDslTemplateContextType.this.getArtifacts((XtextTemplateContext)context);
            if (artifacts != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)artifacts)) {
                DbResolver.DbType dbType;
                ArrayList<MetaStatement> metasToRemove = new ArrayList<MetaStatement>();
                HashSet<String> finalMetas = new HashSet<String>();
                for (MetaStatement meta : artifacts.getStatements()) {
                    if (Utils.isFinal((MetaStatement)meta)) {
                        finalMetas.add(meta.getName());
                        continue;
                    }
                    metasToRemove.add(meta);
                }
                List dbSequences = ProcessorDslTemplateContextType.this.dbResolver.getSequences((EObject)artifacts);
                TableMetaConverter converter = new TableMetaConverter(ProcessorDslTemplateContextType.this.modelProperty, artifacts, ProcessorDslTemplateContextType.this.scopeProvider, finalMetas, dbSequences, dbType = ProcessorDslTemplateContextType.this.getDbType(artifacts));
                if (ProcessorDslTemplateContextType.this.addDefinitions(converter, artifacts)) {
                    return ProcessorDslTemplateContextType.this.replaceAll(converter.getMetaDefinitions(), artifacts);
                }
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class PojoColumnResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "pojoColumn";

        public PojoColumnResolver() {
            super(NAME, "PojoColumn");
        }

        protected String resolve(TemplateContext context) {
            TableDefinition tableDefinition = ProcessorDslTemplateContextType.this.getTableDefinition(ProcessorDslTemplateContextType.this.getMetaStatement((XtextTemplateContext)context));
            if (tableDefinition != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)tableDefinition)) {
                List dbColumns = ProcessorDslTemplateContextType.this.dbResolver.getColumns((EObject)tableDefinition, tableDefinition.getTable());
                return ProcessorDslTemplateContextType.this.getPojoColumns(dbColumns);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class PojoDefinitionsResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "pojoDefinitions";

        public PojoDefinitionsResolver() {
            super(NAME, "PojoDefinitions");
        }

        protected String resolve(TemplateContext context) {
            Artifacts artifacts = ProcessorDslTemplateContextType.this.getArtifacts((XtextTemplateContext)context);
            if (artifacts != null && ProcessorDslTemplateContextType.this.pojoResolver.isResolvePojo((EObject)artifacts)) {
                List pojoClasses = ProcessorDslTemplateContextType.this.pojoResolver.getPojoClasses();
                return ProcessorDslTemplateContextType.this.getPojoDefinitions(pojoClasses);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class PojoGeneratorResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "pojoGenerator";

        public PojoGeneratorResolver() {
            super(NAME, "PojoGenerator");
        }

        protected String resolve(TemplateContext context) {
            Artifacts artifacts = ProcessorDslTemplateContextType.this.getArtifacts((XtextTemplateContext)context);
            PackageDeclaration packagex = ProcessorDslTemplateContextType.this.getPackage((XtextTemplateContext)context);
            if (artifacts != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)artifacts)) {
                DbResolver.DbType dbType;
                ArrayList<PojoEntity> entitiesToRemove = new ArrayList<PojoEntity>();
                HashSet<String> finalEntities = new HashSet<String>();
                Annotations annotations = new Annotations();
                String suffix = packagex.getSuffix();
                for (AbstractPojoEntity ape : packagex.getElements()) {
                    PojoEntity pojo;
                    if (!(ape instanceof AnnotatedEntity)) continue;
                    AnnotatedEntity apojo = (AnnotatedEntity)ape;
                    if (apojo.getEntity() != null && apojo.getEntity() instanceof PojoEntity) {
                        pojo = (PojoEntity)apojo.getEntity();
                        ProcessorDslTemplateContextType.this.grabAnnotations(apojo, pojo, annotations);
                        if (Utils.isFinal((PojoEntity)pojo)) {
                            finalEntities.add(pojo.getName());
                            continue;
                        }
                        entitiesToRemove.add(pojo);
                        continue;
                    }
                    if (apojo.getEntity() == null || !(apojo.getEntity() instanceof EnumEntity) || !Utils.isFinal((EnumEntity)(pojo = (EnumEntity)apojo.getEntity()))) continue;
                    finalEntities.add(pojo.getName());
                }
                List dbSequences = ProcessorDslTemplateContextType.this.dbResolver.getSequences((EObject)artifacts);
                TablePojoConverter converter = new TablePojoConverter(ProcessorDslTemplateContextType.this.modelProperty, artifacts, suffix, finalEntities, annotations, dbSequences, dbType = ProcessorDslTemplateContextType.this.getDbType(artifacts));
                if (ProcessorDslTemplateContextType.this.addDefinitions(converter, artifacts)) {
                    return ProcessorDslTemplateContextType.this.replaceAll(converter.getPojoDefinitions(), artifacts);
                }
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class ProceduresDefinitionsResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "procedureDefinitions";

        public ProceduresDefinitionsResolver() {
            super(NAME, "ProcedureDefinitions");
        }

        protected String resolve(TemplateContext context) {
            Artifacts artifacts = ProcessorDslTemplateContextType.this.getArtifacts((XtextTemplateContext)context);
            if (artifacts != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)artifacts)) {
                List proceduresPresented = Utils.findProcedures(null, (Artifacts)artifacts, (IScope)ProcessorDslTemplateContextType.this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__PROCEDURES));
                List procedures = ProcessorDslTemplateContextType.this.dbResolver.getProcedures((EObject)artifacts);
                return ProcessorDslTemplateContextType.this.getProceduresDefinitions(procedures, proceduresPresented);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }

    public class TablesDefinitionsResolver
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "tableDefinitions";

        public TablesDefinitionsResolver() {
            super(NAME, "TableDefinitions");
        }

        protected String resolve(TemplateContext context) {
            Artifacts artifacts = ProcessorDslTemplateContextType.this.getArtifacts((XtextTemplateContext)context);
            if (artifacts != null && ProcessorDslTemplateContextType.this.dbResolver.isResolveDb((EObject)artifacts)) {
                List tablesPresented = Utils.findTables(null, (Artifacts)artifacts, (IScope)ProcessorDslTemplateContextType.this.scopeProvider.getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__TABLES));
                List tables = ProcessorDslTemplateContextType.this.dbResolver.getTables((EObject)artifacts);
                return ProcessorDslTemplateContextType.this.getTablesDefinitions(tables, tablesPresented);
            }
            return super.resolve(context);
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return true;
        }
    }
}

