/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.ui.resolver;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.sqlproc.dsl.property.ModelProperty;
import org.sqlproc.dsl.resolver.PojoResolver;

@Singleton
public class WorkspacePojoResolverImpl
implements PojoResolver {
    protected Logger LOGGER = Logger.getLogger(WorkspacePojoResolverImpl.class);
    @Inject
    ModelProperty modelProperty;
    private List<URLClassLoader> allLoaders;

    protected void init() {
        IProject[] projects;
        this.LOGGER.info((Object)"POJO START");
        ArrayList<IJavaProject> javaProjects = new ArrayList<IJavaProject>();
        ArrayList<URLClassLoader> loaders = new ArrayList<URLClassLoader>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                project.open(null);
                IJavaProject javaProject = JavaCore.create((IProject)project);
                javaProjects.add(javaProject);
                URLClassLoader classLoader = this.getProjectClassLoader(javaProject);
                loaders.add(classLoader);
            }
            catch (CoreException e) {
                this.LOGGER.warn((Object)("Can't handle project '" + project + "': " + e.getMessage()));
            }
            ++n2;
        }
        this.allLoaders = loaders;
    }

    private URLClassLoader getProjectClassLoader(IJavaProject javaProject) throws CoreException {
        String[] classPathEntries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        ArrayList<URL> urlList = new ArrayList<URL>();
        int i = 0;
        while (i < classPathEntries.length) {
            String entry = classPathEntries[i];
            Path path = new Path(entry);
            try {
                URL url = path.toFile().toURI().toURL();
                urlList.add(url);
            }
            catch (MalformedURLException e) {
                this.LOGGER.warn((Object)("Can't accept URL for '" + path + "': " + e.getMessage()));
            }
            ++i;
        }
        ClassLoader parentClassLoader = javaProject.getClass().getClassLoader();
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        URLClassLoader classLoader = new URLClassLoader(urls, parentClassLoader);
        return classLoader;
    }

    public List<URLClassLoader> getAllLoaders() {
        if (this.allLoaders == null) {
            this.init();
        }
        return this.allLoaders;
    }

    public Class<?> loadClass(String name) {
        if (this.allLoaders == null) {
            this.init();
        }
        for (URLClassLoader loader : this.allLoaders) {
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        this.init();
        for (URLClassLoader loader : this.allLoaders) {
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        this.LOGGER.warn((Object)("Can't find class '" + name + "' in any loader " + this.allLoaders));
        return null;
    }

    public PropertyDescriptor[] getPropertyDescriptors(String name) {
        Class<?> beanClass;
        if (this.allLoaders == null) {
            this.init();
        }
        if ((beanClass = this.loadClass(name)) == null) {
            return null;
        }
        PropertyDescriptor[] descriptors = null;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException introspectionException) {
            return new PropertyDescriptor[0];
        }
        descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        return descriptors;
    }

    public boolean isResolvePojo(EObject model) {
        if (!this.modelProperty.isDoResolvePojo(model)) {
            return false;
        }
        if (this.allLoaders == null) {
            this.init();
        }
        return this.allLoaders != null;
    }

    public List<Class<?>> getPojoClasses() {
        ArrayList pojos = new ArrayList();
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart != null) {
            IFileEditorInput input = (IFileEditorInput)editorPart.getEditorInput();
            IProject project = input.getFile().getProject();
            try {
                project.open(null);
                IJavaProject javaProject = JavaCore.create((IProject)project);
                URLClassLoader classLoader = this.getProjectClassLoader(javaProject);
                IPackageFragment[] iPackageFragmentArray = javaProject.getPackageFragments();
                int n = iPackageFragmentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragment fragment = iPackageFragmentArray[n2];
                    if (fragment.getKind() == 1) {
                        ICompilationUnit[] iCompilationUnitArray = fragment.getCompilationUnits();
                        int n3 = iCompilationUnitArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ICompilationUnit unit = iCompilationUnitArray[n4];
                            if (unit.getTypes() != null && unit.getTypes().length > 0) {
                                String classname = String.valueOf(unit.getParent().getElementName()) + "." + unit.getTypes()[0].getElementName();
                                Class<?> clazz = null;
                                try {
                                    clazz = classLoader.loadClass(classname);
                                }
                                catch (ClassNotFoundException classNotFoundException) {}
                                if (clazz != null) {
                                    Annotation[] annotationArray = clazz.getAnnotations();
                                    int n5 = annotationArray.length;
                                    int n6 = 0;
                                    while (n6 < n5) {
                                        Annotation annotation = annotationArray[n6];
                                        if ("org.sqlproc.engine.annotation.Pojo".equals(annotation.annotationType().getName())) {
                                            pojos.add(clazz);
                                            break;
                                        }
                                        ++n6;
                                    }
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                this.LOGGER.warn((Object)("Can't handle project '" + project + "': " + e.getMessage()));
            }
        }
        return pojos;
    }

    public InputStream getFile(EObject model, String filename) {
        IWorkspaceRoot root;
        IFile modelFile;
        IContainer modelParent;
        Resource resource = model.eResource();
        URI uri = resource.getURI();
        if (uri.isPlatformResource() && (modelParent = (modelFile = (root = ResourcesPlugin.getWorkspace().getRoot()).getFile((IPath)new Path(uri.toPlatformString(false)))).getParent()) instanceof IFolder) {
            IFolder modelDir = (IFolder)modelParent;
            IFile file = modelDir.getFile(filename);
            try {
                return file.getContents();
            }
            catch (CoreException e) {
                this.LOGGER.warn((Object)("Can't handle file '" + filename + "': " + e.getMessage()));
            }
        }
        this.LOGGER.warn((Object)("Can't find file '" + filename + "' in project"));
        return null;
    }
}

