/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.ui.contentassist;

import com.google.inject.Inject;
import java.beans.PropertyDescriptor;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.sqlproc.dsl.processorDsl.AbstractPojoEntity;
import org.sqlproc.dsl.processorDsl.AnnotatedEntity;
import org.sqlproc.dsl.processorDsl.Artifacts;
import org.sqlproc.dsl.processorDsl.Column;
import org.sqlproc.dsl.processorDsl.DatabaseProperty;
import org.sqlproc.dsl.processorDsl.DriverMethodOutputAssignement;
import org.sqlproc.dsl.processorDsl.Entity;
import org.sqlproc.dsl.processorDsl.ExportAssignement;
import org.sqlproc.dsl.processorDsl.ExtendedColumn;
import org.sqlproc.dsl.processorDsl.ExtendedMappingItem;
import org.sqlproc.dsl.processorDsl.ImportAssignement;
import org.sqlproc.dsl.processorDsl.InheritanceAssignement;
import org.sqlproc.dsl.processorDsl.ManyToManyAssignement;
import org.sqlproc.dsl.processorDsl.MappingColumn;
import org.sqlproc.dsl.processorDsl.MappingRule;
import org.sqlproc.dsl.processorDsl.MetaStatement;
import org.sqlproc.dsl.processorDsl.MetagenProperty;
import org.sqlproc.dsl.processorDsl.PackageDeclaration;
import org.sqlproc.dsl.processorDsl.PojoAnnotatedProperty;
import org.sqlproc.dsl.processorDsl.PojoDefinition;
import org.sqlproc.dsl.processorDsl.PojoEntity;
import org.sqlproc.dsl.processorDsl.PojoProperty;
import org.sqlproc.dsl.processorDsl.PojogenProperty;
import org.sqlproc.dsl.processorDsl.ProcessorDslPackage;
import org.sqlproc.dsl.processorDsl.ShowColumnTypeAssignement;
import org.sqlproc.dsl.processorDsl.TableDefinition;
import org.sqlproc.dsl.resolver.DbExport;
import org.sqlproc.dsl.resolver.DbImport;
import org.sqlproc.dsl.resolver.DbResolver;
import org.sqlproc.dsl.resolver.PojoResolver;
import org.sqlproc.dsl.ui.contentassist.AbstractProcessorDslProposalProvider;
import org.sqlproc.dsl.util.Utils;

public class ProcessorDslProposalProvider
extends AbstractProcessorDslProposalProvider {
    @Inject
    PojoResolver pojoResolver;
    @Inject
    DbResolver dbResolver;
    @Inject
    IQualifiedNameConverter qualifiedNameConverter;
    private static final List<String> STATEMENT_TYPE = Arrays.asList("QRY", "CRUD", "CALL");
    private static final List<String> MAPPING_TYPE = Arrays.asList("OUT");
    private static final List<String> OPTION_TYPE = Arrays.asList("OPT", "LOPT", "IOPT", "SOPT", "BOPT", "MOPT");
    private static final List<String> TYPES = Arrays.asList("int", "integer", "long", "byte", "short", "float", "double", "character", "char", "string", "str", "time", "date", "datetime", "timestamp", "stamp", "bool", "boolean", "bigint", "biginteger", "bigdec", "bigdecimal", "bytearr", "bytearray", "bytes", "text", "blob", "clob", "einteger", "eint", "enumstring", "estring", "fromdate", "todate", "cursor", "other");
    private static final List<String> MODIFIERS = Arrays.asList("any", "null", "notnull", "seq", "seq=", "idsel", "idsel=", "id", "isDef=", "isCall=", "dtype=", "gtype=", "discr");
    private static final List<String> F_TYPES = Arrays.asList("set", "update", "values", "where");
    private static final List<String> DEBUG_LEVELS = Arrays.asList("DEBUG", "INFO", "FATAL", "ERROR", "WARN", "TRACE");
    private static final String[] methods = new String[]{"toString", "hashCode", "equals", "isDef", "toInit", "enumDef", "enumInit", "index="};

    @Override
    public void completeMetaStatement_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(STATEMENT_TYPE, "STATEMENT_TYPE", context, acceptor, null);
    }

    @Override
    public void completeMappingRule_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(MAPPING_TYPE, "MAPPING_TYPE", context, acceptor, null);
    }

    @Override
    public void completeOptionalFeature_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(OPTION_TYPE, "OPTION_TYPE", context, acceptor, null);
    }

    protected void addProposalList(List<String> values, String lexerRule, ContentAssistContext context, ICompletionProposalAcceptor acceptor, String prefix) {
        if (values == null) {
            return;
        }
        for (String value : values) {
            String proposal = this.getValueConverter().toString((Object)(prefix != null ? String.valueOf(prefix) + value : value), lexerRule);
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeMetaSql_Ftype(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(F_TYPES, "IDENT", context, acceptor, null);
    }

    @Override
    public void completeExtendedColumnName_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String prefix;
        Column column = (Column)EcoreUtil2.getContainerOfType((EObject)model, Column.class);
        StringBuilder partialName = new StringBuilder("");
        if (column != null) {
            for (ExtendedColumn xcolumn : column.getColumns()) {
                if (partialName.length() > 0) {
                    partialName.append(".");
                }
                partialName.append(xcolumn.getCol().getName());
                if (context.getPreviousModel() != null && xcolumn == context.getPreviousModel()) break;
            }
        }
        if (partialName.length() > 0) {
            partialName.append(".");
        }
        if (!this.completeUsage(model, assignment, context, acceptor, "out", "outx", prefix = String.valueOf(partialName.toString()) + context.getPrefix(), true)) {
            super.completeExtendedColumnName_Name(model, assignment, context, acceptor);
        }
    }

    @Override
    public void completeConstant_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String prefix = context.getPrefix();
        if (!this.completeUsage(model, assignment, context, acceptor, "const", "constx", prefix, false)) {
            super.completeConstant_Name(model, assignment, context, acceptor);
        }
    }

    @Override
    public void completeIdentifier_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String prefix = context.getPrefix();
        if (!this.completeUsage(model, assignment, context, acceptor, "in", "inx", prefix, false)) {
            super.completeIdentifier_Name(model, assignment, context, acceptor);
        }
    }

    public boolean completeUsage(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor, String usageInFilter, String usageInFilterExt, String prefix, boolean cutPrefix) {
        PojoDefinition pojoDefinition;
        if (!this.isResolvePojo(model)) {
            return false;
        }
        MetaStatement metaStatement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)model, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)metaStatement, Artifacts.class);
        String entityName = Utils.getTokenFromModifier((MetaStatement)metaStatement, (String)usageInFilterExt);
        PojoEntity pojoEntity = entityName != null ? Utils.findEntity((IQualifiedNameConverter)this.qualifiedNameConverter, (Artifacts)artifacts, (IScope)this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJO_PACKAGES), (String)entityName) : null;
        String pojoName = pojoEntity != null ? null : Utils.getTokenFromModifier((MetaStatement)metaStatement, (String)usageInFilter);
        PojoDefinition pojoDefinition2 = pojoDefinition = pojoName != null ? Utils.findPojo((IQualifiedNameConverter)this.qualifiedNameConverter, (Artifacts)artifacts, (IScope)this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJOS), (String)pojoName) : null;
        if (pojoDefinition == null && pojoEntity == null) {
            String proposal = this.getValueConverter().toString((Object)("Error: I can't load pojo for " + model), "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
            return true;
        }
        int pos = prefix.lastIndexOf(46);
        prefix = pos > 0 ? prefix.substring(0, pos + 1) : "";
        if (pojoDefinition != null) {
            String clazz = this.getClassName(this.getClass(pojoDefinition), prefix);
            if (clazz == null) {
                return false;
            }
            PropertyDescriptor[] descriptors = this.pojoResolver.getPropertyDescriptors(clazz);
            if (descriptors == null) {
                return false;
            }
            PropertyDescriptor[] propertyDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor descriptor = propertyDescriptorArray[n2];
                if (!"class".equals(descriptor.getName())) {
                    String proposal = this.getValueConverter().toString((Object)descriptor.getName(), "IDENT");
                    ICompletionProposal completionProposal = this.createCompletionProposal(cutPrefix ? proposal : String.valueOf(prefix) + proposal, context);
                    acceptor.accept(completionProposal);
                }
                ++n2;
            }
            return true;
        }
        PojoEntity entity = this.getPojoEntity(pojoEntity, prefix);
        List<PojoProperty> properties = this.getProperties(entity, null);
        if (properties.isEmpty()) {
            return false;
        }
        for (PojoProperty pojoProperty : properties) {
            String proposal = this.getValueConverter().toString((Object)pojoProperty.getName(), "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(cutPrefix ? proposal : String.valueOf(prefix) + proposal, context);
            acceptor.accept(completionProposal);
        }
        return true;
    }

    @Override
    public void completeMappingColumnName_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String prefix;
        int pos;
        PojoDefinition pojoDefinition;
        if (!this.isResolvePojo(model)) {
            super.completeMappingColumnName_Name(model, assignment, context, acceptor);
            return;
        }
        MappingColumn mappingColumn = (MappingColumn)EcoreUtil2.getContainerOfType((EObject)model, MappingColumn.class);
        MappingRule mappingRule = (MappingRule)EcoreUtil2.getContainerOfType((EObject)model, MappingRule.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)mappingRule, Artifacts.class);
        String entityName = Utils.getTokenFromModifier((MappingRule)mappingRule, (String)"outx");
        PojoEntity pojoEntity = entityName != null ? Utils.findEntity((IQualifiedNameConverter)this.qualifiedNameConverter, (Artifacts)artifacts, (IScope)this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJO_PACKAGES), (String)entityName) : null;
        String pojoName = pojoEntity != null ? null : Utils.getTokenFromModifier((MappingRule)mappingRule, (String)"out");
        PojoDefinition pojoDefinition2 = pojoDefinition = pojoName != null ? Utils.findPojo((IQualifiedNameConverter)this.qualifiedNameConverter, (Artifacts)artifacts, (IScope)this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJOS), (String)pojoName) : null;
        if (pojoDefinition == null && pojoEntity == null) {
            String proposal = this.getValueConverter().toString((Object)("Error: I can't load pojo for " + model), "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
        StringBuilder partialName = new StringBuilder("");
        boolean cutPrefix = false;
        if (model instanceof MappingColumn && mappingColumn != null) {
            cutPrefix = true;
            for (ExtendedMappingItem xmapping : mappingColumn.getItems()) {
                if (partialName.length() > 0) {
                    partialName.append(".");
                }
                partialName.append(xmapping.getAttr().getName());
                if (context.getPreviousModel() != null && xmapping == context.getPreviousModel()) break;
            }
        }
        if (partialName.length() > 0) {
            partialName.append(".");
        }
        prefix = (pos = (prefix = String.valueOf(partialName.toString()) + context.getPrefix()).lastIndexOf(46)) > 0 ? prefix.substring(0, pos + 1) : "";
        if (pojoDefinition != null) {
            String clazz = this.getClassName(this.getClass(pojoDefinition), prefix);
            if (clazz == null) {
                return;
            }
            PropertyDescriptor[] descriptors = this.pojoResolver.getPropertyDescriptors(clazz);
            if (descriptors == null) {
                super.completeMappingColumnName_Name(model, assignment, context, acceptor);
            } else {
                PropertyDescriptor[] propertyDescriptorArray = descriptors;
                int n = descriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyDescriptor descriptor = propertyDescriptorArray[n2];
                    if (!"class".equals(descriptor.getName())) {
                        String proposal = this.getValueConverter().toString((Object)descriptor.getName(), "IDENT");
                        ICompletionProposal completionProposal = this.createCompletionProposal(cutPrefix ? proposal : String.valueOf(prefix) + proposal, context);
                        acceptor.accept(completionProposal);
                    }
                    ++n2;
                }
            }
        } else {
            PojoEntity entity = this.getPojoEntity(pojoEntity, prefix);
            List<PojoProperty> properties = this.getProperties(entity, null);
            if (properties.isEmpty()) {
                return;
            }
            for (PojoProperty pojoProperty : properties) {
                String proposal = this.getValueConverter().toString((Object)pojoProperty.getName(), "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(cutPrefix ? proposal : String.valueOf(prefix) + proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    protected String getClass(PojoDefinition pojo) {
        if (pojo.getClassx() != null) {
            return pojo.getClassx().getQualifiedName();
        }
        return pojo.getClass_();
    }

    protected PojoEntity getPojoEntity(PojoEntity baseEntity, String property) {
        Entity innerEntity;
        int pos2;
        if (baseEntity == null || property == null) {
            return baseEntity;
        }
        int pos1 = property.indexOf(46);
        if (pos1 == -1) {
            return baseEntity;
        }
        String checkProperty = property;
        pos1 = checkProperty.indexOf(61);
        if (pos1 > 0 && (pos2 = checkProperty.indexOf(46, pos1)) > pos1) {
            checkProperty = String.valueOf(checkProperty.substring(0, pos1)) + checkProperty.substring(pos2);
        }
        String innerProperty = null;
        pos1 = checkProperty.indexOf(46);
        if (pos1 > 0) {
            innerProperty = checkProperty.substring(pos1 + 1);
            checkProperty = checkProperty.substring(0, pos1);
        }
        PojoProperty innerPojoProperty = null;
        for (PojoProperty pojoProperty : Utils.attributes((PojoEntity)baseEntity)) {
            if (!pojoProperty.getName().equals(checkProperty)) continue;
            innerPojoProperty = pojoProperty;
            break;
        }
        if (innerPojoProperty == null || innerPojoProperty.getRef() == null && innerPojoProperty.getGref() == null) {
            return null;
        }
        Object object = innerEntity = innerPojoProperty.getRef() != null ? innerPojoProperty.getRef() : innerPojoProperty.getGref();
        if (innerEntity instanceof PojoEntity) {
            return this.getPojoEntity((PojoEntity)innerEntity, innerProperty);
        }
        System.out.println("YYYYYY1 " + baseEntity.getName());
        System.out.println("YYYYYY2 " + property);
        System.out.println("YYYYYY3 " + innerProperty);
        System.out.println("YYYYYY4 " + checkProperty);
        System.out.println("YYYYYY5 " + innerPojoProperty.getName());
        System.out.println("YYYYYY6 " + innerPojoProperty.getRef());
        return null;
    }

    List<PojoProperty> getProperties(PojoEntity pojoEntity, List<PojoProperty> inproperties) {
        ArrayList<PojoProperty> properties;
        ArrayList<PojoProperty> arrayList = properties = inproperties != null ? inproperties : new ArrayList<PojoProperty>();
        if (pojoEntity == null) {
            return properties;
        }
        for (PojoAnnotatedProperty apojoProperty : pojoEntity.getFeatures()) {
            PojoProperty pojoProperty = apojoProperty.getFeature();
            if (pojoProperty.getNative() == null && pojoProperty.getRef() == null && pojoProperty.getType() == null) continue;
            properties.add(pojoProperty);
        }
        PojoEntity superType = Utils.getSuperType((PojoEntity)pojoEntity);
        if (superType != null) {
            return this.getProperties(superType, properties);
        }
        return properties;
    }

    protected boolean isPrimitive(Class<?> clazz) {
        if (clazz == null) {
            return true;
        }
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz == String.class) {
            return true;
        }
        if (clazz == java.util.Date.class) {
            return true;
        }
        if (clazz == Date.class) {
            return true;
        }
        if (clazz == Time.class) {
            return true;
        }
        if (clazz == Timestamp.class) {
            return true;
        }
        if (clazz == Blob.class) {
            return true;
        }
        if (clazz == Clob.class) {
            return true;
        }
        if (clazz == BigDecimal.class) {
            return true;
        }
        return clazz == BigInteger.class;
    }

    protected String getClassName(String baseClass, String property) {
        PropertyDescriptor[] descriptors;
        int pos2;
        if (baseClass == null || property == null) {
            return baseClass;
        }
        int pos1 = property.indexOf(46);
        if (pos1 == -1) {
            return baseClass;
        }
        String checkProperty = property;
        pos1 = checkProperty.indexOf(61);
        if (pos1 > 0 && (pos2 = checkProperty.indexOf(46, pos1)) > pos1) {
            checkProperty = String.valueOf(checkProperty.substring(0, pos1)) + checkProperty.substring(pos2);
        }
        String innerProperty = null;
        pos1 = checkProperty.indexOf(46);
        if (pos1 > 0) {
            innerProperty = checkProperty.substring(pos1 + 1);
            checkProperty = checkProperty.substring(0, pos1);
        }
        if ((descriptors = this.pojoResolver.getPropertyDescriptors(baseClass)) == null) {
            return null;
        }
        PropertyDescriptor innerDesriptor = null;
        PropertyDescriptor[] propertyDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor descriptor = propertyDescriptorArray[n2];
            if (descriptor.getName().equals(checkProperty)) {
                innerDesriptor = descriptor;
                break;
            }
            ++n2;
        }
        if (innerDesriptor == null) {
            return null;
        }
        Class innerClass = innerDesriptor.getPropertyType();
        if (innerClass.isArray()) {
            ParameterizedType type = (ParameterizedType)innerDesriptor.getReadMethod().getGenericReturnType();
            if (type.getActualTypeArguments() == null || type.getActualTypeArguments().length == 0) {
                return null;
            }
            innerClass = (Class)type.getActualTypeArguments()[0];
            if (this.isPrimitive(innerClass)) {
                return null;
            }
            return this.getClassName(innerClass.getName(), innerProperty);
        }
        if (Collection.class.isAssignableFrom(innerClass)) {
            ParameterizedType type = (ParameterizedType)innerDesriptor.getReadMethod().getGenericReturnType();
            if (type.getActualTypeArguments() == null || type.getActualTypeArguments().length == 0) {
                return null;
            }
            innerClass = (Class)type.getActualTypeArguments()[0];
            if (this.isPrimitive(innerClass)) {
                return null;
            }
            return this.getClassName(innerClass.getName(), innerProperty);
        }
        if (this.isPrimitive(innerClass)) {
            return null;
        }
        return this.getClassName(innerClass.getName(), innerProperty);
    }

    protected boolean isResolvePojo(EObject model) {
        return this.pojoResolver.isResolvePojo(model);
    }

    protected boolean isResolveDb(EObject model) {
        return this.dbResolver.isResolveDb(model);
    }

    @Override
    public void completeTableDefinition_Table(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeTableDefinition_Table(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void complete_DatabaseColumn(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        TableDefinition tableDefinition;
        if (!this.isResolveDb(model)) {
            super.complete_DatabaseColumn(model, ruleCall, context, acceptor);
            return;
        }
        String prefix = context.getPrefix();
        int pos = prefix.indexOf(46);
        prefix = pos > 0 ? prefix.substring(0, pos) : null;
        MetaStatement metaStatement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)model, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)metaStatement, Artifacts.class);
        String val = Utils.getTokenFromModifier((MetaStatement)metaStatement, (String)"tab", (String)prefix);
        TableDefinition tableDefinition2 = tableDefinition = val != null ? Utils.findTable((IQualifiedNameConverter)this.qualifiedNameConverter, (Artifacts)artifacts, (IScope)this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__TABLES), (String)val) : null;
        if (tableDefinition != null && tableDefinition.getTable() != null) {
            for (String column : this.dbResolver.getColumns(model, tableDefinition.getTable())) {
                String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                String completion = prefix != null ? String.valueOf(prefix) + '.' + proposal : proposal;
                ICompletionProposal completionProposal = this.createCompletionProposal(completion, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void complete_DatabaseTable(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.complete_DatabaseTable(model, ruleCall, context, acceptor);
            return;
        }
        MetaStatement metaStatement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)model, MetaStatement.class);
        Artifacts artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)metaStatement, Artifacts.class);
        TableDefinition tableDefinition = null;
        List vals = Utils.getTokensFromModifier((MetaStatement)metaStatement, (String)"tab");
        boolean found = false;
        for (String val : vals) {
            tableDefinition = Utils.findTable((IQualifiedNameConverter)this.qualifiedNameConverter, (Artifacts)artifacts, (IScope)this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__TABLES), (String)val);
            if (tableDefinition == null) continue;
            String proposal = this.getValueConverter().toString((Object)tableDefinition.getTable(), "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
            found = true;
        }
        if (found) {
            return;
        }
    }

    @Override
    public void completePojogenProperty_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ICompletionProposal completionProposal;
        String proposal;
        if (!this.isResolveDb(model)) {
            super.completePojogenProperty_DbTable(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
        for (String table : this.dbResolver.getCheckConstraints(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completePojogenProperty_DbProcedure(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completePojogenProperty_DbProcedure(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getProcedures(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completePojogenProperty_DbFunction(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completePojogenProperty_DbFunction(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getFunctions(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeTableAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeTableAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(String.valueOf(proposal) + "->", context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeInheritanceAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeInheritanceAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(String.valueOf(proposal) + "->", context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completePojogenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completePojogenProperty_DbTables(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completePojogenProperty_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completePojogenProperty_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeMetagenProperty_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeMetagenProperty_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completePojogenProperty_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof PojogenProperty)) {
            super.completePojogenProperty_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        if (prop.getDbTable() != null) {
            for (String column : this.dbResolver.getColumns(model, prop.getDbTable())) {
                String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completePojogenProperty_DbColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof PojogenProperty)) {
            super.completePojogenProperty_DbColumns(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        if (prop.getDbTable() != null) {
            for (String column : this.dbResolver.getColumns(model, prop.getDbTable())) {
                String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeImplementsAssignement_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ICompletionProposal completionProposal;
        String proposal;
        if (!this.isResolveDb(model)) {
            super.completeImplementsAssignement_DbTables(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
        for (String table : this.dbResolver.getProcedures(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
        for (String table : this.dbResolver.getFunctions(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeExtendsAssignement_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ICompletionProposal completionProposal;
        String proposal;
        if (!this.isResolveDb(model)) {
            super.completeExtendsAssignement_DbTables(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
        for (String table : this.dbResolver.getProcedures(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
        for (String table : this.dbResolver.getFunctions(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeImplementsAssignement_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ICompletionProposal completionProposal;
        String proposal;
        if (!this.isResolveDb(model)) {
            super.completeImplementsAssignement_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
        for (String table : this.dbResolver.getProcedures(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
        for (String table : this.dbResolver.getFunctions(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeExtendsAssignement_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ICompletionProposal completionProposal;
        String proposal;
        if (!this.isResolveDb(model)) {
            super.completeExtendsAssignement_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
        for (String table : this.dbResolver.getProcedures(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
        for (String table : this.dbResolver.getFunctions(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeImplementsAssignementGenerics_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ICompletionProposal completionProposal;
        String proposal;
        if (!this.isResolveDb(model)) {
            super.completeImplementsAssignementGenerics_DbTables(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
        for (String table : this.dbResolver.getProcedures(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
        for (String table : this.dbResolver.getFunctions(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeExtendsAssignementGenerics_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ICompletionProposal completionProposal;
        String proposal;
        if (!this.isResolveDb(model)) {
            super.completeExtendsAssignementGenerics_DbTables(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
        for (String table : this.dbResolver.getProcedures(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
        for (String table : this.dbResolver.getFunctions(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeImplementsAssignementGenerics_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ICompletionProposal completionProposal;
        String proposal;
        if (!this.isResolveDb(model)) {
            super.completeImplementsAssignementGenerics_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
        for (String table : this.dbResolver.getProcedures(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
        for (String table : this.dbResolver.getFunctions(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeExtendsAssignementGenerics_DbNotTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ICompletionProposal completionProposal;
        String proposal;
        if (!this.isResolveDb(model)) {
            super.completeExtendsAssignementGenerics_DbNotTables(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
        for (String table : this.dbResolver.getProcedures(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
        for (String table : this.dbResolver.getFunctions(model)) {
            if (table.indexOf(36) >= 0) continue;
            proposal = this.getValueConverter().toString((Object)table, "IDENT");
            completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeColumnTypeAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        block5: {
            PojogenProperty prop;
            block6: {
                block4: {
                    if (!this.isResolveDb(model) && !(model instanceof PojogenProperty)) {
                        super.completeColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
                        return;
                    }
                    prop = (PojogenProperty)model;
                    if (prop.getDbTable() == null) break block4;
                    for (String column : this.dbResolver.getColumns(model, prop.getDbTable())) {
                        String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                        ICompletionProposal completionProposal = this.createCompletionProposal(String.valueOf(proposal) + "->", context);
                        acceptor.accept(completionProposal);
                    }
                    break block5;
                }
                if (prop.getDbProcedure() == null) break block6;
                for (String column : this.dbResolver.getProcColumns(model, prop.getDbProcedure())) {
                    String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                    ICompletionProposal completionProposal = this.createCompletionProposal(String.valueOf(proposal) + "->", context);
                    acceptor.accept(completionProposal);
                }
                break block5;
            }
            if (prop.getDbFunction() == null) break block5;
            for (String column : this.dbResolver.getFunColumns(model, prop.getDbFunction())) {
                String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(String.valueOf(proposal) + "->", context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeColumnAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof PojogenProperty)) {
            super.completeColumnAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        if (prop.getDbTable() != null) {
            ICompletionProposal completionProposal;
            String proposal;
            for (String column : this.dbResolver.getColumns(model, prop.getDbTable())) {
                proposal = this.getValueConverter().toString((Object)column, "IDENT");
                completionProposal = this.createCompletionProposal(String.valueOf(proposal) + "->", context);
                acceptor.accept(completionProposal);
            }
            for (String column : this.dbResolver.getCheckColumns(model, prop.getDbTable())) {
                proposal = this.getValueConverter().toString((Object)column, "IDENT");
                completionProposal = this.createCompletionProposal(String.valueOf(proposal) + "->", context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeImportAssignement_PkTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        block5: {
            if (!this.isResolveDb(model) && !(model instanceof ImportAssignement)) {
                super.completeImportAssignement_PkTable(model, assignment, context, acceptor);
                return;
            }
            ImportAssignement imp = (ImportAssignement)model;
            PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)imp, PojogenProperty.class);
            if (prop.getDbTable() == null || imp.getDbColumn() == null) break block5;
            if ("create-many-to-one".equals(prop.getName())) {
                for (String table : this.dbResolver.getTables(model)) {
                    if (table.indexOf(36) >= 0) continue;
                    String proposal = this.getValueConverter().toString((Object)table, "IDENT");
                    ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                    acceptor.accept(completionProposal);
                }
            } else {
                for (DbImport dbImport : this.dbResolver.getDbImports(model, prop.getDbTable())) {
                    if (dbImport.getFkColumn() == null || !dbImport.getFkColumn().equals(imp.getDbColumn())) continue;
                    String proposal = this.getValueConverter().toString((Object)dbImport.getPkTable(), "IDENT");
                    ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                    acceptor.accept(completionProposal);
                }
            }
        }
    }

    @Override
    public void completeImportAssignement_PkColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        block5: {
            if (!this.isResolveDb(model) && !(model instanceof ImportAssignement)) {
                super.completeImportAssignement_PkColumn(model, assignment, context, acceptor);
                return;
            }
            ImportAssignement imp = (ImportAssignement)model;
            PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)imp, PojogenProperty.class);
            if (prop.getDbTable() == null || !(imp.getDbColumn() != null & imp.getPkTable() != null)) break block5;
            if ("create-many-to-one".equals(prop.getName())) {
                for (String column : this.dbResolver.getColumns(model, imp.getPkTable())) {
                    String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                    ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                    acceptor.accept(completionProposal);
                }
            } else {
                for (DbImport dbImport : this.dbResolver.getDbImports(model, prop.getDbTable())) {
                    if (dbImport.getFkColumn() == null || !dbImport.getFkColumn().equals(imp.getDbColumn()) || dbImport.getPkTable() == null || !dbImport.getPkTable().equals(imp.getPkTable())) continue;
                    String proposal = this.getValueConverter().toString((Object)dbImport.getPkColumn(), "IDENT");
                    ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                    acceptor.accept(completionProposal);
                }
            }
        }
    }

    @Override
    public void completeImportAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof PojogenProperty)) {
            super.completeImportAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        if (prop.getDbTable() != null) {
            for (String column : this.dbResolver.getColumns(model, prop.getDbTable())) {
                String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(String.valueOf(proposal) + "->", context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeExportAssignement_FkTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        block5: {
            if (!this.isResolveDb(model) && !(model instanceof ExportAssignement)) {
                super.completeExportAssignement_FkTable(model, assignment, context, acceptor);
                return;
            }
            ExportAssignement exp = (ExportAssignement)model;
            PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)exp, PojogenProperty.class);
            if (prop.getDbTable() == null || exp.getDbColumn() == null) break block5;
            if ("create-one-to-many".equals(prop.getName())) {
                for (String table : this.dbResolver.getTables(model)) {
                    if (table.indexOf(36) >= 0) continue;
                    String proposal = this.getValueConverter().toString((Object)table, "IDENT");
                    ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                    acceptor.accept(completionProposal);
                }
            } else {
                for (DbExport dbExport : this.dbResolver.getDbExports(model, prop.getDbTable())) {
                    if (dbExport.getPkColumn() == null || !dbExport.getPkColumn().equals(exp.getDbColumn())) continue;
                    String proposal = this.getValueConverter().toString((Object)dbExport.getFkTable(), "IDENT");
                    ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                    acceptor.accept(completionProposal);
                }
            }
        }
    }

    @Override
    public void completeExportAssignement_FkColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        block5: {
            if (!this.isResolveDb(model) && !(model instanceof ExportAssignement)) {
                super.completeExportAssignement_FkColumn(model, assignment, context, acceptor);
                return;
            }
            ExportAssignement exp = (ExportAssignement)model;
            PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)exp, PojogenProperty.class);
            if (prop.getDbTable() == null || !(exp.getDbColumn() != null & exp.getFkTable() != null)) break block5;
            if ("create-one-to-many".equals(prop.getName())) {
                for (String column : this.dbResolver.getColumns(model, exp.getFkTable())) {
                    String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                    ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                    acceptor.accept(completionProposal);
                }
            } else {
                for (DbExport dbExport : this.dbResolver.getDbExports(model, prop.getDbTable())) {
                    if (dbExport.getPkColumn() == null || !dbExport.getPkColumn().equals(exp.getDbColumn()) || dbExport.getFkTable() == null || !dbExport.getFkTable().equals(exp.getFkTable())) continue;
                    String proposal = this.getValueConverter().toString((Object)dbExport.getFkColumn(), "IDENT");
                    ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                    acceptor.accept(completionProposal);
                }
            }
        }
    }

    @Override
    public void completeExportAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof PojogenProperty)) {
            super.completeExportAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        if (prop.getDbTable() != null) {
            for (String column : this.dbResolver.getColumns(model, prop.getDbTable())) {
                String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(String.valueOf(proposal) + "->", context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeManyToManyAssignement_PkColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof PojogenProperty)) {
            super.completeManyToManyAssignement_PkColumn(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty prop = (PojogenProperty)model;
        if (prop.getDbTable() != null) {
            for (DbImport dbImport : this.dbResolver.getDbImports(model, prop.getDbTable())) {
                String proposal = this.getValueConverter().toString((Object)dbImport.getPkColumn(), "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(String.valueOf(proposal) + "->", context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeManyToManyAssignement_PkTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof ManyToManyAssignement)) {
            super.completeManyToManyAssignement_PkTable(model, assignment, context, acceptor);
            return;
        }
        ManyToManyAssignement many2 = (ManyToManyAssignement)model;
        PojogenProperty prop = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)many2, PojogenProperty.class);
        if (prop.getDbTable() != null && many2.getPkColumn() != null) {
            for (DbImport dbImport : this.dbResolver.getDbImports(model, prop.getDbTable())) {
                if (dbImport.getPkColumn() == null || !dbImport.getPkColumn().equals(many2.getPkColumn())) continue;
                String proposal = this.getValueConverter().toString((Object)dbImport.getPkTable(), "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeInheritanceAssignement_DbColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof InheritanceAssignement)) {
            super.completeInheritanceAssignement_DbColumns(model, assignment, context, acceptor);
            return;
        }
        PojogenProperty pojogenProperty = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        if (pojogenProperty.getDbTable() != null) {
            for (String column : this.dbResolver.getColumns(model, pojogenProperty.getDbTable())) {
                String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completePojogenProperty_Methods(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!(model instanceof PojogenProperty)) {
            super.completePojogenProperty_Methods(model, assignment, context, acceptor);
            return;
        }
        String[] stringArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String method = stringArray[n2];
            String proposal = this.getValueConverter().toString((Object)method, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
            ++n2;
        }
    }

    @Override
    public void completeShowColumnTypeAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        block5: {
            PojogenProperty prop;
            block6: {
                block4: {
                    if (!this.isResolveDb(model) && !(model instanceof PojogenProperty)) {
                        super.completeShowColumnTypeAssignement_DbColumn(model, assignment, context, acceptor);
                        return;
                    }
                    prop = (PojogenProperty)model;
                    if (prop.getDbTable() == null) break block4;
                    for (String column : this.dbResolver.getColumns(model, prop.getDbTable())) {
                        String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                        ICompletionProposal completionProposal = this.createCompletionProposal(String.valueOf(proposal) + "->", context);
                        acceptor.accept(completionProposal);
                    }
                    break block5;
                }
                if (prop.getDbProcedure() == null) break block6;
                for (String column : this.dbResolver.getProcColumns(model, prop.getDbProcedure())) {
                    String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                    ICompletionProposal completionProposal = this.createCompletionProposal(String.valueOf(proposal) + "->", context);
                    acceptor.accept(completionProposal);
                }
                break block5;
            }
            if (prop.getDbFunction() == null) break block5;
            for (String column : this.dbResolver.getFunColumns(model, prop.getDbFunction())) {
                String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(String.valueOf(proposal) + "->", context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeShowColumnTypeAssignement_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String column;
        if (!this.isResolveDb(model) && !(model instanceof ShowColumnTypeAssignement)) {
            super.completeShowColumnTypeAssignement_Type(model, assignment, context, acceptor);
            return;
        }
        ShowColumnTypeAssignement prop = (ShowColumnTypeAssignement)model;
        PojogenProperty pojogenProperty = (PojogenProperty)EcoreUtil2.getContainerOfType((EObject)model, PojogenProperty.class);
        String type = null;
        if (pojogenProperty.getDbTable() != null) {
            String table = pojogenProperty.getDbTable();
            column = prop.getDbColumn();
            type = this.dbResolver.getType(model, table, column);
        } else if (pojogenProperty.getDbProcedure() != null) {
            String procedure = pojogenProperty.getDbProcedure();
            column = prop.getDbColumn();
            type = this.dbResolver.getProcType(model, procedure, column);
        } else if (pojogenProperty.getDbFunction() != null) {
            String function = pojogenProperty.getDbFunction();
            column = prop.getDbColumn();
            type = this.dbResolver.getFunType(model, function, column);
        }
        if (type != null) {
            String proposal = this.getValueConverter().toString((Object)type, "PropertyValue");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeJoinTableAssignement_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeJoinTableAssignement_DbTable(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(String.valueOf(proposal) + "->", context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeJoinTableAssignement_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeJoinTableAssignement_DbTables(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void complete_StatementModifier(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ICompletionProposal completionProposal;
        Artifacts artifacts = null;
        MetaStatement metaStatement = (MetaStatement)EcoreUtil2.getContainerOfType((EObject)model, MetaStatement.class);
        artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)metaStatement, Artifacts.class);
        Set<PojoEntity> entities = this.listEntities(artifacts.eResource().getResourceSet(), this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJO_PACKAGES));
        for (PojoEntity entity : entities) {
            String proposal = this.getValueConverter().toString((Object)entity.getName(), "IDENT");
            ICompletionProposal completionProposal2 = this.createCompletionProposal("constx=" + (String)proposal, context);
            acceptor.accept(completionProposal2);
            ICompletionProposal completionProposal3 = this.createCompletionProposal("inx=" + (String)proposal, context);
            acceptor.accept(completionProposal3);
            ICompletionProposal completionProposal32 = this.createCompletionProposal("outx=" + (String)proposal, context);
            acceptor.accept(completionProposal32);
        }
        Set<PojoDefinition> pojos = this.listPojos(artifacts.eResource().getResourceSet(), this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJOS));
        for (PojoDefinition pojo : pojos) {
            String proposal = this.getValueConverter().toString((Object)pojo.getName(), "IDENT");
            ICompletionProposal completionProposal2 = this.createCompletionProposal("const=" + proposal, context);
            acceptor.accept(completionProposal2);
            completionProposal = this.createCompletionProposal("in=" + proposal, context);
            acceptor.accept(completionProposal);
            ICompletionProposal completionProposal3 = this.createCompletionProposal("out=" + proposal, context);
            acceptor.accept(completionProposal3);
        }
        Set<TableDefinition> tables = this.listTables(artifacts.eResource().getResourceSet(), this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__TABLES));
        for (TableDefinition table : tables) {
            String proposal = this.getValueConverter().toString((Object)table.getName(), "IDENT");
            completionProposal = this.createCompletionProposal("tab=" + proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void complete_MappingRuleModifier(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Artifacts artifacts = null;
        MappingRule mappingRule = (MappingRule)EcoreUtil2.getContainerOfType((EObject)model, MappingRule.class);
        artifacts = (Artifacts)EcoreUtil2.getContainerOfType((EObject)mappingRule, Artifacts.class);
        Set<PojoEntity> entities = this.listEntities(artifacts.eResource().getResourceSet(), this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJO_PACKAGES));
        for (PojoEntity entity : entities) {
            String proposal = this.getValueConverter().toString((Object)entity.getName(), "IDENT");
            ICompletionProposal completionProposal2 = this.createCompletionProposal("outx=" + proposal, context);
            acceptor.accept(completionProposal2);
        }
        Set<PojoDefinition> pojos = this.listPojos(artifacts.eResource().getResourceSet(), this.getScopeProvider().getScope((EObject)artifacts, ProcessorDslPackage.Literals.ARTIFACTS__POJOS));
        for (PojoDefinition pojo : pojos) {
            String proposal = this.getValueConverter().toString((Object)pojo.getName(), "IDENT");
            ICompletionProposal completionProposal2 = this.createCompletionProposal("out=" + proposal, context);
            acceptor.accept(completionProposal2);
        }
    }

    @Override
    public void complete_Modifier(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(TYPES, "IDENT", context, acceptor, "type=");
        this.addProposalList(MODIFIERS, "IDENT", context, acceptor, null);
    }

    @Override
    public void complete_MappingItemModifier(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(TYPES, "IDENT", context, acceptor, "type=");
        this.addProposalList(MODIFIERS, "IDENT", context, acceptor, null);
    }

    protected Set<PojoEntity> listEntities(ResourceSet resourceSet, IScope scope) {
        TreeSet<PojoEntity> result = new TreeSet<PojoEntity>(new Comparator<PojoEntity>(){

            @Override
            public int compare(PojoEntity o1, PojoEntity o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Iterable iterable = scope.getAllElements();
        for (IEObjectDescription description : iterable) {
            PackageDeclaration packageDeclaration = (PackageDeclaration)resourceSet.getEObject(description.getEObjectURI(), true);
            for (AbstractPojoEntity aEntity : packageDeclaration.getElements()) {
                AnnotatedEntity ae;
                if (!(aEntity instanceof AnnotatedEntity) || !((ae = (AnnotatedEntity)aEntity).getEntity() instanceof PojoEntity)) continue;
                result.add((PojoEntity)ae.getEntity());
            }
        }
        return result;
    }

    protected Set<PojoDefinition> listPojos(ResourceSet resourceSet, IScope scope) {
        TreeSet<PojoDefinition> result = new TreeSet<PojoDefinition>(new Comparator<PojoDefinition>(){

            @Override
            public int compare(PojoDefinition o1, PojoDefinition o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Iterable iterable = scope.getAllElements();
        for (IEObjectDescription description : iterable) {
            PojoDefinition pojo = (PojoDefinition)resourceSet.getEObject(description.getEObjectURI(), true);
            result.add(pojo);
        }
        return result;
    }

    protected Set<TableDefinition> listTables(ResourceSet resourceSet, IScope scope) {
        TreeSet<TableDefinition> result = new TreeSet<TableDefinition>(new Comparator<TableDefinition>(){

            @Override
            public int compare(TableDefinition o1, TableDefinition o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Iterable iterable = scope.getAllElements();
        for (IEObjectDescription description : iterable) {
            TableDefinition table = (TableDefinition)resourceSet.getEObject(description.getEObjectURI(), true);
            result.add(table);
        }
        return result;
    }

    @Override
    public void completeMetagenProperty_DbTable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeMetagenProperty_DbTable(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeMetagenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeMetagenProperty_DbTables(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeMetagenProperty_DbFunction(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeMetagenProperty_DbFunction(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getFunctions(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeMetagenProperty_DbProcedure(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeMetagenProperty_DbProcedure(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getProcedures(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeMetagenProperty_Sequence(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeMetagenProperty_Sequence(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getSequences(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeMetaTypeAssignement_DbColumn(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof MetagenProperty)) {
            super.completeMetaTypeAssignement_DbColumn(model, assignment, context, acceptor);
            return;
        }
        MetagenProperty prop = (MetagenProperty)model;
        if (prop.getDbTable() != null) {
            for (String column : this.dbResolver.getColumns(model, prop.getDbTable())) {
                String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeDaogenProperty_DbTables(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeDaogenProperty_DbTables(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getTables(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeMetagenProperty_DbColumns(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof MetagenProperty)) {
            super.completeMetagenProperty_DbColumns(model, assignment, context, acceptor);
            return;
        }
        MetagenProperty prop = (MetagenProperty)model;
        if (prop.getDbTable() != null) {
            for (String column : this.dbResolver.getColumns(model, prop.getDbTable())) {
                String proposal = this.getValueConverter().toString((Object)column, "IDENT");
                ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
                acceptor.accept(completionProposal);
            }
        }
    }

    @Override
    public void completeDatabaseMetaInfoAssignement_DbMetaInfo(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeDatabaseMetaInfoAssignement_DbMetaInfo(model, assignment, context, acceptor);
            return;
        }
        String dbMetaInfo = this.dbResolver.getDbMetaInfo(model);
        String proposal = this.getValueConverter().toString((Object)dbMetaInfo, "PropertyValue");
        ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
        acceptor.accept(completionProposal);
    }

    @Override
    public void completeDriverMetaInfoAssignement_DbDriverInfo(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeDriverMetaInfoAssignement_DbDriverInfo(model, assignment, context, acceptor);
            return;
        }
        String dbDriverInfo = this.dbResolver.getDbDriverInfo(model);
        String proposal = this.getValueConverter().toString((Object)dbDriverInfo, "PropertyValue");
        ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
        acceptor.accept(completionProposal);
    }

    @Override
    public void completeDriverMethodOutputAssignement_DriverMethod(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof DatabaseProperty)) {
            super.completeDriverMethodOutputAssignement_DriverMethod(model, assignment, context, acceptor);
            return;
        }
        for (String driverMetod : this.dbResolver.getDriverMethods(model)) {
            String proposal = this.getValueConverter().toString((Object)driverMetod, "PropertyValue");
            ICompletionProposal completionProposal = this.createCompletionProposal(String.valueOf(proposal) + "->", context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeDriverMethodOutputAssignement_CallOutput(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model) && !(model instanceof DriverMethodOutputAssignement)) {
            super.completeDriverMethodOutputAssignement_CallOutput(model, assignment, context, acceptor);
            return;
        }
        DriverMethodOutputAssignement prop = (DriverMethodOutputAssignement)model;
        String methodName = prop.getDriverMethod();
        Object methodCallOutput = this.dbResolver.getDriverMethodOutput(model, methodName);
        if (methodCallOutput == null) {
            methodCallOutput = "null";
        }
        String proposal = this.getValueConverter().toString((Object)("" + methodCallOutput), "PropertyValue");
        ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
        acceptor.accept(completionProposal);
    }

    @Override
    public void completeDatabaseTypeAssignement_DbType(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        DbResolver.DbType[] dbTypes;
        if (!this.isResolveDb(model)) {
            super.completeDatabaseTypeAssignement_DbType(model, assignment, context, acceptor);
            return;
        }
        String dbMetaInfo = this.dbResolver.getDbMetaInfo(model);
        DbResolver.DbType[] dbTypeArray = dbTypes = DbResolver.DbType.fromDbMetaInfo((String)dbMetaInfo);
        int n = dbTypes.length;
        int n2 = 0;
        while (n2 < n) {
            DbResolver.DbType dbType = dbTypeArray[n2];
            String proposal = this.getValueConverter().toString((Object)dbType.getValue(), "PropertyValue");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
            ++n2;
        }
    }

    @Override
    public void completeDatabaseCatalogAssignement_DbCatalog(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeDatabaseCatalogAssignement_DbCatalog(model, assignment, context, acceptor);
            return;
        }
        for (String catalog : this.dbResolver.getCatalogs(model)) {
            String proposal = this.getValueConverter().toString((Object)catalog, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeDatabaseSchemaAssignement_DbSchema(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeDatabaseSchemaAssignement_DbSchema(model, assignment, context, acceptor);
            return;
        }
        for (String schema : this.dbResolver.getSchemas(model)) {
            String proposal = this.getValueConverter().toString((Object)schema, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeDebugLevelAssignement_Debug(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.addProposalList(DEBUG_LEVELS, "DEBUG_LEVELS", context, acceptor, null);
    }

    @Override
    public void completeProcedurePojoAssignement_DbProcedure(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeProcedurePojoAssignement_DbProcedure(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getProcedures(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeFunctionPojoAssignement_DbFunction(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!this.isResolveDb(model)) {
            super.completeFunctionPojoAssignement_DbFunction(model, assignment, context, acceptor);
            return;
        }
        for (String table : this.dbResolver.getFunctions(model)) {
            if (table.indexOf(36) >= 0) continue;
            String proposal = this.getValueConverter().toString((Object)table, "IDENT");
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            acceptor.accept(completionProposal);
        }
    }
}

