/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.ui.templates;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.sqlproc.dsl.processorDsl.Artifacts;
import org.sqlproc.dsl.processorDsl.PojoType;
import org.sqlproc.dsl.property.ImplementsExtends;
import org.sqlproc.dsl.property.ModelProperty;
import org.sqlproc.dsl.property.PojoAttribute;
import org.sqlproc.dsl.resolver.DbResolver;
import org.sqlproc.dsl.ui.templates.TableMetaConverter;

public class TableDaoConverter
extends TableMetaConverter {
    private boolean debug = false;
    protected Set<String> finalDaos;
    protected Set<String> daoIgnoreTables = new HashSet<String>();
    protected Set<String> daoOnlyTables = new HashSet<String>();
    protected String daoImplementationPackage;
    protected Map<String, ImplementsExtends> daoToImplements = new HashMap<String, ImplementsExtends>();
    protected ImplementsExtends daoToExtends = null;
    protected boolean daoMakeItFinal;
    protected Map<String, PojoType> daoFunctionsResult = new HashMap<String, PojoType>();
    protected Set<String> notGenerics;
    protected Set<String> generics;

    public TableDaoConverter() {
    }

    public TableDaoConverter(ModelProperty modelProperty, Artifacts artifacts, String suffix, IScopeProvider scopeProvider, Set<String> finalDaos, List<String> dbSequences, DbResolver.DbType dbType) {
        super(modelProperty, artifacts, null, Collections.<String>emptySet(), dbSequences, dbType);
        Set daoOnlyTables;
        this.debug = modelProperty.getDaoDebugLevel((EObject)artifacts) != null && modelProperty.getDaoDebugLevel((EObject)artifacts).isGreaterOrEqual((Priority)Level.DEBUG);
        this.suffix = suffix != null ? suffix : "";
        this.finalDaos = finalDaos;
        Set daoIgnoreTables = modelProperty.getDaoIgnoreTables((EObject)artifacts);
        if (daoIgnoreTables != null) {
            this.daoIgnoreTables.addAll(daoIgnoreTables);
        }
        if ((daoOnlyTables = modelProperty.getDaoOnlyTables((EObject)artifacts)) != null) {
            this.daoOnlyTables.addAll(daoOnlyTables);
        }
        this.daoImplementationPackage = modelProperty.getDaoImplementationPackage((EObject)artifacts);
        Map daoToImplements = modelProperty.getDaoToImplements((EObject)artifacts);
        if (daoToImplements != null) {
            this.daoToImplements.putAll(daoToImplements);
        }
        this.daoToExtends = modelProperty.getDaoToExtends((EObject)artifacts);
        this.daoMakeItFinal = modelProperty.isDaoMakeItFinal((EObject)artifacts);
        Map daoFunctionsResult = modelProperty.getDaoFunctionsResult((EObject)artifacts);
        if (daoFunctionsResult != null) {
            this.daoFunctionsResult.putAll(daoFunctionsResult);
        }
        if (this.debug) {
            System.out.println("finalDaos " + this.finalDaos);
            System.out.println("daoIgnoreTables " + this.daoIgnoreTables);
            System.out.println("daoOnlyTables " + this.daoOnlyTables);
            System.out.println("daoImplementationPackage " + this.daoImplementationPackage);
            System.out.println("daoToImplements " + this.daoToImplements);
            System.out.println("daoToExtends " + this.daoToExtends);
            System.out.println("daoFunctionsResult " + this.daoFunctionsResult);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getDaoDefinitions() {
        try {
            PojoType ptype;
            String dispName;
            PojoAttribute returnAttribute;
            Map attributes;
            if (this.debug) {
                System.out.println("pojos " + this.pojos);
                System.out.println("pojoExtends " + this.pojoExtends);
                System.out.println("pojoInheritanceDiscriminator " + this.pojoInheritanceDiscriminator);
                System.out.println("pojoInheritanceSimple " + this.pojoInheritanceSimple);
                System.out.println("pojoDiscriminators " + this.pojoDiscriminators);
                System.out.println("indexes " + this.indexes);
                System.out.println("procedures " + this.procedures);
                System.out.println("functions " + this.functions);
            }
            StringBuilder buffer = new StringBuilder();
            boolean isSerializable = false;
            HashSet<String> serializables = new HashSet<String>();
            boolean oneMoreLine = false;
            if (!this.daoToImplements.isEmpty()) {
                for (ImplementsExtends ie : this.daoToImplements.values()) {
                    Object daoName;
                    JvmType type = ie.getToImplement();
                    if (type.getIdentifier().endsWith("Serializable")) {
                        if (!ie.getDbTables().isEmpty()) {
                            for (String dbTable : ie.getDbTables()) {
                                if (dbTable.equalsIgnoreCase("Procedures")) {
                                    serializables.add("Procedures");
                                    continue;
                                }
                                if (dbTable.equalsIgnoreCase("Functions")) {
                                    serializables.add("Functions");
                                    continue;
                                }
                                serializables.add(dbTable);
                            }
                            continue;
                        }
                        if (!ie.getDbNotTables().isEmpty()) {
                            for (String pojo : this.pojos.keySet()) {
                                serializables.add(pojo);
                            }
                            for (String pojo : this.enums.keySet()) {
                                serializables.add(pojo);
                            }
                            serializables.add("Procedures");
                            serializables.add("Functions");
                            for (String dbTable : ie.getDbNotTables()) {
                                serializables.remove(dbTable);
                            }
                            continue;
                        }
                        isSerializable = true;
                        continue;
                    }
                    buffer.append("\n  implements ").append(type.getIdentifier());
                    if (ie.isGenerics()) {
                        buffer.append(" <<>>");
                        if (this.notGenerics == null) {
                            this.notGenerics = new HashSet<String>();
                        }
                        if (this.generics == null) {
                            this.generics = new HashSet<String>();
                        }
                    }
                    if (!ie.getDbTables().isEmpty()) {
                        buffer.append(" onlyDaos");
                        for (String dbColumn : ie.getDbTables()) {
                            void var10_28;
                            String string = (String)this.tableNames.get(dbColumn);
                            if (string == null) {
                                String string2 = dbColumn;
                            }
                            daoName = String.valueOf(this.tableToCamelCase((String)var10_28)) + "Dao";
                            if (this.generics != null) {
                                this.generics.add((String)daoName);
                            }
                            buffer.append(" ").append((String)daoName);
                        }
                    }
                    if (ie.getDbNotTables().isEmpty()) continue;
                    buffer.append(" exceptDaos");
                    for (String dbColumn : ie.getDbNotTables()) {
                        void var10_31;
                        String string = (String)this.tableNames.get(dbColumn);
                        if (string == null) {
                            String string3 = dbColumn;
                        }
                        daoName = String.valueOf(this.tableToCamelCase((String)var10_31)) + "Dao";
                        if (this.notGenerics != null) {
                            this.notGenerics.add((String)daoName);
                        }
                        buffer.append(" ").append((String)daoName);
                    }
                }
                oneMoreLine = true;
            }
            if (this.daoToExtends != null) {
                String daoName;
                JvmType type = this.daoToExtends.getToImplement();
                buffer.append("\n  extends ").append(type.getIdentifier());
                if (this.daoToExtends.isGenerics()) {
                    buffer.append(" <<>>");
                }
                if (!this.daoToExtends.getDbTables().isEmpty()) {
                    buffer.append(" onlyDaos");
                    for (Object dbColumn : this.daoToExtends.getDbTables()) {
                        Object pojoName2 = (String)this.tableNames.get(dbColumn);
                        if (pojoName2 == null) {
                            pojoName2 = dbColumn;
                        }
                        daoName = String.valueOf(this.tableToCamelCase((String)pojoName2)) + "Dao";
                        buffer.append(" ").append(daoName);
                    }
                }
                if (!this.daoToExtends.getDbNotTables().isEmpty()) {
                    buffer.append(" exceptDaos");
                    for (Object dbColumn : this.daoToExtends.getDbNotTables()) {
                        Object pojoName = (String)this.tableNames.get(dbColumn);
                        if (pojoName == null) {
                            pojoName = dbColumn;
                        }
                        daoName = String.valueOf(this.tableToCamelCase((String)pojoName)) + "Dao";
                        buffer.append(" ").append(daoName);
                    }
                }
                oneMoreLine = true;
            }
            if (this.daoImplementationPackage != null) {
                buffer.append("\n  implementation-package ").append(this.daoImplementationPackage);
                oneMoreLine = true;
            }
            if (oneMoreLine) {
                buffer.append("\n");
            }
            for (String pojo : this.pojos.keySet()) {
                String daoName;
                if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(pojo) || this.daoIgnoreTables.contains(pojo)) continue;
                Object pojoName3 = (String)this.tableNames.get(pojo);
                if (pojoName3 == null) {
                    pojoName3 = pojo;
                }
                if (this.finalDaos.contains(daoName = String.valueOf(this.tableToCamelCase((String)pojoName3)) + "Dao") || (this.pojoInheritanceDiscriminator.containsKey(pojo) || this.pojoInheritanceSimple.containsKey(pojo)) && !this.notAbstractTables.contains(pojo)) continue;
                buffer.append("\n  ");
                if (this.daoMakeItFinal) {
                    buffer.append("final ");
                }
                buffer.append("dao ");
                buffer.append(daoName);
                if (this.generics != null && !this.generics.isEmpty()) {
                    if (this.generics.contains(daoName)) {
                        buffer.append(" ::: ");
                    } else {
                        buffer.append(" :: ");
                    }
                } else if (this.notGenerics != null && !this.notGenerics.isEmpty()) {
                    if (this.notGenerics.contains(daoName)) {
                        buffer.append(" :: ");
                    } else {
                        buffer.append(" ::: ");
                    }
                } else {
                    buffer.append(" :: ");
                }
                buffer.append(this.tableToCamelCase((String)pojoName3));
                if (isSerializable || serializables.contains(pojo)) {
                    buffer.append(" serializable 1 ");
                }
                buffer.append(" {");
                buffer.append("\n    scaffold");
                if (this.generateMethods.contains("toInit")) {
                    LinkedHashMap<String, String> toInit = new LinkedHashMap<String, String>();
                    this.toInits(pojo, toInit);
                    for (Map.Entry entry : toInit.entrySet()) {
                        String pojoName2;
                        buffer.append("\n    ").append((String)entry.getKey()).append(" :::");
                        if (this.pojoInheritanceSimple.containsKey(entry.getValue())) {
                            for (String pojo2 : (Set)this.pojoInheritanceSimple.get(entry.getValue())) {
                                buffer.append(" ").append(this.columnToCamelCase(pojo2));
                                pojoName2 = (String)this.tableNames.get(pojo2);
                                if (pojoName2 == null) {
                                    pojoName2 = pojo2;
                                }
                                buffer.append(" ::").append(this.tableToCamelCase(pojoName2));
                            }
                            continue;
                        }
                        for (String pojo2 : (Set)this.pojoInheritanceDiscriminator.get(entry.getValue())) {
                            buffer.append(" ").append((String)this.pojoDiscriminators.get(pojo2));
                            pojoName2 = (String)this.tableNames.get(pojo2);
                            if (pojoName2 == null) {
                                pojoName2 = pojo2;
                            }
                            buffer.append(" ::").append(this.tableToCamelCase(pojoName2));
                        }
                    }
                }
                buffer.append("\n  }\n");
            }
            boolean hasProcedures = false;
            for (String pojo : this.procedures.keySet()) {
                boolean isFunction;
                if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(pojo) || this.daoIgnoreTables.contains(pojo) || (isFunction = this.functions.containsKey(pojo))) continue;
                hasProcedures = true;
                break;
            }
            if (hasProcedures && !this.finalDaos.contains("ProceduresDao")) {
                buffer.append("\n  ");
                if (this.daoMakeItFinal) {
                    buffer.append("final ");
                }
                buffer.append("dao ProceduresDao");
                if (isSerializable || serializables.contains("Procedures")) {
                    buffer.append(" serializable 1 ");
                }
                buffer.append(" {");
                for (String procedure : this.procedures.keySet()) {
                    boolean isFunction;
                    if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(procedure) || this.daoIgnoreTables.contains(procedure) || (isFunction = this.functions.containsKey(procedure))) continue;
                    buffer.append("\n    ");
                    String pojoName4 = (String)this.tableNames.get(procedure);
                    if (pojoName4 == null) {
                        pojoName4 = procedure;
                    }
                    pojoName4 = this.tableToCamelCase(pojoName4);
                    String string = this.lowerFirstChar(pojoName4);
                    Map attributes2 = (Map)this.procedures.get(procedure);
                    if (this.metaProceduresResultSet.containsKey(procedure)) {
                        buffer.append("callQuery ").append(string).append(" :java.util.List<:").append(this.tableToCamelCase((String)this.metaProceduresResultSet.get(procedure))).append(">");
                    } else {
                        PojoAttribute returnAttribute2;
                        PojoAttribute pojoAttribute = returnAttribute2 = attributes2.containsKey("_result_") ? (PojoAttribute)attributes2.get("_result_") : null;
                        if (returnAttribute2 != null && this.dbType != DbResolver.DbType.POSTGRESQL) {
                            buffer.append("callQuery ").append(string).append(" :").append(returnAttribute2.getClassName());
                        } else {
                            buffer.append("callUpdate ").append(string).append(" _void");
                        }
                    }
                    String dispName2 = null;
                    PojoType ptype2 = (PojoType)this.pojosForProcedures.get(procedure);
                    if (ptype2 != null) {
                        dispName2 = ptype2.getRef() != null ? ptype2.getRef().getName() : ptype2.getType().getSimpleName();
                    }
                    buffer.append(" ::: ").append(this.lowerFirstChar(pojoName4)).append(" ::").append(dispName2 != null ? dispName2 : pojoName4);
                }
                buffer.append("\n  }\n");
            }
            boolean hasFunctions = false;
            for (String pojo : this.procedures.keySet()) {
                boolean isFunction;
                if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(pojo) || this.daoIgnoreTables.contains(pojo) || !(isFunction = this.functions.containsKey(pojo))) continue;
                hasFunctions = true;
                break;
            }
            if (hasFunctions && !this.finalDaos.contains("FunctionsDao")) {
                buffer.append("\n  ");
                if (this.daoMakeItFinal) {
                    buffer.append("final ");
                }
                buffer.append("dao FunctionsDao");
                if (isSerializable || serializables.contains("Functions")) {
                    buffer.append(" serializable 1 ");
                }
                buffer.append(" {");
                for (String procedure : this.procedures.keySet()) {
                    void var10_39;
                    boolean isFunction;
                    if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(procedure) || this.daoIgnoreTables.contains(procedure) || !(isFunction = this.functions.containsKey(procedure))) continue;
                    buffer.append("\n    ");
                    String string = (String)this.tableNames.get(procedure);
                    if (string == null) {
                        String string4 = procedure;
                    }
                    String string5 = this.tableToCamelCase((String)var10_39);
                    String procedureName = this.lowerFirstChar(string5);
                    attributes = (Map)this.procedures.get(procedure);
                    if (this.metaFunctionsResultSet.containsKey(procedure)) {
                        buffer.append("callQueryFunction ").append(procedureName).append(" :java.util.List<:").append(this.tableToCamelCase((String)this.metaFunctionsResultSet.get(procedure))).append(">");
                    } else if (this.metaFunctionsResult.containsKey(procedure)) {
                        buffer.append("callFunction ").append(procedureName).append(" :").append(this.metaType2className((String)this.metaFunctionsResult.get(procedure)));
                    } else {
                        PojoAttribute pojoAttribute = returnAttribute = attributes.containsKey("_result_") ? (PojoAttribute)attributes.get("_result_") : null;
                        if (returnAttribute != null) {
                            buffer.append("callQueryFunction ").append(procedureName).append(" :").append(returnAttribute.getClassName());
                        } else {
                            buffer.append("callUpdateFunction ").append(procedureName).append(" _void");
                        }
                    }
                    dispName = null;
                    ptype = (PojoType)this.pojosForProcedures.get(procedure);
                    if (ptype != null) {
                        dispName = ptype.getRef() != null ? ptype.getRef().getName() : ptype.getType().getSimpleName();
                    }
                    buffer.append(" ::: ").append(this.lowerFirstChar(string5)).append(" ::").append(dispName != null ? dispName : string5);
                }
                buffer.append("\n  }\n");
            }
            hasFunctions = false;
            for (String pojo : this.functions.keySet()) {
                boolean isProcedure;
                if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(pojo) || this.daoIgnoreTables.contains(pojo) || (isProcedure = this.procedures.containsKey(pojo))) continue;
                hasFunctions = true;
                break;
            }
            if (hasFunctions && !this.finalDaos.contains("FunctionsDao")) {
                buffer.append("\n  ");
                if (this.daoMakeItFinal) {
                    buffer.append("final ");
                }
                buffer.append("dao FunctionsDao");
                if (isSerializable || serializables.contains("Functions")) {
                    buffer.append(" serializable 1 ");
                }
                buffer.append(" {");
                for (String function : this.functions.keySet()) {
                    void var10_44;
                    boolean isProcedure;
                    if (!this.daoOnlyTables.isEmpty() && !this.daoOnlyTables.contains(function) || this.daoIgnoreTables.contains(function) || (isProcedure = this.procedures.containsKey(function))) continue;
                    buffer.append("\n    ");
                    String string = (String)this.tableNames.get(function);
                    if (string == null) {
                        String string6 = function;
                    }
                    String string7 = this.tableToCamelCase((String)var10_44);
                    String functionName = this.lowerFirstChar(string7);
                    attributes = (Map)this.functions.get(function);
                    if (this.metaFunctionsResultSet.containsKey(function)) {
                        buffer.append("callQueryFunction ").append(functionName).append(" :java.util.List<:").append(this.tableToCamelCase((String)this.metaFunctionsResultSet.get(function))).append(">");
                    } else if (this.metaFunctionsResult.containsKey(function) && this.dbType == DbResolver.DbType.DB2) {
                        buffer.append("callSelectFunction ").append(functionName).append(" :").append(this.metaType2className((String)this.metaFunctionsResult.get(function)));
                    } else if (this.metaFunctionsResult.containsKey(function)) {
                        buffer.append("callFunction ").append(functionName).append(" :").append(this.metaType2className((String)this.metaFunctionsResult.get(function)));
                    } else {
                        PojoAttribute pojoAttribute = returnAttribute = attributes.containsKey("_result_") ? (PojoAttribute)attributes.get("_result_") : null;
                        if (returnAttribute != null) {
                            buffer.append("callQueryFunction ").append(functionName).append(" :").append(returnAttribute.getClassName());
                        } else {
                            buffer.append("callUpdateFunction ").append(functionName).append(" _void");
                        }
                    }
                    dispName = null;
                    ptype = (PojoType)this.pojosForFunctions.get(function);
                    if (ptype != null) {
                        dispName = ptype.getRef() != null ? ptype.getRef().getName() : ptype.getType().getSimpleName();
                    }
                    buffer.append(" ::: ").append(this.lowerFirstChar(string7)).append(" ::").append(dispName != null ? dispName : string7);
                }
                buffer.append("\n  }\n");
            }
            return buffer.toString();
        }
        catch (RuntimeException ex) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            ex.printStackTrace(printWriter);
            String s = ((Object)writer).toString();
            return s;
        }
    }

    protected void toInits(String pojo, Map<String, String> toInit) {
        for (Map.Entry pentry : ((Map)this.pojos.get(pojo)).entrySet()) {
            if (this.ignoreColumns.containsKey(pojo) && ((Set)this.ignoreColumns.get(pojo)).contains(pentry.getKey())) continue;
            PojoAttribute attribute = (PojoAttribute)pentry.getValue();
            String name = this.columnNames.containsKey(pojo) ? (String)((Map)this.columnNames.get(pojo)).get(pentry.getKey()) : null;
            name = name == null ? attribute.getName() : this.columnToCamelCase(name);
            if (!attribute.toInit() || attribute.getRef() == null || !this.pojoInheritanceDiscriminator.containsKey(attribute.getRef()) && !this.pojoInheritanceSimple.containsKey(attribute.getRef())) continue;
            toInit.put(name, attribute.getRef());
        }
        if (this.pojoExtends.containsKey(pojo)) {
            this.toInits((String)this.pojoExtends.get(pojo), toInit);
        }
    }
}

