/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.dsl.ui.syntaxcoloring;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.nodemodel.util.NodeTreeIterator;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.sqlproc.dsl.processorDsl.Constant;
import org.sqlproc.dsl.processorDsl.DatabaseColumn;
import org.sqlproc.dsl.processorDsl.DatabaseTable;
import org.sqlproc.dsl.processorDsl.Entity;
import org.sqlproc.dsl.processorDsl.EnumEntity;
import org.sqlproc.dsl.processorDsl.EnumProperty;
import org.sqlproc.dsl.processorDsl.ExtendedColumn;
import org.sqlproc.dsl.processorDsl.ExtendedMappingItem;
import org.sqlproc.dsl.processorDsl.FunctionDefinition;
import org.sqlproc.dsl.processorDsl.Identifier;
import org.sqlproc.dsl.processorDsl.MappingItem;
import org.sqlproc.dsl.processorDsl.MappingRule;
import org.sqlproc.dsl.processorDsl.MetaStatement;
import org.sqlproc.dsl.processorDsl.OptionalFeature;
import org.sqlproc.dsl.processorDsl.PackageDeclaration;
import org.sqlproc.dsl.processorDsl.PojoDao;
import org.sqlproc.dsl.processorDsl.PojoDefinition;
import org.sqlproc.dsl.processorDsl.PojoEntity;
import org.sqlproc.dsl.processorDsl.PojoMethod;
import org.sqlproc.dsl.processorDsl.PojoMethodArg;
import org.sqlproc.dsl.processorDsl.PojoProperty;
import org.sqlproc.dsl.processorDsl.ProcedureDefinition;
import org.sqlproc.dsl.processorDsl.TableDefinition;
import org.sqlproc.dsl.resolver.PojoResolver;
import org.sqlproc.dsl.resolver.PojoResolverFactory;

public class SemanticHighlightingCalculator
implements ISemanticHighlightingCalculator {
    public static final String CARET = "^";
    public static final String STRING = "$";
    public static final String LPAREN = "(";
    public static final String RPAREN = ")";
    @Inject
    PojoResolver pojoResolver;
    @Inject
    PojoResolverFactory pojoResolverFactory;

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        if (this.pojoResolverFactory != null && this.pojoResolverFactory.getPojoResolver() == null) {
            this.pojoResolverFactory.setPojoResolver(this.pojoResolver);
        }
        if (resource == null) {
            return;
        }
        TreeIterator iter = EcoreUtil.getAllContents((Resource)resource, (boolean)true);
        while (iter.hasNext()) {
            PojoEntity gref;
            Entity ref;
            PojoProperty property;
            PojoDefinition pojo;
            ICompositeNode node;
            ICompositeNode node2;
            EObject current = (EObject)iter.next();
            if (current instanceof MetaStatement) {
                MetaStatement statement = (MetaStatement)current;
                if (statement.getName() == null) continue;
                node2 = NodeModelUtils.getNode((EObject)current);
                acceptor.addPosition(node2.getOffset(), statement.getName().length(), new String[]{"name"});
                this.provideHighlightingForModifiers((EList<String>)statement.getModifiers(), node2, acceptor);
                continue;
            }
            if (current instanceof MappingRule) {
                MappingRule rule = (MappingRule)current;
                if (rule.getName() == null) continue;
                node2 = NodeModelUtils.getNode((EObject)current);
                acceptor.addPosition(node2.getOffset(), rule.getName().length(), new String[]{"name"});
                this.provideHighlightingForModifiers((EList<String>)rule.getModifiers(), node2, acceptor);
                continue;
            }
            if (current instanceof OptionalFeature) {
                OptionalFeature feature = (OptionalFeature)current;
                if (feature.getName() == null) continue;
                node2 = NodeModelUtils.getNode((EObject)current);
                acceptor.addPosition(node2.getOffset(), feature.getName().length(), new String[]{"name"});
                this.provideHighlightingForModifiers((EList<String>)feature.getModifiers(), node2, acceptor);
                continue;
            }
            if (current instanceof Constant) {
                Constant constant = (Constant)current;
                node2 = NodeModelUtils.getNode((EObject)current);
                this.provideHighlightingForFragment("constant", node2, constant.getName(), (EList<String>)constant.getModifiers(), acceptor);
                continue;
            }
            if (current instanceof Identifier) {
                Identifier identifier = (Identifier)current;
                node2 = NodeModelUtils.getNode((EObject)current);
                this.provideHighlightingForFragment("identifier", node2, identifier.getName(), (EList<String>)identifier.getModifiers(), acceptor);
                continue;
            }
            if (current instanceof ExtendedColumn) {
                ExtendedColumn column = (ExtendedColumn)current;
                node2 = NodeModelUtils.getNode((EObject)current);
                this.provideHighlightingForFragment("column", node2, column.getCol().getName(), (EList<String>)column.getModifiers(), acceptor);
                continue;
            }
            if (current instanceof MappingItem) {
                MappingItem item = (MappingItem)current;
                if (item.getName() == null) continue;
                node2 = NodeModelUtils.getNode((EObject)current);
                acceptor.addPosition(node2.getOffset(), item.getName().length(), new String[]{"column"});
                continue;
            }
            if (current instanceof ExtendedMappingItem) {
                ExtendedMappingItem mappingItem = (ExtendedMappingItem)current;
                node2 = NodeModelUtils.getNode((EObject)current);
                this.provideHighlightingForFragment("column", node2, mappingItem.getAttr().getName(), (EList<String>)mappingItem.getModifiers(), acceptor);
                continue;
            }
            if (current instanceof DatabaseColumn) {
                node = NodeModelUtils.getNode((EObject)current);
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"dbcolumn"});
                continue;
            }
            if (current instanceof DatabaseTable) {
                node = NodeModelUtils.getNode((EObject)current);
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"dbtable"});
                continue;
            }
            if (current instanceof PojoDefinition) {
                node = NodeModelUtils.getNode((EObject)current);
                pojo = (PojoDefinition)current;
                this.provideHighlightingForPojo(null, pojo.getName(), node, acceptor);
                continue;
            }
            if (current instanceof TableDefinition) {
                node = NodeModelUtils.getNode((EObject)current);
                TableDefinition table = (TableDefinition)current;
                this.provideHighlightingForTable(null, table.getName(), node, acceptor);
                continue;
            }
            if (current instanceof ProcedureDefinition) {
                node = NodeModelUtils.getNode((EObject)current);
                ProcedureDefinition procedure = (ProcedureDefinition)current;
                this.provideHighlightingForTable(null, procedure.getName(), node, acceptor);
                continue;
            }
            if (current instanceof FunctionDefinition) {
                node = NodeModelUtils.getNode((EObject)current);
                FunctionDefinition function = (FunctionDefinition)current;
                this.provideHighlightingForTable(null, function.getName(), node, acceptor);
                continue;
            }
            if (current instanceof PackageDeclaration) {
                node = NodeModelUtils.getNode((EObject)current);
                PackageDeclaration pkg = (PackageDeclaration)current;
                this.provideHighlightingForPojoPackage(pkg.getName(), node, acceptor);
                continue;
            }
            if (current instanceof PojoEntity) {
                node = NodeModelUtils.getNode((EObject)current);
                pojo = (PojoEntity)current;
                this.provideHighlightingForPojoEntity(pojo.getName(), node, acceptor);
                continue;
            }
            if (current instanceof PojoProperty) {
                node = NodeModelUtils.getNode((EObject)current);
                property = (PojoProperty)current;
                this.provideHighlightingForPojoProperty(property.getName(), node, acceptor);
                ref = property.getRef();
                if (ref != null) {
                    if (ref instanceof PojoEntity) {
                        this.provideHighlightingForPojoEntity(ref.getName(), node, acceptor);
                    } else if (ref instanceof EnumEntity) {
                        this.provideHighlightingForEnumEntity(ref.getName(), node, acceptor);
                    }
                }
                if ((gref = property.getGref()) == null) continue;
                this.provideHighlightingForPojoEntity(gref.getName(), node, acceptor);
                continue;
            }
            if (current instanceof EnumProperty) {
                node = NodeModelUtils.getNode((EObject)current);
                property = (EnumProperty)current;
                this.provideHighlightingForEnumProperty(property.getName(), node, acceptor);
                continue;
            }
            if (current instanceof PojoDao) {
                node = NodeModelUtils.getNode((EObject)current);
                PojoDao dao = (PojoDao)current;
                this.provideHighlightingForPojoDao(dao.getName(), node, acceptor);
                ref = dao.getPojo();
                if (ref == null) continue;
                this.provideHighlightingForPojoEntity(ref.getName(), node, acceptor);
                continue;
            }
            if (!(current instanceof PojoMethod)) continue;
            node = NodeModelUtils.getNode((EObject)current);
            PojoMethod method = (PojoMethod)current;
            this.provideHighlightingForPojoProperty(method.getName(), node, acceptor);
            if (method.getType() != null) {
                ref = method.getType().getRef();
                if (ref != null) {
                    this.provideHighlightingForPojoEntity(ref.getName(), node, acceptor);
                }
                if ((gref = method.getType().getGref()) != null) {
                    this.provideHighlightingForPojoEntity(gref.getName(), node, acceptor);
                }
            }
            if (method.getArgs() == null || method.getArgs().isEmpty()) continue;
            for (PojoMethodArg arg : method.getArgs()) {
                PojoEntity gref2;
                if (arg.getType() == null) continue;
                PojoEntity ref2 = arg.getType().getRef();
                if (ref2 != null) {
                    this.provideHighlightingForPojoEntity(ref2.getName(), node, acceptor);
                }
                if ((gref2 = arg.getType().getGref()) == null) continue;
                this.provideHighlightingForPojoEntity(gref2.getName(), node, acceptor);
            }
        }
    }

    private void provideHighlightingForModifiers(EList<String> filters, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (filters != null && !filters.isEmpty()) {
            NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
            while (iterator.hasNext()) {
                INode inode = (INode)iterator.next();
                if (!filters.contains((Object)inode.getText())) continue;
                acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"statementModifier"});
            }
        }
    }

    private void provideHighlightingForPojo(String name, String pojo, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (name == null && pojo == null) {
            return;
        }
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (name != null && name.contains(inode.getText())) {
                acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"name"});
                if (pojo == null) {
                    return;
                }
            }
            if (pojo == null || !pojo.contains(inode.getText())) continue;
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"identifier"});
            return;
        }
    }

    private void provideHighlightingForPojoPackage(String pojo, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (pojo == null) {
            return;
        }
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (pojo == null || !pojo.contains(inode.getText())) continue;
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"packageName"});
            return;
        }
    }

    private void provideHighlightingForPojoEntity(String pojo, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (pojo == null) {
            return;
        }
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (pojo == null || !pojo.contains(inode.getText())) continue;
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"entityName"});
            return;
        }
    }

    private void provideHighlightingForPojoProperty(String pojo, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (pojo == null) {
            return;
        }
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (pojo == null || !pojo.contains(inode.getText())) continue;
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"propertyName"});
            return;
        }
    }

    private void provideHighlightingForEnumEntity(String pojo, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (pojo == null) {
            return;
        }
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (pojo == null || !pojo.contains(inode.getText())) continue;
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"entityName"});
            return;
        }
    }

    private void provideHighlightingForEnumProperty(String pojo, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (pojo == null) {
            return;
        }
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (pojo == null || !pojo.contains(inode.getText())) continue;
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"propertyName"});
            return;
        }
    }

    private void provideHighlightingForPojoDao(String dao, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (dao == null) {
            return;
        }
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (dao == null || !dao.contains(inode.getText())) continue;
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"daoName"});
            return;
        }
    }

    private void provideHighlightingForTable(String name, String table, ICompositeNode node, IHighlightedPositionAcceptor acceptor) {
        if (name == null && table == null) {
            return;
        }
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (name != null && name.contains(inode.getText())) {
                acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"name"});
                if (table == null) {
                    return;
                }
            }
            if (table == null || !table.contains(inode.getText())) continue;
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"identifier"});
            return;
        }
    }

    private void provideHighlightingForFragment(String defaultColor, ICompositeNode node, String name, EList<String> modifiers, IHighlightedPositionAcceptor acceptor) {
        NodeTreeIterator iterator = new NodeTreeIterator((INode)node);
        boolean afterName = false;
        boolean inParenthesis = false;
        while (iterator.hasNext()) {
            INode inode = (INode)iterator.next();
            if (!afterName) {
                if (!name.equals(inode.getText())) continue;
                acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{defaultColor});
                afterName = true;
                continue;
            }
            if (!inParenthesis && inode.getText().equals(LPAREN)) {
                inParenthesis = true;
                continue;
            }
            if (inParenthesis && inode.getText().equals(RPAREN)) {
                inParenthesis = false;
                continue;
            }
            if (inParenthesis) {
                if (modifiers == null || modifiers.isEmpty() || !modifiers.contains((Object)inode.getText())) continue;
                acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{"modifier"});
                continue;
            }
            acceptor.addPosition(inode.getOffset(), inode.getLength(), new String[]{defaultColor});
        }
    }
}

